<?php
/***************************************************************************
 *							admin_board.php
 *							-------------------
 * begin					: Thursday, Jul 12, 2001
 * copyright			: (C) 2001 The phpBB Group
 * email					: support@phpbb.com
 *
 * modification 		: (C) 2005 Przemo http://www.przemo.org
 * date modification	: ver. 1.9 2005/04/03 19:20
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if ( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['AAGeneral']['Configuration'] = "$file?mode=config";
	$module['ACUsers']['Warnings'] = "$file?mode=warnings";
	return;
}

// Let's set the root dir for phpBB
$phpbb_root_path = './../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx);

$checked = 'checked="checked"';

// Pull all config data
$mode = ( isset($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : $HTTP_POST_VARS['mode'];

$sql = "SELECT fontface1 FROM " . THEMES_TABLE . "";
if (!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, 'Could not query themes information in admin_board', '', __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$theme_fontface = $row['fontface1'];
	}
}

$sql = "SELECT *
	FROM " . CONFIG_TABLE ."
	WHERE config_name NOT IN ('ban_warnings', 'write_warnings', 'warnings_mods_public', 'warnings_enable', 'mod_warnings', 'mod_edit_warnings', 'expire_warnings', 'mod_value_warning')";
if (!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, 'Could not query config information in admin_board', '', __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$config_name = $row['config_name'];
		$config_value = $row['config_value'];

		$default_config[$config_name] = $config_value;

		$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

		if ( $config_name == 'cookie_name' )
		{
			$cookie_name = str_replace('.', '_', $new['cookie_name']);
		}

		if ( isset($HTTP_POST_VARS['submit']) && $mode != sql )
		{
			$new[$config_name] = (isset($HTTP_POST_VARS[$config_name])) ? $HTTP_POST_VARS[$config_name] : str_replace(array("'", "\\"), array("''", "\\\\"), $default_config[$config_name]);

			if ((eregi("http:/", $new[$config_name]) && $config_name == 'server_name') || eregi("http:/", $new[$config_name]) && $config_name == 'cookie_domain')
			{
				message_die(GENERAL_MESSAGE, $lang['wrong_config_parametr']);
			}

			$sql_config_value = (isset($HTTP_POST_VARS[$config_name])) ? str_replace("\'", "''", $new[$config_name]) : $new[$config_name];

			$sql = "UPDATE " . CONFIG_TABLE . " SET
				config_value = '$sql_config_value'
				WHERE config_name = '$config_name'";

			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Failed to update general configuration for ' . $config_name, '', __LINE__, __FILE__, $sql);
			}
		}
		$new[$config_name] = htmlspecialchars($new[$config_name]);
	}

	if ( isset($HTTP_POST_VARS['submit']) && $mode != 'sql' )
	{
		$mode = $HTTP_POST_VARS['mode'];
		$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_board.$phpEx?mode=$mode") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
		message_die(GENERAL_MESSAGE, $message);
	}
}


if ( $mode == 'sql' )
{
	$font = (isset($HTTP_POST_VARS['font'])) ? $HTTP_POST_VARS['font'] : $theme_fontface;
	$sql = "UPDATE " . THEMES_TABLE . "
		SET fontface1 = '" . str_replace("\'", "''", $font) . "'";
	if (!$result = $db->sql_query($sql))
	{
		message_die(CRITICAL_ERROR, 'Could not update themes table', '', __LINE__, __FILE__, $sql);
	}
	else
	{
		$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_board.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
		message_die(GENERAL_MESSAGE, $message);
	}
}

if ( $mode == 'config' || $mode == '' || $mode == 'sql' )
{
	$template->set_filenames(array(
		'body' => 'admin/board_config_body.tpl')
	);

	$new['site_desc'] = str_replace('"', '&quot;', $new['site_desc']);
	$new['sitename'] = str_replace('"', '&quot;', strip_tags($new['sitename']));
	$check_address_yes = ($new['check_address']) ? $checked : '';
	$check_address_no = (!$new['check_address']) ? $checked : '';
	$desc_color = $new['desc_color'];
	$name_color = $new['name_color'];
	$activation_none = ($new['require_activation'] == USER_ACTIVATION_NONE ) ? $checked : '';
	$activation_user = ($new['require_activation'] == USER_ACTIVATION_SELF ) ? $checked : '';
	$activation_admin = ($new['require_activation'] == USER_ACTIVATION_ADMIN ) ? $checked : '';
	$confirm_yes = ($new['enable_confirm']) ? 'checked="checked"' : '';
	$confirm_no = (!$new['enable_confirm']) ? 'checked="checked"' : '';
	$style_select = style_select($new['default_style'], 'default_style', '../templates');
	$lang_select = language_select($new['default_lang'], 'default_lang', '../language');
	$override_user_style_yes = ($new['override_user_style']) ? $checked : '';
	$override_user_style_no = (!$new['override_user_style']) ? $checked : '';
	$timezone_select = tz_select($new['board_timezone'], 'board_timezone');
	$auto_date_yes = ($new['auto_date']) ? $checked : '';
	$auto_date_no = (!$new['auto_date']) ? $checked : '';
	$gzip_yes = ($new['gzip_compress']) ? $checked : '';
	$gzip_no = (!$new['gzip_compress']) ? $checked : '';
	$font_check1 = ( $theme_fontface == 'Verdana, Arial, Helvetica, sans-serif' ) ? $checked : '';
	$font_check4 = ( $theme_fontface == 'Tahoma, Verdana, Arial, Helvetica, sans-serif' ) ? $checked : '';
	$font_check5 = ( $theme_fontface == 'Comic Sans MS, Verdana, Arial, Helvetica' ) ? $checked : '';
	$cookie_secure_yes = ($new['cookie_secure']) ? $checked : '';
	$cookie_secure_no = (!$new['cookie_secure']) ? $checked : '';
	$privmsg_on = (!$new['privmsg_disable']) ? $checked : '';
	$privmsg_off = ($new['privmsg_disable']) ? $checked : '';
	$board_email_form_yes = ($new['board_email_form']) ? $checked : '';
	$board_email_form_no = (!$new['board_email_form']) ? $checked : '';
	$smtp_yes = ($new['smtp_delivery']) ? $checked : '';
	$smtp_no = (!$new['smtp_delivery']) ? $checked : '';

	$template->assign_vars(array(
		'S_CONFIG_ACTION' => append_sid("admin_board.$phpEx"),
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_ENABLED' => $lang['Enabled'],
		'L_DISABLED' => $lang['Disabled'],
		'L_CONFIGURATION_TITLE' => $lang['General_Config'],
		'L_CONFIGURATION_EXPLAIN' => $lang['Config_explain'],
		'L_GENERAL_SETTINGS' => $lang['General_settings'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_CONFIG_CONF' => $lang['conf_conf'],
		'L_CONFIG' => $lang['conf_config'],
		'L_ADDONS' => $lang['conf_addons'],
		'L_MAIN_PAGE' => $lang['conf_main_page'],
		'L_ADDON_MAIN_PAGE' => $lang['l_addon_main_page'],
		'L_ADDON_MAIN' => $lang['l_addon_main'],
		'L_VIEWTOPIC' => $lang['conf_viewtopic'],
		'L_PROFILE' => $lang['conf_profile'],
		'L_ADDON_PROFILE' => $lang['l_addon_profile'],
		'L_POSTING' => $lang['conf_posting'],
		'L_ADDON_POSTING' => $lang['l_addon_posting'],
		'L_ADDON_VIEWTOPIC' => $lang['l_addon_viewtopic'],
		'L_SERVER_NAME' => $lang['Server_name'],
		'L_SERVER_PORT' => $lang['Server_port'],
		'L_SERVER_PORT_EXPLAIN' => $lang['Server_port_explain'],
		'L_CHECK_ADDRESS' => $lang['check_address'],
		'L_CHECK_ADDRESS_E' => $lang['check_address_e'],
		'L_SCRIPT_PATH' => $lang['Script_path'],
		'L_SCRIPT_PATH_EXPLAIN' => $lang['Script_path_explain'],
		'L_SITE_NAME' => $lang['Site_name'],
		'L_COLOR' => $lang['Font_color'],
		'L_SITE_DESCRIPTION' => $lang['Site_desc'],
		'L_DISABLE_BOARD' => $lang['Board_disable'],
		'L_DISABLE_BOARD_EXPLAIN' => $lang['Board_disable_explain'],
		'L_NONE' => $lang['None'],
		'L_USER' => $lang['Username'],
		'L_ADMIN' => $lang['Acc_Admin'],
		'L_ACCT_ACTIVATION' => $lang['Acct_activation'],
		'L_FLOOD_INTERVAL' => $lang['Flood_Interval'],
		'L_FLOOD_INTERVAL_EXPLAIN' => $lang['Flood_Interval_explain'],
		'L_TOPICS_PER_PAGE' => $lang['Topics_per_page'],
		'L_POSTS_PER_PAGE' => $lang['Posts_per_page'],
		'L_HOT_THRESHOLD' => $lang['Hot_threshold'],
		'L_DEFAULT_STYLE' => $lang['Default_style'],
		'L_OVERRIDE_STYLE' => $lang['Override_style'],
		'L_OVERRIDE_STYLE_EXPLAIN' => $lang['Override_style_explain'],
		'L_DEFAULT_LANGUAGE' => $lang['Default_language'],
		'L_DATE_FORMAT' => $lang['Date_format'],
		'L_DATE_FORMAT_EXPLAIN' => $lang['Date_format_explain'],
		'L_SYSTEM_TIMEZONE' => $lang['System_timezone'],
		'L_AUTO_DATE' => $lang['auto_date'],
		'L_AUTO_DATE_E' => $lang['auto_date_e'],
		'L_ENABLE_GZIP' => $lang['Enable_gzip'],
		'L_COOKIE_SETTINGS' => $lang['Cookie_settings'],
		'L_COOKIE_SETTINGS_EXPLAIN' => $lang['Cookie_settings_explain'],
		'L_COOKIE_DOMAIN' => $lang['Cookie_domain'],
		'L_COOKIE_NAME' => $lang['Cookie_name'],
		'L_COOKIE_PATH' => $lang['Cookie_path'],
		'L_COOKIE_SECURE' => $lang['Cookie_secure'],
		'L_COOKIE_SECURE_EXPLAIN' => $lang['Cookie_secure_explain'],
		'L_SESSION_LENGTH' => $lang['Session_length'],
		'L_PRIVATE_MESSAGING' => $lang['Private_Messaging'],
		'L_DISABLE_PRIVATE_MESSAGING' => $lang['Disable_privmsg'],
		'L_INBOX_LIMIT' => $lang['Inbox_limits'],
		'L_SENTBOX_LIMIT' => $lang['Sentbox_limits'],
		'L_SAVEBOX_LIMIT' => $lang['Savebox_limits'],
		'L_COPPA_SETTINGS' => $lang['COPPA_settings'],
		'L_COPPA_FAX' => $lang['COPPA_fax'],
		'L_COPPA_MAIL' => $lang['COPPA_mail'],
		'L_COPPA_MAIL_EXPLAIN' => $lang['COPPA_mail_explain'],
		'L_EMAIL_SETTINGS' => $lang['Email_settings'],
		'L_BOARD_EMAIL_FORM' => $lang['Board_email_form'],
		'L_BOARD_EMAIL_FORM_EXPLAIN' => $lang['Board_email_form_explain'],
		'L_ADMIN_EMAIL' => $lang['Admin_email'],
		'L_EMAIL_RETURN_PATH' => $lang['email_return_path'],
		'L_EMAIL_FROM' => $lang['email_from'],
		'L_EMAIL_SIG' => $lang['Email_sig'],
		'L_EMAIL_SIG_EXPLAIN' => $lang['Email_sig_explain'],
		'L_USE_SMTP' => $lang['Use_SMTP'],
		'L_USE_SMTP_EXPLAIN' => $lang['Use_SMTP_explain'],
		'L_SMTP_SERVER' => $lang['SMTP_server'],
		'L_SMTP_USERNAME' => $lang['SMTP_username'],
		'L_SMTP_USERNAME_EXPLAIN' => $lang['SMTP_username_explain'],
		'L_SMTP_PASSWORD' => $lang['SMTP_password'],
		'L_SMTP_PASSWORD_EXPLAIN' => $lang['SMTP_password_explain'],

		'FACE_FONT' => $lang['face_font'],
		'LARGE_FONT' => $lang['face_large_font'],
		'SMALL_FONT' => $lang['face_small_font'],
		'SERVER_PORT' => $new['server_port'],
		'SCRIPT_PATH' => $new['script_path'],
		'SERVER_NAME' => $new['server_name'],
		'CHECK_ADDRESS_YES' => $check_address_yes,
		'CHECK_ADDRESS_NO' => $check_address_no,
		'SITENAME' => $new['sitename'],
		'SITE_DESCRIPTION' => $new['site_desc'],
		'DESC_COLOR' => color_select(desc_color, $desc_color, $lang_default = $lang['color_default']),
		'NAME_COLOR' => color_select(name_color, $name_color, $lang_default = $lang['color_default']),
		'FLOOD_INTERVAL' => $new['flood_interval'],
		'TOPICS_PER_PAGE' => $new['topics_per_page'],
		'POSTS_PER_PAGE' => $new['posts_per_page'],
		'HOT_TOPIC' => $new['hot_threshold'],
		'ACTIVATION_NONE' => USER_ACTIVATION_NONE,
		'ACTIVATION_NONE_CHECKED' => $activation_none,
		'ACTIVATION_USER' => USER_ACTIVATION_SELF,
		'ACTIVATION_USER_CHECKED' => $activation_user,
		'ACTIVATION_ADMIN' => USER_ACTIVATION_ADMIN,
		'ACTIVATION_ADMIN_CHECKED' => $activation_admin,
		'STYLE_SELECT' => $style_select,
		'OVERRIDE_STYLE_YES' => $override_user_style_yes,
		'OVERRIDE_STYLE_NO' => $override_user_style_no,
		'LANG_SELECT' => $lang_select,
		'DEFAULT_DATEFORMAT' => admin_date_format_select($new['default_dateformat'], $timezone_select),
		'TIMEZONE_SELECT' => $timezone_select,
		'AUTO_DATE_YES' => $auto_date_yes,
		'AUTO_DATE_NO' => $auto_date_no,
		'GZIP_YES' => $gzip_yes,
		'GZIP_NO' => $gzip_no,
		'FONT_CHECK1' => $font_check1,
		'FONT_CHECK4' => $font_check4,
		'FONT_CHECK5' => $font_check5,
		'BOARD_DISABLE' => $new['board_disable'],
		'COOKIE_DOMAIN' => $new['cookie_domain'],
		'COOKIE_NAME' => $new['cookie_name'],
		'COOKIE_PATH' => $new['cookie_path'],
		'SESSION_LENGTH' => $new['session_length'],
		'S_COOKIE_SECURE_ENABLED' => $cookie_secure_yes,
		'S_COOKIE_SECURE_DISABLED' => $cookie_secure_no,
		'S_PRIVMSG_ENABLED' => $privmsg_on,
		'S_PRIVMSG_DISABLED' => $privmsg_off,
		'INBOX_LIMIT' => $new['max_inbox_privmsgs'],
		'SENTBOX_LIMIT' => $new['max_sentbox_privmsgs'],
		'SAVEBOX_LIMIT' => $new['max_savebox_privmsgs'],
		'COPPA_MAIL' => $new['coppa_mail'],
		'COPPA_FAX' => $new['coppa_fax'],
		'BOARD_EMAIL_FORM_ENABLE' => $board_email_form_yes,
		'BOARD_EMAIL_FORM_DISABLE' => $board_email_form_no,
		'BOARD_EMAIL' => $new['board_email'],
		'EMAIL_SIG' => $new['board_email_sig'],
		'EMAIL_RETURN_PATH' => $new['email_return_path'],
		'EMAIL_FROM' => $new['email_from'],
		'SMTP_YES' => $smtp_yes,
		'SMTP_NO' => $smtp_no,
		'SMTP_HOST' => $new['smtp_host'],
		'SMTP_USERNAME' => $new['smtp_username'],
		'SMTP_PASSWORD' => $new['smtp_password'],

		'S_HIDDEN_FIELDS' => '<input type="hidden" name="mode" value="config">')
	);
}

if ( $mode == 'addons' )
{
	$template->set_filenames(array(
		'body' => 'admin/board_config_body_addons.tpl')
	);
	$read_tracking_yes = ($new['read_tracking']) ? $checked : '';
	$read_tracking_no = (!$new['read_tracking']) ? $checked : '';
	$read_trcking_clear = '<a href="' . append_sid("admin_board.$phpEx?mode=clear") . '">' . $lang['Reset'] . '</a>';
	$read_trcking_repair = '<a href="' . append_sid("admin_board.$phpEx?mode=repair") . '">' . $lang['Repair'] . '</a>';
	$crestrict_yes = ($new['crestrict']) ? $checked : '';
	$crestrict_no = (!$new['crestrict']) ? $checked : '';
	$helped_yes = ($new['helped']) ? $checked : '';
	$helped_no = (!$new['helped']) ? $checked : '';
	$helped_forums = $new['helped_forums'];
	$login_require_yes = ($new['login_require']) ? $checked : '';
	$login_require_no = (!$new['login_require']) ? $checked : '';
	$namechange_yes = ($new['allow_namechange']) ? $checked : '';
	$namechange_no = (!$new['allow_namechange']) ? $checked : '';
	$custom_color_use_yes = ($new['custom_color_use']) ? $checked : '';
	$custom_color_use_no = (!$new['custom_color_use']) ? $checked : '';
	$custom_color_view_yes = ($new['custom_color_view']) ? $checked : '';
	$custom_color_view_no = (!$new['custom_color_view']) ? $checked : '';
	$custom_color_mod_yes = ($new['custom_color_mod']) ? $checked : '';
	$custom_color_mod_no = (!$new['custom_color_mod']) ? $checked : '';
	$mod_nick_color = $new['mod_nick_color'];
	$custom_rank_mod_yes = ($new['custom_rank_mod']) ? $checked : '';
	$custom_rank_mod_no = (!$new['custom_rank_mod']) ? $checked : '';
	$del_email_not_yes = ($new['del_user_notify']) ? $checked : '';
	$del_email_not_no = (!$new['del_user_notify']) ? $checked : '';
	$birthday_greeting_yes = ($new['birthday_greeting']) ? $checked : '';
	$birthday_greeting_no = (!$new['birthday_greeting']) ? $checked : '';
	$clog_post = ($new['clog'] == 2) ? $checked : '';
	$clog_yes = ($new['clog'] == 1) ? $checked : '';
	$clog_no = (!$new['clog']) ? $checked : '';
	$google_yes = ($new['google']) ? $checked : '';
	$google_no = (!$new['google']) ? $checked : '';
	$cload_yes = ($new['cload']) ? $checked : '';
	$cload_no = (!$new['cload']) ? $checked : '';
	$not_edit_admin_yes = ($new['not_edit_admin']) ? $checked : '';
	$not_edit_admin_no = (!$new['not_edit_admin']) ? $checked : '';
	$show_badwords_yes = ($new['show_badwords']) ? $checked : '';
	$show_badwords_no = (!$new['show_badwords']) ? $checked : '';
	$ipview_yes = ($new['ipview']) ? $checked : '';
	$ipview_no = (!$new['ipview']) ? $checked : '';
	$show_rules_yes = ($new['show_rules']) ? $checked : '';
	$show_rules_no = (!$new['show_rules']) ? $checked : '';
	$generate_time_yes = ($new['generate_time']) ? $checked : '';
	$generate_time_no = (!$new['generate_time']) ? $checked : '';
	$generate_time_admin_yes = ($new['generate_time_admin']) ? $checked : '';
	$generate_time_admin_no = (!$new['generate_time_admin']) ? $checked : '';
	$redirect_after_registering_yes = ($new['redirect_after_registering']) ? $checked : '';
	$redirect_after_registering_no = (!$new['redirect_after_registering']) ? $checked : '';
	$redirect_address = $new['redirect_address'];
	$r_a_r_time = $new['r_a_r_time'];
	$password_complex_yes = ($new['force_complex_password']) ? $checked : '';
	$password_complex_no = (!$new['force_complex_password']) ? $checked : '';
	$password_not_login_yes = ($new['password_not_login']) ? $checked : '';
	$password_not_login_no = (!$new['password_not_login']) ? $checked : '';
	$search_enable_yes = ($new['search_enable']) ? $checked : '';
	$search_enable_no = (!$new['search_enable']) ? $checked : '';
	$overlib_yes = ($new['overlib']) ? $checked : '';
	$overlib_no = (!$new['overlib']) ? $checked : '';
	$notify_gg_yes = ($new['notify_gg']) ? $checked : '';
	$notify_gg_no = (!$new['notify_gg']) ? $checked : '';
	$admin_notify_reply_yes = ($new['admin_notify_reply']) ? $checked : '';
	$admin_notify_reply_no = (!$new['admin_notify_reply']) ? $checked : '';
	$admin_notify_message_yes = ($new['admin_notify_message']) ? $checked : '';
	$admin_notify_message_no = (!$new['admin_notify_message']) ? $checked : '';
	$all_time_ban_check_yes = ($new['all_time_ban_check']) ? $checked : '';
	$all_time_ban_check_no = (!$new['all_time_ban_check']) ? $checked : '';
	$autorepair_tables_yes = ($new['autorepair_tables']) ? $checked : '';
	$autorepair_tables_no = (!$new['autorepair_tables']) ? $checked : '';
	$lastvisit_days = $new['lastvisit_days'];
	$del_notify_method_yes = ($new['del_notify_method']) ? $checked : '';
	$del_notify_method_no = (!$new['del_notify_method']) ? $checked : '';
	$del_notify_enable_yes = ($new['del_notify_enable']) ? $checked : '';
	$del_notify_enable_no = (!$new['del_notify_enable']) ? $checked : '';
	$del_notify_choice_yes = ($new['del_notify_choice']) ? $checked : '';
	$del_notify_choice_no = (!$new['del_notify_choice']) ? $checked : '';
	$open_in_windows_yes = ($new['open_in_windows']) ? $checked : '';
	$open_in_windows_no = (!$new['open_in_windows']) ? $checked : '';

	$template->assign_vars(array(
		'S_CONFIG_ACTION' => append_sid("admin_board.$phpEx"),
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_ENABLED' => $lang['Enabled'],
		'L_DISABLED' => $lang['Disabled'],
		'L_CONFIGURATION_TITLE' => $lang['General_Config'],
		'L_CONFIGURATION_EXPLAIN' => $lang['Config_explain'],
		'L_GENERAL_SETTINGS' => $lang['General_settings'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_CONFIG_CONF' => $lang['conf_conf'],
		'L_CONFIG' => $lang['conf_config'],
		'L_ADDONS' => $lang['conf_addons'],
		'L_MAIN_PAGE' => $lang['conf_main_page'],
		'L_ADDON_MAIN_PAGE' => $lang['l_addon_main_page'],
		'L_ADDON_MAIN' => $lang['l_addon_main'],
		'L_VIEWTOPIC' => $lang['conf_viewtopic'],
		'L_PROFILE' => $lang['conf_profile'],
		'L_ADDON_PROFILE' => $lang['l_addon_profile'],
		'L_POSTING' => $lang['conf_posting'],
		'L_ADDON_POSTING' => $lang['l_addon_posting'],
		'L_ADDON_VIEWTOPIC' => $lang['l_addon_viewtopic'],
		'L_READ_TRACKING' => $lang['read_tracking'],
		'L_READ_TRACKING_E' => $lang['read_tracking_e'],
		'L_DAY_TO_PRUNE' => $lang['day_to_prune'],
		'L_DAY_TO_PRUNE_E' => $lang['day_to_prune_e'],
		'L_READ_TRACKING_C' => $lang['read_tracking_c'],
		'L_READ_TRACKING_C_E' => $lang['read_tracking_c_e'],
		'L_READ_TRACKING_R' => $lang['read_tracking_r'],
		'L_READ_TRACKING_R_E' => $lang['read_tracking_r_e'],
		'L_MAX_POLL_OPTIONS' => $lang['Max_poll_options'],
		'L_CRESTRICT' => $lang['crestrict'],
		'L_CRESTRICT_E' => $lang['crestrict_e'],
		'L_HELPED' => $lang['helped_a'],
		'L_HELPED_E' => $lang['helped_e'],
		'L_HELPED_FORUMS' => $lang['helped_forums'],
		'L_LOGIN_REQUIRE' => $lang['login_require'],
		'L_LOGIN_REQUIRE_E' => $lang['login_require_e'],
		'L_ALLOW_NAME_CHANGE' => $lang['Allow_name_change'],
		'L_ALLOW_CUSTOM_COLOR' => $lang['Allow_custom_color'],
		'L_ALLOW_CUSTOM_COLOR_EXPLAIN' => $lang['Allow_custom_color_explain'],
		'L_ALLOW_CUSTOM_COLOR_VIEW' => $lang['l_allow_custom_color_view'],
		'L_ALLOW_CUSTOM_COLOR_VIEW_E' => $lang['l_allow_custom_color_view_e'],
		'L_ALLOW_CUSTOM_COLOR_MOD' => $lang['Allow_custom_color_mod'],
		'L_ALLOW_CUSTOM_COLOR_MOD_E' => $lang['Allow_custom_color_mod_e'],
		'L_MOD_NICK_COLOR' => $lang['mod_nick_color'],
		'L_MOD_NICK_COLOR_E' => $lang['mod_nick_color_e'],
		'L_ALLOW_CUSTOM_RANK_MOD' => $lang['Allow_custom_rank_mod'],
		'L_ALLOW_CUSTOM_RANK_MOD_E' => $lang['Allow_custom_rank_mod_e'],
		'L_ALLOW_CUSTOM_RANK' => $lang['Allow_custom_rank'],
		'L_ALLOW_CUSTOM_RANK_EXPLAIN' => $lang['Allow_custom_rank_explain'],
		'L_MAX_SIG_CUSTOM_RANK' => $lang['max_sig_custom_rank'],
		'L_DEL_EMAIL_NOT' => $lang['del_email_not'],
		'L_DEL_EMAIL_NOT_E' => $lang['del_email_not_e'],
		'L_EDIT_TIME' => $lang['edit_time'],
		'L_EDIT_TIME_EXPLAIN' => $lang['edit_time_explain'],
		'L_ENABLE_BIRTHDAY_GREETING' => $lang['Enable_birthday_greeting'],
		'L_BIRTHDAY_GREETING_EXPLAIN' => $lang['Birthday_greeting_expain'],
		'L_MAX_USER_AGE' => $lang['Max_user_age'],
		'L_MIN_USER_AGE' => $lang['Min_user_age'],
		'L_BIRTHDAY_LOOKFORWARD' => $lang['Birthday_lookforward'],
		'L_META_REFRESH' => $lang['l_meta_refresh'],
		'L_META_REFRESH_E' => $lang['l_meta_refresh_e'],
		'L_META_KEYWORDS' => $lang['Meta_keywords'],
		'L_META_KEYWORDS_EXPLAIN' => $lang['Meta_keywords_explain'],
		'L_META_DESCRIPTION' => $lang['Meta_description'],
		'L_META_DESCRIPTION_EXPLAIN' => $lang['Meta_description_explain'],
		'L_SQL' => $lang['l_sql'],
		'L_SQL_E' => $lang['l_sql_e'],
		'L_ADDRESS_WHOIS' => $lang['l_address_whois'],
		'L_ADDRESS_WHOIS_E' => $lang['l_address_whois_e'],
		'L_CLOG' => $lang['clog'],
		'L_LOG_POST' => $lang['clog_post'],
		'L_CLOG_E' => $lang['clog_e'],
		'L_GOOGLE' => $lang['l_google'],
		'L_GOOGLE_E' => $lang['l_google_e'],
		'L_CLOAD' => $lang['cload'],
		'L_LLOAD' => $lang['lload'],
		'L_NOT_EDIT_ADMIN' => $lang['not_edit_admin'],
		'L_NOT_EDIT_ADMIN_E' => $lang['not_edit_admin_e'],
		'L_SHOW_BADWORDS' => $lang['show_badwords'],
		'L_IPVIEW' => $lang['ipview'],
		'L_GENERATE_TIME' => $lang['l_generate_time'],
		'L_GENTIME_ADMIN' => $lang['gentime_admin'],
		'L_SHOW_RULES' => $lang['show_rules'],
		'L_SHOW_RULES_E' => $lang['show_rules_e'],
		'L_RED_AFT_REG' => $lang['red_aft_reg'],
		'L_RED_AFT_REG_E' => $lang['red_aft_reg_e'],
		'L_RED_AFT_ADDRESS' => $lang['red_aft_address'],
		'L_RED_AFT_ADDRESS_E' => $lang['red_aft_address_e'],
		'L_RAR_TIME' => $lang['rar_time'],
		'L_RAR_TIME_E' => $lang['rar_time_e'],
		'L_USER_PASSWORD_SETTINGS' => $lang['user_password_settings'],
		'L_MAX_LOGIN_ERROR' => $lang['Max_login_error'],
		'L_MAX_LOGIN_ERROR_EXPLAIN' => $lang['Max_login_error_explain'],
		'L_BLOCK_TIME' => $lang['Block_time'],
		'L_BLOCK_TIME_EXPLAIN' => $lang['Block_time_explain'],
		'L_PASSWORD_COMPLEX' => $lang['Password_complex'],
		'L_PASSWORD_COMPLEX_EXPLAIN' => $lang['Password_complex_explain'],
		'L_PASSWORD_NOT_LOGIN' => $lang['Password_not_login'],
		'L_PASSWORD_NOT_LOGIN_EXPLAIN' => $lang['Password_not_login_explain'],
		'L_PASSWORD_LEN' => $lang['Password_len'],
		'L_PASSWORD_LEN_EXPLAIN' => $lang['Password_len_explain'],
		'L_MAX_SIG_CHARS_ADMIN_E' => $lang['max_sig_chars_admin_e'],
		'L_MAX_SIG_CHARS_MOD_E' => $lang['max_sig_chars_mod_e'],
		'L_SEARCH_ENABLE' => $lang['search_enable'],
		'L_SEARCH_ENABLE_E' => $lang['search_enable_e'],
		'L_OVERLIB' => $lang['overlib'],
		'L_GG_NR' => $lang['GG_nr'],
		'L_GG_PASS' => $lang['GG_pass'],
		'L_NOTIFY_GG' => $lang['notify_gg'],
		'L_NOTIFY_GG_E' => $lang['notify_gg_e'],
		'L_ADMIN_NOTIFY_GG' => $lang['admin_notify_gg'],
		'L_ADMIN_NOTIFY_GG_E' => $lang['admin_notify_gg_e'],
		'L_ADMIN_NOTIFY_REPLY' => $lang['admin_notify_reply'],
		'L_ADMIN_NOTIFY_REPLY_E' => $lang['admin_notify_reply_e'],
		'L_ADMIN_NOTIFY_MESSAGE' => $lang['admin_notify_message'],
		'L_ADMIN_NOTIFY_MESSAGE_E' => $lang['admin_notify_message_e'],
		'L_ALL_TIME_BAN_CHECK' => $lang['all_time_ban_check'],
		'L_ALL_TIME_BAN_CHECK_E' => $lang['all_time_ban_check_e'],
		'L_AUTOREPAIR_TABLES' => $lang['autorepair_tables'],
		'L_AUTOREPAIR_TABLES_E' => $lang['autorepair_tables_e'],
		'L_LASTVISIT_DAYS' => $lang['lastvisit_days'],
		'L_LASTVISIT_DAYS_E' => $lang['lastvisit_days_e'],
		'L_DEL_NOT_METHOD' => $lang['l_del_not_method'],
		'L_DEL_NOT_ENABLE' => $lang['l_del_not_enable'],
		'L_DEL_NOT_CHOICE' => $lang['l_del_not_choice'],
		'L_OPEN_IN_WINDOWS' => $lang['l_open_in_windows'],
		'L_OPEN_IN_WINDOWS_E' => $lang['l_open_in_windows_e'],


		'READ_TRACKING_YES' => $read_tracking_yes,
		'READ_TRACKING_NO' => $read_tracking_no,
		'DAY_TO_PRUNE' => $new['day_to_prune'],
		'READ_TRACKING_CLEAR' => $read_trcking_clear,
		'READ_TRACKING_REPAIR' => $read_trcking_repair,
		'MAX_POLL_OPTIONS' => $new['max_poll_options'],
		'CRESTRICT_YES' => $crestrict_yes,
		'CRESTRICT_NO' => $crestrict_no,
		'HELPED_YES' => $helped_yes,
		'HELPED_NO' => $helped_no,
		'HELPED_FORUMS' => $new['helped_forums'],
		'LOGIN_REQUIRE_YES' => $login_require_yes,
		'LOGIN_REQUIRE_NO' => $login_require_no,
		'NAMECHANGE_YES' => $namechange_yes,
		'NAMECHANGE_NO' => $namechange_no,
		'CUSTOM_COLOR_USE_YES' => $custom_color_use_yes,
		'CUSTOM_COLOR_USE_NO' => $custom_color_use_no,
		'CUSTOM_COLOR' => $new['allow_custom_color'],
		'CUSTOM_COLOR_VIEW_YES' => $custom_color_view_yes,
		'CUSTOM_COLOR_VIEW_NO' => $custom_color_view_no,
		'CUSTOM_COLOR_MOD_YES' => $custom_color_mod_yes,
		'CUSTOM_COLOR_MOD_NO' => $custom_color_mod_no,
		'MOD_NICK_COLOR' => color_select(mod_nick_color, $mod_nick_color, $lang_default = $lang['color_default']),
		'CUSTOM_RANK' => $new['allow_custom_rank'],
		'CUSTOM_RANK_MOD_YES' => $custom_rank_mod_yes,
		'CUSTOM_RANK_MOD_NO' => $custom_rank_mod_no,
		'MAX_SIG_CUSTOM_RANK' => $new['max_sig_custom_rank'],
		'DEL_EMAIL_NOT_YES' => $del_email_not_yes,
		'DEL_EMAIL_NOT_NO' => $del_email_not_no,
		'EDIT_TIME' => $new['edit_time'],
		'BIRTHDAY_GREETING_YES' => $birthday_greeting_yes,
		'BIRTHDAY_GREETING_NO' => $birthday_greeting_no,
		'BIRTHDAY_LOOKFORWARD' => $new['birthday_check_day'],
		'MAX_USER_AGE' => $new['max_user_age'],
		'MIN_USER_AGE' => $new['min_user_age'],
		'SREFRESH' => $new['refresh'],
		'META_KEYWORDS' => $new['meta_keywords'],
		'META_DESCRIPTION' => $new['meta_description'],
		'SQL' => $new['sql'],
		'ADDRESS_WHOIS' => $new['address_whois'],
		'CLOG_POST' => $clog_post,
		'CLOG_YES' => $clog_yes,
		'CLOG_NO' => $clog_no,
		'GOOGLE_YES' => $google_yes,
		'GOOGLE_NO' => $google_no,
		'CLOAD_YES' => $cload_yes,
		'CLOAD_NO' => $cload_no,
		'NOT_EDIT_ADMIN_YES' => $not_edit_admin_yes,
		'NOT_EDIT_ADMIN_NO' => $not_edit_admin_no,
		'SHOW_BADWORDS_YES' => $show_badwords_yes,
		'SHOW_BADWORDS_NO' => $show_badwords_no,
		'IPVIEW_YES' => $ipview_yes,
		'IPVIEW_NO' => $ipview_no,
		'GENERATE_TIME_YES' => $generate_time_yes,
		'GENERATE_TIME_NO' => $generate_time_no,
		'GENTIMEADMIN_YES' => $generate_time_admin_yes,
		'GENTIMEADMIN_NO' => $generate_time_admin_no,
		'SHOW_RULES_YES' => $show_rules_yes,
		'SHOW_RULES_NO' => $show_rules_no,
		'RAR_YES' => $redirect_after_registering_yes,
		'RAR_NO' => $redirect_after_registering_no,
		'RAR_ADDRESS' => $new['redirect_address'],
		'RAR_TIME' => $new['r_a_r_time'],
		'LASTVISIT_DAYS' => $new['lastvisit_days'],
		'MAX_LOGIN_ERROR' => $new['max_login_error'],
		'MIN_PASSWORD_LEN' => $new['min_password_len'],
		'S_PASSWORD_COMPLEX_ENABLED' => $password_complex_yes,
		'S_PASSWORD_COMPLEX_DISABLED' => $password_complex_no,
		'S_PASSWORD_NOT_LOGIN_ENABLED' => $password_not_login_yes,
		'S_PASSWORD_NOT_LOGIN_DISABLED' => $password_not_login_no,
		'BLOCK_TIME' => $new['block_time'],
		'SEARCH_ENABLE_YES' => $search_enable_yes,
		'SEARCH_ENABLE_NO' => $search_enable_no,
		'OVERLIB_YES' => $overlib_yes,
		'OVERLIB_NO' => $overlib_no,
		'GG_PASS' => $new['haslo_gg'],
		'GG_NR' => $new['numer_gg'],
		'NOTIFY_GG_YES' => $notify_gg_yes,
		'NOTIFY_GG_NO' => $notify_gg_no,
		'ADMIN_NOTIFY_REPLY_YES' => $admin_notify_reply_yes,
		'ADMIN_NOTIFY_REPLY_NO' => $admin_notify_reply_no,
		'ADMIN_NOTIFY_MESSAGE_YES' => $admin_notify_message_yes,
		'ADMIN_NOTIFY_MESSAGE_NO' => $admin_notify_message_no,
		'ALL_TIME_BAN_CHECK_YES' => $all_time_ban_check_yes,
		'ALL_TIME_BAN_CHECK_NO' => $all_time_ban_check_no,
		'AUTOREPAIR_TABLES_YES' => $autorepair_tables_yes,
		'AUTOREPAIR_TABLES_NO' => $autorepair_tables_no,
		'DEL_NOT_METHOD_YES' => $del_notify_method_yes,
		'DEL_NOT_METHOD_NO' => $del_notify_method_no,
		'DEL_NOT_ENABLE_YES' => $del_notify_enable_yes,
		'DEL_NOT_ENABLE_NO' => $del_notify_enable_no,
		'DEL_NOT_CHOICE_YES' => $del_notify_choice_yes,
		'DEL_NOT_CHOICE_NO' => $del_notify_choice_no,
		'OPEN_IN_WINDOWS_YES' => $open_in_windows_yes,
		'OPEN_IN_WINDOWS_NO' => $open_in_windows_no,
		'ADMIN_NOTIFY_GG' => $new['admin_notify_gg'],
		'MAX_SIG_CHARS_ADMIN' => $new['max_sig_chars_admin'],
		'MAX_SIG_CHARS_MOD' => $new['max_sig_chars_mod'],

		'S_HIDDEN_FIELDS' => '<input type="hidden" name="mode" value="addons">')
	);
}

if ( $mode == 'main_page' )
{
	$template->set_filenames(array(
		'body' => 'admin/board_config_body_main_page.tpl')
	);
	$banner_top_enable_yes = ($new['banner_top_enable']) ? $checked : '';
	$banner_top_enable_no = (!$new['banner_top_enable']) ? $checked : '';
	$banner_bottom_enable_yes = ($new['banner_bottom_enable']) ? $checked : '';
	$banner_bottom_enable_no = (!$new['banner_bottom_enable']) ? $checked : '';
	$header_enable_yes = ($new['header_enable']) ? $checked : '';
	$header_enable_no = (!$new['header_enable']) ? $checked : '';
	$board_msg_none = ($new['board_msg_enable'] == '0' ) ? $checked : '';
	$board_msg_index = ($new['board_msg_enable'] == '1') ? $checked : '';
	$board_msg_all = ($new['board_msg_enable'] == '2') ? $checked : '';
	$width_forum_yes = ($new['width_forum']) ? $checked : '';
	$width_forum_no = (!$new['width_forum']) ? $checked : '';
	$width_forum_yes = ($new['width_forum']) ? $checked : '';
	$width_forum_no = (!$new['width_forum']) ? $checked : '';
	$cavatar_yes = ($new['cavatar']) ? $checked : '';
	$cavatar_no = (!$new['cavatar']) ? $checked : '';
	$cchat_yes = ($new['cchat']) ? $checked : '';
	$cchat_no = (!$new['cchat']) ? $checked : '';
	$cdownload_yes = ($new['download']) ? $checked : '';
	$cdownload_no = (!$new['download']) ? $checked : '';
	$album_yes = ($new['album_gallery']) ? $checked : '';
	$album_no = (!$new['album_gallery']) ? $checked : '';
	$cstat_yes = ($new['cstat']) ? $checked : '';
	$cstat_no = (!$new['cstat']) ? $checked : '';
	$cregist_yes = ($new['cregist']) ? $checked : '';
	$cregist_no = (!$new['cregist']) ? $checked : '';
	$cregist_b_yes = ($new['cregist_b']) ? $checked : '';
	$cregist_b_no = (!$new['cregist_b']) ? $checked : '';
	$cstyles_yes = ($new['cstyles']) ? $checked : '';
	$cstyles_no = (!$new['cstyles']) ? $checked : '';
	$ccount_yes = ($new['ccount']) ? $checked : '';
	$ccount_no = (!$new['ccount']) ? $checked : '';
	$u_o_t_d_yes = ($new['u_o_t_d']) ? $checked : '';
	$u_o_t_d_no = (!$new['u_o_t_d']) ? $checked : '';
	$cchat2_yes = ($new['cchat2']) ? $checked : '';
	$cchat2_no = (!$new['cchat2']) ? $checked : '';
	$cbirth_yes = ($new['cbirth']) ? $checked : '';
	$cbirth_no = (!$new['cbirth']) ? $checked : '';
	$staff_enable_yes = ($new['staff_enable']) ? $checked : '';
	$staff_enable_no = (!$new['staff_enable']) ? $checked : '';
	$staff_forums_yes = ($new['staff_forums']) ? $checked : '';
	$staff_forums_no = (!$new['staff_forums']) ? $checked : '';
	$ctop_yes = ($new['ctop']) ? $checked : '';
	$ctop_no = (!$new['ctop']) ? $checked : '';
	$portal_link_yes = ($new['portal_link']) ? $checked : '';
	$portal_link_no = (!$new['portal_link']) ? $checked : '';

	$template->assign_vars(array(
		'S_CONFIG_ACTION' => append_sid("admin_board.$phpEx"),
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_ENABLED' => $lang['Enabled'],
		'L_DISABLED' => $lang['Disabled'],
		'L_CONFIGURATION_TITLE' => $lang['General_Config'],
		'L_CONFIGURATION_EXPLAIN' => $lang['Config_explain'],
		'L_GENERAL_SETTINGS' => $lang['General_settings'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_CONFIG_CONF' => $lang['conf_conf'],
		'L_CONFIG' => $lang['conf_config'],
		'L_ADDONS' => $lang['conf_addons'],
		'L_MAIN_PAGE' => $lang['conf_main_page'],
		'L_ADDON_MAIN_PAGE' => $lang['l_addon_main_page'],
		'L_ADDON_MAIN' => $lang['l_addon_main'],
		'L_VIEWTOPIC' => $lang['conf_viewtopic'],
		'L_PROFILE' => $lang['conf_profile'],
		'L_ADDON_PROFILE' => $lang['l_addon_profile'],
		'L_POSTING' => $lang['conf_posting'],
		'L_ADDON_POSTING' => $lang['l_addon_posting'],
		'L_ADDON_VIEWTOPIC' => $lang['l_addon_viewtopic'],
		'L_BANNER_TOP' => $lang['banner_top'],
		'L_BANNER_TOP_E' => $lang['banner_top_e'],
		'L_BANNER_BOTTOM' => $lang['banner_bottom'],
		'L_BANNER_BOTTOM_E' => $lang['banner_bottom_e'],
		'L_HEADER' => $lang['header'],
		'L_HEADER_E' => $lang['header_e'],
		'L_ENABLE_BOARD_MSG' => $lang['Enable_board_msg'],
		'L_BOARD_MSG_NONE' => $lang['None'],
		'L_BOARD_MSG_INDEX' => $lang['board_msg_index'],
		'L_BOARD_MSG_ALL' => $lang['board_msg_all'],
		'L_BOARD_MSG' => $lang['board_msg'],
		'L_BOARD_MSG_EXPLAIN' => $lang['board_msg_explain'],
		'L_WIDTH_FORUM' => $lang['width_forum'],
		'L_WIDTH_FORUM_E' => $lang['width_forum_e'],
		'L_WIDTH_TABLE' => $lang['width_table'],
		'L_WIDTH_COLOR' => $lang['width_color'],
		'L_CAVATAR' => $lang['cavatar'],
		'L_CAVATAR_E' => $lang['cavatar_e'],
		'L_CCHAT' => $lang['cchat'],
		'L_LCHAT' => $lang['lchat'],
		'L_CDOWNLOAD' => $lang['cdownload'],
		'L_CDOWNLOAD_E' => $lang['cdownload_e'],
		'L_CALBUM' => $lang['calbum'],
		'L_CSTAT' => $lang['cstat'],
		'L_LSTAT' => $lang['lstat'],
		'L_CREGIST' => $lang['cregist'],
		'L_LREGIST' => $lang['lregist'],
		'L_CLOGIN_B' => $lang['clogin_b'],
		'L_CSTYLES' => $lang['cstyles'],
		'L_LSTYLES' => $lang['lstyles'],
		'L_CCOUNT' => $lang['ccount'],
		'L_LCOUNT' => $lang['lcount'],
		'L_U_O_T_D' => $lang['u_o_t_d'],
		'L_LCHAT2' => $lang['lchat2'],
		'L_CBIRTH' => $lang['cbirth'],
		'L_LBIRTH' => $lang['lbirth'],
		'L_STAFF_ENABLE' => $lang['staff_enable'],
		'L_STAFF_FORUMS' => $lang['staff_forums'],
		'L_CLOG' => $lang['clog'],
		'L_CTOP' => $lang['ctop'],
		'L_LTOP' => $lang['ltop'],
		'L_LAST_VISITORS_TIME_E' => $lang['last_visitors_time_e'],
		'L_PORTAL_LINK' => $lang['portal_link'],
		'L_PORTAL_LINK_E' => $lang['portal_link_e'],
		'L_ECHANGE_BANNER' => $lang['echange_banner'],
		'L_ECHANGE_BANNER_E' => $lang['echange_banner_e'],
		'L_ECHANGE_BANNER_HTML' => $lang['echange_banner_html'],

		'BANNER_TOP_ENABLE_YES' => $banner_top_enable_yes,
		'BANNER_TOP_ENABLE_NO' => $banner_top_enable_no,
		'BANNER_TOP' => $new['banner_top'],
		'BANNER_BOTTOM_ENABLE_YES' => $banner_bottom_enable_yes,
		'BANNER_BOTTOM_ENABLE_NO' => $banner_bottom_enable_no,
		'BANNER_BOTTOM' => $new['banner_bottom'],
		'HEADER_ENABLE_YES' => $header_enable_yes,
		'HEADER_ENABLE_NO' => $header_enable_no,
		'BOARD_MSG_NONE' => $board_msg_none,
		'BOARD_MSG_INDEX' => $board_msg_index,
		'BOARD_MSG_ALL' => $board_msg_all,
		'BOARD_MSG' => $new['board_msg'],
		'WIDTH_FORUM_YES' => $width_forum_yes,
		'WIDTH_FORUM_NO' => $width_forum_no,
		'WIDTH_TABLE' => $new['width_table'],
		'WIDTH_COLOR1' => $new['width_color1'],
		'WIDTH_COLOR2' => $new['width_color2'],
		'TABLE_BORDER' => $new['table_border'],
		'CAVATAR_YES' => $cavatar_yes,
		'CAVATAR_NO' => $cavatar_no,
		'CCHAT_YES' => $cchat_yes,
		'CCHAT_NO' => $cchat_no,
		'CDOWNLOAD_YES' => $cdownload_yes,
		'CDOWNLOAD_NO' => $cdownload_no,
		'ALBUM_YES' => $album_yes,
		'ALBUM_NO' => $album_no,
		'CSTAT_YES' => $cstat_yes,
		'CSTAT_NO' => $cstat_no,
		'CREGIST_YES' => $cregist_yes,
		'CREGIST_NO' => $cregist_no,
		'CREGIST_B_YES' => $cregist_b_yes,
		'CREGIST_B_NO' => $cregist_b_no,
		'CSTYLES_YES' => $cstyles_yes,
		'CSTYLES_NO' => $cstyles_no,
		'CCOUNT_YES' => $ccount_yes,
		'CCOUNT_NO' => $ccount_no,
		'U_O_T_D_YES' => $u_o_t_d_yes,
		'U_O_T_D_NO' => $u_o_t_d_no,
		'CCHAT2_YES' => $cchat2_yes,
		'CCHAT2_NO' => $cchat2_no,
		'CBIRTH_YES' => $cbirth_yes,
		'CBIRTH_NO' => $cbirth_no,
		'STAFF_ENABLE_NO' => $staff_enable_no,
		'STAFF_ENABLE_YES' => $staff_enable_yes,
		'STAFF_FORUMS_NO' => $staff_forums_no,
		'STAFF_FORUMS_YES' => $staff_forums_yes,
		'CTOP_YES' => $ctop_yes,
		'PORTAL_LINK_YES' => $portal_link_yes,
		'PORTAL_LINK_NO' => $portal_link_no,
		'ECHANGE_BANNER' => $new['echange_banner'],
		'ECHANGE_BANNER_HTML' => $new['banners_list'],
		'LAST_VISITORS_TIME' => $new['last_visitors_time'],
 
		'S_HIDDEN_FIELDS' => '<input type="hidden" name="mode" value="main_page">')
	);
}

if ( $mode == 'viewtopic' )
{
	$template->set_filenames(array(
		'body' => 'admin/board_config_body_viewtopic.tpl')
	);
	$cagent_yes = ($new['cagent']) ? $checked : '';
	$cagent_no = (!$new['cagent']) ? $checked : '';
	$cfriend_yes = ($new['cfriend']) ? $checked : '';
	$cfriend_no = (!$new['cfriend']) ? $checked : '';
	$cage_yes = ($new['cage']) ? $checked : '';
	$cage_no = (!$new['cage']) ? $checked : '';
	$cjoin_yes = ($new['cjoin']) ? $checked : '';
	$cjoin_no = (!$new['cjoin']) ? $checked : '';
	$cfrom_yes = ($new['cfrom']) ? $checked : '';
	$cfrom_no = (!$new['cfrom']) ? $checked : '';
	$cposts_yes = ($new['cposts']) ? $checked : '';
	$cposts_no = (!$new['cposts']) ? $checked : '';
	$clevell_yes = ($new['clevell']) ? $checked : '';
	$clevell_no = (!$new['clevell']) ? $checked : '';
	$cleveld_yes = ($new['cleveld']) ? $checked : '';
	$cleveld_no = (!$new['cleveld']) ? $checked : '';
	$cignore_yes = ($new['cignore']) ? $checked : '';
	$cignore_no = (!$new['cignore']) ? $checked : '';
	$cquick_yes = ($new['cquick']) ? $checked : '';
	$cquick_no = (!$new['cquick']) ? $checked : '';
	$cgg_yes = ($new['cgg']) ? $checked : '';
	$cgg_no = (!$new['cgg']) ? $checked : '';
	$graphic_yes = ($new['graphic']) ? $checked : '';
	$graphic_no = (!$new['graphic']) ? $checked : '';
	$post_footer_yes = ($new['post_footer']) ? $checked : '';
	$post_footer_no = (!$new['post_footer']) ? $checked : '';
	$hide_viewed_admin_yes = ($new['hide_viewed_admin']) ? $checked : '';
	$hide_viewed_admin_no = (!$new['hide_viewed_admin']) ? $checked : '';
	$hide_edited_admin_yes = (!$new['hide_edited_admin']) ? $checked : '';
	$hide_edited_admin_no = ($new['hide_edited_admin']) ? $checked : '';
	$who_viewed_yes = ($new['who_viewed']) ? $checked : '';
	$who_viewed_no = (!$new['who_viewed']) ? $checked : '';
	$who_viewed_admin_yes = ($new['who_viewed_admin']) ? $checked : '';
	$who_viewed_admin_no = (!$new['who_viewed_admin']) ? $checked : '';
	$not_anonymous_quickreply_yes = ($new['not_anonymous_quickreply']) ? $checked : '';
	$not_anonymous_quickreply_no = (!$new['not_anonymous_quickreply']) ? $checked : '';
	$topic_start_date_yes = ($new['topic_start_date']) ? $checked : '';
	$topic_start_date_no = (!$new['topic_start_date']) ? $checked : '';
	$ignore_topics_yes = ($new['ignore_topics']) ? $checked : '';
	$ignore_topics_no = (!$new['ignore_topics']) ? $checked : '';
	$poster_posts_yes = ($new['poster_posts']) ? $checked : '';
	$poster_posts_no = (!$new['poster_posts']) ? $checked : '';
	$newest_yes = ($new['newest']) ? $checked : '';
	$newest_no = (!$new['newest']) ? $checked : '';
	$csearch_yes = ($new['csearch']) ? $checked : '';
	$csearch_no = (!$new['csearch']) ? $checked : '';
	$sort_methods_yes = ($new['sort_methods']) ? $checked : '';
	$sort_methods_no = (!$new['sort_methods']) ? $checked : '';
	$show_quickreply_yes = ($new['group_rank_hack_version']) ? $checked : '';
	$show_quickreply_no = (!$new['group_rank_hack_version']) ? $checked : '';

	$template->assign_vars(array(
		'S_CONFIG_ACTION' => append_sid("admin_board.$phpEx"),
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_ENABLED' => $lang['Enabled'],
		'L_DISABLED' => $lang['Disabled'],
		'L_CONFIGURATION_TITLE' => $lang['General_Config'],
		'L_CONFIGURATION_EXPLAIN' => $lang['Config_explain'],
		'L_GENERAL_SETTINGS' => $lang['General_settings'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_CONFIG_CONF' => $lang['conf_conf'],
		'L_CONFIG' => $lang['conf_config'],
		'L_ADDONS' => $lang['conf_addons'],
		'L_MAIN_PAGE' => $lang['conf_main_page'],
		'L_ADDON_MAIN_PAGE' => $lang['l_addon_main_page'],
		'L_ADDON_MAIN' => $lang['l_addon_main'],
		'L_VIEWTOPIC' => $lang['conf_viewtopic'],
		'L_PROFILE' => $lang['conf_profile'],
		'L_ADDON_PROFILE' => $lang['l_addon_profile'],
		'L_POSTING' => $lang['conf_posting'],
		'L_ADDON_POSTING' => $lang['l_addon_posting'],
		'L_ADDON_VIEWTOPIC' => $lang['l_addon_viewtopic'],
		'L_CAGENT' => $lang['cagent'],
		'L_CAGENT_E' => $lang['cagente'],
		'L_CFRIEND' => $lang['s_email_friend'],
		'L_LFRIEND' => $lang['lfriend'],
		'L_CAGE' => $lang['cage'],
		'L_LAGE' => $lang['lage'],
		'L_CJOIN' => $lang['cjoin'],
		'L_LJOIN' => $lang['ljoin'],
		'L_CFROM' => $lang['cfrom'],
		'L_LFROM' => $lang['lfrom'],
		'L_CPOSTS' => $lang['cposts'],
		'L_LPOSTS' => $lang['lposts'],
		'L_CLEVELL' => $lang['clevell'],
		'L_LLEVELL' => $lang['llevell'],
		'L_CLEVELD' => $lang['cleveld'],
		'L_CIGNORE' => $lang['cignore'],
		'L_LIGNORE' => $lang['lignore'],
		'L_CQUICK' => $lang['Quick_Reply'],
		'L_LQUICK' => $lang['lquick'],
		'L_CGG' => $lang['cgg'],
		'L_LGG' => $lang['lgg'],
		'L_CLEVELD' => $lang['cleveld'],
		'L_LLEVELD' => $lang['lleveld'],
		'L_GRAPHIC' => $lang['graphic'],
		'L_GRAPHIC_E' => $lang['graphic_e'],
		'L_POST_FOOTER' => $lang['post_footer'],
		'L_POST_FOOTER_E' => $lang['post_footer_e'],
		'L_HV_ADMIN_E' => $lang['hv_admin_e'],
		'L_HV_ADMIN' => $lang['hv_admin'],
		'L_HE_ADMIN' => $lang['he_admin'],
		'L_HE_ADMIN_E' => $lang['he_admin_e'],
		'L_WV' => $lang['wv'],
		'L_WV_ADMIN' => $lang['wv_admin'],
		'L_WV_ADMIN_E' => $lang['wv_admin_e'],
		'L_NOT_ANONYMOUS_QUICKREPLY' => $lang['not_anonymous_quickreply'],
		'L_MAX_SMILIES' => $lang['max_smilies'],
		'L_TOPIC_START_DATE' => $lang['topic_start_date'],
		'L_TOPIC_START_DATEFORMAT' => $lang['topic_start_dateformat'],
		'L_TOPIC_START_DATEFORMAT_E' => $lang['topic_start_dateformat_e'],
		'L_ADDON_VIEWFORUM' => $lang['l_addon_viewforum'],
		'L_IGNORE_TOPICS' => $lang['ignore_topics'],
		'L_POSTER_POSTS' => $lang['l_poster_posts'],
		'L_POSTER_POSTS_E' => $lang['l_poster_posts_e'],
		'L_NEWEST' => $lang['newest'],
		'L_NEWEST_E' => $lang['newest_e'],
		'L_CSEARCH' => $lang['csearch'],
		'L_LSEARCH' => $lang['lsearch'],
		'L_SORT_METHODS' => $lang['sort_methods'],
		'L_SORT_METHODS_E' => $lang['sort_methods_e'],
		'L_QUICK_REPLY_PAGES' => $lang['quick_reply_pages'],

		'CAGENT_YES' => $cagent_yes,
		'CAGENT_NO' => $cagent_no,
		'CFRIEND_YES' => $cfriend_yes,
		'CFRIEND_NO' => $cfriend_no,
		'CAGE_YES' => $cage_yes,
		'CAGE_NO' => $cage_no,
		'CJOIN_YES' => $cjoin_yes,
		'CJOIN_NO' => $cjoin_no,
		'CFROM_YES' => $cfrom_yes,
		'CFROM_NO' => $cfrom_no,
		'CPOSTS_YES' => $cposts_yes,
		'CPOSTS_NO' => $cposts_no,
		'CLEVELL_YES' => $clevell_yes,
		'CLEVELL_NO' => $clevell_no,
		'CIGNORE_YES' => $cignore_yes,
		'CIGNORE_NO' => $cignore_no,
		'CQUICK_YES' => $cquick_yes,
		'CQUICK_NO' => $cquick_no,
		'CGG_YES' => $cgg_yes,
		'CGG_NO' => $cgg_no,
		'CLEVELD_YES' => $cleveld_yes,
		'CLEVELD_NO' => $cleveld_no,
		'GRAPHIC_YES' => $graphic_yes,
		'GRAPHIC_NO' => $graphic_no,
		'POST_FOOTER_YES' => $post_footer_yes,
		'POST_FOOTER_NO' => $post_footer_no,
		'HV_ADMIN_YES' => $hide_viewed_admin_yes,
		'HV_ADMIN_NO' => $hide_viewed_admin_no,
		'HE_ADMIN_YES' => $hide_edited_admin_yes,
		'HE_ADMIN_NO' => $hide_edited_admin_no,
		'WV_YES' => $who_viewed_yes,
		'WV_NO' => $who_viewed_no,
		'WV_ADMIN_YES' => $who_viewed_admin_yes,
		'WV_ADMIN_NO' => $who_viewed_admin_no,
		'TOPIC_START_DATEFORMAT' => $new['topic_start_dateformat'],
		'MAX_SMILIES' => $new['max_smilies'],
		'NOT_ANONYMOUS_QUICKREPLY_YES' => $not_anonymous_quickreply_yes,
		'NOT_ANONYMOUS_QUICKREPLY_NO' => $not_anonymous_quickreply_no,
		'TOPIC_START_DATE_YES' => $topic_start_date_yes,
		'TOPIC_START_DATE_NO' => $topic_start_date_no,
		'IGNORE_TOPICS_NO' => $ignore_topics_no,
		'IGNORE_TOPICS_YES' => $ignore_topics_yes,
		'CTOP_NO' => $ctop_no,
		'POSTER_POSTS_YES' => $poster_posts_yes,
		'POSTER_POSTS_NO' => $poster_posts_no,
		'NEWEST_YES' => $newest_yes,
		'NEWEST_NO' => $newest_no,
		'CSEARCH_YES' => $csearch_yes,
		'CSEARCH_NO' => $csearch_no,
		'SORT_METHODS_YES' => $sort_methods_yes,
		'SORT_METHODS_NO' => $sort_methods_no,
		'QUICK_REPLY_PAGES_YES' => $show_quickreply_yes,
		'QUICK_REPLY_PAGES_NO' => $show_quickreply_no,

		'S_HIDDEN_FIELDS' => '<input type="hidden" name="mode" value="viewtopic">')
	);
}

if ( $mode == 'profile' )
{
	$template->set_filenames(array(
		'body' => 'admin/board_config_body_profile.tpl')
	);
	$cvalidate_yes = ($new['validate']) ? $checked : '';
	$cvalidate_no = (!$new['validate']) ? $checked : '';
	$require_aim_yes = ($new['require_aim']) ? $checked : '';
	$require_aim_no = (!$new['require_aim']) ? $checked : '';
	$require_website_yes = ($new['require_website']) ? $checked : '';
	$require_website_no = (!$new['require_website']) ? $checked : '';
	$require_location_yes = ($new['require_location']) ? $checked : '';
	$require_location_no = (!$new['require_location']) ? $checked : '';
	$gender_yes = ($new['gender']) ? $checked : '';
	$gender_no = (!$new['gender']) ? $checked : '';
	$require_gender_yes = ($new['require_gender']) ? $checked : '';
	$require_gender_no = (!$new['require_gender']) ? $checked : '';
	$cicq_yes = ($new['cicq']) ? $checked : '';
	$cicq_no = (!$new['cicq']) ? $checked : '';
	$cllogin_yes = ($new['cllogin']) ? $checked : '';
	$cllogin_no = (!$new['cllogin']) ? $checked : '';
	$clevelp_yes = ($new['clevelp']) ? $checked : '';
	$clevelp_no = (!$new['clevelp']) ? $checked : '';
	$cyahoo_yes = ($new['cyahoo']) ? $checked : '';
	$cyahoo_no = (!$new['cyahoo']) ? $checked : '';
	$cmsn_yes = ($new['cmsn']) ? $checked : '';
	$cmsn_no = (!$new['cmsn']) ? $checked : '';
	$cjob_yes = ($new['cjob']) ? $checked : '';
	$cjob_no = (!$new['cjob']) ? $checked : '';
	$cinter_yes = ($new['cinter']) ? $checked : '';
	$cinter_no = (!$new['cinter']) ? $checked : '';
	$cemail_yes = ($new['cemail']) ? $checked : '';
	$cemail_no = (!$new['cemail']) ? $checked : '';
	$cbbcode_yes = ($new['cbbcode']) ? $checked : '';
	$cbbcode_no = (!$new['cbbcode']) ? $checked : '';
	$chtml_yes = ($new['chtml']) ? $checked : '';
	$chtml_no = (!$new['chtml']) ? $checked : '';
	$csmiles_yes = ($new['csmiles']) ? $checked : '';
	$csmiles_no = (!$new['csmiles']) ? $checked : '';
	$cpppage_yes = ($new['cpppage']) ? $checked : '';
	$cpppage_no = (!$new['cpppage']) ? $checked : '';
	$clang_yes = ($new['clang']) ? $checked : '';
	$clang_no = (!$new['clang']) ? $checked : '';
	$ctimezone_yes = ($new['ctimezone']) ? $checked : '';
	$ctimezone_no = (!$new['ctimezone']) ? $checked : '';
	$cdatefor_yes = ($new['cdatefor']) ? $checked : '';
	$cdatefor_no = (!$new['cdatefor']) ? $checked : '';
	$cbstyle_yes = ($new['cbstyle']) ? $checked : '';
	$cbstyle_no = (!$new['cbstyle']) ? $checked : '';
	$avatars_local_yes = ($new['allow_avatar_local']) ? $checked : '';
	$avatars_local_no = (!$new['allow_avatar_local']) ? $checked : '';
	$avatars_remote_yes = ($new['allow_avatar_remote']) ? $checked : '';
	$avatars_remote_no = (!$new['allow_avatar_remote']) ? $checked : '';
	$avatars_upload_yes = ($new['allow_avatar_upload']) ? $checked : '';
	$avatars_upload_no = (!$new['allow_avatar_upload']) ? $checked : '';
	$photo_remote_yes = ($new['allow_photo_remote']) ? $checked : '';
	$photo_remote_no = (!$new['allow_photo_remote']) ? $checked : '';
	$photo_upload_yes = ($new['allow_photo_upload']) ? $checked : '';
	$photo_upload_no = (!$new['allow_photo_upload']) ? $checked : '';
	$sig_yes = ($new['allow_sig']) ? $checked : '';
	$sig_no = (!$new['allow_sig']) ? $checked : '';
	$sig_image_yes = ($new['allow_sig_image']) ? $checked : '';
	$sig_image_no = (!$new['allow_sig_image']) ? $checked : '';
	$sig_image_img_yes = ($new['allow_sig_image_img']) ? $checked : '';
	$sig_image_img_no = (!$new['allow_sig_image_img']) ? $checked : '';

	$template->assign_vars(array(
		'S_CONFIG_ACTION' => append_sid("admin_board.$phpEx"),
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_ENABLED' => $lang['Enabled'],
		'L_DISABLED' => $lang['Disabled'],
		'L_CONFIGURATION_TITLE' => $lang['General_Config'],
		'L_CONFIGURATION_EXPLAIN' => $lang['Config_explain'],
		'L_GENERAL_SETTINGS' => $lang['General_settings'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_CONFIG_CONF' => $lang['conf_conf'],
		'L_CONFIG' => $lang['conf_config'],
		'L_ADDONS' => $lang['conf_addons'],
		'L_MAIN_PAGE' => $lang['conf_main_page'],
		'L_ADDON_MAIN_PAGE' => $lang['l_addon_main_page'],
		'L_ADDON_MAIN' => $lang['l_addon_main'],
		'L_VIEWTOPIC' => $lang['conf_viewtopic'],
		'L_PROFILE' => $lang['conf_profile'],
		'L_ADDON_PROFILE' => $lang['l_addon_profile'],
		'L_POSTING' => $lang['conf_posting'],
		'L_ADDON_POSTING' => $lang['l_addon_posting'],
		'L_ADDON_VIEWTOPIC' => $lang['l_addon_viewtopic'],
		'L_VALIDATION' => $lang[Validation],
		'L_CVALIDATEE' => $lang['cvalidatee'],
		'L_REQUIRE_AIM' => $lang['l_require_aim'],
		'L_REQUIRE_AIM_E' => $lang['l_require_aim_e'],
		'L_REQUIRE_WEBSITE' => $lang['l_require_website'],
		'L_REQUIRE_WEBSITE_E' => $lang['l_require_website_e'],
		'L_REQUIRE_LOCATION' => $lang['l_require_location'],
		'L_REQUIRE_LOCATION_E' => $lang['l_require_location_e'],
		'L_MAX_SIG_LOCATION' => $lang['max_sig_location'],
		'L_GENDER' => $lang['l_gender'],
		'L_GENDER_E' => $lang['l_gender_e'],
		'L_REQUIRE_GENDER' => $lang['l_require_gender'],
		'L_CICQ' => $lang['cicq'],
		'L_LICQ' => $lang['licq'],
		'L_CLLOGIN' => $lang['Sort_Last_visit'],
		'L_LLLOGIN' => $lang['lllogin'],
		'L_CLEVELP' => $lang['clevelp'],
		'L_LLEVELP' => $lang['llevelp'],
		'L_CYAHOO' => $lang['cyahoo'],
		'L_LYAHOO' => $lang['lyahoo'],
		'L_CMSN' => $lang['cmsn'],
		'L_LMSN' => $lang['lmsn'],
		'L_CJOB' => $lang['Occupation'],
		'L_LJOB' => $lang['ljob'],
		'L_CINTER' => $lang['Interests'],
		'L_LINTER' => $lang['linter'],
		'L_CEMAIL' => $lang['Public_view_email'],
		'L_LEMAIL' => $lang['lemail'],
		'L_CBBCODE' => $lang['Always_bbcode'],
		'L_LBBCODE' => $lang['lbbcode'],
		'L_CHTML' => $lang['Always_html'],
		'L_LHTML' => $lang['lhtml'],
		'L_CSMILES' => $lang['Always_smile'],
		'L_LSMILES' => $lang['lsmiles'],
		'L_CPPPAGE' => $lang['cpppage'],
		'L_LPPPAGE' => $lang['lpppage'],
		'L_CLANG' => $lang['Board_lang'],
		'L_LLANG' => $lang['llang'],
		'L_CTIMEZONE' => $lang['Timezone'],
		'L_LTIMEZONE' => $lang['ltimezone'],
		'L_CDATEFOR' => $lang['Date_format'],
		'L_LDATEFOR' => $lang['ldatefor'],
		'L_CBSTYLE' => $lang['Board_style'],
		'L_LBSTYLE' => $lang['lbstyle'],
		'L_AVATAR_SETTINGS' => $lang['Avatar_settings'],
		'L_ALLOW_LOCAL' => $lang['Allow_local'],
		'L_ALLOW_REMOTE' => $lang['Allow_remote'],
		'L_ALLOW_REMOTE_EXPLAIN' => $lang['Allow_remote_explain'],
		'L_ALLOW_UPLOAD' => $lang['Allow_upload'],
		'L_ALLOW_AVATAR' => $lang['Allow_avatar'],
		'L_ALLOW_AVATAR_EXPLAIN' => $lang['Allow_avatar_explain'],
		'L_MAX_FILESIZE' => $lang['Max_filesize'],
		'L_MAX_FILESIZE_EXPLAIN' => $lang['Max_filesize_explain'],
		'L_MAX_AVATAR_SIZE' => $lang['Max_avatar_size'],
		'L_MAX_AVATAR_SIZE_EXPLAIN' => $lang['Max_avatar_size_explain'],
		'L_AVATAR_STORAGE_PATH' => $lang['Avatar_storage_path'],
		'L_AVATAR_STORAGE_PATH_EXPLAIN' => $lang['Avatar_storage_path_explain'],
		'L_AVATAR_GALLERY_PATH' => $lang['Avatar_gallery_path'],
		'L_AVATAR_GALLERY_PATH_EXPLAIN' => $lang['Avatar_gallery_path_explain'],
		'L_PROFLE_PHOTO_SETTINGS' => $lang['Profile_photo_settings'],
		'L_ALLOW_PHOTO_REMOTE' => $lang['Allow_photo_remote'],
		'L_ALLOW_PHOTO_REMOTE_EXPLAIN' => $lang['Allow_photo_remote_explain'],
		'L_ALLOW_PHOTO_UPLOAD' => $lang['Allow_photo_upload'],
		'L_PHOTO_MAX_FILESIZE' => $lang['Photo_max_filesize'],
		'L_PHOTO_MAX_FILESIZE_EXPLAIN' => $lang['Photo_max_filesize_explain'],
		'L_MAX_PHOTO_SIZE' => $lang['Max_photo_size'],
		'L_PHOTO_STORAGE_PATH' => $lang['Photo_storage_path'],
		'L_PHOTO_STORAGE_PATH_EXPLAIN' => $lang['Photo_storage_path_explain'],
		'L_SIGNATURE_SETTINGS' => $lang['Signature_settings'],
		'L_ALLOW_SIG_IMAGE' => $lang['Allow_sig_image'],
		'L_ALLOW_SIG' => $lang['Allow_sig'],
		'L_MAX_SIG_LENGTH' => $lang['Max_sig_length'],
		'L_MAX_SIG_LENGTH_EXPLAIN' => $lang['Max_sig_length_explain'],
		'L_MAX_SIG_FILESIZE' => $lang['Max_sig_image_filesize'],
		'L_MAX_SIG_IMAGE_SIZE' => $lang['Max_sig_image_size'],
		'L_MAX_SIG_IMAGE_SIZE_EXPLAIN' => $lang['Max_sig_image_size_explain'],
		'L_SIG_IMAGES_STORAGE_PATH' => $lang['Sig_images_storage_path'],
		'L_SIG_IMAGES_STORAGE_PATH_EXPLAIN' => $lang['Sig_images_storage_path_explain'],
		'L_MAX_SIG_LENGTH' => $lang['Max_sig_length'],
		'L_MAX_SIG_LENGTH_EXPLAIN' => $lang['Max_sig_length_explain'],
		'L_ALLOW_IMG_BBCODE' => $lang['allow_img_bbcode'],
		'L_ALLOW_IMG_BBCODE_E' => $lang['allow_img_bbcode_e'],
		'L_VIEWONLINE' => $lang['viewonline_e'],

		'CVALIDATE_YES' => $cvalidate_yes,
		'CVALIDATE_NO' => $cvalidate_no,
		'REQUIRE_AIM_NO' => $require_aim_no,
		'REQUIRE_AIM_YES' => $require_aim_yes,
		'REQUIRE_WEBSITE_NO' => $require_website_no,
		'REQUIRE_WEBSITE_YES' => $require_website_yes,
		'REQUIRE_LOCATION_NO' => $require_location_no,
		'REQUIRE_LOCATION_YES' => $require_location_yes,
		'MAX_SIG_LOCATION' => $new['max_sig_location'],
		'GENDER_YES' => $gender_yes,
		'GENDER_NO' => $gender_no,
		'REQUIRE_GENDER_YES' => $require_gender_yes,
		'REQUIRE_GENDER_NO' => $require_gender_no,
		'CICQ_YES' => $cicq_yes,
		'CICQ_NO' => $cicq_no,
		'CLLOGIN_YES' => $cllogin_yes,
		'CLLOGIN_NO' => $cllogin_no,
		'CLEVELP_YES' => $clevelp_yes,
		'CLEVELP_NO' => $clevelp_no,
		'CYAHOO_YES' => $cyahoo_yes,
		'CYAHOO_NO' => $cyahoo_no,
		'CMSN_YES' => $cmsn_yes,
		'CMSN_NO' => $cmsn_no,
		'CJOB_YES' => $cjob_yes,
		'CJOB_NO' => $cjob_no,
		'CINTER_YES' => $cinter_yes,
		'CINTER_NO' => $cinter_no,
		'CEMAIL_YES' => $cemail_yes,
		'CEMAIL_NO' => $cemail_no,
		'CBBCODE_YES' => $cbbcode_yes,
		'CBBCODE_NO' => $cbbcode_no,
		'CHTML_YES' => $chtml_yes,
		'CHTML_NO' => $chtml_no,
		'CSMILES_YES' => $csmiles_yes,
		'CSMILES_NO' => $csmiles_no,
		'CPPPAGE_YES' => $cpppage_yes,
		'CPPPAGE_NO' => $cpppage_no,
		'CLANG_YES' => $clang_yes,
		'CLANG_NO' => $clang_no,
		'CTIMEZONE_YES' => $ctimezone_yes,
		'CTIMEZONE_NO' => $ctimezone_no,
		'CDATEFOR_YES' => $cdatefor_yes,
		'CDATEFOR_NO' => $cdatefor_no,
		'CBSTYLE_YES' => $cbstyle_yes,
		'CBSTYLE_NO' => $cbstyle_no,
		'AVATARS_LOCAL_YES' => $avatars_local_yes,
		'AVATARS_LOCAL_NO' => $avatars_local_no,
		'AVATARS_REMOTE_YES' => $avatars_remote_yes,
		'AVATARS_REMOTE_NO' => $avatars_remote_no,
		'AVATARS_UPLOAD_YES' => $avatars_upload_yes,
		'AVATARS_UPLOAD_NO' => $avatars_upload_no,
		'AVATAR_FILESIZE' => $new['avatar_filesize'],
		'ALLOW_AVATAR' => $new['allow_avatar'],
		'AVATAR_MAX_HEIGHT' => $new['avatar_max_height'],
		'AVATAR_MAX_WIDTH' => $new['avatar_max_width'],
		'AVATAR_PATH' => $new['avatar_path'],
		'AVATAR_GALLERY_PATH' => $new['avatar_gallery_path'],
		'PHOTO_REMOTE_YES' => $photo_remote_yes,
		'PHOTO_REMOTE_NO' => $photo_remote_no,
		'PHOTO_UPLOAD_YES' => $photo_upload_yes,
		'PHOTO_UPLOAD_NO' => $photo_upload_no,
		'PHOTO_FILESIZE' => $new['photo_filesize'],
		'PHOTO_MAX_WIDTH' => $new['photo_max_width'],
		'PHOTO_MAX_HEIGHT' => $new['photo_max_height'],
		'PHOTO_PATH' => $new['photo_path'],
		'SIG_YES' => $sig_yes,
		'SIG_NO' => $sig_no,
		'SIG_IMAGE_YES' => $sig_image_yes,
		'SIG_IMAGE_NO' => $sig_image_no,
		'SIG_SIZE' => $new['max_sig_chars'],
		'SIG_IMAGE_FILESIZE' => $new['sig_image_filesize'],
		'SIG_IMAGE_MAX_HEIGHT' => $new['sig_image_max_height'],
		'SIG_IMAGE_MAX_WIDTH' => $new['sig_image_max_width'],
		'SIG_IMAGES_PATH' => $new['sig_images_path'],
		'SIG_IMAGE_IMG_YES' => $sig_image_img_yes,
		'SIG_IMAGE_IMG_NO' => $sig_image_img_no,
		'VIEWONLINE' => $new['viewonline'],
		'S_HIDDEN_FIELDS' => '<input type="hidden" name="mode" value="profile">')
	);
}

if ( $mode == 'posting' )
{
	$template->set_filenames(array(
		'body' => 'admin/board_config_body_posting.tpl')
	);
	$smile_yes = ($new['allow_smilies']) ? $checked : '';
	$smile_no = (!$new['allow_smilies']) ? $checked : '';
	$smilies_columns = $new['smilies_columns'];
	$smilies_rows = $new['smilies_rows'];
	$smilies_w_columns = $new['smilies_w_columns'];
	$html_yes = ($new['allow_html']) ? $checked : '';
	$html_no = (!$new['allow_html']) ? $checked : '';
	$html_tags = $new['allow_html_tags'];
	$restrictbbcode_yes = ($new['allow_bbcode_quest']) ? $checked : '';
	$restrictbbcode_no = (!$new['allow_bbcode_quest']) ? $checked : '';
	$bbcode_yes = ($new['allow_bbcode']) ? $checked : '';
	$bbcode_no = (!$new['allow_bbcode']) ? $checked : '';
	$posticon_yes = ($new['post_icon']) ? $checked : '';
	$posticon_no = (!$new['post_icon']) ? $checked : '';
	$button_b_yes = ($new['button_b']) ? $checked : '';
	$button_b_no = (!$new['button_b']) ? $checked : '';
	$button_i_yes = ($new['button_i']) ? $checked : '';
	$button_i_no = (!$new['button_i']) ? $checked : '';
	$button_u_yes = ($new['button_u']) ? $checked : '';
	$button_u_no = (!$new['button_u']) ? $checked : '';
	$button_q_yes = ($new['button_q']) ? $checked : '';
	$button_q_no = (!$new['button_q']) ? $checked : '';
	$button_c_yes = ($new['button_c']) ? $checked : '';
	$button_c_no = (!$new['button_c']) ? $checked : '';
	$button_l_yes = ($new['button_l']) ? $checked : '';
	$button_l_no = (!$new['button_l']) ? $checked : '';
	$button_im_yes = ($new['button_im']) ? $checked : '';
	$button_im_no = (!$new['button_im']) ? $checked : '';
	$button_ur_yes = ($new['button_ur']) ? $checked : '';
	$button_ur_no = (!$new['button_ur']) ? $checked : '';
	$button_ce_yes = ($new['button_ce']) ? $checked : '';
	$button_ce_no = (!$new['button_ce']) ? $checked : '';
	$button_f_yes = ($new['button_f']) ? $checked : '';
	$button_f_no = (!$new['button_f']) ? $checked : '';
	$button_s_yes = ($new['button_s']) ? $checked : '';
	$button_s_no = (!$new['button_s']) ? $checked : '';
	$button_hi_yes = ($new['button_hi']) ? $checked : '';
	$button_hi_no = (!$new['button_hi']) ? $checked : '';
	$color_box_yes = ($new['color_box']) ? $checked : '';
	$color_box_no = (!$new['color_box']) ? $checked : '';
	$size_box_yes = ($new['size_box']) ? $checked : '';
	$size_box_no = (!$new['size_box']) ? $checked : '';
	$glow_box_yes = ($new['glow_box']) ? $checked : '';
	$glow_box_no = (!$new['glow_box']) ? $checked : '';
	$topic_color_mod_yes = ($new['topic_color_mod']) ? $checked : '';
	$topic_color_mod_no = (!$new['topic_color_mod']) ? $checked : '';
	$topic_color_all_yes = ($new['topic_color_all']) ? $checked : '';
	$topic_color_all_no = (!$new['topic_color_all']) ? $checked : '';
	$topic_color_yes = ($new['topic_color']) ? $checked : '';
	$topic_color_no = (!$new['topic_color']) ? $checked : '';
	$freak_yes = ($new['freak']) ? $checked : '';
	$freak_no = (!$new['freak']) ? $checked : '';
	$expire_yes = ($new['expire']) ? $checked : '';
	$expire_no = (!$new['expire']) ? $checked : '';
	$expire_v_yes = ($new['expire_value']) ? $checked : '';
	$expire_v_no = (!$new['expire_value']) ? $checked : '';
	$restrict_smilies_yes = ($new['restrict_smilies']) ? $checked : '';
	$restrict_smilies_no = (!$new['restrict_smilies']) ? $checked : '';
	$topic_preview_yes = ($new['topic_preview']) ? $checked : '';
	$topic_preview_no = (!$new['topic_preview']) ? $checked : '';
	$not_anonymous_posting_yes = ($new['not_anonymous_posting']) ? $checked : '';
	$not_anonymous_posting_no = (!$new['not_anonymous_posting']) ? $checked : '';
	$split_messages_yes = ($new['split_messages']) ? $checked : '';
	$split_messages_no = (!$new['split_messages']) ? $checked : '';
	$split_messages_admin_yes = ($new['split_messages_admin']) ? $checked : '';
	$split_messages_admin_no = (!$new['split_messages_admin']) ? $checked : '';
	$split_messages_mod_yes = ($new['split_messages_mod']) ? $checked : '';
	$split_messages_mod_no = (!$new['split_messages_mod']) ? $checked : '';
	$admin_html_yes = ($new['admin_html']) ? $checked : '';
	$admin_html_no = (!$new['admin_html']) ? $checked : '';
	$jr_admin_html_yes = ($new['jr_admin_html']) ? $checked : '';
	$jr_admin_html_no = (!$new['jr_admin_html']) ? $checked : '';
	$mod_html_yes = ($new['mod_html']) ? $checked : '';
	$mod_html_no = (!$new['mod_html']) ? $checked : '';
	$title_explain_yes = ($new['title_explain']) ? $checked : '';
	$title_explain_no = (!$new['title_explain']) ? $checked : '';

	$template->assign_vars(array(
		'S_CONFIG_ACTION' => append_sid("admin_board.$phpEx"),
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_ENABLED' => $lang['Enabled'],
		'L_DISABLED' => $lang['Disabled'],
		'L_CONFIGURATION_TITLE' => $lang['General_Config'],
		'L_CONFIGURATION_EXPLAIN' => $lang['Config_explain'],
		'L_GENERAL_SETTINGS' => $lang['General_settings'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_CONFIG_CONF' => $lang['conf_conf'],
		'L_CONFIG' => $lang['conf_config'],
		'L_ADDONS' => $lang['conf_addons'],
		'L_MAIN_PAGE' => $lang['conf_main_page'],
		'L_ADDON_MAIN_PAGE' => $lang['l_addon_main_page'],
		'L_ADDON_MAIN' => $lang['l_addon_main'],
		'L_VIEWTOPIC' => $lang['conf_viewtopic'],
		'L_PROFILE' => $lang['conf_profile'],
		'L_ADDON_PROFILE' => $lang['l_addon_profile'],
		'L_POSTING' => $lang['conf_posting'],
		'L_ADDON_POSTING' => $lang['l_addon_posting'],
		'L_ADDON_VIEWTOPIC' => $lang['l_addon_viewtopic'],
		'L_ALLOW_SMILIES' => $lang['Allow_smilies'],
		'L_SMILIES_PATH' => $lang['Smilies_path'],
		'L_SMILIES_VALUE' => $lang['l_smilies_value'],
		'L_SMILIES_VALUE_E' => $lang['l_smilies_value_e'],
		'L_ALLOW_HTML' => $lang['Allow_HTML'],
		'L_ALLOWED_TAGS' => $lang['Allowed_tags'],
		'L_ALLOWED_TAGS_EXPLAIN' => $lang['Allowed_tags_explain'],
		'L_RESTRICTBBCODE' => $lang['l_restrictbbcode'],
		'L_RESTRICTBBCODE_E' => $lang['l_restrictbbcode_e'],
		'L_ALLOW_BBCODE' => $lang['Allow_BBCode'],
		'L_POSTICON' => $lang['posticon_a'],
		'L_BUTTON_B' => $lang['l_button_b'],
		'L_BUTTON_I' => $lang['l_button_i'],
		'L_BUTTON_U' => $lang['l_button_u'],
		'L_BUTTON_Q' => $lang['l_button_q'],
		'L_BUTTON_C' => $lang['l_button_c'],
		'L_BUTTON_L' => $lang['l_button_l'],
		'L_BUTTON_IM' => $lang['l_button_im'],
		'L_BUTTON_UR' => $lang['l_button_ur'],
		'L_BUTTON_CE' => $lang['l_button_ce'],
		'L_BUTTON_F' => $lang['l_button_f'],
		'L_BUTTON_S' => $lang['l_button_s'],
		'L_BUTTON_HI' => $lang['l_button_hi'],
		'L_COLOR_BOX' => $lang['l_color_box'],
		'L_SIZE_BOX' => $lang['l_size_box'],
		'L_GLOW_BOX' => $lang['l_glow_box'],
		'L_TOPIC_COLOR' => $lang['topic_color'],
		'L_TOPIC_COLOR_ALL' => $lang['topic_color_all'],
		'L_TOPIC_COLOR_MOD' => $lang['topic_color_mod'],
		'L_EXPIRE' => $lang['l_expire_p'],
		'L_EXPIRE_V' => $lang['l_expire_v'],
		'L_EXPIRE_V_E' => $lang['l_expire_v_e'],
		'L_FREAK' => $lang['l_freak'],
		'L_SPLIT_MESSAGES_EXCEPT_E' => $lang['split_messages_except_e'],
		'L_SPLIT_MESSAGES_EXCEPT' => $lang['split_messages_except'],
		'L_ADMIN_HTML_E' => $lang['admin_html_e'],
		'L_RESTRICT_SMILIES' => $lang['restrict_smilies'],
		'L_TOPIC_PREVIEW' => $lang['topic_preview'],
		'L_NOT_ANONYMOUS_POSTING_E' => $lang['not_anonymous_posting_e'],
		'L_SPLIT_MESSAGES' => $lang['split_messages'],
		'L_SPLIT_MESSAGES_E' => $lang['split_messages_e'],
		'L_SPLIT_MESSAGES_ADMIN' => $lang['split_messages_admin'],
		'L_SPLIT_MESSAGES_MOD' => $lang['split_messages_mod'],
		'L_ADMIN_HTML' => $lang['admin_html'],
		'L_JR_ADMIN_HTML' => $lang['jr_admin_html'],
		'L_MOD_HTML' => $lang['mod_html'],
		'L_TITLE_EXPLAIN' => $lang['Subject_e'],

		'SMILE_YES' => $smile_yes,
		'SMILE_NO' => $smile_no,
		'SMILIES_PATH' => $new['smilies_path'],
		'SMILIES_COLUMNS' => $smilies_columns,
		'SMILIES_ROWS' => $smilies_rows,
		'SMILIES_W_COLUMNS' => $smilies_w_columns,
		'HTML_YES' => $html_yes,
		'HTML_NO' => $html_no,
		'HTML_TAGS' => $html_tags,
		'RESTRICTBBCODE_YES' => $restrictbbcode_yes,
		'RESTRICTBBCODE_NO' => $restrictbbcode_no,
		'BBCODE_YES' => $bbcode_yes,
		'BBCODE_NO' => $bbcode_no,
		'POSTICON_YES' => $posticon_yes,
		'POSTICON_NO' => $posticon_no,
		'BUTTON_B_YES' => $button_b_yes,
		'BUTTON_B_NO' => $button_b_no,
		'BUTTON_I_YES' => $button_i_yes,
		'BUTTON_I_NO' => $button_i_no,
		'BUTTON_U_YES' => $button_u_yes,
		'BUTTON_U_NO' => $button_u_no,
		'BUTTON_Q_YES' => $button_q_yes,
		'BUTTON_Q_NO' => $button_q_no,
		'BUTTON_C_YES' => $button_c_yes,
		'BUTTON_C_NO' => $button_c_no,
		'BUTTON_L_YES' => $button_l_yes,
		'BUTTON_L_NO' => $button_l_no,
		'BUTTON_IM_YES' => $button_im_yes,
		'BUTTON_IM_NO' => $button_im_no,
		'BUTTON_UR_YES' => $button_ur_yes,
		'BUTTON_UR_NO' => $button_ur_no,
		'BUTTON_CE_YES' => $button_ce_yes,
		'BUTTON_CE_NO' => $button_ce_no,
		'BUTTON_F_YES' => $button_f_yes,
		'BUTTON_F_NO' => $button_f_no,
		'BUTTON_S_YES' => $button_s_yes,
		'BUTTON_S_NO' => $button_s_no,
		'BUTTON_HI_YES' => $button_hi_yes,
		'BUTTON_HI_NO' => $button_hi_no,
		'COLOR_BOX_YES' => $color_box_yes,
		'COLOR_BOX_NO' => $color_box_no,
		'SIZE_BOX_YES' => $size_box_yes,
		'SIZE_BOX_NO' => $size_box_no,
		'GLOW_BOX_YES' => $glow_box_yes,
		'GLOW_BOX_NO' => $glow_box_no,
		'TOPIC_COLOR_YES' => $topic_color_yes,
		'TOPIC_COLOR_NO' => $topic_color_no,
		'TOPIC_COLOR_MOD_YES' => $topic_color_mod_yes,
		'TOPIC_COLOR_MOD_NO' => $topic_color_mod_no,
		'TOPIC_COLOR_ALL_YES' => $topic_color_all_yes,
		'TOPIC_COLOR_ALL_NO' => $topic_color_all_no,
		'EXPIRE_YES' => $expire_yes,
		'EXPIRE_NO' => $expire_no,
		'EXPIRE_V_YES' => $expire_v_yes,
		'EXPIRE_V_NO' => $expire_v_no,
		'FREAK_YES' => $freak_yes,
		'FREAK_NO' => $freak_no,
		'SPLIT_MESSAGES_EXCEPT' => $new['split_messages_except'],
		'RESTRICT_SMILIES_YES' => $restrict_smilies_yes,
		'RESTRICT_SMILIES_NO' => $restrict_smilies_no,
		'TOPIC_PREVIEW_YES' => $topic_preview_yes,
		'TOPIC_PREVIEW_NO' => $topic_preview_no,
		'NOT_ANONYMOUS_POSTING_YES' => $not_anonymous_posting_yes,
		'NOT_ANONYMOUS_POSTING_NO' => $not_anonymous_posting_no,
		'SPLIT_MESSAGES_YES' => $split_messages_yes,
		'SPLIT_MESSAGES_NO' => $split_messages_no,
		'SPLIT_MESSAGES_ADMIN_YES' => $split_messages_admin_yes,
		'SPLIT_MESSAGES_ADMIN_NO' => $split_messages_admin_no,
		'SPLIT_MESSAGES_MOD_YES' => $split_messages_mod_yes,
		'SPLIT_MESSAGES_MOD_NO' => $split_messages_mod_no,
		'ADMIN_HTML_YES' => $admin_html_yes,
		'ADMIN_HTML_NO' => $admin_html_no,
		'JR_ADMIN_HTML_YES' => $jr_admin_html_yes,
		'JR_ADMIN_HTML_NO' => $jr_admin_html_no,
		'MOD_HTML_YES' => $mod_html_yes,
		'MOD_HTML_NO' => $mod_html_no,
		'TITLE_EXPLAIN_YES' => $title_explain_yes,
		'TITLE_EXPLAIN_NO' => $title_explain_no,
		'S_HIDDEN_FIELDS' => '<input type="hidden" name="mode" value="posting">')
	);
}

if ( $mode == 'clear' )
{
	$sql = "DELETE FROM " . READ_HIST_TABLE . "";
	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Error in clear read history', '', __LINE__, __FILE__, $sql);
	}
	else
	{
		$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_board.$phpEx?mode=addons") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
		message_die(GENERAL_MESSAGE, $message);
	}
}

if ( $mode == 'repair' )
{
	$sql = "REPAIR TABLE " . READ_HIST_TABLE . "";
	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Error in repairing read history', '', __LINE__, __FILE__, $sql);
	}
	else
	{
		$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_board.$phpEx?mode=addons") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
		message_die(GENERAL_MESSAGE, $message);
	}
}

if ( $mode == 'warnings' )
{
	$sql = "SELECT *
		FROM " . CONFIG_TABLE ."
		WHERE config_name IN ('ban_warnings', 'write_warnings', 'warnings_mods_public', 'warnings_enable', 'mod_warnings', 'mod_edit_warnings', 'expire_warnings', 'mod_value_warning', 'viewtopic_warnings')";
	if (!$result = $db->sql_query($sql))
	{
		message_die(CRITICAL_ERROR, 'Could not query config information in admin_board', '', __LINE__, __FILE__, $sql);
	}
	else
	{
		while( $row = $db->sql_fetchrow($result) )
		{
			$config_name = $row['config_name'];
			$config_value = $row['config_value'];
			$default_config[$config_name] = isset($HTTP_POST_VARS['submit']) ? str_replace("'", "\'", $config_value) : $config_value;

			$war[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

			if ( isset($HTTP_POST_VARS['submit_warnings']))
			{
				$sql = "UPDATE " . CONFIG_TABLE . " SET
					config_value = '" . str_replace("\'", "''", $war[$config_name]) . "'
					WHERE config_name = '$config_name'";
				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Failed to update general configuration for ' . $config_name, '', __LINE__, __FILE__, $sql);
				}
			}
		}

		if ( isset($HTTP_POST_VARS['submit_warnings']) )
		{
			$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_board.$phpEx?mode=warnings") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

			message_die(GENERAL_MESSAGE, $message);
		}
	}

	require($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_warnings.' . $phpEx);

	$warnings_enable_yes = ( $war['warnings_enable']) ? $checked : '';
	$warnings_enable_no = ( !$war['warnings_enable']) ? $checked : '';
	$mod_warnings_yes = ( $war['mod_warnings']) ? $checked : '';
	$mod_warnings_no = ( !$war['mod_warnings']) ? $checked : '';
	$mod_edit_warnings_yes = ( $war['mod_edit_warnings']) ? $checked : '';
	$mod_edit_warnings_no = ( !$war['mod_edit_warnings']) ? $checked : '';
	$warnings_mods_public_yes = ( $war['warnings_mods_public']) ? $checked : '';
	$warnings_mods_public_no = ( !$war['warnings_mods_public']) ? $checked : '';
	$mod_value_warning = $war['mod_value_warning'];
	$write_warnings = $war['write_warnings'];
	$ban_warnings = $war['ban_warnings'];
	$expire_warnings = $war['expire_warnings'];
	$viewtopic_warnings_yes = ($new['viewtopic_warnings']) ? $checked : '';
	$viewtopic_warnings_no = (!$new['viewtopic_warnings']) ? $checked : '';

	$template->set_filenames(array(
		'body' => 'admin/warnings_config_body.tpl')
	);

	$template->assign_block_vars('warnings', array(
		'S_CONFIG_ACTION' => append_sid("admin_board.$phpEx"),
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_WARNINGS' => $lang['Warnings'],
		'L_WARNINGS_E' => $lang['Warnings_e'],
		'L_WARNINGS_ENABLE' => $lang['l_warnings_enable'],
		'L_MOD_WARNINGS' => $lang['l_mod_warnings'],
		'L_MOD_EDIT_WARNINGS' => $lang['l_mod_edit_warnings'],
		'L_MOD_VALUE_WARNING' => $lang['l_mod_value_warning'],
		'L_WRITE_WARNINGS' => $lang['l_write_warnings'],
		'L_WRITE_WARNINGS_E' => $lang['l_write_warnings_e'],
		'L_BAN_WARNINGS' => $lang['l_ban_warnings'],
		'L_BAN_WARNINGS_E' => $lang['l_ban_warnings_e'],
		'L_EXPIRE_WARNINGS' => $lang['l_expire_warnings'],
		'L_EXPIRE_WARNINGS_E' => $lang['l_expire_warnings_e'],
		'L_WARNINGS_MODS_PUBLIC' => $lang['l_warnings_mods_public'],
		'L_WARNINGS_MODS_PUBLIC_E' => $lang['l_warnings_mods_public_e'],
		'L_VIEWTOPIC_WARNINGS' => $lang['viewtopic_warnings'],

		'WARNING_ENABLE_YES' => $warnings_enable_yes,
		'WARNING_ENABLE_NO' => $warnings_enable_no,
		'MOD_WARNINGS_YES' => $mod_warnings_yes,
		'MOD_WARNINGS_NO' => $mod_warnings_no,
		'MOD_EDIT_WARNINGS_YES' => $mod_edit_warnings_yes,
		'MOD_EDIT_WARNINGS_NO' => $mod_edit_warnings_no,
		'WARNINGS_MODS_PUBLIC_YES' => $warnings_mods_public_yes,
		'WARNINGS_MODS_PUBLIC_NO' => $warnings_mods_public_no,
		'MOD_VALUE_WARNING' => $war['mod_value_warning'],
		'WRITE_WARNINGS' => $war['write_warnings'],
		'BAN_WARNINGS' => $war['ban_warnings'],
		'EXPIRE_WARNINGS' => $war['expire_warnings'],
		'VIEWTOPIC_WARNINGS_YES' => $viewtopic_warnings_yes,
		'VIEWTOPIC_WARNINGS_NO' => $viewtopic_warnings_no)
	);
}

$template->pparse('body');

include('./page_footer_admin.'.$phpEx);

?>