<?php
#########################################################
## Author: Niels Chr. Rd
## Nickname: Niels Chr. Denmark
## Email: ncr@db9.dk
## http://mods.db9.dk
##
## Ver 1.2.10
## Developed as a drop-in to phpBB2 ver 2.0.2
##
## phpBB2 drop-in mod, that checks for unused accounts for X days
## use the script while logged in as ADMIN, add the days=X as a extra parameter
##   e.g. www.yourdomain.com/delete_users.php?mode=not_login&days=10
## will delete all accounts who have never logged in and are older than 10 days 
##
## And zero postes
##   e.g. www.yourdomain.com/delete_users.php?mode=zero_poster&days=10
## will delete all accounts who have never posted and are older than 10 days 
##
## You can also delete specific users
##   e.g. www.yourdomain.com/delete_users.php?mode=user_name&del_user=Niels
##   or www.yourdomain.com/delete_users.php?mode=user_id&del_user=18
## Will delete a specific user either by name or by id, remember that is is NOT case sensetive
## if the user have posted, then his/her posts will be converted to posted by guest, and the users
## name wil still be showen
##
#########################################################

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['ACUsers']['      '] = $filename; //Space for JuniorAdmins

	return;
}

$phpbb_root_path = '../';
require($phpbb_root_path . 'extension.inc');
require('pagestart.' . $phpEx);

include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_prune_users2.' . $phpEx);

$del_user = ( isset($HTTP_POST_VARS['del_user']) ) ? intval($HTTP_POST_VARS['del_user']) : (( isset($HTTP_GET_VARS['del_user']) ) ? intval($HTTP_GET_VARS['del_user']):'');
$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : ( ( isset($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode']:'');
$days = ( isset($HTTP_POST_VARS['days']) ) ? intval($HTTP_POST_VARS['days']) : (( isset($HTTP_GET_VARS['days']) ) ? intval($HTTP_GET_VARS['days']):'');

// ******************************************************************************************
// Define you own modes here
	
switch ($mode)
{
	case 'user_name' :	$sql=' FROM '. USERS_TABLE .' WHERE username="'.str_replace("'","\'",$del_user).'"';break;

	case 'user_id' :		$sql=' FROM '. USERS_TABLE .' WHERE user_id="'.$del_user.'"';break;

	case 'prune_0' :	$mode ='Zero posters';
	case 'zero_poster' :	$sql=' FROM '. USERS_TABLE .' WHERE user_id<>"'.ANONYMOUS.'" AND user_posts="0" AND user_regdate<"'.(time()-(86400*$days)).'"';break;

	case 'prune_1' :	$mode ='Not logged in';
	case 'not_login': 	$sql=' FROM '. USERS_TABLE .' WHERE user_id<>"'.ANONYMOUS.'" AND user_lastvisit="0" AND user_regdate<"'.(time()-(86400*$days)).'"';break;

	case 'prune_2' :	$mode ='Not activated';
					$sql=' FROM '. USERS_TABLE .' WHERE user_id<>"'.ANONYMOUS.'" AND user_lastvisit="0" AND user_active="0" AND user_actkey<>"" AND user_regdate<"'.(time()-(86400*$days)).'"';break;

	case 'prune_3' : $mode='Long time visit';
					$sql = 'FROM '.USERS_TABLE .' WHERE user_id<>"'.ANONYMOUS.'" AND user_lastvisit<'.(time()-86400*60).' AND user_regdate<"'.(time()-(86400*$days)).'"';break; 

	case 'prune_4' : $mode='Avarage posts';
					$sql = 'FROM '.USERS_TABLE .' WHERE user_id<>"'.ANONYMOUS.'" AND user_posts/((user_lastvisit - user_regdate)/86400) < "0.1" AND user_regdate<"'.(time()-(86400*$days)).'"';break; 

	default:		message_die(GENERAL_ERROR, 'No mode specifyed', '', __LINE__, __FILE__);
}

// ******************************************************************************************
// Do not change anything below this line
//

if ( !$result = $db->sql_query('
	SELECT user_id , username, user_email, user_lang ' . $sql . '
	ORDER BY username LIMIT 800')
)
{
	message_die(GENERAL_ERROR, 'Error obtaining userdata', '', __LINE__, __FILE__, $sql);
}
$user_list = $db->sql_fetchrowset($result);

require($phpbb_root_path . 'includes/functions_remove.'.$phpEx);

$i = 0;
while (isset($user_list[$i]['user_id']))
{
	$user_id=$user_list[$i]['user_id'];
	$username = $user_list[$i]['username'];
	$user_email = $user_list[$i]['user_email'];
	$user_lang = $user_list[$i]['user_lang'];

	delete_user($user_id, $username);

	$name_list .= (($name_list) ? ' , ':'</br>') .$username;
	$i++;
}
$messages .= ((DEBUG) ? '':'').(($i) ? sprintf($lang['Prune_users_number'],$i).$name_list : $lang['Prune_no_users']);
message_die(GENERAL_MESSAGE, $messages); 

?>