<?php
/***************************************************************************
*                    $RCSfile: admin_jr_admin.php,v $
*                            -------------------
*   copyright            : (C) 2002-2003 Nivisec.com
*   email                : support@nivisec.com
*
*   $Id: admin_jr_admin.php,v 1.5 2003/08/15 02:09:36 nivisec Exp $
*
*
***************************************************************************/

/***************************************************************************
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
***************************************************************************/

define('IN_PHPBB', true);
define('MOD_VERSION', '2.0.3');
define('MOD_CODE', 1);
$phpbb_root_path = '../';
include($phpbb_root_path . 'extension.inc');
include_once($phpbb_root_path."includes/functions_jr_admin.$phpEx");

if (!empty($setmodules))
{
	$filename = basename(__FILE__);
	$module['ACUsers']['Jr_Admin'] = $filename;
	return;
}

require('./pagestart.' . $phpEx);

define('DISABLE_VERSION_CHECK', FALSE);

$debug = false;

$status_message = '';
define('UPDATE_MODULE_PREFIX', 'update_module_');
$update_find_pattern = "/^.+_".UPDATE_MODULE_PREFIX."/";

$params = array('mode' => '', 'user_id' => '', 'order' => 'ASC', 'sort_item' => 'username');
if ($debug)
{
	//Dump out the get and post vars if in debug mode
	echo '<pre><span  class="gensmall"><span style="color: blue">DEBUG - POST VARS -<br>';
	print_r($HTTP_POST_VARS);
	echo '</span><br>';
	echo '<span style="color: red">DEBUG - GET VARS -<br>';
	print_r($HTTP_GET_VARS);
	echo '</span><br></pre></span>';
}

foreach($params as $var => $default)
{
	$$var = $default;
	if( isset($HTTP_POST_VARS[$var]) || isset($HTTP_GET_VARS[$var]) )
	{
		$$var = ( isset($HTTP_POST_VARS[$var]) ) ? $HTTP_POST_VARS[$var] : $HTTP_GET_VARS[$var];
	}
}

if (count($HTTP_POST_VARS))
{
	foreach ($HTTP_POST_VARS as $key => $val)
	{
		if (preg_match("/^edit_user_/", $key))
		{
			$user_id = str_replace('edit_user_', '', $key);
		}
	}
}
$page_title = $lang['Jr_Admin'];
$page_desc = $lang['Permissions_Page_Desc'];

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if (!empty($user_id) && !isset($HTTP_POST_VARS['update_user']))
{
	$sql = "SELECT username, user_id, user_level  FROM " . USERS_TABLE . "
		WHERE user_id = $user_id
		ORDER BY username ASC";
	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, $lang['Error_User_Table'], '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);
	if ($debug)
	{
		//Dump out the get and post vars if in debug mode
		echo '<pre><span  class="gensmall"><span style="color: green">DEBUG - User Info -<br>';
		print_r($row);
		echo '</span><br></pre></span>';
	}
	$jr_admin_row = jr_admin_get_user_info($user_id);
	$module_list = jr_admin_get_module_list(true, '');
	$user_module_list = explode(EXPLODE_SEPERATOR_CHAR, $jr_admin_row['user_jr_admin']);
	if ($debug)
	{
		//Dump out the get and post vars if in debug mode
		echo '<pre><span  class="gensmall"><span style="color: purple">DEBUG - Modules -<br>';
		print_r($module_list);
		echo '</span><br>';
		echo '<span style="color: maroon">DEBUG - User Modules -<br>';
		print_r($user_module_list);
		echo '</span><br></pre></span>';
	}

	$i = $j = 0;
	foreach($module_list as $cat => $info_array)
	{
		$template->assign_block_vars('catrow', array(
			'CAT' => ($lang[$cat]) ? $lang[$cat] : $cat,
			'NUM' => $i)
		);
		foreach($info_array as $module_name => $file_array)
		{
			$file_hash = $file_array['file_hash'];
			$checked = (in_array($file_hash, $user_module_list)) ? 'checked="checked"' : '';
			if ( !eregi('admin_jr_admin', $file_array['filename']) && !eregi('xs_frameset', $file_array['filename']) )
			{
				$template->assign_block_vars('catrow.modulerow', array(
					'ROW' => ($j % 2) ? 'row1' : 'row2',
					'NAME' => ($lang[$module_name]) ? $lang[$module_name] : $module_name,
					'FILENAME' => $file_array['filename'],
					'FILE_HASH' => $file_hash,
					'CHECKED' => $checked)
				);
				$j++;
			}
		}
		$i++;
	}
	
	$template->assign_vars(array(
	'USER_ID' => $user_id,
	'USERNAME' => $row['username'],
	'START_DATE' => create_date($board_config['default_dateformat'], $jr_admin_row['start_date'], $board_config['board_timezone']),
	'UPDATE_DATE' => create_date($board_config['default_dateformat'], $jr_admin_row['update_date'], $board_config['board_timezone']),
	'NOTES' => $jr_admin_row['admin_notes'],
	'NOTES_VIEW_CHECKED' => ($jr_admin_row['notes_view']) ? 'checked="checked"' : '',
	'ADMIN_TEXT' => ($row['user_level'] == ADMIN) ? $lang['Admin_Note'] : ''
	));
	
	$template->set_filenames(array('body' => 'admin/jr_admin_user_permissions.tpl'));
}
else
{
	//Update info like module list and color groups
	if (isset($HTTP_POST_VARS['update_user']) && !empty($user_id))
	{
		$user_update_list = '';
		foreach ($HTTP_POST_VARS as $key => $val)
		{
			if (preg_match($update_find_pattern, $key))
			{
				$user_update_list .= (!empty($user_update_list)) ? EXPLODE_SEPERATOR_CHAR : '';
				$user_update_list .= preg_replace($update_find_pattern, '', $key);
			}
		}
		
		if (!jr_admin_user_exist($user_id))
		{
			//If the user_id doesn't exist in the table, we need to add it
			//before we can update!
			sql_query_nivisec(
			'INSERT INTO ' . JR_ADMIN_TABLE . "
			(user_id, start_date) VALUES ($user_id, " . time() . ')',
			$lang['Error_Module_Table']
			);
		}
		
		$notes_view = (isset($HTTP_POST_VARS['notes_view'])) ? 1 : 0;
		$admin_notes = $HTTP_POST_VARS['admin_notes'];
		
		//Do the information update
		$sql = 'UPDATE ' . JR_ADMIN_TABLE . "
			SET user_jr_admin = '$user_update_list',
			update_date = " . time() . ",
			admin_notes = '$admin_notes',
			notes_view = $notes_view
			WHERE user_id = $user_id";
		if (!$db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, $lang['Error_User_Table'], '', __LINE__, __FILE__, $sql);
		}
		$status_message .= $lang['Updated_Permissions'];
	}
	
	//No user_id was found or we are done updating, take them to the info page
	$current_letter = ''; //for alpha links
	$assigned_current_letter_link = false; //for alpha links
	$letter_list = array(); //hold letters

	if ($HTTP_POST_VARS['jr'])
	{
		$sql = "SELECT u.username, u.user_id, j.user_id, j.user_jr_admin
			FROM " . USERS_TABLE . " u, " . JR_ADMIN_TABLE . " j
			WHERE u.user_id = j.user_id
			AND j.user_jr_admin != ''
			AND u.user_id <> " . ANONYMOUS . "
			ORDER BY u.username";
		if (!$result = $db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, $lang['Error_User_Table'], '', __LINE__, __FILE__, $sql);
		}
	}
	else
	{
		$sql = "SELECT username, user_id
			FROM " . USERS_TABLE . "
			WHERE user_id <> " . ANONYMOUS . "
			ORDER BY $sort_item LIMIT $start, 200";
		if (!$result = $db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, $lang['Error_User_Table'], '', __LINE__, __FILE__, $sql);
		}
	}

	while ($row = $db->sql_fetchrow($result))
	{
		$test_letter = strtoupper(substr($row['username'], 0, 1));
		if ($test_letter != $current_letter)
		{
			//If we have a new letter, get it here.
			$current_letter = $test_letter;
			$assigned_current_letter_link = false;
			$letter_list[ord($current_letter)] = true;
		}
		
		$jr_admin_row = jr_admin_get_user_info($row['user_id']);
		$module_count = (!empty($jr_admin_row['user_jr_admin'])) ? count(explode(EXPLODE_SEPERATOR_CHAR, $jr_admin_row['user_jr_admin'])) : 0;
		$is_jr = (!empty($jr_admin_row['user_jr_admin'])) ? 1 : 0;
		$block_text = 'userrow';
		
		$template->assign_block_vars($block_text, array(
		'NAME' => ($is_jr) ? '<span style="color: red">' . $row['username'] . '</span>' : $row['username'],
		'ID' => $row['user_id'],
		'ROW_CLASS' => ($i++ % 2) ? 'row1' : 'row2',
		'BOOKMARK' => (!$assigned_current_letter_link) ? '<a name="'.$current_letter.'">' : '',
		'BOOKMARK_END' => (!$assigned_current_letter_link) ? '</a>' : '',
		'MODULE_COUNT' => ($module_count != 0) ? sprintf($lang['Modules_Owned'], $module_count) : ''
		));
		
		//We 'know' we assigned it if it wasn't already now
		$assigned_current_letter_link = true;
		
	}
	
	//Make sort image choice and sorting links
	$base_order = ($order == 'ASC') ? 'order=DESC' : 'order=ASC';
	$base_filename = append_sid(basename(__FILE__) . '?' . $base_order);
	$desc_img = '<img src="'.$phpbb_root_path.$lang['DESC_Image'].'" border="0">';
	$asc_img = '<img src="'.$phpbb_root_path.$lang['ASC_Image'].'" border="0">';
	$template->assign_vars(array(
	'S_USERNAME' => $base_filename . '&amp;sort_item=username',
	));
	
	if ($sort_item == 'username')
	{
		$template->assign_var('LETTER_HEADING', jr_admin_make_bookmark_heading($letter_list));
	}
	
	$template->set_filenames(array('body' => 'admin/jr_admin_user_list.tpl'));
}
//Common Variables
$template->assign_vars(array(
'L_SHOW_JR' => $lang['show_jr'],
'S_ACTION' => append_sid(basename(__FILE__)),
'S_USER_PERM' => append_sid('admin_ug_auth.'.$phpEx),
'S_PROFILE' => append_sid($phpbb_root_path.'profile.'.$phpEx),
'S_MANAGEMENT' => append_sid('admin_users.'.$phpEx),
'S_USER_POST_URL' => POST_USERS_URL,
'L_NONE' => $lang['None'],
'L_ALLOW' => $lang['Allow_Access'],
'L_VERSION' => $lang['Version'],
'L_PAGE_NAME' => $page_title,
'L_PAGE_DESC' => $page_desc,
'MOD_NUMBER' => MOD,
'VERSION' => MOD_VERSION,
'L_USERS_W_ACCESS' => $lang['Users_with_Access'],
'L_USERS_WOUT_ACCESS' => $lang['Users_without_Access'],
'L_MODULE_COUNT' => $lang['Module_Count'],
'L_EDIT' => $lang['Edit'],
'L_UPDATE' => $lang['Update'],
'L_SUBMIT' => $lang['Submit'],
'L_RESET' => $lang['Reset'],
'L_EXAMPLE' => $lang['Example'],
'L_MODULE_INFO' => $lang['Module_Info'],
'L_CHECK_ALL_IN_CAT' => $lang['Cat_Check_All'],
'L_CHECK_ALL' => $lang['Check_All'],
'L_OPTIONS' => $lang['Options'],
'L_EDIT_PERMISSIONS' => $lang['Edit_Permissions'],
'L_VIEW_PROFILE' => $lang['View_Profile'],
'L_EDIT_USER_DETAILS' => $lang['Edit_User_Details'],
'L_NOTES' => $lang['Notes'],
'L_ALLOW_VIEW' => $lang['Allow_View'],
'L_START_DATE' => $lang['Start_Date'],
'L_UPDATE_DATE' => $lang['Update_Date'],
'L_USERNAME' => $lang['Username'],
'L_EDIT_LIST' => $lang['Edit_Modules'],
'L_USER_STATS' => $lang['User_Stats'],
'L_USER_INFO' => $lang['User_Info'],
'L_ADMIN_NOTES' => $lang['Admin_Notes']
));

if ($status_message != '')
{
	$template->assign_block_vars('statusrow', array());
	$template->assign_vars(array(
	'L_STATUS' => $lang['Status'],
	'I_STATUS_MESSAGE' => $status_message)
	);
}

if (file_exists(@phpbb_realpath($phpbb_root_path.'nivisec_version_check.'.$phpEx) && !DISABLE_VERSION_CHECK))
{
	include($phpbb_root_path.'nivisec_version_check.'.$phpEx);
}

$sql = "SELECT count(user_id) AS total
	FROM " . USERS_TABLE . "
	WHERE user_id <> " . ANONYMOUS;

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
}

if ( $total = $db->sql_fetchrow($result) )
{
	$total_members = $total['total'];
	$pagination = generate_pagination(append_sid(basename(__FILE__)), $total_members, 50, $start). '&nbsp;';
}

$page_number = sprintf($lang['Page_of'], ( floor( $start / 50 ) + 1 ), ceil( $total_members / 50 ));
if ( ceil( $total_members / 50 ) == 1 )
{
	$page_number = '';
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => $page_number,

	'L_GOTO_PAGE' => $lang['Goto_page'])
);


$template->pparse('body');
copyright_nivisec($page_title, '2002-2003');
include('page_footer_admin.'.$phpEx);

?>