<?php
/***************************************************************************
 *
 *                          admin_user_ban.php
 *                            -------------------
 *   begin                : Tuesday, Mar 17, 2003
 *   copyright            : (C) 2003 Wooly Spud
 *   email                : phpbb@xgmag.com
 *
 *   $Id: admin_user_ban.php,v 1.1.2 2003/05/09 03:48:00 woolyspud Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if ( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['ACUsers']['  '] = $filename; //Space for JuniorAdmins

	return;
}

//
// Load default header
//

$phpbb_root_path = './../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

//
// Set Overall Variables
//

if(isset($HTTP_POST_VARS['view_sort']) && isset($HTTP_POST_VARS['view_direction']))
	{
		$start = 0;
		$sort = $HTTP_POST_VARS['view_sort'];

		if($HTTP_POST_VARS['view_direction'] == "ASC")
			{
				$direc = "ASC";
				$asc_sel = " selected";
			}
		elseif($HTTP_POST_VARS['view_direction'] == "DESC")
			{
				$direc = "DESC";
				$dec_sel = " selected";
			}
		else
			{
				$direc = "ASC";
			}

	}
elseif(isset($HTTP_GET_VARS['mode']) && isset($HTTP_GET_VARS['order']) && isset($HTTP_GET_VARS['start']) && !isset($HTTP_POST_VARS['view_sort']) && !isset($HTTP_POST_VARS['view_direction']))
	{
		$start = $HTTP_GET_VARS['start'];
		$sort =  $HTTP_GET_VARS['mode'];
		$direc = $HTTP_GET_VARS['order'];
	}

if(isset($HTTP_POST_VARS['ban_reason']) && $HTTP_POST_VARS['ban_reason'] != "")
	{
		$add_reason = "'".$HTTP_POST_VARS['ban_reason']."'";
	}
else
	{
		$add_reason = "NULL";
	}

if(!isset($start))
	{
		$start = "0";
	}

$mass_unban_sql_front = "DELETE FROM " . BANLIST_TABLE . " WHERE ban_id = 0";

// Determine Proper SQL Statements and redy for retain sort.
if(!isset($sort) || $sort == "username") // User and Default Sort
	{
		$username_sel = " selected";
		$nums_sql = "SELECT * FROM " . BANLIST_TABLE . " WHERE ban_userid != 0";
		$data_sql = "SELECT * FROM " . BANLIST_TABLE . " WHERE ban_userid != 0 ORDER BY ban_id $direc LIMIT $start, " . $board_config['topics_per_page'];
	}
elseif($sort == "email") // Email Sort
	{
		$email_sel = " selected";
		$nums_sql = "SELECT * FROM " . BANLIST_TABLE . " WHERE ban_userid = 0 AND ban_email IS NOT NULL";
		$data_sql = "SELECT * FROM " . BANLIST_TABLE . " WHERE ban_userid = 0 AND ban_email IS NOT NULL ORDER BY ban_id $direc LIMIT $start, " . $board_config['topics_per_page'];
	}
elseif($sort == "ip") // IP Sort
	{
		$ip_sel = " selected";
		$nums_sql = "SELECT * FROM " . BANLIST_TABLE . " WHERE ban_userid = 0 AND ban_email IS NULL";
		$data_sql = "SELECT * FROM " . BANLIST_TABLE . " WHERE ban_userid = 0 AND ban_email IS NULL ORDER BY ban_id $direc LIMIT $start, " . $board_config['topics_per_page'];
	}
elseif($sort == "all") // Sort Show All
	{
		$all_sel = " selected";
		$nums_sql = "SELECT * FROM " . BANLIST_TABLE;
		$data_sql = "SELECT * FROM " . BANLIST_TABLE . " ORDER BY ban_id $direc LIMIT $start, " . $board_config['topics_per_page'];
	}


//
// Functions
//

// Gets user data for fetched data. (Fixed Incompatability with DBAL)
if ( !(function_exists('fetch_user_info')) )
{
	function fetch_user_info($ban_field,$ban_value)
	{
		global $db;
		global $user_info_results;
		$fui_sql = "SELECT * FROM " . USERS_TABLE . " WHERE $ban_field = '" . $ban_value . "' LIMIT 0,1";
		$user_info_results = $db->sql_query($fui_sql);
		@$user_info_results = $db->sql_fetchrow($user_info_results);

		// NOTE: @ supresses errors if this doesnt return data which is ok because we address
		//       Issues with non returned values when they are needed.
	}
}

//
// Start program
//

if(isset($HTTP_GET_VARS['newmode'])) // For view and edit modes
	{
		$newmode = $HTTP_GET_VARS['newmode'];
		$id = $HTTP_GET_VARS['id'];

		if($newmode == "viewreason") // View Mode
			{
				$data_sql = "SELECT * FROM " . BANLIST_TABLE . " Where ban_id = " . $id . " LIMIT 1";

				// Get results to be used to return ban information
				$data_results = $db->sql_query($data_sql)
				or message_die(GENERAL_ERROR, 'Unable to Query Data. Line 148');

				for($i = 0; $row = $db->sql_fetchrow($data_results); $i++)
					{
						$reason = $row[ban_reason];
						$reason = str_replace ( "\n","<br>",$reason);
						$ban_time = create_date($board_config['default_dateformat'], $row[ban_time], $board_config['board_timezone']);
						message_die(GENERAL_MESSAGE, "<p align=left><b>Banned:</b> $ban_time by <b>$row[ban_by]</b> <br /><b>Reason:</b><br /><br />$reason</p>");
					}
			}
		elseif($newmode == "editban") // Edit Mode
			{
				$template->set_filenames(array('body' => 'admin/user_banlist_edit.tpl'));
				$id = $HTTP_GET_VARS['id'];
				$data_sql = "SELECT * FROM " . BANLIST_TABLE . " Where ban_id = " . $id . " LIMIT 1";
				$data_results = $db->sql_query($data_sql)
				or message_die(GENERAL_ERROR, 'Unable to Query Data. Line 164');

				for($i = 0; $row = $db->sql_fetchrow($data_results); $i++)
					{
						$reason = $row[ban_reason];
						$template->assign_vars(array(
								'EDIT_SQL_BEGIN' => "UPDATE " . BANLIST_TABLE ." SET `ban_reason`= '",
								'EDIT_SQL_END' => "' WHERE `ban_id`='".$id."'",
								'REASON' => $reason,
								'BAN_ID' => $id,
								'L_BULM_EDIT_TITLE' => $lang['BULM_Edit_Title'],
								'L_BULM_UPDATE_TITLE' => $lang['BULM_Update_Title'],
								'L_BULM_EDIT_DESCRIPT' => $lang['BULM_Edit_Desc'],
								'L_SUBMIT' => $lang['Submit'],
								'L_REASON' => $lang['BM_reasons'],
								'L_BAN_REASON_EXPLAIN' => $lang['BULM_reason_explain'],
								'S_BANLIST_ACTION' => append_sid("admin_user_ban.$phpEx")
								));
					}
			}
	}
else // For regular mode
	{
		$template->set_filenames(array('body' => 'admin/user_ban_body.tpl'));

		// Run Mass Unban SQL Statement if passed.
		if(isset($HTTP_POST_VARS['runsql']))
			{
				$db->sql_query($HTTP_POST_VARS['runsql']);
			}

		// Update ban reason if passed
		if(isset($HTTP_POST_VARS['updatebanreason']))
			{
				$id = $HTTP_POST_VARS['ban_id'];
				$updatebanreasonhold = $HTTP_POST_VARS['ban_reason'];
				$updatebanreason = "UPDATE " . BANLIST_TABLE ." SET `ban_reason`= '" . $updatebanreasonhold . "' WHERE `ban_id`='".$id."'";
				$db->sql_query($updatebanreason);
			}

		// Get results to be used to return total record numbers
		$nums_results = $db->sql_query($nums_sql)
		or message_die(GENERAL_ERROR, 'Unable to Query Data. Line 206');

		// Get results to be used to return ban information
		$data_results = $db->sql_query($data_sql)
		or message_die(GENERAL_ERROR, 'Unable to Query Data. Line 210');

		// Gets total number of records for pagination purposes
		$total_records = $db->sql_numrows($nums_results)
		or $template->assign_block_vars('switch_nobans', array()); // Turn on no bans message.

		// Should we Paginate?
		if($total_records > $board_config['topics_per_page'])
			{
				$template->assign_block_vars('switch_paginate', array());
			}

		// Fill the Rows
		for($i = 0; $row = $db->sql_fetchrow($data_results); $i++)
			{
				$ban_id = $row[ban_id];

				if(!isset($row[ban_reason]))
					{
						$ban_reason = "<b>-</b>";
					}
				else
					{
						$ban_reason = "<a href=\"javascript:void(0);\" onClick=\"window.open('" . append_sid("admin_user_ban.$phpEx?newmode=viewreason&amp;id=" . $ban_id) . "','ban_reason','scrollbars=yes,width=540,height=450')\">$lang[BULM_Show]</a>";
					}

				if(!isset($row[ban_by]))
					{
						$ban_by = '<center>-</center>';
					}
				else
					{
						$ban_by = $row[ban_by];
					}

				if(!isset($row[ban_time]))
					{
						$ban_time = '<center>-</center>';
					}
				else
					{
						$ban_time = create_date($board_config['default_dateformat'], $row[ban_time], $board_config['board_timezone']);
					}

				if($row[ban_userid] == 0 && $row[ban_email] == NULL)
					{
						$username = '<center>-</center>';
						$email = '<center>-</center>';
						$ip = decode_ip($row[ban_ip]);
						$posts = '-';
						$lastvisit = '-';
					}
				elseif($row[ban_userid] != 0)
					{
						fetch_user_info('user_id ',$row[ban_userid]);
						$username = $user_info_results[username];
						$email = $user_info_results[user_email];
						$ip = "-";
						$posts = $user_info_results[user_posts];
						$lastvisit = create_date($board_config['default_dateformat'], $user_info_results[user_lastvisit], $board_config['board_timezone']);
					}
				elseif($row[ban_userid] == 0 && $row[ban_email] != NULL)
					{
						fetch_user_info('user_email', $row[ban_email]);
						$email = $row[ban_email];
						$ip = '-';

						if(isset($user_info_results[username]))
							{
								$username = $user_info_results[username];
							}
						else
							{
								$username = "<center>-</center>";
							}

						if(isset($user_info_results[user_posts]))
							{
								$posts = $user_info_results[user_posts];
							}
						else
							{
								$posts = "-";
							}

						if(isset($user_info_results[user_lastvisit]))
							{
								$lastvisit = create_date($board_config['default_dateformat'], $user_info_results[user_lastvisit], $board_config['board_timezone']);
							}
						else
							{
								$lastvisit = "-";
							}
					}

				$template->assign_block_vars('rowlist', array(
					'USER_NAME' => $username,
					'EMAIL_ADDY' => $email,
					'IP_ADDY' => $ip,
					'POSTS' => $posts,
					'LAST_VISIT' => $lastvisit,
					'BAN_ID' => $ban_id,
					'BAN_TIME' => $ban_time,
					'BAN_EDIT' => "<center><a href=" . append_sid("admin_user_ban.$phpEx?newmode=editban&amp;id=" . $ban_id) . ">$lang[Update]</a></center>",
					'BAN_REASON' => $ban_reason,
					'BAN_BY' => $ban_by
					));

				$template->assign_block_vars('jscript_mass_unban', array(
					'BAN_ID' => $ban_id
					));
			}

		//
		// Pagination handler
		//

		$pagination = generate_pagination("admin_user_ban.$phpEx?mode=$sort&amp;order=$direc", $total_records, $board_config['topics_per_page'], $start). '&nbsp;';

		//
		// Code for Banning Users (by phpBB Group) Edited for our use.
		//

		if ( isset($HTTP_POST_VARS['submit']) )
			{
				$user_bansql = '';
				$email_bansql = '';
				$ip_bansql = '';
				$user_list = array();

				if ( !empty($HTTP_POST_VARS['username']) )
					{
						$this_userdata = get_userdata($HTTP_POST_VARS['username']);

						if( !$this_userdata )
							{
								message_die(GENERAL_MESSAGE, $lang['No_user_id_specified'] );
							}

						$user_list[] = $this_userdata['user_id'];
					}

				$ip_list = array();

				if ( isset($HTTP_POST_VARS['ban_ip']) )
					{
						$ip_list_temp = explode(',', $HTTP_POST_VARS['ban_ip']);

						for($i = 0; $i < count($ip_list_temp); $i++)
							{

								if ( preg_match('/^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})[ ]*\-[ ]*([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$/', trim($ip_list_temp[$i]), $ip_range_explode) )
									{
										//
										// Don't ask about all this, just don't ask ... !
										//
										$ip_1_counter = $ip_range_explode[1];
										$ip_1_end = $ip_range_explode[5];

										while ( $ip_1_counter <= $ip_1_end )
											{
												$ip_2_counter = ( $ip_1_counter == $ip_range_explode[1] ) ? $ip_range_explode[2] : 0;
												$ip_2_end = ( $ip_1_counter < $ip_1_end ) ? 254 : $ip_range_explode[6];

												if ( $ip_2_counter == 0 && $ip_2_end == 254 )
													{
														$ip_2_counter = 255;
														$ip_2_fragment = 255;
														$ip_list[] = encode_ip("$ip_1_counter.255.255.255");
													}

												while ( $ip_2_counter <= $ip_2_end )
													{
														$ip_3_counter = ( $ip_2_counter == $ip_range_explode[2] && $ip_1_counter == $ip_range_explode[1] ) ? $ip_range_explode[3] : 0;
														$ip_3_end = ( $ip_2_counter < $ip_2_end || $ip_1_counter < $ip_1_end ) ? 254 : $ip_range_explode[7];

														if ( $ip_3_counter == 0 && $ip_3_end == 254 )
															{
																$ip_3_counter = 255;
																$ip_3_fragment = 255;
																$ip_list[] = encode_ip("$ip_1_counter.$ip_2_counter.255.255");
															}

														while ( $ip_3_counter <= $ip_3_end )
															{
																$ip_4_counter = ( $ip_3_counter == $ip_range_explode[3] && $ip_2_counter == $ip_range_explode[2] && $ip_1_counter == $ip_range_explode[1] ) ? $ip_range_explode[4] : 0;
																$ip_4_end = ( $ip_3_counter < $ip_3_end || $ip_2_counter < $ip_2_end ) ? 254 : $ip_range_explode[8];

																if ( $ip_4_counter == 0 && $ip_4_end == 254 )
																	{
																		$ip_4_counter = 255;
																		$ip_4_fragment = 255;
																		$ip_list[] = encode_ip("$ip_1_counter.$ip_2_counter.$ip_3_counter.255");
																	}

																while ( $ip_4_counter <= $ip_4_end )
																	{
																		$ip_list[] = encode_ip("$ip_1_counter.$ip_2_counter.$ip_3_counter.$ip_4_counter");
																		$ip_4_counter++;
																	}
																$ip_3_counter++;
															}
														$ip_2_counter++;
													}
												$ip_1_counter++;
											}
									}
								else if ( preg_match('/^([\w\-_]\.?){2,}$/is', trim($ip_list_temp[$i])) )
									{
										$ip = gethostbynamel(trim($ip_list_temp[$i]));

										for($j = 0; $j < count($ip); $j++)
											{
												if ( !empty($ip[$j]) )
													{
														$ip_list[] = encode_ip($ip[$j]);
													}
											}
									}
								else if ( preg_match('/^([0-9]{1,3})\.([0-9\*]{1,3})\.([0-9\*]{1,3})\.([0-9\*]{1,3})$/', trim($ip_list_temp[$i])) )
									{
										$ip_list[] = encode_ip(str_replace('*', '255', trim($ip_list_temp[$i])));
									}
							}
					}

				$email_list = array();

				if ( isset($HTTP_POST_VARS['ban_email']) )
					{
						$email_list_temp = explode(',', $HTTP_POST_VARS['ban_email']);

						for($i = 0; $i < count($email_list_temp); $i++)
							{
								//
								// This ereg match is based on one by php@unreelpro.com
								// contained in the annotated php manual at php.com (ereg
								// section)
								//

								if (preg_match('#^(([a-z0-9&.-_+])|(\*))+@[a-z0-9\-]+\.([a-z0-9\-]+\.)*?[a-z]+$#is', trim($email_list_temp[$i])))
								{
									$email_list[] = trim($email_list_temp[$i]);
								}
							}
					}

				$sql = "SELECT * FROM " . BANLIST_TABLE;

				if ( !($result = $db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, "Couldn't obtain banlist information", "", __LINE__, __FILE__, $sql);
					}

				$current_banlist = $db->sql_fetchrowset($result);
				$db->sql_freeresult($result);
				$kill_session_sql = '';

				for($i = 0; $i < count($user_list); $i++)
					{
						$in_banlist = false;

						for($j = 0; $j < count($current_banlist); $j++)
							{

								if ( $user_list[$i] == $current_banlist[$j]['ban_userid'] )
									{
										$in_banlist = true;
									}
							}

						if ( !$in_banlist )
							{
								$kill_session_sql .= ( ( $kill_session_sql != '' ) ? ' OR ' : '' ) . "session_user_id = " . intval($user_list[$i]);

								$sql = "INSERT INTO " . BANLIST_TABLE . " (ban_userid, ban_time, ban_by, ban_reason) VALUES (" . $user_list[$i] . ", '" . time() . "', '" . $userdata['username'] . "'," . $add_reason . ")";

								if ( !$db->sql_query($sql) )
									{
										message_die(GENERAL_ERROR, "Couldn't insert ban_userid info into database", "", __LINE__, __FILE__, $sql);
									}
							}
					}

				for($i = 0; $i < count($ip_list); $i++)
					{
						$in_banlist = false;

						for($j = 0; $j < count($current_banlist); $j++)
							{

								if ( $ip_list[$i] == $current_banlist[$j]['ban_ip'] )
									{
										$in_banlist = true;
									}
							}

						if ( !$in_banlist )
							{

								if ( preg_match('/(ff\.)|(\.ff)/is', chunk_split($ip_list[$i], 2, '.')) )
									{
										$kill_ip_sql = "session_ip LIKE '" . str_replace('.', '', preg_replace('/(ff\.)|(\.ff)/is', '%', chunk_split($ip_list[$i], 2, "."))) . "'";
									}
								else
									{
										$kill_ip_sql = "session_ip = '" . $ip_list[$i] . "'";
									}

								$kill_session_sql .= ( ( $kill_session_sql != '' ) ? ' OR ' : '' ) . $kill_ip_sql;

								$sql = "INSERT INTO " . BANLIST_TABLE . " (ban_ip, ban_time, ban_by, ban_reason) VALUES ('" . $ip_list[$i] . "', '" . time() . "', '" . $userdata['username'] . "'," . $add_reason . ")";

								if ( !$db->sql_query($sql) )
									{
										message_die(GENERAL_ERROR, "Couldn't insert ban_ip info into database", "", __LINE__, __FILE__, $sql);
									}
							}
					}

				//
				// Now we'll delete all entries from the session table with any of the banned
				// user or IP info just entered into the ban table ... this will force a session
				// initialisation resulting in an instant ban
				//

				if ( $kill_session_sql != '' )
					{
						$sql = "DELETE FROM " . SESSIONS_TABLE . "
						WHERE $kill_session_sql";

						if ( !$db->sql_query($sql) )
							{
								message_die(GENERAL_ERROR, "Couldn't delete banned sessions from database", "", __LINE__, __FILE__, $sql);
							}
					}

				for($i = 0; $i < count($email_list); $i++)
					{
						$in_banlist = false;
						for($j = 0; $j < count($current_banlist); $j++)
							{

								if ( $email_list[$i] == $current_banlist[$j]['ban_email'] )
									{
										$in_banlist = true;
									}
							}

						if ( !$in_banlist )
							{
								$sql = "INSERT INTO " . BANLIST_TABLE . " (ban_email, ban_time, ban_by, ban_reason)
									VALUES ('" . str_replace("\'", "''", $email_list[$i]) . "', '" . time() . "', '" . $userdata['username'] . "'," . $add_reason . ")";

								if ( !$db->sql_query($sql) )
									{
										message_die(GENERAL_ERROR, "Couldn't insert ban_email info into database", "", __LINE__, __FILE__, $sql);
									}
							}
					}

				$where_sql = '';

				$message = $lang['Ban_update_sucessful'] . '<br /><br />' . sprintf($lang['Click_return_banadmin'], '<a href="' . append_sid("admin_user_ban.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

				message_die(GENERAL_MESSAGE, $message);

			}
		else
			{

				$template->assign_vars(array(
					'L_BAN_TITLE' => $lang['BULM_Title'],
					'L_BAN_EXPLAIN' => $lang['BM_Explain'],
					'L_BAN_EXPLAIN_WARN' => $lang['Ban_explain_warn'],
					'L_IP_OR_HOSTNAME' => $lang['IP_hostname'],
					'L_EMAIL_ADDRESS' => $lang['Email_address'],
					'L_SUBMIT' => $lang['Submit'],
					'L_RESET' => $lang['Reset'],

					'S_BANLIST_ACTION' => append_sid("admin_user_ban.$phpEx"))
					);

				$template->assign_vars(array(
					'L_BAN_USER' => $lang['Ban_username'],
					'L_BAN_USER_EXPLAIN' => $lang['Ban_username_explain'],
					'L_BAN_IP' => $lang['Ban_IP'],
					'L_BAN_IP_EXPLAIN' => $lang['Ban_IP_explain'],
					'L_BAN_EMAIL' => $lang['Ban_email'],
					'L_BAN_EMAIL_EXPLAIN' => $lang['Ban_email_explain'])
					);

				$userban_count = 0;
				$ipban_count = 0;
				$emailban_count = 0;

				$sql = "SELECT b.ban_id, u.user_id, u.username
					FROM " . BANLIST_TABLE . " b, " . USERS_TABLE . " u
					WHERE u.user_id = b.ban_userid
					AND b.ban_userid <> 0
					AND u.user_id <> " . ANONYMOUS . "
					ORDER BY u.user_id ASC";

				if ( !($result = $db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Could not select current user_id ban list', '', __LINE__, __FILE__, $sql);
					}

				$user_list = $db->sql_fetchrowset($result);
				$db->sql_freeresult($result);

				$select_userlist = '';

				for($i = 0; $i < count($user_list); $i++)
					{
						$select_userlist .= '<option value="' . $user_list[$i]['ban_id'] . '">' . $user_list[$i]['username'] . '</option>';
						$userban_count++;
					}

				if( $select_userlist == '' )
					{
						$select_userlist = '<option value="-1">' . $lang['No_banned_users'] . '</option>';
					}

				$select_userlist = '<select name="unban_user[]" multiple="multiple" size="5">' . $select_userlist . '</select>';

				$sql = "SELECT ban_id, ban_ip, ban_email FROM " . BANLIST_TABLE;

				if ( !($result = $db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Could not select current ip ban list', '', __LINE__, __FILE__, $sql);
					}

				$banlist = $db->sql_fetchrowset($result);
				$db->sql_freeresult($result);

				$select_iplist = '';
				$select_emaillist = '';

				for($i = 0; $i < count($banlist); $i++)
					{
						$ban_id = $banlist[$i]['ban_id'];

						if ( !empty($banlist[$i]['ban_ip']) )
							{
								$ban_ip = str_replace('255', '*', decode_ip($banlist[$i]['ban_ip']));
								$select_iplist .= '<option value="' . $ban_id . '">' . $ban_ip . '</option>';
								$ipban_count++;
							}
						else if ( !empty($banlist[$i]['ban_email']) )
							{
								$ban_email = $banlist[$i]['ban_email'];
								$select_emaillist .= '<option value="' . $ban_id . '">' . $ban_email . '</option>';
								$emailban_count++;
							}
					}

				if ( $select_iplist == '' )
					{
						$select_iplist = '<option value="-1">' . $lang['No_banned_ip'] . '</option>';
					}

				if ( $select_emaillist == '' )
					{
						$select_emaillist = '<option value="-1">' . $lang['No_banned_email'] . '</option>';
					}

				$select_iplist = '<select name="unban_ip[]" multiple="multiple" size="5">' . $select_iplist . '</select>';
				$select_emaillist = '<select name="unban_email[]" multiple="multiple" size="5">' . $select_emaillist . '</select>';

				$template->assign_vars(array(
					'L_UNBAN_USER' => $lang['Unban_username'],
					'L_UNBAN_USER_EXPLAIN' => $lang['Unban_username_explain'],
					'L_UNBAN_IP' => $lang['Unban_IP'],
					'L_UNBAN_IP_EXPLAIN' => $lang['Unban_IP_explain'],
					'L_UNBAN_EMAIL' => $lang['Unban_email'],
					'L_UNBAN_EMAIL_EXPLAIN' => $lang['Unban_email_explain'],
					'L_USERNAME' => $lang['Username'],
					'L_LOOK_UP' => $lang['Look_up_User'],
					'L_FIND_USERNAME' => $lang['Find_username'],

					'U_SEARCH_USER' => append_sid("./../search.$phpEx?mode=searchuser"),
					'S_UNBAN_USERLIST_SELECT' => $select_userlist,
					'S_UNBAN_IPLIST_SELECT' => $select_iplist,
					'S_UNBAN_EMAILLIST_SELECT' => $select_emaillist,
					'S_BAN_ACTION' => append_sid("admin_user_ban.$phpEx"))
					);
			}

		//
		// Additional Variable Handling
		//

		$template->assign_vars(array(
			'L_BULM_TITLE' => $lang['BULM_Title'],
			'L_BULM_DESCRIPT' => $lang['BULM_Desc'],
			'L_BULM_SORTBY' => $lang['Sort_by'],
			'L_BAN_NEW_USERS' => $lang['BULM_ban_new_user'],
			'L_BULM_SHOW' => $lang['BM_Show'],
			'L_SORT' => $lang['Order'],
			'L_FUNCTIONS' => $lang['BULM_Functions'],
			'L_BULM_FUNBAN_EXPLAIN' => $lang['BULM_funban_explain'],
			'L_BULM_FUNBAN_TXT' => $lang['BULM_funban_txt'],
			'L_BULM_FNEWBAN_EXPLAIN' => $lang['BULM_fnewban_explain'],
			'L_BULM_FNEWBAN_TXT' => $lang['BULM_fnewban_txt'],
			'L_REASON' => $lang['BM_reasons'],
			'L_BY' => $lang['BM_By'],
			'L_EMAIL' => $lang['Email'],
			'L_LAST_VISIT' => $lang['Last_visit'],
			'L_POSTS' => $lang['posts'],
			'L_BANNED' => $lang['BM_Add_a_new_ban'],
			'L_USERNAME' => $lang['Username'],
			'L_IP' => 'IP',
			'L_ALL' => $lang['BM_All'],
			'L_ASSCEND' => $lang['Sort_Ascending'],
			'L_DESCEND' => $lang['Sort_Descending'],
			'L_BAN_REASON_EXPLAIN' => $lang['BULM_reason_explain'],
			'L_MAIN_BANLIST' => $lang['BM_All'],

			'MAIN_BANLIST' => append_sid("admin_user_banlist.$phpEx"),
			'ASC_SEL' => $asc_sel,
			'DEC_SEL' => $dec_sel,
			'USERNAME_SEL' => $username_sel,
			'EMAIL_SEL' => $email_sel,
			'IP_SEL' => $ip_sel,
			'ALL_SEL' => $all_sel,

			'NO_BANS' => $lang['BULM_nobans'],
			'PAGINATE' => '<table width="100%"><tr><td align="left">' . sprintf($lang['Page_of'], ( ceil( ($start + 1) / $board_config['topics_per_page'] ) ), ceil( $total_records / $board_config['topics_per_page'] )) . '</td><td align="right">' . $pagination . '</td></tr></table>',
			'MUNBAN_SQL_BEGIN' => $mass_unban_sql_front,
			));
	}

$template->pparse('body');

include('./page_footer_admin.'.$phpEx);

?>