<?php
/***************************************************************************
 *								admin_users_list.php
 *								-------------------
 *   begin                : Thursday, July 18, 2002
 *   copyright            : (C) 2002 Smartor
 *   email                : smartor@zapo.net
 *
 *   $Id: admin_users_list.php,v 1.0.1 2002/7/25, 15:12:22 hnt Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['ACUsers']['ACUsers'] = $filename;
	return;
}

//
// Let's set the root dir for phpBB
//
$phpbb_root_path = '../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

//
// Set variables
//
$users_per_page = ($userdata['user_topics_per_page'] > 0) ? $userdata['user_topics_per_page'] : '25';
$start = (isset($HTTP_GET_VARS['start'])) ? $HTTP_GET_VARS['start'] : 0;
$sort_method = (isset($HTTP_POST_VARS['sort'])) ? $HTTP_POST_VARS['sort'] : 'user_id';
if ( isset($HTTP_POST_VARS['order']) )
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if ( isset($HTTP_GET_VARS['order']) )
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = 'joined';
}

if ( $mode == 'website' )
{
	include_once($phpbb_root_path . 'includes/bbcode.'.$phpEx);
}

$mode_types_text = array($lang['Sort_Joined'], $lang['Sort_Last_visit'], $lang['Sort_Username'], $lang['Location'], $lang['Total_posts'], $lang['Email'], $lang['Website'], $lang['helped']);
$mode_types = array('joined', 'lastvisit', 'username', 'location', 'posts', 'email', 'website', 'special_rank');

$custom_fields_exists = (custom_fields('check', '')) ? true : false;
$sql_cf = '';
if ( $custom_fields_exists )
{
	$custom_fields = custom_fields();
	for($i = 0; $i < count($custom_fields[0]); $i++)
	{
		$split_field = 'user_field_' . $custom_fields[0][$i];
		$fields_array[] = $split_field; 
		$custom_fields[1][$i] = str_replace(array('-#', '<br>'), array('',''), $custom_fields[1][$i]);
		$cf_lang = (isset($lang[$custom_fields[1][$i]])) ? $lang[$custom_fields[1][$i]] : $custom_fields[1][$i];
		$mode_types_text[] =  $cf_lang;
		$mode_types[] = $split_field;
		$sql_cf .= ', ' . $split_field;
		if ( $mode == $split_field )
		{
			$jumpbox = $custom_fields[5];
			$memberlist_lang_cf = $cf_lang;
			$memberlist_cf = $split_field;
		}
	}
}

$select_sort_mode = '<select name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if ( $sort_order == 'ASC' )
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

$template->set_filenames(array(
	'body' => 'admin/admin_users_list_body.tpl')
);

if ( $mode == 'special_rank' )
{
	$l_lastvisit = $lang['helped'];
}
else if ( $memberlist_lang_cf )
{
	$l_lastvisit = $memberlist_lang_cf;
}
else if ( $mode == 'location' )
{
	$l_lastvisit = $lang['Location'];
}
else if ( $mode == 'website' )
{
	$l_lastvisit = $lang['Website'];
}
else
{
	$l_lastvisit = $lang['Email'];
}

$template->assign_vars(array(
	'L_ADMIN_USERS_LIST_TITLE' => $lang['Admin_Users_List_Title'],
	'L_ADMIN_USERS_LIST_EXPLAIN' => $lang['Admin_Users_List_Explain'],
	'L_FIND_USERNAME' => $lang['Find_username'],
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'U_LIST_ACTION' => append_sid("admin_users_list.$phpEx"),
	'L_SORT' => $lang['Sort'],
	'L_ORDER' => $lang['Order'],
	'L_SORT_DESCENDING' => $lang['Sort_Descending'],
	'L_SORT_ASCENDING' => $lang['Sort_Ascending'],
	'L_USERNAME' => $lang['Username'],
	'L_EMAIL' => $l_lastvisit,
	'L_EDIT' => $lang['edit_mini'],
	'L_PERMISSION' => $lang['Permissions'],
	'L_JOINED' => $lang['Joined'],
	'L_LAST_VISIT' => $lang['Last_visit'],
	'L_POSTS' => $lang['Posts'],
	'L_ACTIVE' => $lang['Active'],
	'L_USER_TITLE' => $lang['User_admin'],
	'L_USER_EXPLAIN' => $lang['User_admin_explain'],
	'L_USER_SELECT' => $lang['Select_a_User'],
	'L_LOOK_UP' => $lang['Edit'],
	'L_AUTH' => $lang['Permissions'],
	'L_WEBSITE' => $lang['Website'],
	'L_FROM' => $l_from,
	'L_SEARCH_USERS' => $lang['Seeker'],
	'U_SEARCH_USERS' => '<a href="' . append_sid("../seeker.$phpEx") . '" class="nav">' . $lang['Seeker'] . '</a>',
	'U_SEARCH_USER' => append_sid("./../search.$phpEx?mode=searchuser"), 
	'S_USER_ACTION' => append_sid("admin_users.$phpEx"),
	'S_ORDER_SELECT' => $select_sort_order,
	'S_USER_SELECT' => $select_sort_mode)
);

switch( $mode )
{
	case 'joindate':
		$order_by = "user_regdate ASC LIMIT $start, " . $users_per_page;
		break;
	case 'lastvisit':
		$order_by = "user_lastvisit $sort_order LIMIT $start, " . $users_per_page;
		break;
	case 'username':
		$order_by = "username $sort_order LIMIT $start, " . $users_per_page;
		break;
	case 'location':
		$order_by = "user_from $sort_order LIMIT $start, " . $users_per_page;
		break;
	case 'posts':
		$order_by = "user_posts $sort_order LIMIT $start, " . $users_per_page;
		break;
	case 'email':
		$order_by = "user_email $sort_order LIMIT $start, " . $users_per_page;
		break;
	case 'website':
		$order_by = "user_website $sort_order LIMIT $start, " . $users_per_page;
		break;
	case 'special_rank':
		$order_by = "special_rank $sort_order LIMIT $start, " . $users_per_page;
		break;
	default:
		$order_by = "user_regdate $sort_order LIMIT $start, " . $users_per_page;
		break;
}

// Count users
$sql = "SELECT user_id FROM " . USERS_TABLE . "
	WHERE user_id > 0";

if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, 'Could not count Users', '', __LINE__, __FILE__, $sql);
}
$total_users = $db->sql_numrows($result);

// Query users info...
$sql = "SELECT user_id, username, user_email, user_regdate, user_lastvisit, user_posts, user_active, special_rank, user_from, user_website $sql_cf FROM " . USERS_TABLE . "
	WHERE user_id <> " . ANONYMOUS . "
		ORDER BY $order_by";

if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not query Users information", "", __LINE__, __FILE__, $sql);
}

while( $row = $db->sql_fetchrow($result) )
{
	$userrow[] = $row;
}

for ($i = 0; $i < $users_per_page; $i++)
{
	if (empty($userrow[$i]))
	{
		break;
	}

	$row_color = (($i % 2) == 0) ? "row1" : "row2";

	if ( $mode == 'special_rank' )
	{
		$user_email = $userrow[$i]['special_rank'];
	}
	else if ( $mode == 'location' )
	{
		$user_email = $userrow[$i]['user_from'];
	}
	else if ( $mode == 'website' )
	{
		$user_email = make_clickable($userrow[$i]['user_website']);
	}
	else if ( $memberlist_cf )
	{
		$user_email = $userrow[$i][$memberlist_cf];

		if ( $jumpbox )
		{
			$remove_string = array('.gif', '.jpg', '<br>', '-#');
			$replace_string = array('', '', '', '');
			$user_email = htmlspecialchars($user_email);
			if ( eregi('.gif', $user_email) || eregi('.jpg', $user_email) )
			{
				$field_name = str_replace(array('_', '.gif', '.jpg'), array(' ', '', ''), $user_email);
				$user_email = '<img src="../' . $images['images'] . '/custom_fields/' . $user_email . '" border="0" alt="' . $field_name . '" title="' . $field_name . '" align="top" /><br />';
			}
		}
	}
	else
	{
		$user_email = $userrow[$i]['user_email'];
	}

	$template->assign_block_vars('userrow', array(
		'COLOR' => $row_color,
		'NUMBER' => ($start + $i + 1),
		'USERNAME' => '<a href="' . append_sid("../profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $userrow[$i]['user_id']) . '">' . $userrow[$i]['username'] . '</a>',
		'U_ADMIN_USER' => append_sid("admin_users.$phpEx?mode=edit&amp;userlist=1&amp;" . POST_USERS_URL . "=" . $userrow[$i]['user_id']),
		'U_ADMIN_USER_AUTH' => append_sid("admin_ug_auth.$phpEx?mode=user&amp;userlist=1&amp;" . POST_USERS_URL . "=" . $userrow[$i]['user_id']),
		'EMAIL' => $user_email,
		'JOINED' => create_date($board_config['default_dateformat'], $userrow[$i]['user_regdate'], $board_config['board_timezone']),
		'LAST_VISIT' => (!$userrow[$i]['user_lastvisit']) ? $lang['Never'] : create_date($board_config['default_dateformat'], $userrow[$i]['user_lastvisit'], $board_config['board_timezone']),
		'POSTS' => '<a href="' . append_sid("../search.$phpEx?search_author=" . urlencode($userrow[$i]['username']) . "&amp;showresults=posts") . '">' . $userrow[$i]['user_posts'] . '</a>',
		'ACTIVE' => ( $userrow[$i]['user_active'] ) ? $lang['Yes'] : '<b>' . $lang['No'] . '</b>'
		) //end array
	);
}

$template->assign_vars(array(
	'PAGINATION' => generate_pagination(append_sid("admin_users_list.$phpEx?mode=$mode&amp;order=$sort_order"), $total_users, $users_per_page, $start),
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $users_per_page ) + 1 ), ceil( $total_users / $users_per_page ))
	)
);

$template->pparse('body');

include('./page_footer_admin.'.$phpEx);

?>