<?php

$only_admin = 0; // Tylko admin ma dostep do check_files ?
$only_admin_sql = 1; // Tylko admin ma dostep do sprawdzania SQL ?

define('IN_PHPBB', true);

function microtime_float2()
{
   list($usec2, $sec2) = explode(" ", microtime());
   return ((float)$usec2 + (float)$sec2);
}

$time_start2 = microtime_float2();

$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');

if ( @filesize("config.$phpEx") > 50 )
{
	include($phpbb_root_path . 'common.'.$phpEx);
	require($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_portal.' . (($phpEx) ? $phpEx : '.php'));
	$userdata = session_pagestart($user_ip, PAGE_VIEWMEMBERS);
	init_userprefs($userdata);

	if ( $only_admin && $userdata['user_level'] != ADMIN )
	{
		die('Dostp do CheckFiles tylko dla Administratorw.');
	}
	$can_sql = (!$only_admin_sql || $userdata['user_level'] == ADMIN) ? true : false;
}

$mode = $_GET['mode'];
$type = $_GET['type'];
$cf = 'check_files.' . $phpEx;

function md5_checksum($file)
{
	if ( @file_exists($file) )
	{
		$fd = @fopen($file, 'rb');
		$fileContents = @fread($fd, @filesize($file));
		@fclose($fd);
		return md5($fileContents);
	}
	else
	{
		return false;
	}
}

function strlen_used_chars($file)
{
	if ( @file_exists($file) )
	{
		$fd = @fopen($file, 'rb');
		$fileContents = @fread($fd, @filesize($file));
		@fclose($fd);
		return strlen(str_replace(array(" ","\t","\n","\r"), '', $fileContents));
	}
	else
	{
		return false;
	}
}

echo'<!doctype html public "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
 <head>
  <title>phpBB modified by Przemo CheckFiles</title>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2">
  <style type="text/css">
  <!--
  body {
	background-color: #EFEFEF;
	scrollbar-face-color: #EFEFEF;
	scrollbar-highlight-color: #FFFFFF;
	scrollbar-shadow-color: #DEE3E7;
	scrollbar-3dlight-color: #D1D7DC;
	scrollbar-arrow-color:  #006699;
	scrollbar-track-color: #EFEFEF;
	scrollbar-darkshadow-color: #98AAB1;
  }

  .bodyline { background-color: #FFFFFF; border: 1px #98AAB1 solid; }
  font,th,td,p { font-family: Verdana, Arial, Helvetica, sans-serif }
  p, td		{ font-size : 12; color : #000000; }

  hr	{ height: 0px; border: solid #D1D7DC 0px; border-top-width: 1px;}
  h1,h2,h3,h4		{ font-family: Arial, Helvetica, sans-serif; font-size : 19px; font-weight : bold; text-decoration : none; line-height : 100%; color : #000000;}
 
  -->
  </style>
 </head>

 <body bgcolor="#E5E5E5">
    <table width="98%" style="height: 100%" cellspacing="0" cellpadding="7" border="0" align="center">
       <tr>
	      <td class="bodyline" valign="top">';

echo '<h3>CheckFiles - phpBB by Przemo wersja 1.9.4</h3>' . (($mode) ? '<h5>Sprawdzanie synchronizacji SQL</h5>' : '');
	if ( @filesize("config.$phpEx") > 50 && $userdata['user_level'] == ADMIN )
	{
		echo '<font size="1">Jeeli chcesz aby tylko administratorzy mieli dostp do CheckFiles w pliku check_files.php na samym pocztku nadaj zmiennej: <b>$only_admin</b> warto <b>1</b><br />
		Pamitaj jednak, e jeeli gdziekolwiek bdziesz zgasza problem z forum musisz udostpni CheckFiles ! W innym wypadku nie otrzymasz pomocy.</font>';
	}

echo '<hr>';

if ( @filesize("config.$phpEx") > 50 )
{
	echo '<table border="0">';
	if ( $mode == 'sql' && $can_sql )
	{
		echo '<tr><td>
		<a href="' . $cf . '?mode=sql&amp;type=users_posts">Posty uytkownikw</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=posts_text">Tekst&nbsp;postw</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=topic_replies">Postw&nbsp;w&nbsp;tematach</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=last_first_post_in_topic">Pierwszy&nbsp;i&nbsp;ostatni&nbsp;post&nbsp;w&nbsp;temacie</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=moved">Przesunite&nbsp;tematy</a><br />
		<a href="' . $cf . '?mode=sql&amp;type=topics_without_posts">Tematw&nbsp;bez&nbsp;postw</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=posts_without_topic">Postw&nbsp;bez&nbsp;tematw</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=forum_posts">Postw&nbsp;w&nbsp;forach</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=forum_topics">Tematw&nbsp;w&nbsp;forach</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=forum_last_post_id">Ostatni&nbsp;post&nbsp;forum</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=polls">Sondy</a>
		&nbsp; <a href="' . $cf . '?mode=sql&amp;type=users">Uytkownicy</a>
		' . ((is_mod($userdata['user_id']) || $userdata['user_level'] == ADMIN) ? '<br /><br /><a href="' . $cf . '?mode=sql&amp;type=all">Wszystkie</a><br /><font size="1">(Przy duych bazach danych, ta czynno moe trwa bardzo dugo i znacznie obciy serwer!)</font>' : '') . '
		<br /><br />' . (($type) ? '<a href="' . $cf . '?mode=sql">Powrt</a>&nbsp;&nbsp;&nbsp;' : '') . '<a href="' . $cf . '">Powrt do CheckFiles</a>
		<hr />
		</td></tr>';

		if ( !$type )
		{
			echo '</table></td></tr></table></body></html>';
			if ( !empty($db) )
			{
				$db->sql_close();
			}
			exit;
		}

		@set_time_limit('300');

		$sql_results = array();
		$sql_results_name = array('users_posts' => 0, 'posts_text' => 0, 'topic_replies' => 0, 'last_post_topic' => 0, 'first_post_topic' => 0, 'moved' => 0, 'forum_posts' => 0, 'forum_topics' => 0, 'forum_last_post_id' => 0, 'topics_without_posts' => 0, 'posts_without_topic' => 0, 'polls' => 0, 'polls_desc' => 0, 'polls_res' => 0, 'polls_vote' => 0);
		$print_result = '';

		$all = ($type == 'all' && $userdata['user_level'] == ADMIN) ? true : false;

		if ( $type == 'users_posts' || $all )
		{
			$users_ids = array();
			$no_count_forums = no_post_count('1', 'list');
			
			$sql = "SELECT user_id, user_posts
				FROM " . USERS_TABLE . "
				WHERE user_id <> " . ANONYMOUS;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get poster id information', '', __LINE__, __FILE__, $sql);
			}
			while ( $row = $db->sql_fetchrow($result) )
			{
				$sql_posts = "SELECT COUNT(post_id) AS posts
					FROM " . POSTS_TABLE . "
						WHERE poster_id = " . $row['user_id'] . "
						" . (($no_count_forums) ? " AND forum_id NOT IN($no_count_forums)" : '');
				if ( !($result_posts = $db->sql_query($sql_posts)) )
				{
					message_die(GENERAL_ERROR, 'Could not count user posts', '', __LINE__, __FILE__, $sql_posts);
				}
				$row_post = $db->sql_fetchrow($result_posts);

				if ( $row['user_posts'] != $row_post['posts'] )
				{
					$sql_results_name['users_posts']++;
					$users_ids[] = $row['user_id'];
				}
			}

			if ( $sql_results_name['users_posts'] > 0 )
			{
				$echo_ids = '';
				for($i = 0; $i < count($users_ids); $i++)
				{
					$echo_ids .= '<a href="profile.'.$phpEx.'?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $users_ids[$i] . '">' . $users_ids[$i] . '</a>, ';
				}
				$print_result .= '<tr><td>Uytkownikw z niewaciw iloci postw: <b>' . $sql_results_name['users_posts'] . '</b><br />User ID\'s: ' . $echo_ids . '</td></tr>';
			}
		}

		if ( $type == 'posts_text' || $all )
		{
			if ( isset($_GET['repair']) && ($userdata['user_level'] == ADMIN) )
			{
				$sql = "SELECT post_id
					FROM " . POSTS_TABLE;
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not get post list data', '', __LINE__, __FILE__, $sql);
				}

				$list_pt = $list_p = array();

				while ( $row_pt = $db->sql_fetchrow($result) )
				{
					$list_pt[] = $row_pt['post_id'];
				}
				$list_pt = implode(', ', $list_pt);
				$sql = "DELETE FROM " . POSTS_TEXT_TABLE . "
					WHERE post_id NOT IN($list_pt)";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not delete posts', '', __LINE__, __FILE__, $sql);
				}

				$sql = "SELECT post_id
					FROM " . POSTS_TEXT_TABLE;
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not get post text list data', '', __LINE__, __FILE__, $sql);
				}

				while ( $row_p = $db->sql_fetchrow($result) )
				{
					$list_p[] = $row_p['post_id'];
				}
				$list_p = implode(', ', $list_p);
				$sql = "DELETE FROM " . POSTS_TABLE . "
					WHERE post_id NOT IN($list_p)";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not delete posts text', '', __LINE__, __FILE__, $sql);
				}
				die('<br /><br /><b>Posty zostay zsynchronizowane, sprawd jeszcze raz cakowit synchronizacje forum (wszystkie).<br /></b>Jeeli wynik bdzie negatywny uruchom synchronizacj w panelu admina.<br /><br />');
			}
			$sql = "SELECT p.post_id
				FROM " . POSTS_TABLE . " p
				LEFT JOIN " . POSTS_TEXT_TABLE . " pt ON (p.post_id = pt.post_id)
				WHERE pt.post_id IS NULL";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not ged different', '', __LINE__, __FILE__, $sql);
			}
			$p_diff = $pt_diff = '';
			while ( $rowp = $db->sql_fetchrow($result) )
			{
				$p_diff .= ($p_diff) ? ', ' . $rowp['post_id'] : $rowp['post_id'];
			}
			if ( $p_diff )
			{
				$print_result .= '<tr><td><br /><br />ID "pustych" postw bez treci postw: <b>' . $p_diff . '</b></td></tr>';
			}

			$sql = "SELECT pt.post_id
				FROM " . POSTS_TEXT_TABLE . " pt
				LEFT JOIN " . POSTS_TABLE . " p ON (pt.post_id = p.post_id)
				WHERE p.post_id IS NULL";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not ged different', '', __LINE__, __FILE__, $sql);
			}
			while ( $rowpt = $db->sql_fetchrow($result) )
			{
				$pt_diff .= ($pt_diff) ? ', ' . $rowpt['post_id'] : $rowpt['post_id'];
			}
			if ( $pt_diff )
			{
				$print_result .= '<tr><td>' . ((!$p_diff) ? '<br /><br />' : '') . 'ID treci postw bez postw: <b>' . $pt_diff . '</b></td></tr>';
			}
			if ( $userdata['user_level'] == ADMIN && ($pt_diff || $p_diff) )
			{
				$print_result .= '<tr><td><a href="' . $cf . '?mode=sql&amp;type=all&amp;repair=1">Usu "puste" posty i treci postw bez postw</a></td></tr>';
			}
		}

		if ( $type == 'topic_replies' || $type == 'last_first_post_in_topic' || $type == 'posts_without_topic' || $type == 'topics_without_posts' || $type == 'polls' || $all )
		{
			$sql = "SELECT topic_id, topic_replies, topic_last_post_id, topic_first_post_id
				FROM " . TOPICS_TABLE . "
					WHERE topic_moved_id = 0";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get topics data', '', __LINE__, __FILE__, $sql);
			}

			$topics_ids = $topics_last = $topics_last = $posts_wtopics = $topics = $topics_wposts = $polls_ids = array();

			while ( $row = $db->sql_fetchrow($result) )
			{
				if ( $type == 'topic_replies' || $all )
				{
					$sql_posts = "SELECT COUNT(post_id) AS posts
						FROM " . POSTS_TABLE . "
							WHERE topic_id = " . $row['topic_id'];
					if ( !($result_posts = $db->sql_query($sql_posts)) )
					{
						message_die(GENERAL_ERROR, 'Could not count topic posts', '', __LINE__, __FILE__, $sql_posts);
					}
					$row_post = $db->sql_fetchrow($result_posts);

					if ( $row['topic_replies'] != ($row_post['posts'] - 1) )
					{
						$sql_results_name['topic_replies']++;
						$topics_ids[] = $row['topic_id'];
					}
				}
				if ( $type == 'topics_without_posts' || $all )
				{
					$sql_wposts = "SELECT post_id
						FROM " . POSTS_TABLE . "
							WHERE topic_id = " . $row['topic_id'] . "
							LIMIT 1";
					if ( !($result_wposts = $db->sql_query($sql_wposts)) )
					{
						message_die(GENERAL_ERROR, 'Error get posts list', '', __LINE__, __FILE__, $sql_wposts);
					}
					if ( !($row_wposts = $db->sql_fetchrow($result_wposts)) )
					{
						$sql_results_name['topics_without_posts']++;
						$topics_wposts[] = $row['topic_id'];
					}
				}				
				if ( $type == 'last_first_post_in_topic' || $all )
				{
					$sql_posts_last = "SELECT MAX(post_id) AS last_post, MIN(post_id) AS first_post
						FROM " . POSTS_TABLE . "
							WHERE topic_id = " . $row['topic_id'];
					if ( !($result_posts_last = $db->sql_query($sql_posts_last)) )
					{
						message_die(GENERAL_ERROR, 'Could not count topic posts', '', __LINE__, __FILE__, $sql_posts_last);
					}
					$row_post_last = $db->sql_fetchrow($result_posts_last);

					if ( $row['topic_last_post_id'] != $row_post_last['last_post'] )
					{
						$sql_results_name['last_post_topic']++;
						$topics_last[] = $row['topic_id'];
					}
					if ( $row['topic_first_post_id'] != $row_post_last['first_post'] )
					{
						$sql_results_name['first_post_topic']++;
						$topics_first[] = $row['topic_id'];
					}

				}
				$topics[] = $row['topic_id'];
			}

			$topics = (is_array($topics)) ? implode(',', $topics) : $topics;

			if ( ($type == 'posts_without_topic' || $all) && $topics )
			{
				$sql_wtopics = "SELECT post_id
					FROM " . POSTS_TABLE . "
						WHERE topic_id NOT IN($topics)";
				if ( !($result_wtopics = $db->sql_query($sql_wtopics)) )
				{
					message_die(GENERAL_ERROR, 'Error get topic posts', '', __LINE__, __FILE__, $sql_wtopics);
				}
				while ( $row_wpost = $db->sql_fetchrow($result_wtopics) )
				{
					$sql_results_name['posts_without_topic']++;
					$posts_wtopics[] = $row_wpost['post_id'];
				}
				if ( $sql_results_name['posts_without_topic'] > 0 )
				{
					$posts_wtopics = (is_array($posts_wtopics)) ? implode(', ', $posts_wtopics) : $posts_wtopics;
					$print_result .= '<tr><td><br /><br />Postw bez tematw: <b>' . $sql_results_name['posts_without_topic'] . '</b> ID\'s: <b>' . $posts_wtopics . '</b>';
				}
			}
			if ( ($type == 'topics_without_posts' || $all) && $sql_results_name['topics_without_posts'] > 0 )
			{
				$topics_wposts = (is_array($topics_wposts)) ? implode(', ', $topics_wposts) : $topics_wposts;
				$print_result .= '<tr><td><br /><br />Tematw bez postw: <b>' . $sql_results_name['topics_without_posts'] . '</b><br />Topic ID\'s: ' . $topics_wposts . '</td></tr>';
			}
			if ( ($type == 'topic_replies' || $all) && $sql_results_name['topic_replies'] > 0 )
			{
				$echo_ids = '';
				for($i = 0; $i < count($topics_ids); $i++)
				{
					$echo_ids .= '<a href="viewtopic.'.$phpEx.'?' . POST_TOPIC_URL . '=' . $topics_ids[$i] . '">' . $topics_ids[$i] . '</a>, ';
				}
				$print_result .= '<tr><td><br /><br />Tematw z niewaciw iloci odpowiedzi: <b>' . $sql_results_name['topic_replies'] . '</b><br />Topic ID\'s: ' . $echo_ids . '</td></tr>';
			}
			if ( $type == 'last_first_post_in_topic' || $all )
			{
				if ( $sql_results_name['last_post_topic'] > 0 )
				{
					$echo_ids = '';
					for($i = 0; $i < count($topics_last); $i++)
					{
						$echo_ids .= '<a href="viewtopic.'.$phpEx.'?' . POST_TOPIC_URL . '=' . $topics_last[$i] . '">' . $topics_last[$i] . '</a>, ';
					}
					$print_result .= '<tr><td><br /><br />Tematw z niewaciwym ID ostatniego postu: <b>' . $sql_results_name['last_post_topic'] . '</b><br />Topic ID\'s: ' . $echo_ids . '</td></tr>';
				}
				if ( $sql_results_name['first_post_topic'] > 0 )
				{
					$echo_ids = '';
					for($i = 0; $i < count($topics_first); $i++)
					{
						$echo_ids .= '<a href="viewtopic.'.$phpEx.'?' . POST_TOPIC_URL . '=' . $topics_first[$i] . '">' . $topics_first[$i] . '</a>, ';
					}
					$print_result .= '<tr><td><br /><br />Tematw z niewaciwym ID pierwszego postu: <b>' . $sql_results_name['first_post_topic'] . '</b><br />Topic ID\'s: ' . $echo_ids . '</td></tr>';
				}
			}
			if ( ($type == 'polls' || $all) && $topics )
			{
				$sql_p = "SELECT topic_id, vote_id
					FROM " . VOTE_DESC_TABLE . "
					WHERE topic_id NOT IN($topics)";
				if ( !($result_p = $db->sql_query($sql_p)) )
				{
					message_die(GENERAL_ERROR, 'Could not get polls list', '', __LINE__, __FILE__, $sql_p);
				}
				while ( $row_p = $db->sql_fetchrow($result_p) )
				{
					$sql_results_name['polls']++;
					$polls_ids[] = $row_p['vote_id'];
				}

				$sql_p = "SELECT vote_id
					FROM " . VOTE_DESC_TABLE;
				if ( !($result_p = $db->sql_query($sql_p)) )
				{
					message_die(GENERAL_ERROR, 'Could not get polls list', '', __LINE__, __FILE__, $sql_p);
				}
				while ( $row_p = $db->sql_fetchrow($result_p) )
				{
					$sql_results_name['polls_desc'] = $row_p['vote_id'];
				}

			}
		}
		if ( $type == 'moved' || $all )
		{
			$moved_ids = array();
			$sql = "SELECT topic_id, topic_moved_id
				FROM " . TOPICS_TABLE . "
					WHERE topic_moved_id <> 0";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Error get topic moved list', '', __LINE__, __FILE__, $sql);
			}
			while ( $row = $db->sql_fetchrow($result) )
			{
				$sql_m = "SELECT topic_id
					FROM " . TOPICS_TABLE . "
						WHERE topic_id = " . $row['topic_moved_id'];
				if ( !($result_m = $db->sql_query($sql_m)) )
				{
					message_die(GENERAL_ERROR, 'Error get topic list', '', __LINE__, __FILE__, $sql_m);
				}
				if ( !($row_m = $db->sql_fetchrow($result_m)) )
				{
					$sql_results_name['moved']++;
					$moved_ids[] = $row['topic_moved_id'];
				}
			}
			if ( $sql_results_name['moved'] > 0 )
			{
				$echo_ids = '';
				for($i = 0; $i < count($moved_ids); $i++)
				{
					$echo_ids .= '<a href="viewtopic.'.$phpEx.'?' . POST_TOPIC_URL . '=' . $moved_ids[$i] . '">' . $moved_ids[$i] . '</a>, ';
				}
				$print_result .= '<tr><td><br /><br />"Pustych" przesunitych tematw (do usunicia) bez odpowiednika: <b>' . $sql_results_name['moved'] . '</b><br />Topic ID\'s: ' . $echo_ids . '</td></tr>';
			}
		}
		if ( $type == 'without_forum' || $all )
		{
			$wforum_ids = array();
			$forums = array();
			$sql = "SELECT forum_id, forum_link
				FROM " . FORUMS_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Error get forums list', '', __LINE__, __FILE__, $sql);
			}
			while ( $row = $db->sql_fetchrow($result) )
			{
				if ( empty($row['forum_link']) && strlen($row['forum_link']) < 5 )
				{
					$forums[] = $row['forum_id'];
				}
			}
			$forums = (is_array($forums)) ? implode(',', $forums) : $forums;

			if ( $forums )
			{
				if ( isset($_GET['repair_w']) )
				{
					$sql_w = "DELETE FROM " . TOPICS_TABLE . "
							WHERE forum_id NOT IN($forums)";
					if ( !($result_w = $db->sql_query($sql_w)) )
					{
						message_die(GENERAL_ERROR, 'Error deleting topics', '', __LINE__, __FILE__, $sql_m);
					}
					die('<br /><br /><b>Tematy zostay zsynchronizowane, sprawd jeszcze raz cakowit synchronizacje forum (wszystkie).<br /></b>Jeeli wynik bdzie negatywny uruchom synchronizacj w panelu admina.<br /><br />');
				}
				$sql_m = "SELECT topic_id, forum_id
					FROM " . TOPICS_TABLE . "
						WHERE forum_id NOT IN($forums)";
				if ( !($result_m = $db->sql_query($sql_m)) )
				{
					message_die(GENERAL_ERROR, 'Error get topic list', '', __LINE__, __FILE__, $sql_m);
				}
				while ( $row_m = $db->sql_fetchrow($result_m) )
				{
					$sql_results_name['without_forum']++;
					$wforum_ids[] = $row_m['topic_id'] . ' - ' . $row_m['forum_id'];
				}
				if ( $sql_results_name['without_forum'] > 0 )
				{
					$echo_ids = '';
					for($i = 0; $i < count($wforum_ids); $i++)
					{
						$echo_ids .= ($echo_ids) ? ', [' . $wforum_ids[$i] . ']' : '[' . $wforum_ids[$i] . ']';
					}
					$print_result .= '<tr><td><br /><br />Tematw nie przypisanych do adnego lub odpowiedniego forum: <b>' . $sql_results_name['without_forum'] . '</b><br />[Topic ID - Forum ID]: ' . $echo_ids . '<br />Kliknij <a href="' . $cf . '?mode=sql&amp;type=all&amp;repair_w=1">Tutaj</a> aby usun te tematy.</td></tr>';
				}
			}
		}
		if ( $type == 'forum_posts' || $type == 'forum_topics' || $type == 'forum_last_post_id' || $all )
		{
			$fposts_ids = $ftopics_ids = $flast_ids = array();
			$sql = "SELECT forum_id, forum_posts, forum_topics, forum_last_post_id
				FROM " . FORUMS_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get forum data', '', __LINE__, __FILE__, $sql);
			}
			while ( $row = $db->sql_fetchrow($result) )
			{			
				if ( $type == 'forum_posts' || $all )
				{
					$sql_posts = "SELECT COUNT(post_id) AS posts
						FROM " . POSTS_TABLE . "
							WHERE forum_id = " . $row['forum_id'];
					if ( !($result_posts = $db->sql_query($sql_posts)) )
					{
						message_die(GENERAL_ERROR, 'Could not count forum posts', '', __LINE__, __FILE__, $sql_posts);
					}
					$row_post = $db->sql_fetchrow($result_posts);

					if ( $row['forum_posts'] != $row_post['posts'] )
					{
						$sql_results_name['forum_posts']++;
						$fposts_ids[] = $row['forum_id'];
					}
				}
				if ( $type == 'forum_topics' || $all )
				{
					$sql_topics = "SELECT COUNT(topic_id) AS topics
						FROM " . TOPICS_TABLE . "
							WHERE forum_id = " . $row['forum_id'];
					if ( !($result_topics = $db->sql_query($sql_topics)) )
					{
						message_die(GENERAL_ERROR, 'Could not count forum posts', '', __LINE__, __FILE__, $sql_topics);	
					}
					$row_topics = $db->sql_fetchrow($result_topics);

					if ( $row['forum_topics'] != $row_topics['topics'] )
					{
						$sql_results_name['forum_topics']++;
						$ftopics_ids[] = $row['forum_id'];
					}
				}
				if ( $type == 'forum_last_post_id' || $all )
				{
					$sql_last = "SELECT MAX(post_id) AS last
						FROM " . POSTS_TABLE . "
							WHERE forum_id = " . $row['forum_id'];
					if ( !($result_last = $db->sql_query($sql_last)) )
					{
						message_die(GENERAL_ERROR, 'Could not get last forum post', '', __LINE__, __FILE__, $sql_last);	
					}
					$row_last = $db->sql_fetchrow($result_last);

					$row['forum_last_post_id'] = ($row['forum_last_post_id']) ? $row['forum_last_post_id'] : 0;

					if ( $row['forum_last_post_id'] != $row_last['last'] )
					{
						$sql_results_name['forum_last_post_id']++;
						$flast_ids[] = $row['forum_id'];
					}
				}
			}

			if ( ($type == 'forum_posts' || $all) && $sql_results_name['forum_posts'] > 0 )
			{
				$echo_ids = '';
				for($i = 0; $i < count($fposts_ids); $i++)
				{
					$echo_ids .= '<a href="viewforum.'.$phpEx.'?' . POST_FORUM_URL . '=' . $fposts_ids[$i] . '">' . $fposts_ids[$i] . '</a>, ';
				}
				$print_result .= '<tr><td><br /><br />For z niewaciw iloci postw: <b>' . $sql_results_name['forum_posts'] . '</b><br />Forum ID\'s: ' . $echo_ids . '</td></tr>';
			}
			if ( ($type == 'forum_topics' || $all) && $sql_results_name['forum_topics'] > 0 )
			{
				$echo_ids = '';
				for($i = 0; $i < count($ftopics_ids); $i++)
				{
					$echo_ids .= '<a href="viewforum.'.$phpEx.'?' . POST_FORUM_URL . '=' . $ftopics_ids[$i] . '">' . $ftopics_ids[$i] . '</a>, ';
				}
				$print_result .= '<tr><td><br /><br />For z niewaciw iloci tematw: <b>' . $sql_results_name['forum_topics'] . '</b><br />Forum ID\'s: ' . $echo_ids . '</td></tr>';
			}
			if ( ($type == 'forum_last_post_id' || $all) && $sql_results_name['forum_last_post_id'] > 0 )
			{
				$echo_ids = '';
				for($i = 0; $i < count($flast_ids); $i++)
				{
					$echo_ids .= '<a href="viewforum.'.$phpEx.'?' . POST_FORUM_URL . '=' . $flast_ids[$i] . '">' . $flast_ids[$i] . '</a>, ';
				}
				$print_result .= '<tr><td><br /><br />For z niewaciwym ostatnim postem: <b>' . $sql_results_name['forum_last_post_id'] . '</b><br />Forum ID\'s: ' . $echo_ids . '</td></tr>';
			}
		}
		if ( ($type == 'polls' || $all) )
		{
			$list_polls = array();
			if ( $sql_results_name['polls'] )
			{
				$polls_ids = (is_array($polls_ids)) ? implode(', ', $polls_ids) : $polls_ids;
				$print_result .= '<tr><td><br /><br />Sond bez tematw: <b>' . $sql_results_name['polls'] . '</b><br />Vote ID\'s: ' . $polls_ids . '</td></tr>';
			}

			$sql = "SELECT vote_id
				FROM " . VOTE_DESC_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get vote desc data', '', __LINE__, __FILE__, $sql);
			}
			while ( $row = $db->sql_fetchrow($result) )
			{
				$list_polls[] = $row['vote_id'];
			}

			$list_polls = (is_array($list_polls)) ? implode(', ', $list_polls) : $list_polls;

			if ( $list_polls )
			{
				$sql_polls = "SELECT COUNT(r.vote_id) as vid, COUNT(v.vote_id) as vidv
					FROM " . VOTE_DESC_TABLE . " r, " . VOTE_RESULTS_TABLE . " v
					WHERE r.vote_id NOT IN($list_polls)
						OR v.vote_id NOT IN($list_polls)";
				if ( !($result_polls = $db->sql_query($sql_polls)) )
				{
					message_die(GENERAL_ERROR, 'Could not count vote desc from vote desc table', '', __LINE__, __FILE__, $sql_last);	
				}
				$row_polls = $db->sql_fetchrow($result_polls);
				$vid = count($row_polls['vid']);
				$vidv = count($row_polls['vidv']);
				if ( $row_polls['vid'] )
				{
					$print_result .= '<tr><td><br /><br />Gosw nieprzydzielonych do sond: <b>' . $vid . '</b></td></tr>';
				}
				if ( $row_polls['vidv'] )
				{
					$print_result .= '<tr><td><br /><br />Gosujcych nieprzydzielonych do sond: <b>' . $vidv . '</b></td></tr>';
				}
			}
		}

		if ( ($type == 'users' || $all) )
		{
			$g_users = array();
			$sql = "SELECT user_id
				FROM " . USERS_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get user id information', '', __LINE__, __FILE__, $sql);
			}

			if ( isset($_GET['repair_ug']) && $userdata['user_level'] == ADMIN )
			{
				while ( $row = $db->sql_fetchrow($result) )
				{
					$sql_u = "SELECT g.group_id
					FROM " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g
					WHERE ug.user_id = " . $row['user_id'] . "
						AND g.group_id = ug.group_id
						AND g.group_single_user = " . TRUE;
					if ( !($result_u = $db->sql_query($sql_u)) )
					{
						message_die(GENERAL_ERROR, 'Could not select info from user/user_group table', '', __LINE__, __FILE__, $sql_u);
					}

					if ( !$db->sql_affectedrows() ) 
					{
						$sql_rep = "DELETE FROM " . USER_GROUP_TABLE . "
							WHERE user_id = " . $row['user_id'];
						if ( !($result_rep = $db->sql_query($sql_rep)) )
						{
							message_die(GENERAL_ERROR, 'Could not delete old user group data', '', __LINE__, __FILE__, $sql_rep);
						}

						$sql_rep = "INSERT INTO " . GROUPS_TABLE . " (group_name, group_description, group_single_user, group_moderator)
							VALUES ('', 'Personal User', 1, 0)";
						if ( !($result_rep = $db->sql_query($sql_rep)) )
						{
							message_die(GENERAL_ERROR, 'Could not insert data into groups table', '', __LINE__, __FILE__, $sql_rep);
						}
						$group_id = $db->sql_nextid();

						$sql_rep = "INSERT INTO " . USER_GROUP_TABLE . " (user_id, group_id, user_pending)
							VALUES (" . $row['user_id'] . ", $group_id, 0)";
						if ( !($result_rep = $db->sql_query($sql_rep, END_TRANSACTION)) )
						{
							message_die(GENERAL_ERROR, 'Could not insert data into user_group table', '', __LINE__, __FILE__, $sql_rep);
						}
					}
				}
			}

			while ( $row = $db->sql_fetchrow($result) )
			{
				$sql_u = "SELECT g.group_id
				FROM " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g
				WHERE ug.user_id = " . $row['user_id'] . "
					AND g.group_id = ug.group_id
					AND g.group_single_user = " . TRUE;
				if ( !($result_u = $db->sql_query($sql_u)) )
				{
					message_die(GENERAL_ERROR, 'Could not select info from user/user_group table', '', __LINE__, __FILE__, $sql_u);
				}

				if ( !$db->sql_affectedrows() ) 
				{
					$g_users[] = $row['user_id'];
				}
			}

			if ( $g_users )
			{
				for($i = 0; $i < count($g_users); $i++)
				{
					$gecho_ids .= '<a href="profile.'.$phpEx.'?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $g_users[$i] . '">' . $g_users[$i] . '</a>, ';
				}
				$print_result .= '<tr><td><br /><br />Uytkownikw bez grup: <b>' . count($g_users) . '</b><br />User ID\'s: ' . $gecho_ids . '<br /><font size="1">Kady uytkownik ma przypisan grup i personaln grup (groups i user_groups), bez nich uytkownikowi nie mona nada dodatkowych praw.<br />Problem ten mg powsta podczas awarii bazy SQL, lub niestabilnoci serwera, ciko jest go usun, z uwagi na unikalno i brak powizania ID grupy, oraz ID personalnej grupy z uytkownikiem.</font><br /><a href="' . $cf . '?mode=sql&amp;type=users&amp;repair_ug=1">Napraw</a> (uytkownicy z listy powyej utrac przywileje [moderator, przynaleno do grup] )</td></tr>';
			}
		}

		echo ($print_result) ? '<tr><td><br /><font color="red"><b>Baza nie jest zsynchronizowana !</b></font><br /><br /></td></tr>' . $print_result . '<tr><td><br />' . (($userdata['user_level'] == ADMIN) ? '<br /><b>Narzdzia do synchronizacji bazy SQL, znajdziesz w Panelu Administratora w sekcji: Fora, Uytkownicy i Zaczniki</b><br /><font size="1">W prawidowym dziaaniu forum nie przeszkadza desynchronizacja:<br />- Postw uytkownikw (wynika moe ona na przykad z oznaczenia forum jako niezliczajcego posty, po napisaniu tematw w tym forum)<br />- Rnica w iloci postw i treci postw, pod warunkiem, e ilo treci postw jest wiksza<br />&nbsp;&nbsp;(na og jest przyczyn rcznej edycji bazy danych, lub niestabilnoci serwera)<br />- Sondy nieprzypisane do tematw<br />Pozostae desynchronizacje naley jak najszybciej eliminowa.</font>' : '') . '</td></tr>' : '<tr><td><br /><font color="green"><b>' . (($all) ? 'Baza jest zsynchronizowana' : 'Zsynchronizowane') . '.</b></font></tr></td>';

		$time_end2 = microtime_float2();
		$generated_time2 = round(($time_end2 - $time_start2), 2);

		echo '<tr><td><br /><hr /><font size="1">' . (($generated_time2 > 0) ? 'Czas sprawdzania: <b>' . $generated_time2 . '</b>s.<br />' : '') . 'Wykonanych zapyta: <b>' . $db->num_queries . '</b></font></td></tr>';

		echo '</table></td></tr></table></body></html>';
		$db->sql_close();
		exit;
	}

	if ( $can_sql )
	{
		echo '<tr><td colspan="2"><a href="' . $cf.(($mode) ? '' : '?mode=sql') . '">' . (($mode) ? 'Powrt' : 'Sprawd synchronizacj bazy SQL') . '</a><br /><br /></td></tr>';
	}
	if ( phpversion() <  4.1 )
	{
		$phpver = '<font color="red"><b>' . phpversion() . ' - ' . $lang['to_low_php'] . '</b></font>';
	}
	else
	{
		$phpver = phpversion() . ' - <font color="green"><b>OK</b></font>';
	}

	if( preg_match("/^mysql/", SQL_LAYER) )
	{
		$sql = "SELECT VERSION() AS mysql_version";
		if ( $result = $db->sql_query($sql) )
		{
			$row = $db->sql_fetchrow($result);
			$version = $row['mysql_version'];
		}
	}
	else $version = 'No MySql';

	echo '<tr><td valign="top"><table border="0">';
	echo '<tr><td>Server name</td><td>: ' . (( $board_config['server_name'] == $board_config['cookie_domain'] ) ? $board_config['server_name'] : '<font color="red">' . $board_config['server_name'] . '</font> Server name differs from Cookie domain.') . '</td></tr>';
	echo '<tr><td>Cookie domain</td><td>: ' . (( $board_config['server_name'] == $board_config['cookie_domain'] ) ? $board_config['cookie_domain'] : '<font color="red">' . $board_config['cookie_domain'] . '</font> ' . $lang['cookie_different']) . '</td></tr>';
	echo '<tr><td>Check address</td><td>: ' . $board_config['check_address'] . '</td></tr>';
	echo '<tr><td>Cookie secure</td><td>: ' . $board_config['cookie_secure'] . '</td></tr>';
	echo '<tr><td>PHP version</td><td>: ' . $phpver . '</td></tr>';
	echo '<tr><td>MySql version</td><td>: ' . $version . '</td></tr>';
	echo '</table></td><td>&nbsp;&nbsp;&nbsp;</td><td valign="top"><table border="0">';
	echo '<tr><td>Kompresja gzip forum</td><td>: ' . (($board_config['gzip_compress']) ? $lang['Yes'] : $lang['No']) . '</td></tr>';
	echo '<tr><td>Safe mode</td><td>: ' . ((@ini_get('safe_mode')) ? '<font color="red"><b>' . $lang['Yes'] . '</b></font>' : $lang['No'] . ' - <font color="green"><b>OK</b></font>') . '</td></tr>';

	if (!( function_exists('imagecreatefromjpeg') ))
	{
		echo '<tr><td><font color="red"><b>imagecreatefromjpeg()</b></font></td><td>: <font color="red">' . $lang['function_ct_not_exists'] . '</b></td></tr>';
	}
	else
	{
		echo '<tr><td><b>imagecreatefromjpeg()</b></td><td>: ' . $lang['gd_loaded'] . ' - <font color="green"><b>OK</b></font></td></tr>';
	}
	if ( !( function_exists('imagecreate') ) && !( function_exists('imagecreate') ) )
	{
		echo '<tr><td><font color="red"><b>imagecreate()</b></font></td><td>: <font color="red">' . $lang['function_ct_not_exists'] . '</b></td></tr>';	
	}
	else
	{
		$gd_version = (function_exists('imagecreatetruecolor')) ? 2 : 1;
		echo '<tr><td><b>imagecreate()</b></td><td>: ' . sprintf($lang['function_gd'], $gd_version) . ' - <font color="green"><b>OK</b></font></td></tr>';
	}
	if (!@extension_loaded('zlib'))
	{
		echo '<tr><td><font color="red"><b>zlib</b></font></td><td>: <font color="red">' . $lang['function_zlip_not_exists'] . '</b></td></tr>';
	}
	else
	{
		echo '<tr><td><b>zlib</b></td><td>: ' . $lang['loaded'] . ' - <font color="green"><b>OK</b></font></b></td></tr>';	
	}
	echo '</table>';
	echo '</tr></td></table><hr /><table><tr><td valign="top"><table border="0">';

	$files_check = array('album_mod/upload', 'album_mod/upload/tmp', 'album_mod/upload/cache', 'album_mod/upload/cache/tmp', 'files', 'files/tmp', 'files/thumbs', 'images/avatars', 'images/avatars/tmp', 'images/avatars/upload', 'images/avatars/upload/tmp', 'images/photos/tmp', 'images/signatures', 'images/signatures/tmp', 'pafiledb/uploads', 'cache');
	for($i = 0; $i < count($files_check); $i++)
	{
		if ( $i == 8 )
		{
			echo '</table></td><td>&nbsp;&nbsp;&nbsp;</td><td valign="top"><table border="0">';
		}
		if ( @touch($phpbb_root_path . $files_check[$i] . '/test') )
		{
			@unlink($phpbb_root_path . $files_check[$i] . '/test');
			echo '<tr><td nowrap="nowrap">/<b>' . $files_check[$i] . '</b>/</td><td nowrap="nowrap">: ' . $lang['is_writable'] . ' - <font color="green"><b>OK</b></font></td></tr>';
		}
		else
		{
			echo '<tr><td><font color="red">/<b>' . $files_check[$i] . '</b>/</font></td><td>: <font color="red"><b>' . $lang['not_writable'] . ' !</b></font> <font size="1">' . $lang['set_chmod'] . ' <b>chmod 777 ' . $files_check[$i] . '</b></font></td></tr>';
		}
	}
	echo '</table></td></tr></table>';
}
else
{
	require($phpbb_root_path . 'language/lang_english/lang_portal.' . (($phpEx) ? $phpEx : '.php')); 
}

include($phpbb_root_path . 'check_data.'.$phpEx);

$dir = @opendir($phpbb_root_path . 'includes/mods_info/');
$mod_name = $add_size = array();
while (($filename = @readdir($dir)) !== false)
{
	if (@preg_match('/(\.php$)$/is', $filename))
	{
		$file = $phpbb_root_path . 'includes/mods_info/'.$filename;
		include($file);
	}
}
@closedir($dir);

if ( count($mod_name) > 0 )
{
	echo '<hr /><font color="blue"><b>Zainstalowane mody</b>:</font><br />' . $contents;
	for($i=0; count($mod_name) > $i; $i++)
	{
		echo ($i+1) . ' - <b>' . htmlspecialchars(substr($mod_name[$i], 0, 80)) . '</b></br />';
	}
}

if ( isset($HTTP_GET_VARS['set_sum']) )
{
	for($i=0; count($file_list) > $i; $i++)
	{
		$md5_set_sum = md5_checksum($phpbb_root_path . $file_list[$i] . '');
		echo '$md5_sum[\'' . ((@preg_match('/(\.php$)$/is', $file_list[$i])) ? str_replace('.php', '.\'.$phpEx', $file_list[$i]) . ']' : $file_list[$i] . '\']') . ' = \'' . $md5_set_sum . '\';<br />';
	}
	exit;
}

if ( isset($HTTP_GET_VARS['set_size']) )
{
	for($i=0; count($file_list) > $i; $i++)
	{
		$sizes = strlen_used_chars($phpbb_root_path . $file_list[$i] . '');
		echo '$sizes[\'' . ((@preg_match('/(\.php$)$/is', $file_list[$i])) ? str_replace('.php', '.\'.$phpEx', $file_list[$i]) . ']' : $file_list[$i] . '\']') . ' = \'' . $sizes . '\';<br />';
	}
	exit;
}

echo '<hr /><table><tr><td><b>' . $lang['fcr'] . '</b></td></tr></table>';

$result = '';
for($i=0; count($file_list) > $i; $i++)
{
	if ( md5_checksum($file_list[$i]) != trim($md5_sum[$file_list[$i]]) )
	{
		$content = md5_checksum($file_list[$i]);
		$filesize = strlen_used_chars($phpbb_root_path . $file_list[$i]);
		$mod_file = (isset($add_size[$file_list[$i]])) ? true : false;
		if ( !$mod_file || ($filesize != $sizes[$file_list[$i]] + $add_size[$file_list[$i]])  )
		{
			$file_name = ($add_size[$file_list[$i]]) ? '<font color="blue">' . $file_list[$i] . '</font>' : $file_list[$i];
			$result .= ($content) ? '
			<tr>
				<td><b><font style="font-family: Arial, Helvetica; font-size: 11px;">' . $file_name . '</font></b></td>
				<td nowrap="nowrap">: <b><font style="font-family: Arial; font-size: 11px;" color="red">' . $lang['wrong_content'] . ' !</font></b><font style="font-family: Arial; font-size: 11px;"> [ ' . $content . ' ] &gt; [ ' . trim($md5_sum[$file_list[$i]]) . ' ]</font> </td>
				<td align="right" nowrap="nowrap"><font style="font-family: Arial; font-size: 11px;"> ' . $filesize . ' - ' . $sizes[$file_list[$i]] . ' (' . ($filesize - $sizes[$file_list[$i]] - $add_size[$file_list[$i]]) . ')</font></td>
			</tr>
			' : '
			<tr>
				<td><font color="red" style="font-family: Arial, Helvetica; font-size: 11px;"><b>' . $file_list[$i] . '</b></font></td><td>: <b>' . $lang['file_missing'] . ' !</b></td>
			</tr>';
			$wrong_content = true;
		}
		else if ($mod_file)
		{
			$result .= ($content) ? '
			<tr>
				<td><b><font color="blue" style="font-family: Arial, Helvetica; font-size: 11px;">' . $file_list[$i] . '</font></b></td>
				<td nowrap="nowrap">: <b><font color="green" style="font-family: Arial; font-size: 11px;">' . modyfikowany . ' </font></b><font style="font-family: Arial; font-size: 11px;"> [ ' . $content . ' ] &gt; [ ' . trim($md5_sum[$file_list[$i]]) . ' ]</font> </td>
				<td align="right" nowrap="nowrap"><font style="font-family: Arial; font-size: 11px;"> ' . $filesize . ' - ' . $sizes[$file_list[$i]] . ' (' . ($filesize - $sizes[$file_list[$i]] - $add_size[$file_list[$i]]) . ')</font></td>
			</tr>
			' : '
			<tr>
				<td><font color="red" style="font-family: Arial, Helvetica; font-size: 11px;"><b>' . $file_list[$i] . '</b></font></td><td>: <b>' . $lang['file_missing'] . ' !</b></td>
			</tr>';
		}
	}
}
$echo = ( $result ) ? '
<table border="0">
	<tr>
	   <td><font size="2">Nazwa pliku</font> </td>
	   <td nowrap="nowrap"><font size="1">[ suma obecna ] &gt; [ suma prawidowa ] </td>
	   <td align="right" nowrap="nowrap"><font size="1"> Ilo znakw:<br />Aktualnie - Oryginalnie</font></td>
	</tr>
	' . $result . '
</table>
<table>
	<tr>
	   <td>&nbsp;</td>
	</tr>
	<tr>
	   <td>' . (($wrong_content) ? '<font color="red">' . $lang['result_e'] : '<font color="green"><b>' . sprintf($lang['all_files_ok'], count($file_list)) . ' !</b>') . '</font></td>
	</tr>
</table>
' : '
<table>
	<tr>
	   <td>&nbsp;</td>
	</tr>
	<tr>
	   <td><font color="green"><b>' . sprintf($lang['all_files_ok'], count($file_list)) . ' !</b></font></td>
	</tr>
	' . $result . '
</table>';
echo $echo . '</td></tr></table></body></html>';

@$db->sql_close();
exit;

?>