#
# Basic DB data for phpBB2 modified v1.9 by Przemo
#

#
# Table structure for table 'phpbb_auth_access'
#
CREATE TABLE phpbb_auth_access (
   group_id mediumint(8) DEFAULT '0' NOT NULL,
   forum_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   auth_view tinyint(1) DEFAULT '0' NOT NULL,
   auth_read tinyint(1) DEFAULT '0' NOT NULL,
   auth_post tinyint(1) DEFAULT '0' NOT NULL,
   auth_reply tinyint(1) DEFAULT '0' NOT NULL,
   auth_edit tinyint(1) DEFAULT '0' NOT NULL,
   auth_delete tinyint(1) DEFAULT '0' NOT NULL,
   auth_sticky tinyint(1) DEFAULT '0' NOT NULL,
   auth_announce tinyint(1) DEFAULT '0' NOT NULL,
   auth_globalannounce TINYINT (1) NOT NULL,
   auth_vote tinyint(1) DEFAULT '0' NOT NULL,
   auth_pollcreate tinyint(1) DEFAULT '0' NOT NULL,
   auth_attachments tinyint(1) DEFAULT '0' NOT NULL,
   auth_mod tinyint(1) DEFAULT '0' NOT NULL, 
   auth_download TINYINT(1) DEFAULT '0' NOT NULL,
   KEY group_id (group_id),
   KEY forum_id (forum_id)
);


#
# Table structure for table 'phpbb_user_group'
#
CREATE TABLE phpbb_user_group (
   group_id mediumint(8) DEFAULT '0' NOT NULL,
   user_id mediumint(8) DEFAULT '0' NOT NULL,
   user_pending tinyint(1), 
   KEY group_id (group_id),
   KEY user_id (user_id)
);

#
# Table structure for table 'phpbb_groups'
#
CREATE TABLE phpbb_groups (
   group_id mediumint(8) NOT NULL AUTO_INCREMENT,
   group_type tinyint(4) DEFAULT '1' NOT NULL, 
   group_name varchar(40) NOT NULL,
   group_description varchar(255) NOT NULL,
   group_moderator mediumint(8) DEFAULT '0' NOT NULL, 
   group_single_user tinyint(1) DEFAULT '1' NOT NULL, 
   group_order MEDIUMINT(8) DEFAULT '0' NOT NULL,
   group_count INT (4) UNSIGNED DEFAULT '99999999',
   group_count_enable SMALLINT (2) UNSIGNED DEFAULT '0',
   PRIMARY KEY (group_id), 
   KEY group_single_user (group_single_user)
);

#
# Table structure for table 'phpbb_banlist'
#
CREATE TABLE phpbb_banlist (
   ban_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   ban_userid mediumint(8) NOT NULL,
   ban_ip char(8) NOT NULL,
   ban_email varchar(255),
   ban_time int(11) DEFAULT NULL,
   ban_expire_time int(11) DEFAULT NULL,
   ban_by_userid mediumint(8) DEFAULT NULL,
   ban_by TEXT,
   ban_priv_reason text,
   ban_pub_reason_mode tinyint(1) DEFAULT NULL,
   ban_pub_reason TEXT,
   ban_reason TEXT,
   PRIMARY KEY (ban_id), 
   KEY ban_ip_user_id (ban_ip, ban_userid)
);

#
# Table structure for table 'phpbb_categories'
#

CREATE TABLE phpbb_categories (
   cat_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   cat_title varchar(100),
   cat_order mediumint(8) UNSIGNED NOT NULL,
   cat_main_type CHAR(1),
   cat_main MEDIUMINT(8) UNSIGNED DEFAULT '0' NOT NULL,
   cat_desc TEXT NOT NULL,
   PRIMARY KEY (cat_id), 
   KEY cat_order (cat_order)
);

#
# Table structure for table 'phpbb_config'
#
CREATE TABLE phpbb_config ( 
    config_name varchar(255) NOT NULL, 
    config_value text NOT NULL, 
    PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_disallow'
#
CREATE TABLE phpbb_disallow (
   disallow_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   disallow_username varchar(25) DEFAULT '' NOT NULL,
   PRIMARY KEY (disallow_id)
);

#
# Table structure for table 'phpbb_forum_prune'
#
CREATE TABLE phpbb_forum_prune (
   prune_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   forum_id smallint(5) UNSIGNED NOT NULL,
   prune_days smallint(5) UNSIGNED NOT NULL,
   prune_freq smallint(5) UNSIGNED NOT NULL,
   PRIMARY KEY(prune_id),
   KEY forum_id (forum_id)
);

#
# Table structure for table 'phpbb_forums'
#
CREATE TABLE phpbb_forums (
   forum_id smallint(5) UNSIGNED NOT NULL,
   cat_id mediumint(8) UNSIGNED NOT NULL,
   forum_name varchar(150),
   forum_desc text,
   forum_status tinyint(4) DEFAULT '0' NOT NULL, 
   forum_order mediumint(8) UNSIGNED DEFAULT '1' NOT NULL,
   forum_posts mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   forum_topics mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   forum_last_post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   prune_next int(11),
   prune_enable tinyint(1) DEFAULT '0' NOT NULL,
   auth_view tinyint(2) DEFAULT '0' NOT NULL,
   auth_read tinyint(2) DEFAULT '0' NOT NULL,
   auth_post tinyint(2) DEFAULT '0' NOT NULL,
   auth_reply tinyint(2) DEFAULT '0' NOT NULL,
   auth_edit tinyint(2) DEFAULT '0' NOT NULL,
   auth_delete tinyint(2) DEFAULT '0' NOT NULL,
   auth_sticky tinyint(2) DEFAULT '0' NOT NULL,
   auth_announce tinyint(2) DEFAULT '0' NOT NULL,
   auth_globalannounce TINYINT (2) DEFAULT '3' NOT NULL,
   auth_vote tinyint(2) DEFAULT '0' NOT NULL,
   auth_pollcreate tinyint(2) DEFAULT '0' NOT NULL,
   auth_attachments tinyint(2) DEFAULT '0' NOT NULL,
   auth_download TINYINT(2) DEFAULT '0' NOT NULL,
   password varchar(20) NOT NULL DEFAULT '',
   forum_sort TEXT NOT NULL,
   forum_color varchar(20) NOT NULL DEFAULT  '',
   forum_link VARCHAR(255),
   forum_link_internal TINYINT(1) NOT NULL,
   forum_link_hit_count TINYINT(1) NOT NULL,
   forum_link_hit BIGINT(20) UNSIGNED NOT NULL,
   main_type CHAR(1),
   forum_moderate tinyint(1) DEFAULT '0' NOT NULL,
   no_count tinyint(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (forum_id),
   KEY forums_order (forum_order),
   KEY cat_id (cat_id), 
   KEY forum_last_post_id (forum_last_post_id)
);

#
# Table structure for table 'phpbb_posts'
#
CREATE TABLE phpbb_posts (
   post_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   topic_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   forum_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   poster_id mediumint(8) DEFAULT '0' NOT NULL,
   post_time int(11) DEFAULT '0' NOT NULL,
   poster_ip char(8) NOT NULL, 
   post_username varchar(25), 
   enable_bbcode tinyint(1) DEFAULT '1' NOT NULL,
   enable_html tinyint(1) DEFAULT '0' NOT NULL,
   enable_smilies tinyint(1) DEFAULT '1' NOT NULL,
   enable_sig tinyint(1) DEFAULT '1' NOT NULL, 
   post_edit_time int(11),
   post_edit_count smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   post_attachment TINYINT(1) DEFAULT '0' NOT NULL,
   user_agent TEXT,
   post_icon TINYINT(2) UNSIGNED NOT NULL DEFAULT '0',
   post_expire INT(255) UNSIGNED NOT NULL DEFAULT '0',
   reporter_id MEDIUMINT(8) DEFAULT '0' NOT NULL,
   post_marked enum('n','y') NULL,
   post_approve tinyint(1) DEFAULT '1' NOT NULL,
   poster_delete tinyint(1) DEFAULT '0',
   PRIMARY KEY (post_id),
   KEY forum_id (forum_id),
   KEY topic_id (topic_id),
   KEY poster_id (poster_id), 
   KEY post_time (post_time),
   KEY reporter_id (reporter_id)
);

#
# Table structure for table 'phpbb_posts_text'
#
CREATE TABLE phpbb_posts_text (
   post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   bbcode_uid char(10) NOT NULL,
   post_subject char(60),
   post_text text,
   PRIMARY KEY (post_id)
);

#
# Table structure for table 'phpbb_privmsgs'
#
CREATE TABLE phpbb_privmsgs (
   privmsgs_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   privmsgs_type tinyint(4) DEFAULT '0' NOT NULL,
   privmsgs_subject varchar(255) DEFAULT '0' NOT NULL,
   privmsgs_from_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_to_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_date int(11) DEFAULT '0' NOT NULL,
   privmsgs_ip char(8) NOT NULL,
   privmsgs_enable_bbcode tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_enable_html tinyint(1) DEFAULT '0' NOT NULL,
   privmsgs_enable_smilies tinyint(1) DEFAULT '1' NOT NULL, 
   privmsgs_attach_sig tinyint(1) DEFAULT '1' NOT NULL, 
   privmsgs_attachment TINYINT(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (privmsgs_id),
   KEY privmsgs_from_userid (privmsgs_from_userid),
   KEY privmsgs_to_userid (privmsgs_to_userid)
);

#
# Table structure for table 'phpbb_privmsgs_text'
#
CREATE TABLE phpbb_privmsgs_text (
   privmsgs_text_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   privmsgs_bbcode_uid char(10) DEFAULT '0' NOT NULL, 
   privmsgs_text text,
   PRIMARY KEY (privmsgs_text_id)
);

#
# Table structure for table 'phpbb_ranks'
#
CREATE TABLE phpbb_ranks (
   rank_id smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
   rank_title varchar(50) NOT NULL,
   rank_min mediumint(8) DEFAULT '0' NOT NULL,
   rank_special tinyint(1) DEFAULT '0',
   rank_image varchar(255),
   rank_group MEDIUMINT(8) NOT NULL,
   PRIMARY KEY (rank_id) 
);

#
# Table structure for table `phpbb_search_results`
#
CREATE TABLE phpbb_search_results (
  search_id int(11) UNSIGNED NOT NULL DEFAULT '0',
  session_id char(32) NOT NULL DEFAULT '',
  search_array text NOT NULL,
  PRIMARY KEY  (search_id),
  KEY session_id (session_id)
);

#
# Table structure for table `phpbb_search_wordlist`
#
CREATE TABLE phpbb_search_wordlist (
  word_text varchar(50) binary NOT NULL DEFAULT '',
  word_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  word_common tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (word_text), 
  KEY word_id (word_id)
);

#
# Table structure for table `phpbb_search_wordmatch`
#
CREATE TABLE phpbb_search_wordmatch (
  post_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  word_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  title_match tinyint(1) NOT NULL DEFAULT '0',
  KEY post_id (post_id),
  KEY word_id (word_id)
);

#
# Table structure for table 'phpbb_sessions'
#
# Note that if you're running 3.23.x you may want to make
# this table a type HEAP. This type of table is stored
# within system memory and therefore for big busy boards
# is likely to be noticeably faster than continually
# writing to disk ... 
#
# I must admit I read about this type on vB's board.
# Hey, I never said you cannot get basic ideas from
# competing boards, just that I find it's best not to
# look at any code ... !
#
CREATE TABLE phpbb_sessions (
   session_id char(32) DEFAULT '' NOT NULL,
   session_user_id mediumint(8) DEFAULT '0' NOT NULL,
   session_start int(11) DEFAULT '0' NOT NULL,
   session_time int(11) DEFAULT '0' NOT NULL,
   session_ip char(8) DEFAULT '0' NOT NULL,
   session_page int(11) DEFAULT '0' NOT NULL,
   session_logged_in tinyint(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (session_id),
   KEY session_user_id (session_user_id),
   KEY session_id_ip_user_id (session_id, session_ip, session_user_id)
);

#
# Table structure for table 'phpbb_smilies'
#
CREATE TABLE phpbb_smilies (
   smilies_id smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
   code varchar(50),
   smile_url varchar(100),
   emoticon varchar(75),
   PRIMARY KEY (smilies_id)
);

#
# Table structure for table 'phpbb_themes'
#
CREATE TABLE phpbb_themes (
   themes_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT, 
   template_name varchar(30) NOT NULL DEFAULT '', 
   style_name varchar(30) NOT NULL DEFAULT '',
   head_stylesheet varchar(100) DEFAULT NULL,
   body_background varchar(100) DEFAULT NULL,
   body_bgcolor varchar(6) DEFAULT NULL,
   body_text varchar(6) DEFAULT NULL,
   body_link varchar(6) DEFAULT NULL,
   body_vlink varchar(6) DEFAULT NULL,
   body_alink varchar(6) DEFAULT NULL,
   body_hlink varchar(6) DEFAULT NULL,
   tr_color1 varchar(6) DEFAULT NULL,
   tr_color2 varchar(6) DEFAULT NULL,
   tr_color3 varchar(6) DEFAULT NULL,
   tr_class1 varchar(25) DEFAULT NULL,
   tr_class2 varchar(25) DEFAULT NULL,
   tr_class3 varchar(25) DEFAULT NULL,
   th_color1 varchar(6) DEFAULT NULL,
   th_color2 varchar(6) DEFAULT NULL,
   th_color3 varchar(6) DEFAULT NULL,
   th_class1 varchar(25) DEFAULT NULL,
   th_class2 varchar(25) DEFAULT NULL,
   th_class3 varchar(25) DEFAULT NULL,
   td_color1 varchar(6) DEFAULT NULL,
   td_color2 varchar(6) DEFAULT NULL,
   td_color3 varchar(6) DEFAULT NULL,
   td_class1 varchar(25) DEFAULT NULL,
   td_class2 varchar(25) DEFAULT NULL,
   td_class3 varchar(25) DEFAULT NULL,
   fontface1 varchar(50) DEFAULT NULL,
   fontface2 varchar(50) DEFAULT NULL,
   fontface3 varchar(50) DEFAULT NULL,
   fontsize1 tinyint(4) DEFAULT NULL,
   fontsize2 tinyint(4) DEFAULT NULL,
   fontsize3 tinyint(4) DEFAULT NULL,
   fontcolor1 varchar(6) DEFAULT NULL,
   fontcolor2 varchar(6) DEFAULT NULL,
   fontcolor3 varchar(6) DEFAULT NULL,
   span_class1 varchar(25) DEFAULT NULL,
   span_class2 varchar(25) DEFAULT NULL,
   span_class3 varchar(25) DEFAULT NULL, 
   img_size_poll smallint(5) UNSIGNED, 
   img_size_privmsg smallint(5) UNSIGNED, 
   PRIMARY KEY  (themes_id)
);

#
# Table structure for table 'phpbb_themes_name'
#
CREATE TABLE phpbb_themes_name (
   themes_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   tr_color1_name char(50),
   tr_color2_name char(50),
   tr_color3_name char(50),
   tr_class1_name char(50),
   tr_class2_name char(50),
   tr_class3_name char(50),
   th_color1_name char(50),
   th_color2_name char(50),
   th_color3_name char(50),
   th_class1_name char(50),
   th_class2_name char(50),
   th_class3_name char(50),
   td_color1_name char(50),
   td_color2_name char(50),
   td_color3_name char(50),
   td_class1_name char(50),
   td_class2_name char(50),
   td_class3_name char(50),
   fontface1_name char(50),
   fontface2_name char(50),
   fontface3_name char(50),
   fontsize1_name char(50),
   fontsize2_name char(50),
   fontsize3_name char(50),
   fontcolor1_name char(50),
   fontcolor2_name char(50),
   fontcolor3_name char(50),
   span_class1_name char(50),
   span_class2_name char(50),
   span_class3_name char(50),
   PRIMARY KEY (themes_id)
);

#
# Table structure for table 'phpbb_topics'
#
CREATE TABLE phpbb_topics (
   topic_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   forum_id smallint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_title char(60) NOT NULL,
   topic_poster mediumint(8) DEFAULT '0' NOT NULL,
   topic_time int(11) DEFAULT '0' NOT NULL,
   topic_views mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_replies mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_status tinyint(3) DEFAULT '0' NOT NULL,
   topic_vote tinyint(1) DEFAULT '0' NOT NULL,
   topic_type tinyint(3) DEFAULT '0' NOT NULL,
   topic_first_post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_last_post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_moved_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_attachment TINYINT(1) DEFAULT '0' NOT NULL,
   topic_icon TINYINT (2) UNSIGNED DEFAULT '0' NOT NULL,
   topic_expire INT(255) UNSIGNED NOT NULL DEFAULT '0',
   topic_color varchar(25) DEFAULT NULL,
   topic_title_e char(100) NOT NULL,
   PRIMARY KEY (topic_id),
   KEY forum_id (forum_id),
   KEY topic_moved_id (topic_moved_id),
   KEY topic_status (topic_status), 
   KEY topic_type (topic_type) 
);

#
# Table structure for table 'phpbb_topics_watch'
#
CREATE TABLE phpbb_topics_watch (
  topic_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  user_id mediumint(8) NOT NULL DEFAULT '0',
  notify_status tinyint(1) NOT NULL DEFAULT '0',
  KEY topic_id (topic_id),
  KEY user_id (user_id), 
  KEY notify_status (notify_status)
);

#
# Table structure for table 'phpbb_users'
#
CREATE TABLE phpbb_users (
   user_id mediumint(8) NOT NULL,
   user_active tinyint(1) DEFAULT '1',
   username varchar(25) NOT NULL,
   user_password varchar(32) NOT NULL,
   user_session_time int(11) DEFAULT '0' NOT NULL, 
   user_session_page smallint(5) DEFAULT '0' NOT NULL, 
   user_lastvisit int(11) DEFAULT '0' NOT NULL, 
   user_regdate int(11) DEFAULT '0' NOT NULL, 
   user_level tinyint(4) DEFAULT '0',
   user_posts mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   user_timezone decimal(5,2) DEFAULT '0' NOT NULL,
   user_style tinyint(4),
   user_lang varchar(255),
   user_dateformat varchar(14) DEFAULT 'd M Y H:i' NOT NULL,
   user_new_privmsg smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   user_unread_privmsg smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   user_last_privmsg int(11) DEFAULT '0' NOT NULL, 
   user_emailtime int(11), 
   user_viewemail tinyint(1) DEFAULT '1', 
   user_attachsig tinyint(1) DEFAULT '1', 
   user_allowhtml tinyint(1) DEFAULT '1', 
   user_allowbbcode tinyint(1) DEFAULT '1', 
   user_allowsmile tinyint(1) DEFAULT '1', 
   user_allowavatar tinyint(1) DEFAULT '1' NOT NULL, 
   user_allowsig TINYINT(1) DEFAULT '1' NOT NULL,
   user_allow_pm tinyint(1) DEFAULT '1' NOT NULL, 
   user_allow_viewonline tinyint(1) DEFAULT '1' NOT NULL, 
   user_notify tinyint(1) DEFAULT '1' NOT NULL,
   user_notify_pm tinyint(1) DEFAULT '1' NOT NULL, 
   user_popup_pm tinyint(1) DEFAULT '0' NOT NULL,
   user_rank int(11) DEFAULT '0',
   user_avatar varchar(100),
   user_avatar_type tinyint(4) DEFAULT '0' NOT NULL, 
   user_email varchar(255),
   user_icq varchar(15),
   user_website varchar(100),
   user_from varchar(100),
   user_sig text,
   user_sig_bbcode_uid char(10),
   user_sig_image varchar(100) NOT NULL DEFAULT '',
   user_allow_signature tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
   user_allow_sig_image tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
   user_aim varchar(255),
   user_yim varchar(255),
   user_msnm varchar(255),
   user_occ varchar(100),
   user_interests varchar(255),
   user_actkey varchar(32),
   user_newpasswd varchar(32),
   user_posts_per_page VARCHAR (5) DEFAULT '15',
   user_topics_per_page VARCHAR (5) DEFAULT '15',
   user_hot_threshold VARCHAR (5) DEFAULT '35',
   user_birthday INT DEFAULT '999999' NOT NULL,
   user_next_birthday_greeting INT DEFAULT '0' NOT NULL,
   user_custom_rank VARCHAR(255),
   user_photo VARCHAR(100),
   user_photo_type TINYINT(4) DEFAULT '0' NOT NULL,
   user_custom_color VARCHAR(6),
   user_showavatars tinyint(1) DEFAULT '1',
   page_avatar tinyint(1) DEFAULT '1',
   user_traffic INT(255) DEFAULT '999999' NOT NULL,
   user_badlogin SMALLINT(5) NOT NULL,
   user_blocktime INT(11) NOT NULL,
   user_block_by VARCHAR (8),
   disallow_forums VARCHAR (99),
   can_custom_ranks TINYINT(1) DEFAULT '1' NOT NULL,
   can_custom_color TINYINT(1) DEFAULT '1' NOT NULL,
   user_gender TINYINT NOT NULL DEFAULT '0',
   user_sub_forum TINYINT(1) DEFAULT '1' NOT NULL,
   user_split_cat TINYINT(1) DEFAULT '0' NOT NULL,
   user_last_topic_title TINYINT(1) DEFAULT '1' NOT NULL,
   user_sub_level_links TINYINT(1) DEFAULT '2' NOT NULL,
   user_display_viewonline TINYINT(1) DEFAULT '2' NOT NULL,
   view_ignore_topics tinyint(1) DEFAULT '1',
   can_topic_color TINYINT(1) DEFAULT '1' NOT NULL,
   user_notify_gg tinyint(1) DEFAULT '0' NOT NULL,
   allowpm tinyint(1) DEFAULT '1',
   no_report_popup TINYINT(1) DEFAULT '0' NOT NULL,
   refresh_report_popup TINYINT(1) DEFAULT '0' NOT NULL,
   no_report_mail TINYINT(1) DEFAULT '0' NOT NULL,
   user_avatar_width SMALLINT,
   user_avatar_height SMALLINT,
   special_rank mediumint(8) UNSIGNED NULL,
   user_allow_helped tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
   user_ip CHAR(8) DEFAULT '',
   PRIMARY KEY (user_id), 
   KEY user_session_time (user_session_time)
);

#
# Table structure for table 'phpbb_vote_desc'
#
CREATE TABLE phpbb_vote_desc (
  vote_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  topic_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  vote_text text NOT NULL,
  vote_start int(11) NOT NULL DEFAULT '0',
  vote_length int(11) NOT NULL DEFAULT '0',
  vote_max INT(3) DEFAULT '1' NOT NULL,
  vote_voted INT(7) DEFAULT '0' NOT NULL,
  vote_hide TINYINT(1) DEFAULT '0' NOT NULL,
  vote_tothide TINYINT(1) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (vote_id),
  KEY topic_id (topic_id)
);

#
# Table structure for table 'phpbb_vote_results'
#
CREATE TABLE phpbb_vote_results (
  vote_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  vote_option_id tinyint(4) UNSIGNED NOT NULL DEFAULT '0',
  vote_option_text varchar(255) NOT NULL,
  vote_result int(11) NOT NULL DEFAULT '0',
  KEY vote_option_id (vote_option_id),
  KEY vote_id (vote_id)
);

#
# Table structure for table 'phpbb_vote_voters'
#
CREATE TABLE phpbb_vote_voters (
  vote_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  vote_user_id mediumint(8) NOT NULL DEFAULT '0',
  vote_user_ip char(8) NOT NULL,
  vote_cast TINYINT(4) UNSIGNED DEFAULT '0' NOT NULL,
  KEY vote_id (vote_id),
  KEY vote_user_id (vote_user_id),
  KEY vote_user_ip (vote_user_ip)
);

#
# Table structure for table 'phpbb_words'
#
CREATE TABLE phpbb_words (
   word_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   word char(100) NOT NULL,
   replacement text NOT NULL,
   PRIMARY KEY (word_id)
);

# ----------modified----------------

#
#
# Table structure for table 'phpbb_album'
#
CREATE TABLE phpbb_album (
   pic_id int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
   pic_filename varchar(255) NOT NULL,
   pic_thumbnail varchar(255),
   pic_title varchar(255) NOT NULL,
   pic_desc text,
   pic_user_id mediumint(8) NOT NULL,
   pic_username varchar(32),
   pic_user_ip char(8) NOT NULL DEFAULT '0',
   pic_time int(11) UNSIGNED NOT NULL,
   pic_cat_id mediumint(8) UNSIGNED NOT NULL DEFAULT '1',
   pic_view_count int(11) UNSIGNED NOT NULL DEFAULT '0',
   pic_lock tinyint(3) NOT NULL DEFAULT '0',
   pic_approval tinyint(3) NOT NULL DEFAULT '1',
   PRIMARY KEY (pic_id),
   KEY pic_cat_id (pic_cat_id),
   KEY pic_user_id (pic_user_id),
   KEY pic_time (pic_time));

#
# Table structure for table 'phpbb_album_rate'
#
CREATE TABLE phpbb_album_rate (
   rate_pic_id int(11) UNSIGNED NOT NULL,
   rate_user_id mediumint(8) NOT NULL,
   rate_user_ip char(8) NOT NULL,
   rate_point tinyint(3) UNSIGNED NOT NULL,
   KEY rate_pic_id (rate_pic_id),
   KEY rate_user_id (rate_user_id),
   KEY rate_user_ip (rate_user_ip),
   KEY rate_point (rate_point)
);

#
# Table structure for table 'phpbb_album_comment'
#
CREATE TABLE phpbb_album_comment (
   comment_id int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
   comment_pic_id int(11) UNSIGNED NOT NULL,
   comment_user_id mediumint(8) NOT NULL,
   comment_username varchar(32),
   comment_user_ip char(8) NOT NULL,
   comment_time int(11) UNSIGNED NOT NULL,
   comment_text TEXT,
   comment_edit_time int(11) UNSIGNED,
   comment_edit_count smallint(5) UNSIGNED NOT NULL DEFAULT '0',
   comment_edit_user_id mediumint(8),
   PRIMARY KEY(comment_id),
   KEY comment_pic_id (comment_pic_id),
   KEY comment_user_id (comment_user_id),
   KEY comment_user_ip (comment_user_ip),
   KEY comment_time (comment_time)
);

#
# Table structure for table 'phpbb_album_cat'
#
CREATE TABLE phpbb_album_cat (
   cat_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
   cat_parent mediumint UNSIGNED NOT NULL DEFAULT 0,
   cat_type tinyint NOT NULL DEFAULT 0,
   cat_title varchar(255) NOT NULL,
   cat_desc text,
   cat_order mediumint(8) NOT NULL,
   cat_view_level tinyint(3) NOT NULL DEFAULT '-1',
   cat_upload_level tinyint(3) NOT NULL DEFAULT '0',
   cat_rate_level tinyint(3) NOT NULL DEFAULT '0',
   cat_comment_level tinyint(3) NOT NULL DEFAULT '0',
   cat_edit_level tinyint(3) NOT NULL DEFAULT '0',
   cat_delete_level tinyint(3) NOT NULL DEFAULT '2',
   cat_view_groups varchar(255),
   cat_upload_groups varchar(255),
   cat_rate_groups varchar(255),
   cat_comment_groups varchar(255),
   cat_edit_groups varchar(255),
   cat_delete_groups varchar(255),
   cat_moderator_groups varchar(255),
   cat_approval tinyint(3) NOT NULL DEFAULT '0',
   PRIMARY KEY (cat_id),
   KEY cat_order (cat_order)
);

CREATE TABLE phpbb_album_config (
   config_name varchar(255) NOT NULL,
   config_value varchar(255) NOT NULL,
   PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_album_'
#
CREATE TABLE phpbb_attachments (
  attach_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
  post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
  privmsgs_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  user_id_1 mediumint(8) NOT NULL,
  user_id_2 mediumint(8) NOT NULL,
  KEY attach_id_post_id (attach_id, post_id),
  KEY attach_id_privmsgs_id (attach_id, privmsgs_id)
); 

#
# Table structure for table 'phpbb_attachments_config'
#
CREATE TABLE phpbb_attachments_config (
  config_name varchar(255) NOT NULL,
  config_value varchar(255) NOT NULL,
  PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_attachments_desc'
#
CREATE TABLE phpbb_attachments_desc (
  attach_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  physical_filename varchar(255) NOT NULL,
  real_filename varchar(255) NOT NULL,
  download_count mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  comment varchar(255),
  extension varchar(100),
  mimetype varchar(100),
  filesize int(20) NOT NULL,
  filetime int(11) DEFAULT '0' NOT NULL,
  thumbnail tinyint(1) DEFAULT '0' NOT NULL,
  PRIMARY KEY (attach_id),
  KEY filetime (filetime),
  KEY physical_filename (physical_filename(10)),
  KEY filesize (filesize)
);

#
# Table structure for table 'phpbb_anti_robotic_reg'
#
CREATE TABLE phpbb_anti_robotic_reg (
	session_id char(32) DEFAULT '' NOT NULL,
	reg_key char(4) NOT NULL,
	timestamp int(10) UNSIGNED NOT NULL,
	PRIMARY KEY (session_id)
);

#
# Table structure for table 'phpbb_attach_quota'
#
CREATE TABLE phpbb_attach_quota (
  user_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  group_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  quota_type smallint(2) NOT NULL DEFAULT '0',
  quota_limit_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  KEY quota_type (quota_type)
);

#
# Table structure for table 'phpbb_chatbox'
#
CREATE TABLE phpbb_chatbox (
  id int(11) NOT NULL AUTO_INCREMENT,
  name varchar(99) NOT NULL,
  msg varchar(255) NOT NULL,
  timestamp int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (id)
);

#
# Table structure for table 'phpbb_chatbox_session'
#
CREATE TABLE phpbb_chatbox_session (
  username varchar(99) NOT NULL,
  lastactive int(10) DEFAULT '0' NOT NULL,
  laststatus varchar(8) NOT NULL,
  UNIQUE username (username)
);

#
# Table structure for table 'phpbb_extensions'
#
CREATE TABLE phpbb_extensions (
  ext_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  group_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  extension varchar(100) NOT NULL,
  comment varchar(100),
  PRIMARY KEY ext_id (ext_id)
);

#
# Table structure for table 'phpbb_extension_groups'
#
CREATE TABLE phpbb_extension_groups (
  group_id mediumint(8) NOT NULL AUTO_INCREMENT,
  group_name char(20) NOT NULL,
  cat_id tinyint(2) DEFAULT '0' NOT NULL, 
  allow_group tinyint(1) DEFAULT '0' NOT NULL,
  download_mode tinyint(1) UNSIGNED DEFAULT '1' NOT NULL,
  upload_icon varchar(100) DEFAULT '',
  max_filesize int(20) DEFAULT '0' NOT NULL,
  forum_permissions varchar(255) DEFAULT '' NOT NULL,
  PRIMARY KEY group_id (group_id)
);

#
# Table structure for table 'phpbb_forbidden_extensions'
#
CREATE TABLE phpbb_forbidden_extensions (
  ext_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT, 
  extension varchar(100) NOT NULL, 
  PRIMARY KEY (ext_id)
);

#
# Table structure for table 'phpbb_ignore'
#
CREATE TABLE phpbb_ignores (
  user_id mediumint(8) NOT NULL DEFAULT '0',
  user_ignore mediumint(8) NOT NULL DEFAULT '0'
);

#
# Table structure for table 'phpbb_logs'
#
CREATE TABLE phpbb_logs (
  id_log MEDIUMINT(10) NOT NULL AUTO_INCREMENT,
  mode VARCHAR(50) NULL DEFAULT '', 
  topic_id MEDIUMINT(10) NULL DEFAULT '0',
  user_id MEDIUMINT(8) NULL DEFAULT '0',
  username VARCHAR(255) NULL DEFAULT '',
  user_ip CHAR(8) DEFAULT '0' NOT NULL,
  time INT(11) NULL DEFAULT '0',
  PRIMARY KEY (id_log)
);

#
# Table structure for table 'phpbb_pa_cat'
#
CREATE TABLE phpbb_pa_cat (
  cat_id int(10) NOT NULL AUTO_INCREMENT,
  cat_name text,
  cat_desc text,
  cat_files int(10) DEFAULT NULL,
  cat_1xid int(10) DEFAULT NULL,
  cat_parent int(50) DEFAULT NULL,
  cat_order int(50) DEFAULT NULL,
  PRIMARY KEY  (cat_id)
);


#
# Table structure for table `phpbb_pa_comments`
#

CREATE TABLE phpbb_pa_comments (
  comments_id int(10) NOT NULL AUTO_INCREMENT,
  file_id int(10) NOT NULL DEFAULT '0',
  comments_text text NOT NULL,
  comments_title text NOT NULL,
  comments_time int(50) NOT NULL DEFAULT '0',
  comment_bbcode_uid varchar(10) DEFAULT NULL,
  poster_id mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY  (comments_id),
  KEY comments_id (comments_id),
  KEY comment_bbcode_uid (comment_bbcode_uid)
);


#
# Table structure for table `phpbb_pa_custom`
#

CREATE TABLE phpbb_pa_custom (
  custom_id int(50) NOT NULL AUTO_INCREMENT,
  custom_name text NOT NULL,
  custom_description text NOT NULL,
  PRIMARY KEY  (custom_id)
);


#
# Table structure for table `phpbb_pa_customdata`
#

CREATE TABLE phpbb_pa_customdata (
  customdata_file int(50) NOT NULL DEFAULT '0',
  customdata_custom int(50) NOT NULL DEFAULT '0',
  data text NOT NULL
);


#
# Table structure for table `phpbb_pa_files`
#

CREATE TABLE phpbb_pa_files (
  file_id int(10) NOT NULL AUTO_INCREMENT,
  file_name text,
  file_desc text,
  file_creator text,
  file_version text,
  file_longdesc text,
  file_ssurl text,
  file_dlurl text,
  file_time int(50) DEFAULT NULL,
  file_catid int(10) DEFAULT NULL,
  file_posticon text,
  file_license int(10) DEFAULT NULL,
  file_dls int(10) DEFAULT NULL,
  file_last int(50) DEFAULT NULL,
  file_pin int(2) DEFAULT NULL,
  file_docsurl text,
  file_rating double(6,4) NOT NULL DEFAULT '0.0000',
  file_totalvotes int(255) NOT NULL DEFAULT '0',
  PRIMARY KEY  (file_id)
);


#
# Table structure for table `phpbb_pa_license`
#

CREATE TABLE phpbb_pa_license (
  license_id int(10) NOT NULL AUTO_INCREMENT,
  license_name text,
  license_text text,
  PRIMARY KEY  (license_id)
);


#
# Table structure for table `phpbb_pa_settings`
#

CREATE TABLE phpbb_pa_settings (
  settings_id int(1) NOT NULL DEFAULT '1',
  settings_dbname text NOT NULL,
  settings_sitename text NOT NULL,
  settings_dbdescription text NOT NULL,
  settings_dburl text NOT NULL,
  settings_topnumber int(5) NOT NULL DEFAULT '0',
  settings_homeurl text NOT NULL,
  settings_newdays int(5) NOT NULL DEFAULT '0',
  settings_stats int(5) NOT NULL DEFAULT '0',
  settings_viewall int(5) NOT NULL DEFAULT '0',
  settings_showss int(5) NOT NULL DEFAULT '0',
  settings_disable int(5) NOT NULL DEFAULT '0',
  allow_html int(5) NOT NULL DEFAULT '0',
  allow_bbcode int(5) NOT NULL DEFAULT '0',
  allow_smilies int(5) NOT NULL DEFAULT '0',
  allow_comment_links int(5) NOT NULL DEFAULT '0',
  no_comment_link_message varchar(255) NOT NULL DEFAULT '',
  allow_comment_images int(5) NOT NULL DEFAULT '0',
  no_comment_image_message varchar(255) NOT NULL DEFAULT '',
  max_comment_chars int(255) NOT NULL DEFAULT '0',
  directly_linked int(5) NOT NULL DEFAULT '0'
);

#
# Table structure for table `phpbb_pa_votes`
#

CREATE TABLE phpbb_pa_votes (
  votes_ip varchar(50) NOT NULL DEFAULT '0',
  votes_file int(50) NOT NULL DEFAULT '0'
);


#
# Table structure for table 'phpbb_portal_config'
#
CREATE TABLE phpbb_portal_config (
    config_name varchar(255) NOT NULL,
    config_value text NOT NULL,
    PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_quota_limits'
#
CREATE TABLE phpbb_quota_limits (
  quota_limit_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  quota_desc varchar(20) NOT NULL DEFAULT '',
  quota_limit bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY  (quota_limit_id)
);

#
# Table structure for table 'phpbb_read_history'
#
CREATE TABLE phpbb_read_history (
  user_id mediumint(8) NOT NULL DEFAULT '0',
  forum_id smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  topic_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  post_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  post_time int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (user_id, forum_id, topic_id, post_id, post_time),
  KEY user_id (user_id),
  KEY forum_id (forum_id),
  KEY topic_id (topic_id)
);

#
# Table structure for table 'phpbb_stats_config'
#
CREATE TABLE phpbb_stats_config (
  config_name varchar(50) NOT NULL DEFAULT '',
  config_value varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_stats_modules'
#
CREATE TABLE phpbb_stats_modules (
  module_id tinyint(8) NOT NULL DEFAULT '0',
  name varchar(150) NOT NULL DEFAULT '',
  active tinyint(1) NOT NULL DEFAULT '0',
  installed tinyint(1) NOT NULL DEFAULT '0',
  display_order mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  update_time mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  auth_value tinyint(2) NOT NULL DEFAULT '0',
  module_info_cache blob,
  module_db_cache blob,
  module_result_cache blob,
  module_info_time int(10) UNSIGNED NOT NULL DEFAULT '0',
  module_cache_time int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (module_id)
);

#
# Table structure for table 'phpbb_topic_view'
#
CREATE TABLE phpbb_topic_view ( 
  topic_id mediumint(8) NOT NULL, 
  user_id mediumint(8) NOT NULL, 
  view_time int(11) NOT NULL, 
  view_count int(11) NOT NULL
);

#
# Table structure for table 'phpbb_shoutbox'
#
CREATE TABLE phpbb_shoutbox (
  id int(11) NOT NULL AUTO_INCREMENT,
  sb_user_id int(11) NOT NULL,
  msg text NOT NULL,
  timestamp int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (id)
);

#
# Table structure for table 'phpbb_shoutbox_config'
#
CREATE TABLE phpbb_shoutbox_config ( 
    config_name varchar(255) NOT NULL, 
    config_value varchar(255) NOT NULL, 
    PRIMARY KEY (config_name)
);


CREATE TABLE phpbb_topics_ignore (
  topic_id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  user_id mediumint(8) DEFAULT '0' NOT NULL,
  PRIMARY KEY (topic_id, user_id)
);

#
# Table structure for table 'phpbb_birthday'
#
CREATE TABLE phpbb_birthday ( 
    user_id varchar(9) NOT NULL, 
    send_user_id varchar(9) NOT NULL, 
    send_year int(11) NOT NULL, 
    PRIMARY KEY (user_id, send_user_id, send_year)
);

#
# Table structure for table 'phpbb_jr_admin_users'
#
CREATE TABLE phpbb_jr_admin_users (
  user_id mediumint(9) NOT NULL DEFAULT '0',
  user_jr_admin longtext NOT NULL,
  start_date int(10) UNSIGNED NOT NULL DEFAULT '0',
  update_date int(10) UNSIGNED NOT NULL DEFAULT '0',
  admin_notes text NOT NULL,
  notes_view tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (user_id)
);

#
# Table structure for table 'phpbb_users_warnings'
#
CREATE TABLE phpbb_users_warnings (
  id mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  userid mediumint(8) NOT NULL DEFAULT '0',
  modid mediumint(8) NOT NULL DEFAULT '0',
  date int(11) NOT NULL DEFAULT '0',
  value mediumint(8) NOT NULL DEFAULT '0',
  reason text,
  archive tinyint(1) DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
);
