<?php
/***************************************************************************
 *						functions.php
 *						-------------------
 *	begin				: Saturday, Feb 13, 2001
 *	copyright			: (C) 2001 The phpBB Group
 *	email				: support@phpbb.com
 *	modification		: (C) 2003 Przemo http://www.przemo.org
 *	date modification	: ver. 1.9 2004/05/29 19:50
 *
 *	$Id: functions.php,v 1.8.9 2004/05/29 19:50
 *
 ***************************************************************************/

/***************************************************************************
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 ***************************************************************************/

//
// $nav_separator : used in the navigation sentence : ie Forum Index -> MainCat -> Forum -> Topic
// --------------
//--------------------------------------------------------------------------------------------------
$nav_separator = ' &raquo;&nbsp;';

// $tree : designed to get all the hierarchy
//	indexes :
//		- id : full designation : ie Root, f3, c20
//		- idx : rank order
//	$tree['keys'][id]			=> idx,
//	$tree['auth'][id]			=> auth_value array : ie tree['auth'][id]['auth_view'],
//	$tree['sub'][id]			=> array of sub-level ids,
//	$tree['main'][idx]			=> parent id,
//	$tree['type'][idx]			=> type of the row, can be 'c' for categories or 'f' for forums,
//	$tree['id'][idx]			=> value of the row id : cat_id for cats, forum_id for forums,
//	$tree['data'][idx]			=> db table row,
//	$tree['unread_topics'][idx]	=> boolean value to true if there is new topics
$tree = array();

function get_object_lang($cur, $field)
{
	global $board_config, $lang, $tree;
	$res	= '';
	$athis	= $tree['keys'][$cur];
	$type	= $tree['type'][$athis];
	if ( $cur == 'Root' )
	{
		switch($field)
		{
			case 'name':
				if ( isset($lang[$board_config['sitename']]) )
				{
					$res = sprintf($lang['Forum_Index'], $lang[$board_config['sitename']]);
				}
				else
				{
					$res = sprintf($lang['Forum_Index'], $board_config['sitename']);
				}
				break;
			case 'desc':
				if ( isset($lang[$board_config['site_desc']]) )
				{
					$res = $lang[$board_config['site_desc']];
				}
				else
				{
					$res = $board_config['site_desc'];
				}
				break;
		}
	}
	else
	{
		switch($field)
		{
			case 'name':
				$field = ($type == POST_CAT_URL) ? 'cat_title' : 'forum_name';
				break;
			case 'desc':
				$field = ($type == POST_CAT_URL) ? 'cat_desc' : 'forum_desc';
				break;
		}
		$res = ($tree['auth'][$cur]['auth_view']) ? $tree['data'][$athis][$field] : '';
		if ( isset($lang[$res]) )
		{
			$res = $lang[$res];
		}
	}
	return $res;
}

function fill_readhist_buffer(&$buffer, $user_id)
{
	global $board_config, $db, $userdata;

	$buffer = array();
	$sql_ignore_topics = '';
	if ( $board_config['ignore_topics'] )
	{
		$ignore_topics = $userdata['ignore_topics'];
		$sql_ignore_topics = ( $ignore_topics ) ? 'AND topic_id NOT IN (' . $ignore_topics . ')' : '';
	}

	$sql = "SELECT DISTINCT forum_id FROM " . READ_HIST_TABLE . "
			WHERE user_id = $user_id
				$sql_ignore_topics";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error in submit checking forum access', '', __LINE__, __FILE__, $sql);
	}
	while( $row = $db->sql_fetchrow($result) )
	{
		$buffer[$row['forum_id']] = true;
	}
}

function build_tree(&$cats, &$forums, &$new_topic_data, &$tracking_topics, &$tracking_forums, &$tracking_all, &$parents, $level = -1, $main = 'Root')
{
	global $db, $phpEx, $lang, $phpbb_root_path, $userdata, $user_ip;
	global $tree, $board_config, $readhist_buffer;

	$tree_level = array();

	// get the forums of the level
	for($i=0; $i < count($parents[POST_FORUM_URL][$main]); $i++)
	{
		$idx = $parents[POST_FORUM_URL][$main][$i];
		$tree_level['type'][] = POST_FORUM_URL;
		$tree_level['id'][]	= $forums[$idx]['forum_id'];
		$tree_level['sort'][] = $forums[$idx]['forum_order'];
		$tree_level['data'][] = $forums[$idx];
	}
	// add the categories of this level
	for($i=0; $i < count($parents[POST_CAT_URL][$main]); $i++)
	{
		$idx = $parents[POST_CAT_URL][$main][$i];
		$tree_level['type'][] = POST_CAT_URL;
		$tree_level['id'][]	= $cats[$idx]['cat_id'];
		$tree_level['sort'][] = $cats[$idx]['cat_order'];
		$tree_level['data'][] = $cats[$idx];
	}

	// sort both
	if ( !empty($tree_level['data']) )
	{
		array_multisort($tree_level['sort'], $tree_level['type'], $tree_level['id'], $tree_level['data']);
	}

	// add the tree_level to the tree
	$level++;
	$order = 0;
	for($i=0; $i < count($tree_level['data']); $i++)
	{
		$athis = count($tree['data']);
		$key = $tree_level['type'][$i] . $tree_level['id'][$i];
		$order = $order + 10;
		$tree['keys'][$key] = $athis;
		$tree['main'][]	= $main;
		$tree['type'][]	= $tree_level['type'][$i];
		$tree['id'][] = $tree_level['id'][$i];
		$tree['data'][]	= $tree_level['data'][$i];

		$tree['sub'][$main][] = $key;

		if ( !$board_config['read_tracking'] )
		{
			// cookies only set on forums
			$unread_topics = false;
			if ( $tree['type'][$athis] == POST_FORUM_URL )
			{
				$forum_id = $tree['id'][$athis];
				if ( !empty($new_topic_data[$forum_id]) )
				{
					$forum_last_post_time = 0;
					while( list($check_topic_id, $check_post_time) = @each($new_topic_data[$forum_id]) )
					{
						if ( empty($tracking_topics[$check_topic_id]) )
						{
							$unread_topics = true;
							$forum_last_post_time = max($check_post_time, $forum_last_post_time);
						}
						else
						{
							if ( $tracking_topics[$check_topic_id] < $check_post_time )
							{
								$unread_topics = true;
								$forum_last_post_time = max($check_post_time, $forum_last_post_time);
							}
						}
					}
					if ( !empty($tracking_forums[$forum_id]) )
					{
						if ( $tracking_forums[$forum_id] > $forum_last_post_time )
						{
							$unread_topics = false;
						}
					}
					if ( $tracking_all > $forum_last_post_time )
					{
						$unread_topics = false;
					}
				}
			}
			$tree['unread_topics'][$athis] = $unread_topics;
		}
		else
		{
			$forum_id = $tree['id'][$athis];
			if ( $userdata['session_logged_in'] )
			{
				if( !isset($readhist_buffer) )
				{
					fill_readhist_buffer($readhist_buffer, $userdata['user_id']);
				}

				if ( isset($readhist_buffer[$forum_id]) )
				{
					$tree['unread_topics'][$athis] = true;
				}
			}
		}
		// add sub levels
		build_tree($cats, $forums, $new_topic_data, $tracking_topics, $tracking_forums, $tracking_all, $parents, $level, $tree_level['type'][$i] . $tree_level['id'][$i]);
	}

	return;
}

function read_tree()
{
	global $db, $userdata, $board_config, $HTTP_COOKIE_VARS;
	global $tree;

	// get censored words
	$orig_word = array();
	$remplacement_word = array();
	obtain_word_list($orig_word, $replacement_word);

	// mains
	$parents = array();

	// read cats
	$cats = array();
	$sql = "SELECT * FROM " . CATEGORIES_TABLE . "
		ORDER BY cat_order, cat_id";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Couldn\'t access list of Categories', '', __LINE__, __FILE__, $sql);
	}
	while ($row = $db->sql_fetchrow($result))
	{
		if ( $row['cat_main'] == $row['cat_id'] )
		{
			$row['cat_main'] = 0;
		}
		if ( empty($row['cat_main_type']) )
		{
			$row['cat_main_type'] = POST_CAT_URL;
			$row['cat_order'] = $row['cat_order'] + 9000000;
		}
		$row['main'] = ($row['cat_main'] == 0) ? 'Root' : $row['cat_main_type'] . $row['cat_main'];
		$idx = count($cats);
		$cats[$idx] = $row;
		$parents[POST_CAT_URL][ $row['main'] ][] = $idx;
	}

	// read forums
	$forums = array();
	$sql = "SELECT f.*, p.post_time, p.post_username, u.username, u.user_id, t.topic_last_post_id, t.topic_title 
				FROM ((( " . FORUMS_TABLE . " f 
				LEFT JOIN " . POSTS_TABLE . " p ON p.post_id = f.forum_last_post_id ) 
				LEFT JOIN " . USERS_TABLE . " u ON u.user_id = p.poster_id ) 
				LEFT JOIN " . TOPICS_TABLE . " t ON t.topic_last_post_id = p.post_id
					AND t.forum_id = f.forum_id)
				ORDER BY f.forum_order, f.forum_id";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Couldn\'t access list of Forums', '', __LINE__, __FILE__, $sql);
	}
	while ($row = $db->sql_fetchrow($result))
	{
		$main_type = (empty($row['main_type'])) ? POST_CAT_URL : $row['main_type'];
		$row['main'] = ($row['cat_id'] == 0) ? 'Root' : $main_type . $row['cat_id'];
		if ( count($orig_word) )
		{
			$row['topic_title'] = preg_replace($orig_word, $replacement_word, $row['topic_title']);
		}
		$idx = count($forums);
		$forums[$idx] = $row;
		$parents[POST_FORUM_URL][ $row['main'] ][] = $idx;
	}

	if ( !$board_config['read_tracking'] )
	{
		// Obtain a list of topic ids which contain
		// posts made since user last visited
		$new_topic_data = array();
		if ( $userdata['session_logged_in'] )
		{
			$sql_ignore_topics = '';
			if ( $board_config['ignore_topics'] )
			{
				$ignore_topics = $userdata['ignore_topics'];
				$sql_ignore_topics = ( $ignore_topics ) ? 'AND t.topic_id NOT IN (' . $ignore_topics . ')' : '';
			}
			$user_lastvisit = $userdata['user_lastvisit'];

			$sql = "SELECT t.forum_id, t.topic_id, p.post_time 
				FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p 
				WHERE p.post_id = t.topic_last_post_id
					$sql_ignore_topics
					AND p.post_time > $user_lastvisit 
					AND t.topic_moved_id = 0"; 
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query new topic information', '', __LINE__, __FILE__, $sql);
			}

			while( $topic_data = $db->sql_fetchrow($result) )
			{
				$new_topic_data[$topic_data['forum_id']][$topic_data['topic_id']] = $topic_data['post_time'];
			}
		}
	}

	// read the user cookie
	if ( !$board_config['read_tracking'] )
	{
		$tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_t"]) : array();
		$tracking_forums = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_f"]) : array();
		$tracking_all = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) ) ? intval($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) : -1;
	}

	// build the tree
	$tree = array();
	build_tree($cats, $forums, $new_topic_data, $tracking_topics, $tracking_forums, $tracking_all, $parents);

	return;
}

function set_tree_user_auth()
{
	global $board_config, $userdata, $lang;
	global $tree;

	// read the tree from the bottom
	for($i = count($tree['data']) - 1; $i >= 0; $i--)
	{
		$cur = $tree['type'][$i] . $tree['id'][$i];
		$main = $tree['main'][$i];
		$main_idx = ($main == 'Root') ? -1 : $tree['keys'][$main];

		$auth_view = false;
		if ( isset($tree['auth'][$cur]['auth_view']) )
		{
			$auth_view = $tree['auth'][$cur]['auth_view'];
		}
		else if ( isset($tree['auth'][$cur]['tree.auth_view']) )
		{
			$auth_view = $tree['auth'][$cur]['tree.auth_view'];
		}
		$tree['auth'][$cur]['auth_view'] = $auth_view;
		if ( !isset($tree['auth'][$cur]['tree.auth_view']) )
		{
			$tree['auth'][$cur]['tree.auth_view'] = $auth_view;
		}

		// grant the main level
		if ( $main != 'Root' )
		{
			$tree['auth'][$main]['tree.auth_view'] = ($tree['auth'][$main]['tree.auth_view'] || $tree['auth'][$cur]['tree.auth_view']);
		}

		$auth_read = false;
		if ( isset($tree['auth'][$cur]['auth_read']) )
		{
			// forum auth
			$auth_read = $tree['auth'][$cur]['auth_read'];
		}
		$tree['auth'][$cur]['auth_read'] = $auth_read;

		$locked = true;
		if ( isset($tree['data'][$i]['forum_status']) )
		{
			$locked = ($tree['data'][$i]['forum_status'] == FORUM_LOCKED);
		}
		else if ( isset($tree['data'][$i]['tree.locked']) )
		{
			$locked = $tree['data'][$i]['tree.locked'];
		}
		$tree['data'][$i]['locked'] = $locked;

		if ( !isset($tree['data'][$i]['tree.locked']) )
		{
			$tree['data'][$i]['tree.locked'] = $locked;
		}
		$tree['data'][$i]['tree.locked'] = ($tree['data'][$i]['tree.locked'] && $locked);

		if ( !isset($tree['data'][$i]['tree.forum_posts']) )
		{
			$tree['data'][$i]['tree.forum_posts'] = 0;
			$tree['data'][$i]['tree.forum_topics'] = 0;
		}
		if ( $auth_view )
		{
			$tree['data'][$i]['tree.forum_posts'] += $tree['data'][$i]['forum_posts'];
			$tree['data'][$i]['tree.forum_topics'] += $tree['data'][$i]['forum_topics'];
		}

		if ( $main != 'Root' )
		{
			if ( !isset($tree['data'][$main_idx]['tree.locked']) )
			{
				$tree['data'][$main_idx]['tree.locked'] = $tree['data'][$i]['tree.locked'];
			}
			$tree['data'][$main_idx]['tree.locked'] = ($tree['data'][$main_idx]['tree.locked'] && $tree['data'][$i]['tree.locked']);

			if ( !isset($tree['data'][$main_idx]['tree.forum_posts']) )
			{
				$tree['data'][$main_idx]['tree.forum_posts'] = 0;
				$tree['data'][$main_idx]['tree.forum_topics'] = 0;
			}
			if ( $auth_view )
			{
				$tree['data'][$main_idx]['tree.forum_posts'] += $tree['data'][$i]['tree.forum_posts'];
				$tree['data'][$main_idx]['tree.forum_topics'] += $tree['data'][$i]['tree.forum_topics'];
			}
		}

		if ( $auth_read )
		{
			// fill the sub
			if ( empty($tree['data'][$i]['tree.topic_last_post_id']) || ($tree['data'][$i]['post_time'] > $tree['data'][$i]['tree.post_time']) )
			{
				$tree['data'][$i]['tree.topic_last_post_id'] = $tree['data'][$i]['topic_last_post_id'];
				$tree['data'][$i]['tree.post_time']	= $tree['data'][$i]['post_time'];
				$tree['data'][$i]['tree.post_user_id'] = $tree['data'][$i]['user_id'];
				$tree['data'][$i]['tree.post_username'] = ($tree['data'][$i]['user_id'] != ANONYMOUS) ? $tree['data'][$i]['username'] : ( (!empty($tree['data'][$i]['post_username'])) ? $tree['data'][$i]['post_username'] : $lang['Guest'] );
				$tree['data'][$i]['tree.topic_title'] = $tree['data'][$i]['topic_title'];
				$tree['data'][$i]['tree.unread_topics']	= $tree['unread_topics'][$i];
			}
		}

		// grant the main level
		if ( $main != 'Root' )
		{
			if ( empty($tree['data'][$main_idx]['tree.topic_last_post_id']) || ($tree['data'][$i]['tree.post_time'] > $tree['data'][$main_idx]['tree.post_time']) )
			{
				$tree['data'][$main_idx]['tree.topic_last_post_id']	= $tree['data'][$i]['tree.topic_last_post_id'];
				$tree['data'][$main_idx]['tree.post_time'] = $tree['data'][$i]['tree.post_time'];
				$tree['data'][$main_idx]['tree.post_user_id'] = $tree['data'][$i]['tree.post_user_id'];
				$tree['data'][$main_idx]['tree.post_username'] = $tree['data'][$i]['tree.post_username'];
				$tree['data'][$main_idx]['tree.topic_title'] = $tree['data'][$i]['tree.topic_title'];
				$tree['data'][$main_idx]['tree.unread_topics'] = $tree['data'][$i]['tree.unread_topics'];
			}
		}
	}
}

function get_user_tree(&$userdata)
{
	global $tree;

	if ( empty($tree) )
	{
		read_tree();
	}

	// read the user auth if requiered
	if ( empty($tree['auth']) )
	{
		$tree['auth'] = array();
		$wauth = auth(AUTH_ALL, AUTH_LIST_ALL, $userdata);
		if ( !empty($wauth) )
		{
			reset($wauth);
			while (list($key, $data) = each($wauth))
			{
				$tree['auth'][POST_FORUM_URL . $key] = $data;
			}
		}

		// enhanced each level
		set_tree_user_auth();
	}
	return;
}

function get_auth_keys($cur = 'Root', $all = false, $level = -1, $max = -1, $auth_key = 'auth_view')
{
	global $board_config;
	global $tree;

	$keys = array();
	$last_i = -1;

	// add the level

	if ( ($cur == 'Root') || $tree['auth'][$cur][$auth_key] || $all )
	{
		// push the level
		if ( ($max < 0) || ($level < $max) || (($level == $max) && ((substr($tree['main'][$tree['keys'][$cur]], 0, 1) == POST_CAT_URL) || ($tree['main'][$tree['keys'][$cur]] == 'Root') )) )
		{
			// if child of cat, align the level on the parent one
			$orig_level = $level;
			if ( !$all )
			{
				if ( ($level > 0) && ((substr($cur, 0, 1) == POST_FORUM_URL) || (intval($board_config['sub_forum']) > 0)) && (substr($tree['main'][$tree['keys'][$cur]], 0, 1) == POST_CAT_URL) )
				{
					$level = $level - 1;
				}
			}

			// store this level
			$last_i++;
			$keys['keys'][$cur]	= $last_i;
			$keys['id'][$last_i] = $cur;
			$keys['real_level'][$last_i] = $orig_level;
			$keys['level'][$last_i]	= $level;
			$keys['idx'][$last_i] = (isset($tree['keys'][$cur]) ? $tree['keys'][$cur] : -1);

			// get sub-levels
			for($i=0; $i < count($tree['sub'][$cur]); $i++)
			{
				$tkeys = array();
				$tkeys = get_auth_keys($tree['sub'][$cur][$i], $all, $orig_level+1, $max, $auth_key);

				// add sub-levels
				for($j=0; $j < count($tkeys['id']); $j++)
				{
					$last_i++;
					$keys['keys'][$tkeys['id'][$j]] = $last_i;
					$keys['id'][$last_i] = $tkeys['id'][$j];
					$keys['real_level'][$last_i] = $tkeys['real_level'][$j];
					$keys['level'][$last_i]	= $tkeys['level'][$j];
					$keys['idx'][$last_i] = $tkeys['idx'][$j];
				}
			}
		}
	}

	return $keys;
}

function get_max_depth($cur = 'Root', $all = false, $level = -1, &$keys, $max = -1)
{
	global $tree;
	if ( empty($keys['id']) )
	{
		$keys = array();
		$keys = get_auth_keys($cur, $all);
	}

	$max_level = 0;
	for($i = 0; $i < count($keys['id']); $i++)
	{
		if ( $keys['level'][$i] > $max_level )
		{
			$max_level = $keys['level'][$i];
		}
	}
	return $max_level;
}

function get_tree_option($cur = '', $all = false)
{
	global $tree, $lang;

	$keys = array();
	$keys = get_auth_keys('Root', $all);
	$res = '';
	for($i=0; $i < count($keys['id']); $i++)
	{
		// only get object that are not forum links type
		if ( ($tree['type'][ $keys['idx'][$i] ] != POST_FORUM_URL) || empty($tree['data'][ $keys['idx'][$i] ]['forum_link']) )
		{
			$selected = ($cur == $keys['id'][$i]) ? ' selected="selected"' : '';
			$res .= '<option value="' . $keys['id'][$i] . '"' . $selected . '>';

			// name
			$name = get_object_lang($keys['id'][$i], 'name');

			// increment
			$inc = '';
			for($k=1; $k <= $keys['real_level'][$i]; $k++)
			{
				$inc .= '|&nbsp;&nbsp;&nbsp;';
			}
			if ( $keys['level'][$i] >= 0 )
			{
				$inc .= '|--';
			}
			$name = $inc . $name;

			$res .= $name . '</option>';
		}
	}
	return $res;
}

function build_index($cur = 'Root', $cat_break = false, &$forum_moderators, $real_level = -1, $max_level = -1, &$keys)
{
	global $userdata, $db, $lang, $template, $phpEx, $board_config, $lang, $images;
	global $tree, $phpEx, $idx_buffer, $readhist_buffer;
	// init
	$display = false;

	// get the sub_forum switch value
	$sub_forum = intval($board_config['sub_forum']);
	if ( ($sub_forum == 2) && defined('IN_VIEWFORUM') )
	{
		$sub_forum = 1;
	}
	$pack_first_level = ($sub_forum == 2);

	// verify the cat_break parm
	if ( ($cur != 'Root') && ($real_level == -1) )
	{
		$cat_break = false;
	}

	// display the level
	$athis = isset($tree['keys'][$cur]) ? $tree['keys'][$cur] : -1;

	// display each kind of row

	// root level head
	if ( $real_level == -1 )
	{
		// get max inc level
		$max = -1;
		if ( $sub_forum == 2 )
		{
			$max = 0;
		}
		if ( $sub_forum == 1 )
		{
			$max = 1;
		}
		$keys = array();
		$keys = get_auth_keys($cur, false, -1, $max);
		$max_level = get_max_depth($cur, false, -1, $keys, $max);
	}

	// table header
	if ( ($board_config['split_cat'] && $cat_break && ($real_level == 0)) || ((!$board_config['split_cat'] || !$cat_break) && ($real_level == -1)) )
	{
		// if break, get the local max level
		if ( $board_config['split_cat'] && $cat_break && ($real_level == 0) )
		{
			$max_level = 0;
			// the array is sorted
			$start = false;
			$stop = false;
			for($i=0; ($i < count($keys['id']) && !$stop); $i++)
			{
				if ( $start && ($tree['main'][$keys['idx'][$i]] == $tree['main'][$athis]) )
				{
					$stop = true;
					$break;
				}
				if ( $keys['id'][$i] == $cur )
				{
					$start = true;
				}
				if ( $start && !$stop && ($keys['level'][$i] > $max_level) )
				{
					$max_level = $keys['level'][$i];
				}
			}
		}
		$template->assign_block_vars('catrow', array());
		$template->assign_block_vars('catrow.tablehead', array(
			'FORUM_ID' => intval($cur),
			'L_FORUM' => ($athis < 0) ? $lang['Forum'] : get_object_lang($cur, 'name'),
			'INC_SPAN' => $max_level + 2)
		);
	}

	// get the level
	$level = $keys['level'][$keys['keys'][$cur]];

	// sub-forum view management
	$pull_down = true;
	if ( $sub_forum > 0 )
	{
		$pull_down = false;
		if ( ($real_level == 0) && ($sub_forum == 1) )
		{
			$pull_down = true;
		}
	}

	if ( $level >= 0 )
	{
		// cat header row
		if ( ($tree['type'][$athis] == POST_CAT_URL) && $pull_down )
		{
			// display a cat row
			$cat = $tree['data'][$athis];
			$cat_id = $tree['id'][$athis];

			// get the class colors
			$class_catLeft = 'catLeft';
			$class_cat = 'cat';
			$class_rowpic = 'rowpic';

			// send to template
			$template->assign_block_vars('catrow', array());
			$template->assign_block_vars('catrow.cathead', array(
				'CAT_ID' => $cat_id,
				'CAT_TITLE'	=> get_object_lang($cur, 'name'),
				'CLASS_CATLEFT'	=> $class_catLeft,
				'CLASS_CAT'	=> $class_cat,
				'CLASS_ROWPIC'	=> $class_rowpic,
				'INC_SPAN'	=> $max_level - $level + 2,
				'U_VIEWCAT'	=> append_sid("index.$phpEx?" . POST_CAT_URL . "=$cat_id"))
			);


			// add indentation to the display
			for($k = 1; $k <= $level; $k++)
			{
				$template->assign_block_vars('catrow.cathead.inc', array(
					'INC_CLASS' => ($k % 2) ? 'row1' : 'row2')
				);
			}

			// something displayed
			$display = true;
		}
	}

	// forum header row
	if ( $level >= 0 )
	{
		if ( ($tree['type'][$athis] == POST_FORUM_URL) || (($tree['type'][$athis] == POST_CAT_URL) && !$pull_down) )
		{
			// get the data
			$data	= $tree['data'][$athis];
			$id = $tree['id'][$athis];
			$type = $tree['type'][$athis];
			$sub = (!empty($tree['sub'][$cur]) && $tree['auth'][$cur]['tree.auth_view']);

			// specific to the data type
			$title = get_object_lang($cur, 'name');
			$desc = get_object_lang($cur, 'desc');

			// specific to something attached
			if ( $sub )
			{
				$i_new		= $images['category_new'];
				$a_new		= $lang['New_posts'];
				$i_norm		= $images['category'];
				$a_norm		= $lang['No_new_posts'];
				$i_locked	= $images['category_locked'];
				$a_locked	= $lang['Forum_locked'];
			}
			else
			{
				$i_new		= $images['forum_new'];
				$a_new		= $lang['New_posts'];
				$i_norm		= $images['forum'];
				$a_norm		= $lang['No_new_posts'];
				$i_locked	= $images['forum_locked'];
				$a_locked	= $lang['Forum_locked'];
			}

			// forum link type
			if ( ($tree['type'][$athis] == POST_FORUM_URL) && !empty($tree['data'][$athis]['forum_link']) )
			{
				$i_new		= $images['link'];
				$a_new		= $lang['Forum_link'];
				$i_norm		= $images['link'];
				$a_norm		= $lang['Forum_link'];
				$i_locked	= $images['link'];
				$a_locked	= $lang['Forum_link'];
			}

			// front icon
			if ( !$board_config['read_tracking'] )
			{
				$folder_image = ( $data['tree.unread_topics'] ) ? $i_new : $i_norm;
				$folder_alt = ( $data['tree.unread_topics'] ) ? $i_new : $a_norm;
			}
			else
			{
				$forum_id = $tree['id'][$athis];
				$smart_new = false;
				if ( $userdata['session_logged_in'] )
				{
					if( !isset($readhist_buffer) )
					{
						fill_readhist_buffer($readhist_buffer, $userdata['user_id']);
					}

					if ( isset($readhist_buffer[$forum_id]) )
					{
						$smart_new = true;
					}
				}
				$folder_image = ( $smart_new ) ? $i_new : $i_norm;
				$folder_alt = ( $smart_new ) ? $i_new : $a_norm;
			}

			if ( $data['tree.locked'] )
			{
				$folder_image = $i_locked;
				$folder_alt	= $a_locked;
			}

			// moderators list
			$l_moderators	= '&nbsp;';
			$moderator_list = '&nbsp;';
			if ( $type == POST_FORUM_URL )
			{
				if ( count($forum_moderators[$id]) > 0 )
				{
					$l_moderators = ( count($forum_moderators[$id]) == 1 ) ? $lang['Moderator'] : $lang['Moderators'];
					$moderator_list = implode(', ', $forum_moderators[$id]);
				}
			}

			// last post
			$last_post = $lang['No_Posts'];
			if ( $data['tree.topic_last_post_id'] )
			{
				// resize
				$topic_title = $data['tree.topic_title'];
				if ( strlen($topic_title) > (intval($board_config['last_topic_title_length']) -3 ) )
				{
					$topic_title = substr($topic_title, 0, intval($board_config['last_topic_title_length'])) . '...';
				}
				$topic_title = '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=" . $data['tree.topic_last_post_id']) . '#' . $data['tree.topic_last_post_id'] . '" title="' . $data['tree.topic_title'] . '" class="gensmall">' . $topic_title . '</a>';
				$last_postmsg = (($board_config['last_topic_title']) ? $topic_title : '');
				$last_postmsg = ($board_config['last_topic_title']) ? '' . $lang['Last_Post'] . ': ' . $last_postmsg . '' : '';


				$last_post_time = create_date($board_config['default_dateformat'], $data['tree.post_time'], $board_config['board_timezone']);
				$last_post = $last_post_time . '<br />';
				$last_post .= ( $data['tree.post_user_id'] == ANONYMOUS ) ? $data['tree.post_username'] . ' ' : '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $data['tree.post_user_id']) . '">' . $data['tree.post_username'] . '</a> ';
				$last_post .= '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . '=' . $data['tree.topic_last_post_id']) . '#' . $data['tree.topic_last_post_id'] . '"><img src="' . $images['icon_latest_reply'] . '" border="0" alt="' . $lang['View_latest_post'] . '" title="' . $lang['View_latest_post'] . '" /></a>';
			}

			// links to sub-levels
			$links = '';
			if ( $sub && !$pull_down && (intval($board_config['sub_level_links']) > 0) && ((($real_level == 0) && ($sub_forum == 1)) || ($real_level == 1) || ($sub_forum == 2)) )
			{
				for($j=0; $j < count($tree['sub'][$cur]); $j++) if ( $tree['auth'][ $tree['sub'][$cur][$j] ]['auth_view'] )
				{
					$wcur	= $tree['sub'][$cur][$j];
					$wthis	= $tree['keys'][$wcur];
					$wdata	= $tree['data'][$wthis];
					$wname	= get_object_lang($wcur, 'name');
					$wdesc	= get_object_lang($wcur, 'desc');
					switch($tree['type'][$wthis])
					{
						case POST_FORUM_URL:
							$wpgm = append_sid("./viewforum.$phpEx?" . POST_FORUM_URL . '=' . $tree['id'][$wthis]);
							break;
						case POST_CAT_URL:
							$wpgm = append_sid("./index.$phpEx?" . POST_CAT_URL . '=' . $tree['id'][$wthis]);
							break;
						default:
							$wpgm = append_sid("./index.$phpEx");
							break;
					}
					$link = '';
					if ( $wname != '' )
					{
						$link = '<a href="' . $wpgm . '" title="' . $wdesc . '" class="gensmall">' . $wname . '</a>';
					}

					if ( intval($board_config['sub_level_links']) == 2 )
					{
						$wsub = (!empty($tree['sub'][$wcur]) && $tree['auth'][$wcur]['tree.auth_view']);

						// specific to something attached
//						if ( $wsub )
//						{
							$wi_new		= $images['icon_minicat_new'];
							$wa_new		= $lang['New_posts'];
							$wi_norm	= $images['icon_minicat'];
							$wa_norm	= $lang['No_new_posts'];
							$wi_locked	= $images['icon_minicat_locked'];
							$wa_locked	= $lang['Forum_locked'];
/*						}
						else
						{
							$wi_new		= $images['icon_minipost_new'];
							$wa_new		= $lang['New_posts'];
							$wi_norm	= $images['icon_minipost'];
							$wa_norm	= $lang['No_new_posts'];
							$wi_locked	= $images['icon_minipost_lock'];
							$wa_locked	= $lang['Forum_locked'];
						}
*/
						// forum link type
						if ( ($tree['type'][$wthis] == POST_FORUM_URL) && !empty($wdata['forum_link']) )
						{
							$wi_new		= $images['icon_minilink'];
							$wa_new		= $lang['Forum_link'];
							$wi_norm	= $images['icon_minilink'];
							$wa_norm	= $lang['Forum_link'];
							$wi_locked	= $images['icon_minilink'];
							$wa_locked	= $lang['Forum_link'];
						}

						// front icon
						$wfolder_image	= ( $wdata['tree.unread_topics'] ) ? $wi_new : $wi_norm;
						$wfolder_alt	= ( $wdata['tree.unread_topics'] ) ? $wa_new : $wa_norm;
						if ( $wdata['tree.locked'] )
						{
							$wfolder_image	= $wi_locked;
							$wfolder_alt	= $wa_locked;
						}
						$wlast_post = '<a href="' . append_sid("./viewtopic.$phpEx?" . POST_POST_URL . '=' . $wdata['tree.topic_last_post_id']) . '#' . $wdata['tree.topic_last_post_id'] . '">';
						$wlast_post .= '<img src="' . $wfolder_image . '" border="0" alt="' . $wfolder_alt . '" title="' . $wfolder_alt . '" align="middle" /></a>';
					}
					if ( $link != '' )
					{
						$links .= (($links != '') ? ', ' : '') . $wlast_post . $link;
					}
				}
			}


			$sql_ignore_topics = '';
			if ( $board_config['ignore_topics'] && $userdata['session_logged_in'] )
			{
				$ignore_topics = $userdata['ignore_topics'];
				$sql_ignore_topics = ( $ignore_topics ) ? 'AND topic_id NOT IN (' . $ignore_topics . ')' : '';
			}

			if ( !isset($idx_buffer) )
			{
				$idx_buffer = array();
				if ( $userdata['session_logged_in'] )
				{
					if ( $board_config['cpost'] )
					{
						$sql = "SELECT COUNT(post_id) as total, forum_id
							FROM " . POSTS_TABLE . "
							$sql_ignore_topics
							WHERE post_time >= " . $userdata['user_lastvisit'] . "
							GROUP BY forum_id";
						$result = $db->sql_query($sql);
						$idx_buffer['newposts'] = array();
						while ( $row = $db->sql_fetchrow($result) )
						{
							$idx_buffer['newposts'][$row['forum_id']] = $row['total'];
						}
					}
					if ( $board_config['ctop'] )
					{
						$sql = "SELECT COUNT(topic_id) as total, forum_id
							FROM " . TOPICS_TABLE . "
							$sql_ignore_topics
							WHERE topic_time >= " . $userdata['user_lastvisit'] . "
							GROUP BY forum_id";
						$result = $db->sql_query($sql);
						$idx_buffer['newtopics'] = array();
						while ( $row = $db->sql_fetchrow($result) )
						{
							$idx_buffer['newtopics'][$row['forum_id']] = $row['total'];
						}
					}
					if ( $board_config['read_tracking'] )
					{
						$sql = "SELECT COUNT(user_id) AS total, forum_id
							FROM ". READ_HIST_TABLE ."
							$sql_ignore_topics
							WHERE user_id = '" . $userdata['user_id'] . "'
							GROUP BY forum_id";
						$result = $db->sql_query($sql);
						$idx_buffer['read_hist'] = array();
						while ( $row = $db->sql_fetchrow($result) )
						{
							$idx_buffer['read_hist'][$row['forum_id']] = $row['total'];
						}
					}
				}
				$sql = "SELECT forum_id, forum_color FROM " . FORUMS_TABLE;
				$result = $db->sql_query($sql);
				$idx_buffer['forum_color'] = array();
				while ( $row = $db->sql_fetchrow($result) )
				{
					$idx_buffer['forum_color'][$row['forum_id']] = $row['forum_color'];
				}
			}

			if ( $userdata['session_logged_in'] && $board_config['cpost'] )
			{
				$number_new_posts = $idx_buffer['newposts'][$id];
			}
			if ( $userdata['session_logged_in'] && $board_config['ctop'] )
			{
				$number_new_topics = $idx_buffer['newtopics'][$id];
			}
			if ( $userdata['session_logged_in'] && $board_config['read_tracking'] )
			{
				if ( !$idx_buffer['read_hist'][$id] )
				{
					$number_new_topics = '';
					$number_new_posts = '';
				}
			}

			$num_new_topics = ($number_new_topics && $board_config['ctop'] && $userdata['session_logged_in']) ? '<br />' . $lang['new_topicsss'] . ' <b>' . $number_new_topics . '</b>' : '';
			$num_new_posts = ($number_new_posts && $board_config['cpost'] && $userdata['session_logged_in']) ? '<br />' . $lang['new_postsss'] . ' <b>' . $number_new_posts . '</b>' : '';

			if ( $idx_buffer['forum_color'][$id] != '' && $tree['type'][$athis] != POST_CAT_URL )
			{
				$title = '<span style="color: #' . $idx_buffer['forum_color'][$id] . '">' . $title . '</span>';
			}

			// send to template
			$template->assign_block_vars('catrow', array());
			$template->assign_block_vars('catrow.forumrow', array(
				'FORUM_ID' => $id,
				'FORUM_FOLDER_IMG' => $folder_image,
				'FORUM_NAME' => $title,
				'FORUM_DESC' => $desc,
				'POSTS' => $data['tree.forum_posts'],
				'TOPICS' => $data['tree.forum_topics'],
				'LAST_POST'	=> $last_post,
				'LAST_POSTMSG'	=> $last_postmsg,
				'MODERATORS' => $moderator_list,
				'L_MODERATOR' => $l_moderators, 
				'L_FORUM_FOLDER_ALT' => $folder_alt, 
				'U_VIEWFORUM' => ($type == POST_FORUM_URL) ? append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$id") : append_sid("index.$phpEx?" . POST_CAT_URL . "=$id"),
				'NUM_NEW_TOPICS' => $num_new_topics,
				'NUM_NEW_POSTS' => $num_new_posts,
				'INC_SPAN' => $max_level- $level+1,
				'INC_CLASS'	=> ( !($level % 2) ) ? 'row1' : 'row2')
			);

			// add indentation to the display
			for($k=1; $k <= $level; $k++)
			{
				$template->assign_block_vars('catrow.forumrow.inc', array(
					'INC_CLASS' => ($k % 2) ? 'row1' : 'row2')
				);
			}

			// add the links row
			if ( !empty($links) )
			{
				$template->assign_block_vars('catrow.forumrow.links', array(
					'L_LINKS' => (empty($moderator_list) ? '' : '<br />'),
					'LINKS'	=> $links)
				);
			}

			// forum link type
			if ( ($tree['type'][$athis] == POST_FORUM_URL) && !empty($tree['data'][$athis]['forum_link']) )
			{
				$s_hit_count = '';
				if ( $tree['data'][$athis]['forum_link_hit_count'] )
				{
					$s_hit_count = sprintf($lang['Forum_link_visited'], $tree['data'][$athis]['forum_link_hit']);
				}
				$template->assign_block_vars('catrow.forumrow.forum_link', array(
					'HIT_COUNT' => $s_hit_count)
				);
			}
			else
			{
				$template->assign_block_vars('catrow.forumrow.forum_link_no', array());
			}

			// something displayed
			$display = true;
		}
	}

	// display sub-levels
	for($i = 0; $i < count($tree['sub'][$cur]); $i++) if ( !empty($keys['keys'][$tree['sub'][$cur][$i]]) )
	{
		$wdisplay = build_index($tree['sub'][$cur][$i], $cat_break, $forum_moderators, $level+1, $max_level, $keys);
		if ( $wdisplay )
		{
			$display = true;
		}
	}

	if ( $level >=0 )
	{
		// forum footer row
		if ( $tree['type'][$athis] == POST_FORUM_URL )
		{
		}
	}

	if ( $level >= 0 )
	{
		// cat footer
		if ( ($tree['type'][$athis] == POST_CAT_URL) && $pull_down )
		{
			$template->assign_block_vars('catrow', array());
			$template->assign_block_vars('catrow.catfoot', array(
				'INC_SPAN' => $max_level - $level+5)
			);

			// add indentation to the display
			for($k = 1; $k <= $level; $k++)
			{
				$template->assign_block_vars('catrow.catfoot.inc', array(
					'INC_SPAN' => $max_level - $level+5,
					'INC_CLASS' => ($k % 2) ? 'row1' : 'row2')
				);
			}
		}
	}

	// root level footer
	if ( ($board_config['split_cat'] && $cat_break && $real_level == 0) || ((!$board_config['split_cat'] || !$cat_break) && $real_level == -1) )
	{
		$template->assign_block_vars('catrow', array());
		$template->assign_block_vars('catrow.tablefoot', array());
	}

	return $display;
}

function display_index($cur='Root')
{
	global $board_config, $template, $userdata, $lang, $db, $nav_links, $phpEx;
	global $images, $nav_separator, $nav_cat_desc;

	$template->set_filenames(array(
		'index' => 'index_box.tpl')
	);

	// Obtain list of moderators of each forum
	// First users, then groups ... broken into two queries
	$sql = "SELECT aa.forum_id, u.user_id, u.username 
		FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
		WHERE aa.auth_mod = " . TRUE . " 
			AND g.group_single_user = 1 
			AND ug.group_id = aa.group_id 
			AND g.group_id = aa.group_id 
			AND u.user_id = ug.user_id 
		GROUP BY u.user_id, u.username, aa.forum_id 
		ORDER BY aa.forum_id, u.user_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
	}

	$forum_moderators = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_moderators[$row['forum_id']][] = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '" class="gensmall">' . $row['username'] . '</a>';
	}

	$sql = "SELECT aa.forum_id, g.group_id, g.group_name 
		FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g 
		WHERE aa.auth_mod = " . TRUE . " 
			AND g.group_single_user = 0 
			AND g.group_type <> " . GROUP_HIDDEN . "
			AND ug.group_id = aa.group_id 
			AND g.group_id = aa.group_id 
		GROUP BY g.group_id, g.group_name, aa.forum_id 
		ORDER BY aa.forum_id, g.group_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
	}

	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_moderators[$row['forum_id']][] = '<a href="' . append_sid("groupcp.$phpEx?" . POST_GROUPS_URL . "=" . $row['group_id']) . '">' . $row['group_name'] . '</a>';
	}

	// let's dump all of this on the template
	$keys = array();
	$display = build_index($cur, $board_config['split_cat'], $forum_moderators, -1, -1, $keys);

	// constants
	$template->assign_vars(array(
		'L_FORUM' => $lang['Forum'],
		'L_TOPICS' => $lang['Topics'],
		'L_POSTS' => $lang['Posts'],
		'L_LASTPOST' => $lang['Last_Post'])
	);
	$template->assign_vars(array(
		'SPACER' => $images['spacer'],
		'NAV_SEPARATOR' => $nav_separator,
		'NAV_CAT_DESC' => $nav_cat_desc)
	);
	if ( $display )
	{
		$template->assign_var_from_handle('BOARD_INDEX', 'index');
	}
	return $display;
}

function make_cat_nav_tree($cur, $pgm = '', $nav_class = 'nav')
{
	global $phpbb_root_path, $phpEx, $db;
	global $global_orig_word, $global_replacement_word;
	global $nav_separator;
	global $tree;

	// get topic or post level
	$type = substr($cur, 0, 1);
	$id = intval(substr($cur,1));
	$topic_title = '';
	$fcur = '';
	switch ($type)
	{
		case POST_TOPIC_URL:
			$sql = "SELECT forum_id, topic_title 
				FROM " . TOPICS_TABLE . "
				WHERE topic_id = $id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query topics information', '', __LINE__, __FILE__, $sql);
			}
			if ( $row = $db->sql_fetchrow($result))
			{
				$fcur = POST_FORUM_URL . $row['forum_id'];
				$topic_title = $row['topic_title'];
				$orig_word = array();
				$remplacement_word = array();
				obtain_word_list($orig_word, $replacement_word);
				if ( count($orig_word) )
				{
					$topic_title = preg_replace($orig_word, $replacement_word, $topic_title);
				}
			}
			break;
		case POST_POST_URL:
			$sql = "SELECT t.forum_id, t.topic_title 
				FROM " . POSTS_TABLE . " p, " . TOPICS_TABLE . " t 
				WHERE t.topic_id = p.topic_id
					AND post_id = $id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query posts information', '', __LINE__, __FILE__, $sql);
			}
			if ( $row = $db->sql_fetchrow($result) )
			{
				$fcur = POST_FORUM_URL . $row['forum_id'];
				$topic_title = $row['topic_title'];
				$orig_word = array();
				$remplacement_word = array();
				obtain_word_list($orig_word, $replacement_word);
				if ( count($orig_word) )
				{
					$topic_title = preg_replace($orig_word, $replacement_word, $topic_title);
				}
			}
			break;
	}

	// keep the compliancy with prec versions
	if ( !isset($tree['keys'][$cur]) )
	{
		$cur = isset($tree['keys'][POST_CAT_URL . $cur]) ? POST_CAT_URL . $cur : $cur;
	}

	// find the object
	$athis = isset($tree['keys'][$cur]) ? $tree['keys'][$cur] : -1;

	$res = '';
	while (($athis >= 0) || ($fcur != ''))
	{
		$type = (substr($fcur, 0, 1) != '') ? substr($cur, 0, 1) : $tree['type'][$athis];
		switch($type)
		{
			case POST_CAT_URL:
				$field_name		= get_object_lang($cur, 'name');
				$param_type		= POST_CAT_URL;
				$param_value	= $tree['id'][$athis];
				$pgm_name		= "index.$phpEx";
				break;
			case POST_FORUM_URL:
				$field_name		= get_object_lang($cur, 'name');
				$param_type		= POST_FORUM_URL;
				$param_value	= $tree['id'][$athis];
				$pgm_name		= "viewforum.$phpEx";
				break;
			case POST_TOPIC_URL:
				$field_name		= $topic_title;
				$param_type		= POST_TOPIC_URL;
				$param_value	= $id;
				$pgm_name		= "viewtopic.$phpEx";
				break;
			case POST_POST_URL:
				$field_name		= $topic_title;
				$param_type		= POST_POST_URL;
				$param_value	= $id . '#' . $id;
				$pgm_name		= "viewtopic.$phpEx";
				break;
			default :
				$field_name		= '';
				$param_type		= '';
				$param_value	= '';
				$pgm_name		= "index.$phpEx";
				break;
		}
		if ( $pgm != '' )
		{
			$pgm_name = $pgm.$phpEx;
		}

		if ( !empty($field_name) )
		{
			$res = '<a href="' . append_sid('./' . $pgm_name . (($field_name != '') ? "?$param_type=$param_value" : '')) . '" class="' . $nav_class . '">' . $field_name . '</a>' . (($res != '') ? $nav_separator . $res : '');
		}

		// find parent object
		if ( $fcur != '' )
		{
			$cur = $fcur;
			$pgm = '';
			$fcur = '';
			$topic_title = '';
		}
		else
		{
			$cur = $tree['main'][$athis];
		}
		$athis = isset($tree['keys'][$cur]) ? $tree['keys'][$cur] : -1;
	}

	return $res;
}

function jumpbox($action, $match_forum_id = 0)
{
	global $template, $userdata, $lang, $db, $nav_links, $phpEx, $SID;
	global $links;

	// build the jumpbox
	$boxstring = '<select name="selected_id" onchange="if(this.options[this.selectedIndex].value != -1){ forms[\'jumpbox\'].submit() }">';
	$boxstring .= '<option value="-1">' . $lang['Select_forum'] . '</option><option value="-1"></option>' . get_tree_option(POST_FORUM_URL . $match_forum_id);
	$boxstring .= '</select>';

	// add SID if missing
	// Let the jumpbox work again in sites having additional session id checks.
	// if ( !empty($SID) )
	// { 
			$boxstring .= '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" />';
	// }

	// dump this to template
	$template->set_filenames(array(
		'jumpbox' => 'jumpbox.tpl')
	);
	$template->assign_vars(array(
		'L_GO' => $lang['Go'],
		'L_JUMP_TO' => $lang['Jump_to'],
		'L_SELECT_FORUM' => $lang['Select_forum'],

		'S_JUMPBOX_SELECT' => $boxstring,
		'S_JUMPBOX_ACTION' => append_sid($action))
	);
	$template->assign_var_from_handle('JUMPBOX', 'jumpbox');

	return;
}

function selectbox($box_name, $ignore_forum = false, $select_forum = '')
{
	$s_id = ($select_forum != '') ? POST_FORUM_URL . $select_forum : '';
	$s_list = get_tree_option($select_forum);
	$res = '<select name="' . $box_name . '">' . $s_list . '</select>';
	return $res;
}

function get_db_stat($mode)
{
	global $db;

	switch( $mode )
	{
		case 'usercount':
			$sql = "SELECT COUNT(user_id) AS total
				FROM " . USERS_TABLE . "
				WHERE user_id <> " . ANONYMOUS;
			break;

		case 'newestuser':
			$sql = "SELECT user_id, username
				FROM " . USERS_TABLE . "
				WHERE user_id <> " . ANONYMOUS . "
				ORDER BY user_id DESC
				LIMIT 1";
			break;

		case 'postcount':
		case 'topiccount':
			$sql = "SELECT SUM(forum_topics) AS topic_total, SUM(forum_posts) AS post_total
				FROM " . FORUMS_TABLE;
			break;
	}

	if ( !($result = $db->sql_query($sql)) )
	{
		return false;
	}

	$row = $db->sql_fetchrow($result);

	switch ( $mode )
	{
		case 'usercount':
			return $row['total'];
			break;
		case 'newestuser':
			return $row;
			break;
		case 'postcount':
			return $row['post_total'];
			break;
		case 'topiccount':
			return $row['topic_total'];
			break;
	}

	return false;
}

function get_userdata($user)
{
	global $db;

	$sql = "SELECT *
		FROM " . USERS_TABLE . " 
		WHERE ";
	$sql .= ( ( is_integer($user) ) ? "user_id = $user" : "username = '" .	str_replace("\'", "''", $user) . "'" ) . " AND user_id <> " . ANONYMOUS;
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Tried obtaining data for a non-existent user', '', __LINE__, __FILE__, $sql);
	}

	return ( $row = $db->sql_fetchrow($result) ) ? $row : false;
}

function make_jumpbox($action, $match_forum_id = 0)
{
	global $template, $userdata, $lang, $db, $nav_links, $phpEx, $SID;

	return jumpbox($action, $match_forum_id);

	$sql = "SELECT c.cat_id, c.cat_title, c.cat_order
		FROM " . CATEGORIES_TABLE . " c, " . FORUMS_TABLE . " f
		WHERE f.cat_id = c.cat_id
		" . (($userdata['user_level'] == ADMIN) ? "" : "AND c.cat_title <> 'global_announcement'" ) . "
		GROUP BY c.cat_id, c.cat_title, c.cat_order
		ORDER BY c.cat_order";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldn\'t obtain category list.', '', __LINE__, __FILE__, $sql);
	}
	
	$category_rows = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$category_rows[] = $row;
	}

	if ( $total_categories = count($category_rows) )
	{
		$sql = "SELECT *
			FROM " . FORUMS_TABLE . "
			ORDER BY cat_id, forum_order";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
		}

		$boxstring = '<select name="' . POST_FORUM_URL . '" onChange="if(this.options[this.selectedIndex].value != -1){ forms[\'jumpbox\'].submit() }"><option value="-1">' . $lang['Select_forum'] . '</option>';

		$forum_rows = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$forum_rows[] = $row;
		}

		if ( $total_forums = count($forum_rows) )
		{
			for($i = 0; $i < $total_categories; $i++)
			{
				$boxstring_forums = '';
				for($j = 0; $j < $total_forums; $j++)
				{
					if ( $forum_rows[$j]['cat_id'] == $category_rows[$i]['cat_id'] && $forum_rows[$j]['auth_view'] <= AUTH_REG )
					{

						$selected = ( $forum_rows[$j]['forum_id'] == $match_forum_id ) ? 'selected="selected"' : '';
						$boxstring_forums .= '<option value="' . $forum_rows[$j]['forum_id'] . '"' . $selected . '>' . $forum_rows[$j]['forum_name'] . '</option>';

						$nav_links['chapter forum'][$forum_rows[$j]['forum_id']] = array (
							'url' => append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=" . $forum_rows[$j]['forum_id']),
							'title' => $forum_rows[$j]['forum_name']
						);
					}
				}

				if ( $boxstring_forums != '' )
				{
					$boxstring .= '<option value="-1">&nbsp;</option>';
					$boxstring .= '<option value="-1">' . $category_rows[$i]['cat_title'] . '</option>';
					$boxstring .= '<option value="-1">----------------</option>';
					$boxstring .= $boxstring_forums;
				}
			}
		}

		$boxstring .= '</select>';
	}
	else
	{
		$boxstring .= '<select name="' . POST_FORUM_URL . '" onChange="if(this.options[this.selectedIndex].value != -1){ forms[\'jumpbox\'].submit() }"></select>';
	}

	// add SID if missing
	// Let the jumpbox work again in sites having additional session id checks.
	//if ( !empty($SID) )
	//{ 
			$boxstring .= '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" />';
	//}

	$template->set_filenames(array(
		'jumpbox' => 'jumpbox.tpl')
	);

	$template->assign_vars(array(
		'L_GO' => $lang['Go'],
		'L_JUMP_TO' => $lang['Jump_to'],
		'L_SELECT_FORUM' => $lang['Select_forum'],

		'S_JUMPBOX_SELECT' => $boxstring,
		'S_JUMPBOX_ACTION' => append_sid($action))
	);
	$template->assign_var_from_handle('JUMPBOX', 'jumpbox');

	return;
}

//
// Initialise user settings on page load
function init_userprefs($userdata)
{
	global $board_config, $theme, $images;
	global $template, $lang, $phpEx, $phpbb_root_path;
	global $nav_links;

	if ( $userdata['user_id'] != ANONYMOUS )
	{
		if ( !empty($userdata['user_lang']) )
		{
			$board_config['default_lang'] = $userdata['user_lang'];
		}

		if ( !empty($userdata['user_dateformat']) )
		{
			$board_config['default_dateformat'] = $userdata['user_dateformat'];
		}

		if ( isset($userdata['user_timezone']) )
		{
			$board_config['board_timezone'] = $userdata['user_timezone'];
		}
	}

	if ( !file_exists(@phpbb_realpath($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_main.'.$phpEx)) )
	{
		$board_config['default_lang'] = 'english';
	}

	include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_main.' . $phpEx);

	if ( defined('IN_ADMIN') )
	{
		if ( !file_exists(@phpbb_realpath($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_admin.'.$phpEx)) )
		{
			$board_config['default_lang'] = 'english';
		}

		include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_admin.' . $phpEx);
	}
	$language = $board_config['default_lang'];

	if ( defined('ATTACHMENTS_ON') )
	{
		if (file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_main_attach.'.$phpEx))
		{
			include($phpbb_root_path . 'language/lang_' . $language . '/lang_main_attach.' . $phpEx);
		}

		if (defined('IN_ADMIN'))
		{
			if (file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_admin_attach.'.$phpEx))
			{
				include($phpbb_root_path . 'language/lang_' . $language . '/lang_admin_attach.' . $phpEx);
			}
		}
	}

	global $tree;
	if ( empty($tree['auth']) )
	{
		get_user_tree($userdata);
	}

	if ( !$board_config['override_user_style'] )
	{
		if ( $userdata['user_id'] != ANONYMOUS && $userdata['user_style'] > 0 )
		{
			if ( $theme = setup_style($userdata['user_style']) )
			{
				return;
			}
		}
	}

	$theme = setup_style($board_config['default_style']);

	//
	// Mozilla navigation bar
	// Default items that should be valid on all pages.
	// Defined here to correctly assign the Language Variables
	// and be able to change the variables within code.
	//
	$nav_links['top'] = array ( 
		'url' => append_sid($phpbb_root_path . 'index.' . $phpEx),
		'title' => sprintf($lang['Forum_Index'], $board_config['sitename'])
	);
	$nav_links['search'] = array ( 
		'url' => append_sid($phpbb_root_path . 'search.' . $phpEx),
		'title' => $lang['Search']
	);
	$nav_links['help'] = array ( 
		'url' => append_sid($phpbb_root_path . 'faq.' . $phpEx),
		'title' => $lang['FAQ']
	);
	$nav_links['author'] = array ( 
		'url' => append_sid($phpbb_root_path . 'memberlist.' . $phpEx),
		'title' => $lang['Memberlist']
	);

	return;
}

function setup_style($style)
{
	global $db, $board_config, $template, $images, $phpbb_root_path;

	$sql = "SELECT *
		FROM " . THEMES_TABLE . "
		WHERE themes_id = $style";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, 'Could not query database for theme info');
	}

	if ( !($row = $db->sql_fetchrow($result)) )
	{
		message_die(CRITICAL_ERROR, 'Could not get theme data for themes_id [' . $style . ']');
	}

	$template_path = 'templates/';
	$template_name = $row['template_name'] ;

	$template = new Template($phpbb_root_path . $template_path . $template_name);

	if ( $template )
	{
		$current_template_path = $template_path . $template_name;
		@include($phpbb_root_path . $template_path . $template_name . '/' . $template_name . '.cfg');

		if ( !defined('TEMPLATE_CONFIG') )
		{
			message_die(CRITICAL_ERROR, 'Could not open ' . $template_name . ' template config file', '', __LINE__, __FILE__);
		}

		$img_lang = ( file_exists(@phpbb_realpath($phpbb_root_path . $current_template_path . '/images/lang_' . $board_config['default_lang'])) ) ? $board_config['default_lang'] : 'english';

		while( list($key, $value) = @each($images) )
		{
			if ( !is_array($value) )
			{
				$images[$key] = str_replace('{LANG}', 'lang_' . $img_lang, $value);
			}
		}
	}

	return $row;
}

function encode_ip($dotquad_ip)
{
	$ip_sep = explode('.', $dotquad_ip);
	return sprintf('%02x%02x%02x%02x', $ip_sep[0], $ip_sep[1], $ip_sep[2], $ip_sep[3]);
}

function decode_ip($int_ip)
{
	$hexipbang = explode('.', chunk_split($int_ip, 2, '.'));
	return hexdec($hexipbang[0]). '.' . hexdec($hexipbang[1]) . '.' . hexdec($hexipbang[2]) . '.' . hexdec($hexipbang[3]);
}


//
// Create date/time from format and timezone
//
function create_date($format, $gmepoch, $tz)
{
	global $board_config, $lang;
	static $translate;

	if ( empty($translate) && $board_config['default_lang'] != 'english' )
	{
		@reset($lang['datetime']);
		while ( list($match, $replace) = @each($lang['datetime']) )
		{
			$translate[$match] = $replace;
		}
	}

	if ( $board_config['auto_date'] )
	{
		return ( !empty($translate) ) ? strtr(@gmdate($format, $gmepoch + (3600 * ($tz + (date('I',$gmepoch) && date('I'))))), $translate) : @gmdate($format, $gmepoch + (3600 * ($tz + (date('I',$gmepoch) && date('I')))));
	}
	else
	{
		return ( !empty($translate) ) ? strtr(@gmdate($format, $gmepoch + (3600 * $tz)), $translate) : @gmdate($format, $gmepoch + (3600 * $tz));
	}

}


// 
// Full Pagination routine, generates
// page number sequence 
// 
function generate_full_pagination($base_url, $num_items, $per_page, $start_item, $add_prevnext_text = TRUE) 
{ 
	global $lang;

	//
	// You can change this value, see the Author Notes for details
	//
	$break_page = 20;

	$total_pages = ceil($num_items / $per_page);

	if ( $total_pages <= 1 ) 
	{ 
		return '';
	} 

	$on_page = floor($start_item / $per_page) + 1;
	$page_string = '';

	for($i = 1; $i < $total_pages + 1; $i++) 
	{ 
		if ( $break_page > 0 )
		{ 
			if ( (($i-1) % $break_page) == 0 )
			{ 
				$page_string .= '<br />';
			} 
		}
		$page_string .= ( $i == $on_page ) ? '<b>' . $i . '</b>' : '<a href="' . append_sid($base_url . "&amp;start=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
		if ( $i < $total_pages )
		{
			$page_string .= ', ';
		}
	}

	if ( $add_prevnext_text )
	{
		if ( $on_page > 1 )
		{
			$page_string = ' <a href="' . append_sid($base_url . "&amp;start=" . ( ( $on_page - 2 ) * $per_page ) ) . '">' . $lang['Previous'] . '</a>&nbsp;&nbsp;' . $page_string;
		}

		if ( $on_page < $total_pages )
		{
			$page_string .= '&nbsp;&nbsp;<a href="' . append_sid($base_url . "&amp;start=" . ( $on_page * $per_page ) ) . '">' . $lang['Next'] . '</a>';
		}
	}

	$page_string = $lang['Goto_page'] . ' ' . $page_string;

	return $page_string;
}

//
// Pagination routine, generates
// page number sequence
//
function generate_pagination($base_url, $num_items, $per_page, $start_item, $add_prevnext_text = TRUE)
{
	global $lang;

	$total_pages = ceil($num_items / $per_page);

	if ( $total_pages <= 1 )
	{
		return '';
	}

	$on_page = floor($start_item / $per_page) + 1;

	$page_string = '';
	if ( $total_pages > 10 )
	{
		$init_page_max = ( $total_pages > 3 ) ? 3 : $total_pages;

		for($i = 1; $i < $init_page_max + 1; $i++)
		{
			$page_string .= ( $i == $on_page ) ? '<b>' . $i . '</b>' : '<a href="' . append_sid($base_url . "&amp;start=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
			if ( $i < $init_page_max )
			{
				$page_string .= ", ";
			}
		}

		if ( $total_pages > 3 )
		{
			if ( $on_page > 1 && $on_page < $total_pages )
			{
				$page_string .= ( $on_page > 5 ) ? ' ... ' : ', ';

				$init_page_min = ( $on_page > 4 ) ? $on_page : 5;
				$init_page_max = ( $on_page < $total_pages - 4 ) ? $on_page : $total_pages - 4;

				for($i = $init_page_min - 1; $i < $init_page_max + 2; $i++)
				{
					$page_string .= ($i == $on_page) ? '<b>' . $i . '</b>' : '<a href="' . append_sid($base_url . "&amp;start=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
					if ( $i < $init_page_max + 1 )
					{
						$page_string .= ', ';
					}
				}

				$page_string .= ( $on_page < $total_pages - 4 ) ? ' ... ' : ', ';
			}
			else
			{
				$page_string .= ' ... ';
			}

			for($i = $total_pages - 2; $i < $total_pages + 1; $i++)
			{
				$page_string .= ( $i == $on_page ) ? '<b>' . $i . '</b>' : '<a href="' . append_sid($base_url . "&amp;start=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
				if ( $i < $total_pages )
				{
					$page_string .= ", ";
				}
			}
		}
	}
	else
	{
		for($i = 1; $i < $total_pages + 1; $i++)
		{
			$page_string .= ( $i == $on_page ) ? '<b>' . $i . '</b>' : '<a href="' . append_sid($base_url . "&amp;start=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
			if ( $i < $total_pages )
			{
				$page_string .= ', ';
			}
		}
	}

	if ( $add_prevnext_text )
	{
		if ( $on_page > 1 )
		{
			$page_string = ' <a href="' . append_sid($base_url . "&amp;start=" . ( ( $on_page - 2 ) * $per_page ) ) . '">' . $lang['Previous'] . '</a>&nbsp;&nbsp;' . $page_string;
		}

		if ( $on_page < $total_pages )
		{
			$page_string .= '&nbsp;&nbsp;<a href="' . append_sid($base_url . "&amp;start=" . ( $on_page * $per_page ) ) . '">' . $lang['Next'] . '</a>';
		}

	}

	$page_string = $lang['Goto_page'] . ' ' . $page_string . '<br />';

	return $page_string;
}


//
// This does exactly what preg_quote() does in PHP 4-ish
// If you just need the 1-parameter preg_quote call, then don't bother using this.
//
function phpbb_preg_quote($str, $delimiter)
{
	$text = preg_quote($str);
	$text = str_replace($delimiter, '\\' . $delimiter, $text);
	
	return $text;
}


//
// Obtain list of naughty words and build preg style replacement arrays for use by the
// calling script, note that the vars are passed as references this just makes it easier
// to return both sets of arrays
//
function obtain_word_list(&$orig_word, &$replacement_word)
{
	global $db;
	global $global_orig_word, $global_replacement_word;

	if ( isset($global_orig_word) )
	{
		$orig_word	= $global_orig_word;
		$replacement_word = $global_replacement_word;
	}
	else
	{
		// Define censored word matches
		$sql = "SELECT word, replacement
			FROM " . WORDS_TABLE;
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get censored words from database', '', __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			do 
			{
				$orig_word[] = '#\b(' . str_replace('\*', '\w*?', phpbb_preg_quote($row['word'], '#')) . ')\b#i';
				$replacement_word[] = $row['replacement'];
			}
			while ( $row = $db->sql_fetchrow($result) );
		}
		$global_orig_word = $orig_word;
		$global_replacement_word = $replacement_word;
	}
	return true;
}


// Filter supplied string on supplied bad words, except for users with moderator
// privilege, who get to see the original bad words highlighted instead
function replace_bad_words(&$orig_word, &$replacement_word, &$string)
{
	global $is_auth;

	// don't bother if no bad words defined
	if ( !count($orig_word) )
	{
		return;
	}

	if ( $is_auth['auth_mod'] )
	{
		$string = preg_replace($orig_word, '<span class="badwordhighlight">' . "\\1" . '</span>', $string);
	}
	else
	{
		$string = preg_replace($orig_word, $replacement_word, $string);
	}
}


//
// This is general replacement for die(), allows templated
// output in users (or default) language, etc.
//
// $msg_code can be one of these constants:
//
// GENERAL_MESSAGE : Use for any simple text message, eg. results 
// of an operation, authorisation failures, etc.
//
// GENERAL ERROR : Use for any error which occurs _AFTER_ the 
// common.php include and session code, ie. most errors in 
// pages/functions
//
// CRITICAL_MESSAGE : Used when basic config data is available but 
// a session may not exist, eg. banned users
//
// CRITICAL_ERROR : Used when config data cannot be obtained, eg
// no database connection. Should _not_ be used in 99.5% of cases
//
function message_die($msg_code, $msg_text = '', $msg_title = '', $err_line = '', $err_file = '', $sql = '')
{
	global $db, $template, $board_config, $theme, $lang, $phpEx, $phpbb_root_path, $nav_links, $gen_simple_header, $images;
	global $userdata, $user_ip, $session_length;
	global $starttime;
	global $tree;
	if ( !$board_config['report_disable'] )
	{
		global $rp;
	}

	static $msg_history;
	if( !isset($msg_history) )
	{
		$msg_history = array();
	}
	$msg_history[] = array(
		'msg_code'	=> $msg_code,
		'msg_text'	=> $msg_text,
		'msg_title'	=> $msg_title,
		'err_line'	=> $err_line,
		'err_file'	=> $err_file,
		'sql'		=> $sql
	);

	if ( defined('HAS_DIED') )
	{
		//
		// This message is printed at the end of the report.
		// Of course, you can change it to suit your own needs. ;-)
		//
		$custom_error_message = 'Please, contact the Administrator. Thank you.';
		if ( !empty($board_config) && !empty($board_config['board_email']) )
		{
			$custom_error_message = sprintf($custom_error_message, '<a href="mailto:' . $board_config['board_email'] . '">', '</a>');
		}
		else
		{
			$custom_error_message = sprintf($custom_error_message, '', '');
		}
		echo "<html>\n<body>\n<b>Critical Error!</b><br />\nmessage_die() was called multiple times.<br />&nbsp;<hr />";
		if ( DEBUG )
		{
			for( $i = 0; $i < count($msg_history); $i++ )
			{
				echo '<b>Error #' . ($i+1) . "</b>\n<br />\n";
				if( !empty($msg_history[$i]['msg_title']) )
				{
					echo '<b>' . $msg_history[$i]['msg_title'] . "</b>\n<br />\n";
				}
				echo $msg_history[$i]['msg_text'] . "\n<br /><br />\n";
				if( !empty($msg_history[$i]['err_line']) )
				{
					echo '<b>Line :</b> ' . $msg_history[$i]['err_line'] . '<br /><b>File :</b> ' . $msg_history[$i]['err_file'] . "</b>\n<br />\n";
				}
				if( !empty($msg_history[$i]['sql']) )
				{
					echo '<b>SQL :</b> ' . $msg_history[$i]['sql'] . "\n<br />\n";
				}

				$sql_error = $db->sql_error();

				if( !empty($sql_error['message']) )
				{
					echo '<b>SQL message:</b> ' . $sql_error['message'] . "\n<br />\n";
				}
				echo "&nbsp;<hr />\n";
			}
		}
		echo $custom_error_message . '<hr /><br clear="all">';
		die("</body>\n</html>");
	}
	
	define('HAS_DIED', 1);

	$sql_store = $sql;
	
	//
	// Get SQL error if we are debugging. Do this as soon as possible to prevent 
	// subsequent queries from overwriting the status of sql_error()
	//
	if ( DEBUG && ( $msg_code == GENERAL_ERROR || $msg_code == CRITICAL_ERROR ) )
	{
		$sql_error = $db->sql_error();

		$debug_text = '';

		if ( $sql_error['message'] != '' )
		{
			$debug_text .= '<br /><br />SQL Error : ' . $sql_error['code'] . ' ' . $sql_error['message'];
		}

		if ( $sql_store != '' )
		{
			$debug_text .= "<br /><br />$sql_store";
		}

		if ( $err_line != '' && $err_file != '' )
		{
			$debug_text .= '<br /><br />Line : ' . $err_line . '<br />File : ' . basename($err_file) . '<span class="gensmall">' . $lang['support'] . '</span>';
		}
	}

	if ( empty($userdata) && ( $msg_code == GENERAL_MESSAGE || $msg_code == GENERAL_ERROR ) )
	{
		$userdata = session_pagestart($user_ip, PAGE_INDEX);
		init_userprefs($userdata);
	}

	//
	// If the header hasn't been output then do it
	//
	if ( !defined('HEADER_INC') && $msg_code != CRITICAL_ERROR )
	{
		if ( empty($lang) )
		{
			if ( !empty($board_config['default_lang']) )
			{
				include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_main.'.$phpEx);
			}
			else
			{
				include($phpbb_root_path . 'language/lang_english/lang_main.'.$phpEx);
			}
		}

		if ( empty($template) )
		{
			$template = new Template($phpbb_root_path . 'templates/' . $board_config['board_template']);
		}
		if ( empty($theme) )
		{
			$theme = setup_style($board_config['default_style']);
		}

		// Load the Page Header
		if ( !defined('IN_ADMIN') )
		{
			include($phpbb_root_path . 'includes/page_header.'.$phpEx);
		}
		else
		{
			include($phpbb_root_path . 'admin/page_header_admin.'.$phpEx);
		}
	}

	switch($msg_code)
	{
		case GENERAL_MESSAGE:
			if ( $msg_title == '' )
			{
				$msg_title = $lang['Information'];
			}
			break;

		case CRITICAL_MESSAGE:
			if ( $msg_title == '' )
			{
				$msg_title = $lang['Critical_Information'];
			}
			break;

		case GENERAL_ERROR:
			if ( $msg_text == '' )
			{
				$msg_text = $lang['An_error_occured'];
			}

			if ( $msg_title == '' )
			{
				$msg_title = $lang['General_Error'];
			}
			break;

		case CRITICAL_ERROR:
			// Critical errors mean we cannot rely on _ANY_ DB information being
			// available so we're going to dump out a simple echo'd statement
			include($phpbb_root_path . 'language/lang_english/lang_main.'.$phpEx);

			if ( $msg_text == '' )
			{
				$msg_text = $lang['A_critical_error'];
			}

			if ( $msg_title == '' )
			{
				$msg_title = 'phpBB by Przemo : <b>' . $lang['Critical_Error'] . '</b>';
			}
			break;
	}

	// Add on DEBUG info if we've enabled debug mode and this is an error. This
	// prevents debug info being output for general messages should DEBUG be
	// set TRUE by accident (preventing confusion for the end user!)
	if ( DEBUG && ( $msg_code == GENERAL_ERROR || $msg_code == CRITICAL_ERROR ) )
	{
		if ( $debug_text != '' )
		{
			$msg_text = $msg_text . '<br /><br /><b><u>DEBUG MODE</u></b>' . $debug_text;
		}
	}

	if ( $msg_code != CRITICAL_ERROR )
	{
		if ( !empty($lang[$msg_text]) )
		{
			$msg_text = $lang[$msg_text];
		}

		if ( !defined('IN_ADMIN') )
		{
			$template->set_filenames(array(
				'message_body' => 'message_body.tpl')
			);
		}
		else
		{
			$template->set_filenames(array(
				'message_body' => 'admin/admin_message_body.tpl')
			);
		}

		// Try to repair table if potential damage
		if ( $sql_error['code'] == '1016' || $sql_error['code'] == '1034' )
		{
			if ( $board_config['autorepair_tables'] )
			{
				$pos1 = strpos($sql_error['message'], ": '");
				$pos2 = strpos($sql_error['message'], "'.");
				$table_damage = substr($sql_error['message'], ($pos1 + 3), ($pos2 - ($pos1 + 3)));
				$table_damage = str_replace('.MYI', '', $table_damage);
				$table_damage = str_replace('.MYD', '', $table_damage);

				$sql = "REPAIR TABLE " . $table_damage . "";
				if ( !($result = $db->sql_query($sql)) )
				{
					$rt_result = $db->sql_error();
					$wynik = sprintf($lang['rrtf'], $table_damage, $sql, $rt_result, $table_damage);
				}
				else
				{
					$wynik = sprintf($lang['rrts'], $table_damage, $sql, $table_damage);
				}

				$sql3 = "SELECT config_value
					FROM " . CONFIG_TABLE . "
					WHERE config_name = 'last_dtable_notify'";
				$result3 = $db->sql_query($sql3);
				$row3 = $db->sql_fetchrow($result3);

				if ( $row3['config_value'] < (time()-3600) )
				{
					@mail($board_config['board_email'], $lang['mstr'], $wynik);

					$sql2 = "UPDATE " . CONFIG_TABLE . "
						SET config_value = '" . time() . "'
						WHERE config_name = 'last_dtable_notify'";
					$result2 = $db->sql_query($sql2);
				}
				$msg_text = $lang['rrsum'] . '<br /><br /><span style="font size: 10px">' . $msg_text . '</span>';
			}
		}

		$template->assign_vars(array(
			'MESSAGE_TITLE' => $msg_title,
			'MESSAGE_TEXT' => $msg_text)
		);
		$template->pparse('message_body');

		if ( !defined('IN_ADMIN') )
		{
			include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
		}
		else
		{
			include($phpbb_root_path . 'admin/page_footer_admin.'.$phpEx);
		}
	}
	else
	{
		echo "<html>\n<body>\n" . $msg_title . "\n<br /><br />\n" . $msg_text . "</body>\n</html>";
	}
	exit;
}


//
// This function is for compatibility with PHP 4.x's realpath()
// function. In later versions of PHP, it needs to be called
// to do checks with some functions. Older versions of PHP don't
// seem to need this, so we'll just return the original value.
// dougk_ff7 <October 5, 2002>
function phpbb_realpath($path)
{
	global $phpbb_root_path, $phpEx;
	return (!@function_exists('realpath') || !@realpath($phpbb_root_path . 'includes/functions.'.$phpEx)) ? $path : @realpath($path);
}

function redirect($url)
{
	global $db, $board_config;

	if ( !empty($db) )
	{
		$db->sql_close();
	}

	if (strstr(urldecode($url), "\n") || strstr(urldecode($url), "\r"))
	{ 
		message_die(GENERAL_ERROR, 'Tried to redirect to potentially insecure url.');
	}

	$server_protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
	$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
	$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
	$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
	$script_name = ($script_name == '') ? $script_name : '/' . $script_name;
	$url = preg_replace('#^\/?(.*?)\/?$#', '/\1', trim($url));

	// Redirect via an HTML form for PITA webservers
	if ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) )
	{
		header('Refresh: 0; URL=' . $server_protocol . $server_name . $server_port . $script_name . $url);
		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="0; url=' . $server_protocol . $server_name . $server_port . $script_name . $url . '"><title>Redirect</title></head><body><div align="center">If your browser does not support meta redirection please click <a href="' . $server_protocol . $server_name . $server_port . $script_name . $url . '">HERE</a> to be redirected</div></body></html>';
		exit;
	}

	// Behave as per HTTP/1.1 spec for others
	$url = str_replace('&amp;', '&', $url);
	header('Location: ' . $server_protocol . $server_name . $server_port . $script_name . $url);
	exit;
}

// Password-protected forums
function password_check ($forum_id, $password, $redirect)
{
	global $db, $userdata, $lang, $board_config;
	global $HTTP_COOKIE_VARS;

	if ( !$forum_id )
	{
		message_die(GENERAL_MESSAGE, $lang['Forum_not_exist']);
	}

	$sql = "SELECT password FROM " . FORUMS_TABLE . "
		WHERE forum_id = $forum_id";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not retrieve forum password', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	if ( $password != $row['password'] )
	{
		message_die(GENERAL_MESSAGE, $lang['Incorrect_forum_password']);
	}

	$cookie_name = $board_config['cookie_name'] . '_fpass_' . $forum_id;
	setcookie($cookie_name, md5($password), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
	redirect($redirect);

	return true;
}


function password_box ($forum_id, $s_form_action)
{
	global $db, $template, $theme, $board_config, $lang, $phpEx, $phpbb_root_path, $gen_simple_header;
	global $userdata;

	$page_title = $lang['Enter_forum_password'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	$template->set_filenames(array(
		'body' => 'password_body.tpl')
	);

	$template->assign_vars(array(
		'L_ENTER_PASSWORD' => $lang['Enter_forum_password'],
		'L_SUBMIT' => $lang['Submit'],
		'L_CANCEL' => $lang['Cancel'],

		'S_FORM_ACTION' => $s_form_action)
	);

	$template->pparse('body');
	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}


// Add function mkrealdate for Birthday MOD
// the originate php "mktime()", does not work proberly on all OS, especially when going back in time
// before year 1970 (year 0), this function "mkrealtime()", has a mutch larger valid date range,
// from 1901 - 2099. it returns a "like" UNIX timestamp divided by 86400, so
// calculation from the originate php date and mktime is easy.
// mkrealdate, returns the number of day (with sign) from 1.1.1970.
function mkrealdate($day,$month,$birth_year)
{
	// range check months
	if ( $month < 1 || $month > 12)
	{
		return 'error';
	}
	// range check days
	switch ($month)
	{
		case 1: if ( $day > 31) return 'error';
		break;
		case 2: if ( $day > 29)
			return 'error';
			$epoch = $epoch + 31;
			break;
		case 3: if ( $day > 31)
			return 'error';
			$epoch = $epoch + 59;
			break;
		case 4: if ( $day > 30)
			return 'error' ;
			$epoch = $epoch + 90;
			break;
		case 5: if ( $day > 31)
			return 'error';
			$epoch = $epoch + 120;
			break;
		case 6: if ( $day > 30)
			return 'error';
			$epoch = $epoch + 151;
			break;
		case 7: if ( $day > 31)
			return 'error';
			$epoch = $epoch + 181;
			break;
		case 8: if ( $day > 31)
			return 'error';
			$epoch = $epoch + 212;
			break;
		case 9: if ( $day > 30)
			return 'error';
			$epoch = $epoch + 243;
			break;
		case 10: if ( $day > 31)
			return 'error';
			$epoch = $epoch + 273;
			break;
		case 11: if ( $day > 30)
			return 'error';
			$epoch = $epoch + 304;
			break;
		case 12: if ( $day > 31)
			return 'error';
			$epoch = $epoch + 334;
			break;
	}
	$epoch = $epoch + $day;
	$epoch_Y = sqrt(($birth_year - 1970) * ($birth_year - 1970));
	$leapyear = round((($epoch_Y + 2) / 4)-.5);
	if (($epoch_Y + 2) % 4 == 0 )
	{
		// curent year is leapyear
		$leapyear--;
		if ( $birth_year > 1970 && $month >= 3)
		{
			$epoch = $epoch + 1;
		}
		if ( $birth_year < 1970 && $month < 3)
		{
			$epoch = $epoch - 1;
		}
	}
	else if ( $month == 2 && $day > 28)
	{
		return 'error'; //only 28 days in feb.
	}
	//year
	$epoch = ($birth_year > 1970) ? $epoch + $epoch_Y * 365 - 1 + $leapyear : $epoch - $epoch_Y * 365 - 1 - $leapyear;

	return $epoch;
}


// Add function realdate for Birthday MOD
// the originate php "date()", does not work proberly on all OS, especially when going back in time
// before year 1970 (year 0), this function "realdate()", has a mutch larger valid date range,
// from 1901 - 2099. it returns a "like" UNIX date format (only d,m and Y, may be used)
// is expect a input like a UNIX timestamp divided by 86400, so
// calculation from the originate php date and mktime is easy.
// e.g. realdate ("m d Y", 3) returns the string "1 3 1970"
function realdate($date_syntax,$date)
{
	global $lang;
	$birth_year = 0;
	$date_mid = $date;
	$i = 2;
	if ( $date >= 0 )
	{
		while ($date_mid > 364)
		{
			$date_mid = $date_mid - 365;
			$birth_year++;
			if ( $i==3 )
			{
				$i = 0;
				if ( $date_mid > 365 )
				{
					$date_mid--;
				}
			}
			else
			{
				$i++;
			}
		}
	}
	else if ( $date < 0 )
	{
		while ($date_mid < 0)
		{
			$birth_year--;
			$date_mid = $date_mid + 365;
			if ( $i==3 )
			{
				$i=0;
				$date_mid++;
			}
			else
			{
				$i++;
			}
		}
	}
	$days = $days + $date_mid;
	if ( ($birth_year + 2) % 4 == 0 )
	{
		if ( $date_mid > 334 )
		{
			$day = $date_mid - 334;
			$month = 12;
		}
		else if ( $date_mid > 304 )
		{
			$day = $date_mid - 304;
			$month = 11;
		}
		else if ( $date_mid > 273 )
		{
			$day = $date_mid - 273;
			$month = 10;
		}
		else if ( $date_mid>243 )
		{
			$day = $date_mid - 243;
			$month = 9;
		}
		else if ( $date_mid > 212 )
		{
			$day = $date_mid - 212;
			$month = 8;
		}
		else if ( $date_mid > 181 )
		{
			$day = $date_mid - 181;
			$month = 7;
		}
		else if ( $date_mid > 151 )
		{
			$day = $date_mid - 151;
			$month = 6;
		}
		else if ( $date_mid > 120 )
		{
			$day = $date_mid - 120;
			$month = 5;
		}
		else if ( $date_mid > 90 )
		{
			$day = $date_mid - 90;
			$month = 4;
		}
		else if ( $date_mid > 59 )
		{
			$day = $date_mid - 59;
			$month = 3;
		}
		else if ( $date_mid > 30 )
		{
			$day = $date_mid - 30;
			$month = 2;
		}
		else
		{
			$month = 1;
			$day = $date_mid + 1;
		}
	}
	else
	{
		if ( $date_mid > 333 )
		{
			$day = $date_mid-333;
			$month =12;
		}
		else if ( $date_mid > 303 )
		{
			$day = $date_mid - 303;
			$month = 11;
		}
		else if ( $date_mid > 272)
		{
			$day = $date_mid - 272;
			$month = 10;
		}
		else if ( $date_mid > 242 )
		{
			$day = $date_mid - 242;
			$month = 9;
		}
		else if ( $date_mid > 211 )
		{
			$day = $date_mid - 211;
			$month = 8;
		}
		else if ( $date_mid > 180 )
		{
			$day = $date_mid - 180;
			$month = 7;
		}
		else if ( $date_mid > 150 )
		{
			$day = $date_mid - 150;
			$month = 6;
		}
		else if ( $date_mid > 119 )
		{
			$day = $date_mid - 119;
			$month = 5;
		}
		else if ( $date_mid > 89 )
		{
			$day = $date_mid - 89;
			$month = 4;
		}
		else if ( $date_mid > 58 )
		{
			$day = $date_mid - 58;
			$month = 3;
		}
		else if ( $date_mid > 30 )
		{
			$day = $date_mid - 30;
			$month = 2;
		}
		else
		{
			$month = 1;
			$day = $date_mid + 1;
		}
	}

	if ( !(strrpos($date_syntax, 'j') === false) )
	{
		$date_syntax = str_replace('j', $day,$date_syntax);
	}
	else
	{
		if ( $day < 10 )
		{
			$day = '0'.($day);
		}
		$date_syntax = str_replace('d', $day,$date_syntax);
	}
	if ( !(strrpos($date_syntax, 'n' ) === false) )
	{
		$date_syntax = str_replace('n', $month,$date_syntax);
	}
	else
	{
		if ( $month < 10 )
		{
			$month ='0'.($month);
		}
		$date_syntax = str_replace('m', $month,$date_syntax);
		$month--;
		$date_table = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
		$date_syntax = str_replace('M', $lang['datetime'][$date_table[$month]], $date_syntax);
	}
	$birth_year = $birth_year + 1970;
	$date_syntax = str_replace('Y', $birth_year, $date_syntax);

	return $date_syntax;
}


function get_poster_topic_posts($topic_id, $user_id)
{
	global $lang, $db;

	static $ptp_buff;

	if( !isset($ptp_buff) )
	{
		$ptp_buff = array();
	}
	if( is_array($topic_id) )
	{
		$topic_id_list = implode(',', $topic_id);
		$sql = "SELECT topic_id, COUNT(post_id) AS posts
			FROM " . POSTS_TABLE . "
			WHERE topic_id IN ($topic_id_list)
				AND poster_id = $user_id
			GROUP BY topic_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain poster topic posts information', '', __LINE__, __FILE__, $sql);
		}
		while( $row = $db->sql_fetchrow($result) )
		{
			$ptp_buff[$user_id][$row['topic_id']] = $row['posts'];
		}
		foreach( $topic_id as $id )
		{
			if( !isset($ptp_buff[$user_id][$id]) )
			{
				$ptp_buff[$user_id][$id] = '';
			}
		}
		return;
	}

	if( isset($ptp_buff[$user_id][$topic_id]) )
	{
		return $ptp_buff[$user_id][$topic_id];
	}

	$sql = "SELECT COUNT(post_id) AS posts
		FROM " . POSTS_TABLE . "
		WHERE topic_id = $topic_id 
			AND poster_id = $user_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain poster topic posts information', '', __LINE__, __FILE__, $sql);
	}

	$poster_posts = ( $row = $db->sql_fetchrow($result) ) ? $row['posts'] : '';

	return $poster_posts;
}


function get_posts_last_reply($topic_id, $user_id)
{
	global $lang, $db;

	static $last_posts;

	if( !isset($last_posts) )
	{
		$last_posts = array();
	}
	if( is_array($topic_id) )
	{
		$topic_id_list = implode(',', $topic_id);
		$sql = "SELECT topic_id, MAX(post_id) AS post
			FROM " . POSTS_TABLE . "
			WHERE topic_id IN ($topic_id_list)
				AND poster_id = $user_id
			GROUP BY topic_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain poster topic posts information', '', __LINE__, __FILE__, $sql);
		}
		while( $row = $db->sql_fetchrow($result) )
		{
			$last_posts[$user_id][$row['topic_id']] = $row['post'];
		}
		foreach( $topic_id as $id )
		{
			if( !isset($last_posts[$user_id][$id]) )
			{
				$last_posts[$user_id][$id] = 0;
			}
		}
		return;
	}

	if( isset($last_posts[$user_id][$topic_id]) )
	{
			$poster_last_post = $last_posts[$user_id][$topic_id];
	}
	else
	{
		$sql = "SELECT post_id 
			FROM " . POSTS_TABLE . "
			WHERE topic_id = $topic_id 
				AND poster_id = $user_id
			ORDER by post_id DESC
			LIMIT 1";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain poster topic posts information', '', __LINE__, __FILE__, $sql);
		}
	$poster_last_post = ( $row = $db->sql_fetchrow($result) ) ? $row['post_id'] : 0;
	}

	$sql = "SELECT COUNT(post_id) AS posts
		FROM " . POSTS_TABLE . "
		WHERE topic_id = $topic_id 
			AND poster_id <> $user_id
			AND post_id > $poster_last_post";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain poster topic posts information', '', __LINE__, __FILE__, $sql);
	}
	$poster_replies = ( $row = $db->sql_fetchrow($result)) ? $row['posts'] : '';
	$poster_replies = ( $poster_replies > 0 ) ? $poster_replies : '';
	return $poster_replies;
}


function user_agent($agent, $uaimages)
{
	$uaimages = $uaimages . '/user_agent/';
	$sa = '';
	if ( eregi('windows', $agent) || eregi('win9', $agent) || eregi('win32', $agent) )
	{
		$sa = (eregi('windows 9', $agent) || eregi('nt 4', $agent) || eregi('nt 5.0', $agent) || eregi('windows', $agent) || eregi('win32', $agent)) ? 'windows_98_nt_2000' : $sa;
		$sa = (eregi('nt 5.1', $agent) || eregi('nt 5.2', $agent) || eregi('nt 5.3', $agent) || eregi('nt 5.4', $agent) || eregi('nt 5.5', $agent)) ? 'windows_xp_2003' : $sa;
	}
	else
	{
		$sa = (eregi('linux', $agent)) ? 'linux' : $sa;
		$sa = (eregi('suse', $agent)) ? 'linux_suse' : $sa;
		$sa = (eregi('knoppix', $agent)) ? 'linux_knoppix' : $sa;
		$sa = (eregi('turbolinux', $agent)) ? 'linux_turbolinux' : $sa;
		$sa = (eregi('slackware', $agent)) ? 'linux_slackware' : $sa;
		$sa = (eregi('gentoo', $agent)) ? 'linux_gentoo' : $sa;
		$sa = (eregi('lycoris', $agent)) ? 'linux_lycoris' : $sa;
		$sa = (eregi('debian', $agent)) ? 'linux_debian' : $sa;
		$sa = (eregi('redhat', $agent)) ? 'linux_redhat' : $sa;
		$sa = (eregi('bsd', $agent)) ? 'linux_freebsd' : $sa; // :P
	}
	if ( $sa == '')
	{
		$sa = (eregi('mac', $agent)) ? 'macos' : $sa;
		$sa = (eregi('aix', $agent)) ? 'aix' : $sa;
		$sa = (eregi('lindows', $agent)) ? 'lindows' : $sa;
		$sa = (eregi('amiga', $agent)) ? 'amiga' : $sa;
		$sa = (eregi('athe', $agent)) ? 'athe' : $sa;
		$sa = (eregi('beos', $agent)) ? 'beos' : $sa;
		$sa = (eregi('zeta', $agent)) ? 'beos' : $sa;
		$sa = (eregi('BlueEyed', $agent)) ? 'beos' : $sa;
		$sa = (eregi('nextstep', $agent)) ? 'nextstep' : $sa;
		$sa = (eregi('warp', $agent)) ? 'warp' : $sa;
		$sa = (eregi('qnx', $agent)) ? 'qnx' : $sa;
		$sa = (eregi('risc', $agent)) ? 'risc' : $sa;
		$sa = (eregi('solaris', $agent)) ? 'solaris' : $sa;
		$sa = (eregi('unix', $agent)) ? 'unix' : $sa;
		$sa = (eregi('macos', $agent)) ? 'macos' : $sa;
		$sa = (eregi('mac os', $agent)) ? 'macos' : $sa;
		$sa = ($sa == '' && eregi('win9', $agent) || eregi('win3', $agent) || eregi('windows', $agent)) ? 'windows_98_nt_2000' : $sa;
	}
	
	$ba = '';
	$ba = (eregi('mozilla', $agent)) ? 'mozilla' : $ba;
	$ba = (eregi('msie', $agent)) ? 'ie' : $ba;
	$ba = (eregi('netscape', $agent)) ? 'netscape' : $ba;
	$ba = (eregi('opera', $agent)) ? 'opera' : $ba;
	$ba = (eregi('konqueror', $agent)) ? 'konqueror' : $ba;
	$ba = (eregi('galeon', $agent)) ? 'galeon' : $ba;
	$ba = (eregi('firefox', $agent)) ? 'firefox' : $ba;
	$ba = (eregi('netsprint', $agent)) ? 'netsprint' : $ba;
	$ba = (eregi('firebird', $agent)) ? 'firebird' : $ba;
	$ba = (eregi('links', $agent)) ? 'links' : $ba;
	$ba = (eregi('dillo', $agent)) ? 'dillo' : $ba;
	$ba = (eregi('omniweb', $agent)) ? 'omniweb' : $ba;
	$ba = (eregi('avant', $agent)) ? 'avant' : $ba;
	$ba = (eregi('myie2', $agent)) ? 'myie2' : $ba;

	$ba = ($ba == '') ? 'unknown' : $ba;
	$sa = ($sa == '') ? 'unknown' : $sa;

	$agent_img = $uaimages . 'icon_' . $sa . '.gif';
	$sizes = @getimagesize($agent_img);
	$agent_img = (intval($sizes[0]) > 0 && intval($sizes[1]) > 0) ? $agent_img . '" width="' . $sizes[0] . '" height="' . $sizes[1] : $agent_img;

	$system_img = $uaimages . 'icon_' . $ba . '.gif';
	$sizes = @getimagesize($system_img);
	$system_img = (intval($sizes[0]) > 0 && intval($sizes[1]) > 0) ? $system_img . '" width="' . $sizes[0] . '" height="' . $sizes[1] : $system_img;

	return '&nbsp;&nbsp;<img src="' . $agent_img . '" alt="" align="top" title="' . $agent . '">&nbsp;<img src="' . $system_img . '" alt="" align="top" title="' . $agent . '">';
}


function is_jr_admin($user_id)
{
	global $db;
	$sql = "SELECT COUNT(user_id) AS is_jr_admin
		FROM " . JR_ADMIN_TABLE . "
		WHERE user_id = $user_id
			AND user_jr_admin <> ''";
	if ( !($result = $db->sql_query($sql)) )
	{
		return false;
	}
	if ( $row = $db->sql_fetchrow($result) )
	{
		$is_jr_admin = ($row['is_jr_admin'] > 0) ? true : false;
	}
	return $is_jr_admin;
}


function is_mod($user_id, $forum_id = '')
{
	global $db;

	$check_forum_sql = ($forum_id) ? " AND aa.forum_id = $forum_id" : '';

	$sql = "SELECT COUNT(auth_mod) AS is_mod 
		FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . USERS_TABLE . " u 
		WHERE ug.user_id = $user_id
			AND ug.user_pending = 0 
			AND aa.group_id = ug.group_id 
			AND aa.auth_mod = " . TRUE . "
			$check_forum_sql
			AND u.user_level <> 1"; 
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain moderator status', '', __LINE__, __FILE__, $sql);
	}
	if ( $row = $db->sql_fetchrow($result))
	{
		$is_mod = ($row['is_mod'] > 0) ? true : false;
	}
	return $is_mod;
}


function no_post_count($forum_id, $mode = '')
{
	global $db;

	if ( $mode != 'list' )
	{
		$sql = "SELECT no_count FROM " . FORUMS_TABLE . "
			WHERE forum_id = $forum_id";
		if ( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not retrieve forum data', '', __LINE__, __FILE__, $sql);
		}

		$row = $db->sql_fetchrow($result);
		if ( $row['no_count'] )
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	else
	{
		$sql = "SELECT forum_id 
			FROM " . FORUMS_TABLE . "
			WHERE no_count = 1";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query forums table', '', __LINE__, __FILE__, $sql);
		}

		$no_count_forums = '';
		while( $row = $db->sql_fetchrow($result) )
		{
			$no_count_forums .= ( ( $no_count_forums != '' ) ? ', ' : '' ) . $row['forum_id'];
		}
		return $no_count_forums;
	}
}


function custom_fields($check = '', $view = false, $forum_id = '')
{
	global $db;

	if ( $check )
	{
		if ( $check == 'viewtopic' )
		{
			$where = "WHERE view_post <> 0 AND no_forum NOT LIKE '%[" . $forum_id . "]%'";
		}
		else if ( $check == 'profile' )
		{
			$where = 'WHERE view_profile <> 0';
		}
		else if ( $check == 'quick_regist' )
		{
			$where = 'WHERE requires = 1';
		}

		$sql = "SELECT COUNT(id) AS total
			FROM " . FIELDS_TABLE . "
			$where
			LIMIT 1";
		if ( !($result = $db->sql_query($sql)) )
		{
			return false;
		}
		$row = $db->sql_fetchrow($result);
		if ( $row['total'] > 0 )
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		if ( $view == 'quick_regist' )
		{
			$get_sql = 'id, desc_short, max_value, jumpbox';
			$get_viewprofile = 'WHERE requires = 1';
		}
		else
		{
			$get_sql = (!$view) ? 'id, desc_short, desc_long, max_value, min_value, numerics, requires, jumpbox, set_form' : 'id, desc_short, max_value, min_value, numerics, jumpbox, makelinks, view_post';
			$get_viewprofile = ($view == 'profile') ? "WHERE view_profile <> 0" : "WHERE view_post <> 0 AND no_forum NOT LIKE '%[" . $forum_id . "]%'";
		}
		if ( !$view )
		{
			$get_viewprofile = 'WHERE view_profile <> 0 OR view_post <> 0 OR requires = 1';
		}

		$sql = "SELECT " . $get_sql . "
			FROM " . FIELDS_TABLE . "
			$get_viewprofile
			ORDER by id ASC";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get data from fields table', '', __LINE__, __FILE__, $sql);
		}
		$row = $db->sql_fetchrow($result);

		$i = 0;
		do
		{
			if ( $view != 'quick_regist' )
			{
				if ( !$view )
				{
					$requires[] = $row['requires'];
					$desc_long[] = $row['desc_long'];
					$set_form[] = $row['set_form'];
				}

				$id[] = $row['id'];
				$desc[] = $row['desc_short'];
				$max_value[] = $row['max_value'];
				$min_value[] = $row['min_value'];
				$numerics[] = $row['numerics'];
				$jumpbox[] = str_replace(", ", ",", $row['jumpbox']);
				$makelinks[] = $row['makelinks'];
				$view_post[] = $row['view_post'];
			}
			else
			{
				$id[] = $row['id'];
				$desc[] = $row['desc_short'];
				$max_value[] = $row['max_value'];
				$jumpbox[] = str_replace(", ", ",", $row['jumpbox']);
			}

			$i++;
		}
		while ( $row = $db->sql_fetchrow($result) );
		
		if ( $view != 'quick_regist' )
		{
			if ( !$view )
			{
				return array($id, $desc, $max_value, $min_value, $numerics, $requires, $jumpbox, $desc_long, $set_form);
			}
			else
			{
				return array($id, $desc, $max_value, $min_value, $numerics, $jumpbox, $makelinks, $view_post);
			}
		}
		else
		{
			return array($id, $desc, $max_value, $jumpbox);
		}
	}
}

function get_ri()
{
	global $db;

	$sql = "SELECT *
		FROM " . PORTAL_CONFIG_TABLE . "
		WHERE config_name = 'ri_data'
			OR config_name = 'ri_time'";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, 'Could not query portal config information', '', __LINE__, __FILE__, $sql);
	}
	
	while ( $row = $db->sql_fetchrow($result) )
	{
		$ri_config[$row['config_name']] = $row['config_value'];
	}

	if ( intval($ri_config['ri_time']) < time() - (24 * 3600 * 5) || intval($ri_config['ri_time']) > time() )
	{
		$sql = "UPDATE " . PORTAL_CONFIG_TABLE . "
			SET config_value = '" . time() . "'
			WHERE config_name = 'ri_time'";
		if ( !($result = $db->sql_query($sql)) ) 
		{
			message_die(GENERAL_ERROR, 'Error in updating config table');
		}

		$fp = @fsockopen('przemo.org', 80, $erstr, $errno, 2);
		if ( $fp )
		{
			$path = "/phpBB2/data.txt";
			@fputs($fp, "GET $path HTTP/1.0\r\nHost: przemo.org\r\n\r\n");
			$data = '';
			while (!@feof($fp))
			{
				$data .= @fgets($fp, 2048) . '<br>';
			}
			@fclose($fp);

			if ( @eregi('begin_info', $data) )
			{
				$begin = strpos($data, 'begin_info');
				$end = strpos($data, 'end_info');
				$data_out = substr($data, $begin + 10, $end - $begin - 10);
				$data_out = str_replace("'", "\'", $data_out);

				$sql = "UPDATE " . PORTAL_CONFIG_TABLE . "
					SET config_value = '$data_out'
					WHERE config_name = 'ri_data'";
				if ( !($result = $db->sql_query($sql)) ) 
				{
					message_die(GENERAL_ERROR, 'Error in updating config table');
				}

				$ri_config['ri_data'] = $data_out = str_replace("\\'", "'", $data_out);
			}
		}
	}

	return print $ri_config['ri_data'];
}

// Function strip all BBcodes (borrowed from Mouse Hover Topic Preview MOD)
function bbencode_strip($text, $uid)
{
	// pad it with a space so we can distinguish between FALSE and matching the 1st char (index 0).
	// This is important; bbencode_quote(), bbencode_list(), and bbencode_code() all depend on it.
	$text = ' ' . $text;

	if ( !(strpos($text, "[") && strpos($text, "]")) )
	{
		$text = substr($text, 1);
		return $text;
	}

	$text = str_replace("[code:1:$uid]","", $text);
	$text = str_replace("[/code:1:$uid]", " ", $text);
	$text = str_replace("[code:$uid]", "", $text);
	$text = str_replace("[/code:$uid]", " ", $text);

	$text = str_replace("[quote:1:$uid]","", $text);
	$text = str_replace("[/quote:1:$uid]", " ", $text);
	$text = str_replace("[quote:$uid]", "", $text);
	$text = str_replace("[/quote:$uid]", " ", $text);

	$text = preg_replace("/\[quote:$uid=(?:\"?([^\"]*)\"?)\]/si", "", $text);
	$text = preg_replace("/\[quote:1:$uid=(?:\"?([^\"]*)\"?)\]/si", "", $text);
	
	$text = str_replace("[list:$uid]", "", $text);
	$text = str_replace("[*:$uid]", " ", $text);
	$text = str_replace("[/list:u:$uid]", " ", $text);
	$text = str_replace("[/list:o:$uid]", " ", $text);
	$text = preg_replace("/\[list=([a1]):$uid\]/si", "", $text);

	$text = preg_replace("/\[color=(\#[0-9A-F]{6}|[a-z]+):$uid\]/si", "", $text);
	$text = str_replace("[/color:$uid]", " ", $text);

	$text = str_replace("[url]","", $text);
	$text = str_replace("[/url]", " ", $text);
	$text = str_replace("[/URL]", " ", $text);

	$text = preg_replace("/\[url=([a-z0-9\-\.,\?!%\*_\/:;~\\&$@\/=\+]+)\]/si", "", $text);
	$text = str_replace("[/url]", " ", $text);

	$text = str_replace("[img:$uid]","", $text);
	$text = str_replace("[/img:$uid]", " ", $text);

	$text = str_replace("[email:$uid]","", $text);
	$text = str_replace("[/email:$uid]", " ", $text);

	$text = preg_replace("/\[size=([\-\+]?[1-2]?[0-9]):$uid\]/si", "", $text);
	$text = str_replace("[/size:$uid]", " ", $text);
	
	$text = preg_replace("/\[align=(left|right|center|justify):$uid\]/si", "", $text);
	$text = str_replace("[/align:$uid]", " ", $text);

	$text = str_replace("[b:$uid]","", $text);
	$text = str_replace("[/b:$uid]", " ", $text);

	$text = str_replace("[u:$uid]", "", $text);
	$text = str_replace("[/u:$uid]", " ", $text);

	$text = str_replace("[i:$uid]", "", $text);
	$text = str_replace("[/i:$uid]", " ", $text);

	$text = str_replace("[fade:$uid]", "", $text);
	$text = str_replace("[/fade:$uid]", " ", $text);

	$text = str_replace("[scroll:$uid]", "", $text);
	$text = str_replace("[/scroll:$uid]", " ", $text);

	$text = str_replace("[center:$uid]", "", $text);
	$text = str_replace("[/center:$uid]", " ", $text);

	$text = preg_replace("/\[glow=(\#[0-9A-F]{6}|[a-z]+):$uid\]/si", "", $text);
	$text = str_replace("[/glow:$uid]", " ", $text);

	$text = preg_replace("/\[shadow=(\#[0-9A-F]{6}|[a-z]+):$uid\]/si", "", $text);
	$text = str_replace("[/shadow:$uid]", " ", $text);

	$text = str_replace("[g:$uid]", "", $text);
	$text = str_replace("[/g:$uid]", " ", $text);

	$text = str_replace("[you:$uid]", "you", $text);

	$text = preg_replace("#\[hide:$uid\](.*?)\[/hide:$uid\]#si"," ", $text);

	$text = preg_replace("#\[mod\](.*?)\[/mod\]#si"," ", $text);

	$text = substr($text, 1);

	return $text;
}


function notify_delete($post_id, $topic_id, $user_id, $notify_user, $reason, $in_modcp = false)
{
	global $db, $lang, $board_config, $phpEx;

	$get_post_id = ($in_modcp) ? 't.topic_first_post_id' : $post_id;

	$sql = "SELECT t.topic_first_post_id, t.topic_title, pt.post_text, pt.bbcode_uid, u.username, u.user_email, u.user_lang
		FROM " . TOPICS_TABLE . " t, " . POSTS_TEXT_TABLE . " pt, " . USERS_TABLE . " u
		WHERE pt.post_id = $get_post_id
			AND t.topic_id = $topic_id
			AND u.user_id = $notify_user";

	if ( !($result = $db->sql_query($sql)) )
	{
		return;
	}

	$row = $db->sql_fetchrow($result);

	if ( !$row['user_email'] )
	{
		return;
	}

	$unhtml_specialchars_match = array('#&gt;#', '#&lt;#', '#&quot;#', '#&amp;#');
	$unhtml_specialchars_replace = array('>', '<', '"', '&');

	$post_text = preg_replace($unhtml_specialchars_match, $unhtml_specialchars_replace, $row['post_text']);
	$post_text = preg_replace("#\[mod\](.*?)\[/mod\]#si", "", $post_text);

	$separator = "\n\r";
	$separator .= ($row['topic_title']) ? "\n\r" . preg_replace($unhtml_specialchars_match, $unhtml_specialchars_replace, $lang['Topic'] . ': "' . $row['topic_title']) . "\"\n\r" : '';
	$separator .= "\n\r" . (($board_config['del_notify_method']) ? bbencode_strip($post_text, $row['bbcode_uid']) : str_replace(':' . $row['bbcode_uid'], '', $post_text));

	$reason_out = (is_numeric($reason)) ? $lang['del_notify_reasons'][$reason] : $reason;
	$reason_out = ($reason == '0' || empty($reason_out) || is_numeric($reason_out)) ? '.' : '. ' . $lang['reason'] . ': ' . $reason_out;
	$l_post_topic = ($row['topic_first_post_id'] == $post_id || $in_modcp) ? $lang['Topic'] : $lang['Post'];

	$server_protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
	$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
	$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
	$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
	$script_name = ($script_name == '') ? $script_name . '/viewtopic.'.$phpEx : '/' . $script_name . '/viewtopic.'.$phpEx;

	$url_absolute = $server_protocol . $server_name . $server_port . $script_name;

	$u_topic = $url_absolute . '?' . POST_TOPIC_URL . '=' . $topic_id;

	$topic_link = ($row['topic_first_post_id'] == $post_id || $in_modcp) ? '' : sprintf($lang['topic_link'], $u_topic);

	if ( $board_config['del_notify_method'] )
	{
		$message = sprintf($lang['notify_message'], $l_post_topic, '"' . $board_config['sitename'] . '"', $reason_out . $topic_link . $lang['your_post'] . $separator);

		require_once($phpbb_root_path . 'includes/emailer.'.$phpEx);
		$emailer = new emailer($board_config['smtp_delivery']);

		$emailer->from($board_config['email_from']);
		$emailer->replyto($board_config['email_return_path']);

		$emailer->use_template('notify_delete', $row['user_lang']);
		$emailer->email_address($row['user_email']);
		$emailer->set_subject(sprintf($lang['subject_notify_delete'], $l_post_topic));

		$emailer->assign_vars(array(
			'SITENAME' => $board_config['sitename'],
			'BOARD_EMAIL' => $board_config['board_email'],
			'TO_USERNAME' => $row['username'],
			'URL' => $url_absolute,
			'MESSAGE' => $message)
		);

		$emailer->send();
		$emailer->reset();
	}
	else
	{
		send_forum_pm($notify_user, sprintf($lang['subject_notify_delete'], $l_post_topic), sprintf($lang['notify_message'], $l_post_topic, '"' . $board_config['sitename'] . '"', $reason_out . $topic_link . $lang['your_post'] . $separator));
	}
	return;
}

function send_forum_pm($user_to_id, $nd_subject, $nd_message)
{
	global $board_config, $lang, $db, $phpbb_root_path, $phpEx;

	$sql = "SELECT *
		FROM " . USERS_TABLE . " 
		WHERE user_id = " . $user_to_id . "
		AND user_id <> " . ANONYMOUS;
	if ( !($result = $db->sql_query($sql)) )
	{
		return;
	}
	$to_userdata = $db->sql_fetchrow($result);

	require_once($phpbb_root_path . 'includes/bbcode.'.$phpEx);
	require_once($phpbb_root_path . 'includes/functions_post.'.$phpEx);

	$bbcode_uid = make_bbcode_uid();
	$nd_message = str_replace("'", "''", $nd_message);

	$nd_message = prepare_message(trim($nd_message), 0, 1, 1, $bbcode_uid);

	$msg_time = time();

	// Do inbox limit stuff
	$sql = "SELECT COUNT(privmsgs_id) AS inbox_items, MIN(privmsgs_date) AS oldest_post_time 
		FROM " . PRIVMSGS_TABLE . " 
		WHERE ( privmsgs_type = " . PRIVMSGS_NEW_MAIL . " 
			OR privmsgs_type = " . PRIVMSGS_READ_MAIL . " 
			OR privmsgs_type = " . PRIVMSGS_UNREAD_MAIL . " ) 
			AND privmsgs_to_userid = " . $to_userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		return;
	}

	$sql_priority = ( SQL_LAYER == 'mysql' ) ? 'LOW_PRIORITY' : '';

	if ( $inbox_info = $db->sql_fetchrow($result) )
	{
		if ( $inbox_info['inbox_items'] >= $board_config['max_inbox_privmsgs'] )
		{
			$sql = "DELETE $sql_priority FROM " . PRIVMSGS_TABLE . " 
				WHERE ( privmsgs_type = " . PRIVMSGS_NEW_MAIL . " 
					OR privmsgs_type = " . PRIVMSGS_READ_MAIL . " 
					OR privmsgs_type = " . PRIVMSGS_UNREAD_MAIL . " ) 
						AND privmsgs_date = " . $inbox_info['oldest_post_time'] . " 
						AND privmsgs_to_userid = " . $to_userdata['user_id'];
			if ( !$db->sql_query($sql) )
			{
				return;
			}
		}
	}

	$sql_info = "INSERT INTO " . PRIVMSGS_TABLE . " (privmsgs_type, privmsgs_subject, privmsgs_from_userid, privmsgs_to_userid, privmsgs_date, privmsgs_ip, privmsgs_enable_html, privmsgs_enable_bbcode, privmsgs_enable_smilies, privmsgs_attach_sig)
		VALUES (" . PRIVMSGS_NEW_MAIL . ", '" . str_replace("\'", "''", $nd_subject) . "', -1, " . $to_userdata['user_id'] . ", $msg_time, '$user_ip', 0, 1, 1, 1)";

	if ( !($result = $db->sql_query($sql_info, BEGIN_TRANSACTION)) )
	{
		return;
	}

	$privmsg_sent_id = $db->sql_nextid();

	$sql = "INSERT INTO " . PRIVMSGS_TEXT_TABLE . " (privmsgs_text_id, privmsgs_bbcode_uid, privmsgs_text)
		VALUES ($privmsg_sent_id, '" . $bbcode_uid . "', '" . str_replace("\'", "''", $nd_message) . "')";

	if ( !$db->sql_query($sql, END_TRANSACTION) )
	{
		return;
	}

	$sql = "UPDATE " . USERS_TABLE . "
		SET user_new_privmsg = user_new_privmsg + 1, user_last_privmsg = '9999999999'
		WHERE user_id = " . $to_userdata['user_id']; 
	if ( !$status = $db->sql_query($sql) )
	{
		return;
	}

	return;
}

function confirm($confirm_lang, $address, $sid = '')
{
	global $lang;

	$form_sid = ($sid) ? '<input type="hidden" name="sid" value="' . $sid . '">' : '';
	message_die(GENERAL_MESSAGE, '<form action="' . $address . '" method="post"><table border="0"><tr><td class="row1" align="center"><span class="gen">' . $confirm_lang . '</span><br /><br /><input type="hidden" name="confirm" value="1"><input type="submit" name="confirm" class="mainoption" value="' . $lang['Yes'] . '" />&nbsp;&nbsp;<input type="submit" name="cancel" value="' . $lang['No'] . '" class="liteoption" />' . $form_sid . '</td></tr></table></form>');

	return;
}

function is_jr_admin_buffered($user_id)
{
	global $db;
	static $jradmin_list;

	if( !isset($jradmin_list) )
	{
		$sql = "SELECT DISTINCT user_id
			FROM " . JR_ADMIN_TABLE . "
			WHERE user_jr_admin <> ''";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain junior admin list', '', __LINE__, __FILE__, $sql);
		}
		$jradmin_list = array();
		while( $row = $db->sql_fetchrow($result) )
		{
			$jradmin_list[$row['user_id']] = true;
		}
	}
	return isset($jradmin_list[$user_id]) ? true : false;
}

function is_mod_buffered($user_id)
{
	global $db;
	static $mod_list;

	if( !isset($mod_list) )
	{
		$sql = "SELECT DISTINCT ug.user_id AS mod_user
			FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . USERS_TABLE . " u
			WHERE ug.user_pending = 0
				AND aa.group_id = ug.group_id
				AND u.user_id = ug.user_id
				AND aa.auth_mod = " . TRUE . "
			AND u.user_level <> 1";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain moderator list', '', __LINE__, __FILE__, $sql);
		}
		$mod_list = array();
		while( $row = $db->sql_fetchrow($result) )
		{
			$mod_list[$row['mod_user']] = true;
		}
	}
	return isset($mod_list[$user_id]) ? true : false;
}

// added at phpBB 2.0.12 to fix a bug in PHP 4.3.10 (only supporting charlist in php >= 4.1.0)
function phpbb_rtrim($str, $charlist = false)
{
	if ($charlist === false)
	{
		return rtrim($str);
	}
	
	$php_version = explode('.', PHP_VERSION);

	// php version < 4.1.0
	if ((int) $php_version[0] < 4 || ((int) $php_version[0] == 4 && (int) $php_version[1] < 1))
	{
		while ($str{strlen($str)-1} == $charlist)
		{
			$str = substr($str, 0, strlen($str)-1);
		}
	}
	else
	{
		$str = rtrim($str, $charlist);
	}

	return $str;
}

?>