<?php
/***************************************************************************
 *						functions_admin.php
 *						-------------------
 *	begin				: Saturday, Feb 13, 2001
 *	copyright			: (C) 2001 The phpBB Group
 *	email				: support@phpbb.com
 *	modification 		: (C) 2003 Przemo http://www.przemo.org
 *	date modification	: ver. 1.9 2004/05/30 21:50
 *
 *	$Id: functions_admin.php,v 1.8.9 2004/05/30 21:50
 ***************************************************************************/

/***************************************************************************
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 ***************************************************************************/

//
// Simple version of jumpbox, just lists authed forums
//
function make_forum_select($box_name, $ignore_forum = false, $select_forum = '')
{
	global $db, $userdata;

	$is_auth_ary = auth(AUTH_READ, AUTH_LIST_ALL, $userdata);

	$sql = "SELECT forum_id, forum_name
		FROM " . FORUMS_TABLE . " 
		ORDER BY cat_id, forum_order";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldn not obtain forums information', '', __LINE__, __FILE__, $sql);
	}

	$forum_list = '';
	while( $row = $db->sql_fetchrow($result) )
	{
		if ( $is_auth_ary[$row['forum_id']]['auth_read'] && $ignore_forum != $row['forum_id'] )
		{
			$selected = ( $select_forum == $row['forum_id'] ) ? ' selected="selected"' : '';
			$forum_list .= '<option value="' . $row['forum_id'] . '"' . $selected .'>' . $row['forum_name'] . '</option>';
		}
	}

	$forum_list = ( $forum_list == '' ) ? '<option value="-1">-- ! No Forums ! --</option>' : '<select name="' . $box_name . '">' . $forum_list . '</select>';

	return $forum_list;
}


//
// Synchronise functions for forums/topics
//
function sync($type, $id = false)
{
	global $db;

	switch($type)
	{
		case 'all forums':
			$sql = "SELECT forum_id
				FROM " . FORUMS_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get forum IDs', '', __LINE__, __FILE__, $sql);
			}

			while( $row = $db->sql_fetchrow($result) )
			{
				sync('forum', $row['forum_id']);
			}
			break;

		case 'all topics':
			$sql = "SELECT topic_id
				FROM " . TOPICS_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get topic ID', '', __LINE__, __FILE__, $sql);
			}

			while( $row = $db->sql_fetchrow($result) )
			{
				sync('topic', $row['topic_id']);
			}
			break;

			case 'forum':
			$sql = "SELECT MAX(post_id) AS last_post, COUNT(post_id) AS total 
				FROM " . POSTS_TABLE . "
				WHERE forum_id = $id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get post ID', '', __LINE__, __FILE__, $sql);
			}

			if ( $row = $db->sql_fetchrow($result) )
			{
				$last_post = ( $row['last_post'] ) ? $row['last_post'] : 0;
				$total_posts = ($row['total']) ? $row['total'] : 0;
			}
			else
			{
				$last_post = 0;
				$total_posts = 0;
			}

			$sql = "SELECT COUNT(topic_id) AS total
				FROM " . TOPICS_TABLE . "
				WHERE forum_id = $id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get topic count', '', __LINE__, __FILE__, $sql);
			}

			$total_topics = ( $row = $db->sql_fetchrow($result) ) ? ( ( $row['total'] ) ? $row['total'] : 0 ) : 0;

			$sql = "UPDATE " . FORUMS_TABLE . "
				SET forum_last_post_id = $last_post, forum_posts = $total_posts, forum_topics = $total_topics
				WHERE forum_id = $id";
			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not update forum', '', __LINE__, __FILE__, $sql);
			}
			break;

		case 'topic':
			$sql = "SELECT MAX(post_id) AS last_post, MIN(post_id) AS first_post, COUNT(post_id) AS total_posts
				FROM " . POSTS_TABLE . "
				WHERE topic_id = $id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not get post ID', '', __LINE__, __FILE__, $sql);
			}

			if ( $row = $db->sql_fetchrow($result) )
			{
				$sql = ($row['total_posts']) ? "UPDATE " . TOPICS_TABLE . " SET topic_replies = " . ( $row['total_posts'] - 1 ) . ", topic_first_post_id = " . $row['first_post'] . ", topic_last_post_id = " . $row['last_post'] . " WHERE topic_id = $id" : "DELETE FROM " . TOPICS_TABLE . " WHERE topic_id = $id";
						
				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not update topic', '', __LINE__, __FILE__, $sql);
				}
			}
			if ( defined('ATTACHMENTS_ON') )
			{
				attachment_sync_topic($id);
			}
			break;
	}
	
	return true;
}


function check_form($chars, $text)
{
	if ( empty($text) )
	{
		message_die(GENERAL_MESSAGE, 'Short Description is empty !');
	}

	if ( substr($chars, 0, 1) == ',' )
	{
		$chars = substr($chars, 1);
	}
	if ( substr($chars, -1) == ',' )
	{
		$chars = substr($chars, 0, -1);
	}
	return $chars;
}

/* this function takes the FAQ array generated as a result
 * of include'ing the lang_faq.php file and turns it into
 * a pair of arrays, $blocks and $quests.
 *    $blocks - just contains numerically indexed block titles
 *    $quests - is in the following format:
 *      $quests[$block_number][$question_number][Q] - is the question
 *      $quests[$block_number][$question_number][A] - is the answer
 */
function faq_to_array($faq)
{
	$blocks = array();
	$quests = array();

	$block_no = -1;
	$quest_no = 0;

	for($i = 0; $i < count($faq); $i++)
	{
		if($faq[$i][0] == '--')
		{
			$block_no++;
			$blocks[$block_no] = $faq[$i][1];
			$quests[$block_no] = array();
			$quest_no = 0;
		}
		else
		{
			$quests[$block_no][$quest_no][Q] = $faq[$i][0];
			$quests[$block_no][$quest_no][A] = $faq[$i][1];
			$quest_no++;
		}
	}

	return array($blocks, $quests);
}
/* END function faq_to_array */

/* this function takes the array generated by faq_to_array and changes
 * it back into lines suitable for dumping to a lang_faq.php file. It
 * returns a numerically-indexed array of said lines.
 */
function array_to_faq($blocks, $quests)
{
	$lines = array();

	for($i = 0; $i < count($blocks); $i++)
	{
		$lines[] = '$faq[] = array("--", "'.str_replace('"', '\"', $blocks[$i]).'");'."\n";

		for($j = 0; $j < count($quests[$i]); $j++)
		{
			if( !empty($quests[$i][$j][Q]) && !empty($quests[$i][$j][A]) )
			{
				$lines[] = '$faq[] = array("'.str_replace('"', '\"', $quests[$i][$j][Q]).'", "'.str_replace('"', '\"', $quests[$i][$j][A]).'");'."\n";
			}
		}

		$lines[] = "\n";
	}

	return $lines;
}
/* END function array_to_faq */

function check_auth($type, $key, $u_access, $is_admin)
{
	$auth_user = 0;

	if( count($u_access) )
	{
		for($j = 0; $j < count($u_access); $j++)
		{
			$result = 0;
			switch($type)
			{
				case AUTH_ACL:
					$result = $u_access[$j][$key];

				case AUTH_MOD:
					$result = $result || $u_access[$j]['auth_mod'];

				case AUTH_ADMIN:
					$result = $result || $is_admin;
					break;
			}

			$auth_user = $auth_user || $result;
		}
	}
	else
	{
		$auth_user = $is_admin;
	}

	return $auth_user;
}

function recalculate_user_posts($old_forum_id, $new_forum_id, $topic_id)
{
	global $db;

	$new_forum_id_count = (no_post_count($new_forum_id)) ? true : false;
	$old_forum_id_count = (no_post_count($old_forum_id)) ? true : false;

	if ( !$new_forum_id_count && $old_forum_id_count && !is_array($topic_id))
	{
		$sql = "SELECT poster_id, COUNT(post_id) AS posts 
			FROM " . POSTS_TABLE . " 
			WHERE topic_id = $topic_id 
			GROUP BY poster_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get poster id information', '', __LINE__, __FILE__, $sql);
		}
		$count_sql = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$count_sql[] = "UPDATE " . USERS_TABLE . " 
				SET user_posts = user_posts - " . $row['posts'] . "
				WHERE user_id = " . $row['poster_id'];
		}
		$db->sql_freeresult($result);

		if ( sizeof($count_sql) )
		{
			for($i = 0; $i < sizeof($count_sql); $i++)
			{
				if ( !$db->sql_query($count_sql[$i]) )
				{
					message_die(GENERAL_ERROR, 'Could not update user post count information', '', __LINE__, __FILE__, $sql);
				}
			}
		}
	}
	else if ( $new_forum_id_count && !$old_forum_id_count && !is_array($topic_id) )
	{
		$sql = "SELECT poster_id, COUNT(post_id) AS posts 
			FROM " . POSTS_TABLE . " 
			WHERE topic_id = $topic_id 
			GROUP BY poster_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get poster id information', '', __LINE__, __FILE__, $sql);
		}
		$count_sql = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$count_sql[] = "UPDATE " . USERS_TABLE . " 
				SET user_posts = user_posts + " . $row['posts'] . "
				WHERE user_id = " . $row['poster_id'];
		}
		$db->sql_freeresult($result);

		if ( sizeof($count_sql) )
		{
			for($i = 0; $i < sizeof($count_sql); $i++)
			{
				if ( !$db->sql_query($count_sql[$i]) )
				{
					message_die(GENERAL_ERROR, 'Could not update user post count information', '', __LINE__, __FILE__, $sql);
				}
			}
		}
	}
	else if ( !$new_forum_id_count && $old_forum_id_count && is_array($topic_id))
	{//array topic_id mean topic_id = post_id

		$posts_ids = (is_array($topic_id)) ? implode(', ', $topic_id) : $topic_id;
		$sql = "SELECT poster_id, COUNT(post_id) AS posts 
			FROM " . POSTS_TABLE . " 
			WHERE post_id IN($posts_ids) 
			GROUP BY poster_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get poster id information', '', __LINE__, __FILE__, $sql);
		}
		$count_sql = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$count_sql[] = "UPDATE " . USERS_TABLE . " 
				SET user_posts = user_posts - " . $row['posts'] . "
				WHERE user_id = " . $row['poster_id'];
		}
		$db->sql_freeresult($result);

		if ( sizeof($count_sql) )
		{
			for($i = 0; $i < sizeof($count_sql); $i++)
			{
				if ( !$db->sql_query($count_sql[$i]) )
				{
					message_die(GENERAL_ERROR, 'Could not update user post count information', '', __LINE__, __FILE__, $sql);
				}
			}
		}
	}
	if ( $new_forum_id_count && !$old_forum_id_count && is_array($topic_id))
	{//array topic_id mean topic_id = post_id

		$posts_ids = (is_array($topic_id)) ? implode(', ', $topic_id) : $topic_id;
		$sql = "SELECT poster_id, COUNT(post_id) AS posts 
			FROM " . POSTS_TABLE . " 
			WHERE post_id IN($posts_ids) 
			GROUP BY poster_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get poster id information', '', __LINE__, __FILE__, $sql);
		}
		$count_sql = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$count_sql[] = "UPDATE " . USERS_TABLE . " 
				SET user_posts = user_posts + " . $row['posts'] . "
				WHERE user_id = " . $row['poster_id'];
		}
		$db->sql_freeresult($result);

		if ( sizeof($count_sql) )
		{
			for($i = 0; $i < sizeof($count_sql); $i++)
			{
				if ( !$db->sql_query($count_sql[$i]) )
				{
					message_die(GENERAL_ERROR, 'Could not update user post count information', '', __LINE__, __FILE__, $sql);
				}
			}
		}
	}
	return;
}

?>