<?php
/***************************************************************************
 *			      function_selects.php
 *			      -------------------
 *   begin		  : Saturday, Feb 13, 2001
 *   copyright		  : (C) 2001 The phpBB Group
 *   email		  : support@phpbb.com
 *
 *   $Id: functions_selects.php,v 1.3 2002/03/18 23:53:12 psotfx Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *
 ***************************************************************************/

//
// Pick a language, any language ...
//
function language_select($default, $select_name = "language", $dirname="language")
{
	global $phpEx;

	$dir = opendir($dirname);

	$lang = array();
	while ( $file = readdir($dir) )
	{
		if (preg_match('#^lang_#i', $file) && !is_file(@phpbb_realpath($phpbb_root_path . $dirname . '/' . $file)) && !is_link(@phpbb_realpath($phpbb_root_path . $dirname . '/' . $file)))
		{
			$filename = trim(str_replace("lang_", "", $file));
			$displayname = preg_replace("/^(.*?)_(.*)$/", "\\1 [ \\2 ]", $filename);
			$displayname = preg_replace("/\[(.*?)_(.*)\]/", "[ \\1 - \\2 ]", $displayname);
			$lang[$displayname] = $filename;
		}
	}

	closedir($dir);

	@asort($lang);
	@reset($lang);

	$lang_select = '<select name="' . $select_name . '">';
	while ( list($displayname, $filename) = @each($lang) )
	{
		$selected = ( strtolower($default) == strtolower($filename) ) ? ' selected="selected"' : '';
		$lang_select .= '<option value="' . $filename . '"' . $selected . '>' . ucwords($displayname) . '</option>';
	}
	$lang_select .= '</select>';

	return $lang_select;
}

//
// Pick a template/theme combo, 
//
function style_select($default_style, $select_name = "style", $dirname = "templates")
{
	global $db;

	$sql = "SELECT themes_id, style_name
		FROM " . THEMES_TABLE . "
		ORDER BY template_name, themes_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't query themes table", "", __LINE__, __FILE__, $sql);
	}

	$quick = ($select_name == 'template' || $select_name == 'fpage_theme') ? ' onchange="forms[\'quickchange\'].submit()" style="font-size:9px;"' : '';

	$style_select = '<select name="' . $select_name . '"' . $quick . '>';
	while ( $row = $db->sql_fetchrow($result) )
	{
		$tcount=0;
		$t_id = $row['themes_id'];
		$selected = ( $row['themes_id'] == $default_style ) ? ' selected="selected"' : '';
		$style_select .= '<option value="' . $row['themes_id'] . '"' . $selected . '>' . $row['style_name'] . '</option>';
	}
	$style_select .= "</select>";
	return $style_select;
}

//
// Pick a timezone
//
function tz_select($default, $select_name = 'timezone')
{
	global $sys_timezone, $lang;

	$default == ( !isset($default) ) ? $sys_timezone : $default;
	$tz_select = '<select name="' . $select_name . '">';

	while( list($offset, $zone) = @each($lang['tz']) )
	{
		$selected = ( $offset == $default ) ? ' selected="selected"' : '';
		$tz_select .= '<option value="' . $offset . '"' . $selected . '>' . $zone . '</option>';
	}
	$tz_select .= '</select>';

	return $tz_select;
}

//
// Pick a (canned) date format
//
function date_format_select($default, $timezone, $select_name = 'dateformat')
{
	global $board_config;

	// Include any valid PHP date format strings here, in your preferred order
	$date_formats = array(
		'D d M, Y',
		'D d M, Y g:i a',
		'D d M, Y H:i',
		'D d M, y',
		'D d M, y g:i a',
		'D d M, y H:i',
		'D M d, Y',
		'D M d, Y g:i a',
		'D M d, Y H:i',
		'D M d, y',
		'D M d, y g:i a',
		'D M d, y H:i',
		'd M Y h:i a',
		'd M Y h:i',
		'd M y h:i',
		'j F Y',
		'j F Y, g:i a',
		'j F Y, H:i',
		'j F y',
		'j F y, g:i a',
		'j F y, H:i',
		'Y-m-d',
		'Y-m-d, g:i a',
		'Y-m-d, H:i',
		'd-m-Y',
		'd-m-Y, g:i ',
		'd-m-Y, H:i',
		'y-m-d',
		'y-m-d, g:i a',
		'y-m-d, H:i',
		'd-m-y',
		'd-m-y, g:i a',
		'd-m-y, H:i'
	);

	$timezone == ( !isset($timezone) ) ? $board_config['board_timezone'] : $timezone;	$now = time() + (3600 * $timezone);
	$df_select = '<select name="' . $select_name . '">';
	for ($i = 0; $i < sizeof($date_formats); $i++)
	{

		$format = $date_formats[$i];
		$display = date($format, $now);
		$df_select .= '<option value="' . $format . '" ' . $check_format . '';
		$df_select .=  (isset($default) && ($default == $format)) ? ' selected' : '';
		$df_select .= '>' . $display . '</option>';
	}
	$df_select .= '</select>';

	return $df_select;
}

function admin_date_format_select($default, $timezone, $select_name = 'default_dateformat')
{
	global $board_config;

	// Include any valid PHP date format strings here, in your preferred order
	$date_formats = array(
		'D d M, Y',
		'D d M, Y g:i a',
		'D d M, Y H:i',
		'D d M, y',
		'D d M, y g:i a',
		'D d M, y H:i',
		'D M d, Y',
		'D M d, Y g:i a',
		'D M d, Y H:i',
		'D M d, y',
		'D M d, y g:i a',
		'D M d, y H:i',
		'd M Y h:i a',
		'd M Y h:i',
		'd M y h:i',
		'j F Y',
		'j F Y, g:i a',
		'j F Y, H:i',
		'j F y',
		'j F y, g:i a',
		'j F y, H:i',
		'Y-m-d',
		'Y-m-d, g:i a',
		'Y-m-d, H:i',
		'd-m-Y',
		'd-m-Y, g:i ',
		'd-m-Y, H:i',
		'y-m-d',
		'y-m-d, g:i a',
		'y-m-d, H:i',
		'd-m-y',
		'd-m-y, g:i a',
		'd-m-y, H:i'
	);

	$timezone == ( !isset($timezone) ) ? $board_config['board_timezone'] : $timezone;
	$now = time() + (3600 * $timezone);

	$df_select = '<select name="' . $select_name . '">';
	for ($i = 0; $i < sizeof($date_formats); $i++)
	{
		$format = $date_formats[$i];
		$display = date($format, $now);
		$df_select .= '<option value="' . $format . '"';
		$df_select .= (isset($default) && ($default == $format)) ? ' selected' : '';
		$df_select .= '>' . $display . '</option>';
	}
	$df_select .= '</select>';

	return $df_select;
}

function color_select($select_name, $check_select, $lang_default)
{
	global $board_config;
	$colors = array(
		'','191970','000080','00008B','2F4F4F','0000CD','0000FF','4169E1','1E90FF','6495ED','00BFFF','6495ED',
		'4682B4','87CEFA','00FFFF','7EFFD4','008B8B','20B2AA','48D1CC','40E0D0','AFEEEE','E0FFFF','B0C4DE',
		'E6E6FA','F0F8FF','F0FFFF','F5FFFA','F0FFF0','9932CC','9400D3','6A5ACD','9370DB','8A2BE2','483D8B',
		'5F9EA0','DCDCDC','C0C0C0','A9A9A9','778899','808080','696969','BDB76B','6B8E23','556B2F','006400',
		'008000','32CD32','9ACD32','00FF00','ADFF2F','FFA07A','FF7F50','DC143C','CD5C5C','DC143C','FF4500',
		'CC0000','F00800','FF0000','FF6347','E9967A','FA8072','DB7093','FFC0CB','FFB6C1','F0E68C','FFFF00',
		'FFD700','DAA520','FF8C00','FFA500','F4A460','D2691E','B22222','8B0000','4B0082','8B008B','CD1585',
		'FF1493','FF69B4','FF00FF','FF00FF','BA55D3','DA70D6','EE82EE','DDA0DD','F5F5DC','FFF8DC','FFFACD',
		'FFFFE0','FDF5E6','FFF0F5','FFE4DC','FFEFD5','FAEBD7','FFEBCD','EEE8AA','FFE4B5','FFDAB9','DEB887',
		'D2B48C','B8860B','CD853F','A0522D','8B4513','BC8F8F','D8BFD8','8FBC8F','008080','2E8B57','3CB371',
		'66CDAA','00FF7F','00FA9A','98FB98','FFFFF0','FFF5EE','FFFAFA','F8F8FF','FFFFFF','F5F5F5','000000'
	);
	$df_select = '<select name="' . $select_name . '">';
	for ($i = 0; $i < sizeof($colors); $i++)
	{
		$color = $colors[$i];
		$color_sel = ( $color == '' ) ? $lang_default : $color_sel = $color;
		$df_select .= '<option style="color:#' . $color . '" value="' . $color . '"';
		$df_select .=  ( $check_select == $color ) ? ' selected' : '';
		$df_select .= '>' . $color_sel . '</option>';
	}
	$df_select .= '</select>';
	return $df_select;
}

function module_jumpbox($jumpbox_name, $list_modules, $lang_modules)
{
	global $db, $board_config, $lang;

	$sql = "SELECT config_value
	FROM " . PORTAL_CONFIG_TABLE . "
	WHERE config_name = '" . $jumpbox_name . "'";
	if(!$result = $db->sql_query($sql))
	{
		message_die(CRITICAL_ERROR, "Could not query jumpbox config information", "", __LINE__, __FILE__, $sql);
	}
	$row_value = $db->sql_fetchrow($result);

	$df_select = '<select name="' . $jumpbox_name . '">';
	for ($i = 0; $i < sizeof($list_modules); $i++)
	{
		$value = $list_modules[$i];
		$name = $lang_modules[$i];
		$df_select .= '<option value="' . $value . '"';
		if ( $row_value['config_value'] == $value )
		{
			$df_select .= ' selected';
		}
		$df_select .= '>' . $name . '</option>';
	}
	$df_select .= '</select>';
	return $df_select;
}

?>