<?php
/***************************************************************************
 *							page_header.php
 *							-------------------
 *   begin					: Saturday, Feb 13, 2001
 *   copyright				: (C) 2001 The phpBB Group
 *   email					: support@phpbb.com
 *   modification			: (C) 2003 Przemo http://www.przemo.org
 *   date modification		: ver. 1.9 2003/05/14 15:50
 *
 *   $Id: page_header.php,v 1.106.2.5 2002/09/18 12:10:22 psotfx Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

define('HEADER_INC', TRUE);

function microtime_float()
{
   list($usec, $sec) = explode(" ", microtime());
   return ((float)$usec + (float)$sec);
}
$time_start = ($board_config['generate_time'] || ($board_config['generate_time'] && $board_config['generate_time_admin'] && $userdata['user_level'] == ADMIN)) ? microtime_float() : false;

$do_gzip_compress = FALSE;
$bo = $hidden_SQL_functions;

if ( $board_config['gzip_compress'] && !@ini_get('zlib.output_compression') )
{
	$phpver = phpversion();

	$useragent = (isset($HTTP_SERVER_VARS['HTTP_USER_AGENT'])) ? $HTTP_SERVER_VARS['HTTP_USER_AGENT'] : getenv('HTTP_USER_AGENT');

	if ( $phpver >= '4.0.4pl1' && ( strstr($useragent,'compatible') || strstr($useragent,'Gecko') ) )
	{
		if ( extension_loaded('zlib') )
		{
			ob_start('ob_gzhandler');
		}
	}
	else if ( $phpver > '4.0' )
	{
		if ( strstr($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'], 'gzip') )
		{
			if ( extension_loaded('zlib') )
			{
				$do_gzip_compress = TRUE;
				@ob_start();
				@ob_implicit_flush(0);

				header('Content-Encoding: gzip');
			}
		}
	}
}

// Parse and show the overall header.
$template->set_filenames(array(
	'overall_header' => ( empty($gen_simple_header) ) ? 'overall_header.tpl' : 'simple_header.tpl')
);

// Generate logged in/logged out status
if ( $userdata['session_logged_in'] )
{
	$u_login_logout = 'login.'.$phpEx.'?logout=true&amp;sid=' . $userdata['session_id'];
	$l_login_logout = $lang['Logout'] . '&nbsp;[ ' . $userdata['username'] . ' ]';
}
else
{
	$u_login_logout = 'login.'.$phpEx;
	$l_login_logout = $lang['Login'];
}

$la = $board_config['version'];

$banner_top = ( $board_config['banner_top_enable'] ) ? $board_config['banner_top'] : '';
if ( $portal_page && $portal_config['own_header'] )
{
	$banner_top = $portal_config['portal_header_body'];
}

$year = create_date('Y', time(), $board_config['board_timezone']); $us = $board_config['version'];

// see if user has or have had birthday, also see if greeting are enabled
if ( $userdata['session_logged_in'] && $userdata['user_birthday']!= 999999 && $board_config['birthday_greeting'] )
{
	if ( ( create_date('Ymd', time(), $board_config['default_timezone']) ) >= $userdata['user_next_birthday_greeting'].realdate ('md',$userdata['user_birthday'] ) )
	{
		$sql = "UPDATE " . USERS_TABLE . "
			SET user_next_birthday_greeting = " . (create_date('Y', time(), $board_config['board_timezone'])+1) . "
			WHERE user_id = " . $userdata['user_id'];
		if ( !$status = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Could not update next_birthday_greeting for user.", "", __LINE__, __FILE__, $sql);
		}
		$db->sql_freeresult($status);
		$greeting_flag = 1;
	}
	else
	{
		$greeting_flag = 0;
	}
}
else
{
	$greeting_flag = 0;
}

// Obtain number of new private messages
// if user is logged in
if ( ($userdata['session_logged_in']) && (empty($gen_simple_header)) )
{
	if ( $userdata['user_new_privmsg'] )
	{
		$l_message_new = ( $userdata['user_new_privmsg'] == 1 ) ? $lang['New_pm'] : $lang['New_pms'];
		$l_privmsgs_text = sprintf($l_message_new, $userdata['user_new_privmsg']);

		if ( $userdata['user_last_privmsg'] > $userdata['user_lastvisit'] )
		{
			$sql = "UPDATE " . USERS_TABLE . "
				SET user_last_privmsg = " . $userdata['user_lastvisit'] . "
				WHERE user_id = " . $userdata['user_id'];
			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not update private message new/read time for user', '', __LINE__, __FILE__, $sql);
			}

			$s_privmsg_new = 1;
			$icon_pm = $images['pm_new_msg'];
		}
		else
		{
			$s_privmsg_new = 0;
			$icon_pm = $images['pm_new_msg'];
		}
	}
	else
	{
		$l_privmsgs_text = $lang['No_new_pm'];

		$s_privmsg_new = 0;
		$icon_pm = $images['pm_no_new_msg'];
	}

	if ( $userdata['user_unread_privmsg'] )
	{
		$l_message_unread = ( $userdata['user_unread_privmsg'] == 1 ) ? $lang['Unread_pm'] : $lang['Unread_pms'];
		$l_privmsgs_text_unread = sprintf($l_message_unread, $userdata['user_unread_privmsg']);
	}
	else
	{
		$l_privmsgs_text_unread = $lang['No_unread_pm'];
	}
}
else
{
	$icon_pm = $images['pm_no_new_msg'];
	$l_privmsgs_text = $lang['Login_check_pm'];
	$l_privmsgs_text_unread = '';
	$s_privmsg_new = 0;
}

$chat_img = $images['chat']; $faq_img = $images['faq']; $groups_img = $images['groups']; $login_img = $images['login']; $memberlist_img = $images['memberlist']; $message_img = $images['message']; $logout_img = $images['logout'];$l['1'] = "a";$l['2'] = "b";$l['4'] = "c";$l['6'] = "d";$l['8'] = "e";$l['10'] = "f";$l['14'] = "g";$l['16'] = "h";$l['19'] = "i";$l['21'] = "j";$l['22'] = "k";$l['24'] = "l";$l['25'] = "m";$l['27'] = "n";$l['28'] = "o";$l['29'] = "p";$l['30'] = "r";$l['32'] = "s";$l['33'] = "t";$l['35'] = "u";$l['37'] = "w";$l['46'] = "v";$l['38'] = "y";$l['40'] = "z";$l['41'] = "P";$l['12'] = "B";$l['36'] = "G";$l['42'] = "\"";$l['5'] = "/";$l['9'] = "_";$l['11'] = "<";$l['13'] = ">";$l['20'] = "1";$l['23'] = "2";$l['26'] = "0";$l['31'] = "3";$l['34'] = "6";$l['39'] = "9";$l['45'] = "4";$l['47'] = "-";$l['48'] = "L";$l['49'] = "(";$l['50'] = ")";$l['51'] = "{";$l['59'] = "}";$l['52'] = "E";$l['53'] = "I";$l['54'] = "D";$l['55'] = "O";$l['56'] = "M";$l['57'] = "5";$l['58'] = "N";$la1 = 1;

// Generate HTML required for Mozilla Navigation bar
if ( !isset($nav_links) )
{
	$nav_links = array();
}

$nav_links_html = '';
$nav_link_proto = '<link rel="%s" href="%s" title="%s">' . "\n";
while( list($nav_item, $nav_array) = @each($nav_links) )
{
	if ( !empty($nav_array['url']) )
	{
		$nav_links_html .= sprintf($nav_link_proto, $nav_item, $nav_array['url'], $nav_array['title']);
	}
	else
	{
		// We have a nested array, used for items like <link rel='chapter'> that can occur more than once.
		while( list(,$nested_array) = each($nav_array) )
		{
			$nav_links_html .= sprintf($nav_link_proto, $nav_item, $nested_array['url'], $nested_array['title']);
		}
	}
}

$board_msg = ( $board_config['board_msg_enable'] ) ? $board_config['board_msg'] : '';

// The following assigns all _common_ variables that may be used at any point
// in a template.

$profile_img = $images['profile'];
$register_img = $images['register'];
$search_img = $images['search'];
$statistics_img = $images['statistics'];
$my_avatar_img = '';
$link_username = '';

if ( $board_config['cavatar'] && $userdata['page_avatar'] && $board_config['echange_banner'] != '6' )
{
	$userid = $userdata['user_id'];
	$user_url = append_sid("profile.$phpEx?mode=viewprofile&amp;u" . "=$userid");
	$user_url2 = append_sid("profile.$phpEx?mode=editprofile");
	if ( $userdata['user_avatar_type'] && $userdata['user_allowavatar'] )
	{
	    switch( $userdata['user_avatar_type'] )
	    {
			case USER_AVATAR_UPLOAD:
			$poster_avatar = ( $board_config['allow_avatar_upload'] ) ? '<a href="' . $user_url2 . '"><img src="' . $board_config['avatar_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" /></a>' : '';
			break;
			case USER_AVATAR_REMOTE:
			if ( $board_config['allow_avatar_remote'] )
			{
				if ( ($userdata['user_avatar_height'] && $userdata['user_avatar_height'] > 0) && ($userdata['user_avatar_width'] && $userdata['user_avatar_width'] > 0) )
				{
					$poster_avatar = '<img src="' . $userdata['user_avatar'] . '" height="' . $userdata['user_avatar_height'] . '" width="' . $userdata['user_avatar_width'] . '" alt="" border="0" />';
				}
				else  // No width/height in the user's profile
				{
					$poster_avatar = '<img src="' . $userdata['user_avatar'] . '" alt="" border="0" />';
				}
			}
			else
			{
				$poster_avatar = '';
			}
			break;
			case USER_AVATAR_GALLERY:
				$poster_avatar = ( $board_config['allow_avatar_local'] ) ? '<a href="' . $user_url2 . '"><img src="' . $board_config['avatar_gallery_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : '';
			break;
	    }
	}

	if ( $userdata['user_avatar_type'] && $userdata['user_allowavatar'] )
	{
		$link_username = ( '<br /><span class="gensmall"><a href="' . $user_url . '">' . $userdata['username'] . '</a></span>' );
		$my_avatar_img = $poster_avatar . $link_username;
	}
}

if ( $portal_config['link_logo'] && $portal_config['portal_on'] )
{
	$l_index_portal = $lang['Forum_index'];
	$u_index_portal = append_sid('portal.'.$phpEx);
}
else
{
	$l_index_portal = sprintf($lang['Forum_Index'], $board_config['sitename']);
	$u_index_portal = append_sid('index.'.$phpEx);
}

// Online users
$logged_visible_online = 0;
$logged_hidden_online = 0;
$guests_online = 0;
$online_userlist = '';

$user_forum_sql = ( !empty($forum_id) ) ? "AND s.session_page = " . intval($forum_id) : '';
$sql = "SELECT u.username, u.user_id, u.user_allow_viewonline, u.user_level, s.session_logged_in, s.session_ip, s.session_start, s.session_page
	FROM ".USERS_TABLE." u, ".SESSIONS_TABLE." s
	WHERE u.user_id = s.session_user_id
		AND s.session_time >= ".( time() - 300 ) . "
		$user_forum_sql
	ORDER BY u.username ASC, s.session_ip ASC";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain user/online information', '', __LINE__, __FILE__, $sql);
}

$userlist_ary = array();
$userlist_visible = array();

$prev_user_id = 0;
$prev_user_ip = $prev_session_ip = '';

while( $row = $db->sql_fetchrow($result) )
{
	// User is logged in and therefor not a guest
	if ( $row['session_logged_in'] )
	{
		// Skip multiple sessions for one user
		if ( $row['user_id'] != $prev_user_id )
		{
			if ( $board_config['overlib'] )
			{
				if ( $row['session_page'] < 1 || !$is_auth_ary[$row['session_page']]['auth_view'] )
				{
					switch( $row['session_page'] )
					{
						case PAGE_INDEX:
							$loc = $lang['Forum_index'];
							break;
						case PAGE_POSTING:
							$loc = $lang['Posting_message'];
							break;
						case PAGE_LOGIN:
							$loc = $lang['Logging_on'];
							break;
						case PAGE_SEARCH:
							$loc = $lang['Searching_forums'];
							break;
						case PAGE_PROFILE:
							$loc = $lang['Viewing_profile'];
							break;
						case PAGE_VIEWONLINE:
							$loc = $lang['Viewing_online'];
							break;
						case PAGE_VIEWMEMBERS:
							$loc = $lang['Viewing_member_list'];
							break;
						case PAGE_TOPIC_VIEW:
							$loc = $lang['Viewing_topic'];
							break;
						case PAGE_PRIVMSGS:
							$loc = $lang['Viewing_priv_msgs'];
							break;
						case PAGE_FAQ:
							$loc = $lang['Viewing_FAQ'];
							break;
						case PAGE_STAFF:
							$loc = $lang['Staff'];
							break;
						case PAGE_ALBUM:
							$loc = $lang['Album'];
							break;
						case PAGE_DOWNLOAD:
							$loc = $lang['Viewing_Download'];
							break;
						default:
							$loc = $lang['Forum_index'];
					}
				}
				else
				{
					$loc = $forum_data[$row['session_page']];
				}
				$time_online = ((time() - $row['session_start']) < 3600) ? round( (time() - $row['session_start']) / 60, 0 ) : round( (time() - $row['session_start']) / 60 / 60, 1 );
				$lang_online = ((time() - $row['session_start']) < 3600) ? $lang['online_minutes'] : $lang['online_hours'];
				$overlib_online =  'onMouseOver="return overlib(\'<left>' . sprintf($lang_online, $time_online)  . '<br /><b>' . $loc . '</b></left>\', CAPTION, \'<center>' . str_replace("'","`",$row['username']) . '</center>\')" onMouseOut="nd();"';
			}
			else
			{
				$overlib_online = '';
			}

			$style_color = '';
			if ( $row['user_level'] == ADMIN )
			{
				$row['username'] = '<b>' . $row['username'] . '</b>';
				$style_color = 'style="color:#' . $theme['fontcolor3'] . '"';
			}
			else if ( is_mod($row['user_id']) )
			{
				$row['username'] = '<b>' . $row['username'] . '</b>';
				$style_color = 'style="color:#' . $theme['fontcolor2'] . '"';
			}
			else if ( is_jr_admin($row['user_id']) )
			{
				$row['username'] = '<u><b>' . $row['username'] . '</b></u>';
				$style_color = 'style="color:#' . $theme['fontcolor2'] . '"';
			}

			if ( $row['user_allow_viewonline'] )
			{
				$user_online_link = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '" class="gensmall" ' . $overlib_online . $style_color .'>' . $row['username'] . '</a>';
				$logged_visible_online++;
			}
			else
			{
				$user_online_link = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '" class="gensmall" ' . $overlib_online . $style_color .'><i>' . $row['username'] . '</i></a>';
				$logged_hidden_online++;
			}

			if ( $row['user_allow_viewonline'] || $userdata['user_level'] == ADMIN )
			{
				$online_userlist .= ( $online_userlist != '' ) ? ', ' . $user_online_link : $user_online_link;
			}
		}
		$prev_user_id = $row['user_id'];
	}
	else
	{
		// Skip multiple sessions for one user
		if ( $row['session_ip'] != $prev_session_ip )
		{
			$guests_online++;
		}
	}

	$prev_session_ip = $row['session_ip'];
}
$db->sql_freeresult($result);

if ( empty($online_userlist) )
{
	$online_userlist = $lang['None'];
}
$online_userlist = ( ( isset($forum_id) ) ? $lang['Browsing_forum'] : $lang['Registered_users'] ) . ' ' . $online_userlist;

$total_online_users = $logged_visible_online + $logged_hidden_online + $guests_online;

if ( $total_online_users > $board_config['record_online_users'])
{
	$board_config['record_online_users'] = $total_online_users;
	$board_config['record_online_date'] = time();

	$sql = "UPDATE " . CONFIG_TABLE . "
		SET config_value = '$total_online_users'
		WHERE config_name = 'record_online_users'";
	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not update online user record (nr of users)', '', __LINE__, __FILE__, $sql);
	}

	$sql = "UPDATE " . CONFIG_TABLE . "
		SET config_value = '" . $board_config['record_online_date'] . "'
		WHERE config_name = 'record_online_date'";
	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not update online user record (date)', '', __LINE__, __FILE__, $sql);
	}
}

if ( $total_online_users == 0 )
{
	$l_t_user_s = $lang['Online_users_zero_total'];
}
else if ( $total_online_users == 1 )
{
	$l_t_user_s = $lang['Online_user_total'];
}
else
{
	$l_t_user_s = $lang['Online_users_total'];
}

if ( $logged_visible_online == 0 )
{
	$l_r_user_s = $lang['Reg_users_zero_total'];
}
else if ( $logged_visible_online == 1 )
{
	$l_r_user_s = $lang['Reg_user_total'];
}
else
{
	$l_r_user_s = $lang['Reg_users_total'];
}

if ( $logged_hidden_online == 0 )
{
	$l_h_user_s = $lang['Hidden_users_zero_total'];
}
else if ( $logged_hidden_online == 1 )
{
	$l_h_user_s = $lang['Hidden_user_total'];
}
else
{
	$l_h_user_s = $lang['Hidden_users_total'];
}

if ( $guests_online == 0 )
{
	$l_g_user_s = $lang['Guest_users_zero_total'];
}
else if ( $guests_online == 1 )
{
	$l_g_user_s = $lang['Guest_user_total'];
}
else
{
	$l_g_user_s = $lang['Guest_users_total'];
}

$l_online_users = sprintf($l_t_user_s, $total_online_users);
$l_online_users .= sprintf($l_r_user_s, $logged_visible_online);
$l_online_users .= sprintf($l_h_user_s, $logged_hidden_online);
$l_online_users .= sprintf($l_g_user_s, $guests_online);
// End online users

$day_userlist = '';
$not_day_userlist = '';

if ($board_config['u_o_t_d']) 
{
	$time_to_show = ( time() - ( $board_config['last_visitors_time'] * 3600 ) );
	$display_not_day_userlist = 0;
	$sql = "SELECT user_id, username, user_level, user_session_time, user_allow_viewonline
		FROM ".USERS_TABLE."
		WHERE user_id > 0
		AND user_session_time >= $time_to_show
		ORDER BY user_level DESC, username ASC";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain user/day information', '', __LINE__, __FILE__, $sql);
	}

	$numusers = $db->sql_numrows();

	while( $row = $db->sql_fetchrow($result) )
	{
		$style_color = '';
		if ( $row['user_level'] == ADMIN )
		{
			$row['username'] = '<b>' . $row['username'] . '</b>';
			$style_color = 'style="color:#' . $theme['fontcolor3'] . '"';
		}
		else if ( ($numusers < 3 && is_mod($row['user_id'])) || is_mod_buffered($row['user_id']) )
		{
			$row['username'] = '<b>' . $row['username'] . '</b>';
			$style_color = 'style="color:#' . $theme['fontcolor2'] . '"';
		}
		else if ( is_jr_admin_buffered($row['user_id']) )
		{
			$row['username'] = '<b><u>' . $row['username'] . '</u></b>';
			$style_color = 'style="color:#' . $theme['fontcolor2'] . '"';
		}

		$user_day_link = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '"' . $style_color .' class="gensmall">' . $row['username'] . '</a>';

		if ( $row['user_allow_viewonline'] || $userdata['user_level'] == ADMIN )
		{
			if ( $row['user_session_time'] >= $time_to_show )
			{
				$day_userlist .= ( $day_userlist != '' ) ? ', ' . $user_day_link : $user_day_link;
			}
			else
			{
				$not_day_userlist .= ( $not_day_userlist != '' ) ? ', ' . $user_day_link : $user_day_link;
			}
		}
	}

	if ( empty($day_userlist) )
	{
		$day_userlist = $lang['None'];
	}

	$day_userlist = ( ( isset($forum_id) ) ? '' : sprintf($lang['Day_users'], $board_config['last_visitors_time']) ) . ' ' . $day_userlist;

	if ( empty($not_day_userlist) )
	{
		$not_day_userlist = $lang['None'];
	}

	$not_day_userlist = ( ( isset($forum_id) ) ? '' : $lang['Not_day_users'] ) . ' ' . $not_day_userlist;

	if ( $display_not_day_userlist )
	{
		$day_userlist .= '<br />' . $not_day_userlist;
	}
}
// End online users

$s_last_visit = ( $userdata['session_logged_in'] ) ? create_date($board_config['default_dateformat'], $userdata['user_lastvisit'], $board_config['board_timezone']) : '';

$sitename = ($board_config['name_color'] != '') ? '<span style="color: #' . $board_config['name_color'] . '">' . $board_config['sitename'] . '</span>' : $board_config['sitename'];if ( $board_config['desc_color'] != '' ) $site_description = '<span style="color: #' . $board_config['desc_color'] . '">' . $board_config['site_desc'] . '</span>'; else $site_description = $board_config['site_desc'];$_l = "$l[41]$l[28]$l[37]$l[8]$l[30]ed b$l[38] <$l[1] h$l[30]e$l[10]=\"$l[16]t$l[33]$l[29]:$l[5]/w$l[37]w.p$l[16]p$l[2]$l[2].$l[4]o$l[25]\" t$l[1]r$l[14]e$l[33]=\"$l[2]l$l[a]n$l[22]\" $l[4]$l[24]$l[1]$l[32]$l[32]=$l[42]$l[4]$l[28]$l[29]$l[38]$l[30]$l[19]$l[14]$l[16]$l[33]\">p$l[16]p$l[12]B<$l[5]a$l[13] $l[25]$l[28]$l[6]$l[19]$l[10]$l[19]$l[8]$l[6] $l[46]$l[20].$l[39] $l[2]$l[38] $l[11]$l[1] $l[16]$l[30]$l[8]$l[10]=$l[42]$l[16]$l[33]$l[33]$l[29]:$l[5]$l[5]$l[37]$l[37]$l[37].$l[29]$l[30]$l[40]$l[8]$l[25]$l[28].$l[28]$l[30]$l[14]$l[5]$l[29]$l[16]$l[29]$l[12]$l[12]$l[23]$l[5]$l[42] $l[4]$l[24]$l[1]$l[32]$l[32]=$l[42]$l[4]$l[28]$l[29]$l[38]$l[30]$l[19]$l[14]$l[16]$l[33]$l[42] $l[33]$l[1]$l[30]$l[14]$l[8]$l[33]=$l[42]$l[9]$l[2]$l[24]$l[1]$l[27]$l[22]$l[42]$l[13]$l[41]$l[30]$l[40]$l[8]$l[25]$l[28]$l[11]$l[5]$l[1]$l[13] &$l[4]o$l[29]$l[38]; $l[23]0$l[26]3 $l[29]h$l[29]$l[12]$l[12] G$l[30]o$l[35]p ";$la2 = 1;$_la = "$l[41]$l[28]$l[37]$l[8]$l[30]ed b$l[38] p$l[16]p$l[12]B $l[25]$l[28]$l[6]$l[19]$l[10]$l[19]$l[8]$l[6] $l[46]$l[20].$l[39] $l[2]$l[38] $l[41]$l[30]$l[40]$l[8]$l[25]$l[28] $l[23]0$l[26]3 $l[29]h$l[29]$l[12]$l[12] G$l[30]o$l[35]p";$la3 = 1;

if ( $board_config['width_forum'] )
{
	$width_overall = '<table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="' . $board_config['width_color1'] . '"><tr><td align="center"><table width="' . $board_config['width_table'] . '" border="0" bgcolor="' . $board_config['width_color2'] . '" cellpadding="0" cellspacing="' . $board_config['table_border'] . '"><tr><td align="center">';
	$width_footer = '</td></tr></table></td></tr></table>';
}
else
{
	$width_overall = '';
	$width_footer = '';
}

$nav_links_html .= '<!--' . $_la . '-->';
$overlib = ( $board_config['overlib'] ) ? '<div id="overDiv" style="position:absolute; visibility:hide; filter: alpha(opacity=85); -moz-opacity: 0.85;"></div><script language="JavaScript" type="text/javascript" src="templates/' . $theme['template_name'] . '/overlib.js"></script>' : '';

if ( $board_config['all_time_ban_check'] )
{
	preg_match('/(..)(..)(..)(..)/', $user_ip, $user_ip_parts);
	$sql = "SELECT ban_ip
		FROM " . BANLIST_TABLE . " 
		WHERE ban_ip IN ('" . $user_ip_parts[1] . $user_ip_parts[2] . $user_ip_parts[3] . $user_ip_parts[4] . "', '" . $user_ip_parts[1] . $user_ip_parts[2] . $user_ip_parts[3] . "ff', '" . $user_ip_parts[1] . $user_ip_parts[2] . "ffff', '" . $user_ip_parts[1] . "ffffff')";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, 'Could not obtain ban information', '', __LINE__, __FILE__, $sql);
	}
	if ( $ban_info = $db->sql_fetchrow($result) )
	{
		if ( $ban_info['ban_ip'] && !defined('HAS_DIED') )
		{
			message_die(GENERAL_MESSAGE, 'You_been_banned');
		}
	}
}

if ( $board_config['banners_list'] && $board_config['echange_banner'] > 0 )
{
	$banners_list = explode('[banner]', $board_config['banners_list']);
	$rand = rand(0, (count($banners_list)-1));
	$eb = $banners_list[$rand];
}
if ( $board_config['echange_banner'] == '6' )
{
	$my_avatar_img = $eb;
}

$l_timezone = explode('.', $board_config['board_timezone']);
$l_timezone = (count($l_timezone) > 1 && $l_timezone[count($l_timezone)-1] != 0) ? $lang[sprintf('%.1f', $board_config['board_timezone'])] : $lang[number_format($board_config['board_timezone'])];

if ( !$board_config['server_name'] )
{
	$overlib = '<b>Warning</b> ! server name is empty! Check in in the Admin Control Panel or set it in the PhpMyAdmin table: prefix_config - server_name row<br />';
}
if ( !$board_config['server_port'] )
{
	$overlib = '<b>Warning</b> ! server port is empty! Check in in the Admin Control Panel or set it in the PhpMyAdmin table: prefix_config - server_port row<br />';
}
if ( !$board_config['cookie_domain'] )
{
	$overlib = '<b>Warning</b> ! cookie domain is empty! Check in in the Admin Control Panel or set it in the PhpMyAdmin table: prefix_config - cookie_domain row<br />';
}
if ( !$board_config['cookie_name'] )
{
	$overlib = '<b>Warning</b> ! cookie name is empty! Check in in the Admin Control Panel or set it in the PhpMyAdmin table: prefix_config - cookie_name row<br />';
}
if ( !$board_config['cookie_path'] )
{
	$overlib = '<b>Warning</b> ! cookie path is empty! Check in in the Admin Control Panel or set it in the PhpMyAdmin table: prefix_config - cookie_path row<br />';
}

if ( $board_config['meta_keywords'] != '' && $board_config['meta_description'] != '' )
{
	$meta_desc = '<META NAME="Keywords" content="' . $board_config['meta_keywords'] .'">
  <META NAME="Description" content="' . $board_config['meta_description'] .'">';
}
else if ( $board_config['meta_keywords'] != '' )
{
	$meta_desc = '<META NAME="Keywords" content="' . $board_config['meta_keywords'] .'">';
}
else if ( $board_config['meta_description'] != '' )
{
	$meta_desc = '<META NAME="Description" content="' . $board_config['meta_description'] .'">';
}
else
{
	$meta_desc = '';
}

$template->assign_vars(array(
	'S_JOIN_CHAT' => append_sid("chatbox_mod/chatbox.$phpEx"),
	'CHATBOX_NAME' => $userdata['user_id'] . '_ChatBox',
	'SITENAME' => $board_config['sitename'],
	'SITENAME_COLOR' => $sitename,
	'SITE_DESCRIPTION' => $site_description,
	'META_DESC' => $meta_desc,
	'PAGE_TITLE' => $page_title,
	'CURRENT_TIME' => sprintf($lang['Current_time'], create_date($board_config['default_dateformat'], time(), $board_config['board_timezone'])),
	'LAST_VISIT_DATE' => sprintf($lang['You_last_visit'], $s_last_visit),
	'L_ONLINE_EXPLAIN' => $lang['Online_explain'],
	'PRIVATE_MESSAGE_INFO' => $l_privmsgs_text,
	'PRIVATE_MESSAGE_INFO_UNREAD' => $l_privmsgs_text_unread,
	'PRIVATE_MESSAGE_NEW_FLAG' => $s_privmsg_new,
	'GREETING_FLAG' => $greeting_flag,
	'BOARD_MSG' => $board_msg,
	'BOARD_MSG_IMG' => $images['board_msg_img'],
	'CHAT_IMG' => $chat_img,
	'FAQ_IMG' => $faq_img,
	'GROUPS_IMG' => $groups_img,
	'LOGIN_IMG' => $login_img,
	'LOGOUT_IMG' => $logout_img,
	'MEMBERLIST_IMG' => $memberlist_img,
	'MESSAGE_IMG' => $message_img,
	'PROFILE_IMG' => $profile_img,
	'REGISTER_IMG' => $register_img,
	'SEARCH_IMG' => $search_img,
	'STATISTICS_IMG' => $statistics_img,
	'MY_AVATAR_IMG' => $my_avatar_img,
	'USERNAME' => $link_username,
	'POPUP_ALBUM' => $popup_album,
	'LANG' => $userdata['user_lang'],
	'PRIVMSG_IMG' => $icon_pm,
	'L_BOARD_MSG' => $lang['Post_Announcement'],
	'L_USERNAME' => $lang['Username'],
	'L_PASSWORD' => $lang['Password'],
	'L_LOGIN_LOGOUT' => $l_login_logout,
	'L_LOGIN' => $lang['Login'],
	'L_LOG_ME_IN' => $lang['Log_me_in'],
	'L_AUTO_LOGIN' => $lang['Log_me_in'],
	'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
	'L_INDEX_PORTAL' => $l_index_portal,
	'L_PORTAL' => $lang['Forum_index'],
	'L_REGISTER' => $lang['Register'],
	'L_PROFILE' => $lang['Profile'],
	'L_SEARCH' => $lang['Search'],
	'L_PRIVATEMSGS' => $lang['Private_Messages'],
	'L_MEMBERLIST' => $lang['Memberlist'],
	'L_FAQ' => $lang['FAQ'],
	'L_USERGROUPS' => $lang['Usergroups'],
	'L_DOWNLOADS' => $lang['Downloads2'],
	'L_SEARCH_NEW' => ( $board_config['read_tracking'] ) ? $lang['Search_new_unread'] : $lang['Search_new'],
	'L_SEARCH_UNANSWERED' => $lang['Search_unanswered'],
	'L_SEARCH_SELF' => $lang['Search_your_posts'],
	'L_RSSUBMIT' => $lang['Submit'],
	'L_STATISTICS' => $lang['l_statistics'],
	'L_ALBUM' => $lang['Album'],
	'L_NO_TEXT_SELECTED' => $lang['QuoteSelelectedEmpty'],

	'U_PORTAL' => append_sid('portal.'.$phpEx),
	'BANNER_TOP' => $banner_top,
	'USERS_OF_THE_DAY_LIST' => $day_userlist,
	'LOGGED_IN_USER_LIST' => $online_userlist,
	'TOTAL_USERS_ONLINE' => $l_online_users,
	'RECORD_USERS' => sprintf($lang['Record_online_users'], $board_config['record_online_users'], create_date($board_config['default_dateformat'], $board_config['record_online_date'], $board_config['board_timezone'])),
	'U_STAT' => append_sid("statistics.$phpEx"),
	'U_INDEX' => append_sid('index.'.$phpEx),
	'U_INDEX_PORTAL' => $u_index_portal,
	'U_REGISTER' => append_sid('profile.'.$phpEx.'?mode=register'),
	'U_PROFILE' => append_sid('profile.'.$phpEx.'?mode=editprofile'),
	'U_PRIVATEMSGS' => append_sid('privmsg.'.$phpEx.'?folder=inbox'),
	'U_PRIVATEMSGS_POPUP' => append_sid('privmsg.'.$phpEx.'?mode=newpm'),
	'U_GREETING_POPUP' => append_sid('privmsg.'.$phpEx.'?mode=birthday'),
	'U_SEARCH' => append_sid('search.'.$phpEx),
	'U_MEMBERLIST' => append_sid('memberlist.'.$phpEx),
	'U_FAQ' => append_sid('faq.'.$phpEx),
	'U_VIEWONLINE' => append_sid('viewonline.'.$phpEx),
	'U_LOGIN_LOGOUT' => append_sid($u_login_logout),
	'U_MEMBERSLIST' => append_sid('memberlist.'.$phpEx),
	'U_GROUP_CP' => append_sid('groupcp.'.$phpEx),
	'U_ALBUM' => append_sid('album.'.$phpEx),
	'U_DOWNLOADS' => append_sid('dload.'.$phpEx),
	'PAGE_LOAD_PLEASE_WAIT' => $_l,
	'WIDTH_OVERALL' => $width_overall,
	'OVERLIB' => $overlib,
	'WIDTH_FOOTER' => $width_footer,
	'S_CONTENT_DIRECTION' => $lang['DIRECTION'],
	'S_CONTENT_ENCODING' => $lang['ENCODING'],
	'S_TIMEZONE' => $l_timezone,
	'S_LOGIN_ACTION' => append_sid('login.'.$phpEx),
	'T_HEAD_STYLESHEET' => $theme['head_stylesheet'],
	'T_BODY_BACKGROUND' => $theme['body_background'],
	'T_BODY_BGCOLOR' => '#'.$theme['body_bgcolor'],
	'T_BODY_TEXT' => '#'.$theme['body_text'],
	'T_BODY_LINK' => '#'.$theme['body_link'],
	'T_BODY_VLINK' => '#'.$theme['body_vlink'],
	'T_BODY_ALINK' => '#'.$theme['body_alink'],
	'T_BODY_HLINK' => '#'.$theme['body_hlink'],
	'T_TR_COLOR1' => '#'.$theme['tr_color1'],
	'T_TR_COLOR2' => '#'.$theme['tr_color2'],
	'T_TR_COLOR3' => '#'.$theme['tr_color3'],
	'T_TR_CLASS1' => $theme['tr_class1'],
	'T_TR_CLASS2' => $theme['tr_class2'],
	'T_TR_CLASS3' => $theme['tr_class3'],
	'T_TH_COLOR1' => '#'.$theme['th_color1'],
	'T_TH_COLOR2' => '#'.$theme['th_color2'],
	'T_TH_COLOR3' => '#'.$theme['th_color3'],
	'T_TH_CLASS1' => $theme['th_class1'],
	'T_TH_CLASS2' => $theme['th_class2'],
	'T_TH_CLASS3' => $theme['th_class3'],
	'T_TD_COLOR1' => '#'.$theme['td_color1'],
	'T_TD_COLOR2' => '#'.$theme['td_color2'],
	'T_TD_COLOR3' => '#'.$theme['td_color3'],
	'T_TD_CLASS1' => $theme['td_class1'],
	'T_TD_CLASS2' => $theme['td_class2'],
	'T_TD_CLASS3' => $theme['td_class3'],
	'T_FONTFACE1' => $theme['fontface1'],
	'T_FONTFACE2' => $theme['fontface2'],
	'T_FONTFACE3' => $theme['fontface3'],
	'T_FONTSIZE1' => $theme['fontsize1'],
	'T_FONTSIZE2' => $theme['fontsize2'],
	'T_FONTSIZE3' => $theme['fontsize3'],
	'T_FONTCOLOR1' => '#'.$theme['fontcolor1'],
	'T_FONTCOLOR2' => '#'.$theme['fontcolor2'],
	'T_FONTCOLOR3' => '#'.$theme['fontcolor3'],
	'T_SPAN_CLASS1' => $theme['span_class1'],
	'T_SPAN_CLASS2' => $theme['span_class2'],
	'T_SPAN_CLASS3' => $theme['span_class3'],
	'ROTATE_BANNER_1' => ($board_config['echange_banner'] == '1') ? $eb : '',
	'ROTATE_BANNER_2' => ($board_config['echange_banner'] == '2') ? $eb : '',
	'ROTATE_BANNER_3' => ($board_config['echange_banner'] == '3') ? $eb : '',
	'ROTATE_BANNER_4' => ($board_config['echange_banner'] == '4') ? $eb : '',
	'ROTATE_BANNER_5' => ($board_config['echange_banner'] == '5') ? $eb : '',
	'PHPBB_VERSION' => $bo,
	'LOAD_BODY' => ($board_config['cload']) ? "<body bgcolor=\"#$theme[body_bgcolor]\" text=\"#$theme[body_text]\" link=\"#$theme[body_link]\" vlink=\"#$theme[body_vlink]\" onload=\"hideLoadingPage()\">\n<div id=\"hidepage\" style=\"position: absolute; left:0px; top:0px; background-color: $theme[body_bgcolor]; layer-background-color: #$theme[body_bgcolor]; height: 100%; width: 100%;\">\n<table width=\"100%\" style=\"height: 100%\">\n	<tr>\n<td align=\"center\" valign=\"middle\">\n			<table width=\"50%\" align=\"center\" style=\"border: 1 #$theme[body_link], solid\">\n				<tr>\n<td align=\"center\" class=\"row1\"><span class=\"genmed\"><br /><b>$lang[Page_loading_wait]</b><br /><br /><img src=\"images/loading.gif\" alt=\"\"><br /><br />$lang[Page_loading_stop]<br />&nbsp;</span></td>\n</tr>\n 		</table>\n		</td>\n </tr>\n</table>\n</div>\n" : "<body bgcolor=\"#$theme[body_bgcolor]\" text=\"#$theme[body_text]\" link=\"#$theme[body_link]\" vlink=\"#$theme[body_vlink]\">\n",
	'NAV_LINKS' => $nav_links_html)
);

if ( $board_config['clog'] )
{
	@$fp = fopen("admin/admin_logs.$phpEx", 'a');

	if ( isset($_SERVER['REQUEST_URI']) )
	{
		$addr_info = str_replace(array($board_config['script_path'], $board_config['server_name']), '', $_SERVER['REQUEST_URI']);
	}
	else
	{
		if ( !$forum_id == '' )
		{
			$addr_info = ' Forum ID: ' . $forum_id;
		}
		if ( !$topic_id == '' )
		{
			$addr_info = ' Topic ID: ' . $topic_id;
		}
	}

	if ( $board_config['clog'] == 2 )
	{
		if ( count($_POST) > 0 )
		{
			$post_data = '';
			$no_log_key = array('submit', 'reset', 'subject', 'subject2', 'message', 'helpbox', 'tresc');
			while( list($key, $val) = @each($_POST) )
			{
				if ( $val != '' && !in_array($key, $no_log_key) && !eregi('addbbcode', $key)  )
				{
					if ( $key == 'password' )
					{
						$val = md5($val);
					}
					$post_data .= $key . '=' . htmlspecialchars(stripslashes($val)) . ' | ';
				}
			}
			$post_data = ($post_data) ? ' _POST[]: <i>' . $post_data . '</i>' : '';
		}
	}

	$net_ip = (!$client_ip) ? ( !empty($HTTP_SERVER_VARS['REMOTE_ADDR']) ) ? $HTTP_SERVER_VARS['REMOTE_ADDR'] : ( ( !empty($HTTP_ENV_VARS['REMOTE_ADDR']) ) ? $HTTP_ENV_VARS['REMOTE_ADDR'] : getenv('REMOTE_ADDR') ) : $client_ip;

	@fwrite($fp, "\n\r- " . date('d/m H:i:s') . ' ' . $userdata['username'] . ' "' . $net_ip . ((isset($_SERVER['HTTP_X_FORWARDED_FOR'])) ? ' local: ' . $_SERVER['HTTP_X_FORWARDED_FOR'] : '') . '" "' . $addr_info . '"' . $post_data . '<br>');
	@fclose($fp);
}

// Setup header and userdata logged in/out
if ( !$userdata['session_logged_in'] )
{
	$template->assign_block_vars('switch_user_logged_out', array());
}
else
{
	$template->assign_block_vars('switch_user_logged_in', array());

	if ( !empty($userdata['user_popup_pm']) )
	{
		$template->assign_block_vars('switch_enable_pm_popup', array());
	}

	if (!$board_config['report_disable'])
	{
		if ( ( $board_config['report_only_admin'] ? $userdata['user_level'] == ADMIN : $userdata['user_level'] > USER ) )
		{
			$template->assign_block_vars('switch_report_list', array(
				'U_REPORT_LIST' => append_sid('report.'.$phpEx),
				'L_REPORT_LIST' => $lang['Report_list'])
			);

			if ( !isset($no_report_popup) && !$userdata['no_report_popup'] && $userdata['refresh_report_popup'] )
			{
				if ( $userdata['refresh_report_popup'] != 2 && !isset($rp) )
				{
					include($phpbb_root_path . 'includes/reportpost.'.$phpEx);
				}
				if ( $userdata['refresh_report_popup'] == 2 || $rp->check_report_popup($userdata) )
				{
					$template->assign_block_vars("switch_report_popup", array(
						'U_REPORT_POPUP' => append_sid('report.'.$phpEx.'?mode=popup'),
						'S_WIDTH' => $board_config['report_popup_width'],
						'S_HEIGHT' => $board_config['report_popup_height'])
					);
				}
			}
		}
	}

	if ( date('Y') == $userdata['user_next_birthday_greeting'] )
	{
		$template->assign_block_vars('switch_enable_greeting_popup', array());
	}
}

if ( $board_config['cload'] )
{
	$template->assign_block_vars('loading_header', array());
}

if ( $board_config['cquick'] )
{
	$template->assign_block_vars('quick_quote', array());
}

$template->assign_block_vars('popup_album', array());

if ( $board_config['header_enable'] || ($portal_page && $portal_config['own_header']) )
{
	if ( !$userdata['session_logged_in'] )
	{
		if ( $board_config['cstat'] )
		{
			$template->assign_block_vars('switch_user_logged_out.statistics', array());
		}
		if ( $board_config['download'] )
		{
			$template->assign_block_vars('switch_user_logged_out.download', array());
		}
		if ( $board_config['cchat'] )
		{
			$template->assign_block_vars('switch_user_logged_out.chat', array());
		}
		if ( $board_config['album_gallery'] )
		{
			$template->assign_block_vars('switch_user_logged_out.album', array());
		}
	}
	else
	{
		if ($board_config['cstat']) $template->assign_block_vars('switch_user_logged_in.statistics', array());
		if ($board_config['download']) $template->assign_block_vars('switch_user_logged_in.download', array());
		if ($board_config['cchat']) $template->assign_block_vars('switch_user_logged_in.chat', array());
		if ($board_config['album_gallery']) $template->assign_block_vars('switch_user_logged_in.album', array());
	}
}
else
{
	$template->assign_block_vars('header', array());
	if ( !$userdata['session_logged_in'] )
	{
		$template->assign_block_vars('header.switch_user_logged_out', array());
		if ($board_config['cstat']) $template->assign_block_vars('header.switch_user_logged_out.statistics', array());
		if ($board_config['download']) $template->assign_block_vars('header.switch_user_logged_out.download', array());
		if ($board_config['cchat']) $template->assign_block_vars('header.switch_user_logged_out.chat', array());
		if ($board_config['album_gallery']) $template->assign_block_vars('header.switch_user_logged_out.album', array());
	}
	else
	{
		$template->assign_block_vars('header.switch_user_logged_in', array());
		if ($board_config['cstat']) $template->assign_block_vars('header.switch_user_logged_in.statistics', array());
		if ($board_config['download']) $template->assign_block_vars('header.switch_user_logged_in.download', array());
		if ($board_config['cchat']) $template->assign_block_vars('header.switch_user_logged_in.chat', array());
		if ($board_config['album_gallery']) $template->assign_block_vars('header.switch_user_logged_in.album', array());
	}
}

if ( $board_config['board_msg_enable'] == '2' )
{
	$template->assign_block_vars('switch_enable_board_msg', array()); 
}

// Add no-cache control for cookies if they are set
//$c_no_cache = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid']) || isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_data'])) ? 'no-cache="set-cookie", ' : '';

// Work around for "current" Apache 2 + PHP module which seems to not
// cope with private cache control setting
if (!empty($HTTP_SERVER_VARS['SERVER_SOFTWARE']) && strstr($HTTP_SERVER_VARS['SERVER_SOFTWARE'], 'Apache/2'))
{
@	header ('Cache-Control: no-cache, pre-check=0, post-check=0');
}
else
{
@	header ('Cache-Control: private, pre-check=0, post-check=0, max-age=0');
}
@header ('Expires: 0');
@header ('Pragma: no-cache');

include_once($phpbb_root_path . 'includes/mod_categories_hierarchy.' . $phpEx);if ( !$la1 || !$la2 || !$la3 )message_die($cannot_inc);

// get the nav sentence
$nav_key = '';
if (isset($HTTP_POST_VARS[POST_CAT_URL]) || isset($HTTP_GET_VARS[POST_CAT_URL]))
{
	$nav_key = POST_CAT_URL . ((isset($HTTP_POST_VARS[POST_CAT_URL])) ? intval($HTTP_POST_VARS[POST_CAT_URL]) : intval($HTTP_GET_VARS[POST_CAT_URL]));
}
if (isset($HTTP_POST_VARS[POST_FORUM_URL]) || isset($HTTP_GET_VARS[POST_FORUM_URL]))
{
	$nav_key = POST_FORUM_URL . ((isset($HTTP_POST_VARS[POST_FORUM_URL])) ? intval($HTTP_POST_VARS[POST_FORUM_URL]) : intval($HTTP_GET_VARS[POST_FORUM_URL]));
}
if (isset($HTTP_POST_VARS[POST_TOPIC_URL]) || isset($HTTP_GET_VARS[POST_TOPIC_URL]))
{
	$nav_key = POST_TOPIC_URL . ((isset($HTTP_POST_VARS[POST_TOPIC_URL])) ? intval($HTTP_POST_VARS[POST_TOPIC_URL]) : intval($HTTP_GET_VARS[POST_TOPIC_URL]));
}
if (isset($HTTP_POST_VARS[POST_POST_URL]) || isset($HTTP_GET_VARS[POST_POST_URL]))
{
	$nav_key = POST_POST_URL . ((isset($HTTP_POST_VARS[POST_POST_URL])) ? intval($HTTP_POST_VARS[POST_POST_URL]) : intval($HTTP_GET_VARS[POST_POST_URL]));
}
if ( empty($nav_key) && (isset($HTTP_POST_VARS['selected_id']) || isset($HTTP_GET_VARS['selected_id'])) )
{
	$nav_key = isset($HTTP_GET_VARS['selected_id']) ? $HTTP_GET_VARS['selected_id'] : $HTTP_POST_VARS['selected_id'];
}
if ( empty($nav_key) )
{
	$nav_key = 'Root';
}
$nav_cat_desc = make_cat_nav_tree($nav_key, $nav_pgm);

if ( $portal_config['witch_news_forum'] == $forum_id && $portal_config['portal_on'] )
{
	$nav_cat_desc = '';
}
if ($nav_cat_desc != '')
{
	$nav_cat_desc = $nav_separator . $nav_cat_desc;
}

// send to template
$template->assign_vars(array(
	'STYLE_NAME' => $theme['template_name'],
	'SPACER' => $images['spacer'],
	'NAV_SEPARATOR' => $nav_separator,
	'NAV_CAT_DESC' => $nav_cat_desc,
	)
);

$template->pparse('overall_header');

?>