<?php
/****************************************************************************** 
* 
*	File: read_history.inc 
*  Author:  Ken Brookman 
*  Created: 10/20/02 
*  Notes:  Made for phpBB 2.0.1 using mySQL v4.0 on Free BSD 
*  Desc:  This will include some of the functions necessary to add smart post 
*			tracking to phpBB. 
* 
*  modification		: (C) 2005 Przemo http://www.przemo.org
*  date modification	: ver. 1.9 2005/04/05 15:50
******************************************************************************/ 

function smart_mark_all_read()
{
	global $db, $userdata;

	if ( $userdata['session_logged_in'] )
	{
		$sql = "CHECK TABLE " . READ_HIST_TABLE;

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error in checking read history table', '', __LINE__, __FILE__, $sql);
		}

		$check = $db->sql_fetchrow();
		if ( $check['Msg_text'] != 'OK' )
		{
			$sql = "REPAIR TABLE " . READ_HIST_TABLE;

			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Error in repair read history table', '', __LINE__, __FILE__, $sql);
			}
		}
		
		$sql = "DELETE FROM " . READ_HIST_TABLE . "
			WHERE user_id = " . $userdata['user_id'];

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error in marking all as read', '', __LINE__, __FILE__, $sql);
		}
	}
}

function smart_submit(&$forum_id, &$topic_id, &$current_time, &$post_id)
{
	global $db, $userdata, $board_config;
	
	$time_to_read = ( time() - ( $board_config['lastvisit_days'] * 86400 ) );

	$sql = "SELECT forum_id, auth_read, auth_view FROM " . FORUMS_TABLE . "
		WHERE forum_id = $forum_id
			AND (auth_read > 1 OR auth_view > 1)";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error in submit checking forum access', '',__LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$sql = "INSERT DELAYED IGNORE INTO " . READ_HIST_TABLE . " (user_id, forum_id, topic_id, post_id, post_time)
			SELECT DISTINCT us.user_id, $forum_id, $topic_id, $post_id, $current_time
			FROM " . USER_GROUP_TABLE . " ug, " . AUTH_ACCESS_TABLE. " aa, " . USERS_TABLE . " us
			WHERE aa.forum_id = $forum_id
				AND us.user_lastvisit > $time_to_read
				AND 
				(
					us.user_active = 1
					AND ug.user_pending = 0
					AND ug.user_id != " . $userdata['user_id'] . "
					AND us.user_id != " . ANONYMOUS . "
					AND aa.group_id = ug.group_id
					AND ug.user_id = us.user_id
					AND (";

		if ( $row['auth_view'] > 0 )
		{
			if ( $row['auth_read'] > 0 )
			{
				$sql .= "((aa.auth_read != 0 AND aa.auth_view != 0) OR aa.auth_mod = 1)";
			}
			else
			{
				$sql .= "(aa.auth_view != 0 OR aa.auth_mod = 1)";
			}
		}
		else
		{
			$sql .= "(aa.auth_read != 0 OR aa.auth_mod = 1)";
		}

		$sql .= ") OR us.user_level = 1 AND us.user_id != " . $userdata['user_id'] . ")";

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error in submit of restricted forum', '',__LINE__, __FILE__, $sql);
		}
	}
	else
	{
		$sql = "INSERT DELAYED INTO " . READ_HIST_TABLE . " (user_id, forum_id, topic_id, post_id, post_time)
			SELECT DISTINCT user_id, $forum_id, $topic_id, $post_id, $current_time
			FROM " . USERS_TABLE . "
			WHERE user_id != " . $userdata['user_id'] . "
				AND user_lastvisit > $time_to_read
				AND user_id != " . ANONYMOUS . "
				AND user_active = 1";
		if ( !$db->sql_query($sql) )
		{
			echo $sql."<br /><br />";
			$err = $db->sql_error();
			echo $err['message']."<br /><br />";
			echo $err['code'];
 
			message_die(GENERAL_ERROR, 'Error in submit of UNrestricted forum', '', __LINE__, __FILE__, $sql);
		}
	}
}

function smart_read_topic(&$topic_id)
{
	global $db, $userdata;

	if ( $userdata['session_logged_in'] )
	{
		$sql = "DELETE FROM " . READ_HIST_TABLE . "
			WHERE user_id = " . $userdata['user_id'] . "
				AND topic_id = $topic_id";

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error in submit of UNrestricted forum', '',__LINE__, __FILE__, $sql);
		}
	}
}

function smart_is_new_topic(&$topic_id)
{
	global $db, $userdata;

	if ( $userdata['session_logged_in'] )
	{
		$sql = "SELECT topic_id FROM " . READ_HIST_TABLE . "
			WHERE topic_id = $topic_id
				AND user_id = " . $userdata['user_id'];

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error in submit checking forum access', '',__LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			return true;
		}
	}

	return false;
}

function smart_get_new_topics(&$topics) // $topics: list od topics id's separated by colons
{
	global $db, $userdata;

	if ( !$userdata['session_logged_in'] || $topics == '' )
	{
		return array();
	}
	$sql = "SELECT DISTINCT topic_id
		FROM " . READ_HIST_TABLE . " 
		WHERE topic_id IN ($topics)
			AND user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error in submit checking forum access', '',__LINE__, __FILE__, $sql);
	}
	$topic_list = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$topic_list[] = $row['topic_id'];
	}
	return $topic_list;
}

function smart_get_new_topic_posts(&$topic_id, $posts) // $posts: list od topics id's separated by colons
{
	global $db, $userdata;

	if ( !$userdata['session_logged_in'] )
	{
		return array();
	}
	$sql = "SELECT topic_id, post_id FROM " . READ_HIST_TABLE . "
		WHERE topic_id = $topic_id
			AND user_id = " . $userdata['user_id'] . "
			AND post_id IN ($posts)";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error in submit checking forum access', '', __LINE__, __FILE__, $sql);
	}
	$post_list = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$post_list[] = $row['post_id'];
	}
	return $post_list;
}

function smart_is_new_topic_post(&$topic_id, &$post_id)
{
	global $db, $userdata;

	if ($userdata['session_logged_in'])
	{
		$sql = "SELECT topic_id, post_id FROM " . READ_HIST_TABLE . "
			WHERE topic_id = $topic_id
				AND user_id = " . $userdata['user_id'] . "
				AND post_id = $post_id";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error in submit checking forum access', '',__LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			if ( $row['post_id'] == $post_id )
			{
				return true;
			}
			else
			{
				return false;
			}
		}
	}
}

function smart_is_new_forum(&$forum_id)
{
	global $board_config, $db, $userdata;

	if ( $userdata['session_logged_in'] )
	{
		$sql_ignore_topics = '';
		if ( $board_config['ignore_topics'] )
		{
			$ignore_topics = $userdata['ignore_topics'];
			$sql_ignore_topics = ( $ignore_topics ) ? 'AND topic_id NOT IN (' . $ignore_topics . ')' : '';
		}

		$sql = "SELECT forum_id FROM " . READ_HIST_TABLE . "
			WHERE forum_id = $forum_id
				$sql_ignore_topics
				AND user_id = " . $userdata['user_id'];

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error in submit checking forum access', '',__LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			return true;
		}
	}

	return false;
}

function smart_mark_forum_read(&$forum_id)
{
	global $db, $userdata;

	if ( $userdata['session_logged_in'] )
	{
		$sql = "CHECK TABLE " . READ_HIST_TABLE;

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error in checking read history table', '', __LINE__, __FILE__, $sql);
		}

		$check = $db->sql_fetchrow();
		if ( $check['Msg_text'] != 'OK' )
		{
			$sql = "REPAIR TABLE " . READ_HIST_TABLE;

			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Error in repair read history table', '', __LINE__, __FILE__, $sql);
			}
		}

		$sql = "DELETE FROM " . READ_HIST_TABLE . "
			WHERE user_id = " . $userdata['user_id'] . "
				AND forum_id = $forum_id";

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error in marking all as read', '',__LINE__, __FILE__, $sql);
		}
	}
}

?>