<?php
/***************************************************************************
 *							index.php
 *							-------------------
 *	begin					: Saturday, Feb 13, 2001
 *	copyright			: (C) 2001 The phpBB Group
 *	email					: support@phpbb.com
 *
 *	modification		: (C) 2005 Przemo http://www.przemo.org
 *	date modification	: ver. 1.9 2005/04/03 16:30
 *
 ***************************************************************************/

/***************************************************************************
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx); 

if ( $board_config['check_address'] && $HTTP_HOST != $board_config['server_name'] && isset($HTTP_HOST) && $board_config['server_name'] && $board_config['script_path'] && !isset($HTTP_GET_VARS['redir']) )
{
	$server_protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
	$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
	$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
	$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
	$script_name = ($script_name == '') ? $script_name : '/' . $script_name;

	$check_path_setup = @fopen($server_protocol . $server_name . $server_port . $script_name . '/extension.inc', 'r');
	if ( $check_path_setup )
	{
		@fclose($check_path_setup);
		$check_path_ok = true;
	}

	if ( $check_path_ok )
	{
		if ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) )
		{
			header('Refresh: 0; URL=' . $server_protocol . $server_name . $server_port . $script_name. '/index.'.$phpEx . '?redir=1');
			echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="0; url=' . $server_protocol . $server_name . $server_port . $script_name. '/index.'.$phpEx . '?redir=1"><title>Redirect</title></head><body><div align="center">If your browser does not support meta redirection please click <a href="' . $server_protocol . $server_name . $server_port . $script_name. '/index.'.$phpEx . '?redir=1">HERE</a> to be redirected</div></body></html>';
			exit;
		}

		// Behave as per HTTP/1.1 spec for others
		header('Location: ' . $server_protocol . $server_name . $server_port . $script_name. '/index.'.$phpEx . '?redir=1');
		exit;
	}
}

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

if ( $board_config['read_tracking'] )
{
	include($phpbb_root_path . 'includes/read_history.'.$phpEx);
}

if ( $board_config['login_require'] && !$userdata['session_logged_in'] )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

if ( $board_config['ccount'] )
{
	$visit_counter = $board_config['visitors'];

	if ( !$HTTP_COOKIE_VARS[COUNTER_NAME] )
	{
		@setcookie(COUNTER_NAME, '1', (time() + 3600), $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);

		$sql = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '" . ($visit_counter + 1) . "'
			WHERE config_name = 'visitors'";
		$result = $db->sql_query($sql);
	}
}

if ( $userdata['session_logged_in'] && $board_config['redirect_after_registering'] )
{
	if ((time() - $userdata['user_lastvisit']) < $board_config['r_a_r_time'] )
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['redirect_info'], '<a href="' . $board_config['redirect_address'] . '">', '</a>', '<meta http-equiv="refresh" content="4;url=' . $board_config['redirect_address'] . '">'));
	}
}

//Count unread posts
$sql_ignore_topics = '';
if ( $userdata['session_logged_in'] && $board_config['ignore_topics'] && $board_config['read_tracking'] )
{
	$ignore_topics = $userdata['ignore_topics'];
	if ( $ignore_topics )
	{
		$sql = "DELETE FROM ". READ_HIST_TABLE ."
			WHERE user_id = " . $userdata['user_id'] . "
				AND topic_id IN ($ignore_topics)";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not delete ignored topics from read history table', '', __LINE__, __FILE__, $sql);
		}
	}
	$sql_ignore_topics = ( $ignore_topics ) ? 'AND topic_id NOT IN (' . $ignore_topics . ')' : '';
}

$l_searchnew = '';
if ( $userdata['session_logged_in'] )
{
	if ( $board_config['read_tracking'] )
	{
		$l_searchnew = $lang['Search_new_unread'];
		$sql = "SELECT COUNT(user_id) AS total
			FROM ". READ_HIST_TABLE ."
			WHERE user_id = " . $userdata['user_id'] . "
			$sql_ignore_topics";

		$result = $db->sql_query($sql);
		if ( $result )
		{
			$row = $db->sql_fetchrow($result);
			$l_searchnew = ($row['total']) ? $l_searchnew . '&nbsp;[' . $row['total'] . ']' : '';
		}

		$sql = "SELECT COUNT(post_id) as total
			FROM " . POSTS_TABLE . "
			WHERE post_time >= " . $userdata['user_lastvisit'] . "
			$sql_ignore_topics";
		if ( $result = $db->sql_query($sql))
		{
			$row = $db->sql_fetchrow($result);
			if ( $row['total'] )
			{
				$nbsp_s = ($l_searchnew != '') ? '&nbsp/&nbsp' : '';
				$search_lastvisit = '<span class="gensmall">' . $nbsp_s . '<a href="' . append_sid('search.'.$phpEx.'?search_id=lastvisit') . '" class="gensmall">' . $lang['Search_new'] . '&nbsp;[' . $row['total'] . ']</a></span>';
			}
			else
			{
				$search_lastvisit = '';
			}
		}
	}
	else
	{
		$l_searchnew = $lang['Search_new'];
		$sql = "SELECT COUNT(post_id) as total
			FROM " . POSTS_TABLE . "
			WHERE post_time >= " . $userdata['user_lastvisit'] . "
			$sql_ignore_topics";
		if ( $result = $db->sql_query($sql))
		{
			$row = $db->sql_fetchrow($result);
			$l_searchnew = ($row['total']) ? $l_searchnew . '&nbsp;[' . $row['total'] . ']' : '';
		}
	}
}
//end count unread posts

$viewcat = ( !empty($HTTP_GET_VARS[POST_CAT_URL]) ) ? intval($HTTP_GET_VARS[POST_CAT_URL]) : -1;
if ( $viewcat <= 0 )
{
	$viewcat = -1;
}
$viewcatkey = ($viewcat < 0) ? 'Root' : POST_CAT_URL . $viewcat;

if ( isset($HTTP_GET_VARS['mark']) || isset($HTTP_POST_VARS['mark']) )
{
	$mark_read = ( isset($HTTP_POST_VARS['mark']) ) ? $HTTP_POST_VARS['mark'] : $HTTP_GET_VARS['mark'];
}
else
{
	$mark_read = '';
}

$fpage_style = '';
if ( $board_config['cstyles'] )
{
	$fpage_style = $userdata['user_style'];
	if ( isset($HTTP_POST_VARS['fpage_theme']) )
	{
		$fpage_theme = intval($HTTP_POST_VARS['fpage_theme']);
		$fp_sql = "UPDATE " . USERS_TABLE . "
			SET user_style = '$fpage_theme'
			WHERE user_id = '" . $userdata['user_id'] . "'";
		if ( !($fp_result = $db->sql_query($fp_sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not update users table ' . $user_id . $fpage_theme, '', __LINE__, __FILE__, $sql);
		}
		else
		{
			redirect(append_sid("login.$phpEx?redirect=index.$phpEx", true));
		}
	}
}

// Handle marking posts
if ( $mark_read == 'forums' )
{
	if ( $viewcat < 0 )
	{
		if ( $userdata['session_logged_in'] )
		{
			if ( $board_config['read_tracking'] )
			{
				smart_mark_all_read();
			}
			else
			{
				setcookie($board_config['cookie_name'] . '_f_all', time(), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
			}
		}

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' .append_sid("index.$phpEx") . '">')
		);
	}
	else
	{
		if ( $userdata['session_logged_in'] )
		{
			// get the list of object authorized
			$keys = array();
			$keys = get_auth_keys($viewcatkey);

			// mark each forums
			for ($i=0; $i < count($keys['id']); $i++) if ($tree['type'][ $keys['idx'][$i] ] == POST_FORUM_URL)
			{
				$forum_id = $tree['id'][ $keys['idx'][$i] ];
				$sql = "SELECT MAX(post_time) AS last_post FROM " . POSTS_TABLE . "
					WHERE forum_id = $forum_id";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
				}
				if ( $row = $db->sql_fetchrow($result) )
				{
					if ( ( count($tracking_forums) + count($tracking_topics) ) >= 150 && empty($tracking_forums[$forum_id]) )
					{
						asort($tracking_forums);
						unset($tracking_forums[key($tracking_forums)]);
					}

					if ( $row['last_post'] > $userdata['user_lastvisit'] )
					{
						$tracking_forums[$forum_id] = time();
						setcookie($board_config['cookie_name'] . '_f', serialize($tracking_forums), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
					}
				}
			}
		}

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url='	.append_sid("index.$phpEx?" . POST_CAT_URL . "=$viewcat") . '">')
		);
	}

	$message = $lang['Forums_marked_read'] . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a> ');
	message_die(GENERAL_MESSAGE, $message);
}

// If you don't use these stats on your index you may want to consider removing them
include_once($phpbb_root_path . 'includes/mod_categories_hierarchy.' . $phpEx);
if (($board_config['display_viewonline'] == 2) || (($viewcat < 0) && ($board_config['display_viewonline'] == 1)) )
{
	$total_posts = get_db_stat('postcount');
	$total_users = get_db_stat('usercount');
	$newest_userdata = get_db_stat('newestuser');
	$newest_user = $newest_userdata['username'];
	$newest_uid = $newest_userdata['user_id'];
	$topiccount = get_db_stat('topiccount');

	if ( $total_posts == 0 )
	{
		$l_total_post_s = $lang['Posted_articles_zero_total'];
	}
	else if ( $total_posts == 1 )
	{
		$l_total_post_s = $lang['Posted_article_total'];
	}
	else
	{
		$l_total_post_s = $lang['Posted_articles_total'];
	}

	if ( $total_users == 0 )
	{
		$l_total_user_s = $lang['Registered_users_zero_total'];
	}
	else if ( $total_users == 1 )
	{
		$l_total_user_s = $lang['Registered_user_total'];
	}
	else
	{
		$l_total_user_s = $lang['Registered_users_total'];
	}
}

$birthday_today_list = '';
$birthday_week_list = '';
if ( $board_config['cbirth'] )
{
	$current_year = create_date('Y', time(), $board_config['board_timezone']);

	$bmsg = $HTTP_POST_VARS['bmsg'];
	$send_mode = ( isset($HTTP_GET_VARS['send_mode']) ) ? $HTTP_GET_VARS['send_mode'] : $HTTP_POST_VARS['send_mode'];
	$mode = ( isset($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : $HTTP_POST_VARS['mode'];
	$user_age = ( isset($HTTP_GET_VARS['user_age']) ) ? $HTTP_GET_VARS['user_age'] : $HTTP_POST_VARS['user_age'];
	$user = ( isset($HTTP_GET_VARS['user']) ) ? intval($HTTP_GET_VARS['user']) : intval($HTTP_POST_VARS['user']);

	if ( $mode == 'congratulations' && $user )
	{
		if ( $userdata['session_logged_in'] )
		{
			$sql = "SELECT user_email
				FROM " . USERS_TABLE . "
				WHERE user_id = " . $userdata['user_id'];
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_MESSAGE, 'User email or user not exist');
			}
			$sender_row = $db->sql_fetchrow($result);
			$sender_email = $sender_row['user_email'];

			$sql = "SELECT username, user_lang, user_email
				FROM " . USERS_TABLE . "
				WHERE user_id = $user";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_MESSAGE, 'User_not_exist');
			}

			$user_row = $db->sql_fetchrow($result);
			
			include($phpbb_root_path . 'includes/emailer.'.$phpEx);
			$emailer = new emailer($board_config['smtp_delivery']);

			$emailer->from($sender_email);
			$emailer->replyto($sender_email);

			if ( $send_mode == 'custom_sending' )
			{
				$emailer->use_template('birthday_congratulations_custom', $user_row['user_lang']);
			}
			else
			{
				$emailer->use_template('birthday_congratulations', $user_row['user_lang']);
			}
			$emailer->email_address($user_row['user_email']);
			$emailer->set_subject(sprintf($lang['Birthday_subject'], $user_age));

			$emailer->assign_vars(array(
				'USER_AGE' => $user_age,
				'POSTER_USERNAME' => $userdata['username'],
				'MESSAGE' => $bmsg,
				'SITE_URL' => $server_protocol . $server_name . $server_port . $script_name,
				'SITENAME' => $board_config['sitename'],
				'EMAIL_SIG' => (!empty($board_config['board_email_sig'])) ? str_replace('<br />', "\n", "-- \n" . $board_config['board_email_sig']) : '')
			);

			if ( !$send_mode )
			{
				$fp_message = '<b>' . $lang['choose_congratulations_format'] . '</b><br /><br /><a href="' . append_sid("index.$phpEx") . '?mode=congratulations&amp;send_mode=sending&amp;user=' . $user . '&amp;user_age=' . $user_age . '">' . $lang['congratulations_format_standart'] . '</a><br /><span class="gensmall">' . $lang['congratulations_format_standart_e'] . '</span><br /><br /><a href="' . append_sid("index.$phpEx") . '?mode=congratulations&amp;send_mode=custom&amp;user=' . $user . '&amp;user_age=' . $user_age . '">' . $lang['congratulations_format_custom'] . '</a><br /><span class="gensmall">' . $lang['congratulations_format_custom_e'] . '</span>';
				message_die(GENERAL_MESSAGE, $fp_message);
			}

			if ( $send_mode == 'custom' )
			{
				$fp_message = '<form action="' . append_sid("index.$phpEx") . '" method="post">' . $lang['gg_mes'] . '<br /><textarea name="bmsg" rows="9" cols="90" value="" class="post"></textarea><br /><input type="hidden" name="mode" value="congratulations" /><input type="hidden" name="send_mode" value="custom_sending" /><input type="hidden" name="user" value="' . $user . '" /><input type="hidden" name="user_age" value="' . $user_age . '" /><br /><input type="submit" name="send_custom_congratulations" class="mainoption" value="' . $lang['Submit'] . '" /></form>';
				message_die(GENERAL_MESSAGE, $fp_message);
			}

			if ( $send_mode == 'sending' || $send_mode == 'custom_sending' )
			{

				if ( $send_mode == 'custom_sending' && $bmsg == '' )
				{
					$fp_message = $lang['Empty_message'] . '<br /><br />' . sprintf($lang['Click_return_custom_sending'], '<a href="' . append_sid("index.$phpEx?mode=congratulations&amp;send_mode=custom&amp;user=$user&amp;user_age=$user_age") . '">', '</a>');
					message_die(GENERAL_MESSAGE, $fp_message);
				}

				$sql = "INSERT INTO " . $table_prefix . "birthday (user_id, send_user_id, send_year)
					VALUES ('" . $userdata['user_id'] . "', '$user', '$current_year')";
				if ( !$result = $db->sql_query($sql) )
				{
					$fp_message = $lang['congratulations_send_no'] . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
					message_die(GENERAL_MESSAGE, $fp_message);
				}
				else
				{
					$emailer->send();
					$emailer->reset();
					$fp_message = $lang['congratulations_send'] . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
					message_die(GENERAL_MESSAGE, $fp_message);
				}
			}
		}
		else
		{
			redirect(append_sid("login.$phpEx?redirect=index.$phpEx", true));
		}
	}

	$sql = "SELECT user_id, username, user_email, user_lang, user_birthday, user_level FROM " . USERS_TABLE. "
		WHERE user_birthday <> 999999
		ORDER BY username";
	if ($result = $db->sql_query($sql))
	{
		$birthdayrow = $db->sql_fetchrowset($result);
		if ( !empty($birthdayrow) && $board_config['birthday_check_day'] )
		{
			$birth_year = create_date('Y', time(), $board_config['board_timezone']);
			$date_today = create_date('Ymd', time(), $board_config['board_timezone']);
			$date_forward = create_date('Ymd', time() + ($board_config['birthday_check_day'] * 86400), $board_config['board_timezone']);
			for($i = 0; $i < count($birthdayrow); $i++)
			{
				$user_birthday = realdate('md', $birthdayrow[$i]['user_birthday']);
				$user_birthday2 = (($birth_year . $user_birthday < $date_today) ? $birth_year + 1 : $birth_year) . $user_birthday;
				if ( $user_birthday2 == $date_today )
				{
					//user have birthday today
					$user_age = $birth_year - realdate ('Y', $birthdayrow[$i]['user_birthday']);
					$style_color = ($birthdayrow[$i]['user_level'] == ADMIN ) ? 'style="color:#' . $theme['fontcolor3'] . '"' : ((is_mod($birthdayrow[$i]['user_id'])) ? 'style="color:#' . $theme['fontcolor2'] . '"' : '');

					$sql = "SELECT user_id FROM " . $table_prefix . "birthday
						WHERE user_id = " . $userdata['user_id'] . "
						AND send_user_id = " . $birthdayrow[$i]['user_id'] . "
						AND send_year = " . $current_year;
					$result = $db->sql_query($sql);
					$checkrow = $db->sql_fetchrowset($result);

					$congratulations_link = (!empty($checkrow) || $birthdayrow[$i]['user_id'] == $userdata['user_id']) ? '' : ' <a href="' . append_sid("index.$phpEx?mode=congratulations&amp;user=" . $birthdayrow[$i]['user_id'] . "&amp;user_age=" . $user_age . "") . '"' . $style_color . ' class="gensmall">(' . $lang['send_congratulations'] . ')</b></a>';
					$birthday_today_list .= ' &nbsp;<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow[$i]['user_id']) . '" class="mainmenu"' . $style_color .'><b>' . $birthdayrow[$i]['username'] . '</a></b> ('.$user_age.')' . $congratulations_link;
				}
				else if ( $user_birthday2 > $date_today && $user_birthday2 <= $date_forward )
				{
					// user are having birthday within the next days
					$user_age = ($birth_year . $user_birthday < $date_today) ? $birth_year - realdate ('Y', $birthdayrow[$i]['user_birthday']) +1 : $birth_year - realdate('Y', $birthdayrow[$i]['user_birthday']);
					$style_color = ($birthdayrow[$i]['user_level'] == ADMIN ) ? 'style="color:#' . $theme['fontcolor3'] . '"' : ((is_mod($birthdayrow[$i]['user_id'])) ? 'style="color:#' . $theme['fontcolor2'] . '"' : '');
					$birthday_week_list .= ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow[$i]['user_id']) . '" class="gensmall"' . $style_color .'><b>' . $birthdayrow[$i]['username'] . '</a></b>('.$user_age.')';
				}
			}
		}
	}
	$template->assign_vars(array(
		'L_WHOSBIRTHDAY_WEEK' => ($board_config['birthday_check_day'] > 1) ? sprintf((($birthday_week_list) ? $lang ['Birthday_week'] . $birthday_week_list : $lang['Nobirthday_week']), $board_config['birthday_check_day']) : '',
		'BIRTH' => $birth,
		'L_WHOSBIRTHDAY_TODAY' => ($board_config['birthday_check_day']) ? ($birthday_today_list) ? $lang['Birthday_today'] . $birthday_today_list : $lang['Nobirthday_today'] : '')
	);
}
$db->sql_freeresult($result);

// Start output of page
$page_title = $lang['Forum_index'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'index_body.tpl')
);

$sesid = $userdata['session_id'];

if ( $board_config['cstyles'] )
{
	$style_box0 ='<td align="right"><span class="gensmall">';
	$style_box = $lang['Change_style'] . ':&nbsp;';
	$style_box2 = '</span></td>';
	$style_box3 = $lang['Change_style'] . ':&nbsp;';
	$style_box4 = '</span></td>';
}
else
{
	$style_box0 = '';
	$style_box = '';
	$style_box2 = '';
	$style_box3 = '';
	$style_box4 = '';
}

if ( $board_config['validate'] && @extension_loaded('zlib') && !$userdata['session_logged_in'] )
{
	$key = '';
	$max_length_reg_key = 4;
	$chars = array('1','2','3','4','5','6','7','8','9');

	$count = count($chars) - 1;
	srand((double)microtime()*1000000);

	for($i = 0; $i < $max_length_reg_key; $i++)
	{
		$key .= $chars[rand(0, $count)];
	}

	$sql = "DELETE FROM " . ANTI_ROBOT_TABLE . "
		WHERE timestamp < '" . (time() - 3600) . "'
		OR session_id = '" . $userdata['session_id'] . "'";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain registration information', '', __LINE__, __FILE__, $sql);
	}

	$sql = "INSERT INTO ". ANTI_ROBOT_TABLE . "
		VALUES ('" . $userdata['session_id'] . "', '" . $key . "', '" . time() . "')";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not check registration information', '', __LINE__, __FILE__, $sql);
	}

	$validate1 = '<img src="' . append_sid("includes/confirm_register.$phpEx") . '" width="95" height="20" border="0">&nbsp;';
	$validate2 = '<input type="text" class="post" onFocus="Active(this); this.value=\'\'" onBlur="NotActive(this)" name="reg_key" maxlength="4" size="4" value="' . $lang['Code'] . '" />&nbsp;&nbsp;&nbsp&nbsp;';
}
else
{
	$validate1 = '';
	$validate2 = '';
}

$gender_box = '';
$regist_form = '';
$custom_reg_b = '';
$custom_reg = '';

if ( $board_config['gender'] && $board_config['require_gender'] )
{
	$gender_box = '<span class="gensmall">&nbsp;' . $lang['Gender'] . ': ' . $lang['Female'] . '<input type="radio" name="gender" value="1" /> ' . $lang['Male'] . '<input type="radio" name="gender" value="1" /></span>';
}

if ( $board_config['cregist'] )
{
	$custom_field_box = '';
	$custom_fields_exists = (custom_fields('quick_regist', '')) ? true : false;

	if ( $custom_fields_exists )
	{
		$custom_fields = custom_fields('', 'quick_regist');
		for($i = 0; $i < count($custom_fields[0]); $i++)
		{
			$split_field = 'user_field_' . $custom_fields[0][$i];
			$desc = (isset($lang[$custom_fields[1][$i]])) ? $lang[$custom_fields[1][$i]] : $custom_fields[1][$i];
			$desc = str_replace(array('-#', '<br>'), array('',''), $desc);

			if ( $custom_fields[3][$i] )
			{
				$options = explode(',', $custom_fields[3][$i]);
				if ( count($options) > 0 )
				{
					if ( eregi('.gif', $options[count($options) -1 ]) || eregi('.jpg', $options[count($options) -1 ]))
					{
						$jumpbox = '<script language="javascript" type="text/javascript">
						<!--
							function update_rank(newimage){document.' . $split_field . '.src = \'' . $images['images'] . '/custom_fields/\'+newimage;}
						//-->
						</script>';
						$jumpbox .= '<select name="' . $split_field . '" onchange="update_rank(this.options[selectedIndex].value);"><option value="no_image.gif">' . $lang['None'] . '</option>';
						for ($j = 0; $j+1 <= count($options); $j++) 
						{
							$field_name = str_replace(array('_', '.gif', '.jpg'), array(' ', '', ''), $options[$j]);
							$cf_selected = ($options[$j] == $$split_field) ? 'selected="selected"' : '';
							$jumpbox .= '<option value="' . $options[$j] . '" ' . $cf_selected . '>' . $field_name . '</option>';
						}
						$jumpbox .= '</select>&nbsp;<img name="' . $split_field . '" src="' . $images['images'] . '/custom_fields/no_image.gif" border="0" alt="" align="top" />';
					}
					else
					{
						$jumpbox = '<select name="' . $split_field . '"><option value="" ' . $cf_selected . '>' . $lang['None'] . '</option>';
						for ($j = 0; $j+1 <= count($options); $j++) 
						{
							$cf_selected = ($options[$j] == $$split_field) ? 'selected="selected"' : '';
							$jumpbox .= '<option value="' . $options[$j] . '" ' . $cf_selected . '>' . $options[$j] . '</option>';
						}
						$jumpbox .= '</select>';
					}
					$custom_field_box .= $desc . ': ' . $jumpbox . '&nbsp;&nbsp;';
				}
			}
			else
			{
				$field_size = ($custom_fields[2][$i] < 20) ? ($custom_fields[2][$i] + 1) : '20';
				$custom_field_box .= $desc . ': <input type="text" name="' . $split_field . '" class="post" maxlength="' . $custom_fields[2][$i] . '" size="' . $field_size . '" onFocus="Active(this)" onBlur="NotActive(this)" />&nbsp;&nbsp;';
			}
		}
	}

	$regist_form = '
				<form method="post" action="profile.'.$phpEx.'">
				<table width="100%" cellpadding="0" cellspacing="1" border="0" class="forumline">
					<tr>
						<td class="catHead" colspan="7" height="28"><span class="cattitle">&nbsp;'.$lang['rname'].'</span></td>
					</tr>
				</table>

				<table width="100%" cellpadding="3" cellspacing="0" border="0" class="forumline">
					<tr>
						<td class="row1" align="left" valign="middle"><span class="gensmall">'.$lang['Username'].':</span></td>
						<td class="row1" align="left" valign="middle"><input type="text" class="post" onFocus="Active(this)" onBlur="NotActive(this)" style="width:120px" name="username" size="25" maxlength="20" value="" /></td>
						<td class="row1">&nbsp;</td>
						<td class="row1" align="left" valign="middle"><span class="gensmall">'.$lang['Password'].':</span></td>
						<td class="row1" align="left" valign="middle"><input type="password" class="post" onFocus="Active(this)" onBlur="NotActive(this)" style="width:120px" name="new_password" size="25" maxlength="100" value="" /></td>
						<td nowrap class="row1" align="left" valign="middle">' . $gender_box . ' '.$validate1.''.$validate2.'</td>
						<td class="row1" width="100%"></td>
					</tr>
					<tr>
						<td class="row1" align="left" valign="middle"><span class="gensmall">'.$lang['Confirm_password'].':</span></td>
						<td class="row1" align="left" valign="middle"><input type="password" class="post" onFocus="Active(this)" onBlur="NotActive(this)" style="width:120px" name="password_confirm" size="25" maxlength="100" value="" /></td>
						<td class="row1">&nbsp;</td>
						<td class="row1" align="left" valign="middle"><span class="gensmall">'.$lang['Email'].'</span></td>
						<td class="row1" align="left" valign="middle"><input type="text" class="post" onFocus="Active(this)" onBlur="NotActive(this)" style="width:120px" name="email" size="25" maxlength="255" value="" /></td>
						<td class="row1" align="left" valign="middle" nowrap="nowrap"><span class="gensmall">' . $custom_field_box . '<input type="hidden" name="viewemail" value="1" checked="checked" /><input type="hidden" name="hideonline" value="0" checked="checked" /><input type="hidden" name="notifyreply" value="0" checked="checked" /><input type="hidden" name="notifypm" value="1" checked="checked" /><input type="hidden" name="popup_pm" value="1" checked="checked" /><input type="hidden" name="attachsig" value="1" checked="checked" /><input type="hidden" name="allowbbcode" value="1" checked="checked" /><input type="hidden" name="allowhtml" value="1" checked="checked" /><input type="hidden" name="allowsmilies" value="1" checked="checked" /><input type="hidden" name="' . $board_config['default_dateformat'] . '" value="d M Y h:i a" maxlength="14" class="post" /><input type="hidden" name="mode" value="register" /><input type="hidden" name="agreed" value="true" /><input type="hidden" name="sid" value="' . $userdata['session_id'] . '"><input type="hidden" name="coppa" value="0" /><input type="hidden" name="user_topics_per_page" value="'.$board_config['topics_per_page'].'" checked="checked" /><input type="hidden" name="user_posts_per_page" value="'.$board_config['posts_per_page'].'" checked="checked" /><input type="hidden" name="user_hot_threshold" value="'.$board_config['hot_threshold'].'" checked="checked" /><input type="submit" name="submit" value="'.$lang['Submit'].'" class="liteoption" /></span></td>
						<td class="row1" width="100%"></td>
					</tr>
				</table>
			</form>
';

	if ( $board_config['cregist_b'] )
	{
		$custom_reg_b = $regist_form . '</br>';
	}
	else
	{
		$custom_reg = $regist_form;
	}
}

$counter = ( $board_config['ccount'] ) ? '<br />' . $lang['visitors_txt'] . ' <b>' . $visit_counter . '</b> ' . $lang['visitors_txt2'] : '';
$lposts = ''; $lposts2 = ''; $ltopics = ''; $ltopics2 = '';
if ( $board_config['cpost'] && $userdata['session_logged_in'] )
{
	$lposts = '<br />' . $lang['new_postsss'] . ' <b>';
	$lposts2 = '</b>';
}
if ( $board_config['ctop'] && $userdata['session_logged_in'] )
{
	$ltopics = '<br />' . $lang['new_topicsss'] . '<b>';
	$ltopics2 = '</b>';
}
if ( $board_config['cstyles'] )
{
	if (!empty($_SERVER['HTTP_USER_AGENT'])) 
	{
		$HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
	} 
	else if (!empty($HTTP_SERVER_VARS['HTTP_USER_AGENT'])) 
	{
		$HTTP_USER_AGENT = $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
	}
	else if (!isset($HTTP_USER_AGENT))
	{
		$HTTP_USER_AGENT = '';
	}
	$submit_button = (eregi('Opera', $HTTP_USER_AGENT) || !$HTTP_USER_AGENT) ? '<input type="submit" name="submit" value="&raquo;" class="liteoption" style="width:14px;height:18px;">' : '';

	if ( $userdata['session_logged_in'] )
	{
		$template->assign_vars(array(
			'FPAGE_STYLE' => style_select($fpage_style, 'fpage_theme') . $submit_button)
		);
	}
	else
	{
		$template->assign_vars(array(
			'TEMPLATE_SELECT' => style_select($board_config['default_style'], 'template') . $submit_button)
		);
	}
}

$sql = "SELECT *
	FROM " . SHOUTBOX_CONFIG_TABLE . "
		WHERE config_name = 'shoutbox_on'
			OR config_name = 'banned_user_id_view'
			OR config_name = 'allow_users_view'
			OR config_name = 'allow_users'
			OR config_name = 'allow_users_view'
			OR config_name = 'shout_width'
			OR config_name = 'shout_height'";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query shoutbox config information', '', __LINE__, __FILE__, $sql);
}

while ( $row = $db->sql_fetchrow($result) )
{
	$shoutbox_config[$row['config_name']] = $row['config_value'];
}

if ( $shoutbox_config['shoutbox_on'] )
{
	$shoutbox_config['banned_user_id_view'] = $GLOBALS['shoutbox_config']['banned_user_id_view'];
	if ( strstr($shoutbox_config['banned_user_id_view'], ',') )
	{
		$fids = explode(',', $shoutbox_config['banned_user_id_view']);
		while( list($foo, $id) = each($fids) )
		{
			$fid[] = intval( trim($id) );
		}
	}
	else
	{
		$fid[] = intval( trim($shoutbox_config['banned_user_id_view']) );
	}
	reset($fid);

	if ( in_array($userdata['user_id'], $fid) == false && ($shoutbox_config['allow_users_view'] || $userdata['session_logged_in']) && ($shoutbox_config['allow_users'] || $shoutbox_config['allow_users_view'] || $userdata['user_level'] == ADMIN || is_mod($userdata['user_id'])))
	{
		include($phpbb_root_path . 'shoutbox_body.'.$phpEx);
	}
}

$sql = "SELECT user_id
	FROM " . JR_ADMIN_TABLE . "
	WHERE user_jr_admin <> ''
	LIMIT 1";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain junior admins', '', __LINE__, __FILE__, $sql);
}
if ($row = $db->sql_fetchrow($result))
{
	$is_some_jr_admin = ($row['user_id']) ? true : false;
}

$template->assign_vars(array(
	'TOTAL_POSTS' => sprintf($l_total_post_s, $total_posts) . ', ' . $lang['topics'] . ' <b>' . get_db_stat('topiccount') . '</b>',
	'TOTAL_USERS' => sprintf($l_total_user_s, $total_users),
	'NEWEST_USER' => sprintf($lang['Newest_user'], '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$newest_uid") . '" class="gensmall">', $newest_user, '</a>'),
	'FORUM_IMG' => $images['forum'],
	'FORUM_NEW_IMG' => $images['forum_new'],
	'FORUM_LOCKED_IMG' => $images['forum_locked'],
	'L_FORUM' => $lang['Forum'],
	'L_TOPICS' => $lang['Topics'],
	'L_REPLIES' => $lang['Replies'],
	'L_VIEWS' => $lang['Views'],
	'L_POSTS' => $lang['Posts'],
	'L_LASTPOST' => $lang['Last_Post'],
	'L_NO_NEW_POSTS' => $lang['No_new_posts'],
	'L_NEW_POSTS' => $lang['New_posts'],
	'L_NO_NEW_POSTS_LOCKED' => $lang['No_new_posts_locked'],
	'L_NEW_POSTS_LOCKED' => $lang['New_posts_locked'],
	'L_WHOSONLINE_ADMIN' => sprintf($lang['Admin_online_color'], '<span style="color:#' . $theme['fontcolor3'] . '">', '</span>'),
	'L_WHOSONLINE_MOD' => sprintf($lang['Mod_online_color'], '<span style="color:#' . $theme['fontcolor2'] . '">', '</span>'),
	'L_WHOSONLINE_JR_ADMIN' => ($is_some_jr_admin) ? '&nbsp; [ ' . sprintf($lang['Junior_online_color'], '<span style="color:#' . $theme['fontcolor2'] . '"><u>', '</u></span>') . ' ] ' : '',
	'L_WHO_IS_ONLINE' => $lang['Who_is_Online'],
	'L_MODERATOR' => $lang['Moderators'],
	'L_FORUM_LOCKED' => $lang['Forum_is_locked'],
	'L_MARK_FORUMS_READ' => $lang['Mark_all_forums'],
	'LTOPICS' => $ltopics,
	'LTOPICS2' => $ltopics2,
	'LPOSTS' => $lposts,
	'LPOSTS2' => $lposts2,
	'L_VIEW_DETAILED' => $lang['l_whoisonline'],
	'U_SEARCH_UNANSWERED' => append_sid('search.'.$phpEx.'?search_id=unanswered'),
	'U_SEARCH_SELF' => append_sid('search.'.$phpEx.'?search_id=egosearch'),
	'U_SEARCH_NEW' => append_sid('search.'.$phpEx.'?search_id=newposts'),
	'L_SEARCH_NEW' => $l_searchnew,
	'SEARCH_LASTVISITPOSTS' => ($board_config['read_tracking']) ? $search_lastvisit : '',
	'CUSTOM_REG' => $custom_reg,
	'CUSTOM_REG_B' => $custom_reg_b,
	'VALIDATE1' => $validate1,
	'VALIDATE2' => $validate2,
	'STYLE_BOX' => $style_box,
	'STYLE_BOX2' => $style_box2,
	'STYLE_BOX3' => $style_box3,
	'STYLE_BOX4' => $style_box4,
	'STYLE_BOX0' => $style_box0,
	'COUNTER' => $counter,
	'T_SELECT_ACTION' => append_sid("index.$phpEx"),
	'U_MARK_READ' => "index.$phpEx?mark=forums&amp;sid=" . $userdata['session_id'])
);

// Okay, let's build the index

// don't display the board statistics
if ( ($board_config['display_viewonline'] == 2) || (($viewcat < 0) && ($board_config['display_viewonline'] == 1)) )
{
	$template->assign_block_vars('disable_viewonline', array());

	if ( $board_config['cbirth'] )
	{
		$template->assign_block_vars('disable_viewonline.birthday', array());
	}

	if ( $board_config['cchat2'] )
	{
		require_once($phpbb_root_path . 'chatbox_front.'.$phpEx);

		$template->assign_block_vars('disable_viewonline.chat', array());

		if ($userdata['session_logged_in'])
		{
			$template->assign_block_vars('disable_viewonline.chat.logged_in', array());
		}
		else
		{
			$template->assign_block_vars('disable_viewonline.chat.logged_out', array());
		}

		$template->assign_vars(array(
			'TOTAL_CHATTERS_ONLINE' => sprintf($lang['How_Many_Chatters'], $howmanychat),
			'CHATTERS_LIST' => sprintf($lang['Who_Are_Chatting' ], $chatters),
			'L_CLICK_TO_JOIN_CHAT' => $lang['Click_to_join_chat'],
			'S_JOIN_CHAT' => append_sid("chatbox_mod/chatbox.$phpEx"),
			'CHATBOX_NAME' => $userdata['user_id'] . '_ChatBox',
			'L_LOGIN_TO_JOIN_CHAT' => $lang['Login_to_join_chat'])
		);
	}

	if ( $board_config['staff_enable'] )
	{
		$template->assign_block_vars('disable_viewonline.staff', array());
		$template->assign_vars(array(
			'L_STAFF' => $lang['l_staff'],
			'U_STAFF' => append_sid("staff.$phpEx"))
		);
	}

	if ( $board_config['warnings_enable'] )
	{
		$template->assign_block_vars('disable_viewonline.warnings', array());
		$template->assign_vars(array(
			'U_WARNINGS' => '<a href="' . append_sid("warnings.$phpEx") . '" class="gensmall">' . $lang['Warnings'] . '</a>',)
		);
	}
}

// display the index
$display = display_index($viewcatkey);

if (!$display)
{
	message_die(GENERAL_MESSAGE, $lang['No_forums']);
}

if ($board_config['board_msg_enable'] == '1')
{
	$template->assign_block_vars('switch_enable_board_msg_index', array()); 
}

// Generate the page
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>