<?php

/***************************************************************************
 *                            lang_admin.php [English]
 *                              -------------------
 *     begin                : Sat Dec 16 2000
 *     copyright            : (C) 2001 The phpBB Group
 *     email                : support@phpbb.com
 *     modification	        : (C) 2003 Przemo http://www.przemo.org
 *     date modification    : ver. 1.9 2004/04/14 15:50
 *
 *     $Id: lang_admin.php,v 1.35.2.9 2003/06/10 00:31:19 psotfx Exp $
 *
 ****************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 ***************************************************************************/

/* CONTRIBUTORS
	2002-12-15	Philip M. White (pwhite@mailhaven.com)
		Fixed many minor grammatical mistakes
*/

//
// Format is same as lang_main
//

//
// Modules, this replaces the keys used
// in the modules[][] arrays in each module file
//
$lang['AAGeneral'] = 'General Admin';
$lang['ACUsers'] = 'User Admin';
$lang['ADGroups'] = 'Group Admin';
$lang['Forums'] = 'Forum Admin';
$lang['Styles'] = 'Styles Admin';

$lang['Configuration'] = 'Configuration';
$lang['Permissions'] = 'Permissions';
$lang['Manage'] = 'Management';
$lang['Disallow'] = 'Disallow names';
$lang['Prune'] = 'Pruning';
$lang['Mass_Email'] = 'Mass Email';
$lang['Ranks'] = 'Ranks';
$lang['Smilies'] = 'Smilies';
$lang['Ban_Management'] = 'Ban Control';
$lang['Word_Censor'] = 'Word Censors';
$lang['Export'] = 'Export';
$lang['Create_new'] = 'Create';
$lang['Add_new'] = 'Add';
$lang['Backup_DB'] = 'Backup Database';
$lang['Restore_DB'] = 'Restore Database';


//
// Index
//
$lang['Admin'] = 'Administration';
$lang['Not_admin'] = 'You are not authorised to administer this board';
$lang['Welcome_phpBB'] = 'Welcome to phpBB';
$lang['Admin_intro'] = 'Thank you for choosing phpBB as your forum solution. This screen will give you a quick overview of all the various statistics of your board. You can get back to this page by clicking on the <u>Admin Index</u> link in the left pane. To return to the index of your board, click the phpBB logo also in the left pane. The other links on the left hand side of this screen will allow you to control every aspect of your forum experience, each screen will have instructions on how to use the tools.';
$lang['Main_index'] = 'Forum Index';
$lang['Forum_stats'] = 'Forum Statistics';
$lang['Admin_Index'] = 'Admin Index';
$lang['Preview_forum'] = 'Preview Forum';

$lang['Click_return_admin_index'] = 'Click %sHere%s to return to the Admin Index';

$lang['Statistic'] = 'Statistic';
$lang['Value'] = 'Value';
$lang['Number_posts'] = 'Number of posts';
$lang['Posts_per_day'] = 'Posts per day';
$lang['Number_topics'] = 'Number of topics';
$lang['Topics_per_day'] = 'Topics per day';
$lang['Number_users'] = 'Number of users';
$lang['Users_per_day'] = 'Users per day';
$lang['Board_started'] = 'Board started';
$lang['Avatar_dir_size'] = 'Avatar directory size';
$lang['Database_size'] = 'Database size';
$lang['Gzip_compression'] = 'Gzip compression';
$lang['Not_available'] = 'Not available';

$lang['ON'] = 'ON';
$lang['OFF'] = 'OFF'; 


//
// DB Utils
//
$lang['Database_Utilities'] = 'Database Utilities';

$lang['Restore'] = 'Restore';
$lang['Backup'] = 'Backup';
$lang['Restore_explain'] = 'This will perform a full restore of all phpBB tables from a saved file. If your server supports it, you may upload a gzip compressed text file and it will automatically be decompressed. <b>WARNING</b> This will overwrite any existing data. The restore may take a long time to process please do not move from this page till it is complete.';
$lang['Backup_explain'] = 'Here you can back up all your phpBB-related data. If you have any additional custom tables in the same database with phpBB that you would like to back up as well please enter their names separated by commas in the Additional Tables textbox below. If your server supports it you may also gzip compress the file to reduce its size before download.';

$lang['Backup_options'] = 'Backup options';
$lang['Start_backup'] = 'Start Backup';
$lang['Full_backup'] = 'Full backup';
$lang['Structure_backup'] = 'Structure Only backup';
$lang['Data_backup'] = 'Data only backup';
$lang['Additional_tables'] = 'Additional tables';
$lang['Gzip_compress'] = 'Gzip compress file';
$lang['Select_file'] = 'Select a file';
$lang['Start_Restore'] = 'Start Restore';

$lang['Restore_success'] = 'The Database has been successfully restored.<br /><br />Your board should be back to the state it was when the backup was made.';
$lang['Backup_download'] = 'Your download will start shortly please wait till it begins.<br />But if will be some problems with copy database, use PhpMyAdmin to copy database per parts';
$lang['Backups_not_supported'] = 'Sorry, but database backups are not currently supported for your database system';

$lang['Restore_Error_uploading'] = 'Error in uploading the backup file';
$lang['Restore_Error_filename'] = 'Filename problem, please try an alternative file';
$lang['Restore_Error_decompress'] = 'Cannot decompress a gzip file, please upload a plain text version';
$lang['Restore_Error_no_file'] = 'No file was uploaded';


//
// Auth pages
//
$lang['Select_a_User'] = 'Select a User';
$lang['Select_a_Group'] = 'Select a Group';
$lang['Select_a_Forum'] = 'Select a Forum';
$lang['Auth_Control_User'] = 'User Permissions Control';
$lang['Auth_Control_Group'] = 'Group Permissions Control';
$lang['Auth_Control_Forum'] = 'Forum Permissions Control';
$lang['Look_up_User'] = 'Look up User';
$lang['Look_up_Group'] = 'Look up Group';
$lang['Look_up_Forum'] = 'Look up Forum';

$lang['Group_auth_explain'] = 'Here you can alter the permissions and moderator status assigned to each user group. Do not forget when changing group permissions that individual user permissions may still allow the user entry to forums, etc. You will be warned if this is the case.';
$lang['User_auth_explain'] = 'Here you can alter the permissions and moderator status assigned to each individual user. Do not forget when changing user permissions that group permissions may still allow the user entry to forums, etc. You will be warned if this is the case.';
$lang['Forum_auth_explain'] = 'Here you can alter the authorisation levels of each forum. You will have both a simple and advanced method for doing this, advanced offers greater control of each forum operation. Remember that changing the permission level of forums will affect which users can carry out the various operations within them.';

$lang['Simple_mode'] = 'Simple Mode';
$lang['Advanced_mode'] = 'Advanced Mode';
$lang['Moderator_status'] = 'Moderator status';

$lang['Allowed_Access'] = 'Allowed Access';
$lang['Disallowed_Access'] = 'Disallowed Access';
$lang['Is_Moderator'] = 'Is Moderator';
$lang['Not_Moderator'] = 'Not Moderator';

$lang['Conflict_warning'] = 'Authorisation Conflict Warning';
$lang['Conflict_access_userauth'] = 'This user still has access rights to this forum via group membership. You may want to alter the group permissions or remove this user the group to fully prevent them having access rights. The groups granting rights (and the forums involved) are noted below.';
$lang['Conflict_mod_userauth'] = 'This user still has moderator rights to this forum via group membership. You may want to alter the group permissions or remove this user the group to fully prevent them having moderator rights. The groups granting rights (and the forums involved) are noted below.';

$lang['Conflict_access_groupauth'] = 'The following user (or users) still have access rights to this forum via their user permission settings. You may want to alter the user permissions to fully prevent them having access rights. The users granted rights (and the forums involved) are noted below.';
$lang['Conflict_mod_groupauth'] = 'The following user (or users) still have moderator rights to this forum via their user permissions settings. You may want to alter the user permissions to fully prevent them having moderator rights. The users granted rights (and the forums involved) are noted below.';

$lang['Public'] = 'Public';
$lang['Private'] = 'Private';
$lang['Registered'] = 'Registered';
$lang['Administrators'] = 'Administrators';
$lang['Hidden'] = 'Hidden';

// These are displayed in the drop down boxes for advanced
// mode forum auth, try and keep them short!
$lang['Forum_ALL'] = 'ALL';
$lang['Forum_REG'] = 'REG';
$lang['Forum_PRIVATE'] = 'PRIVATE';
$lang['Forum_MOD'] = 'MOD';
$lang['Forum_ADMIN'] = 'ADMIN';

$lang['View'] = 'View';
$lang['Read'] = 'Read';
$lang['Post'] = 'Post';
$lang['Reply'] = 'Reply';
$lang['Edit'] = 'Edit';
$lang['Delete'] = 'Delete';
$lang['Sticky'] = 'Sticky';
$lang['Announce'] = 'Announce';
$lang['Vote'] = 'Vote';
$lang['Pollcreate'] = 'Poll create';

$lang['Simple_Permission'] = 'Simple Permission';

$lang['User_Level'] = 'User Level';
$lang['Auth_User'] = 'User';
$lang['Auth_Admin'] = 'Administrator';
$lang['Group_memberships'] = 'Usergroup memberships (in total: %d)';
$lang['Usergroup_members'] = 'This group has the following members (in total: %d)';

$lang['Forum_auth_updated'] = 'Forum permissions updated';
$lang['User_auth_updated'] = 'User permissions updated';
$lang['Group_auth_updated'] = 'Group permissions updated';

$lang['Auth_updated'] = 'Permissions have been updated';
$lang['Click_return_userauth'] = 'Click %sHere%s to return to User Permissions';
$lang['Click_return_groupauth'] = 'Click %sHere%s to return to Group Permissions';
$lang['Click_return_forumauth'] = 'Click %sHere%s to return to Forum Permissions';


//
// Banning
//
$lang['Ban_control'] = 'Ban Control';
$lang['Ban_explain'] = 'Here you can control the banning of users. You can achieve this by banning either or both of a specific user or an individual or range of IP addresses or hostnames. These methods prevent a user from even reaching the index page of your board. To prevent a user from registering under a different username you can also specify a banned email address. Please note that banning an email address alone will not prevent that user from being able to log on or post to your board. You should use one of the first two methods to achieve this.';
$lang['Ban_explain_warn'] = 'Please note that entering a range of IP addresses results in all the addresses between the start and end being added to the banlist. Attempts will be made to minimise the number of addresses added to the database by introducing wildcards automatically where appropriate. If you really must enter a range try to keep it small or better yet state specific addresses.';

$lang['Select_username'] = 'Select a Username';
$lang['Select_ip'] = 'Select an IP address';
$lang['Select_email'] = 'Select an Email address';

$lang['Ban_username'] = 'Ban one or more specific users';
$lang['Ban_username_explain'] = 'You can ban multiple users in one go using the appropriate combination of mouse and keyboard for your computer and browser';

$lang['Ban_IP'] = 'Ban one or more IP addresses or hostnames';
$lang['IP_hostname'] = 'IP addresses or hostnames';
$lang['Ban_IP_explain'] = 'To specify several different IP addresses or hostnames separate them with commas. To specify a range of IP addresses, separate the start and end with a hyphen (-); to specify a wildcard, use an asterisk (*).';

$lang['Ban_email'] = 'Ban one or more email addresses';
$lang['Ban_email_explain'] = 'To specify more than one email address, separate them with commas. To specify a wildcard username, use * like *@hotmail.com';

$lang['Unban_username'] = 'Un-ban one more specific users';
$lang['Unban_username_explain'] = 'You can unban multiple users in one go using the appropriate combination of mouse and keyboard for your computer and browser';

$lang['Unban_IP'] = 'Un-ban one or more IP addresses';
$lang['Unban_IP_explain'] = 'You can unban multiple IP addresses in one go using the appropriate combination of mouse and keyboard for your computer and browser';

$lang['Unban_email'] = 'Un-ban one or more email addresses';
$lang['Unban_email_explain'] = 'You can unban multiple email addresses in one go using the appropriate combination of mouse and keyboard for your computer and browser';

$lang['No_banned_users'] = 'No banned usernames';
$lang['No_banned_ip'] = 'No banned IP addresses';
$lang['No_banned_email'] = 'No banned email addresses';

$lang['Ban_update_sucessful'] = 'The banlist has been updated successfully';
$lang['Click_return_banadmin'] = 'Click %sHere%s to return to Ban Control';


//
// Configuration
//
$lang['General_Config'] = 'General Configuration';
$lang['Config_explain'] = 'The form below will allow you to customize all the general board options. For User and Forum configurations use the related links on the left hand side.';

$lang['Click_return_config'] = 'Click %sHere%s to return to General Configuration';

$lang['General_settings'] = 'General Board Settings';
$lang['Server_name'] = 'Domain Name';
$lang['Server_name_explain'] = 'The domain name from which this board runs';
$lang['Script_path'] = 'Script path';
$lang['Script_path_explain'] = 'The path where phpBB2 is located relative to the domain name';
$lang['Server_port'] = 'Server Port';
$lang['Server_port_explain'] = 'The port your server is running on, usually 80. Only change if different';
$lang['Site_name'] = 'Site name';
$lang['Site_desc'] = 'Site description';
$lang['Board_disable'] = 'Disable board';
$lang['Board_disable_explain'] = 'If you put here some reason, this will make the board unavailable to users.';
$lang['Acct_activation'] = 'Enable account activation';
$lang['Acc_Admin'] = 'Admin';
$lang['Acc_User'] = 'User';
$lang['Acc_Admin'] = 'Admin';

$lang['Abilities_settings'] = 'User and Forum Basic Settings';
$lang['Max_poll_options'] = 'Max number of poll options';
$lang['Flood_Interval'] = 'Flood Interval';
$lang['Flood_Interval_explain'] = 'Number of seconds a user must wait between posts';
$lang['Board_email_form'] = 'User email via board';
$lang['Board_email_form_explain'] = 'Users send email to each other via this board';
$lang['Topics_per_page'] = 'Topics Per Page';
$lang['Posts_per_page'] = 'Posts Per Page';
$lang['Hot_threshold'] = 'Posts for Popular Threshold';
$lang['Default_style'] = 'Default Style';
$lang['Override_style'] = 'Override user style';
$lang['Override_style_explain'] = 'Replaces users style with the default';
$lang['Default_language'] = 'Default Language';
$lang['Date_format'] = 'Date Format';
$lang['System_timezone'] = 'System Timezone';
$lang['Enable_gzip'] = 'Enable GZip Compression';
$lang['Enable_prune'] = 'Enable Forum Pruning';
$lang['Allow_HTML'] = 'Allow HTML';
$lang['Allow_BBCode'] = 'Allow BBCode';
$lang['Allowed_tags'] = 'Allowed HTML tags';
$lang['Allowed_tags_explain'] = 'Separate tags with commas';
$lang['Allow_smilies'] = 'Allow Smilies';
$lang['Smilies_path'] = 'Smilies Storage Path';
$lang['Smilies_path_explain'] = 'Path under your phpBB root dir, e.g. images/smiles';
$lang['Allow_sig'] = 'Allow Signatures';
$lang['Max_sig_length'] = 'Maximum signature length';
$lang['Max_sig_length_explain'] = 'Maximum number of characters in user signatures';
$lang['Allow_name_change'] = 'Allow Username changes';

$lang['Avatar_settings'] = 'Avatar Settings';
$lang['Allow_local'] = 'Enable gallery avatars';
$lang['Allow_remote'] = 'Enable remote avatars';
$lang['Allow_remote_explain'] = 'Avatars linked to from another website';
$lang['Allow_upload'] = 'Enable avatar uploading';
$lang['Max_filesize'] = 'Maximum Avatar File Size';
$lang['Max_filesize_explain'] = 'For uploaded avatar files';
$lang['Max_avatar_size'] = 'Maximum Avatar Dimensions';
$lang['Max_avatar_size_explain'] = '(Height x Width in pixels)';
$lang['Avatar_storage_path'] = 'Avatar Storage Path';
$lang['Avatar_storage_path_explain'] = 'Path under your phpBB root dir, e.g. images/avatars';
$lang['Avatar_gallery_path'] = 'Avatar Gallery Path';
$lang['Avatar_gallery_path_explain'] = 'Path under your phpBB root dir for pre-loaded images, e.g. images/avatars/gallery';

$lang['COPPA_settings'] = 'COPPA Settings';
$lang['COPPA_fax'] = 'COPPA Fax Number';
$lang['COPPA_mail'] = 'COPPA Mailing Address';
$lang['COPPA_mail_explain'] = 'This is the mailing address to which parents will send COPPA registration forms';

$lang['Email_settings'] = 'Email Settings';
$lang['Admin_email'] = 'Admin Email Address';
$lang['Email_sig'] = 'Email Signature';
$lang['Email_sig_explain'] = 'This text will be attached to all emails the board sends';
$lang['Use_SMTP'] = 'Use SMTP Server for email';
$lang['Use_SMTP_explain'] = 'Say yes if you want or have to send email via a named server instead of the local mail function';
$lang['SMTP_server'] = 'SMTP Server Address';
$lang['SMTP_username'] = 'SMTP Username';
$lang['SMTP_username_explain'] = 'Only enter a username if your SMTP server requires it';
$lang['SMTP_password'] = 'SMTP Password';
$lang['SMTP_password_explain'] = 'Only enter a password if your SMTP server requires it';

$lang['Disable_privmsg'] = 'Private Messaging';
$lang['Inbox_limits'] = 'Max posts in Inbox (Admin x 6 and Moderator x 3)';
$lang['Sentbox_limits'] = 'Max posts in Sentbox (Admin x 6 and Moderator x 3)';
$lang['Savebox_limits'] = 'Max posts in Savebox (Admin x 6 and Moderator x 3)';

$lang['Cookie_settings'] = 'Cookie settings';
$lang['Cookie_settings_explain'] = '<span style="color: red">These details define how cookies are sent to your users browsers. In most cases the default values for the cookie settings should be sufficient but if you need to change them do so with care, incorrect settings can prevent users logging in.</span><br />Example: address forum: <b>www.przemo.org/forum</b>or <b>http://www.przemo.org/forum</b> cookie domain and domain name must be: <b>www.przemo.org</b><br /> Second example address: <b>http://przemo.org/forum</b> domain name and cookie domain: <b>przemo.org</b><br />Dont use more than one domain for connecting to forum if not users possibli can not log in!';
$lang['Cookie_domain'] = 'Cookie domain';
$lang['Cookie_name'] = 'Cookie name';
$lang['Cookie_path'] = 'Cookie path';
$lang['Cookie_secure'] = 'Cookie secure';
$lang['Cookie_secure_explain'] = 'If your server is running via SSL set this to enabled else leave as disabled';
$lang['Session_length'] = 'Session length [ seconds ]';

// Visual Confirmation
$lang['Visual_confirm'] = 'Enable Visual Confirmation';
$lang['Visual_confirm_explain'] = 'Requires users enter a code defined by an image when registering.';

//
// Forum Management
//
$lang['Forum_admin'] = 'Forum Administration';
$lang['Forum_admin_explain'] = 'From this panel you can add, delete, edit, re-order and re-synchronise categories and forums.<br />Remember: if you want create subforums, you must create first category in selected forum, after it add forums in the create category.';
$lang['Edit_forum'] = 'Edit forum';
$lang['Create_forum'] = 'Create new forum';
$lang['Create_category'] = 'Create new category';
$lang['Remove'] = 'Remove';
$lang['Action'] = 'Action';
$lang['Update_order'] = 'Update Order';
$lang['Config_updated'] = 'Forum Configuration Updated Successfully';
$lang['Edit'] = 'Edit';
$lang['Delete'] = 'Delete';
$lang['Move_up'] = 'Move up';
$lang['Move_down'] = 'Move down';
$lang['Resync'] = 'Resync';
$lang['No_mode'] = 'No mode was set';
$lang['Forum_edit_delete_explain'] = 'The form below will allow you to customize all the general board options. For User and Forum configurations use the related links on the left hand side';

$lang['Move_contents'] = 'Move all contents';
$lang['Forum_delete'] = 'Delete Forum';
$lang['Forum_delete_explain'] = 'The form below will allow you to delete a forum (or category) and decide where you want to put all topics (or forums) it contained.';

$lang['Status_locked'] = 'Locked';
$lang['Status_unlocked'] = 'Unlocked';
$lang['Forum_settings'] = 'General Forum Settings';
$lang['Forum_name'] = 'Forum name';
$lang['Forum_desc'] = 'Description';
$lang['Forum_status'] = 'Forum status';
$lang['Forum_pruning'] = 'Auto-pruning';

$lang['prune_freq'] = 'Check for topic age every';
$lang['prune_days'] = 'Remove topics that have not been posted to in';
$lang['Set_prune_data'] = 'You have turned on auto-prune for this forum but did not set a frequency or number of days to prune. Please go back and do so';

$lang['Move_and_Delete'] = 'Move and Delete';

$lang['Delete_all_posts'] = 'Delete all posts';
$lang['Nowhere_to_move'] = 'Nowhere to move to';

$lang['Edit_Category'] = 'Edit Category';
$lang['Edit_Category_explain'] = 'Use this form to modify a category\'s name.';

$lang['Forums_updated'] = 'Forum and Category information updated successfully';

$lang['Must_delete_forums'] = 'You need to delete all forums before you can delete this category';

$lang['Click_return_forumadmin'] = 'Click %sHere%s to return to Forum Administration';


//
// Smiley Management
//
$lang['smiley_title'] = 'Smiles Editing Utility';
$lang['smile_desc'] = 'From this page you can add, remove and edit the emoticons or smileys that your users can use in their posts and private messages.';

$lang['smiley_config'] = 'Smiley Configuration';
$lang['smiley_code'] = 'Smiley Code';
$lang['smiley_url'] = 'Smiley Image File';
$lang['smiley_emot'] = 'Smiley Emotion';
$lang['smile_add'] = 'Add a new Smiley';
$lang['Smile'] = 'Smile';
$lang['Emotion'] = 'Emotion';

$lang['Select_pak'] = 'Select Pack (.pak) File';
$lang['replace_existing'] = 'Replace Existing Smiley';
$lang['keep_existing'] = 'Keep Existing Smiley';
$lang['smiley_import_inst'] = 'You should unzip the smiley package and upload all files to the appropriate Smiley directory for your installation. Then select the correct information in this form to import the smiley pack.';
$lang['smiley_import'] = 'Smiley Pack Import';
$lang['choose_smile_pak'] = 'Choose a Smile Pack .pak file';
$lang['import'] = 'Import Smileys';
$lang['smile_conflicts'] = 'What should be done in case of conflicts';
$lang['del_existing_smileys'] = 'Delete existing smileys before import';
$lang['import_smile_pack'] = 'Import Smiley Pack';
$lang['export_smile_pack'] = 'Create Smiley Pack';
$lang['export_smiles'] = 'To create a smiley pack from your currently installed smileys, click %sHere%s to download the smiles.pak file. Name this file appropriately making sure to keep the .pak file extension. Then create a zip file containing all of your smiley images plus this .pak configuration file.';

$lang['smiley_add_success'] = 'The Smiley was successfully added';
$lang['smiley_edit_success'] = 'The Smiley was successfully updated';
$lang['smiley_import_success'] = 'The Smiley Pack was imported successfully!';
$lang['smiley_del_success'] = 'The Smiley was successfully removed';
$lang['Click_return_smileadmin'] = 'Click %sHere%s to return to Smiley Administration';


//
// User Management
//
$lang['User_admin'] = 'User Administration';
$lang['User_admin_explain'] = 'Here you can change your users\' information and certain options. To modify the users\' permissions, please use the user and group permissions system.';

$lang['Look_up_user'] = 'Look up user';

$lang['Admin_user_fail'] = 'Couldn\'t update the user\'s profile.';
$lang['Admin_user_updated'] = 'The user\'s profile was successfully updated.';
$lang['Click_return_useradmin'] = 'Click %sHere%s to return to User Administration';

$lang['User_delete'] = 'Delete this user';
$lang['User_delete_explain'] = 'Click here to delete this user, this cannot be undone.';
$lang['User_deleted'] = 'User was successfully deleted.';

$lang['User_status'] = 'User is active';
$lang['User_allowpm'] = 'Can send Private Messages';
$lang['User_allowavatar'] = 'Can display avatar';

$lang['Admin_avatar_explain'] = 'Here you can see and delete the user\'s current avatar.';

$lang['User_special'] = 'Special admin-only fields';
$lang['User_special_explain'] = 'These fields are not able to be modified by the users. Here you can set their status and other options that are not given to users.';


//
// Group Management
//
$lang['Group_administration'] = 'Group Administration';
$lang['Group_admin_explain'] = 'From this panel you can administer all your usergroups. You can delete, create and edit existing groups. You may choose moderators, toggle open/closed group status and set the group name and description';
$lang['Error_updating_groups'] = 'There was an error while updating the groups';
$lang['Updated_group'] = 'The group was successfully updated';
$lang['Added_new_group'] = 'The new group was successfully created';
$lang['Deleted_group'] = 'The group was successfully deleted';
$lang['New_group'] = 'Create new group';
$lang['Edit_group'] = 'Edit group';
$lang['group_name'] = 'Group name';
$lang['group_description'] = 'Group description';
$lang['group_moderator'] = 'Group moderator';
$lang['group_status'] = 'Group status';
$lang['group_open'] = 'Open group';
$lang['group_closed'] = 'Closed group';
$lang['group_hidden'] = 'Hidden group';
$lang['group_delete'] = 'Delete group';
$lang['group_delete_check'] = 'Delete this group';
$lang['submit_group_changes'] = 'Submit Changes';
$lang['reset_group_changes'] = 'Reset Changes';
$lang['No_group_name'] = 'You must specify a name for this group';
$lang['No_group_moderator'] = 'You must specify a moderator for this group';
$lang['No_group_mode'] = 'You must specify a mode for this group, open or closed';
$lang['No_group_action'] = 'No action was specified';
$lang['delete_group_moderator'] = 'Delete the old group moderator?';
$lang['delete_moderator_explain'] = 'If you\'re changing the group moderator, check this box to remove the old moderator from the group. Otherwise, do not check it, and the user will become a regular member of the group.';
$lang['Click_return_groupsadmin'] = 'Click %sHere%s to return to Group Administration.';
$lang['Select_group'] = 'Select a group';
$lang['Look_up_group'] = 'Look up group';


//
// Prune Administration
//
$lang['Forum_Prune'] = 'Forum Prune';
$lang['Forum_Prune_explain'] = 'This will delete any topic which has not been posted to within the number of days you select. If you do not enter a number then all topics will be deleted. It will not remove topics in which polls are still running nor will it remove announcements. You will need to remove these topics manually.';
$lang['Do_Prune'] = 'Do Prune';
$lang['All_Forums'] = 'All Forums';
$lang['Prune_topics_not_posted'] = 'Prune topics with no replies in this many days';
$lang['Topics_pruned'] = 'Topics pruned';
$lang['Prune_success'] = 'Pruning of forums was successful';


//
// Word censor
//
$lang['Words_title'] = 'Word Censoring';
$lang['Words_explain'] = 'From this control panel you can add, edit, and remove words that will be automatically censored on your forums. In addition people will not be allowed to register with usernames containing these words. Wildcards (*) are accepted in the word field, eg. *test* will match detestable, test* would match testing, *test would match detest.';
$lang['Word'] = 'Word';
$lang['Edit_word_censor'] = 'Edit word censor';
$lang['Replacement'] = 'Replacement';
$lang['Add_new_word'] = 'Add new word';
$lang['Update_word'] = 'Update word censor';

$lang['Must_enter_word'] = 'You must enter a word and its replacement';
$lang['No_word_selected'] = 'No word selected for editing';

$lang['Word_updated'] = 'The selected word censor has been successfully updated';
$lang['Word_added'] = 'The word censor has been successfully added';
$lang['Word_removed'] = 'The selected word censor has been successfully removed';

$lang['Click_return_wordadmin'] = 'Click %sHere%s to return to Word Censor Administration';


//
// Mass Email
//
$lang['Mass_email_explain'] = 'Here you can email a message to either all of your users or all users of a specific group. To do this, an email will be sent out to the administrative email address supplied, with a blind carbon copy sent to all recipients. If you are emailing a large group of people please be patient after submitting and do not stop the page halfway through. It is normal for a mass emailing to take a long time, you will be notified when the script has completed';
$lang['Compose'] = 'Compose';

$lang['Recipients'] = 'Recipients';
$lang['All_users'] = 'All Users';

$lang['Email_successfull'] = 'Your message has been sent';
$lang['Click_return_massemail'] = 'Click %sHere%s to return to the Mass Email form';


//
// Ranks admin
//
$lang['Ranks_title'] = 'Rank Administration';
$lang['Ranks_explain'] = 'Using this form you can add, edit, view and delete ranks. You can also create custom ranks which can be applied to a user via the user management facility';

$lang['Add_new_rank'] = 'Add new rank';

$lang['Rank_title'] = 'Rank Title';
$lang['Rank_special'] = 'Set as Special Rank';
$lang['Rank_minimum'] = 'Minimum Posts';
$lang['Rank_maximum'] = 'Maximum Posts';
$lang['Rank_image'] = 'Rank Image';
$lang['Rank_image_explain'] = 'Use this to define a small image associated with the rank.<br />Ranks images should be in the /templates/Name_style/images/ranks/ for all installed styles';

$lang['Must_select_rank'] = 'You must select a rank';
$lang['No_assigned_rank'] = 'No special rank assigned';

$lang['Rank_updated'] = 'The rank was successfully updated';
$lang['Rank_added'] = 'The rank was successfully added';
$lang['Rank_removed'] = 'The rank was successfully deleted';
$lang['No_update_ranks'] = 'The rank was successfully deleted. However, user accounts using this rank were not updated. You will need to manually reset the rank on these accounts';

$lang['Click_return_rankadmin'] = 'Click %sHere%s to return to Rank Administration';


//
// Disallow Username Admin
//
$lang['Disallow_control'] = 'Username Disallow Control';
$lang['Disallow_explain'] = 'Here you can control usernames which will not be allowed to be used. Disallowed usernames are allowed to contain a wildcard character of *. Please note that you will not be allowed to specify any username that has already been registered, you must first delete that name then disallow it';

$lang['Delete_disallow'] = 'Delete';
$lang['Delete_disallow_title'] = 'Remove a Disallowed Username';
$lang['Delete_disallow_explain'] = 'You can remove a disallowed username by selecting the username from this list and clicking submit';

$lang['Add_disallow'] = 'Add';
$lang['Add_disallow_title'] = 'Add a disallowed username';
$lang['Add_disallow_explain'] = 'You can disallow a username using the wildcard character * to match any character';

$lang['No_disallowed'] = 'No Disallowed Usernames';

$lang['Disallowed_deleted'] = 'The disallowed username has been successfully removed';
$lang['Disallow_successful'] = 'The disallowed username has been successfully added';
$lang['Disallowed_already'] = 'The name you entered could not be disallowed. It either already exists in the list, exists in the word censor list, or a matching username is present';

$lang['Click_return_disallowadmin'] = 'Click %sHere%s to return to Disallow Username Administration';


//
// Styles Admin
//
$lang['Styles_admin'] = 'Styles Administration';
$lang['Styles_explain'] = 'Using this facility you can add, remove and manage styles (templates and themes) available to your users';
$lang['Styles_addnew_explain'] = 'The following list contains all the themes that are available for the templates you currently have. The items on this list have not yet been installed into the phpBB database. To install a theme simply click the install link beside an entry';

$lang['Select_template'] = 'Select a Template';

$lang['Style'] = 'Style';
$lang['Template'] = 'Template';
$lang['Install'] = 'Install';
$lang['Download'] = 'Download';

$lang['Edit_theme'] = 'Edit Theme';
$lang['Edit_theme_explain'] = 'In the form below you can edit the settings for the selected theme';

$lang['Create_theme'] = 'Create Theme';
$lang['Create_theme_explain'] = 'Use the form below to create a new theme for a selected template. When entering colours (for which you should use hexadecimal notation) you must not include the initial #, i.e.. CCCCCC is valid, #CCCCCC is not';

$lang['Export_themes'] = 'Export Themes';
$lang['Export_explain'] = 'In this panel you will be able to export the theme data for a selected template. Select the template from the list below and the script will create the theme configuration file and attempt to save it to the selected template directory. If it cannot save the file itself it will give you the option to download it. In order for the script to save the file you must give write access to the webserver for the selected template dir. For more information on this see the phpBB 2 users guide.';

$lang['Theme_installed'] = 'The selected theme has been installed successfully';
$lang['Style_removed'] = 'The selected style has been removed from the database. To fully remove this style from your system you must delete the appropriate style from your templates directory.';
$lang['Theme_info_saved'] = 'The theme information for the selected template has been saved. You should now return the permissions on the theme_info.cfg (and if applicable the selected template directory) to read-only';
$lang['Theme_updated'] = 'The selected theme has been updated. You should now export the new theme settings';
$lang['Theme_created'] = 'Theme created. You should now export the theme to the theme configuration file for safe keeping or use elsewhere';

$lang['Confirm_delete_style'] = 'Are you sure you want to delete this style?';

$lang['Download_theme_cfg'] = 'The exporter could not write the theme information file. Click the button below to download this file with your browser. Once you have downloaded it you can transfer it to the directory containing the template files. You can then package the files for distribution or use elsewhere if you desire';
$lang['No_themes'] = 'The template you selected has no themes attached to it. To create a new theme click the Create New link on the left hand panel';
$lang['No_template_dir'] = 'Could not open the template directory. It may be unreadable by the webserver or may not exist';
$lang['Cannot_remove_style'] = 'You cannot remove the style selected since it is currently the forum default. Please change the default style and try again.';
$lang['Style_exists'] = 'The style name to selected already exists, please go back and choose a different name.';

$lang['Click_return_styleadmin'] = 'Click %sHere%s to return to Style Administration';

$lang['Theme_settings'] = 'Theme Settings';
$lang['Theme_element'] = 'Theme Element';
$lang['Simple_name'] = 'Simple Name';
$lang['Value'] = 'Value';
$lang['Save_Settings'] = 'Save Settings';

$lang['Stylesheet'] = 'CSS Stylesheet';
$lang['Background_image'] = 'Background Image';
$lang['Background_color'] = 'Background Colour';
$lang['Theme_name'] = 'Theme Name';
$lang['Link_color'] = 'Link Colour';
$lang['Text_color'] = 'Text Colour';
$lang['VLink_color'] = 'Visited Link Colour';
$lang['ALink_color'] = 'Active Link Colour';
$lang['HLink_color'] = 'Hover Link Colour';
$lang['Tr_color1'] = 'Table Row Colour 1';
$lang['Tr_color2'] = 'Table Row Colour 2';
$lang['Tr_color3'] = 'Table Row Colour 3';
$lang['Tr_class1'] = 'Table Row Class 1';
$lang['Tr_class2'] = 'Table Row Class 2';
$lang['Tr_class3'] = 'Table Row Class 3';
$lang['Th_color1'] = 'Table Header Colour 1';
$lang['Th_color2'] = 'Table Header Colour 2';
$lang['Th_color3'] = 'Table Header Colour 3';
$lang['Th_class1'] = 'Table Header Class 1';
$lang['Th_class2'] = 'Table Header Class 2';
$lang['Th_class3'] = 'Table Header Class 3';
$lang['Td_color1'] = 'Table Cell Colour 1';
$lang['Td_color2'] = 'Table Cell Colour 2';
$lang['Td_color3'] = 'Table Cell Colour 3';
$lang['Td_class1'] = 'Table Cell Class 1';
$lang['Td_class2'] = 'Table Cell Class 2';
$lang['Td_class3'] = 'Table Cell Class 3';
$lang['fontface1'] = 'Font Face 1';
$lang['fontface2'] = 'Font Face 2';
$lang['fontface3'] = 'Font Face 3';
$lang['fontsize1'] = 'Font Size 1';
$lang['fontsize2'] = 'Font Size 2';
$lang['fontsize3'] = 'Font Size 3';
$lang['fontcolor1'] = 'Font Colour 1';
$lang['fontcolor2'] = 'Font Colour 2';
$lang['fontcolor3'] = 'Font Colour 3';
$lang['span_class1'] = 'Span Class 1';
$lang['span_class2'] = 'Span Class 2';
$lang['span_class3'] = 'Span Class 3';
$lang['img_poll_size'] = 'Polling Image Size [px]';
$lang['img_pm_size'] = 'Private Message Status size [px]';


//
// Install Process
//
$lang['Welcome_install'] = 'Welcome to phpBB modified by Przemo Installation';
$lang['Initial_config'] = 'Basic Configuration';
$lang['DB_config'] = 'Database Configuration';
$lang['Admin_config'] = 'Admin Configuration';
$lang['continue_upgrade'] = 'Once you have downloaded your config file to your local machine you may\'Continue Upgrade\' button below to move forward with the upgrade process. Please wait to upload the config file until the upgrade process is complete.';
$lang['upgrade_submit'] = 'Continue Upgrade';

$lang['Installer_Error'] = 'An error has occurred during installation';
$lang['Previous_Install'] = 'A previous installation has been detected';
$lang['Install_db_error'] = 'An error occurred trying to update the database';

$lang['Re_install'] = 'Your previous installation is still active.<br /><br />If you would like to re-install phpBB 2 you should click the Yes button below. Please be aware that doing so will destroy all existing data, no backups will be made! The administrator username and password you have used to log in in to the board will be re-created after the re-installation, no other settings will be retained. <br /><br />Think carefully before pressing Yes!';

$lang['Inst_Step_0'] = 'Thank you for choosing phpBB 2. In order to complete this install please fill out the details requested below. Please note that the database you install into should already exist. If you are installing to a database that uses ODBC, e.g. MS Access you should first create a DSN for it before proceeding.';

$lang['Start_Install'] = 'Start Install';
$lang['Finish_Install'] = 'Finish Installation';

$lang['Default_lang'] = 'Default board language';
$lang['DB_Host'] = 'Database Server Hostname / DSN';
$lang['DB_Name'] = 'Your Database Name';
$lang['DB_Username'] = 'Database Username';
$lang['DB_Password'] = 'Database Password';
$lang['Database'] = 'Your Database';
$lang['Install_lang'] = 'Choose Language for Installation';
$lang['dbms'] = 'Database Type';
$lang['Table_Prefix'] = 'Prefix for tables in database';
$lang['Admin_Username'] = 'Administrator Username';
$lang['Admin_Password'] = 'Administrator Password';
$lang['Admin_Password_confirm'] = 'Administrator Password [ Confirm ]';

$lang['Inst_Step_2'] = 'Your admin username has been created. At this point your basic installation is complete. You will now be taken to a screen which will allow you to administer your new installation. Please be sure to check the General Configuration details and make any required changes. Thank you for choosing phpBB 2.';

$lang['Unwriteable_config'] = 'Your config file is un-writeable at present. A copy of the config file will be downloaded to your computer when you click the button below. You should upload this file to the same directory as phpBB 2. Once this is done you should log in using the administrator name and password you provided on the previous form and visit the admin control center (a link will appear at the bottom of each screen once logged in) to check the general configuration. Thank you for choosing phpBB 2.';
$lang['Download_config'] = 'Download Config';

$lang['ftp_choose'] = 'Choose Download Method';
$lang['ftp_option'] = '<br />Since FTP extensions are enabled in this version of PHP you may also be given the option of first trying to automatically FTP the config file into place.';
$lang['ftp_instructs'] = 'You have chosen to FTP the file to the account containing phpBB 2 automatically. Please enter the information below to facilitate this process. Note that the FTP path should be the exact path via FTP to your phpBB2 installation as if you were FTPing to it using any normal client.';
$lang['ftp_info'] = 'Enter Your FTP Information';
$lang['Attempt_ftp'] = 'Attempt to FTP config file into place';
$lang['Send_file'] = 'Just send the file to me and I\'ll FTP it manually';
$lang['ftp_path'] = 'FTP path to phpBB 2';
$lang['ftp_username'] = 'Your FTP Username';
$lang['ftp_password'] = 'Your FTP Password';
$lang['Transfer_config'] = 'Start Transfer';
$lang['NoFTP_config'] = 'The attempt to FTP the config file into place failed. Please download the config file and FTP it into place manually.';

$lang['Install'] = 'Install';
$lang['Upgrade'] = 'Upgrade';


$lang['Install_Method'] = 'Choose your installation method';

$lang['Install_No_Ext'] = 'The PHP configuration on your server doesn\'t support the database type that you chose';

$lang['Install_No_PCRE'] = 'phpBB2 Requires the Perl-Compatible Regular Expressions Module for PHP which your PHP configuration doesn\'t appear to support!';


//
// Modified addons
//

$lang['ABForums'] = 'Forum Admin';
$lang['Private Messages'] = 'Private messages';
$lang['Users List'] = 'List users';
$lang['logs'] = 'Connects logs';
$lang['body_footer'] = 'Copyright note of Portal';
$lang['v_top_posters'] = 'Value for top posters. 0 - disable';
$lang['v_recent_topics'] = 'Value for last topics. 0 - disable';
$lang['portal_config'] = 'Portal settings';
$lang['l_album_pics'] = 'How many Last Pictures. 0 to disable';
$lang['album_pics'] = 'Last pics';
$lang['body_footer_e'] = 'You can to create own the copyright note of portal, or leave empty.';
$lang['l_own_body'] = 'Own side in place of news';
$lang['l_own_body_e'] = 'If you pass code the html of own side here, it in place of news will be your own side';
$lang['l_number_of_news'] = 'Number of news in portal';
$lang['l_news_length'] = 'The length of news (the signs)';
$lang['l_witch_news_forum'] = 'Forum of news';
$lang['l_witch_news_forum_e'] = 'Pass ID forum from which news will be taken. You can in him give suitable authorizations moderators, they in Portal will be then Newsman. If more than 1 separate ID with comma';
$lang['l_witch_poll_forum'] = 'ID Pool Forum';
$lang['l_except_forum'] = 'Barred forum of news';
$lang['links_body'] = 'Links body';
$lang['Portal_index'] = 'Portal Index';
$lang['Preview_portal'] = 'Preview Portal';
$lang['All_Forums'] = 'All Forums';
$lang['General_Portal_Config'] = 'Portal Settings';
$lang['Config_Portal_e'] = 'The form below will allow you to customize general Portal options';
$lang['General_Portal_settings'] = 'Portal settings';
$lang['Click_return_portal_config'] = 'Click %sHere%s to return to Portal Configuration';
$lang['Config_portal_updated'] = 'Portal Configuration Updated Successfully';
$lang['Sort_alpha'] = 'Alphabetically';
$lang['Sort_fpdate'] = 'Chronologically';
$lang['User_allowsig'] = 'Can display signature';
$lang['Set_posts'] = 'User Posts';
$lang['Must_select_rank'] = 'You must select a rank';
$lang['No_assigned_rank'] = 'No special rank assigned';

$lang['Enable_birthday_greeting'] = 'Enable birthday greating';
$lang['Birthday_greeting_expain'] = 'User which got already greeting, will get greeting once again.  ';
$lang['Next_birthday_greeting'] = 'Next year birthday greating';
$lang['Next_birthday_greeting_expain'] = 'This field keeps track of the next year the user shall have a birthday greeting';
$lang['Wrong_next_birthday_greeting'] = 'Wrong year next birthday greating';
$lang['Max_user_age'] = 'Max user age';
$lang['Min_user_age'] = 'Min user age';
$lang['Birthday_lookforward'] = 'How many days to show on main side before birthdays';

// Custom User Rank Mod 
$lang['Custom_Rank'] = 'user defined rank';
$lang['Allow_custom_rank'] = 'allow user defined rank';
$lang['Allow_custom_rank_explain'] = 'amount of posts, before an user can select his own rank';

// Admin User List
$lang['Admin_Users_List_Title'] = 'Users List Administration';
$lang['Admin_Users_List_Explain'] = 'Here is the list of your users with many useful information';
$lang['Last_visit'] = 'Last Visit';
$lang['Active'] = 'Active';

$lang['Allow_avatar'] = 'Allow Avatar per post';
$lang['Allow_avatar_explain'] = 'amount of posts, before an user can select his own avatar';

$lang['cagent'] = 'Showing system and browser.';
$lang['cagente'] = 'Do to show in view of topics, user\'s system and browser?';
$lang['crestrict'] = 'The restriction of access for registered';
$lang['crestrict_e'] = 'Unregistered users it can not look through users and profiles';
$lang['login_require'] = 'The total restriction of access for unregistered';
$lang['login_require_e'] = 'Registered users it can not look through no part of forum';

// Log actions MOD Start
$lang['Log_action_title'] = 'Logs Actions';
$lang['Log_action_explain'] = 'Here you can see the actions done by your moderators/administrators';
$lang['Choose_sort_method'] = 'Choose sorting method';
$lang['Order'] = 'Order';
$lang['Go'] = 'Go';
$lang['Id_log'] = 'Log Id';
$lang['Delete_log'] = 'Delete Log';
$lang['Action'] = 'Action';
$lang['Done_by'] = 'Done By';
$lang['User_ip'] = 'User IP';
$lang['Log_delete'] = 'Log delete successfully.';
$lang['Click_return_admin_log'] = 'Click %sHere%s to return to the Log Actions';
// Log actions MOD End

$lang['OverallPermissions'] = 'Overall Permissions';

// Addons

$lang['l_addon_main_page'] = 'Main Page setup';
$lang['l_addon_viewforum'] = 'Viewforum setup';
$lang['l_addon_viewtopic'] = 'Viewtopic setup';
$lang['l_addon_posting'] = 'Posting setup';
$lang['l_addon_profile'] = 'Profile setup';
$lang['l_addon_main'] = 'Addons setup';
$lang['l_google'] = 'Google search engine';
$lang['l_google_e'] = 'Setup forum to allow few search engine to indexed your board egg. Google';
$lang['l_restrictbbcode'] = 'BBCode for unregistered';
$lang['l_restrictbbcode_e'] = 'Allow or deny use bbode for unregistered users';
$lang['l_sql'] = 'PhpMyAdmin';
$lang['l_sql_e'] = 'Input here link to your PhpMyAdmin (Link in navigation menu';
$lang['l_button_b'] = 'Button bbcode [b]';
$lang['l_button_i'] = 'Button bbcode [i]';
$lang['l_button_u'] = 'Button bbcode [u]';
$lang['l_button_q'] = 'Button bbcode [Quote]';
$lang['l_button_c'] = 'Button bbcode [Code]';
$lang['l_button_l'] = 'Button bbcode [List]';
$lang['l_button_im'] = 'Button bbcode [Img]';
$lang['l_button_ur'] = 'Button bbcode [URL]';
$lang['l_button_ce'] = 'Button bbcode [Center]';
$lang['l_button_f'] = 'Button bbcode [Fade]';
$lang['l_button_s'] = 'Button bbcode [Scroll]';
$lang['l_button_hi'] = 'Button bbcode [Hide]';
$lang['l_color_box'] = 'JumpBox color';
$lang['l_size_box'] = 'JumpBox size';
$lang['l_glow_box'] = 'JumpBoxy Glow & Shadow';
$lang['l_freak'] = 'Buttons FrEaK & l33t';

$lang['l_logsip_e'] = 'Logging disably by default, you can enable it in Configuration menu. To logs working /admin/admin_logs.php permission must be to write: chmod 777 admin_logs.php';
$lang['l_logsip'] = 'Logs of connections';

$lang['Allow_custom_color'] = 'Allow Custom Username Color';
$lang['Allow_custom_color_explain'] = 'Posts needed before user can choose username color.';
$lang['l_allow_custom_color_view'] = 'Switch off the alterability only nick';
$lang['l_allow_custom_color_view_e'] = 'Users it will not can alter their colours. You will can it alter in admin panel';
$lang['Allow_custom_color_mod'] = 'Allow in relays moderators colours';
$lang['Allow_custom_color_mod_e'] = 'Allow in relays only moderators colours own nicks';
$lang['Allow_custom_rank_mod'] = 'Allow moderators on own titles';
$lang['Allow_custom_rank_mod_e'] = 'Allow only moderators on placing own titles';
$lang['Rank_title_e'] = 'If you want use name rank in the rank image and you want turn off rank name, just add before rank name: <b>-#</b> rank will not be visible';
$lang['Download_limits'] = 'Traffic';
$lang['Files'] = 'Files';
$lang['Limit_users'] = 'Traffic for users';
$lang['ipview'] = 'Moderators can see users IP';
$lang['show_badwords'] = 'Show original censored word administrators and moderators';
$lang['cstyles'] = 'Styles on main side?';
$lang['lstyles'] = 'The small belt includes on main side to quick change of styles of forum';
$lang['cstat'] = 'Statistics?';
$lang['lstat'] = 'It shows in headline of side, link to statistics';
$lang['cload'] = 'Loading?';
$lang['auto_date'] = 'Automatic change of date';
$lang['auto_date_e'] = 'The automatic change of date in time summer / winter';
$lang['cavatar'] = 'Avatar in headline?';
$lang['cavatar_e'] = 'When user be logged in, his avatar shows in headline';
$lang['clog'] = 'Logging hosts and IP';
$lang['clog_e'] = 'Do to log in hosty and addresses IP to file? (Attention! Should every now and then to control his size)';
$lang['lload'] = 'It after click on link shows "Page loading please wait"';
$lang['crefresh'] = 'Refresh?';
$lang['lrefresh'] = 'After change one\'s settings np. in profile after what to transfer time user on target side?';
$lang['cchat'] = 'Button of Chat in headline';
$lang['lchat'] = 'In headline of side, the button with link to chat';
$lang['clogin'] = 'Quick log in?';

$lang['cregist'] = 'Quick registration?';
$lang['lregist'] = 'When it logged in user on forum enters it shows at mountain of field to quick registration';
$lang['clogin_b'] = 'Below side ';
$lang['cchat2'] = 'Link to chat';
$lang['lchat2'] = 'Below side link to chat';
$lang['ccount'] = 'Hit counter';
$lang['lcount'] = 'It shows below the main side, hit counter';
$lang['cbirth'] = 'Birthday Info';
$lang['lbirth'] = 'Shows below main side there are birthdays today and in the closest days';
$lang['cpost'] = 'New posts';
$lang['lpost'] = 'It shows on main side, section in field of given section, how much new posts was written in data from your last visit';
$lang['ctop'] = 'New topics?';
$lang['ltop'] = 'It shows on main side, section in field of given section, how much new topicss was written in data from your last visit';
$lang['cfriend'] = 'Notify friend about this topic';
$lang['lfriend'] = 'In view of topic, shows the link "Notify friend about this topic"';
$lang['cage'] = 'Age user under avatar';
$lang['lage'] = 'Whether in view of topic, under the user\'s avatar, to show his Age ?';
$lang['cjoin'] = 'Joined Date user under avatar';
$lang['ljoin'] = 'Whether in view of topic, under the user\'s avatar, to show his Joined Date ?';
$lang['cfrom'] = 'Location under avatar';
$lang['lfrom'] = 'Whether in view of topic, under the user\'s avatar, to show where from is user?';
$lang['cposts'] = 'Number of posts under avatarem';
$lang['lposts'] = 'Do in view of topic, under the user\'s avatar, to show how much there posts?';
$lang['clevell'] = 'Level user under his avatar';
$lang['llevell'] = 'Whether in view of topic, under the user\'s avatar, to show his Level?';
$lang['cleveld'] = 'Level user under his post';
$lang['lleveld'] = 'Whether in view of topic, under buttons ( the profile, pw, email) to show user Level ?';
$lang['cglow'] = 'Glow and Shadow';
$lang['lglow'] = 'Whether to show during writing of answer and new topics, BBCode Glow and Shadow ? <b>Attention!</b> Give YES if you switched off Permin on BBCode';
$lang['lfreak'] = 'Whether to show during writing of answer and new topics, BBCode FrEaK i l33t?';
$lang['cignore'] = 'Button Ignore';
$lang['lignore'] = 'Show button to ignore users?';
$lang['lquick'] = 'Whether in view of topic to show below sides, field "Quick Reply" ?';
$lang['lgg'] = 'Whether in view of topic, to show as well as during registration the profile the Gadu-Gadu?';
$lang['csearch'] = 'Look for in this forum';
$lang['lsearch'] = 'Whether in view of list of topics to show field "Search For" ?';
$lang['newest'] = 'The title of topic the link to last read topic';
$lang['newest_e'] = 'If include, then the title of topic, it will be here into the link the topic, but you in place in what finished recently to read this topic (very comfortable).';
$lang['lllogin'] = 'Whether in users\' as well as view profile to show field "Date last log in" ?';
$lang['clevelp'] = 'Level user in profil';
$lang['llevelp'] = 'Whether in userprofile\'s to show him Level?';
$lang['licq'] = 'Whether during registration as well as edition of profile, to show the field "ICQ" ?';
$lang['lyahoo'] = 'Whether during registration as well as edition of profile, to show the field "YIM" ?';
$lang['lmsn'] = 'Whether during registration as well as edition of profile, to show the field "MSNM" ?';
$lang['ljob'] = 'Whether during registration as well as edition of profile, to show the field "Occupation" ?';
$lang['linter'] = 'Whether during registration as well as edition of profile, to show the field "Interests" ?';
$lang['lemail'] = 'Whether during registration as well as edition of profile, to show the field "Always show my e-mail address" ? (It be engaged significantly)';
$lang['lbbcode'] = 'Whether during registration as well as edition of profile, to show the field "Always allow BBCode" (It be engaged significantly)?';
$lang['lhtml'] = 'Whether during registration as well as edition of profile, to show the field "Always allow HTML" ?(It be engaged significantly)';
$lang['lsmiles'] = 'Whether during registration as well as edition of profile, to show the field "Always enable Smilies" ? (It be engaged significantly)';
$lang['cpppage'] = 'Posts, topics and popular in page';
$lang['lpppage'] = 'Whether during registration as well as edition of profile, to show the fields (Posts, topics and popular in page)?';
$lang['llang'] = 'Whether during registration as well as edition of profile, to show the field "Board Language" ?';
$lang['ltimezone'] = 'Whether during registration as well as edition of profile, to show the field "Timezone" ?';
$lang['ldatefor'] = 'Whether during registration as well as edition of profile, to show the field "Date Format" ?';
$lang['lbstyle'] = 'Whether during registration as well as edition of profile, to show the field "Board Style" ?';
$lang['no_post_count'] = 'No post count in forum';
$lang['no_post_count_explain'] = 'Forum IDs of forums you don\'t want users post to increase. Separate multiple forum IDs with commas';
$lang['modules'] = 'Location of modules';
$lang['modules_e'] = 'Portal be partite on three columns, in central news are in left and right modules. Following jumpbox permit to adapt, order, as well as side from which module will be.';
$lang['custom_body'] = 'Content of own menu';
$lang['custom_body_e'] = 'Write in HTML - at content of menu';
$lang['custom_name'] = 'Title of own menu';
$lang['custom_name_e'] = 'Write the title of menu';
$lang['rmodule'] = 'Right side portal';
$lang['lmodule'] = 'Left side portal';
$lang['clock'] = 'Clock';
$lang['custom_mod'] = 'Own menu';
$lang['custom_blank_mod'] = 'Own blank menu';
$lang['l_scroll_recent_topics'] = 'Scrool last topics';
$lang['l_portal_menu_a'] = 'Settlement of Menu';
$lang['album_pos'] = 'Settlement of Menu Last Picture';
$lang['l_quick_stats_a'] = 'The Settlement of graphic statistics';
$lang['l_links_a'] = 'Settlement of Menu Links';
$lang['l_search_a'] = 'Settlement of Menu Search';
$lang['l_stat_a'] = 'Settlement of Menu Quick statistics';
$lang['l_recent_topics_a'] = 'Settlement of Menu Last topics';
$lang['l_top_posters_a'] = 'Settlement of Menu Most Active users';
$lang['l_birthday_a'] = 'Settlement of Menu Today';
$lang['l_info_a'] = 'Settlement of Menu User Info';
$lang['l_login_a'] = 'Settlement of Menu Log in';
$lang['l_whoonline_a'] = 'Settlement of Menu Who is on forum';
$lang['l_chat_a'] = 'Settlement of Menu Chat';
$lang['l_register_a'] = 'Settlement of Menu Quick register';
$lang['l_links'] = 'Own links, in module Menu';
$lang['l_links_e'] = 'in order to link was visible, you have to pass the name of thin line and address. External address, np. www.onet.pl has to begin sie from http:it // that is http://www.onet.pl W different case link will show on: www.your.forum.com/www.onet.pl W case of files in catalogue of forum, we pass the file name only np. the statistics.php';
$lang['l_links1'] = 'Link to forum';
$lang['l_links2'] = 'Link to portal';
$lang['l_links3'] = 'Link to users list';
$lang['l_links4'] = 'Link Search';
$lang['l_links5'] = 'Link Groups';
$lang['l_links6'] = 'Link to profil';
$lang['l_links7'] = 'link Log in/Log out';
$lang['l_links8'] = 'Link Register';
$lang['l_links8_e'] = '';
$lang['l_blank_body_on'] = 'Own modules';
$lang['l_blank_body_on_e'] = 'It below field was found was to inscription in HTML - at own modules.';
$lang['body_header'] = 'Code HTML of own headline';
$lang['body_header_e'] = 'You in this field can write in HTML own headline, along with thin lines. You can give banner and all that it will come to your cephalad.';
$lang['none'] = 'turn off';
$lang['l_align_right'] = 'right';
$lang['l_align_center'] = 'center';
$lang['l_align_left'] = 'left';
$lang['custom_desc'] = 'Link name';
$lang['custom_address'] = 'Link address';
$lang['l_portal_on'] = 'Portal On-line';
$lang['l_link_logo'] = 'The logo of forum the link to portal';
$lang['l_own_header'] = 'Own headline of portal';
$lang['l_portal_on_e'] = 'You can write for portal your own headline, but if you will switch off, headline will be the same for forum.';
$lang['l_news_forum'] = 'Headline News';
$lang['l_body_news_forum'] = 'Own headline news';
$lang['l_body_news_forum_e'] = 'You can write for news your own headline';
$lang['l_meta_refresh'] = 'Refresh';
$lang['l_meta_refresh_e'] = 'Time after settings what side be becomes refreshed after change';
$lang['Meta_keywords'] = 'META Keywords';
$lang['Meta_keywords_explain'] = 'Keywords in tags HTML <META KEYWORDS>';
$lang['Meta_description'] = 'META Description';
$lang['Meta_description_explain'] = 'Description w tagach HTML <META DESCRIPTION>';
$lang['l_poll'] = 'Pool Menu';
$lang['Globalannounce'] = 'Global Announce';

$lang['Group_rank'] = 'Grouprank';
$lang['Group_rank_explain'] = 'Here you can say that this rank only can be used by the selected group. This rank is disabled, if this rank is a special rank.';
$lang['Group_Rank_special'] = 'Special- / Grouprank';
$lang['Group_rank_order'] = 'Grouprank order';
$lang['Group_rank_order_moved'] = 'Group moved successfully.';
$lang['Group_rank_order_alreay_moved'] = 'Group already moved.';
$lang['Group_rank_order_could_not_moved'] = 'These Group couldn\'t moved because it is already at the top / bottom.';
$lang['Group_rank_resynced'] = 'Grouporder was resynced succesfully.';
$lang['Group_rank_order_title'] = 'Groupranks - Order';
$lang['Group_rank_order_explain'] = 'If a user is a member of two or more groups with own groupranks, the grouprank of the group, witch is higher in this list, will be shown.';
$lang['calbum'] = 'Turn on the galleries of pictures';
$lang['l_address_whois'] = 'Address of check Whois';
$lang['l_address_whois_e'] = 'Pass the address of side according to. which it will be checked Whois. Remember in order to passing http://';
$lang['u_o_t_d'] = 'To show who today visited forum?';
$lang['posticon_a'] = 'Turn on emoticons of topics/posts';
$lang['GG_nr'] = 'Number of Gadu-Gadu';
$lang['GG_pass'] = 'Password to Gadu-Gadu';
$lang['Inactive_title'] = 'Inactive Users';
$lang['Deleted_user'] = 'User with ID No. #%d deleted';
$lang['Activate_title'] = 'Account Actions';
$lang['Reg_date'] = 'Joined';
$lang['Activate'] = 'Activate';
$lang['Action'] = 'Actions';
$lang['Waiting_1'] = '(awaits activation since %d day)';
$lang['Waiting_2'] = '(awaits activation since %d days)';
$lang['No_users'] = 'There is no user who awaits an activation.';
$lang['Total_member'] = '<b>%d</b> user awaits activation.';
$lang['Total_members'] = '<b>%d</b> users await activation.';

$lang['user_password_settings'] = 'User password settings';
$lang['Max_login_error'] = 'Block user on wrong log in';
$lang['Max_login_error_explain'] = 'If a user submit a wrong password, repeately, then the users account is blocked for a while, specify here how meny times vrong passwords are discarded before the users account is blocked'; 
$lang['Block_time'] = 'Block account time';
$lang['Block_time_explain'] = 'Number of minuttes, the users account are blocked, if a wrong password s submitted repeately more than specifyed in "Block user on wrong log in"';
$lang['Password_complex'] = 'Complex Password';
$lang['Password_complex_explain'] = 'Users password must consist of both alfa and numeric letters';
$lang['Password_len'] = 'Minimum password length';
$lang['Password_len_explain'] = 'Valid range is [ 1 - 32 ]';
$lang['Password_not_login'] = 'Password different from login';
$lang['Password_not_login_explain'] = 'Password are not accepted if they are the same as login username';

$lang['Account_block'] = 'Account block';
$lang['Account_block_explain'] = 'here you can view/set or reset users block information';
$lang['Block_until'] = 'Blocked until: %s';// %s is substituded with the date/time
$lang['Block_by'] = 'Blocked by IP: %s';// %s is substituded with the ip addr.
$lang['Last_block_by'] = 'Last blocked by IP: %s';// %s is substituded with the ip addr.
$lang['Unblock_user'] = 'Unblock user account';
$lang['Block_user'] = 'Block user account for %s min';// %s is substituded with the date/time
$lang['Badlogin_count'] = 'Number of bad log in';
$lang['l_require_aim'] = 'To require near registration GG';
$lang['l_require_website'] = 'To require near registration WWW';
$lang['l_require_location'] = 'To require near registration Location';
$lang['l_require_aim_e'] = 'You will give If YES, switch off on main side quick registration.';
$lang['l_require_website_e'] = 'You will give If YES, switch off on main side quick registration.';
$lang['l_require_location_e'] = 'You will give If YES, switch off on main side quick registration.';

$lang['BULM_Title'] = 'Advanced Banned User Manager';
$lang['BULM_Desc'] = 'This ACP Module allows you to view all currently banned users and sort them for Quick Reference. As well as ban new users if required.';
$lang['BULM_Edit_Title'] = 'Ban Editor';
$lang['BULM_Edit_Desc'] = 'This allows you to edit certain aspects of a ban.';
$lang['BULM_Functions'] = 'Functions';
$lang['BULM_ban_new_user'] = 'Ban New Users';
$lang['BULM_funban_explain'] = 'This allows you to unban Multiple members that have been marked above';
$lang['BULM_funban_txt'] = 'Unban Marked';
$lang['BULM_nobans'] = '<center><b>No Bans Where Found For this Sort Method.</b></center>';
$lang['BULM_reason'] = 'Reason';
$lang['BULM_reason_explain'] = 'Reason for banning member(s), email(s), ip address(s)<br /><b>Note:</b> This reason will be applied to all bans submitted. You can later edit induvidual bans reasons, but it is reccomended that you only ban 1 at a time if you are specifying a reason.<br /><br />HTML is On<br />bbcode is Off';
$lang['BULM_Update_Title'] = 'Update Ban Information';

$lang['BM_Show_bans_by'] = 'Shows bans';
$lang['BM_All'] = 'All';
$lang['BM_Show'] = 'Show';
$lang['BM_Banned'] = 'Banned';
$lang['BM_Expires'] = 'Expire';
$lang['BM_By'] = 'Banned by';
$lang['BM_Reasons'] = 'Reason';
$lang['BM_Add_a_new_ban'] = 'Add ban';
$lang['BM_Delete_selected_bans'] = 'Delete selected bans';
$lang['BM_Private_reason'] = 'Private reason';
$lang['BM_Private_reason_explain'] = 'Private reasons will shows only for admins';
$lang['BM_Public_reason'] = 'Public reason';
$lang['BM_Public_reason_explain'] = 'Public reason will be shows only banned users';
$lang['BM_Generic_reason'] = 'Default reason';
$lang['BM_Mirror_private_reason'] = 'Identically like Private reason';
$lang['BM_Other'] = 'Other/put below';
$lang['BM_Expire_time'] = 'Time expire';
$lang['BM_Expire_time_explain'] = 'You can decide when ban will expire.';
$lang['BM_Never'] = 'Never';
$lang['BM_After_specified_length_of_time'] = 'After:';
$lang['BM_Minutes'] = 'Minutes';
$lang['BM_Weeks'] = 'Weeks';
$lang['BM_Months'] = 'Months';
$lang['BM_Years'] = 'Years';
$lang['BM_After_specified_date'] = 'Or after date:';
$lang['BM_AM'] = 'AM';
$lang['BM_PM'] = 'PM';
$lang['BM_24_hour'] = '24-Hours';
$lang['Custom_fields'] = 'Profile fields';
$lang['post_footer'] = 'Turn off icons under post';
$lang['post_footer_e'] = 'This option hidden posts icon (Email, WWW, Profil, PM, AIM) but Quote, Edit stay.';
$lang['graphic'] = 'Text instead icons';
$lang['graphic_e'] = 'Replace PM, Profil, WWW, Cytuj, Edit icons with text';
$lang['shoutbox_on'] = 'ShoutBox on';
$lang['date_on'] = 'Show date';
$lang['sb_make_links'] = 'Make links';
$lang['sb_links_names'] = 'Username link to profile';
$lang['sb_allow_edit'] = 'Allow Administrators to edit messages';
$lang['sb_allow_edit_m'] = 'Allow Moderators to edit messages';
$lang['sb_allow_edit_all'] = 'Allow to edit own messages';
$lang['sb_allow_delete'] = 'Allow Administrators to delete messages';
$lang['sb_allow_delete_m'] = 'Allow Moderators to delete messages';
$lang['sb_allow_delete_all'] = 'Allow to delete own messages';
$lang['sb_allow_guest'] = 'Allow Quests to send messages';
$lang['sb_allow_guest_view'] = 'Shoutbox only visible for guests';
$lang['sb_allow_users'] = 'Allow registered users to send messages';
$lang['sb_allow_users_view'] = 'Shoutbox only visible for registered users';
$lang['delete_days'] = 'Amount of days after messages will be deleted';
$lang['sb_count_msg'] = 'Number of viewed messages';
$lang['sb_text_lenght'] = 'Max messages letters';
$lang['sb_word_lenght'] = 'Max word letters';
$lang['setup_shoutbox'] = 'Shoutbox Configuration';
$lang['shout_size'] = 'ShoutBox size';
$lang['sb_banned_send'] = 'Disallow send messages for user';
$lang['sb_banned_send_e'] = 'User IDs of users who can\'t send messages to ShoutBox. Separate multiple user IDs with commas, for example: <b>18, 124</b>';
$lang['sb_banned_view'] = 'Disallow ShoutBox for user';
$lang['sb_banned_view_e'] = 'User IDs of users who can\'t view and use ShoutBox. Separate multiple user IDs with commas, for example: <b>18, 124</b>';
$lang['color_mod'] = 'Moderator nickname color (eg. FF0000)';
$lang['color_admin'] = 'Administrator nickname color (eg. FF0000)';

$lang['max_sig_custom_rank'] = 'Max rank lenght';
$lang['max_sig_location'] = 'Max location lenght';
$lang['face_font'] = 'Font setup';
$lang['face_large_font'] = 'Large font';
$lang['face_small_font'] = 'Small font';
$lang['disallow_forums'] = 'Disallow write in forum';
$lang['disallow_forums_e'] = 'Disallow this user to send post/topics to selected forums, if mr that one, enter ID\'s separated by commas, for example:<b> 2, 6</b>';
$lang['can_custom_ranks'] = 'Allow own rank';
$lang['can_custom_color'] = 'Allow own color nick';
$lang['Signature_settings'] = 'Signature Settings';
$lang['Allow_sig_image'] = 'Allow signature images';
$lang['Max_sig_image_filesize'] = 'Maximum signature image filesize';
$lang['Max_sig_image_size'] = 'Maximum signature image dimensions';
$lang['Max_sig_image_size_explain'] = '(height x width in pixels)';
$lang['Sig_images_storage_path'] = 'Signature images storage path ';
$lang['Sig_images_storage_path_explain'] = 'Path under your phpBB root dir for pre-loaded images, e.g. images/signatures<br />Make sure it is world-writeable!';

$lang['hv_admin'] = 'Hide prewiew by admin topic';
$lang['hv_admin_e'] = 'When engaged, prewiew topic by admin it will not be counted';
$lang['he_admin'] = 'Hide by admin the edition of topic';
$lang['he_admin_e'] = 'When engaged, information about edition after edition of own topic by admin to fast it will not be added';
$lang['wv'] = 'Who view this topic';
$lang['wv_admin'] = 'Who looked through topic for admin and moderators only';
$lang['wv_admin_e'] = 'Link to view \'who looked this topic\' it will be only possible for administrators and moderators';
$lang['edit_time'] = 'Post Edit time'; 
$lang['edit_time_explain'] = 'The time (in minutes) the user has to edit his/her post. Setting this value to 0, the time is unlimited. Not concerning Administrators and Moderators';

$lang['group_count'] = 'Number of required posts';
$lang['group_count_explain'] = 'When users have posted more posts than this value <i>(in any forum)</i> then they will be added to this usergroup<br/> This only applys if "' . $lang['Group_count_enable'] . '" are enabled';
$lang['group_count_updated'] = '%d member(s) are now, members of this group';
$lang['Group_count_enable'] = 'Users automatic added when posting';
$lang['Group_count_update'] = 'Add/Update new users';
$lang['Group_count_delete'] = 'Delete/Update old users';

$lang['read_tracking'] = 'Tracking topics';
$lang['read_tracking_e'] = 'It includes tracking not read topics for every user, after he perusal topic it stops he to be appointed as read <br /> Attention!, function this is very comfortable treat near users peck (especially visitor forum seldom) a lot of places occupy in database. Average near 50 active users and totality 500 only schedule read_history in database occupies about 5 mb. To cleaning, fuction below.';
$lang['read_tracking_c'] = 'Cleaning read history';
$lang['read_tracking_c_e'] = 'In case the transfer of forum, or you can use the needs of "losing the weight the database" with this function to the wyczysci schedules read_history. After cleanout it every user will be dust appointed all topics as read.';
$lang['sort_methods'] = 'Blocked downwards';
$lang['sort_methods_e'] = 'After blocking (the lock the topic) he will be transferred on only pit the letters of topics';

$lang['l_gender'] = 'Users gender';
$lang['l_gender_e'] = 'Setting during registration and in profile users sex makes possible. Visible also the icon besidelognames in view of topic';
$lang['l_require_gender'] = 'To require during registration sex?';

$lang['Optimize_DB'] = 'Optimize Database';
$lang['Optimize'] = 'Optimize';
$lang['Optimize_explain'] = 'The elimination of data leaves in the database of the empty spaces, to eliminate these empty spaces is necessary to optimize database. Here it is possible to optimize the data in the tables of the database.';
$lang['Optimize_Table'] = 'Table';
$lang['Optimize_Record'] = 'Record';
$lang['Optimize_Type'] = 'Type';
$lang['Optimize_Size'] = 'Size';
$lang['Optimize_Status'] = 'Status';
$lang['Optimize_InvertChecked'] = 'Invert Checked';
$lang['Optimize_TableOptimized'] = 'Optimized Tables';
$lang['Optimize_success'] = 'Optimize databaze success';
$lang['Optimize_NoTableChecked'] = '<b>No</b> Table Checked';

//Nie ma czeskiego i slowackiego
$lang['SQL_Admin_No_Access'] = 'You dont have permission to access this menu.<br /><br />Click %sHERE%s to view details.';

$lang['day_to_prune'] = 'Days to prune posts';
$lang['day_to_prune_e'] = 'If you set 30 days, after 30 days information in the read tracking will be prune.<br />For large boards or if will be some problems with table phpbb_read_history and necessity synchronize forums i recommend decrease this value to 7 or 3 or disable this function';
$lang['banner_top'] = 'Overall header banner';
$lang['banner_top_e'] = 'You can include the headline banner of forum, it can then be with thin lines also own headline (code html)';
$lang['banner_bottom'] = 'Banner in copyright note of forum';
$lang['banner_bottom_e'] = 'You can include in copyright note of forum the banner, it can then be with thin lines also own copyright note (code html)';
$lang['header'] = 'Turn off original headline';
$lang['header_e'] = 'The original headline of forum switches off when we want to use only own headline ( headline banner with thin lines)';

$lang['Category_attachment'] = 'Attached to';
$lang['Category_desc'] = 'Description';
$lang['Category_config_error_fixed'] = 'An error in the category setup has been fixed';
$lang['Attach_forum_wrong'] = 'You can\'t attach a forum to a forum';
$lang['Attach_root_wrong'] = 'You can\'t attach a forum to the forum index';
$lang['Forum_name_missing'] = 'You can\'t create a forum without a name';
$lang['Category_name_missing'] = 'You can\'t create a category without a name';
$lang['Only_forum_for_topics'] = 'Topics can only be found in forums';
$lang['Delete_forum_with_attachment_denied'] = 'You can\'t delete forums having sub-levels';
$lang['Category_delete'] = 'Delete Category';
$lang['Category_delete_explain'] = 'The form below will allow you to delete a category and decide where you want to put all forums and categories it contained.';
$lang['Forum_link_url'] = 'Link URL';
$lang['Forum_link_url_explain'] = 'You can set here an URI to a phpBB prog, or a full URL to an external server.<br />Remember you must write http:// first.';
$lang['Forum_link_internal'] = 'phpBB prog';
$lang['Forum_link_internal_explain'] = 'Choose yes if you invoke a program that stands in the phpBB dirs';
$lang['Forum_link_hit_count'] = 'Hit count';
$lang['Forum_link_hit_count_explain'] = 'Choose yes if you want the board to count and display the number of hit using this link';
$lang['Forum_link_with_attachment_deny'] = 'You can\'t set a forum as a link if it has already sub-levels';
$lang['Forum_link_with_topics_deny'] = 'You can\'t set a forum as a link if it has already topics in';
$lang['Forum_attached_to_link_denied'] = 'You can\'t attach a forum or a category to a forum link';
$lang['Configuration_extend'] = 'Configuration +';
$lang['Override_user_choices'] = 'Override user choices';

$lang['not_edit_admin'] = 'Protect admin posts';
$lang['not_edit_admin_e'] = 'It turn on protect admins posts and polls, moderators can not delete or edit';
$lang['staff_enable'] = 'Enable view staff';
$lang['staff_forums'] = 'View forums';
$lang['l_smilies_value'] = 'Smilies amount';
$lang['l_smilies_value_e'] = 'In posting, values: <b>C</b>-columns, <b>R</b>-rows, <b>CW</b>-columns view all smilies';
$lang['l_generate_time'] = 'Generate page time';
$lang['mod_nick_color'] = 'Moderators nick color';
$lang['mod_nick_color_e'] = 'You can set the moderators nickname color. All setups nick color will be disable. Only admins will be able to set your nick color';
$lang['Warnings'] = 'Warnings for users';
$lang['mass_smilies_add'] = 'Mass add smilies from catalog';
$lang['mass_smilies_added'] = 'Add smilies from catalog';
$lang['Click_to_back_smilies'] = 'Smilies added: <b>%s</b><br /><br />Click %sHERE%s to return smilies management';
$lang['Enable_board_msg'] = 'Enable Board Message';
$lang['board_msg'] = 'Board Message'; 
$lang['board_msg_explain'] = 'Enter the message that you will show. Max. 255 characters (including HTML - tags)';
$lang['board_msg_index'] = 'Index ONLY';
$lang['board_msg_all'] = 'ALL pages';

$lang['width_forum'] = 'Set width forum';
$lang['width_forum_e'] = 'You can choose width your forum, value in pixels e.g: <b>900</b> You can set background color, border color e.g: <b>#FF2121</b> and border thickness';
$lang['width_table'] = 'Width table in pixels';
$lang['width_t	able'] = 'Forum width';
$lang['width_color'] = 'Color1, Color2, Border';
$lang['Resync_Stats'] = 'Synchronize';
$lang['Rebuild_search'] = 'Rebuild Search';
$lang['Rebuild_search_explain'] = 'Rebuilding the search table, will take a while but will increase the effectivness of the search function.';
$lang['Time_limit'] = 'Time limit';
$lang['Post_limit'] = 'Post limit';
$lang['Finished'] = 'Finished';
$lang['Refresh_rate'] = 'Refresh rate';
$lang['Percentage_complete'] = 'Percentage complete';
$lang['Resync_page_desc_simple'] = 'Welcome to the Resync Forum Statistics admin module addon. You are currently in <strong>simple mode</strong>. If you click the button below, this script will go through your database and set over; All your Forum\'s Topics and Posts counts as well as the last post made in a forum (as seen on the index), All Topic replies counts and the last post in each topic. If you would like to specify exactly which forums you want to resync and what exactly to resync, you should use the Advanced Mode.<br /><b>Before use this tool you should backup your database!</b>'; 
$lang['Resync_all_ask'] = 'Resync all forums and their topics?';
$lang['Resync_options'] = 'Resync Options';
$lang['Resync_forum_topics'] = 'Forum Topics Count';
$lang['Resync_forum_posts'] = 'Forum Posts Count';
$lang['Resync_forum_last_post'] = 'Forum Last Post';
$lang['Resync_topic_replies'] = 'Topic Replies Counts';
$lang['Resync_topic_last_post'] = 'Topic Last Posts';
$lang['Resync_question'] = 'Resync?';
$lang['Resync_do'] = 'Start Resync';
$lang['Resync_redirect'] = '<br /><br />Return to the <a href="%s">Resync Forum Statistics</a><br /><br />Return to the <a href="%s">Admin Index</a>.';
$lang['Resync_completed'] = 'Congratulations, your forum(s) and their topic(s) are now in sync!';
$lang['Resync_no_forums'] = 'You have no forums to be resynced!';
$lang['resume_rebuild'] = '<b>Attention!</b> exist before session of rebuilding, if you want resume it, click %sHERE%s If you want clear information about before rebuilding, click %sHERE%s (not recommend).';
$lang['value_not'] = 'Value: <b>%s</b> not set, check your query<br /><br />Click %sHERE%s to return';
$lang['confirm_clear'] = 'Values not set, you sure to clear this table ?';
$lang['cannot_execute'] = 'Can not execute: <b>%s</b><br /><br />Click %sHERE%s to return.';
$lang['execute_done'] = 'number queries: <b>%s</b><br /><br /><b>%s</b><br /><br />CLICK %sHERE%s to return.';
$lang['mysql_e'] = '<span style="color: red"><b>ATTENTION !!!</b></span> This tool is only for advanced users! Wrong use can failure your forum and database!<br />This tool allow you to mass change values in database SQL.<br />For example if you want change style for all users: choos in the USERS TABLE row, write new values in field and push EXECUTE. If you want change style selected group users (for example moderators) fill in fields: WHERE (user_level) = 2<br /><br /><b>Before use this tool you should backup your database!</b>';
$lang['users_table'] = 'Table prefix_users';
$lang['topics_table'] = 'Table prefix_topics';
$lang['posts_table'] = 'Table prefix_posts';
$lang['forums_table'] = 'Table prefix_forums';
$lang['do_query'] = 'Execute query/queries';
$lang['do_query_e'] = '<b>Attention</b>: You can use <b>;</b> to separate multiple queries.';
$lang['own_query'] = 'Own query';
$lang['deleting'] = 'Deleting from SQL';
$lang['column_in_table'] = 'Column in table';
$lang['new_value'] = 'new field value';
$lang['where_user_level'] = 'where e.g: <b>user_level</b>';
$lang['where_forum_id'] = 'where e.g: <b>forum_id</b>';
$lang['where_topic_id'] = 'where e.g: <b>topic_id</b>';
$lang['where_forum_status'] = 'where e.g: <b>forum_status</b>';
$lang['where_user_posts'] = 'where e.g: <b>user_posts</b>';
$lang['execute'] = 'execute';
$lang['column_in_table'] = 'Column in selected table';
$lang['delete_from_table'] = 'Delete from table';
$lang['optional'] = 'optional';
$lang['red_aft_reg'] = 'Redirect after register';
$lang['red_aft_reg_e'] = 'Redirect users after first log in to some address';
$lang['red_aft_address'] = 'Redirect address';
$lang['red_aft_address_e'] = 'Put here address (must add <b>http://</b> page to redirect users after registering, it can will be some address to topic of your forum';
$lang['rar_time'] = 'Time redirecting';
$lang['rar_time_e'] = 'Put here time for still redirecting, for right work it can not will be less than 10 seconds';
$lang['show_rules'] = 'Show rules befor registering';
$lang['gentime_admin'] = 'Time generated for admins only';
$lang['access_title'] = 'Permission SQL`a';
$lang['access_explain'] = 'With security reason acces do SQL menu is only for selected main admins.<br />If you dont have access and you think that is wrong, tell it to main admin.<br />If you are main admin you can add new main admins added with ID`s, if you dont know what that mean, dont think about SQL for security your forum :><br />If you are added admin, bottom is form to change lists admins, if you are main admin and dont see this form, click %s<b>HERE</b>%s you will be able to choose your id (default is 2) as main, and you will can add new lists admins.<br /><span style="color: red"><b>Remember</b></span> after add your ID change name or delete <b>/admin/main_admin.php</b> if not your admins will be able to remove you and add yours ID.';
$lang['list_admin'] = 'Lists main admins';
$lang['admin_list_e'] = 'ID`s added admins';
$lang['change_list'] = 'Write new lists (ID`s separate with comma)';
$lang['change_main_admin'] = 'Your ID';
$lang['email_return_path'] = 'Return email';
$lang['email_from'] = 'Reply to';
$lang['IPSearch_Search_by_IP'] = 'Search by IP Address';
$lang['IPSearch_Enter_IP'] = 'Enter an IP Address';
$lang['IPSearch_Search_Results'] = 'IP Address Search Results';
$lang['IPSearch_Enter_an_IP'] = 'Please go back and enter an IP Address.';
$lang['IPSearch_Again'] = 'Search Again?';
$lang['smiley_del_all_success'] = 'All smilies deleted';
$lang['dell_all_smilies'] = 'Delete all smilies !';
$lang['l_poster_posts'] = 'Mark topics if you post in it';
$lang['l_poster_posts_e'] = 'Before topic title add mark if user take part in this thread, on mouse over display hom many post he posting in this thread';
$lang['can_topic_color'] = 'Allow use topic color';
$lang['topic_color_all'] = 'Topic color for all';
$lang['topic_color_mod'] = 'Topic color for moderators';
$lang['conf_conf'] = 'Setting';
$lang['conf_config'] = 'Main';
$lang['conf_addons'] = 'Additional';
$lang['conf_main_page'] = 'Main page';
$lang['conf_viewtopic'] = 'View topic';
$lang['conf_profile'] = 'Profile';
$lang['conf_posting'] = 'Posting';
$lang['ignore_topics'] = 'Ignore topics';
$lang['allow_img_bbcode'] = 'Disallow [IMG] bbcode in signatures';
$lang['allow_img_bbcode_e'] = 'Disallowing using [IMG] in the signatures, users can upload own signature images with restriction to the size, settings below';
$lang['Uninstall18'] = 'Uninstall v.1.9';
$lang['uninstall_explain'] = 'Here you can uninstall my modification and restore your phpBB 2.0.x<br />First step you may restore SQL database here second step you may restore your phpBB 2.0.x originall files without \'images\' directory and <b>config.php</b> file.';
$lang['Uninstall'] = 'Uninstall';
$lang['confirm_uninstall'] = 'Are you sure to uninstall?';
$lang['uninstall_end'] = '<span class="nav"><b>Uninstall result:</b></span><br /><span class="gensmall">If all queries are blue it mean deinstall succeed, try to delete all additionall files from my modification</span>';
$lang['query_executed'] = 'Query execute';
$lang['query_not_executed'] = 'Query not execute';
$lang['Uaktualnienia'] = 'Updates';

$lang['Report_post'] = 'Report post';
$lang['Report_config_updated'] = 'The settings of the report post hack are updated successfully.';
$lang['Click_return_report_config'] = 'Click %sHere%s to return to the report post hack configuration.';
$lang['Click_return_report_auth'] = 'Click %sHere%s to return to the report post hack permissions.';
$lang['Click_return_report_auth_select'] = 'Click %shere%s to return to the report post hack permissions select.';
$lang['Report_config'] = 'Report post hack - Configuration';
$lang['Report_config_explain'] = 'Here you can customize all settings.';
$lang['Report_popup_size'] = 'Popup size';
$lang['Report_popup_size_explain'] = 'Here you can edit the height and width the size of report popup ( in pixel )';
$lang['Report_popup_links_target'] = 'Popup target';
$lang['Report_popup_links_target_explain'] = 'Here you can customize in witch window the links in the report popup should be shown';
$lang['Report_only_admin'] = 'Only for admins';
$lang['Report_only_admin_explain'] = 'If you activate this option, only admin receive the reports';
$lang['Report_no_guests'] = 'Allow no Guests';
$lang['Report_no_guests_explain'] = 'If you activate this option, only registered users can report posts';
$lang['Report_popup_links_target_0'] = 'Open in one new window';
$lang['Report_popup_links_target_1'] = 'Open each in a new window';
$lang['Report_popup_links_target_2'] = 'Open in a already opened window';
$lang['No_group_specified'] = 'No group(s) specified';
$lang['Report_already_auth'] = 'This users / group can\'t be added because he / it is already added.';
$lang['Report_auth_field_explain'] = 'You can spectify multiple users in one go using the appropriate combination of mouse and keyboard for your computer and browser';
$lang['Report_permissions_explain'] = 'Here you can lock the report function for special users or disable the reporting of post from special users.';
$lang['Report_no_auth'] = 'Forbid selected users to report';
$lang['Report_disable'] = 'Disable the reporting of post from special users';
$lang['Report_post_disable'] = 'Disable Report posts';
$lang['del_email_not'] = 'Notify user via e-mail about delete accout';
$lang['Prune_users'] = 'Prune users'; 
$lang['Acat'] = 'Category: Add';
$lang['Ecat'] = 'Category: Edit';
$lang['Dcat'] = 'Category: Delete';
$lang['Rcat'] = 'Category: Reorder';
$lang['Afile'] = 'File: Add';
$lang['Efile'] = 'File: Edit';
$lang['Dfile'] = 'File: Delete';
$lang['Afield'] = 'Custom Field: Add';
$lang['Efield'] = 'Custom Field: Edit';
$lang['Dfield'] = 'Custom Field: Delete';
$lang['Alicense'] = 'License: Add';
$lang['Elicense'] = 'License: Edit';
$lang['Dlicense'] = 'License: Delete';
$lang['Fchecker'] = 'File: Maintenance';
$lang['Repair'] = 'Repair';
$lang['read_tracking_r'] = 'Repair table read_history';
$lang['read_tracking_r_e'] = 'This is very "dynamically" table, can crashed, use this function to repair table read_history';
$lang['cookie_warning'] = 'ATTENTION ! Server Name (' . $board_config['server_name'] . ') is different with Cookie Domain (' . $board_config['cookie_domain'] . ') it will can cause problems.';
$lang['wrong_config_parametr'] = 'Cookie Domain or Server Name can not contain <b>http://</b> !';
$lang['Birthday_explain'] = 'The syntax used is %s, e.g. %s, remember prefixed zeros';
$lang['cgg'] = 'Gadu-Gadu';
$lang['cfreak'] = 'FrEaK & l33t';
$lang['cyahoo'] = 'Yahoo Messenger';
$lang['cmsn'] = 'MSN Messenger';
$lang['Rules_title'] = 'Action : %s';
$lang['Locking_topic'] = 'Locking a topic';
$lang['Unlocking_topic'] = 'Unlocking a topic';
$lang['Spliting_topic'] = 'Splitting a topic';
$lang['Moving_topic'] = 'Moving a topic';
$lang['Deleting_topic'] = 'Deleting a topic';
$lang['Editing_topic'] = 'Editing a topic';
$lang['Lock_Explication'] = 'When a Moderator/Administrator lock a topic, it\'s not possible for a normal user to reply. But Moderators/Administrators can still continue to post.';
$lang['Unlock_Explication'] = 'A Moderator/Administrator can unlock a topic which have been lock. This will allow all users to continue to post in the thread.';
$lang['Split_Explication'] = 'Splitting a topic whci have a lot of page gives you the possibility to keep your topics more organized.';
$lang['Move_Explication'] = 'If you choose to move a topic, you will be able to send a topic, which is in a forum A, to a forum B. You can also choose to use a Shadow Topic in the forum A.';
$lang['Delete_Explication'] = 'If a Moderator/Administrator, the topic will no longer be display on the forum and nobdy will be able to restore it. <br /><b>Be careful with this function</b>';
$lang['Edit_Explication'] = 'By editing a post, an Administratr and/or a Moderator can change what a user have written in the post.';
$lang['No_action_specified'] = 'There is no action specified';
$lang['Photo_storage_path'] = 'Photo Storage Path';
$lang['Photo_storage_path_explain'] = 'Path under your phpBB root dir, e.g. images/photos';
$lang['Allow_photo_upload'] = 'Enable photo uploading';
$lang['Photo_max_filesize'] = 'Maximum Photo File Size';
$lang['Photo_max_filesize_explain'] = 'For uploaded profile photos';
$lang['Max_photo_size'] = 'Maximum Photo Dimensions';
$lang['Profile_photo_settings'] = 'Profile Photo Settings';
$lang['Allow_photo_remote'] = 'Enable remote profile photos';
$lang['Allow_photo_remote_explain'] = 'Photos linked to from another website';
$lang['Forum_link'] = 'Link redirection';

$lang['last_visitors_time_e'] = 'Time in hours to view last users logged in.';
$lang['max_sig_chars_admin_e'] = 'It multiply value of max signature chars for admin';
$lang['max_sig_chars_mod_e'] = 'It multiply value of max signature chars for moderator';
$lang['viewonline_e'] = 'Restrict change viewonline for users: 0 - user can set, 1 - only visible, 2 - only invisible';
$lang['restrict_smilies'] = 'Restrict smilies for not logged in users';
$lang['topic_preview'] = 'Topic review';
$lang['not_anonymous_posting_e'] = 'Require set nickname for not logged in users when posting';
$lang['not_anonymous_quickreply'] = 'Hide quick reply for anonymous users';
$lang['l_expire_v'] = 'Value 2 expire days in the QuickReply';
$lang['l_expire_v_e'] = 'If disable will not show.';
$lang['max_smilies'] = 'Value of smilies in the quick reply';
$lang['portal_link'] = 'Portal link';
$lang['portal_link_e'] = 'If forum is portal or poll portal forum, link to main page redirect at portal';
$lang['search_enable'] = 'Enable "Search"';
$lang['search_enable_e'] = 'You can disable/enable search. When someone posting words will not add to search table. It is for small quota database';
$lang['overlib'] = 'Enable dynamicly OnMouseOver Overlib effect';
$lang['topic_start_date'] = 'Enable topic start date';
$lang['topic_start_dateformat'] = 'Dateformat for topic start date';
$lang['topic_start_dateformat_e'] = 'Leave blank for use forum dateformat';
$lang['all_time_ban_check'] = 'Effectively banning not logged in users';
$lang['all_time_ban_check_e'] = '';
$lang['autorepair_tables'] = 'Autorepair tables';
$lang['autorepair_tables_e'] = 'If some tables will crach, it try to repair it and send email to administrator';
$lang['check_address'] = 'Check connect address';
$lang['check_address'] = 'It check address for identical with board config cookies settings';
$lang['echange_banner'] = 'Echange banners';
$lang['echange_banner_e'] = 'Echange banner mod values 0-6.<br />0 Banner disable, 1 - Footer banner, 2 - Banner on the top main index, 3 - Banner under menu, 4 - Banner bottom of the main index, 5 - Banner footer, 6 - echange with index avatar in the corner';
$lang['echange_banner_html'] = 'Put here HTML code for echange banners, separate multiple banners html code with: <b>[banner]</b><br />Example: <b>&lt;table&gt;First banner&lt;/table&gt;[banner]&lt;table&gt;Second banner&lt;/table&gt;</b>';
$lang['split_messages'] = 'Split double messages';
$lang['split_messages_e'] = 'Merges post text on posting to the last message in topic instead of adding a new one';
$lang['split_messages_admin'] = 'Split admin\'s posts';
$lang['split_messages_mod'] = 'Split moderator\'s posts';
$lang['split_messages_except'] = 'Except split in forums';
$lang['split_messages_except'] = 'Except forums for non split posts, enter their ID\'s separated by commas. Example: <b>2, 7</b>';
$lang['admin_html'] = 'Allow HTML for Admin\'s';
$lang['admin_html_e'] = 'You can allow all html tags for Admin\'s. Forum setup will be ignored';
$lang['jr_admin_html'] = 'Allow HTML for JuniorAdmin\'s';
$lang['mod_html'] = 'Allow HTML for Moderator\'s';
$lang['lastvisit_days'] = 'Lastvisit readtracking';
$lang['lastvisit_days_e'] = 'Last visit back read tracking. Days value';
$lang['notify_gg'] = 'Notify GG';
$lang['notify_gg_e'] = 'If set number and password GG you can enable GG notify users';
$lang['admin_notify_gg'] = 'Admin notify GG';
$lang['admin_notify_gg_e'] = 'Here you can set your GG number(s), you will notify if new topics will posting, more than one number separate with comma';
$lang['admin_notify_reply'] = 'Admin Notify reply';
$lang['admin_notify_reply_e'] = 'Here you can set notify about all new posts';
$lang['admin_notify_message'] = 'All messages in GG notify';
$lang['admin_notify_message_e'] = '';
$lang['Download2'] = 'Download';
$lang['helped_a'] = 'Helped points';
$lang['helped_e'] = 'Enable "Helped" points. Topic author, will can add "Helped" point for user who post reply in your topic.';
$lang['helped_forums'] = 'Inactive in forums with ID\'s:';
$lang['User_allow_helped'] = 'Allow "Helped" points';
$lang['User_allow_helped_e'] = 'Allow or disallow using "Helped" button. Hide value of "Helped" points which obtain this user';
$lang['Admin_notepad'] = 'Admin Notepad';
$lang['confirm_deluser'] = 'Are you sure to delete this user ?';
$lang['l_del_not_method'] = 'Notify method';
$lang['l_del_not_enable'] = 'Notify when post / topic will delete';
$lang['l_del_not_choice'] = 'Administrators and Moderators can choice delete without notify';
$lang['Donation'] = '<b>Make a donation<br />to the author</b>';
$lang['l_open_in_windows'] = 'Open all links in new windows';
$lang['l_open_in_windows_e'] = '';
$lang['Forum_moderate'] = 'Moderate forum';
$lang['Modules_title'] = 'Admin Modules';
$lang['Modules_explain'] = 'You can choise which admin modules you want to use.';
$lang['Modules_add_explain'] = '';
$lang['All_modules'] = 'All modules';
$lang['Custom_modules'] = 'Custom modules';
$lang['Prune_explain'] = 'Will not remove topics with poll or topics mark as: announce, sticky.';
$lang['No_count'] = 'No count posts';
$lang['Forums_shadow'] = 'Forums not associated to exists category';
$lang['Wrong_category'] = 'Wrong category';
$lang['All_forums'] = 'all forums and category';
$lang['Reset_modules'] = 'Set defaultadmin modules';
$lang['quick_reply_pages'] = 'Quick reply only on last page';
$lang['clog_post'] = 'Log all $_POST variables';
$lang['log_file_limit_info'] = 'Log file <b>/admin/admin_logs.'.$phpEx.'</b> is too big (%sMb) to open in browser.<br /><br />File was compressed to: <b>%s</b><br /><br />Click %sHere%s to get it.<br /><br />After downloading you need to remove the file from FTP.';
$lang['log_file_limit_error1'] = 'Error in openning: <b>%s</b>';
$lang['log_file_limit_error2'] = 'Error in save compressedfile: <b>%s</b>';

//
// That's all Folks!
// -------------------------------------------------

?>