<?php
/***************************************************************************
 *                            lang_main.php [English]
 *                              -------------------
 *     begin                : Sat Dec 16 2000
 *     copyright            : (C) 2001 The phpBB Group
 *     email                : support@phpbb.com
 *     modification			: (C) 2003 Przemo http://www.przemo.org
 *     date modification	: ver. 1.9 2004/04/15 21:00
 *
 *     $Id: lang_main.php,v 1.85.2.15 2003/06/10 00:31:19 psotfx Exp $
 *
 ****************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 ***************************************************************************/

//
// CONTRIBUTORS:
//	 Add your details here if wanted, e.g. Name, username, email address, website
// 2002-08-27  Philip M. White        - fixed many grammar problems
//

//
// The format of this file is ---> $lang['message'] = 'text';
//
// You should also try to set a locale and a character encoding (plus direction). The encoding and direction
// will be sent to the template. The locale may or may not work, it's dependent on OS support and the syntax
// varies ... give it your best guess!
//

$lang['ENCODING'] = 'iso-8859-1';
$lang['DIRECTION'] = 'ltr';
$lang['LEFT'] = 'left';
$lang['RIGHT'] = 'right';
$lang['DATE_FORMAT'] = 'd M Y'; // This should be changed to the default date format for your language, php date() format

// This is optional, if you would like a _SHORT_ message output
// along with our copyright message indicating you are the translator
// please add it here.
// $lang['TRANSLATION'] = '';

//
// Common, these terms are used
// extensively on several pages
//
$lang['Forum'] = 'Forum';
$lang['Category'] = 'Category';
$lang['Topic'] = 'Topic';
$lang['Topics'] = 'Topics';
$lang['Replies'] = 'Replies';
$lang['Views'] = 'Views';
$lang['Post'] = 'Post';
$lang['Posts'] = 'Posts';
$lang['Posted'] = 'Posted';
$lang['Username'] = 'Username';
$lang['Password'] = 'Password';
$lang['Email'] = 'Email';
$lang['Poster'] = 'Poster';
$lang['Author'] = 'Author';
$lang['Time'] = 'Time';
$lang['Hours'] = 'Hours';
$lang['Message'] = 'Message';

$lang['1_Day'] = '1 Day';
$lang['7_Days'] = '7 Days';
$lang['2_Weeks'] = '2 Weeks';
$lang['1_Month'] = '1 Month';
$lang['3_Months'] = '3 Months';
$lang['6_Months'] = '6 Months';
$lang['1_Year'] = '1 Year';

$lang['Go'] = 'Go';
$lang['Jump_to'] = 'Jump to';
$lang['Submit'] = 'Submit';
$lang['Reset'] = 'Reset';
$lang['Cancel'] = 'Cancel';
$lang['Preview'] = 'Preview';
$lang['Confirm'] = 'Confirm';
$lang['Yes'] = 'Yes';
$lang['No'] = 'No';
$lang['Enabled'] = 'Enabled';
$lang['Disabled'] = 'Disabled';
$lang['Error'] = 'Error';

$lang['Next'] = 'Next';
$lang['Previous'] = 'Previous';
$lang['Goto_page'] = 'Goto page';
$lang['Joined'] = 'Joined';
$lang['IP_Address'] = 'IP Address';

$lang['Select_forum'] = 'Select a forum';
$lang['View_latest_post'] = 'View latest post';
$lang['View_newest_post'] = 'View newest post';
$lang['Page_of'] = 'Page <b>%d</b> of <b>%d</b>'; // Replaces with: Page 1 of 2 for example

$lang['ICQ'] = 'ICQ Number';
$lang['AIM'] = 'Number Gadu-Gadu';
$lang['MSNM'] = 'MSN Messenger';
$lang['YIM'] = 'Yahoo Messenger';

$lang['Forum_Index'] = '%s Forum Index'; // eg. sitename Forum Index, %s can be removed if you prefer

$lang['Post_new_topic'] = 'Post new topic';
$lang['Reply_to_topic'] = 'Reply to topic';
$lang['Reply_with_quote'] = 'Reply with quote';

$lang['Click_return_topic'] = 'Click %sHere%s to return to the topic'; // %s's here are for uris, do not remove!
$lang['Click_return_login'] = 'Click %sHere%s to try again';
$lang['Click_return_forum'] = 'Click %sHere%s to return to the forum';
$lang['Click_view_message'] = 'Click %sHere%s to view your message';
$lang['Click_return_modcp'] = 'Click %sHere%s to return to the Moderator Control Panel';
$lang['Click_return_group'] = 'Click %sHere%s to return to group information';

$lang['Admin_panel'] = 'Go to Administration Panel';

$lang['Board_disable'] = 'Sorry, but this board is currently unavailable. Please try again later';


//
// Global Header strings
//
$lang['Registered_users'] = 'Registered Users:';
$lang['Browsing_forum'] = 'Users browsing this forum:';
$lang['Online_users_zero_total'] = 'In total there are <b>0</b> users online :: ';
$lang['Online_users_total'] = 'In total there are <b>%d</b> users online :: ';
$lang['Online_user_total'] = 'In total there is <b>%d</b> user online :: ';
$lang['Reg_users_zero_total'] = '0 Registered, ';
$lang['Reg_users_total'] = '%d Registered, ';
$lang['Reg_user_total'] = '%d Registered, ';
$lang['Hidden_users_zero_total'] = '0 Hidden and ';
$lang['Hidden_user_total'] = '%d Hidden and ';
$lang['Hidden_users_total'] = '%d Hidden and ';
$lang['Guest_users_zero_total'] = '0 Guests';
$lang['Guest_users_total'] = '%d Guests';
$lang['Guest_user_total'] = '%d Guest';
$lang['Record_online_users'] = 'Most users ever online was <b>%s</b> on %s'; // first %s = number of users, second %s is the date.

$lang['Admin_online_color'] = '%sAdministrator%s';
$lang['Mod_online_color'] = '%sModerator%s';

$lang['You_last_visit'] = 'You last visited on %s'; // %s replaced by date/time
$lang['Current_time'] = 'The time now is %s'; // %s replaced by time

$lang['Search_new'] = 'View posts since last visit';
$lang['Search_your_posts'] = 'View your posts';
$lang['Search_unanswered'] = 'View unanswered posts';

$lang['Register'] = 'Register';
$lang['Profile'] = 'Profile';
$lang['Edit_profile'] = 'Edit your profile';
$lang['Search'] = 'Search';
$lang['Memberlist'] = 'Memberlist';
$lang['FAQ'] = 'FAQ';
$lang['BBCode_guide'] = 'BBCode Guide';
$lang['Usergroups'] = 'Usergroups';
$lang['Last_Post'] = 'Last Post';
$lang['Moderator'] = 'Moderator';
$lang['Moderators'] = 'Moderators';


//
// Stats block text
//
$lang['Posted_articles_zero_total'] = 'Our users have posted a total of <b>0</b> articles'; // Number of posts
$lang['Posted_articles_total'] = 'Our users have posted a total of <b>%d</b> articles'; // Number of posts
$lang['Posted_article_total'] = 'Our users have posted a total of <b>%d</b> article'; // Number of posts
$lang['Registered_users_zero_total'] = 'We have <b>0</b> registered users'; // # registered users
$lang['Registered_users_total'] = 'We have <b>%d</b> registered users'; // # registered users
$lang['Registered_user_total'] = 'We have <b>%d</b> registered user'; // # registered users
$lang['Newest_user'] = 'The newest registered user is <b>%s%s%s</b>'; // a href, username, /a 

$lang['No_new_posts_last_visit'] = 'No new posts since your last visit';
$lang['No_new_posts'] = 'No new posts';
$lang['New_posts'] = 'New posts';
$lang['New_post'] = 'New post';
$lang['No_new_posts_hot'] = 'No new posts [ Popular ]';
$lang['New_posts_hot'] = 'New posts [ Popular ]';
$lang['No_new_posts_locked'] = 'No new posts [ Locked ]';
$lang['New_posts_locked'] = 'New posts [ Locked ]';
$lang['Forum_is_locked'] = 'Forum is locked';


//
// Login
//
$lang['Enter_password'] = 'Please enter your username and password to log in.';
$lang['Login'] = 'Log in';
$lang['Logout'] = 'Log out';

$lang['Forgotten_password'] = 'I forgot my password';

$lang['Log_me_in'] = 'Log me on automatically each visit';

$lang['Error_login'] = 'You have specified an incorrect or inactive username, or an invalid password.';


//
// Index page
//
$lang['Index'] = 'Index';
$lang['No_Posts'] = 'No Posts';
$lang['No_forums'] = 'This board has no forums';

$lang['Private_Message'] = 'Private Message';
$lang['Private_Messages'] = 'Private Messages';
$lang['Who_is_Online'] = 'Who is Online';

$lang['Mark_all_forums'] = 'Mark all forums read';
$lang['Forums_marked_read'] = 'All forums have been marked read';


//
// Viewforum
//
$lang['View_forum'] = 'View Forum';

$lang['Forum_not_exist'] = 'The forum you selected does not exist.';

$lang['Display_topics'] = 'Display topics from previous';
$lang['All_Topics'] = 'All Topics';

$lang['Topic_Announcement'] = '<b>Announcement:</b>';
$lang['Topic_Sticky'] = '<b>Sticky:</b>';
$lang['Topic_Moved'] = '<b>Moved:</b>';
$lang['Topic_Poll'] = '<b>[ Poll ]</b>';

$lang['Mark_all_topics'] = 'Mark all topics read';
$lang['Topics_marked_read'] = 'The topics for this forum have now been marked read';

$lang['Rules_post_can'] = 'You <b>can</b> post new topics in this forum';
$lang['Rules_post_cannot'] = 'You <b>cannot</b> post new topics in this forum';
$lang['Rules_reply_can'] = 'You <b>can</b> reply to topics in this forum';
$lang['Rules_reply_cannot'] = 'You <b>cannot</b> reply to topics in this forum';
$lang['Rules_edit_can'] = 'You <b>can</b> edit your posts in this forum';
$lang['Rules_edit_cannot'] = 'You <b>cannot</b> edit your posts in this forum';
$lang['Rules_delete_can'] = 'You <b>can</b> delete your posts in this forum';
$lang['Rules_delete_cannot'] = 'You <b>cannot</b> delete your posts in this forum';
$lang['Rules_vote_can'] = 'You <b>can</b> vote in polls in this forum';
$lang['Rules_vote_cannot'] = 'You <b>cannot</b> vote in polls in this forum';
$lang['Rules_moderate'] = 'You <b>can</b> %smoderate this forum%s'; // %s replaced by a href links, do not remove! 

$lang['No_topics_post_one'] = 'There are no posts in this forum.<br />Click on the <b>Post New Topic</b> link on this page to post one.';


//
// Viewtopic
//
$lang['View_topic'] = 'View topic';

$lang['Guest'] = 'Guest';
$lang['Post_subject'] = 'Post subject';
$lang['View_next_topic'] = 'Next topic';
$lang['View_previous_topic'] = 'Previous topic';
$lang['Submit_vote'] = 'Submit Vote';
$lang['View_results'] = 'View Results';

$lang['No_newer_topics'] = 'There are no newer topics in this forum';
$lang['No_older_topics'] = 'There are no older topics in this forum';
$lang['Topic_post_not_exist'] = 'The topic or post you requested does not exist';
$lang['No_posts_topic'] = 'No posts exist for this topic';

$lang['Display_posts'] = 'Display posts from previous';
$lang['All_Posts'] = 'All Posts';
$lang['Newest_First'] = 'Newest First';
$lang['Oldest_First'] = 'Oldest First';

$lang['Back_to_top'] = 'Back to top';

$lang['Read_profile'] = 'View user\'s profile';
$lang['Send_email'] = 'Send e-mail to user';
$lang['Visit_website'] = 'Visit poster\'s website';
$lang['ICQ_status'] = 'ICQ Status';
$lang['Edit_delete_post'] = 'Edit/Delete this post';
$lang['View_IP'] = 'View IP address of poster';
$lang['Delete_post'] = 'Delete this post';

$lang['wrote'] = 'wrote'; // proceeds the username and is followed by the quoted text
$lang['Quote'] = 'Quote'; // comes before bbcode quote output.
$lang['Code'] = 'Code'; // comes before bbcode code output.

$lang['Edited_time_total'] = 'Last edited by %s on %s; edited %d time in total'; // Last edited by me on 12 Oct 2001; edited 1 time in total
$lang['Edited_times_total'] = 'Last edited by %s on %s; edited %d times in total'; // Last edited by me on 12 Oct 2001; edited 2 times in total

$lang['Lock_topic'] = 'Lock this topic';
$lang['Unlock_topic'] = 'Unlock this topic';
$lang['Move_topic'] = 'Move this topic';
$lang['Delete_topic'] = 'Delete this topic';
$lang['Split_topic'] = 'Split this topic';

$lang['Stop_watching_topic'] = 'Stop watching this topic';
$lang['Start_watching_topic'] = 'Watch this topic for replies';
$lang['No_longer_watching'] = 'You are no longer watching this topic';
$lang['You_are_watching'] = 'You are now watching this topic';

$lang['Total_votes'] = 'Total Votes';

//
// Posting/Replying (Not private messaging!)
//
$lang['Message_body'] = 'Message body';
$lang['Topic_review'] = 'Topic review';

$lang['No_post_mode'] = 'No post mode specified';

$lang['Post_a_new_topic'] = 'Post a new topic';
$lang['Post_a_reply'] = 'Post a reply';
$lang['Post_topic_as'] = 'Post topic as';
$lang['Edit_Post'] = 'Edit post';
$lang['Options'] = 'Options';

$lang['Post_Announcement'] = 'Announcement';
$lang['Post_Sticky'] = 'Sticky';
$lang['Post_Normal'] = 'Normal';

$lang['Confirm_delete'] = 'Are you sure you want to delete this post?';
$lang['Confirm_delete_poll'] = 'Are you sure you want to delete this poll?';

$lang['Flood_Error'] = 'You cannot make another post so soon after your last; please try again in a short while.';
$lang['Empty_subject'] = 'You must specify a subject when posting a new topic.';
$lang['Empty_message'] = 'You must enter a message when posting.';
$lang['Forum_locked'] = 'This forum is locked: you cannot post, reply to, or edit topics.';
$lang['Topic_locked'] = 'This topic is locked: you cannot edit posts or make replies.';
$lang['No_post_id'] = 'You must select a post to edit';
$lang['No_topic_id'] = 'You must select a topic to reply to';
$lang['No_valid_mode'] = 'You can only post, reply, edit, or quote messages. Please return and try again.';
$lang['No_such_post'] = 'There is no such post. Please return and try again.';
$lang['Edit_own_posts'] = 'Sorry, but you can only edit your own posts.';
$lang['Delete_own_posts'] = 'Sorry, but you can only delete your own posts.';
$lang['Cannot_delete_replied'] = 'Sorry, but you may not delete posts that have been replied to.';
$lang['Cannot_delete_poll'] = 'Sorry, but you cannot delete an active poll.';
$lang['Empty_poll_title'] = 'You must enter a title for your poll.';
$lang['To_few_poll_options'] = 'You must enter at least two poll options.';
$lang['To_many_poll_options'] = 'You have tried to enter too many poll options.';
$lang['Post_has_no_poll'] = 'This post has no poll.';
$lang['Already_voted'] = 'You have already voted in this poll.';
$lang['No_vote_option'] = 'You must specify an option when voting.';

$lang['Add_poll'] = 'Add a Poll';
$lang['Add_poll_explain'] = 'If you do not want to add a poll to your topic, leave the fields blank.';
$lang['Poll_question'] = 'Poll question';
$lang['Poll_option'] = 'Poll option';
$lang['Add_option'] = 'Add option';
$lang['Update'] = 'Update';
$lang['Delete'] = 'Delete';
$lang['Poll_for'] = 'Run poll for';
$lang['Days'] = 'Days';
$lang['Poll_for_explain'] = '[ Enter 0 or leave blank for a never ending poll ]';
$lang['Delete_poll'] = 'Delete Poll';

$lang['Disable_HTML_post'] = 'Disable HTML in this post';
$lang['Disable_BBCode_post'] = 'Disable BBCode in this post';
$lang['Disable_Smilies_post'] = 'Disable Smilies in this post';

$lang['HTML_is_ON'] = 'HTML is <u>ON</u>';
$lang['HTML_is_OFF'] = 'HTML is <u>OFF</u>';
$lang['BBCode_is_ON'] = '%sBBCode%s is <u>ON</u>';
$lang['BBCode_is_OFF'] = '%sBBCode%s is <u>OFF</u>';
$lang['Smilies_are_ON'] = 'Smilies are <u>ON</u>';
$lang['Smilies_are_OFF'] = 'Smilies are <u>OFF</u>';

$lang['Attach_signature'] = 'Attach signature (signatures can be changed in profile)';
$lang['Notify'] = 'Notify me when a reply is posted';
$lang['Delete_post'] = 'Delete this post';

$lang['Stored'] = 'Your message has been entered successfully.';
$lang['Deleted'] = 'Your message has been deleted successfully.';
$lang['Poll_delete'] = 'Your poll has been deleted successfully.';
$lang['Vote_cast'] = 'Your vote has been cast.';

$lang['Topic_reply_notification'] = 'Topic Reply Notification';

$lang['bbcode_b_help'] = 'Bold text: [b]text[/b] (alt+b)';
$lang['bbcode_i_help'] = 'Italic text: [i]text[/i] (alt+i)';
$lang['bbcode_u_help'] = 'Underline text: [u]text[/u] (alt+u)';
$lang['bbcode_q_help'] = 'Quote text: [quote]text[/quote] (alt+q)';
$lang['bbcode_c_help'] = 'Code display: [code]code[/code] (alt+c)';
$lang['bbcode_l_help'] = 'List: [list]text[/list] (alt+l)';
$lang['bbcode_o_help'] = 'Ordered list: [list=]text[/list] (alt+o)';
$lang['bbcode_p_help'] = 'Insert image: [img]http://image_url[/img] (alt+p)';
$lang['bbcode_w_help'] = 'Insert URL: [url]http://url[/url] or [url=http://url]URL text[/url] (alt+w)';
$lang['bbcode_a_help'] = 'Close all open bbCode tags';
$lang['bbcode_s_help'] = 'Font color: [color=red]text[/color] Tip: you can also use color=#FF0000';
$lang['bbcode_f_help'] = 'Font size: [size=x-small]small text[/size]';

$lang['Emoticons'] = 'Emoticons';
$lang['More_emoticons'] = 'View more Emoticons';

$lang['Font_color'] = 'Font colour';
$lang['color_default'] = 'Default';
$lang['color_dark_red'] = 'Dark Red';
$lang['color_red'] = 'Red';
$lang['color_orange'] = 'Orange';
$lang['color_brown'] = 'Brown';
$lang['color_yellow'] = 'Yellow';
$lang['color_green'] = 'Green';
$lang['color_olive'] = 'Olive';
$lang['color_cyan'] = 'Cyan';
$lang['color_blue'] = 'Blue';
$lang['color_dark_blue'] = 'Dark Blue';
$lang['color_indigo'] = 'Indigo';
$lang['color_violet'] = 'Violet';
$lang['color_white'] = 'White';
$lang['color_black'] = 'Black';

$lang['Font_size'] = 'Font size';
$lang['font_tiny'] = 'Tiny';
$lang['font_small'] = 'Small';
$lang['font_normal'] = 'Normal';
$lang['font_large'] = 'Large';
$lang['font_huge'] = 'Huge';

$lang['Close_Tags'] = 'Close Tags';
$lang['Styles_tip'] = 'Tip: Styles can be applied quickly to selected text';


//
// Private Messaging
//
$lang['Private_Messaging'] = 'Private Messaging';

$lang['Login_check_pm'] = 'Log in to check your private messages';
$lang['New_pms'] = 'You have %d <span class=\'pm\'>*<b>new</b>*</span> messages';
$lang['New_pm'] = 'You have %d <span class=\'pm\'>*<b>new</b>*</span> message';
$lang['No_new_pm'] = 'You have no new messages';
$lang['Unread_pms'] = 'You have %d unread messages';
$lang['Unread_pm'] = 'You have %d unread message';
$lang['No_unread_pm'] = 'You have no unread messages';
$lang['You_new_pm'] = 'A new private message is waiting for you in your Inbox';
$lang['You_new_pms'] = 'New private messages are waiting for you in your Inbox';
$lang['You_no_new_pm'] = 'No new private messages are waiting for you';

$lang['Unread_message'] = 'Unread message';
$lang['Read_message'] = 'Read message';

$lang['Read_pm'] = 'Read message';
$lang['Post_new_pm'] = 'Post message';
$lang['Post_reply_pm'] = 'Reply to message';
$lang['Post_quote_pm'] = 'Quote message';
$lang['Edit_pm'] = 'Edit message';

$lang['Inbox'] = 'Inbox';
$lang['Outbox'] = 'Outbox';
$lang['Savebox'] = 'Savebox';
$lang['Sentbox'] = 'Sentbox';
$lang['Flag'] = 'Flag';
$lang['Subject'] = 'Subject';
$lang['From'] = 'From';
$lang['To'] = 'To';
$lang['Date'] = 'Date';
$lang['Mark'] = 'Mark';
$lang['Sent'] = 'Sent';
$lang['Saved'] = 'Saved';
$lang['Delete_marked'] = 'Delete Marked';
$lang['Delete_all'] = 'Delete All';
$lang['Save_marked'] = 'Save Marked';
$lang['Save_message'] = 'Save Message';
$lang['Delete_message'] = 'Delete Message';

$lang['Display_messages'] = 'Display messages from previous';
$lang['All_Messages'] = 'All Messages';

$lang['No_messages_folder'] = 'You have no messages in this folder';

$lang['PM_disabled'] = 'Private messaging has been disabled on this board.';
$lang['Cannot_send_privmsg'] = 'Sorry, but the administrator has prevented you from sending private messages.';
$lang['No_to_user'] = 'You must specify a username to whom to send this message.';
$lang['No_such_user'] = 'Sorry, but no such user exists.';

$lang['Disable_HTML_pm'] = 'Disable HTML in this message';
$lang['Disable_BBCode_pm'] = 'Disable BBCode in this message';
$lang['Disable_Smilies_pm'] = 'Disable Smilies in this message';

$lang['Message_sent'] = 'Your message has been sent.';

$lang['Click_return_inbox'] = 'Click %sHere%s to return to your Inbox';
$lang['Click_return_index'] = 'Click %sHere%s to return to the Index';

$lang['Send_a_new_message'] = 'Send a new private message';
$lang['Send_a_reply'] = 'Reply to a private message';
$lang['Edit_message'] = 'Edit private message';

$lang['Notification_subject'] = 'New Private Message has arrived';

$lang['Find_username'] = 'Find a username';
$lang['Find'] = 'Find';
$lang['No_match'] = 'No matches found.';

$lang['No_post_id'] = 'No post ID was specified';
$lang['No_such_folder'] = 'No such folder exists';
$lang['No_folder'] = 'No folder specified';

$lang['Mark_all'] = 'Mark all';
$lang['Unmark_all'] = 'Unmark all';

$lang['Confirm_delete_pm'] = 'Are you sure you want to delete this message?';
$lang['Confirm_delete_pms'] = 'Are you sure you want to delete these messages?';

$lang['Inbox_size'] = 'Your Inbox is %d%% full';
$lang['Sentbox_size'] = 'Your Sentbox is %d%% full'; 
$lang['Savebox_size'] = 'Your Savebox is %d%% full';

$lang['Click_view_privmsg'] = 'Click %sHere%s to visit your Inbox';


//
// Profiles/Registration
//
$lang['Viewing_user_profile'] = 'Viewing profile :: %s';
$lang['About_user'] = 'All about %s';

$lang['Preferences'] = 'Preferences';
$lang['Items_required'] = 'Items marked with a * are required unless stated otherwise';
$lang['Registration_info'] = 'Registration Information';
$lang['Profile_info'] = 'Profile Information (can you change it later if not mark a star)';
$lang['Profile_info_warn'] = 'This information will be publicly viewable';
$lang['Avatar_panel'] = 'Avatar control panel';
$lang['Avatar_gallery'] = 'Avatar gallery';

$lang['Website'] = 'Website';
$lang['Location'] = 'Location';
$lang['Contact'] = 'Contact';
$lang['Email_address'] = 'E-mail address';
$lang['Email'] = 'E-mail';
$lang['Send_private_message'] = 'Send private message';
$lang['Hidden_email'] = '[ Hidden ]';
$lang['Search_user_posts'] = 'Search for posts by this user';
$lang['Interests'] = 'Interests';
$lang['Occupation'] = 'Occupation';
$lang['Poster_rank'] = 'Poster rank';

$lang['Total_posts'] = 'Total posts';
$lang['User_post_pct_stats'] = '%.2f%% of total';
$lang['User_post_day_stats'] = '%.2f posts per day';
$lang['Search_user_posts'] = 'Find all posts by %s';

$lang['No_user_id_specified'] = 'Sorry, but that user does not exist.';
$lang['Wrong_Profile'] = 'You cannot modify a profile that is not your own.';

$lang['Only_one_avatar'] = 'Only one type of image can be specified';
$lang['File_no_data'] = 'The file at the URL you gave contains no data';
$lang['No_connection_URL'] = 'A connection could not be made to the URL you gave';
$lang['Incomplete_URL'] = 'The URL you entered is incomplete';
$lang['Wrong_remote_avatar_format'] = 'The URL of the remote image is not valid';
$lang['No_send_account_inactive'] = 'Sorry, but your password cannot be retrieved because your account is currently inactive. Please contact the forum administrator for more information';

$lang['Always_smile'] = 'Always enable Smilies';
$lang['Always_html'] = 'Always allow HTML';
$lang['Always_bbcode'] = 'Always allow BBCode';
$lang['Always_add_sig'] = 'Always attach my signature';
$lang['Always_notify'] = 'Always notify me of replies';
$lang['Always_notify_explain'] = 'Sends an e-mail when someone replies to a topic you have posted in. This can be changed whenever you post';

$lang['Board_style'] = 'Board Style';
$lang['Board_lang'] = 'Board Language';
$lang['No_themes'] = 'No Themes In database';
$lang['Timezone'] = 'Timezone';
$lang['Date_format'] = 'Date format';
$lang['Date_format_explain'] = 'The syntax used is identical to the PHP <a href=\'http://www.php.net/date\' target=\'_other\'>date()</a> function';
$lang['Signature'] = 'Signature';
$lang['Signature_explain'] = 'Display an image under each post you make. Only one image can be displayed at a time, its width can be no greater than %d pixels, the height no greater than %d pixels, and the filesize no more than %d kB.';
$lang['Public_view_email'] = 'Always show my e-mail address';

$lang['Current_password'] = 'Current password';
$lang['New_password'] = 'New password';
$lang['Confirm_password'] = 'Confirm password';
$lang['Confirm_password_explain'] = 'You must confirm your current password if you wish to change it or alter your e-mail address';
$lang['password_if_changed'] = 'You only need to supply a password if you want to change it';
$lang['password_confirm_if_changed'] = 'You only need to confirm your password if you changed it above';

$lang['Avatar'] = 'Avatar';
$lang['Avatar_explain'] = 'Displays a small graphic image below your details in posts. Only one image can be displayed at a time, its width can be no greater than %d pixels, a height no greater than %d pixels and a file size no more than %dkB.';
$lang['Upload_Avatar_file'] = 'Upload image from your machine';
$lang['Upload_Avatar_URL'] = 'Upload image from a URL';
$lang['Upload_Avatar_URL_explain'] = 'Enter the URL of the location containing the image, it will be copied to this site.';
$lang['Pick_local_Avatar'] = 'Select Avatar from the gallery';
$lang['Link_remote_Avatar'] = 'Link to off-site image';
$lang['Link_remote_Avatar_explain'] = 'Enter the URL of the location containing the Avatar image you wish to link to.';
$lang['Avatar_URL'] = 'URL of Avatar Image';
$lang['Select_from_gallery'] = 'Select Avatar from gallery';
$lang['View_avatar_gallery'] = 'Show gallery';

$lang['Select_avatar'] = 'Select avatar';
$lang['Return_profile'] = 'Cancel avatar';
$lang['Select_category'] = 'Select category';

$lang['Delete_Image'] = 'Delete Image';
$lang['Current_Image'] = 'Current Image';

$lang['Notify_on_privmsg'] = 'Notify on new Private Message';
$lang['Popup_on_privmsg'] = 'Pop up window on new Private Message';
$lang['Popup_on_privmsg_explain'] = 'Some templates may open a new window to inform you when new private messages arrive';
$lang['Hide_user'] = 'Hide your online status';

$lang['Profile_updated'] = 'Your profile has been updated';
$lang['Profile_updated_inactive'] = 'Your profile has been updated. However, you have changed vital details, thus your account is now inactive. Check your e-mail to find out how to reactivate your account, or if admin activation is required, wait for the administrator to reactivate it.';

$lang['Password_mismatch'] = 'The passwords you entered did not match.';
$lang['Current_password_mismatch'] = 'The current password you supplied does not match that stored in the database.';
$lang['Password_long'] = 'Your password must be no more than 32 characters.';
$lang['Too_many_registers'] = 'You have made too many registration attempts. Please try again later.';
$lang['Username_taken'] = 'Sorry, but this username has already been taken.';
$lang['Username_invalid'] = 'Sorry, but this username contains an invalid character such as \'.';
$lang['Username_disallowed'] = 'Sorry, but this username has been disallowed.';
$lang['Email_taken'] = 'Sorry, but that e-mail address is already registered to a user.';
$lang['Email_banned'] = 'Sorry, but this e-mail address has been banned.';
$lang['Email_invalid'] = 'Sorry, but this e-mail address is invalid.';
$lang['Signature_too_long'] = 'Your signature is too long.';
$lang['Fields_empty'] = 'You must fill in the required fields';
$lang['Avatar_filetype'] = 'The image filetype must be .jpg, .gif or .png';
$lang['Avatar_filesize'] = 'The image file size must be less than %d kB';
$lang['Avatar_imagesize'] = 'The image must be less than %d pixels wide and %d pixels high';

$lang['Welcome_subject'] = 'Welcome to %s Forums';
$lang['New_account_subject'] = 'New user account';
$lang['Account_activated_subject'] = 'Account Activated';

$lang['Account_added'] = 'Thank you for registering. Your account has been created. You may now log in with your username and password';
$lang['Account_inactive'] = 'Your account has been created. However, this forum requires account activation, an activation key has been sent to the e-mail address you provided. Please check your email for further information';
$lang['Account_inactive_admin'] = 'Your account has been created. However, this forum requires account activation by the administrator. An e-mail has been sent to them and you will be informed when your account has been activated';
$lang['Account_active'] = 'Your account has now been activated. Thank you for registering';
$lang['Account_active_admin'] = 'The account has now been activated';
$lang['Reactivate'] = 'Reactivate your account!';
$lang['Already_activated'] = 'You have already activated your account';
$lang['COPPA'] = 'Your account has been created but has to be approved. Please check your e-mail for details.';

$lang['Registration'] = 'Registration Agreement Terms';
$lang['Reg_agreement'] = 'While the administrators and moderators of this forum will attempt to remove or edit any generally objectionable material as quickly as possible, it is impossible to review every message. Therefore you acknowledge that all posts made to these forums express the views and opinions of the author and not the administrators, moderators or webmaster (except for posts by these people) and hence will not be held liable.<br /><br />You agree not to post any abusive, obscene, vulgar, slanderous, hateful, threatening, sexually-orientated or any other material that may violate any applicable laws. Doing so may lead to you being immediately and permanently banned (and your service provider being informed). The IP address of all posts is recorded to aid in enforcing these conditions. You agree that the webmaster, administrator and moderators of this forum have the right to remove, edit, move or close any topic at any time should they see fit. As a user you agree to any information you	have entered above being stored in a database. While this information will not be disclosed to any third party without your consent the webmaster, administrator and moderators cannot be held responsible for any hacking attempt that may lead to the data being compromised.<br /><br />This forum system uses cookies to store information on your local computer. These cookies do not contain any of the information you have entered above, they serve only to improve your viewing pleasure. The email address is used only for confirming your registration details and password (and for sending new passwords should you forget your current one).<br /><br />By clicking Register below you agree to be bound by these conditions.';

$lang['Agree_under_13'] = '';
$lang['Agree_over_13'] = 'I Agree to these terms';
$lang['Agree_not'] = 'I do not agree to these terms';

$lang['Wrong_activation'] = 'The activation key you supplied does not match any in the database.';
$lang['Send_password'] = 'Send me a new password';
$lang['Password_updated'] = 'A new password has been created, please check your e-mail for details on how to activate it.';
$lang['No_email_match'] = 'The e-mail address you supplied does not match the one listed for that username.';
$lang['New_password_activation'] = 'New password activation';
$lang['Password_activated'] = 'Your account has been re-activated. To log in, please use the password supplied in the e-mail you received.';

$lang['Send_email_msg'] = 'Send an e-mail message';
$lang['No_user_specified'] = 'No user was specified';
$lang['User_prevent_email'] = 'This user does not wish to receive e-mail. Try sending them a private message.';
$lang['User_not_exist'] = 'That user does not exist';
$lang['CC_email'] = 'Send a copy of this e-mail to yourself';
$lang['Email_message_desc'] = 'This message will be sent as plain text, so do not include any HTML or BBCode. The return address for this message will be set to your e-mail address.';
$lang['Flood_email_limit'] = 'You cannot send another e-mail at this time. Try again later.';
$lang['Recipient'] = 'Recipient';
$lang['Email_sent'] = 'The e-mail has been sent.';
$lang['Send_email'] = 'Send e-mail';
$lang['Empty_subject_email'] = 'You must specify a subject for the e-mail.';
$lang['Empty_message_email'] = 'You must enter a message to be e-mailed.';


//
// Visual confirmation system strings
//
$lang['Confirm_code_wrong'] = 'The confirmation code you entered was incorrect';
$lang['Too_many_registers'] = 'You have exceeded the number of registration attempts for this session. Please try again later.';
$lang['Confirm_code_impaired'] = 'If you are visually impaired or cannot otherwise read this code please contact the %sAdministrator%s for help.';
$lang['Confirm_code'] = 'Confirmation code';
$lang['Confirm_code_explain'] = 'Enter the code exactly as you see it. The code is case sensitive and zero has a diagonal line through it.';



//
// Memberslist
//
$lang['Select_sort_method'] = 'Select sort method';
$lang['Sort'] = 'Sort';
$lang['Sort_Top_Ten'] = 'Top Ten Posters';
$lang['Sort_Joined'] = 'Joined Date';
$lang['Sort_Username'] = 'Username';
$lang['Sort_Email'] = 'Email';
$lang['Sort_Ascending'] = 'Ascending';
$lang['Sort_Descending'] = 'Descending';
$lang['Order'] = 'Order';


//
// Group control panel
//
$lang['Group_Control_Panel'] = 'Group Control Panel';
$lang['Group_member_details'] = 'Group Membership Details';
$lang['Group_member_join'] = 'Join a Group';

$lang['Group_Information'] = 'Group Information';
$lang['Group_name'] = 'Group name';
$lang['Group_description'] = 'Group description';
$lang['Group_membership'] = 'Group membership';
$lang['Group_Members'] = 'Group Members';
$lang['Group_Moderator'] = 'Group Moderator';
$lang['Pending_members'] = 'Pending Members';

$lang['Group_type'] = 'Group type';
$lang['Group_open'] = 'Open group';
$lang['Group_closed'] = 'Closed group';
$lang['Group_hidden'] = 'Hidden group';

$lang['Current_memberships'] = 'Current memberships';
$lang['Non_member_groups'] = 'Non-member groups';
$lang['Memberships_pending'] = 'Memberships pending';

$lang['No_groups_exist'] = 'No Groups Exist';
$lang['Group_not_exist'] = 'That user group does not exist';

$lang['Join_group'] = 'Join Group';
$lang['No_group_members'] = 'This group has no members';
$lang['Group_hidden_members'] = 'This group is hidden, you cannot view its membership';
$lang['No_pending_group_members'] = 'This group has no pending members';
$lang['Group_joined'] = 'You have successfully subscribed to this group.<br />You will be notified when your subscription is approved by the group moderator';
$lang['Group_request'] = 'A request to join your group %s has been made.';
$lang['Group_approved'] = 'Your request has been approved.';
$lang['Group_added'] = 'You have been added to usergroup %s.';
$lang['Already_member_group'] = 'You are already a member of this group';
$lang['User_is_member_group'] = 'User is already a member of this group';
$lang['Group_type_updated'] = 'Successfully updated group type.';

$lang['Could_not_add_user'] = 'The user you selected does not exist.';
$lang['Could_not_anon_user'] = 'You cannot make Anonymous a group member.';

$lang['Confirm_unsub'] = 'Are you sure you want to unsubscribe from this group?';
$lang['Confirm_unsub_pending'] = 'Your subscription to this group has not yet been approved, are you sure you want to unsubscribe?';

$lang['Unsub_success'] = 'You have been un-subscribed from this group.';

$lang['Approve_selected'] = 'Approve Selected';
$lang['Deny_selected'] = 'Deny Selected';
$lang['Not_logged_in'] = 'You must be logged in to join a group.';
$lang['Remove_selected'] = 'Remove Selected';
$lang['Add_member'] = 'Add Member';
$lang['Not_group_moderator'] = 'You are not this group\'s moderator, therefore you cannot perform that action.';

$lang['Login_to_join'] = 'Log in to join or manage group memberships';
$lang['This_open_group'] = 'This is an open group, click to request membership';
$lang['This_closed_group'] = 'This is a closed group, %s';
$lang['This_hidden_group'] = 'This is a hidden group, %s';
$lang['Member_this_group'] = 'You are a member of this group';
$lang['Pending_this_group'] = 'Your membership of this group is pending';
$lang['Are_group_moderator'] = 'You are the group moderator';
$lang['None'] = 'None';

$lang['Subscribe'] = 'Subscribe';
$lang['Unsubscribe'] = 'Unsubscribe';
$lang['View_Information'] = 'View Information';


//
// Search
//
$lang['Search_query'] = 'Search Query';
$lang['Search_options'] = 'Search Options';

$lang['Search_keywords'] = 'Search for Keywords';
$lang['Search_keywords_explain'] = 'You can use <u>AND</u> to define words which must be in the results, <u>OR</u> to define words which may be in the result and <u>NOT</u> to define words which should not be in the result. Use * as a wildcard for partial matches<br />To search phrase embrance it in the <b>"</b>quotation<b>"</b>';
$lang['Search_author'] = 'Search for Author';
$lang['Search_author_explain'] = 'Use * as a wildcard for partial matches';

$lang['Search_for_any'] = 'Search for any terms or use query as entered';
$lang['Search_for_all'] = 'Search for all terms';
$lang['Search_title_msg'] = 'Search topic title and message text';
$lang['Search_msg_only'] = 'Search message text only';

$lang['Return_first'] = 'Return first';
$lang['characters_posts'] = 'characters of posts';

$lang['Search_previous'] = 'Search previous';

$lang['Sort_by'] = 'Sort by';
$lang['Sort_Time'] = 'Post Time';
$lang['Sort_Post_Subject'] = 'Post Subject';
$lang['Sort_Topic_Title'] = 'Topic Title';
$lang['Sort_Author'] = 'Author';
$lang['Sort_Forum'] = 'Forum';

$lang['Display_results'] = 'Display results as';
$lang['All_available'] = 'All available';
$lang['No_searchable_forums'] = 'You do not have permissions to search any forum on this site';

$lang['No_search_match'] = 'No topics or posts met your search criteria';
$lang['Found_search_match'] = 'Search found %d match';
$lang['Found_search_matches'] = 'Search found %d matches';

$lang['Close_window'] = 'Close Window';


//
// Auth related entries
//
// Note the %s will be replaced with one of the following 'user' arrays
$lang['Sorry_auth_announce'] = 'Sorry, but only %s can post announcements in this forum.';
$lang['Sorry_auth_sticky'] = 'Sorry, but only %s can post sticky messages in this forum.'; 
$lang['Sorry_auth_read'] = 'Sorry, but only %s can read topics in this forum.'; 
$lang['Sorry_auth_post'] = 'Sorry, but only %s can post topics in this forum.'; 
$lang['Sorry_auth_reply'] = 'Sorry, but only %s can reply to posts in this forum.';
$lang['Sorry_auth_edit'] = 'Sorry, but only %s can edit posts in this forum.'; 
$lang['Sorry_auth_delete'] = 'Sorry, but only %s can delete posts in this forum.';
$lang['Sorry_auth_vote'] = 'Sorry, but only %s can vote in polls in this forum.';

// These replace the %s in the above strings
$lang['Auth_Anonymous_Users'] = '<b>anonymous users</b>';
$lang['Auth_Registered_Users'] = '<b>registered users</b>';
$lang['Auth_Users_granted_access'] = '<b>users granted special access</b>';
$lang['Auth_Moderators'] = '<b>moderators</b>';
$lang['Auth_Administrators'] = '<b>administrators</b>';

$lang['Not_Moderator'] = 'You are not a moderator of this forum.';
$lang['Not_Authorised'] = 'Not Authorised';

$lang['You_been_banned'] = 'You have been banned from this forum.<br />Please contact the webmaster or board administrator for more information.';


//
// Viewonline
//
$lang['Reg_users_zero_online'] = 'There are 0 Registered users and ';
$lang['Reg_users_online'] = 'There are %d Registered users and ';
$lang['Reg_user_online'] = 'There is %d Registered user and ';
$lang['Hidden_users_zero_online'] = '0 Hidden users online';
$lang['Hidden_users_online'] = '%d Hidden users online';
$lang['Hidden_user_online'] = '%d Hidden user online';
$lang['Guest_users_online'] = 'There are %d Guest users online';
$lang['Guest_users_zero_online'] = 'There are 0 Guest users online';
$lang['Guest_user_online'] = 'There is %d Guest user online';
$lang['No_users_browsing'] = 'There are no users currently browsing this forum';

$lang['Online_explain'] = '';

$lang['Forum_Location'] = 'Forum Location';
$lang['Last_updated'] = 'Last Updated';

$lang['Forum_index'] = 'Forum index';
$lang['Logging_on'] = 'Logging on';
$lang['Posting_message'] = 'Posting a message';
$lang['Searching_forums'] = 'Searching forums';
$lang['Viewing_profile'] = 'Viewing profile';
$lang['Viewing_online'] = 'Viewing who is online';
$lang['Viewing_member_list'] = 'Viewing member list';
$lang['Viewing_priv_msgs'] = 'Viewing Private Messages';
$lang['Viewing_FAQ'] = 'Viewing FAQ';


//
// Moderator Control Panel
//
$lang['Mod_CP'] = 'Moderator Control Panel';
$lang['Mod_CP_explain'] = 'Using the form below you can perform mass moderation operations on this forum. You can lock, unlock, move or delete any number of topics.';

$lang['Select'] = 'Select';
$lang['Delete'] = 'Delete';
$lang['Move'] = 'Move';
$lang['Lock'] = 'Lock';
$lang['Unlock'] = 'Unlock';

$lang['Topics_Removed'] = 'The selected topics have been successfully removed from the database.';
$lang['Topics_Locked'] = 'The selected topics have been locked.';
$lang['Topics_Moved'] = 'The selected topics have been moved.';
$lang['Topics_Unlocked'] = 'The selected topics have been unlocked.';
$lang['No_Topics_Moved'] = 'No topics were moved.';

$lang['Confirm_delete_topic'] = 'Are you sure you want to remove the selected topic/s?';
$lang['Confirm_lock_topic'] = 'Are you sure you want to lock the selected topic/s?';
$lang['Confirm_unlock_topic'] = 'Are you sure you want to unlock the selected topic/s?';
$lang['Confirm_move_topic'] = 'Are you sure you want to move the selected topic/s?';

$lang['Move_to_forum'] = 'Move to forum';
$lang['Leave_shadow_topic'] = 'Leave shadow topic in old forum.';

$lang['Split_Topic'] = 'Split Topic Control Panel';
$lang['Split_Topic_explain'] = 'Using the form below you can split a topic in two, either by selecting the posts individually or by splitting at a selected post';
$lang['Split_title'] = 'New topic title';
$lang['Split_forum'] = 'Forum for new topic';
$lang['Split_posts'] = 'Split selected posts';
$lang['Split_after'] = 'Split from selected post';
$lang['Topic_split'] = 'The selected topic has been split successfully';

$lang['Too_many_error'] = 'You have selected too many posts. You can only select one post to split a topic after!';

$lang['None_selected'] = 'You have not selected any topics to perform this operation on. Please go back and select at least one.';
$lang['New_forum'] = 'New forum';

$lang['This_posts_IP'] = 'IP address for this post';
$lang['Other_IP_this_user'] = 'Other IP addresses this user has posted from';
$lang['Users_this_IP'] = 'Users posting from this IP address';
$lang['IP_info'] = 'IP Information';
$lang['Lookup_IP'] = 'Look up IP address';


//
// Timezones ... for display on each page
//
$lang['All_times'] = 'All times are %s';

// These are displayed in the timezone select box
$lang['tz']['-12'] = 'GMT - 12 Hours';
$lang['tz']['-11'] = 'GMT - 11 Hours';
$lang['tz']['-10'] = 'GMT - 10 Hours';
$lang['tz']['-9'] = 'GMT - 9 Hours';
$lang['tz']['-8'] = 'GMT - 8 Hours';
$lang['tz']['-7'] = 'GMT - 7 Hours';
$lang['tz']['-6'] = 'GMT - 6 Hours';
$lang['tz']['-5'] = 'GMT - 5 Hours';
$lang['tz']['-4'] = 'GMT - 4 Hours';
$lang['tz']['-3.5'] = 'GMT - 3.5 Hours';
$lang['tz']['-3'] = 'GMT - 3 Hours';
$lang['tz']['-2'] = 'GMT - 2 Hours';
$lang['tz']['-1'] = 'GMT - 1 Hours';
$lang['tz']['0'] = 'GMT';
$lang['tz']['1'] = 'GMT + 1 Hour';
$lang['tz']['2'] = 'GMT + 2 Hours';
$lang['tz']['3'] = 'GMT + 3 Hours';
$lang['tz']['3.5'] = 'GMT + 3.5 Hours';
$lang['tz']['4'] = 'GMT + 4 Hours';
$lang['tz']['4.5'] = 'GMT + 4.5 Hours';
$lang['tz']['5'] = 'GMT + 5 Hours';
$lang['tz']['5.5'] = 'GMT + 5.5 Hours';
$lang['tz']['6'] = 'GMT + 6 Hours';
$lang['tz']['6.5'] = 'GMT + 6.5 Hours';
$lang['tz']['7'] = 'GMT + 7 Hours';
$lang['tz']['8'] = 'GMT + 8 Hours';
$lang['tz']['9'] = 'GMT + 9 Hours';
$lang['tz']['9.5'] = 'GMT + 9.5 Hours';
$lang['tz']['10'] = 'GMT + 10 Hours';
$lang['tz']['11'] = 'GMT + 11 Hours';
$lang['tz']['12'] = 'GMT + 12 Hours';
$lang['tz']['13'] = 'GMT + 13 Hours';

$lang['datetime']['Sunday'] = 'Sunday';
$lang['datetime']['Monday'] = 'Monday';
$lang['datetime']['Tuesday'] = 'Tuesday';
$lang['datetime']['Wednesday'] = 'Wednesday';
$lang['datetime']['Thursday'] = 'Thursday';
$lang['datetime']['Friday'] = 'Friday';
$lang['datetime']['Saturday'] = 'Saturday';
$lang['datetime']['Sun'] = 'Sun';
$lang['datetime']['Mon'] = 'Mon';
$lang['datetime']['Tue'] = 'Tue';
$lang['datetime']['Wed'] = 'Wed';
$lang['datetime']['Thu'] = 'Thu';
$lang['datetime']['Fri'] = 'Fri';
$lang['datetime']['Sat'] = 'Sat';
$lang['datetime']['January'] = 'January';
$lang['datetime']['February'] = 'February';
$lang['datetime']['March'] = 'March';
$lang['datetime']['April'] = 'April';
$lang['datetime']['May'] = 'May';
$lang['datetime']['June'] = 'June';
$lang['datetime']['July'] = 'July';
$lang['datetime']['August'] = 'August';
$lang['datetime']['September'] = 'September';
$lang['datetime']['October'] = 'October';
$lang['datetime']['November'] = 'November';
$lang['datetime']['December'] = 'December';
$lang['datetime']['Jan'] = 'Jan';
$lang['datetime']['Feb'] = 'Feb';
$lang['datetime']['Mar'] = 'Mar';
$lang['datetime']['Apr'] = 'Apr';
$lang['datetime']['May'] = 'May';
$lang['datetime']['Jun'] = 'Jun';
$lang['datetime']['Jul'] = 'Jul';
$lang['datetime']['Aug'] = 'Aug';
$lang['datetime']['Sep'] = 'Sep';
$lang['datetime']['Oct'] = 'Oct';
$lang['datetime']['Nov'] = 'Nov';
$lang['datetime']['Dec'] = 'Dec';

//
// Errors (not related to a
// specific failure on a page)
//
$lang['Information'] = 'Information';
$lang['Critical_Information'] = 'Critical Information';

$lang['General_Error'] = 'General Error';
$lang['Critical_Error'] = 'Critical Error';
$lang['An_error_occured'] = 'An Error Occurred';
$lang['A_critical_error'] = 'A Critical Error Occurred';

//
// Modified addons
//

$lang['2_Days'] = '2 Days';
$lang['3_Days'] = '3 Days';
$lang['4_Days'] = '4 Days';
$lang['5_Days'] = '5 Days';
$lang['6_Days'] = '6 Days';
$lang['left'] = 'left side';
$lang['center'] = 'center';
$lang['right'] = 'right side';
$lang['Last_posted'] = 'Last Post:';
$lang['registered_have'] = 'We have';
$lang['registered_users'] = 'registered users';
$lang['users_write'] = 'Users write';
$lang['posts'] = 'posts';
$lang['topics'] = 'topics';
$lang['Legend'] = 'Legend';
$lang['User_online_color'] = '%sUser%s';
$lang['Search_new_unread'] = 'View unread posts';
$lang['Quick_register'] = 'Quick register';
$lang['visitors_txt'] = 'This board have totally';
$lang['visitors_txt2'] = 'visitors';
$lang['Sticky_topic'] = 'Sticky this topic';
$lang['Announce_topic'] = 'Announce this topic';
$lang['Normal_topic'] = 'Reset this topic to normal';
$lang['Sticky'] = 'Sticky';
$lang['Announce'] = 'Announcement';
$lang['Normalise'] = 'Normal';
$lang['Topics_Stickyd'] = 'The selected topics have been stickied';
$lang['Topics_Announced'] = 'The selected topics have been announced';
$lang['Topics_Normalised'] = 'The selected topics have been normalised';
$lang['Topic_started'] = 'Topic started';
$lang['Mark_topic_unread'] = 'Mark current topic unread';
$lang['Advanced_search'] = 'Advanced Search';
$lang['bbcode_y_help'] = 'Font Center: [center]text[/center] (alt+y)';
$lang['bbcode_e_help'] = 'Fade text: [fade]some text[/fade] (alt+e)';
$lang['bbcode_k_help'] = 'Scrolling text: [scroll]text[/scroll] (alt+k)';
$lang['bbcode_s2_help'] = 'Shadow Color: [shadow=red]text[/shadow] Tip: this makes your text shadowed';
$lang['bbcode_g_help'] = 'Glow Color: [glow=red]text[/glow] Tip: this makes your text glow';
$lang['bbcode_h_help'] = 'Hide: [hide]message[/hide] (alt+h)';
$lang['Protect_not_copied'] = '--- phpBB : The Protected Message is not copied in this quote ---';
$lang['Protect_message'] = 'Protected Message:';
$lang['Protect_info'] = '--- If you are a *registered user* : you need to post in this topic to see the message ---';
$lang['Shadow_color'] = 'Shadow Color';
$lang['Glow_color'] = 'Glow Color';
$lang['write_link_text'] = 'Enter the text to be displayed for the link';
$lang['write_address'] = 'Enter the full URL for the link';
$lang['img_address'] = 'Enter the address to your image';
$lang['stream_address'] = 'Enter file address';
$lang['New_nsnd_pm'] = 'You have %d new message';
$lang['GG'] = 'Number Gadu-Gadu :: %s';
$lang['STAT_GG'] = 'User Gadu-gadu status';
$lang['Topics_per_page'] = 'Topics Per Page';
$lang['Posts_per_page'] = 'Posts Per Page';
$lang['Hot_threshold'] = 'Posts for Popular Threshold';
$lang['Show_avatars'] = 'Show Avatars';
$lang['Search_title_only'] = 'Search topic title only';
$lang['Topics_Expired'] = 'Topic will expire after attribute time';

$lang['GG_wait'] = 'Message waiting for receive.<br />Will be deliveret when user swich on Gadu-gadu<br /> or user is on <b>"invisible"</b> status or <b>"only for friends"</b>';
$lang['GG_full'] = 'User mailbox its full! Cannot send message.';
$lang['GG_send'] = 'Message delivery to user';
$lang['GG_not_send'] = 'Message not delivert, try another one or refresh page';
$lang['bramka_gg'] = 'WWW Gate -> Gadu-Gadu';
$lang['gg_mes'] = 'Write your message';

// ChatBox Mod
$lang['How_Many_Chatters'] = 'There are <B>%d</B> user(s) on chat now';
$lang['Who_Are_Chatting'] = '<B>%s</B>';
$lang['Click_to_join_chat'] = 'Click to join chat';
$lang['ChatBox'] = 'ChatBox';
$lang['log_out_chat'] = 'You have successfully logged out from chat on ';
$lang['Login_to_join_chat'] = 'Log in to join chat';

$lang['Last_visit'] = 'Last log in';
$lang['Never'] = 'Never';
$lang['Sort_Last_visit'] = 'Date last log in';

// Page MOD
$lang['Page_loading_wait'] = 'Page Loading... please wait!';
$lang['Page_loading_stop'] = 'This page still doesn\'t show? Click <span onclick="hideLoadingPage()" style="cursor:hand"><u>here</u></span>';

// Advanced Quick Reply Mod
$lang['Quick_Reply'] = 'Quick Reply';
$lang['Quick_quote'] = 'Quote the last message';
$lang['QuoteSelelected'] = 'Quote selected';
$lang['QuoteSelelectedEmpty'] = 'Select a text anywhere on a page and try again';
$lang['Quick_Reply_smilies'] = 'All emoticons';
$lang['l_statistics'] = 'Statistics';

//Add on for Birthday Mod 
$lang['Birthday'] = 'Birthday'; 
$lang['No_birthday_specify'] = 'None Specified';
$lang['Age'] = 'Age';
$lang['Wrong_birthday_format'] = 'The birthday format was entered incorrectly.';
$lang['Birthday_greeting_today'] = 'We would like to wish you congratulatons on reaching %s years old today.<br /><br /> The Management';//%s is substituted with the users age 
$lang['Birthday_greeting_prev'] = 'We would like to give you a belated congratulatons for becoming %s years old on the %s.<br /><br /> The Management';//%s is substituted with the users age, and birthday 
$lang['Greeting_Messaging'] = 'Congratulations';
$lang['Birthday_today'] = 'Users with a birthday today:';
$lang['Birthday_week'] = 'Users with a birthday within the next %d days:';
$lang['Nobirthday_week'] = 'No users are having a birthday in the upcoming %d days';
$lang['Nobirthday_today'] = 'No users have a birthday today';
$lang['Year'] = 'Year';
$lang['Month'] = 'Month';
$lang['Day'] = 'Day';
$lang['send_congratulations'] = 'congratulations';
$lang['congratulations_send'] = 'Congratulations for this user has been sent.';
$lang['congratulations_send_no'] = 'Congratulations for this user earlier has been sent.';
$lang['congratulations_subject'] = 'Best wishes from opening of your birthday!!!';

$lang['l_whoisonline'] = 'View details';
$lang['new_topicsss'] = 'New topics:';
$lang['new_postsss'] = 'New posts:';

// Custom Status Rank 
$lang['Custom_Rank'] = 'Rank';
$lang['Custom_Rank_Explain'] = 'Define your own rank.';
$lang['Custom_color'] = 'Username Color';

$lang['Change_style'] = 'Change The Board Style';

$lang['l_level'] = 'Level';

//
// Ignore User Function
//
$lang['Ignore_list'] = 'Ignore Function';
$lang['Ignore_users'] = 'These Users are in your Ignore List';
$lang['Ignore_add'] = 'Add User to Ignore List';
$lang['Ignore_delete'] = 'Remove User from Ignore List';
$lang['Ignore_added'] = 'User added to Ignore List';
$lang['Ignore_deleted'] = 'User removed from Ignore List';
$lang['Ignore_submit'] = 'Ignore User';
$lang['Ignore_exists'] = 'User is Already on Ignore List';
$lang['Click_return_ignore'] = 'Click %sHERE%s to view the Ignore Page';
$lang['Ignore_user_warn'] = 'You cannot Ignore Yourself!!!';
$lang['Post_user_ignored'] = 'You have added this person to your <b>Ignore List</b>.';
$lang['Click_view_ignore'] = 'Click %sHERE%s to view this post.<br />';

$lang['Search_for'] = 'Search for';

$lang['Print_View'] = 'Printable version';
$lang['Wrong_reg_key'] = 'Wrong Validation';
$lang['Validation'] = 'Validation';
$lang['Validation_explain'] = 'To make sure you are not a robot, please type what digits you see in the image right';
$lang['Logs'] = 'Logs';
$lang['LogsActions'] = 'Logs actions';
$lang['Msg_Icon_No_Icon'] = 'No';
$lang['messageicon'] = 'Topic icon';
$lang['posticon'] = 'Message icon';
$lang['postmsgicon'] = 'Topic/Message icon';
$lang['Custom_color'] = 'Username Color';
$lang['Custom_color_Explain'] = 'Define your Custom Username color.'; 
$lang['Topic_view_users'] = 'Who viewed this topic';
$lang['Topic_time'] = 'Last viewed';
$lang['Topic_count'] = 'View count';

//
// Addons language
//

$lang['cdownload'] = 'Download enable';
$lang['cdownload_e'] = 'Enabled download and header link';
$lang['cicq'] = 'ICQ';



//
// Portal
//
$lang['Board_navigation'] = 'Board Navigation';
$lang['Statistics'] = 'Statistics';
$lang['Comments'] = 'Comments';
$lang['Read_Full'] = 'Read Full';
$lang['View_comments'] = 'View Comments';
$lang['Post_your_comment'] = 'Post your comment';
$lang['Welcome'] = 'Welcome';
$lang['Register_new_account'] = 'Don\'t have an account yet?<br />You can %sregister%s for FREE';
$lang['Remember_me'] = 'Remember me';
$lang['View_complete_list'] = 'View complete list';
$lang['Poll'] = 'Poll';
$lang['Login_to_vote'] = 'You must log in to vote';
$lang['Vote'] = 'Vote';
$lang['No_poll'] = 'No poll at the moment';
$lang['Recent_topics'] = 'Recent topics';
$lang['Who_is_Chatting'] = 'Who is Chatting';
$lang['links'] = 'Links';
$lang['Day'] = 'Day';
$lang['year_left'] = 'To NewYear is';
$lang['days'] = 'days.';
$lang['blank'] = 'Blank';
$lang['kto_imieniny'] = 'Name-day for';
$lang['Today'] = 'Today';
$lang['login'] = 'Sign in';
$lang['top_posters'] = 'Best posters';
$lang['last_posters'] = 'Last registered';
$lang['who_online'] = 'Who is online/visited today';
$lang['today_register'] = 'Registered users';
$lang['info_menu'] = 'User Info';
$lang['stats_user'] = 'Quick stats';
$lang['stats_user'] = 'Custom statistics';
$lang['rname'] = 'Quick register';
$lang['Search_at'] = 'Search at';
$lang['l_download_pos'] = 'Menu Download';
$lang['Junior_online_color'] = '%sJunior Admin%s';
$lang['Topic_global_announcement'] = '<b>Global Announcement:</b>';
$lang['Post_global_announcement'] = 'Global Announcement';

$lang['Forum_not_exist'] = 'No such forum exists';
$lang['Enter_forum_password'] = 'Enter forum password';
$lang['Incorrect_forum_password'] = 'Incorrect forum password';
$lang['Only_alpha_num_chars'] = 'The password must be between 3-20 characters and can only contain alphanumeric characters (A-Z, a-z, 0-9).';

$lang['Album'] = 'Album';
$lang['Personal_Gallery_Of_User'] = 'Personal Gallery of %s';
$lang['l_whois'] = 'Whois';

$lang['Album'] = 'Album';
$lang['Personal_Gallery_Of_User'] = 'Personal Gallery of %s';
$lang['l_whois'] = 'Whois';
$lang['Staff'] = 'Staff Site';
$lang['Forums'] = 'Forums';
$lang['Admin'] = 'Administrator';
$lang['Junior'] = 'Junior Admin';
$lang['Period'] = 'since <b>%d</b> days';
$lang['l_staff'] = 'Staff';
$lang['Topic_bookmark'] = 'Add this topic to your bookmarks';
$lang['Not_auth_edit_delete_admin'] = 'You cannot edit/delete an administrator\'s posts, sorry.';
$lang['Day_users'] = 'Users last %s hours:';
$lang['Not_day_users'] = 'Users who <span style="color:red">DIDN\'T</span> visit during the last 24 hours:';
$lang['post_expire'] = 'Post expire:';
$lang['topic_expire'] = 'Expire:';
$lang['expire_unlimit'] = 'Unlimit';
$lang['l_expire_p'] = 'Post/topic time expire';
$lang['l_expire_p_e'] = 'Choose how long post/topic will be on the forum. After will be automatically deleted.';
$lang['announce-stick'] = 'Stick topic - mark topic as announce or global announce';
$lang['Merge'] = 'Merge';
$lang['Topics_Merged'] = 'The selected topics have been merged';
$lang['No_Topics_Merged'] = 'No topics were merged';
$lang['Confirm_merge_topic'] = 'Are you sure you want to merge the selected topic/s?<br /><span class=genmed>(Next you will select a target post to merge these into next)</span>';
$lang['Merge_to_forum'] = 'Merge to forum';
$lang['Merge_topic'] = 'Merge this topic';
$lang['Merge_post'] = 'Merge posts in this topic';
$lang['Merge_after'] = 'Merge from selected post';
$lang['Merge_posts'] = 'Merge selected posts';
$lang['Mod_CP_explain'] = 'Using the form below you can perform mass moderation operations on this forum. You can lock, unlock, move, merge or delete any number of topics.';
$lang['Mod_CP_merge_explain'] = 'Select the topic with which the topic/post has to merge';
$lang['Merge_Topic_explain'] = 'Using the form below you can merge posts to a topic, either by selecting the posts individually or by merging at a selected post';
$lang['Merge_post_topic'] = 'Merge posts into a topic';
$lang['Posts_Merged'] = 'The selected posts have been merged';
$lang['post_expire_q'] = 'Expire';
$lang['Error_login_tomutch'] = 'You have specified an locked username, please try again latter';
$lang['Password_not_complex'] = 'The specifyed password, does not confirm this sites complexity rules, you should verify that: the password ';
$lang['Password_to_short'] = 'is at least %d characters long';
$lang['Password_mixed'] = 'have both nubers and letter';
$lang['Password_not_same'] = 'are not the same as your username';
$lang['Downloads2'] = 'Download';
$lang['See_all'] = 'See all files';
$lang['Ignore_mini'] = 'Ignore';
$lang['pm_mini'] = 'PM';
$lang['aim_mini'] = 'GG';
$lang['quote_mini'] = 'Quote';
$lang['edit_mini'] = 'Edit';
$lang['mini_reply'] = 'REPLY';
$lang['mini_newtopic'] = 'NEW TOPIC';
$lang['mini_locked'] = 'CLOSED';
$lang['gg_mes'] = 'Message';
$lang['login_to_shoutcast'] = 'You must be logged in to use shoutbox or sending messages is avaliable only for Administrators and Moderators';
$lang['sb_show'] = 'show';
$lang['sb_hide'] = 'Hide';
$lang['sb_hide_done'] = 'Done';
$lang['sb_banned_send'] = 'You can\'t send messages';
$lang['custom_rank_too_long'] = 'Your Rank is too long';
$lang['location_too_long'] = 'Location - is to long';
$lang['banned_forum'] = 'You cannot write on this forum.';
$lang['Signature_panel'] = 'Signature control panel';
$lang['Signature_text'] = 'Signature text';
$lang['Signature_text_explain'] = 'This is a block of text that can be added to posts you make. There is a %d character limit; images are not allowed.';
$lang['Allow_signatures'] = 'Allow signatures';
$lang['Allow_sig_images'] = 'Allow signature images';
$lang['edit_time_past'] = 'You\'re not allowed to edit your post. You have to edit your post within <b>%d</b> minutes, after you posted your message.';
$lang['No_more'] = 'no more users accepted';
$lang['No_add_allowed'] = 'automatic user addition is not allowed';
$lang['Join_auto'] = 'You may join this group, since your post count meet the group criteria';
$lang['Permissions'] = 'Permissions';
$lang['quote_image'] = 'Image';
$lang['Gender'] = 'Gender';
$lang['Male'] = 'Male'; 
$lang['Female'] = 'Female'; 
$lang['No_gender_specify'] = 'I dont know :)';
$lang['Profile_photo'] = 'Profile Photo';
$lang['Photo_panel'] = 'Profile photo control panel';
$lang['Photo_explain'] = 'Displays a small graphic image in your Profile. Only one image can be displayed at a time, its width can be no greater than %d pixels, a height no greater than %d pixels and a file size no more than %dkB.'; 

$lang['not_gg_account'] = 'Not number or password for GG gate. Contact with administrator';
$lang['not_gg_addresat'] = 'Recipient is empty';
$lang['wrong_gg_addresat'] = 'Bad format recipient number';
$lang['not_gg_msg'] = 'Message is empty';
$lang['gg_too_long'] = 'Message too long, max chars is: 1800';
$lang['gg_wrong_numner'] = 'Write valid number and password';
$lang['not_gg_self'] = 'Cannot send message myself';
$lang['gg_are_send'] = 'Message delivered';
$lang['gg_are_wait'] = 'Message waiting';
$lang['gg_are_full'] = 'Inbox is full';

$lang['topic_expire_mod'] = 'Expire after: ';

$lang['Forum_link_visited'] = 'This link has been visited %d times';
$lang['Redirect'] = 'Redirect';
$lang['Redirect_to'] = 'If your browser does not support meta redirection please click %sHERE% to be redirected';
$lang['Click_close_window'] = '%sClose window%s';

$lang['Use_sub_forum'] = 'Index packing';
$lang['Hierarchy_setting'] = 'Categories Hierarchy settings';
$lang['Index_packing_explain'] = 'Choose the level of packing you want for the index';
$lang['Medium'] = 'Medium';
$lang['Full'] = 'Full';
$lang['NoneS'] = 'Tree';
$lang['Split_categories'] = 'Split categories on index';
$lang['Use_last_topic_title'] = 'Show the last topic titles on index';
$lang['Last_topic_title_length'] = 'Title length of the last topic on index';
$lang['Sub_level_links'] = 'Sub-level links on index';
$lang['Sub_level_links_explain'] = 'Add the links to the sub-levels in the forum or category description';
$lang['With_pics'] = 'With icons';
$lang['Display_viewonline'] = 'Display viewonline information box on index';
$lang['Never'] = 'Never';
$lang['Root_index_only'] = 'On root index only';
$lang['Always'] = 'Always';
$lang['Click_return_preferences'] = 'Click %sHere%s to return to Preferences';

$lang['login_require'] = 'Access to this part of forum require logged in.';
$lang['login_require_register'] = 'If you not registered, click %sHere%s to register.';

$lang['Click_return_custom_sending'] = 'Click %sHere%s to return to the send congratulations';
$lang['choose_congratulations_format'] = 'Choose congratulations format:';
$lang['congratulations_format_standart'] = 'Standart';
$lang['congratulations_format_standart_e'] = 'Sending after click';
$lang['congratulations_format_custom'] = 'Your own message';
$lang['congratulations_format_custom_e'] = 'You can write your own congratulations';
$lang['generate_time'] = 'Page generated in';
$lang['second'] = 'second';
$lang['seconds'] = 'seconds';
$lang['page_avatar'] = 'Avatar in header';
$lang['page_avatar_e'] = 'Not recomended for person using 800x600 resolution';
$lang['lang_q_quote'] = 'Quick quote selected.';
$lang['Warnings'] = 'Reprimand users';
$lang['Warnings_viewtopic'] = 'Reprimends';
$lang['warnings_banned_info'] = '<b>You are banned !</b><br /><br />You have: <b>%s</b> warnings with value: <b>%s</b>. Max. value is: <b>%s</b><br /><br />Last warning: <b>%s</b><br />Reason: <i>%s</i>';
$lang['disallow_posting'] = 'You exceed warnings limit. You can not posting new posts and topics.<br /><br />Click %sHERE%s to view warnings page.';
$lang['warnings_lastwar_info'] = '<b>You get new warning !</b><br /><br />Click %sHERE%s to see it.';
$lang['support'] = '<br /><br />If you can not fix this problem,<br />you can find help, or ask question at: <a href="http://przemo.org/phpBB2/forum/viewtopic.php?t=24" target="_blank">http://przemo.org/phpBB2/forum</a>';
$lang['poster_posts'] = 'You posted in this topic';
$lang['Sort_per_letter'] = 'Show only usernames starting with';
$lang['Others'] = 'others';
$lang['All'] = 'all';
$lang['ignore_topic_added'] = 'Selected topic/s added to your ignore list.<br />Don`t will be display in the unread topic list (or topics since last visit)<br /><br />Click %sHERE%s to view your topics ignore list.<br /><br />Click %sHERE%s to return index.';
$lang['ignore_mark'] = 'Ignore selected topics';
$lang['ignore_topics'] = 'Ignored topics';
$lang['list_ignore'] = 'Your list ignored topics';
$lang['ignore_list_empty'] = 'Your ignore topics list is empty.<br /><br />Click %sHERE%s to return index';
$lang['ignore_topic'] = 'Ignore this topic';
$lang['current_topic_ignore'] = 'You ignored this topic';
$lang['view_ignore_topics'] = 'Show ignore topics';
$lang['bbcode_ct_help'] = 'Topic color, showing on view forum';
$lang['topic_color'] = 'Topic color';
$lang['15_min'] = '15 min';
$lang['30_min'] = '30 min';
$lang['45_min'] = '45 min';
$lang['1_Hour'] = '1 Hour';
$lang['2_Hour'] = '2 Hours';
$lang['6_Hour'] = '6 Hours';
$lang['12_Hour'] = '12 Hours';
$lang['icons'] = 'All post/topic icons';
$lang['your_posts'] = 'your posts';
$lang['replys_last_post'] = 'replies since your last post';
$lang['unread_posts'] = 'unread posts';
$lang['posts_last_visit'] = 'posts since your last visit';
$lang['not_poster_post'] = 'You don`t posting this topic';
$lang['lang_q_quote_e'] = 'You can quote selected words. Mark words to quote and click here. You can quote more times';
$lang['ignore_topic_e'] = 'You can add this topic to your ignore list. It not will be show in the list topics and in the search results';
$lang['ignore_topic_submit_e'] = 'It add mar topics to your ignore list. Topics not will be show in the list topics and search results';
$lang['more_topicicons'] = 'You can choose more icons. If you click here it open new window with more icons';
$lang['online_minutes'] = 'Minutes oline: <b>%s</b>';
$lang['online_hours'] = 'Hours online: <b>%s</b>';
$lang['Viewing_topic'] = 'View topic';
$lang['gg_header_info_pm'] = 'Otrzymaes nowa prywatna wiadomosc od: %s';
$lang['gg_notify_topic'] = 'W twoim temacie: "%s" uytkownik: %s napisal odpowiedz';
$lang['l_notify_gg'] = 'Notify Gadu-Gadu';
$lang['l_notify_gg_e'] = 'If you choose notify Gadu-Gadu notifications about private messages and tracking topics will be send only to your Gadu_gadu<br />You should add %s number to your GG userlist if you want receive notices.';
$lang['l_notify_gg_forumlink'] = 'Adres forum: %s';
$lang['l_notify_gg_privmsg'] = 'Link do twojej skrzynki: %s';
$lang['l_notify_gg_topic'] = 'eby zobaczy temat kliknij: %s';
$lang['generate_queries'] = 'SQL queries';
$lang['unread_post'] = 'Unread post';
$lang['refresh'] = 'Refresh';
$lang['new_board_topic'] = 'Na forum %s uytkownik %s napisa nowy temat: %s';
$lang['new_board_post'] = 'Na forum %s uytkownik %s napisa odpowied w temacie: %s';
$lang['Search_post_time'] = 'Show posts last:</span><br /><span class="gensmall">It shows posted posts before choosing time. You can set shows method Topics and Posts';
$lang['allowpm'] = 'Allow your private messages';
$lang['allowpm_e'] = 'Allow sending private message for you';
$lang['open_all_new_window'] = 'Open all links in new windows';

$lang['s_email_friend'] = 'Notify friend about this topic';
$lang['s_email_friend_f_name'] = 'Friend name:';
$lang['s_email_friend_f_email'] = 'Friend email:';
$lang['s_email_friend_title'] = '%s just look this thread: %s';
$lang['s_email_friend_message'] = 'I read %s on the %s You must see it! Here is a link: %s';

$lang['mstr'] = 'Automatic repair table';
$lang['rrtf'] = 'The table %s is damage, attempt to auto repair failed:\n%s\n%s\nTry repair manually, execute query: REPAIR TABLE %s';
$lang['rrts'] = 'The table %s was damage, attempt to auto repair propably successfull:\n%s\n If not try repair manually, execute query REPAIR TABLE %s';
$lang['rrsum'] = 'Occured fine error, the script was attempt to repair and notice board administrator.';

$lang['Resync_page_title'] = 'Resync Forum Statistics';

$lang['Report_no_access'] = 'You haven\'t the permission to use this function of the report post hack!';
$lang['Report_disabled'] = 'Posts of this user can\'t be reported.';
$lang['Report_post_already_reported'] = 'This post is already reported';
$lang['Report_post_self'] = 'You can\'t report your own post.';
$lang['Report_already_removed'] = 'This report is already removed.';
$lang['Report_no_posts'] = 'No (additional) reported posts!';
$lang['Report_no_title'] = 'No title';
$lang['Reporter'] = 'Reporter';
$lang['Report_posts'] = 'Reported posts';
$lang['Report_popup_text'] = 'Follow posts has been reported:';
$lang['Report_deleted'] = 'Report removed.';
$lang['Report_post_reported'] = 'Report submitted. Thank you.';
$lang['Report_post'] = 'Report this post to Moderator/Admin.';
$lang['Report_del'] = 'Remove report.';
$lang['Report_no_popup'] = 'Open report popup on new reports';
$lang['Report_no_mail'] = 'Notify per email if someone report a post';
$lang['Report_reload_window'] = 'Reload window';
$lang['Report_no_auth'] = 'You can\'t report posts because you aren\'t logged in or this function is locked for you.';
$lang['Report_open_popup'] = 'Open report popup';
$lang['Report_list'] = 'Report list';
$lang['added'] = 'Added';
$lang['Voted_show'] = 'Voted : '; // it means :  users that voted  (the number of voters will follow)
$lang['Results_after'] = 'Results will be visible after the poll expires';
$lang['Poll_expires'] = 'Poll expires in : ';
$lang['Minutes'] = 'Minutes';
$lang['Max_vote'] = 'Maximum selections';
$lang['Max_vote_explain'] = '[ Enter 1 or leave blank to allow only one selection ]';
$lang['Max_voting_1_explain'] = 'Please select only ';
$lang['Max_voting_2_explain'] = ' answers';
$lang['Max_voting_3_explain'] = ' (selections above limit will be ignored)';
$lang['Vhide'] = 'Hide';
$lang['Hide_vote'] = 'Results';
$lang['Tothide_vote'] = 'Sum of votes';
$lang['Hide_vote_explain'] = ' [ Hide until poll expires ]';

$lang['helped_confirm'] = 'If you are this topic author and this reply help you, you can add one HELPED point for this user<br /><br />Click %sHERE%s to add point, or click %sHERE%s to cancel and return topic';
$lang['helped_added'] = 'Helped point added.<br />Click %sHERE%s to return.';
$lang['He_helped'] = 'If this post help you, click to add point for this user';
$lang['help_1'] = '';
$lang['help_more'] = ' times';
$lang['postrow_help'] = '<b>Helped:</b> ';
$lang['postrow_help_she'] = '<b>Helped:</b> ';
$lang['helped'] = 'Helped';
$lang['Joined_she'] = 'Joined';
$lang['redirect_info'] = 'You have to read %sTHIS%s informations, before review forum !%s';
$lang['that_same_msg'] = 'You can not post twice that same messages !';
$lang['Total_vots'] = 'Votes';
$lang['Seeker'] = 'Search users';
$lang['No_split_post'] = 'No split this message';
$lang['too_many_voting'] = 'Max voting is: <b>%s</b> for this pool, but you mark: <b> %s</b>.<br />Vote has not added, go back and vote one more time.';
$lang['failed_sending_email'] = 'Failed sending email<br />Maybe wrong e-mail address was hand, otherwise Admin should check email setting or disable sending email by forum.';

$lang['del_notify'] = 'Notify user about post / topic delete';
$lang['del_notify_reasons'] = '';
$lang['del_notify_reasons'][] = 'No reason';
$lang['del_notify_reasons'][] = 'Post nie na temat';
$lang['del_notify_reasons'][] = 'Post sprzeczny z regulaminem';
$lang['del_notify_reasons'][] = 'Post nie wnoszcy nic do tematu';
$lang['del_notify_reasons'][] = 'Niski poziom intelektualny postu';
$lang['del_notify_reason'] = 'Choice reason.';
$lang['del_notify_reason_e'] = 'If you choice "No reason", notify will be without reason.';
$lang['del_notify_reason2'] = 'Custom reason';
$lang['del_notify_reason2_e'] = 'Here you can write your own reason, list above will be ignore.';
$lang['del_notify_choice'] = 'Do not send notify';
$lang['notify_message'] = 'Your %s which you write on Forum: %s, was delete by Administrator or Moderator%s';
$lang['your_post'] = "\n\r\n\rYour post:";
$lang['reason'] = "\n\rReason";
$lang['subject_notify_delete'] = 'Your %s was delete';
$lang['topic_link'] = "\n\rTopic link: %s";
$lang['forum_service'] = 'Forum service';
$lang['confirm_report_post'] = 'Are you sure you want to report this post to the Moderator and Administrator?';
$lang['confirm_expire_topic'] = 'Are you sure to expiry this topic?';
$lang['Accept'] = 'Accept';
$lang['Reject'] = 'Reject';
$lang['Accept-reject'] = 'Accept/Reject choosed';
$lang['Post_no_approved'] = 'Waitung for accept';
$lang['Loser_protect'] = 'ATTENTION! You trying to reply on the <b>%s</b> page of topic, topic contain <b>%s</b> pages. Read first all topic before reply !!!<br /><br />Click %sHere%s to go to next page. Click%sHere%s if you sure want reply without reading all topic.';
$lang['User_deleted'] = 'Deleted';
$lang['Go_to_bottom'] = 'Go to bottom';
$lang['Account_delete'] = 'Account deletedon %s';
$lang['User_report_post'] = 'A User has reported a post';
$lang['Birthday_subject'] = 'Best wishes from opening of your %s birthday!!!';
$lang['Account_blocked'] = 'Your account blocked';
$lang['Setup_wrong'] = 'Wrong forum setup ! Check settings: Domain name, Server port, Script path.';
$lang['Subject_e'] = 'Subject explain';
$lang['Subject_e_info'] = 'not obligatory';
//
// That's all Folks!
// -------------------------------------------------

?>