<?php
/***************************************************************************
 *							login.php
 *							-------------------
 * begin					: Saturday, Feb 13, 2001
 * copyright			: (C) 2001 The phpBB Group
 * email					: support@phpbb.com
 * modification		: (C) 2005 Przemo http://www.przemo.org
 * date modification	: ver. 1.9 2005/03/06 19:00
 *
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 ***************************************************************************/

//
// Allow people to reach login page if
// board is shut down
//
define("IN_LOGIN", true);

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

if ( $board_config['check_address'] && $HTTP_HOST != $board_config['server_name'] && isset($HTTP_HOST) && $board_config['server_name'] && $board_config['script_path'] && !isset($HTTP_GET_VARS['redir']) )
{
	$server_protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
	$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
	$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
	$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
	$the_script_name = ($script_name == '') ? $script_name : '/' . $script_name;
	$script_name = ($script_name == '') ? $script_name . '/login.'.$phpEx : '/' . $script_name . '/login.'.$phpEx;

	$check_path_setup = @fopen($server_protocol . $server_name . $server_port . $the_script_name . '/extension.inc', 'r');
	if ( $check_path_setup )
	{
		@fclose($check_path_setup);
		$check_path_ok = true;
	}

	if ( $check_path_ok )
	{
		if ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) )
		{
			header('Refresh: 0; URL=' . $server_protocol . $server_name . $server_port . $script_name. '?redir=1');
			echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="0; url=' . $server_protocol . $server_name . $server_port . $script_name. '?redir=1"><title>Redirect</title></head><body><div align="center">If your browser does not support meta redirection please click <a href="' . $server_protocol . $server_name . $server_port . $script_name. '?redir=1">HERE</a> to be redirected</div></body></html>';
			exit;
		}

		// Behave as per HTTP/1.1 spec for others
		header('Location: ' . $server_protocol . $server_name . $server_port . $script_name. '?redir=1');
		exit;
	}
}

//
// Set page ID for session management
//
$userdata = session_pagestart($user_ip, PAGE_LOGIN);
init_userprefs($userdata);
//
// End session management
//

// session id check
if (!empty($HTTP_POST_VARS['sid']) || !empty($HTTP_GET_VARS['sid']))
{
	$sid = (!empty($HTTP_POST_VARS['sid'])) ? $HTTP_POST_VARS['sid'] : $HTTP_GET_VARS['sid'];
}
else
{
	$sid = '';
}

if ( isset($HTTP_POST_VARS['login']) || isset($HTTP_GET_VARS['login']) || isset($HTTP_POST_VARS['logout']) || isset($HTTP_GET_VARS['logout']) )
{
	if ( ( isset($HTTP_POST_VARS['login']) || isset($HTTP_GET_VARS['login']) ) && !$userdata['session_logged_in'] )
	{
		$username = isset($HTTP_POST_VARS['username']) ? trim(htmlspecialchars($HTTP_POST_VARS['username'])) : '';
		$username = substr(str_replace("\\'", "'", $username), 0, 25);
		$username = str_replace("'", "\\'", $username);
		$password = isset($HTTP_POST_VARS['password']) ? $HTTP_POST_VARS['password'] : '';

		$sql = "SELECT user_id, username, user_password, user_active, user_level, user_badlogin, user_blocktime, user_email, user_lang, user_timezone
			FROM " . USERS_TABLE . "
			WHERE username = '" . str_replace("\\'", "''", $username) . "'";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error in obtaining userdata', '', __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			if ( $row['user_level'] != ADMIN && $board_config['board_disable'] )
			{
				redirect(append_sid("index.$phpEx", true));
			}
			else
			{
				if ( md5($password) == $row['user_password'] && $row['user_active'] && $row['user_blocktime'] < time() )
				{
					$sql = "UPDATE " . USERS_TABLE . " SET user_badlogin = '0'
						WHERE username = '" . str_replace("\'", "''", $username) . "'";
					if ( !($result = $db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Error updating correct login data', '', __LINE__, __FILE__, $sql);
					}
					$row['user_badlogin'] = 0;
				}

				if ( $row['user_badlogin'] < $board_config['max_login_error'] && $row['user_blocktime'] < time() )
				{
					if ( md5($password) == $row['user_password'] && $row['user_active'] )
					{
						$autologin = ( isset($HTTP_POST_VARS['autologin']) ) ? TRUE : 0;

						$session_id = session_begin($row['user_id'], $user_ip, PAGE_INDEX, FALSE, $autologin);

						if ( $session_id )
						{
							$sql = "UPDATE " . USERS_TABLE . " SET user_badlogin = '0'
								WHERE username = '" . str_replace("\'", "''", $username) . "'";
							if ( !($result = $db->sql_query($sql)) )
							{
								message_die(GENERAL_ERROR, 'Error updating correct login data', '', __LINE__, __FILE__, $sql);
							}

							$url = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : "index.$phpEx";
							redirect(append_sid($url, true));
						}
						else
						{
							message_die(CRITICAL_ERROR, "Couldn't start session : login", "", __LINE__, __FILE__);
						}
					}
					else
					{
						$redirect = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : '';
						$redirect = str_replace('?', '&', $redirect);

						if (strstr(urldecode($redirect), "\n") || strstr(urldecode($redirect), "\r"))
						{
							message_die(GENERAL_ERROR, 'Tried to redirect to potentially insecure url.');
						}

						$template->assign_vars(array(
							'META' => '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("login.$phpEx?redirect=$redirect") . '">')
						);

						if ( $row['user_active'] )
						{
							//count bad login
							// block the user for X min
							if ( ($row['user_badlogin'] + 1) % $board_config['max_login_error'] )
							{
								$sql = "UPDATE " . USERS_TABLE . " SET user_badlogin = user_badlogin + 1
									WHERE username = '" . str_replace("\'", "''", $username) . "'";
								if ( !($result = $db->sql_query($sql)) )
								{
									message_die(GENERAL_ERROR, 'Error updating bad login data', '', __LINE__, __FILE__, $sql);
								}
							}
							else
							{
								$blocktime = ", user_block_by = '$user_ip', user_blocktime = '" . (time() + ($board_config['block_time'] * 60)) . "'";
								$sql = "UPDATE " . USERS_TABLE . "
									SET user_badlogin = user_badlogin + 1 $blocktime
									WHERE username = '" . str_replace("\'", "''", $username) . "'";
								if ( !($result = $db->sql_query($sql)) )
								{
									message_die(GENERAL_ERROR, 'Error updating bad login data' . $user_ip, '', __LINE__, __FILE__, $sql);
								}

								if ( $row['user_email'] && $row['user_blocktime'] < (time() - 3600) )
								{
									include($phpbb_root_path . 'includes/emailer.'.$phpEx);
									$emailer = new emailer($board_config['smtp_delivery']);

									$emailer->from($board_config['email_from']);
									$emailer->replyto($board_config['email_return_path']);

									$emailer->email_address($row['user_email']);
									$emailer->use_template('bad_login', (file_exists(@phpbb_realpath($phpbb_root_path . "language/lang_" . $row['user_lang'] . "/email/bad_login.tpl"))) ? $row['user_lang'] : '' );
									$emailer->set_subject($lang['Account_blocked']);

									$emailer->assign_vars(array(
										'USER' => $row['username'],
										'BLOCK_TIME' => $board_config['block_time'],
										'BAD_LOGINS' => ($row['user_badlogin'] + 1),
										'BLOCK_UNTIL' => create_date ('D d. M, Y H:i:s', (time() + ($board_config['block_time'] * 60)), $row['user_timezone']),
										'SITENAME' => $board_config['sitename'],
										'BOARD_EMAIL' => $board_config['board_email'])
									);
									$emailer->send();
									$emailer->reset();
								}
							}
						}
						$message = $lang['Error_login'] . '<br /><br />' . sprintf($lang['Click_return_login'], '<a href="' . append_sid("login.$phpEx?redirect=$redirect") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
						message_die(GENERAL_MESSAGE, $message);
					}
				}
				else
				{
					$message = (($lang['Error_login_tomutch']) ? $lang['Error_login_tomutch'] : $lang['Error_login']) . '<br /><br />' . sprintf($lang['Click_return_login'], '<a href="' . append_sid("login.$phpEx?redirect=$redirect") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
					message_die(GENERAL_MESSAGE, $message);
				}
			}
		}
		else
		{
			$redirect = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : "";
			$redirect = str_replace("?", "&", $redirect);
			if (strstr(urldecode($redirect), "\n") || strstr(urldecode($redirect), "\r"))
			{
				message_die(GENERAL_ERROR, 'Tried to redirect to potentially insecure url.');
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=login.' . $phpEx . '?redirect=' . $redirect . '">')
			);

			$message = $lang['Error_login'] . '<br /><br />' . sprintf($lang['Click_return_login'], '<a href="login.' . $phpEx . '?redirect=' . $redirect . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
	}
	else if ( ( (isset($HTTP_GET_VARS['logout']) && $HTTP_GET_VARS['sid'] == $userdata['session_id']) || isset($HTTP_POST_VARS['logout']) ) && $userdata['session_logged_in'] )
	{
		if ( $userdata['session_logged_in'] )
		{
			session_end($userdata['session_id'], $userdata['user_id']);
		}

		if (!empty($HTTP_POST_VARS['redirect']) || !empty($HTTP_GET_VARS['redirect']))
		{
			$url = (!empty($HTTP_POST_VARS['redirect'])) ? htmlspecialchars($HTTP_POST_VARS['redirect']) : htmlspecialchars($HTTP_GET_VARS['redirect']);
			$url = str_replace('&amp;', '&', $url);
			redirect(append_sid($url, true));
		}
		else
		{
			redirect(append_sid("index.$phpEx", true));
		}
	}
	else
	{
		$url = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : "index.$phpEx";
		redirect(append_sid($url, true));
	}
}
else
{
	//
	// Do a full login page dohickey if
	// user not already logged in
	//
	if ( !$userdata['session_logged_in'] )
	{
		$page_title = $lang['Login'];
		include($phpbb_root_path . 'includes/page_header.'.$phpEx);

		$template->set_filenames(array(
			'body' => 'login_body.tpl')
		);

		if ( isset($HTTP_POST_VARS['redirect']) || isset($HTTP_GET_VARS['redirect']) )
		{
			$forward_to = $HTTP_SERVER_VARS['QUERY_STRING'];

			if ( preg_match("/^redirect=([a-z0-9\.#\/\?&=\+\-_]+)/si", $forward_to, $forward_matches) )
			{
				$forward_to = ( !empty($forward_matches[3]) ) ? $forward_matches[3] : $forward_matches[1];
				$forward_match = explode('&', $forward_to);

				if (count($forward_match) > 1 )
				{
					$forward_page = '';

					for($i = 1; $i < count($forward_match); $i++)
					{
						if( !ereg("sid=", $forward_match[$i]) )
						{
							if( $forward_page != '' )
							{
								$forward_page .= '&';
							}
							$forward_page .= $forward_match[$i];
						}
					}
					$forward_page = $forward_match[0] . '?' . $forward_page;
				}
				else
				{
					$forward_page = $forward_match[0];
				}
			}
		}
		else
		{
			$forward_page = '';
		}

		$username = ( $userdata['user_id'] != ANONYMOUS ) ? $userdata['username'] : '';

		$s_hidden_fields = '<input type="hidden" name="redirect" value="' . $forward_page . '" />';

		make_jumpbox('viewforum.'.$phpEx, $forum_id);
		$template->assign_vars(array(
			'USERNAME' => $username,

			'L_ENTER_PASSWORD' => $lang['Enter_password'],
			'L_SEND_PASSWORD' => $lang['Forgotten_password'],

			'U_SEND_PASSWORD' => append_sid("profile.$phpEx?mode=sendpassword"),
			'S_HIDDEN_FIELDS' => $s_hidden_fields)
		);

		$template->pparse('body');

		include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
	}
	else
	{
		redirect(append_sid("index.$phpEx", true));
	}
}

?>