<?php
/***************************************************************************
 *						memberlist.php
 *						-------------------
 *	begin				: Friday, May 11, 2001
 *	copyright			: (C) 2001 The phpBB Group
 *	email				: support@phpbb.com
 *	modification		: (C) 2003 Przemo http://www.przemo.org
 *	date modification	: ver. 1.9 2004/05/12 14:20
 *
 *	$Id: memberlist.php,v 1.8.9 2004/05/12 14:20
 ***************************************************************************/

/***************************************************************************
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

// Start session management
$userdata = session_pagestart($user_ip, PAGE_VIEWMEMBERS);
init_userprefs($userdata);
// End session management

if ( $userdata['session_logged_in'] && $board_config['redirect_after_registering'] )
{
	if ((time() - $userdata['user_lastvisit']) < $board_config['r_a_r_time'] )
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['redirect_info'], '<a href="' . $board_config['redirect_address'] . '">', '</a>', '<meta http-equiv="refresh" content="4;url=' . $board_config['redirect_address'] . '">'));
	}
}

$user_topics_per_page = ($userdata['user_topics_per_page'] > 0) ? $userdata['user_topics_per_page'] : '25';

if ( isset($HTTP_POST_VARS['letter']) )
{
	$by_letter = ($HTTP_POST_VARS['letter']) ? htmlspecialchars($HTTP_POST_VARS['letter']) : 'all';
}
else if ( isset($HTTP_GET_VARS['letter']) )
{
	$by_letter = ($HTTP_GET_VARS['letter']) ? htmlspecialchars($HTTP_GET_VARS['letter']) : 'all';
}

if ( $board_config['login_require'] && !$userdata['session_logged_in'] || ( $board_config['crestrict'] && !$userdata['session_logged_in'] ) )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = 'joined';
}

if ( isset($HTTP_POST_VARS['order']) )
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if ( isset($HTTP_GET_VARS['order']) )
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

// Memberlist sorting
$mode_types_text = array($lang['Sort_Joined'], $lang['Sort_Last_visit'], $lang['Sort_Username'], $lang['Location'], $lang['Total_posts'], $lang['Email'], $lang['Website'], $lang['Sort_Top_Ten'], $lang['helped']);
$mode_types = array('joined', 'lastvisit', 'username', 'location', 'posts', 'email', 'website', 'topten', 'special_rank');

$custom_fields_exists = (custom_fields('check', '')) ? true : false;
$sql_cf = '';
if ( $custom_fields_exists )
{
	$custom_fields = custom_fields();
	for($i = 0; $i < count($custom_fields[0]); $i++)
	{
		$split_field = 'user_field_' . $custom_fields[0][$i];
		$fields_array[] = $split_field; 
		$custom_fields[1][$i] = str_replace(array('-#', '<br>'), array('',''), $custom_fields[1][$i]);
		$cf_lang = (isset($lang[$custom_fields[1][$i]])) ? $lang[$custom_fields[1][$i]] : $custom_fields[1][$i];
		$mode_types_text[] =  $cf_lang;
		$mode_types[] = $split_field;
		$sql_cf .= ', ' . $split_field;
		if ( $mode == $split_field )
		{
			$memberlist_lang_cf = $cf_lang;
			$memberlist_cf = $split_field;
		}
	}
}

$select_sort_mode = '<select name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if ( $sort_order == 'ASC' )
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

// Generate page
$page_title = $lang['Memberlist'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'memberlist_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

if ( $mode == 'special_rank' )
{
	$l_from = $lang['helped'];
}
else if ( $memberlist_lang_cf )
{
	$l_from = $memberlist_lang_cf;
}
else
{
	$l_from = $lang['Location'];
}

$template->assign_vars(array(
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_EMAIL' => $lang['Email'],
	'L_WEBSITE' => $lang['Website'],
	'L_FROM' => $l_from,
	'L_ORDER' => $lang['Order'],
	'L_SORT' => $lang['Sort'],
	'L_SUBMIT' => $lang['Sort'],
	'L_AIM' => $lang['AIM'],
	'L_YIM' => $lang['YIM'],
	'L_MSNM' => $lang['MSNM'],
	'L_ICQ' => $lang['ICQ'], 
	'L_JOINED' => $lang['Joined'], 
	'L_LAST_VISIT' => $lang['Last_visit'],
	'L_POSTS' => $lang['Posts'], 
	'L_POST_TIME' => $lang['Last_Post'],

	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'S_MODE_ACTION' => append_sid("memberlist.$phpEx"),
	'U_STAFF' => ($board_config['staff_enable']) ? '<a href="' . append_sid("staff.$phpEx") . '" class="nav">' . $lang['Staff'] . '</a>' : '',
	'U_SEARCH_USERS' => '<a href="' . append_sid("seeker.$phpEx") . '" class="nav">' . $lang['Seeker'] . '</a>',
	'CGG_OFF1' => (!$board_config['cgg']) ? '<!--' : '',
	'CGG_OFF2' => (!$board_config['cgg']) ? '-->' : '',
	'CLLOGIN_OFF1' => (!$board_config['cllogin']) ? '<!--' : '',
	'CLLOGIN_OFF2' => (!$board_config['cllogin']) ? '-->' : '')
);

switch( $mode )
{
	case 'joindate':
		$order_by = "user_regdate ASC LIMIT $start, " . $user_topics_per_page;
		break;
	case 'lastvisit':
		$order_by = "user_lastvisit $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
	case 'username':
		$order_by = "username $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
	case 'location':
		$order_by = "user_from $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
	case 'posts':
		$order_by = "user_posts $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
	case 'email':
		$order_by = "user_email $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
	case 'website':
		$order_by = "user_website $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
	case 'topten':
		$order_by = "user_posts $sort_order LIMIT 10";
		break;
	case 'special_rank':
		$order_by = "special_rank $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
	default:
		$order_by = "user_regdate $sort_order LIMIT $start, " . $user_topics_per_page;
		break;
}

if ( $custom_fields_exists )
{
	$custom_fields = custom_fields();
	for($i = 0; $i < count($custom_fields[0]); $i++)
	{
		$split_field = 'user_field_' . $custom_fields[0][$i];
		if ( $mode == $split_field )
		{
			$order_by = "$split_field $sort_order LIMIT $start, " . $user_topics_per_page;
		}
	}
}

// Set per-letter selection
$others_sql = $select_letter = '';
$mode_letter = (!isset($HTTP_GET_VARS['mode']) && !isset($HTTP_POST_VARS['mode'])) ? '' : '&amp;mode=' . $mode;
for ($i = 97; $i <= 122; $i++)
{
	$others_sql .= " AND username NOT LIKE '" . chr($i) . "%' ";
	$select_letter .= ( $by_letter == chr($i) ) ? chr($i) . '&nbsp;' : '<a href="' . append_sid("memberlist.$phpEx?letter=" . chr($i) . $mode_letter . "&amp;order=$sort_order&amp;start=$start") . '">' . chr($i) . '</a>&nbsp;';
}
$select_letter .= ( $by_letter == 'others' ) ? $lang['Others'] . '&nbsp;' : '<a href="' . append_sid("memberlist.$phpEx?letter=others" . $mode_letter . "&amp;order=$sort_order&amp;start=$start") . '">' . $lang['Others'] . '</a>&nbsp;';
$select_letter .= ( $by_letter == 'all' ) ? $lang['All'] : '<a href="' . append_sid("memberlist.$phpEx?letter=all" . $mode_letter . "&amp;order=$sort_order&amp;start=$start") . '">' . $lang['All'] . '</a>';

$template->assign_vars(array(
	'L_SORT_PER_LETTER' => $lang['Sort_per_letter'],
	'S_LETTER_SELECT' => $select_letter,
	'S_LETTER_HIDDEN' => '<input type="hidden" name="letter" value="' . $by_letter . '" />')
);

if ( $by_letter == 'all' )
{
	$letter_sql = '';
}
else if ( $by_letter == 'others' )
{
	$letter_sql = $others_sql;
}
else
{
	$letter_sql = " AND username LIKE '" . substr($by_letter, 0, 1) . "%' ";
}

$order_by = (isset($HTTP_GET_VARS['letter']) && !isset($HTTP_GET_VARS['mode']) && !isset($HTTP_POST_VARS['mode']) ) ? "username $sort_order LIMIT $start, " . $user_topics_per_page : $order_by;

$sql = "SELECT username, user_id, user_level, user_viewemail, user_posts, user_lastvisit, user_regdate, user_from, user_website, user_email, user_icq, user_aim, user_yim, user_msnm, user_avatar, user_avatar_type, user_allowavatar, user_gender, user_custom_color, can_custom_color, special_rank $sql_cf
	 FROM " . USERS_TABLE . "
	WHERE user_id <> " . ANONYMOUS . "$letter_sql
	ORDER BY $order_by";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$numusers = $db->sql_numrows();
	$i = 0;
	do
	{
		$username = $row['username'];
		$user_id = $row['user_id'];

		if ( $row['user_level'] == ADMIN )
		{
			$username = '<b>' . $username . '</b>';
		}
		else if ( is_jr_admin_buffered($row['user_id']) )
		{
			$username = '<u>' . $username . '</u>';
		}
		else if ( ($numusers < 3 && is_mod($row['user_id'])) || is_mod_buffered($row['user_id']) )
		{
			$username = '<i>' . $username . '</i>';
		}

		$from = ( !empty($row['user_from']) ) ? $row['user_from'] : '&nbsp;';
		$joined = create_date($board_config['default_dateformat'], $row['user_regdate'], $board_config['board_timezone']);
		$last_visit = (!empty($row['user_lastvisit'])) ? create_date($board_config['default_dateformat'], $row['user_lastvisit'], $board_config['board_timezone']) : $lang['Never'];

		$posts = ( $row['user_posts'] ) ? $row['user_posts'] : 0;

		$poster_avatar = '';
		if ( $row['user_avatar_type'] && $user_id != ANONYMOUS && $row['user_allowavatar'] )
		{
			switch( $row['user_avatar_type'] )
			{
				case USER_AVATAR_UPLOAD:
					$poster_avatar = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $row['user_avatar'] . '" alt="" border="0" />' : '';
					break;
				case USER_AVATAR_REMOTE:
					$poster_avatar = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $row['user_avatar'] . '" alt="" border="0" />' : '';
					break;
				case USER_AVATAR_GALLERY:
					$poster_avatar = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $row['user_avatar'] . '" alt="" border="0" />' : '';
					break;
			}
		}

		$gender_image = '';

		if ( $board_config['gender'] )
		{
			switch ($row['user_gender'])
			{
				case 1 :
					$gender_image = '<img src="' . $images['icon_minigender_male'] . '" alt="' . $lang['Gender']. ':' . $lang['Male'] . '" title="' . $lang['Male'] . '" border="0" />';
				break;
				case 2 :
					$gender_image = '<img src="' . $images['icon_minigender_female'] . '" alt="' . $lang['Gender']. ':' . $lang['Female'] . '" title="' . $lang['Female'] . '" border="0" />';
				break;
				default :
					$gender_image = '';
			}
			$gender_image = ($gender_image != '') ? '&nbsp;' . $gender_image : '';			
		}

		$poster_custom_color = $row['user_custom_color'];
		$show_custom_color = '';
		$custom_color_mod = ''; 
		if ( $board_config['mod_nick_color'] == '' )
		{
			if ( $board_config['custom_color_use'] && $row['user_posts'] >= $board_config['allow_custom_color'] )
			{
				$show_custom_color = true;
			}
			if ( is_mod($row['user_id']) || $row['user_level'] == ADMIN || is_jr_admin($row['user_id']) )
			{
				$custom_color_mod = true;
			}
			if ( $board_config['custom_color_mod'] && $custom_color_mod )
			{
				$show_custom_color = true;
			}
			if ( $board_config['custom_color_view'] )
			{
				$show_custom_color = true;
			}

			if ( $show_custom_color && $row['can_custom_color'] && $poster_custom_color != '' && $board_config['mod_nick_color'] == '' )
			{
				$username = '<span style="color: #' . $poster_custom_color . '">' . $username . '</span>' . $gender_image;
			}
			else
			{
				$username = $username . $gender_image . '<br />';
			}
		}
		else
		{
			if ( $row['user_level'] == ADMIN && $row['can_custom_color'] )
			{
				$username = '<span style="color: #' . $poster_custom_color . '">' . $username . '</span>' . $gender_image;
			}
			else if ( $row['can_custom_color'] && (($numusers < 3 && is_mod($row['user_id'])) || is_mod_buffered($row['user_id'])) )
			{
				$username = '<span style="color: #' . $board_config['mod_nick_color'] . '">' . $username . '</span>' . $gender_image;
			}
			else if ( $row['can_custom_color'] )
			{
				$username = $username . $gender_image;
			}

		}

		if ( !empty($row['user_viewemail']) || $userdata['user_level'] == ADMIN )
		{
			$email_uri = ( $board_config['board_email_form'] ) ? append_sid("profile.$phpEx?mode=email&amp;" . POST_USERS_URL .'=' . $user_id) : 'mailto:' . $row['user_email'];

			$email_img = '<a href="' . $email_uri . '"><img src="' . $images['icon_email'] . '" alt="' . $lang['Send_email'] . '" title="' . $lang['Send_email'] . '" border="0" /></a>';
			$email = '<a href="' . $email_uri . '">' . $lang['Send_email'] . '</a>';
		}
		else
		{
			$email_img = '&nbsp;';
			$email = '&nbsp;';
		}

		$temp_url = append_sid("privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=$user_id");
		$pm_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_pm'] . '" alt="' . $lang['Send_private_message'] . '" title="' . $lang['Send_private_message'] . '" border="0" /></a>';
		$pm = '<a href="' . $temp_url . '">' . $lang['Send_private_message'] . '</a>';

		$www_img = ( $row['user_website'] ) ? '<a href="' . $row['user_website'] . '" target="_userwww"><img src="' . $images['icon_www'] . '" alt="' . $lang['Visit_website'] . '" title="' . $lang['Visit_website'] . '" border="0" /></a>' : '';
		$www = ( $row['user_website'] ) ? '<a href="' . $row['user_website'] . '" target="_userwww">' . $lang['Visit_website'] . '</a>' : '';

		if ( !empty($row['user_icq']) )
		{
			$icq_status_img = '<a href="http://wwp.icq.com/' . $row['user_icq'] . '#pager"><img src="http://web.icq.com/whitepages/online?icq=' . $row['user_icq'] . '&amp;img=5" alt="" width="18" height="18" border="0" /></a>';
			$icq_img = '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $row['user_icq'] . '"><img src="' . $images['icon_icq'] . '" alt="' . $lang['ICQ'] . '" title="' . $lang['ICQ'] . '" border="0" /></a>';
			$icq = '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $row['user_icq'] . '">' . $lang['ICQ'] . '</a>';
		}
		else
		{
			$icq_status_img = '';
			$icq_img = '';
			$icq = '';
		}

		if ( !empty($row['user_aim']) )
 		{
			$gg_url = append_sid("gg.$phpEx?mode=gadu&amp;" . POST_USERS_URL . '=' . $user_id);
			$aim_status_img = '<a href="' . $gg_url . '"><img title="GG: ' . $row['user_aim'] . '" alt="' . $row['user_aim'] . '" src="http://www.gadu-gadu.pl/users/status.asp?id=' . $row['user_aim'] . '&amp;img=5" width="18" height="18" border="0" /></a>';
			$aim_img = '<a href="' . $gg_url . '"><img src="' . $images['icon_aim'] . '" alt="' . $lang['AIM'] . '" title="' . $lang['AIM'] . '" border="0" /></a>';
			$aim = '<a href="' . $gg_url . '">' . $lang['AIM'] . '</a>';
		}
		else
		{
			$aim_status_img = '';
			$aim_img = '';
			$aim = '';
		}
		$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id");
		$msn_img = ( $row['user_msnm'] ) ? '<a href="' . $temp_url . '"><img src="' . $images['icon_msnm'] . '" alt="' . $lang['MSNM'] . '" title="' . $lang['MSNM'] . '" border="0" /></a>' : '';
		$msn = ( $row['user_msnm'] ) ? '<a href="' . $temp_url . '">' . $lang['MSNM'] . '</a>' : '';

		$yim_img = ( $row['user_yim'] ) ? '<a href="http://edit.yahoo.com/config/send_webmesg?.target=' . $row['user_yim'] . '&amp;.src=pg"><img src="' . $images['icon_yim'] . '" alt="' . $lang['YIM'] . '" title="' . $lang['YIM'] . '" border="0" /></a>' : '';
		$yim = ( $row['user_yim'] ) ? '<a href="http://edit.yahoo.com/config/send_webmesg?.target=' . $row['user_yim'] . '&amp;.src=pg">' . $lang['YIM'] . '</a>' : '';

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];
		
		$post_time_sql = "SELECT post_time
			FROM " . POSTS_TABLE . "
			WHERE poster_id = $user_id
			ORDER BY post_time DESC
			LIMIT 1";
		
		if ( !($post_time_result = $db->sql_query($post_time_sql)) ) 
		{ 
			message_die(GENERAL_ERROR, 'Error getting user last post time', '', __LINE__, __FILE__, $post_time_sql); 
		} 
		
		$post_time_row = $db->sql_fetchrow($post_time_result); 
		$last_post_time = (isset($post_time_row['post_time'])) ? create_date($board_config['default_dateformat'], $post_time_row['post_time'], $board_config['board_timezone']) : $lang['None'];

		if ( $mode == 'special_rank' )
		{
			$from = $row['special_rank'];
		}
		else if ( $memberlist_cf )
		{
			require_once($phpbb_root_path . 'includes/bbcode.'.$phpEx);
			$from = make_clickable($row[$memberlist_cf]);

			$remove_string = array('.gif', '.jpg', '<br>', '-#');
			$replace_string = array('', '', '', '');
			if ( eregi('.gif', $from) || eregi('.jpg', $from) )
			{
				$field_name = str_replace(array('_', '.gif', '.jpg'), array(' ', '', ''), $from);
				$from = (file_exists($images['images'] . '/custom_fields/' . $from)) ? '<img src="' . $images['images'] . '/custom_fields/' . $from . '" border="0" alt="' . $field_name . '" title="' . $field_name . '" align="top" /><br />' : $from;
			}
		}

		$template->assign_block_vars('memberrow', array(
			'ROW_NUMBER' => $i + ( $start + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'USERNAME' => $username,
			'FROM' => $from,
			'JOINED' => $joined,
			'LAST_VISIT' => ($board_config['cllogin']) ? $last_visit : '',
			'POSTS' => $posts,
			'AVATAR_IMG' => $poster_avatar,
			'PROFILE_IMG' => $profile_img,
			'PM_IMG' => $pm_img,
			'PM' => $pm,
			'EMAIL_IMG' => $email_img,
			'EMAIL' => $email,
			'WWW_IMG' => $www_img,
			'WWW' => $www,
			'ICQ_STATUS_IMG' => $icq_status_img,
			'ICQ_IMG' => $icq_img,
			'ICQ' => $icq,
			'AIM_IMG' => $aim_img,
			'AIM' => $aim,
			'AIM_STATUS_IMG' => ($board_config['cgg']) ? $aim_status_img : '',
			'MSN_IMG' => $msn_img,
			'MSN' => $msn,
			'YIM_IMG' => $yim_img,
			'YIM' => $yim,
			'LAST_POST_TIME' => $last_post_time,
			'CGG_OFF1' => $cgg_off1,
			'CGG_OFF2' => $cgg_off2,
			
			'U_VIEWPROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id"))
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}

if ( $mode != 'topten' || $user_topics_per_page < 10 )
{
	$sql = "SELECT count(user_id) AS total
		FROM " . USERS_TABLE . "
		WHERE user_id <> " . ANONYMOUS . $letter_sql;

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_members = $total['total'];
		$pagination = generate_pagination("memberlist.$phpEx?mode=$mode&amp;order=$sort_order&amp;letter=$by_letter", $total_members, $user_topics_per_page, $start). '&nbsp;';
	}
}
else
{
	$pagination = '&nbsp;';
	$total_members = 10;
}

$page_number = sprintf($lang['Page_of'], ( floor( $start / $user_topics_per_page ) + 1 ), ceil( $total_members / $user_topics_per_page ));
if ( ceil( $total_members / $user_topics_per_page ) == 1 )
{
	$page_number = '';
}

$template->assign_vars(array(
	'USERNAME_STYLE_E' => sprintf($lang['Admin_online_color'], '<b>', '</b>') . ', ' . sprintf($lang['Junior_online_color'], '<u>', '</u>') . ', ' . sprintf($lang['Mod_online_color'], '<i>', '</i>'),
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => $page_number,

	'L_GOTO_PAGE' => $lang['Goto_page'])
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>