<?php
/***************************************************************************
 *				portal.php
 *				-------------------
 * Author		: (C) 2003 Przemo http://www.przemo.org
 * date			: ver. 1.9 2003/06/15 21:00
 *
 *	Build on the engine ezPortal by Smartor
 *	For full configurable i move here all HTML code from .tpl
 *
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 ***************************************************************************/

define('IN_PHPBB', true);
define('PORTAL', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'fetchposts.'.$phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

if ( $userdata['session_logged_in'] && $board_config['redirect_after_registering'] )
{
	if ((time() - $userdata['user_lastvisit']) < $board_config['r_a_r_time'] )
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['redirect_info'], '<a href="' . $board_config['redirect_address'] . '">', '</a>', '<meta http-equiv="refresh" content="4;url=' . $board_config['redirect_address'] . '">'));
	}
}

if ( $board_config['login_require'] && !$userdata['session_logged_in'] )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

if ( !$portal_config['portal_on'] )
{
	redirect(append_sid("index.$phpEx?redirect=index.$phpEx", true));
}

$portal_page = 1;

$row1 = $theme['td_class1'];
$row2 = $theme['td_class2'];

include('includes/page_header.'.$phpEx);

require($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_portal.' . $phpEx);

$sql = "SELECT config_value FROM " . PORTAL_CONFIG_TABLE . "
	WHERE config_name LIKE 'module%'
	 AND config_value <> ''";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(CRITICAL_ERROR, 'Could not query portal config information', '', __LINE__, __FILE__, $sql);
}

$modules = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$modules[] = $row['config_value'];
}

if ( in_array('stats_user_menu', $modules) )
{
	$total_topics = get_db_stat('topiccount');
	$total_posts = get_db_stat('postcount');
	$total_users = get_db_stat('usercount');
	$newest_userdata = get_db_stat('newestuser');
	$newest_user = $newest_userdata['username'];
	$newest_uid = $newest_userdata['user_id'];
	$stats_user_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" align="' . $portal_config['stat_a'] . '" height="25"><span class="genmed"><b>' . $lang['Statistics'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['stat_a'] . '"><span class="gensmall">' . $lang['users_write'] . ' <b>' . $total_posts . '</b> ' . $lang['posts'] . ', <b>' . $total_topics . '</b> ' . $lang['topics'] . '</span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['stat_a'] . '"><span class="gensmall">' . $lang['registered_have'] . ' <b>' . $total_users . '</b> ' . $lang['registered_users'] . '</span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['stat_a'] . '"><span class="gensmall">' . sprintf($lang['Newest_user'], '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$newest_uid") . '">', $newest_user, '</a>') . '</span></td></tr></table><br />';
}

// Recent Topics
$recent_topics_menu = '';
if ( $portal_config['value_recent_topics'] > 0 )
{
	$sql = "SELECT * FROM ". FORUMS_TABLE . "
		ORDER BY forum_id";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not query forums information', '', __LINE__, __FILE__, $sql);
	}
	$forum_data = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_data[] = $row;
	}

	$is_auth_ary = array();
	$is_auth_ary = auth(AUTH_ALL, AUTH_LIST_ALL, $userdata, $forum_data);

	$except_forum_id = ($portal_config['except_forum'] == '') ? '\'start\'' : $portal_config['except_forum'];
	for ($i = 0; $i < count($forum_data); $i++)
	{
		if ( (!$is_auth_ary[$forum_data[$i]['forum_id']]['auth_read']) or (!$is_auth_ary[$forum_data[$i]['forum_id']]['auth_view']) )
		{
			if ( $except_forum_id == '\'start\'' )
			{
				$except_forum_id = $forum_data[$i]['forum_id'];
			}
			else
			{
				$except_forum_id .= ',' . $forum_data[$i]['forum_id'];
			}
		}
	}

	$sql = "SELECT topic_id, topic_title
			FROM " . TOPICS_TABLE . "
			WHERE forum_id NOT IN (" . $except_forum_id . ")
				AND topic_status <> 2
			ORDER BY topic_time DESC
			LIMIT " . $portal_config['value_recent_topics'];
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not query recent topics information', '', __LINE__, __FILE__, $sql);
	}

	$recent_topic_row = array();
	if ( $portal_config['scroll_recent_topics'] )
	{
		$recent_topics_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td align="' . $portal_config['recent_topics_a'] . '" class="catHead" height="25"><span class="genmed"><b>' . $lang['Recent_topics'] . '</b></span></td></tr><tr><td class="' . $row1 . '"><span class="gensmall">';
		while ($row = $db->sql_fetchrow($result))
		{
			$recent_topics_menu .= '&raquo; <a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $row['topic_id']) . '" style="text-decoration: none;">' . $row['topic_title'] . '</a><br />';
		}
	}
	else
	{
		$recent_topics_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td align="' . $portal_config['recent_topics_a'] . '" class="catHead" height="25"><span class="genmed"><b>' . $lang['Recent_topics'] . '</b></span></td></tr>';
		while ($row = $db->sql_fetchrow($result))
		{
			$recent_topic_row[] = $row;
			$recent_topics_menu .= '<tr><td class="' . $row1 . '" align="' . $portal_config['recent_topics_a'] . '"><span class="gensmall">&raquo; <a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $row['topic_id']) . '" class="mainmenu">' . $row['topic_title'] . '</a></span></td></tr>';
		}
	}
	$recent_topics_menu .= '</span></td></tr></table><br />';
}
// End recent topics


$custom_footer = $portal_config['portal_footer_body'];
$minutes = date('is', time());
//$timetoday = ( time() - ( 60 * ($minutes[0] . $minutes[1]) ) - ( $minutes[2] . $minutes[3] ) ) - (3600 * ( create_date('H', time(), $board_config['board_timezone']) ));

if ( in_array('whoonline_menu', $modules) )
{
	$sql = "SELECT session_ip, MAX(session_time) as session_time FROM " . SESSIONS_TABLE . "
		WHERE session_user_id = '" . ANONYMOUS . "'
			AND session_time >= " . ( time() - 86400 ) . "
		GROUP BY session_ip";

	if ( !$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Couldn\'t retrieve guest user today data', '', __LINE__, __FILE__, $sql);
	}

	while( $guest_list = $db->sql_fetchrow($result))
	{ 
		if ( $guest_list['session_time'] > ( time() - 3600 ) )
		{
			$users_lasthour++;
		}
	}
	$guests_today = $db->sql_numrows($result);

	$time_to_show = ( time() - ( $board_config['last_visitors_time'] * 3600 ) );

	$sql = "SELECT user_id, username, user_allow_viewonline, user_level, user_lastvisit FROM " . USERS_TABLE . "
		WHERE user_id != '" . ANONYMOUS . "'
			AND user_session_time >= $time_to_show
		ORDER BY user_level DESC, username ASC";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Couldn\'t retrieve user today data', '', __LINE__, __FILE__, $sql); 
	}

	while( $todayrow = $db->sql_fetchrow($result)) 
	{ 
		$style_color = '';
		if ( $todayrow['user_lastvisit'] >= ( time() - 3600 ) )
		{
			$users_lasthour++;
		}

		if ( $todayrow['user_level'] == ADMIN )
		{
			$todayrow['username'] = '<b>' . $todayrow['username'] . '</b>';
			$style_color = 'style="color:#' . $theme['fontcolor3'] . '"';
		}
		else if ( is_jr_admin($todayrow['user_id']) )
		{
			$todayrow['username'] = '<u><b>' . $todayrow['username'] . '</b></u>';
			$style_color = 'style="color:#' . $theme['fontcolor2'] . '"';
		}
		else if ( is_mod($todayrow['user_id']) )
		{
			$todayrow['username'] = '<b>' . $todayrow['username'] . '</b>';
			$style_color = 'style="color:#' . $theme['fontcolor2'] . '"';
		}

		$users_today_list .= ($todayrow['user_allow_viewonline']) ? ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $todayrow['user_id']) . '"' . $style_color  . '>' . $todayrow['username'] . '</a>,' : (($userdata['user_level']==ADMIN) ? ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $todayrow['user_id']) . '"' . $style_color  . '><i>' . $todayrow['username'] . '</i></a>,' : '');
		if ( !$todayrow['user_allow_viewonline'] )
		{
			$logged_hidden_today++;
		}
		else
		{
			$logged_visible_today++;
		}
	}

	if ( $users_today_list )
	{
		$users_today_list[ strlen( $users_today_list)-1] = ' '; 
	}
	else
	{
		$users_today_list = $lang['None'];
	}
	$total_users_today = $db->sql_numrows($result) + $guests_today;

	$users_today_list = $users_today_list;
	$l_today_r_user_s = ($logged_visible_today) ? ( ( $logged_visible_today == 1 ) ? $lang['Reg_user_total'] : $lang['Reg_users_total'] ) : $lang['Reg_users_zero_total'];
	$l_today_h_user_s = ($logged_hidden_today) ? (($logged_hidden_today == 1) ? $lang['Hidden_user_total'] : $lang['Hidden_users_total'] ) : $lang['Hidden_users_zero_total'];
	$l_today_g_user_s = ($guests_today) ? (($guests_today == 1) ? $lang['Guest_user_total'] : $lang['Guest_users_total']) : $lang['Guest_users_zero_total'];
	$l_today_users = sprintf($l_today_user_s, $total_users_today);
	$l_today_users .= sprintf($l_today_r_user_s, $logged_visible_today);
	$l_today_users .= sprintf($l_today_h_user_s, $logged_hidden_today);
	$l_today_users .= sprintf($l_today_g_user_s, $guests_today);

	$users_lasthour_menu = ($users_lasthour) ? $lang['Users_lasthour_explain'] . ':<b>' . $users_lasthour . '</b>' : $lang['Users_lasthour_none_explain'];
	$whoonline_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['whoonline_a'] . '"><span class="genmed"><b>' . $lang['Who_is_Online'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['whoonline_a'] . '"><span class="gensmall">' . sprintf($lang['Day_users'], $board_config['last_visitors_time']) . '<br />' . $l_today_users . '</span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['whoonline_a'] . '"><span class="gensmall">' . $lang['today_register'] . ':<br />' . $users_today_list . '</span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['whoonline_a'] . '"><span class="gensmall">' . $users_lasthour_menu . '</span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['whoonline_a'] . '"><span class="gensmall">' . $l_online_users . '</span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['whoonline_a'] . '"><span class="gensmall">[ <a href="'.append_sid('viewonline.'.$phpEx).'" class="mainmenu">' . $lang['Who_is_Online'] . '</a> ]</span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['whoonline_a'] . '"><span class="gensmall">' . sprintf($lang['Record_online_users'], $board_config['record_online_users'], create_date($board_config['default_dateformat'], $board_config['record_online_date'], $board_config['board_timezone'])) . '</span></td></tr></table><br />';
}

// Begin top posters
$top_posters_menu = '';
if ( $portal_config['value_top_posters'] > 0 )
{
	$top_posters_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" colspan="2" height="25" align="' . $portal_config['top_posters_a'] . '"><span class="genmed"><b>' . $lang['top_posters'] . '</b></span></td></tr>';

	$sql = "SELECT user_id, username, user_posts
		FROM " . USERS_TABLE . "
		WHERE user_id > 0
		ORDER BY user_posts DESC
		LIMIT " . $portal_config['value_top_posters'];

	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not query top posters information', '', __LINE__, __FILE__, $sql);
	}
	while ($row = $db->sql_fetchrow($result))
	{
		if ( $row['user_posts'] > 0 )
		{
			$top_posters_menu .= '<tr><td class="' . $row1 . '" width="60%"><span class="gensmall"><a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;u=") . $row['user_id'] . '" class="mainmenu">' . $row['username'] . '</a></span></td><td class="' . $row1 . '"><span class="gensmall"> &nbsp;' . $lang['posts'] . ' <a href="' . append_sid("search.$phpEx?search_author=") . $row['username'] . '" class="mainmenu">' . $row['user_posts'] . '</a></span></td></tr>';
		}
	}
	$top_posters_menu .= '</table><br />';
}
// End top posters

if ( in_array('info_menu', $modules) )
{
	$l_searchnew = ($board_config['read_tracking']) ? $lang['Search_new_unread'] : $lang['Search_new'];

	//Count unread posts
	if ( $userdata['session_logged_in'] )
	{
		$sql_ignore_topics = '';
		if ( $board_config['ignore_topics'] )
		{
			$ignore_topics = $userdata['ignore_topics'];
			$sql_ignore_topics = ($ignore_topics) ? 'AND topic_id NOT IN (' . $ignore_topics . ')' : '';
		}
		if ( $board_config['read_tracking'] )
		{
			$sql = "SELECT COUNT(user_id) AS total
				FROM ". READ_HIST_TABLE ."
				WHERE user_id = " . $userdata['user_id'] . "
				$sql_ignore_topics";

			$result = $db->sql_query($sql);
			if ( $result )
			{
				$row = $db->sql_fetchrow($result);
				$l_searchnew = ($row['total']) ? $l_searchnew . '&nbsp;[' . $row['total'] . ']' : '';
			}
		}
		else
		{
			$sql = "SELECT COUNT(post_id) as total
				FROM " . POSTS_TABLE . "
				WHERE post_time >= " . $userdata['user_lastvisit'] . "
				$sql_ignore_topics";

			$result = $db->sql_query($sql);
			if ( $result )
			{
				$row = $db->sql_fetchrow($result);
				$l_searchnew = ($row['total']) ? $l_searchnew . '&nbsp;[' . $row['total'] . ']' : '';
			}
		}
	}
	$change_style_li = '';
	$change_style_lo = '';
	if ( $board_config['cstyles'] )
	{
		$change_style_li = '<tr><td class="' . $row1 . '"><form method="post" name="quickchange" action="' . append_sid("portal.$phpEx") . '"><table border="0"><tr><td class="' . $row1 . '" align="' . $portal_config['info_a'] . '"><span class="gensmall">' . $lang['Change_style'] . ':<br />' . style_select($userdata['user_style'], 'fpage_theme') . '</span></td></tr></table></form></td></tr>';
		$change_style_lo = '<tr><td class="' . $row2 . '"><form method="post" name="quickchange" action="' . append_sid("portal.$phpEx") . '"><table border="0"><tr><td class="' . $row2 . '" align="' . $portal_config['info_a'] . '"><span class="gensmall">' . $lang['Change_style'] . ':<br />' . style_select($board_config['default_style'], 'template') . '</span></td></tr></table></form></td></tr>';
	}

	if ( $userdata['session_logged_in'] )
	{
		$info_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['info_a'] . '"><span class="genmed"><b>' . $lang['Welcome'] . ' ' . $name_link . '</b></span></td></tr><tr><td class="' . $row1 . '" align="center"><span class="gensmall">' . $avatar_img . '</span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['info_a'] . '"><span class="gensmall">' . sprintf($lang['You_last_visit'], $s_last_visit) . '</td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['info_a'] . '"><span class="gensmall"><a href="'.append_sid("search.$phpEx?search_id=newposts") . '" class="gensmall">' . $l_searchnew . '</a></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['info_a'] . '"><span class="gensmall">' . sprintf($lang['Current_time'], create_date($board_config['default_dateformat'], time(), $board_config['board_timezone'])) . '</td></tr>' . $change_style_li . '</table><br />';
	}
	else
	{
		$info_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['info_a'] . '"><span class="genmed"><b>' . $lang['Welcome'] . ' ' . $name_link . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['info_a'] . '"><span class="gensmall">' . sprintf($lang['Current_time'], create_date($board_config['default_dateformat'], time(), $board_config['board_timezone'])) . '</span></td></tr>' . $change_style_lo . '</table><br />';
	}
}
//end count unread posts

$birthday_today_list = '';
$birthday_week_list = '';
if ( $board_config['cbirth'] && in_array('birthday_menu', $modules))
{
	// Birthday Mod, Show users with birthday 
	$sql = "SELECT user_id, username, user_birthday, user_level FROM " . USERS_TABLE . "
		WHERE user_birthday <> 999999
		ORDER BY username";
	if ( $result = $db->sql_query($sql) )
	{
		$birthdayrow = $db->sql_fetchrowset($result);
		if ( !empty($birthdayrow) )
		{
			$year = create_date('Y', time(), $board_config['board_timezone']);
			$date_today = create_date('Ymd', time(), $board_config['board_timezone']);
			$date_forward = create_date('Ymd', time() + ($board_config['birthday_check_day'] * 86400), $board_config['board_timezone']);
			for($i = 0; $i < count($birthdayrow); $i++)
			{
				$user_birthday = realdate('md', $birthdayrow[$i]['user_birthday']);
				$user_birthday2 = (($year . $user_birthday < $date_today) ? $year + 1 : $year) . $user_birthday;
				if ( $user_birthday2 == $date_today )
				{
					//user have birthday today
					$user_age = $year - realdate ('Y', $birthdayrow[$i]['user_birthday']);
					$style_color = ($birthdayrow[$i]['user_level'] == ADMIN) ? 'style="color:#' . $theme['fontcolor3'] . '"' : (( is_mod($birthdayrow[$i]['user_id']) ) ? 'style="color:#' . $theme['fontcolor2'] . '"' : '');
			
					$current_year = create_date('Y', time(), $board_config['board_timezone']);

					$sql = "SELECT user_id FROM " . $table_prefix . "birthday
						WHERE user_id = '" . $userdata['user_id'] . "'
							AND send_user_id = '" . $birthdayrow[$i]['user_id'] . "'
							AND send_year = '" . $current_year . "'";

					$result = $db->sql_query($sql);
					$checkrow = $db->sql_fetchrowset($result);
					$congratulations_link = (!empty($checkrow) || $birthdayrow[$i]['user_id'] == $userdata['user_id']) ? '' : ' <a href="' . append_sid("index.$phpEx?mode=congratulations&amp;user=" . $birthdayrow[$i]['user_id'] . "&amp;user_age=" . $user_age . "") . '"' . $style_color . ' class="gensmall">(' . $lang['send_congratulations'] . ')</b></a>';

					$birthday_today_list .= '<tr><td class="' . $row1 . '" align="' . $portal_config['birthday_a'] . '"><span class="gensmall"><a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow[$i]['user_id']) . '" class="mainmenu"' . $style_color  . '><b>' . $birthdayrow[$i]['username'] . ' </a></b>(' . $user_age . ')' . $congratulations_link . '</span></td></tr>';
				}
				else if ( $user_birthday2 > $date_today && $user_birthday2 <= $date_forward )
				{
					// user are having birthday within the next days
					$user_age = ($year . $user_birthday < $date_today) ? $year - realdate('Y', $birthdayrow[$i]['user_birthday']) + 1 : $year - realdate('Y', $birthdayrow[$i]['user_birthday']);
					$style_color = ($birthdayrow[$i]['user_level'] == ADMIN ) ? 'style="color:#' . $theme['fontcolor3'] . '"' : (( is_mod($birthdayrow[$i]['user_id']) ) ? 'style="color:#' . $theme['fontcolor2'] . '"' : '');
					$birthday_week_list .= ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow[$i]['user_id']) . '"' . $style_color  . '><b>' . $birthdayrow[$i]['username'] . ' (' . $user_age . ')</b></a>';
				}
			}
		}
	}
	$zaaa = 365 - create_date('z', time(), $board_config['board_timezone']) + create_date('L', time(), $board_config['board_timezone']);
	$dm = create_date('j', time(), $board_config['board_timezone']);
	$rok = create_date('Y', time(), $board_config['board_timezone']);
	$godz = create_date('G:i', time(), $board_config['board_timezone']);
	$mc = create_date('n', time(), $board_config['board_timezone']);
	$data = "$mc-$dm";
	$td = '';
	$md = '';
	$birth_name = '';
	include($phpbb_root_path . 'includes/portal_data.'.$phpEx);

	$birthday_yes_no = ($birthday_today_list) ? $lang['Birthday_today'] : $lang['Nobirthday_today'];
	$birthday_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['birthday_a'] . '"><span class="genmed"><b>' . $lang['Today'] . ':</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['birthday_a'] . '"><span class="gensmall">' . $lang['Time'] . ': <b>' . $godz . '</b>, ' . $td . '<br />' . $dm . ' ' . $md . ' ' . $rok . '<br />' . $lang['year_left'] . ' ' . $zaaa . ' ' . $lang['days'] . '</span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['birthday_a'] . '"><span class="gensmall">' . $lang['kto_imieniny'] . ': <b>' . $birth_name . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['birthday_a'] . '"><span class="gensmall">' . $birthday_yes_no . ' ' . $birthday_today_list . '</span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['birthday_a'] . '"><span class="gensmall">' . sprintf((($birthday_week_list) ? $lang ['Birthday_week'] . $birthday_week_list : $lang ['Nobirthday_week']), $board_config['birthday_check_day']) . '</span></td></tr></table><br />';
}

$db->sql_freeresult($result);

// Start output of page

$template->set_filenames(array(
	'body' => 'portal_body.tpl')
);

if ( in_array('info_menu', $modules) )
{
	$avatar_img = '';
	if ( $userdata['user_avatar_type'] && $userdata['user_allowavatar'] )
	{
		switch( $userdata['user_avatar_type'] )
		{
			case USER_AVATAR_UPLOAD:
				$avatar_img = ($board_config['allow_avatar_upload']) ? '<img src="' . $board_config['avatar_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_REMOTE:
				$avatar_img = ($board_config['allow_avatar_remote']) ? '<img src="' . $userdata['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_GALLERY:
				$avatar_img = ($board_config['allow_avatar_local']) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : '';
				break;
		}
	}
	$name_link = ($userdata['session_logged_in']) ? '<a href="' . append_sid("profile.$phpEx?mode=editprofile&amp;" . $userdata['user_id']) . '">' . $userdata['username'] . '</a>' : $lang['Guest'];
}

// Change Style
if ( isset($HTTP_POST_VARS['fpage_theme']) )
{
	$fpage_theme = intval($HTTP_POST_VARS['fpage_theme']);
	$fp_sql = "UPDATE " . USERS_TABLE . "
		SET user_style = '$fpage_theme'
		WHERE user_id = " . $userdata['user_id'];
	if ( !($fp_result = $db->sql_query($fp_sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not update users table', '', __LINE__, __FILE__, $sql);
	}
	else
	{
		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="0 ;url=' .append_sid("portal.$phpEx") . '">')
		);
	}
}

// Fetch Posts from Announcements Forum
$open_bracket = '';
$close_bracket = '';
$read_full = '';
if ( (!$portal_config['own_body'] && $portal_config['witch_news_forum'] != '') || isset($HTTP_GET_VARS['s']) )
{
	if ( isset($HTTP_GET_VARS['s']) )
	{
		$show_forum = intval($HTTP_GET_VARS['s']);
		$is_auth = array();
		$is_auth = $tree['auth'][POST_FORUM_URL . $show_forum];

		if ( !empty($show_forum) )
		{
			$sql = "SELECT password
				FROM " . FORUMS_TABLE . "
				WHERE forum_id = $show_forum";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not obtain forum information', '', __LINE__, __FILE__, $sql);
			}
		}
		else
		{
			message_die(GENERAL_MESSAGE, 'Forum_not_exist');
		}

		if ( !($forum_row = $db->sql_fetchrow($result)) )
		{
			message_die(GENERAL_MESSAGE, 'Forum_not_exist');
		}

		$portal_config['witch_news_forum'] = (!empty($show_forum) && $is_auth['auth_read'] && !$forum_row['password']) ? $show_forum : $portal_config['witch_news_forum'];
	}

	if ( !isset($HTTP_GET_VARS['article']) )
	{
		$fetchposts = phpbb_fetch_posts($portal_config['witch_news_forum'], $portal_config['number_of_news'], $portal_config['news_length']);

		for ($i = 0; $i < count($fetchposts); $i++)
		{
			if ( $fetchposts[$i]['striped'] == 1 )
			{
				$open_bracket = '[ ';
				$close_bracket = ' ]';
				$read_full = $lang['Read_Full'];
			}
			else
			{
				$open_bracket = '';
				$close_bracket = '';
				$read_full = '';
			}

			$fp_text = preg_replace("#\[mod\](.*?)\[/mod\]#si", "", $fetchposts[$i]['post_text']);
			$fp_text = preg_replace("#\[hide(.*?)\[\/hide#si","", $fp_text);

			$template->assign_block_vars('fetchpost_row', array(
				'TITLE' => $fetchposts[$i]['topic_title'],
				'POSTER' => $fetchposts[$i]['username'],
				'TIME' => $fetchposts[$i]['topic_time'],
				'TEXT' => $fp_text,
				'REPLIES' => $fetchposts[$i]['topic_replies'],
				'U_VIEW_COMMENTS' => append_sid('viewtopic.'.$phpEx . '?t=' . $fetchposts[$i]['topic_id']),
				'U_POST_COMMENT' => append_sid('posting.'.$phpEx . '?mode=reply&amp;t=' . $fetchposts[$i]['topic_id']),
				'U_READ_FULL' => append_sid('portal.'.$phpEx.'?article=' . $i . ( ($show_forum) ? '&s=' . $show_forum : '')),
				'L_READ_FULL' => $read_full,
				'OPEN' => $open_bracket,
				'CLOSE' => $close_bracket)
			);
		}
	}
	else
	{
		$fetchposts = phpbb_fetch_posts($portal_config['witch_news_forum'], $portal_config['number_of_news'], 0);

		$i = intval($HTTP_GET_VARS['article']);

		$template->assign_block_vars('fetchpost_row', array(
			'TITLE' => $fetchposts[$i]['topic_title'],
			'POSTER' => $fetchposts[$i]['username'],
			'TIME' => $fetchposts[$i]['topic_time'],
			'TEXT' => $fetchposts[$i]['post_text'],
			'REPLIES' => $fetchposts[$i]['topic_replies'],
			'U_VIEW_COMMENTS' => append_sid('viewtopic.'.$phpEx.'?t=' . $fetchposts[$i]['topic_id']),
			'U_POST_COMMENT' => append_sid('posting.'.$phpEx.'?mode=reply&amp;t=' . $fetchposts[$i]['topic_id']))
		);
	}
}
// END: Fetch Announcements

// Fetch Poll
$fetchpoll = ($portal_config['witch_poll_forum'] != '') ? phpbb_fetch_poll($portal_config['witch_poll_forum']) : '';

if ( !empty($fetchpoll) )
{
	$sql = "SELECT vote_id
		FROM " . VOTE_USERS_TABLE . "
		WHERE vote_id = " . $fetchpoll['vote_id'] . "
			AND vote_user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain user vote data for this topic', '', __LINE__, __FILE__, $sql);
	}

	$user_voted = ($row = $db->sql_fetchrow($result)) ? TRUE : 0;

	if ( $user_voted )
	{
		$vote_options = count($fetchpoll['options']);
		$vote_results_sum = 0;

		for($i = 0; $i < $vote_options; $i++)
		{
			$vote_results_sum += $fetchpoll['options'][$i]['vote_result'];
		}

		$vote_graphic = 0;
		$vote_graphic_max = count($images['voting_graphic']);

		for($i = 0; $i < $vote_options; $i++)
		{
			$vote_percent = ($vote_results_sum > 0) ? $fetchpoll['options'][$i]['vote_result'] / $vote_results_sum : 0;
			$vote_graphic_length = round($vote_percent * 165);

			$vote_graphic_img = $images['voting_graphic'][$vote_graphic];
			$vote_graphic = ($vote_graphic < $vote_graphic_max - 1) ? $vote_graphic + 1 : 0;

			$hide_vote_bl = '';
			$hide_vote_zr = '0';
			$total_votes_1 = $lang['Total_votes'] ;
			$total_votes_2 = $vote_results_sum;

			if ( ( $poll_expired == 0 ) && ( $hide_vote == 1 ) && ( $fetchpoll['options'][0]['vote_length'] <> 0 ) )
			{
				if ( $tothide_vote == 1 )
				{
					$total_votes_1 = '' ;
					$total_votes_2 = '' ;
				}
				$poll_expires_c = $lang['Results_after'];

				$template->assign_block_vars('poll_option', array(
					'TOTAL_VOTES' => $lang['Total_vots'],
					'POLL_OPTION_CAPTION' => $fetchpoll['options'][$i]['vote_option_text'],
					'POLL_OPTION_RESULT' => $hide_vote_bl,
					'POLL_OPTION_PERCENT' => $hide_vote_bl,
					'POLL_OPTION_IMG' => $vote_graphic_img,
					'POLL_OPTION_IMG_WIDTH' => $hide_vote_zr)
				);
			}
			else
			{
				$poll_expires_c = '';
				$template->assign_block_vars('poll_option', array(
					'TOTAL_VOTES' => $lang['Total_vots'],
					'POLL_OPTION_CAPTION' => $fetchpoll['options'][$i]['vote_option_text'],
					'POLL_OPTION_RESULT' => $fetchpoll['options'][$i]['vote_result'],
					'POLL_OPTION_PERCENT' => sprintf("%.1d%%", ($vote_percent * 100)),

					'POLL_OPTION_IMG' => $vote_graphic_img,
					'POLL_OPTION_IMG_WIDTH' => $vote_graphic_length)
				);
			}
		}
		$template->assign_vars(array(
			'S_POLL_QUESTION' => $fetchpoll['vote_text'])
		);
	}
	else
	{
		$template->assign_block_vars('switch_user_logged_in.poll_vote', array());

		$max_vote = $fetchpoll['vote_max'];
		$vote_box = ($max_vote > 1) ? 'checkbox' : 'radio';

		if ( $max_vote > 1 )
		{
			$vote_br = '<br />';
			$max_vote_nb = $max_vote;
		}
		else
		{
			$vote_br = '';
			$lang['Max_voting_1_explain'] = '';
			$lang['Max_voting_2_explain'] = '';
			$lang['Max_voting_3_explain'] = '';
			$max_vote_nb = '';
		}

		$template->assign_vars(array(
			'S_POLL_QUESTION' => $fetchpoll['vote_text'],
			'S_POLL_ACTION' => append_sid('posting.'.$phpEx.'?' . POST_TOPIC_URL . '=' . $fetchpoll['topic_id']),
			'S_TOPIC_ID' => $fetchpoll['topic_id'],
			'POLL_VOTE_BOX' => $vote_box,
			'MAX_VOTING_1_EXPLAIN' => $lang['Max_voting_1_explain'],
			'MAX_VOTING_2_EXPLAIN' => $lang['Max_voting_2_explain'],
			'MAX_VOTING_3_EXPLAIN' => $lang['Max_voting_3_explain'],
			'max_vote' => $max_vote_nb,
			'L_SUBMIT_VOTE' => $lang['Submit_vote'],
			'L_LOGIN_TO_VOTE' => $lang['Login_to_vote'])
		);

		for ($i = 0; $i < count($fetchpoll['options']); $i++)
		{
			$template->assign_block_vars('poll_option_row', array(
				'OPTION_ID' => $fetchpoll['options'][$i]['vote_option_id'],
				'OPTION_TEXT' => $fetchpoll['options'][$i]['vote_option_text'],
				'VOTE_RESULT' => $fetchpoll['options'][$i]['vote_result'])
			);
		}
	}
}
else
{
	$template->assign_vars(array(
		'S_POLL_QUESTION' => $lang['No_poll'],
		'DISABLED' => 'disabled="disabled"')
	);
}

// Menus
$custom1_body = ($portal_config['custom1_body']) ? '<tr><td class="' . $row1 . '" align="' . $portal_config['custom1_body_a'] . '"><span class="genmed" style="line-height: 150%">' . $portal_config['custom1_body'] . '</span></td></tr>' : '';
$custom1_name = ($portal_config['custom1_name']) ? '<tr><td class="catHead" height="25" align="' . $portal_config['custom1_body_a'] . '"><span class="genmed"><b>' . $portal_config['custom1_name'] . '</b></span></td></tr>' : '';
$custom_module1 = ($portal_config['custom1_body_on'] && $portal_config['custom1_name'] | $portal_config['custom1_body']) ? '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline">' . $custom1_name . $custom1_body . '</table><br />' : '';
$custom2_body = ($portal_config['custom2_body']) ? '<tr><td class="' . $row1 . '" align="' . $portal_config['custom2_body_a'] . '"><span class="genmed" style="line-height: 150%">' . $portal_config['custom2_body'] . '</span></td></tr>' : '';
$custom2_name = ($portal_config['custom2_name']) ? '<tr><td class="catHead" height="25" align="' . $portal_config['custom2_body_a'] . '"><span class="genmed"><b>' . $portal_config['custom2_name'] . '</b></span></td></tr>' : '';
$custom_module2 = ($portal_config['custom2_body_on'] && $portal_config['custom2_name'] | $portal_config['custom2_body']) ? '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline">' . $custom2_name . $custom2_body . '</table><br />' : '';
$blank1_body = ($portal_config['blank1_body']) ? $portal_config['blank1_body'] : '';
$blank_module1 = ($portal_config['blank1_body_on']) ? $blank1_body : '';
$blank2_body = ($portal_config['blank2_body']) ? $portal_config['blank2_body'] : '';
$blank_module2 = ($portal_config['blank2_body_on']) ? $blank2_body : '';
$blank3_body = ($portal_config['blank3_body']) ? $portal_config['blank3_body'] . '' : '';
$blank_module3 = ($portal_config['blank3_body_on']) ? $blank3_body : '';
$blank4_body = ($portal_config['blank4_body']) ? $portal_config['blank4_body'] . '' : '';
$blank_module4 = ($portal_config['blank4_body_on']) ? $blank4_body : '';


$custom_links1 = ($portal_config['custom_desc1'] && $portal_config['custom_address1']) ? '<a href="' . $portal_config['custom_address1'] . '" class="mainmenu">' . $portal_config['custom_desc1'] . '</a><br />' : '';
$custom_links2 = ($portal_config['custom_desc2'] && $portal_config['custom_address2']) ? '<a href="' . $portal_config['custom_address2'] . '" class="mainmenu">' . $portal_config['custom_desc2'] . '</a><br />' : '';
$custom_links3 = ($portal_config['custom_desc3'] && $portal_config['custom_address3']) ? '<a href="' . $portal_config['custom_address3'] . '" class="mainmenu">' . $portal_config['custom_desc3'] . '</a><br />' : '';
$custom_links4 = ($portal_config['custom_desc4'] && $portal_config['custom_address4']) ? '<a href="' . $portal_config['custom_address4'] . '" class="mainmenu">' . $portal_config['custom_desc4'] . '</a><br />' : '';
$custom_links5 = ($portal_config['custom_desc5'] && $portal_config['custom_address5']) ? '<a href="' . $portal_config['custom_address5'] . '" class="mainmenu">' . $portal_config['custom_desc5'] . '</a><br />' : '';
$custom_links6 = ($portal_config['custom_desc6'] && $portal_config['custom_address6']) ? '<a href="' . $portal_config['custom_address6'] . '" class="mainmenu">' . $portal_config['custom_desc6'] . '</a><br />' : '';
$custom_links7 = ($portal_config['custom_desc7'] && $portal_config['custom_address7']) ? '<a href="' . $portal_config['custom_address7'] . '" class="mainmenu">' . $portal_config['custom_desc7'] . '</a><br />' : '';
$custom_links8 = ($portal_config['custom_desc8'] && $portal_config['custom_address8']) ? '<a href="' . $portal_config['custom_address8'] . '" class="mainmenu">' . $portal_config['custom_desc8'] . '</a><br />' : '';
$links1 = ($portal_config['links1']) ? '<a href="' . append_sid("index.$phpEx") . '" class="mainmenu">' . $lang['Forum'] . '</a><br />' : '';
$links2 = ($portal_config['links2']) ? '<a href="' . append_sid("portal.$phpEx") . '" class="mainmenu">' . $lang['Forum_index'] . '</a><br />' : '';
$links3 = ($portal_config['links3']) ? '<a href="' . append_sid("memberlist.$phpEx") . '" class="mainmenu">' . $lang['Memberlist'] . '</a><br />' : '';
$links4 = ($portal_config['links4']) ? '<a href="' . append_sid("search.$phpEx") . '" class="mainmenu">' . $lang['Search'] . '</a><br />' : '';
$links5 = ($portal_config['links5']) ? '<a href="' . append_sid("groupcp.$phpEx") . '" class="mainmenu">' . $lang['Usergroups'] . '</a><br />' : '';
$links6 = ($portal_config['links6'] && $userdata['session_logged_in']) ? '<a href="' . append_sid("profile.$phpEx?mode=editprofile") . '" class="mainmenu">' . $lang['Profile'] . '</a><br />' : '';
$links7 = ($portal_config['links7']) ? '<a href="' . $u_login_logout . '" class="mainmenu">' . $l_login_logout . '</a><br />' : '';
$links8 = ($portal_config['links8'] && !$userdata['session_logged_in']) ? '<a href="' . append_sid('profile.'.$phpEx.'?mode=register') . '" class="mainmenu">' . $lang['Register'] . '</a><br />' : '';

$portal_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['portal_menu_a'] . '"><span class="genmed"><b>' . $lang['Board_navigation'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['portal_menu_a'] . '" style="line-height: 120%"><span class="genmed">' . $custom_links1 . $custom_links2 . $custom_links3 . $custom_links4 . $links1 . $links2 . $links3 . $links4 . $links5 . $links6 . $links7 . $links8 . $custom_links5 . $custom_links6 . $custom_links7 . $custom_links8 . '</span></td></tr></table><br />';
$links_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['links_a'] . '"><span class="genmed"><b>' . $lang['links'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['links_a'] . '"><span class="gensmall">' . $portal_config['links_body'] . '</span></td></tr></table><br />';
$search_menu = '<script language="JavaScript" type="text/javascript">
<!--
function checkSearch(){if (document.search_block.search_engine.value == "google"){window.open("http://www.google.com/search?q=" + document.search_block.search_keywords.value, "_google", "");return false;}else{return true;}}
//-->
</script><form name="search_block" method="post" action="'.append_sid('search.'.$phpEx).'" onSubmit="return checkSearch()"><table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" align="' . $portal_config['search_a'] . '" height="25"><span class="genmed"><b>' . $lang['Search'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['search_a'] . '"><span class="gensmall" style="line-height=150%">' . $lang['Search'] . ':<br /><input class="post" type="text" name="search_keywords" size="15" /></span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['search_a'] . '"><span class="gensmall" style="line-height=150%">' . $lang['Search_at'] . ':<br /><select class="post" name="search_engine"><option value="site">Forum</option><option value="google">Google</option></select><br /><a href="'.append_sid('search.'.$phpEx).'" class="mainmenu">' . $lang['Advanced_search'] . '</a></span></td></tr><tr><td class="' . $row1 . '" align="center"><input type="hidden" name="search_fields" value="all" /><input type="hidden" name="show_results" value="topics" /><input class="mainoption" type="submit" value="' . $lang['Search'] . '" /></td></tr></table></form><br />';

if ( in_array('login_menu', $modules) && !$userdata['session_logged_in'] )
{
	$login_menu = (!$userdata['session_logged_in']) ? '<form method="post" action="' . append_sid("login.$phpEx") . '"><table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['login_a'] . '"><span class="genmed"><b>' . $lang['Login'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['login_a'] . '"><span class="gensmall"><input type="hidden" name="redirect" value="' . append_sid("portal.$phpEx") . '" />' . $lang['Username'] . ':<br /><input class="post" type="text" name="username" size="15" /></span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['login_a'] . '"><span class="gensmall">' . $lang['Password'] . ':<br /><input class="post" type="password" name="password" size="15" /></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['login_a'] . '"><span class="gensmall"><input class="text" type="checkbox" name="autologin" />' . $lang['Remember_me'] . '&nbsp;<input type="submit" class="mainoption" name="login" value="' . $lang['Login'] . '" /></span></td></tr><tr><td class="' . $row2 . '" align="' . $portal_config['login_a'] . '"><span class="gensmall"><a href="'.append_sid("profile.$phpEx?mode=sendpassword") . '">' . $lang['Forgotten_password'] . '</a></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['login_a'] . '"><span class="gensmall">' . sprintf($lang['Register_new_account'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>') . '</span></td></tr></table></form><br />' : '';
}

if ( in_array('chat_menu', $modules) )
{
	include($phpbb_root_path . 'chatbox_front.'.$phpEx);
	$chat_menu = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['chat_a'] . '"><span class="genmed"><b>' . $lang['Who_is_Chatting'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="' . $portal_config['chat_a'] . '"><span class="gensmall">' . sprintf($lang['How_Many_Chatters'], $howmanychat) . '<br />' . sprintf($lang['Who_Are_Chatting' ], $chatters) . '<br />[ ' . ( ($userdata['session_logged_in']) ? '<a href="javascript:void(0);" onClick="window.open(\'' . append_sid("chatbox_mod/chatbox.$phpEx") . '\',\'' . $userdata['user_id'] . '_ChatBox' . '\',\'scrollbars=no,width=540,height=450\')" class="mainmenu">' . $lang['Click_to_join_chat'] . '</a>' : $lang['Login_to_join_chat'] ) . ' ]</span></td></tr></table><br />';
}

$row_class = $row1;

$custom_field_box = '';
$custom_fields_exists = (custom_fields('quick_regist', '')) ? true : false;

if ( $custom_fields_exists )
{
	$custom_fields = custom_fields('', 'quick_regist');
	for($i = 0; $i < count($custom_fields[0]); $i++)
	{
		$split_field = 'user_field_' . $custom_fields[0][$i];
		$desc = (isset($lang[$custom_fields[1][$i]])) ? $lang[$custom_fields[1][$i]] : $custom_fields[1][$i];
		$desc = str_replace(array('-#', '<br>'), array('',''), $desc);
		$row_class = ($row_class == $row1) ? $row2 : $row1;

		if ( $custom_fields[3][$i] )
		{
			$options = explode(',', $custom_fields[3][$i]);
			if ( count($options) > 0 )
			{
				if ( eregi('.gif', $options[count($options) -1 ]) || eregi('.jpg', $options[count($options) -1 ]))
				{
					$jumpbox = '<script language="javascript" type="text/javascript">
					<!--
						function update_rank(newimage){document.' . $split_field . '.src = \'' . $images['images'] . '/custom_fields/\'+newimage;}
					//-->
					</script>';
					$jumpbox .= '<select name="' . $split_field . '" onchange="update_rank(this.options[selectedIndex].value);"><option value="no_image.gif">' . $lang['None'] . '</option>';
					for ($j = 0; $j+1 <= count($options); $j++) 
					{
						$field_name = str_replace(array('_', '.gif', '.jpg'), array(' ', '', ''), $options[$j]);
						$cf_selected = ($options[$j] == $$split_field) ? 'selected="selected"' : '';
						$jumpbox .= '<option value="' . $options[$j] . '" ' . $cf_selected . '>' . $field_name . '</option>';
					}
					$jumpbox .= '</select>&nbsp;<img name="' . $split_field . '" src="' . $images['images'] . '/custom_fields/no_image.gif" border="0" alt="" align="top" />';
				}
				else
				{
					$jumpbox = '<select name="' . $split_field . '"><option value="" ' . $cf_selected . '>' . $lang['None'] . '</option>';
					for ($j = 0; $j+1 <= count($options); $j++) 
					{
						$cf_selected = ($options[$j] == $$split_field) ? 'selected="selected"' : '';
						$jumpbox .= '<option value="' . $options[$j] . '" ' . $cf_selected . '>' . $options[$j] . '</option>';
					}
					$jumpbox .= '</select>';
				}
				$custom_field_box .= '<tr><td class="' . $row_class . '" align="center"><span class="gensmall">' . $desc . ':<br />' . $jumpbox . '</span></td></tr>';
			}
		}
		else
		{
			$field_size = ($custom_fields[2][$i] < 20) ? ($custom_fields[2][$i] + 1) : '20';
			$custom_field_box .= '<tr><td class="' . $row_class . '" align="center"><span class="gensmall">' . $desc . ':<br /><input type="text" name="' . $split_field . '" class="post", maxlength="' . $custom_fields[2][$i] . '" size="' . $field_size . '" onFocus="Active(this)" onBlur="NotActive(this)"></span></td></tr>';
		}
	}
}

$row_class = ($row_class == $row1) ? $row2 : $row1;

if ( in_array('register_menu', $modules) && !$userdata['session_logged_in'])
{
	if ( $board_config['validate'] && @extension_loaded('zlib') && !$userdata['session_logged_in'] )
	{
		$key = '';
		$max_length_reg_key = 4;
		$chars = array('1','2','3','4','5','6','7','8','9');

		$count = count($chars) - 1;
		srand((double)microtime()*1000000);

		for($i = 0; $i < $max_length_reg_key; $i++)
		{
			$key .= $chars[rand(0, $count)];
		}

		$sql = "DELETE FROM " . ANTI_ROBOT_TABLE . "
			WHERE timestamp < '" . (time() - 3600) . "'
			OR session_id = '" . $userdata['session_id'] . "'";
		if ( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain registration information', '', __LINE__, __FILE__, $sql);
		}

		$sql = "INSERT INTO ". ANTI_ROBOT_TABLE . "
			VALUES ('" . $userdata['session_id'] . "', '" . $key . "', '" . time() . "')";
		if ( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not check registration information', '', __LINE__, __FILE__, $sql);
		}
		
		$row_class = ($row_class == $row1) ? $row2 : $row1;
		$validate1 = '<tr><td class="' . $row_class . '" align="center"><span class="gensmall"><img src="' . append_sid("includes/confirm_register.$phpEx") . '" width="120" height="27" border="0">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
		$validate2 = '<input type="text" class="post" name="reg_key" maxlength="4" onFocus="this.value=\'\'" size="5" value="' . $lang['Code'] . '" /></span></td></tr>';
	}
	else
	{
		$validate1 = '';
		$validate2 = '';
	}
	$gender_box = ($board_config['gender'] && $board_config['require_gender']) ? '<tr><td class="' . $row_class . '" align="center"><span class="gensmall">' . $lang['Gender'] . ':<br />' . $lang['Female'] . '<input type="radio" name="gender" value="1" /> ' . $lang['Male'] . '<input type="radio" name="gender" value="1" /></b></span></td></tr>' : '';
	$register_menu = '<form method="post" action="profile.' . $phpEx . '"><table align="center" width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['register_a'] . '"><span class="genmed"><b>' . $lang['Quick_register'] . '</b></span></td></tr><tr><td class="' . $row1 . '" align="center"><span class="gensmall">' . $lang['Username'] . ':<br /><input type="text" class="post" style="width:150px" name="username" size="25" maxlength="20" value="" /></span></td></tr><tr><td class="' . $row2 . '" align="center"><span class="gensmall">' . $lang['Password'] . ':&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $lang['Confirm_password'] . ':<br /><input type="password" class="post" style="width: 60px" name="new_password" maxlength="100" value="" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="password" class="post" style="width: 60px" name="password_confirm" maxlength="100" value="" /></span></td></tr><tr><td class="' . $row1 . '" align="center"><span class="gensmall">' . $lang['Email'] . '<br /><input type="text" class="post" style="width:150px" name="email" size="25" maxlength="255" value="" /></span></td></tr>' . $validate1 . $validate2 . $custom_field_box . $gender_box . '<tr><td class="' . $row_class . '" align="center"><span class="gensmall"><input type="submit" name="submit" value="' . $lang['Register'] . '" class="liteoption" /></span></td></tr></table><input type="hidden" name="viewemail" value="1" checked="checked" /><input type="hidden" name="hideonline" value="0" checked="checked" /><input type="hidden" name="notifyreply" value="0" checked="checked" /><input type="hidden" name="notifypm" value="1" checked="checked" /><input type="hidden" name="popup_pm" value="1" checked="checked" /><input type="hidden" name="attachsig" value="1" checked="checked" /><input type="hidden" name="allowbbcode" value="1" checked="checked" /><input type="hidden" name="allowhtml" value="1" checked="checked" /><input type="hidden" name="allowsmilies" value="1" checked="checked" /><input type="hidden" name="dateformat" value="' . $board_config['default_dateformat'] . '" maxlength="14" class="post" /><input type="hidden" name="mode" value="register" /><input type="hidden" name="agreed" value="true" /><input type="hidden" name="sid" value=' . $userdata['session_id'] . '><input type="hidden" name="coppa" value="0" /><input type="hidden" name="user_topics_per_page" value="' . $board_config['topics_per_page'] . '" checked="checked" /><input type="hidden" name="user_posts_per_page" value="' . $board_config['posts_per_page'] . '" checked="checked" /><input type="hidden" name="user_hot_threshold" value="' . $board_config['hot_threshold'] . '" checked="checked" /></form><br />';
}

$clock_menu = '<table align="center" width="100%" cellpadding="2" cellspacing="1" border="0" ><tr><td align="center"><span class="gensmall"><object type="application/x-shockwave-flash" data="images/clock.swf" width="180" height="180"><param name="movie" value="images/clock.swf" /></object></span></td></tr></table><br />';

$news_forum = '';
if ( $portal_config['news_forum'] )
{
	$news_forum = $portal_config['body_news_forum'];
}

if ( $board_config['album_gallery'] && $portal_config['recent_pics'] > 0 && in_array('album_menu', $modules))
{
	include($phpbb_root_path . 'album_portal.'.$phpEx);
}

if ( $board_config['download'] && in_array('download', $modules))
{
	include($phpbb_root_path . 'pafiledb/includes/portal_stats.'.$phpEx);
	$download = '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="' . $portal_config['download_pos'] . '"><span class="genmed"><b>' . $lang['Downloads2'] . '</b></span></td></tr>' . $lang['Stats_portal'] . '<tr><td class="' . $row1 . '" align="' . $portal_config['download_pos'] . '"><span class="gensmall"><a href="dload.'.$phpEx.'">' . $lang['See_all'] . '</a></span></td></tr></table><br />';
}
// End menus

$where = $HTTP_GET_VARS['show'];
$allowed_values = array(
	'1' => 'portal_page1.html',
	'2' => 'portal_page2.html',
	'3' => 'portal_page3.html',
	'4' => 'portal_page4.html',
	'5' => 'portal_page5.html');

if ( $allowed_values[$where] != '' && file_exists('./' . $allowed_values[$where]) )
{
	if ( !function_exists('file_get_contents') )
	{
		function file_get_contents($filename)
		{
			$file = @fopen($filename, 'rb');
			if ( $file )
			{
				if ( $fsize = @filesize($filename) )
				{
					$data = @fread($file, $fsize);
				}
				else
				{
					$data = '';
					while (!@feof($file))
					{
						$data .= @fread($file, 1024);
					}
				}
				@fclose($file);
			}
			return $data;
		}
	}

	$template->assign_vars(array(
		'OWN_BODY' => file_get_contents('./' . $allowed_values[$where]),
		'BEGIN_NEWS' => '<!--',
		'END_NEWS' => '-->')
	);
}
else
{
	$template->assign_vars(array(
		'OWN_BODY' => $portal_config['own_body'],
		'BEGIN_NEWS' => ($portal_config['own_body']) ? '<!--' : '',
		'END_NEWS' => ($portal_config['own_body']) ? '-->' : '')
	);
}

$template->assign_vars(array(
	'NEWS_HEADER' => $news_forum,
	'L_FORUM' => $lang['Forum'],
	'L_BOARD_NAVIGATION' => $lang['Board_navigation'],
	'L_ANNOUNCEMENT' => $lang['Post_Announcement'],
	'L_POSTED' => $lang['Posted'],
	'L_COMMENTS' => $lang['Comments'],
	'L_VIEW_COMMENTS' => $lang['View_comments'],
	'L_POST_COMMENT' => $lang['Post_your_comment'],
	'L_POLL' => $lang['Poll'],
	'L_VOTE_BUTTON' => $lang['Vote'],
	'L_RECENT_TOPICS' => $lang['Recent_topics'],
	'POLLR_OFF1' => ($portal_config['poll'] == '1' || $portal_config['poll'] == '0') ? '<!--' : '',
	'POLLR_OFF2' => ($portal_config['poll'] == '1' || $portal_config['poll'] == '0') ? '-->' : '',
	'POLLL_OFF1' => ($portal_config['poll'] == '2' || $portal_config['poll'] == '0') ? '<!--' : '',
	'POLLL_OFF2' => ($portal_config['poll'] == '2' || $portal_config['poll'] == '0') ? '-->' : '',
	'MODULE1' => $$portal_config['module1'],
	'MODULE2' => $$portal_config['module2'],
	'MODULE3' => $$portal_config['module3'],
	'MODULE4' => $$portal_config['module4'],
	'MODULE5' => $$portal_config['module5'],
	'MODULE6' => $$portal_config['module6'],
	'MODULE7' => $$portal_config['module7'],
	'MODULE8' => $$portal_config['module8'],
	'MODULE9' => $$portal_config['module9'],
	'MODULE10' => $$portal_config['module10'],
	'MODULE11' => $$portal_config['module11'],
	'MODULE12' => $$portal_config['module12'],
	'MODULE13' => $$portal_config['module13'],
	'MODULE14' => $$portal_config['module14'],
	'MODULE15' => $$portal_config['module15'],
	'MODULE16' => $$portal_config['module16'],
	'MODULE17' => $$portal_config['module17'],
	'MODULE18' => $$portal_config['module18'],
	'MODULE19' => $$portal_config['module19'],
	'MODULE20' => $$portal_config['module20'],
	'MODULE21' => $$portal_config['module21'],
	'MODULE22' => $$portal_config['module22'],
	'MODULE23' => $$portal_config['module23'],
	'MODULE24' => $$portal_config['module24'])
);

// Generate the page
if ( !$userdata['session_logged_in'] )
{
	$template->assign_block_vars('logged_out', array());
}
else
{
	$template->assign_block_vars('logged_in', array());
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>