<?php
/***************************************************************************
 *						posting.php
 *						-------------------
 *	begin				: Saturday, Feb 13, 2001
 *	copyright			: (C) 2001 The phpBB Group
 *	email				: support@phpbb.com
 *	modification		: (C) 2003 Przemo http://www.przemo.org
 *	date modification	: ver. 1.9 2004/04/15 16:11
 *
 *	$Id: posting.php,v 1.8.9 2004/05/12 16:11
 ***************************************************************************/

/***************************************************************************
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 ***************************************************************************/

define('IN_PHPBB', true);
define('PORTAL', true);
define('ATTACH', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_post.'.$phpEx);

if ( $board_config['read_tracking'] )
{
	include($phpbb_root_path . 'includes/read_history.'.$phpEx);
}

include($phpbb_root_path . 'includes/functions_log.'.$phpEx);

$params = array('submit' => 'post', 'preview' => 'preview', 'delete' => 'delete', 'poll_delete' => 'poll_delete', 'poll_add' => 'add_poll_option', 'poll_edit' => 'edit_poll_option', 'mode' => 'mode');
while( list($var, $param) = @each($params) )
{
	if ( !empty($HTTP_POST_VARS[$param]) || !empty($HTTP_GET_VARS[$param]) )
	{
		$$var = ( !empty($HTTP_POST_VARS[$param]) ) ? $HTTP_POST_VARS[$param] : $HTTP_GET_VARS[$param];
	}
	else
	{
		$$var = '';
	}
}

$confirm = isset($HTTP_POST_VARS['confirm']) ? true : false;

$params = array('forum_id' => POST_FORUM_URL, 'topic_id' => POST_TOPIC_URL, 'post_id' => POST_POST_URL);
while( list($var, $param) = @each($params) )
{
	if ( !empty($HTTP_POST_VARS[$param]) || !empty($HTTP_GET_VARS[$param]) )
	{
		$$var = ( !empty($HTTP_POST_VARS[$param]) ) ? intval($HTTP_POST_VARS[$param]) : intval($HTTP_GET_VARS[$param]);
	}
	else
	{
		$$var = '';
	}
}

$refresh = $preview || $poll_add || $poll_edit || $poll_delete;

if ( $HTTP_POST_VARS['msg_icon'] )
{
	$msg_icon_checked = intval($HTTP_POST_VARS['msg_icon']);
	$msg_icon = intval($HTTP_POST_VARS['msg_icon']);
}
else
{
	$msg_icon_checked = 0;
}

if ( $HTTP_POST_VARS['more_icon'] )
{
	$msg_icon = intval($HTTP_POST_VARS['more_icon']);
}

$topic_color = ($HTTP_POST_VARS['topic_color']) ? htmlspecialchars($HTTP_POST_VARS['topic_color']) : '';

if ( $HTTP_POST_VARS['msg_expire'] )
{
	$msg_expire_checked = intval($HTTP_POST_VARS['msg_expire']);
	$msg_expire = intval($HTTP_POST_VARS['msg_expire']);
}
else
{
	$msg_expire_checked = 0;
}

// Set topic type
$topic_type = (!empty($HTTP_POST_VARS['topictype'])) ? intval($HTTP_POST_VARS['topictype']) : POST_NORMAL;

// If the mode is set to topic review then output
// that review ...
if ( $mode == 'topicreview' )
{
	require($phpbb_root_path . 'includes/topic_review.'.$phpEx);

	topic_review($topic_id, false);
	if ( !empty($db) )
	{
		$db->sql_close();
	}
	exit;
}
else if ( $mode == 'smilies' )
{
	generate_smilies('window', PAGE_POSTING);
	if ( !empty($db) )
	{
		$db->sql_close();
	}
	exit;
}
else if ( $mode == 'icons' )
{
	more_icons(PAGE_POSTING);
	if ( !empty($db) )
	{
		$db->sql_close();
	}
	exit;
}

// Start session management
$userdata = session_pagestart($user_ip, PAGE_POSTING);
init_userprefs($userdata);
// End session management

$is_mod = (is_mod_buffered($userdata['user_id'])) ? true : false;
$is_jr_admin = (is_jr_admin_buffered($userdata['user_id'])) ? true : false;

if ( $board_config['login_require'] && !$userdata['session_logged_in'] )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

// Was cancel pressed? If so then redirect to the appropriate
// page, no point in continuing with any further checks
if ( isset($HTTP_POST_VARS['cancel']) )
{
	if ( $post_id )
	{
		$redirect = "viewtopic.$phpEx?" . POST_POST_URL . "=$post_id";
		$post_append = "#$post_id";
	}
	else if ( $topic_id )
	{
		$redirect = "viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id";
		$post_append = '';
	}
	else if ( $forum_id )
	{
		$redirect = "viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id";
		$post_append = '';
	}
	else
	{
		$redirect = "index.$phpEx";
		$post_append = '';
	}

	redirect(append_sid($redirect, true) . $post_append);
}

// What auth type do we need to check?
$is_auth = array();
switch( $mode )
{
	case 'newtopic':
		if ( $topic_type == POST_GLOBAL_ANNOUNCE )
		{
			$is_auth_type = 'auth_globalannounce';
		}
		else
		if ( $topic_type == POST_ANNOUNCE )
		{
			$is_auth_type = 'auth_announce';
		}
		else if ( $topic_type == POST_STICKY )
		{
			$is_auth_type = 'auth_sticky';
		}
		else
		{
			$is_auth_type = 'auth_post';
		}
		break;
	case 'reply':
	case 'quote':
		$is_auth_type = 'auth_reply';
		break;
	case 'editpost':
		$is_auth_type = 'auth_edit';
		break;
	case 'delete':
	case 'poll_delete':
		$is_auth_type = 'auth_delete';
		break;
	case 'vote':
		$is_auth_type = 'auth_vote';
		break;
	case 'topicreview':
		$is_auth_type = 'auth_read';
		break;
	default:
		message_die(GENERAL_MESSAGE, $lang['No_post_mode']);
		break;
}

// Here we do various lookups to find topic_id, forum_id, post_id etc.
// Doing it here prevents spoofing (eg. faking forum_id, topic_id or post_id
$error_msg = '';
$post_data = array();
switch ( $mode )
{
	case 'newtopic':
		if ( empty($forum_id) )
		{
			message_die(GENERAL_MESSAGE, $lang['Forum_not_exist']);
		}

		$sql = "SELECT * 
			FROM " . FORUMS_TABLE . " 
			WHERE forum_id = $forum_id";
		break;

	case 'reply':
	case 'vote':
		if ( empty( $topic_id) )
		{
			message_die(GENERAL_MESSAGE, $lang['No_topic_id']);
		}

		$sql = "SELECT f.*, t.topic_status, t.topic_title, t.topic_title_e
			FROM " . FORUMS_TABLE . " f, " . TOPICS_TABLE . " t
			WHERE t.topic_id = $topic_id
				AND f.forum_id = t.forum_id";
		break;

	case 'quote':
	case 'editpost':
	case 'delete':
	case 'poll_delete':
		if ( empty($post_id) )
		{
			message_die(GENERAL_MESSAGE, $lang['No_post_id']);
		}
		if ( $userdata['user_level'] != ADMIN && $board_config['not_edit_admin'] && ($mode == 'editpost' || $mode == 'delete' || $mode == 'poll_delete') )
		{
			$sql = "SELECT u.user_level
					FROM " . POSTS_TABLE . " p, " . USERS_TABLE . " u
					WHERE p.post_id = $post_id
						AND p.poster_id = u.user_id
						AND u.user_level = " . ADMIN;
			if ( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not retrieve post information', '', __LINE__, __FILE__, $sql);
			}
			if ( $row = $db->sql_fetchrow($result) )
			{
				message_die(GENERAL_MESSAGE, $lang['Not_auth_edit_delete_admin']);
			}
		}

		$select_sql = ( !$submit ) ? ", t.topic_title, t.topic_title_e, t.topic_color, p.enable_bbcode, p.enable_html, p.enable_smilies, p.enable_sig, p.post_username, p.post_time, pt.post_subject, pt.post_text, pt.bbcode_uid, u.username, u.user_id, u.user_sig, u.user_sig_image, p.user_agent, p.post_icon, p.post_expire" : '';
		$from_sql = ( !$submit ) ? ", " . POSTS_TEXT_TABLE . " pt, " . USERS_TABLE . " u" : '';
		$where_sql = ( !$submit ) ? "AND pt.post_id = p.post_id AND u.user_id = p.poster_id" : '';
		if ( !$board_config['report_disable'] )
		{
			$select_sql .= ( $mode == 'delete' ) ? ', p.reporter_id' : '';
		}

		$sql = "SELECT f.*, t.topic_id, t.topic_status, t.topic_type, t.topic_first_post_id, t.topic_last_post_id, t.topic_vote, p.post_id, p.poster_id" . $select_sql . " 
			FROM " . POSTS_TABLE . " p, " . TOPICS_TABLE . " t, " . FORUMS_TABLE . " f" . $from_sql . " 
			WHERE p.post_id = $post_id 
				AND t.topic_id = p.topic_id 
				AND f.forum_id = p.forum_id
				$where_sql";
		break;

	default:
		message_die(GENERAL_MESSAGE, $lang['No_valid_mode']);
}

if ( $result = $db->sql_query($sql) )
{
	$post_info = $db->sql_fetchrow($result);

	$forum_id = $post_info['forum_id'];
	$forum_name = get_object_lang(POST_FORUM_URL . $forum_id, 'name');

	$is_auth = auth(AUTH_ALL, $forum_id, $userdata, $post_info);

	// Topic Lock/Unlock
	$lock = (isset($HTTP_POST_VARS['lock'])) ? TRUE : FALSE;
	$unlock = (isset($HTTP_POST_VARS['unlock'])) ? TRUE : FALSE;
	
	if ( ($submit || $confirm) && ($lock || $unlock) && ($is_auth['auth_mod']) && ($mode != 'newtopic') && (!$refresh) )
	{
		$t_id = ( !isset($post_info['topic_id']) ) ? $topic_id : $post_info['topic_id'];

		if ( $unlock ) 
		{
			$sql = "UPDATE " . TOPICS_TABLE . " 
			SET topic_status = " . TOPIC_UNLOCKED . " 
			WHERE topic_id = $t_id
			AND topic_moved_id = 0";

			log_action('lock', $t_id, $userdata['user_id'], $userdata['username']);
		}
		else if ( $lock )
		{
			$sql = "UPDATE " . TOPICS_TABLE . " 
			SET topic_status = " . TOPIC_LOCKED . " 
			WHERE topic_id = $t_id
			AND topic_moved_id = 0";

			log_action('unlock', $t_id, $userdata['user_id'], $userdata['username']);
		}

		if ( $lock || $unlock )
		{
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not update topics table', '', __LINE__, __FILE__, $sql);
			}
		}
	}

	if ( $post_info['forum_status'] == FORUM_LOCKED && !$is_auth['auth_mod'])
	{
		message_die(GENERAL_MESSAGE, $lang['Forum_locked']);
	}
	else if ( $mode != 'newtopic' && $post_info['topic_status'] == TOPIC_LOCKED && !$is_auth['auth_mod'])
	{
		message_die(GENERAL_MESSAGE, $lang['Topic_locked']);
	}
	if ( $mode == 'editpost' && !$is_auth['auth_mod'] && $board_config['edit_time'] != '0' && !$submit)
	{
		$current_time = time();
		$difference_sec = $current_time - $post_info['post_time'] ;
		$difference_min = ($current_time - $post_info['post_time']) / 60;
		if ( $difference_min > $board_config['edit_time'] )
		{
			$message = sprintf($lang['edit_time_past'],$board_config['edit_time']) . '<br /><br />' . sprintf($lang['Click_view_message'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=" . $post_id) . '#' . $post_id . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
	}

	if ( $mode == 'editpost' || $mode == 'delete' || $mode == 'poll_delete' )
	{
		$topic_id = $post_info['topic_id'];

		$post_data['poster_post'] = ($post_info['poster_id'] == $userdata['user_id']) ? true : false;
		$post_data['first_post'] = ($post_info['topic_first_post_id'] == $post_id) ? true : false;
		$post_data['last_post'] = ($post_info['topic_last_post_id'] == $post_id) ? true : false;
		$post_data['last_topic'] = ($post_info['forum_last_post_id'] == $post_id) ? true : false;
		$post_data['has_poll'] = ($post_info['topic_vote']) ? true : false;
		$post_data['topic_type'] = $post_info['topic_type'];
		$post_data['poster_id'] = $post_info['poster_id'];

		if ( $post_data['first_post'] && $post_data['has_poll'] )
		{
			$sql = "SELECT * 
				FROM " . VOTE_DESC_TABLE . " vd, " . VOTE_RESULTS_TABLE . " vr 
				WHERE vd.topic_id = $topic_id 
					AND vr.vote_id = vd.vote_id 
				ORDER BY vr.vote_option_id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not obtain vote data for this topic', '', __LINE__, __FILE__, $sql);
			}

			$poll_options = array();
			$poll_results_sum = 0;
			if ( $row = $db->sql_fetchrow($result) )
			{
				$poll_title = $row['vote_text'];
				$poll_id = $row['vote_id'];
				$poll_length = $row['vote_length'] / 86400;
				$poll_length_h = ( $row['vote_length'] - ( $poll_length * 86400) ) / 3600;
				$max_vote = $row['vote_max'];
				$hide_vote = $row['vote_hide'];
				$tothide_vote = $row['vote_tothide'];

				do
				{
					$poll_options[$row['vote_option_id']] = $row['vote_option_text'];
					$poll_results_sum += $row['vote_result'];
				}
				while ( $row = $db->sql_fetchrow($result) );
			}

			$post_data['edit_poll'] = ( (!$poll_results_sum || $is_auth['auth_mod']) && $post_data['first_post']) ? true : 0;
		}
		else
		{
			$post_data['edit_poll'] = ($post_data['first_post'] && $is_auth['auth_pollcreate']) ? true : false;
		}
		
		// Can this user edit/delete the post/poll?
		if ( $post_info['poster_id'] != $userdata['user_id'] && !$is_auth['auth_mod'] )
		{
			$message = ( $delete || $mode == 'delete' ) ? $lang['Delete_own_posts'] : $lang['Edit_own_posts'];
			$message .= '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">', '</a>');

			message_die(GENERAL_MESSAGE, $message);
		}
		else if ( !$post_data['last_post'] && !$is_auth['auth_mod'] && ( $mode == 'delete' || $delete ) )
		{
			message_die(GENERAL_MESSAGE, $lang['Cannot_delete_replied']);
		}
		else if ( !$post_data['edit_poll'] && !$is_auth['auth_mod'] && ( $mode == 'poll_delete' || $poll_delete ) )
		{
			message_die(GENERAL_MESSAGE, $lang['Cannot_delete_poll']);
		}
	}
	else
	{
		if ( $mode == 'quote' )
		{
			$topic_id = $post_info['topic_id'];
		}

		$post_data['first_post'] = ($mode == 'newtopic') ? true : 0;
		$post_data['last_post'] = false;
		$post_data['has_poll'] = false;
		$post_data['edit_poll'] = false;
	}
}
else
{
	message_die(GENERAL_MESSAGE, $lang['No_such_post']);
}

// The user is not authed, if they're not logged in then redirect
// them, else show them an error message
if ( !$is_auth[$is_auth_type] )
{
	if ( $userdata['session_logged_in'] )
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['Sorry_' . $is_auth_type], $is_auth[$is_auth_type . "_type"]));
	}

	switch( $mode )
	{
		case 'newtopic':
			$redirect = "mode=newtopic&amp;" . POST_FORUM_URL . "=" . $forum_id;
			break;
		case 'reply':
		case 'topicreview':
			$redirect = "mode=reply&amp;" . POST_TOPIC_URL . "=" . $topic_id;
			break;
		case 'quote':
		case 'editpost':
			$redirect = "mode=quote&amp;" . POST_POST_URL ."=" . $post_id;
			break;
	}

	redirect(append_sid("login.$phpEx?redirect=posting.$phpEx&amp;" . $redirect, true));
}

if ( !$forum_id )
{
	$where_sql = ( $post_id ) ? "p.post_id = $post_id AND p.topic_id = t.topic_id" : "t.topic_id = $topic_id";
	$sql = "SELECT t.forum_id FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p
			WHERE $where_sql";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_MESSAGE, 'Could not retrieve forum id', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	$forum_id = $row['forum_id'];
}

$is_mod_forum = (is_mod($userdata['user_id'], $forum_id)) ? true : false;

if ( !$is_mod_forum && !$is_jr_admin && $userdata['user_level'] != ADMIN )
{
	$sql = "SELECT * FROM " . FORUMS_TABLE . "
		WHERE forum_id = $forum_id";
	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_MESSAGE, 'Could not retrieve forum information', '', __LINE__, __FILE__, $sql);
	}

	$forum_row = $db->sql_fetchrow($result);

	$redirect = str_replace("&amp;", "&", preg_replace('#.*?([a-z]+?\.' . $phpEx . '.*?)$#i', '\1', htmlspecialchars($_SERVER['REQUEST_URI'])));
	$cookie_forum_pass = $board_config['cookie_name'] . '_fpass_' . $forum_id;
	if ( $HTTP_POST_VARS['cancel'] )
	{
		redirect(append_sid("index.$phpEx"));
	}
	else if ( $HTTP_POST_VARS['submit'] && $HTTP_POST_VARS['password'] )
	{
		password_check($forum_id, $HTTP_POST_VARS['password'], $redirect);
	}

	if ( ($forum_row['password'] != '') && ($HTTP_COOKIE_VARS[$cookie_forum_pass] != md5($forum_row['password'])) )
	{
		password_box($forum_id, $redirect);
	}
}

// Set toggles for various options
if ( $board_config['allow_html'] || ( ($board_config['mod_html'] && $is_mod_forum) || ($board_config['admin_html'] && $userdata['user_level'] == ADMIN) || ($board_config['jr_admin_html'] && $is_jr_admin) ) )
{
	$html_on = ($submit || $refresh) ? (( !empty($HTTP_POST_VARS['disable_html'])) ? 0 : TRUE ) : (( $userdata['user_id'] == ANONYMOUS) ? $board_config['allow_html'] : $userdata['user_allowhtml']);
	$show_html = true;
}
else
{
	$html_on = 0;
	$show_html = false;
}

if ( $board_config['allow_bbcode_quest'] )
{
	if ( !$board_config['allow_bbcode'] || !$userdata['session_logged_in'] )
	{
		$bbcode_on = 0;
	}
	else
	{
		$bbcode_on = ($submit || $refresh) ? ((!empty($HTTP_POST_VARS['disable_bbcode'])) ? 0 : TRUE ) : (($userdata['user_id'] == ANONYMOUS) ? $board_config['allow_bbcode'] : $userdata['user_allowbbcode']);
	}
}
else
{
	if ( !$board_config['allow_bbcode'] )
	{
		$bbcode_on = 0;
	}
	else
	{
		$bbcode_on = ($submit || $refresh) ? ((!empty($HTTP_POST_VARS['disable_bbcode'])) ? 0 : TRUE) : (($userdata['user_id'] == ANONYMOUS) ? $board_config['allow_bbcode'] : $userdata['user_allowbbcode']);
	}
}

if ( !$board_config['allow_smilies'] || ( $board_config['restrict_smilies'] && !$userdata['session_logged_in'] ) )
{
	$smilies_on = 0;
}
else
{
	$smilies_on = ($submit || $refresh) ? ((!empty($HTTP_POST_VARS['disable_smilies'])) ? 0 : TRUE) : (($userdata['user_id'] == ANONYMOUS) ? $board_config['allow_smilies'] : $userdata['user_allowsmile']);
}

if ( ($submit || $refresh) && $is_auth['auth_read'] )
{
	$notify_user = (!empty($HTTP_POST_VARS['notify'])) ? TRUE : 0;
}
else
{
	if ( $mode != 'newtopic' && $userdata['session_logged_in'] )
	{
		$sql = "SELECT topic_id 
			FROM " . TOPICS_WATCH_TABLE . "
			WHERE topic_id = $topic_id 
				AND user_id = " . $userdata['user_id'];
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain topic watch information', '', __LINE__, __FILE__, $sql);
		}

		$notify_user = ($db->sql_fetchrow($result)) ? TRUE : $userdata['user_notify'];
	}
	else
	{
		$notify_user = ($userdata['session_logged_in'] && $is_auth['auth_read']) ? $userdata['user_notify'] : 0;
	}
}

$attach_sig = ($submit || $refresh) ? ((!empty($HTTP_POST_VARS['attach_sig'])) ? TRUE : 0) : (($userdata['user_id'] == ANONYMOUS) ? 0 : $userdata['user_attachsig']);

if ( defined('ATTACHMENTS_ON') )
{
	execute_posting_attachment_handling();
}

// What shall we do?
if ( ( $delete || $poll_delete || $mode == 'delete' ) && !$confirm )
{
	// Confirm deletion
	$s_hidden_fields = '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" /><input type="hidden" name="' . POST_POST_URL . '" value="' . $post_id . '" />';
	$s_hidden_fields .= ($delete || $mode == 'delete') ? '<input type="hidden" name="mode" value="delete" />' : '<input type="hidden" name="mode" value="poll_delete" />';

	$l_confirm = ($delete || $mode == 'delete') ? $lang['Confirm_delete'] : $lang['Confirm_delete_poll'];

	// Output confirmation page
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);

	if ( $mode == 'delete' && $post_info['poster_id'] != $userdata['user_id'] && $post_info['poster_id'] != ANONYMOUS && $board_config['del_notify_enable'])
	{
		$reason_jumpbox = '<select name="reasons">';
		for($i = 0; $i < count($lang['del_notify_reasons']); $i++)
		{
			$reason_jumpbox .= '<option value="' . $i . '" ' . (($i == 0) ?'selected="selected"' : '') . '>' . $lang['del_notify_reasons'][$i] . '</option>';
		}
		$reason_jumpbox .= '</select>';

		$s_hidden_fields .= '<input type="hidden" name="notify_user" value="' . $post_info['poster_id'] . '" />';
		$del_choice = ($board_config['del_notify_choice']) ? '<input type="checkbox" name="no_notify"> ' . $lang['del_notify_choice'] . '<br /><br />' : '';

		$sql = "SELECT username
			FROM " . USERS_TABLE . "
			WHERE user_id = " . $post_info['poster_id'];
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get username from users table', '', __LINE__, __FILE__, $sql);
		}
		$rowname = $db->sql_fetchrow($result);

		$template->set_filenames(array(
			'confirm_body' => 'confirm_body_notify.tpl')
		);

		$template->assign_vars(array(
			'MESSAGE_TITLE' => sprintf($lang['del_notify'], $rowname['username']),
			'REASON_JUMPBOX' => $reason_jumpbox,

			'L_DEL_NOTIFY_REASON' => $lang['del_notify_reason'],
			'L_DEL_NOTIFY_REASON_E' => $lang['del_notify_reason_e'],
			'L_DEL_NOTIFY_REASON2' => $lang['del_notify_reason2'],
			'L_DEL_NOTIFY_REASON2_E' => $lang['del_notify_reason2_e'],
			'L_DEL_NOTIFY' => $lang['del_notify'],
			'L_CONFIRM_DELETE' => $del_choice . $lang['Confirm_delete'],
			'L_YES' => $lang['Yes'],
			'L_NO' => $lang['Cancel'],

			'S_CONFIRM_ACTION' => append_sid("posting.$phpEx"),
			'S_HIDDEN_FIELDS' => $s_hidden_fields)
		);
	}
	else
	{
		$template->set_filenames(array(
			'confirm_body' => 'confirm_body.tpl')
		);

		$template->assign_vars(array(
			'MESSAGE_TITLE' => $lang['Information'],
			'MESSAGE_TEXT' => $l_confirm,

			'L_YES' => $lang['Yes'],
			'L_NO' => $lang['No'],

			'S_CONFIRM_ACTION' => append_sid("posting.$phpEx"),
			'S_HIDDEN_FIELDS' => $s_hidden_fields)
		);
	}

	$template->pparse('confirm_body');

	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}
else if ( $mode == 'vote' )
{
	// Vote in a poll
	$vote_option_id = intval($HTTP_POST_VARS['vote_id']);

	$sql = "SELECT vd.vote_id, vd.vote_max
		FROM " . VOTE_DESC_TABLE . " vd, " . VOTE_RESULTS_TABLE . " vr
		WHERE vd.topic_id = $topic_id
			AND vr.vote_id = vd.vote_id
			AND vr.vote_option_id = $vote_option_id
		GROUP BY vd.vote_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain vote data for this topic', '', __LINE__, __FILE__, $sql);
	}

	if ( $vote_info = $db->sql_fetchrow($result) )
	{
		$max_vote = $vote_info['vote_max'];
	}

	$max_voting = count($HTTP_POST_VARS['vote_id']);

	if ( $max_voting > $max_vote )
	{
		$message_return .= '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, sprintf($lang['too_many_voting'], $max_vote, $max_voting) . $message_return);
	}
	$vddd = '';

	for($i = 0; $i < $max_voting; $i++)
	{
		$vbn[$i] = $HTTP_POST_VARS['vote_id'][$i];
	}

	$sql = "SELECT vd.vote_id
		FROM " . VOTE_DESC_TABLE . " vd, " . VOTE_RESULTS_TABLE . " vr
		WHERE vd.topic_id = $topic_id
			AND vr.vote_id = vd.vote_id
			AND vr.vote_option_id = $vote_option_id
		GROUP BY vd.vote_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain vote data for this topic', '', __LINE__, __FILE__, $sql);
	}

	if ( $vote_info = $db->sql_fetchrow($result) )
	{
		$vote_id = $vote_info['vote_id'];

		$sql = "SELECT *
			FROM " . VOTE_USERS_TABLE . "
			WHERE vote_id = $vote_id
				AND vote_user_id = " . $userdata['user_id'];
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain user vote data for this topic', '', __LINE__, __FILE__, $sql);
		}

		if ( !($row = $db->sql_fetchrow($result)) )
		{
			for($i = 0; $i < $max_voting; $i++)
			{
				$vote_option_id = $vbn[$i];

				$sql = "UPDATE " . VOTE_RESULTS_TABLE . " 
					SET vote_result = vote_result + 1 
					WHERE vote_id = $vote_id 
					AND vote_option_id = $vote_option_id";
				$vote_option_id = $vddd;
				if ( !$db->sql_query($sql, BEGIN_TRANSACTION) )
				{
					message_die(GENERAL_ERROR, 'Could not update poll result', '', __LINE__, __FILE__, $sql);
				}

				$sql = "INSERT INTO " . VOTE_USERS_TABLE . " (vote_id, vote_user_id, vote_user_ip, vote_cast)
					VALUES ($vote_id, " . $userdata['user_id'] . ", '$user_ip', '" . $vbn[$i] . "')";
				if ( !$db->sql_query($sql, BEGIN_TRANSACTION) )
				{
					message_die(GENERAL_ERROR, "Could not insert user_id for poll", "", __LINE__, __FILE__, $sql);
				}
			}
			$sql = "UPDATE " . VOTE_DESC_TABLE . " 
				SET vote_voted = vote_voted + 1 
				WHERE vote_id = $vote_id 
				AND topic_id = $topic_id";
			if ( !$db->sql_query($sql, BEGIN_TRANSACTION) )
			{
				message_die(GENERAL_ERROR, 'Could not update poll voted', '', __LINE__, __FILE__, $sql);
			}
			$message = $lang['Vote_cast'];
		}
		else
		{
			$message = $lang['Already_voted'];
		}
	}
	else
	{
		$message = $lang['No_vote_option'];
	}

	$template->assign_vars(array(
		'META' => '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">')
	);

	$message .= '<br /><br />' . sprintf($lang['Click_view_message'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}
else if ( $submit || $confirm )
{
	// Submit post/vote (newtopic, edit, reply, etc.)

	if ( $mode == 'reply' && $board_config['split_messages'] && $userdata['user_id'] != ANONYMOUS )
	{
		$do_split = false;
		if ( $userdata['user_level'] == ADMIN || $is_jr_admin )
		{
			$do_split = (!$board_config['split_messages_admin']) ? false : true;
		}
		else
		{
			$do_split = ($is_mod && !$board_config['split_messages_mod']) ? false : true;
		}

		if ( !empty($board_config['split_messages_except']) && $do_split )
		{
			if ( strstr($board_config['split_messages_except'], ',') )
			{
				$fids = explode(',', $board_config['split_messages_except']);
				while( list($foo, $id) = each($fids) )
				{
					$fid[] = intval( trim($id) );
				}
			}
			else
			{
				$fid[] = intval( trim($board_config['split_messages_except']) );
			}
			reset($fid);
			$do_split = ( in_array($forum_id, $fid) == true ) ? false : true;
		}

		if ( isset($HTTP_POST_VARS['nosplit']) && ($userdata['user_level'] == ADMIN || $is_jr_admin || $is_mod) )
		{
			$do_split = false;
		}

		if ( $do_split )
		{
			$poster_id = $userdata['user_id'];

			$sql = "SELECT post_id, poster_id, MAX(post_time) FROM " . POSTS_TABLE . "
				WHERE topic_id = $topic_id
				GROUP BY post_time
				ORDER BY post_time DESC LIMIT 1";
	
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not obtain post', '', __LINE__, __FILE__, $sql);
			}
			$post_id_last_row = $db->sql_fetchrow($result);
			$post_id = $post_id_last_row['post_id'];
			$poster_topic_id = $post_id_last_row['poster_id'];

			if ( $post_id_last_row['poster_id'] == $poster_id )
			{
				$sql = "SELECT pt.post_text, pt.bbcode_uid, p.enable_bbcode, p.enable_html, p.enable_smilies
					FROM " . POSTS_TEXT_TABLE . " pt, " . POSTS_TABLE . " p
					WHERE p.post_id = $post_id
					AND pt.post_id = $post_id";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not obtain post information', '', __LINE__, __FILE__, $sql);
				}
				$row = $db->sql_fetchrow($result);

				$buid = $row['bbcode_uid'];
				$add_data = create_date($board_config['default_dateformat'], time(), $board_config['board_timezone']);
				$separator = " \n\n[size=9:" . $buid . "][ [i:" . $buid . "][b:" . $buid . "]" . $lang['added'] . "[/b:" . $buid . "]: " . $add_data . "[/i:" . $buid . "] ][/size:" . $buid . "]\n";
				$message = prepare_message($HTTP_POST_VARS['message'], $row['enable_html'], $row['enable_bbcode'], $row['enable_smilies'], $buid, $forum_id);
				$last_message = prepare_message(str_replace(array("'", "\\"), array("''", "\\\\"), unprepare_message($row['post_text'])), $row['enable_html'], $row['enable_bbcode'], $row['enable_smilies'], $buid, $forum_id);
				$splited = $last_message . $separator . str_replace("\'", "''", $message);

				if ( strlen($splited) > 65500 )
				{
					message_die(GENERAL_MESSAGE, 'Your message is too long. It can not be more than 65500 chars.');
				}

				if ( trim(str_replace("''", "\'", $last_message)) == trim(str_replace('\"', '"', $message)) )
				{
					message_die(GENERAL_ERROR, $lang['that_same_msg']);
				}

				if ( defined('ATTACHMENTS_ON') )
				{
					$attachment_mod['posting']->insert_attachment($post_id);
				}

				$sql = "UPDATE " . POSTS_TEXT_TABLE . "
					SET post_text = '$splited'
					WHERE post_id = $post_id";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not update splited message', '', __LINE__, __FILE__, $sql);
				}

				if ( $board_config['search_enable'] )
				{
					include($phpbb_root_path . 'includes/functions_search.'.$phpEx);
					add_search_words(0, $post_id, stripslashes($message));
				}

				$meta = '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=" . $post_id) . '#' . $post_id . '">';
				$return_message = $lang['Stored'] . '<br /><br />' . sprintf($lang['Click_view_message'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=" . $post_id) . '#' . $post_id . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">', '</a>');

				$template->assign_vars(array(
					'META' => $meta . $return_meta)
				);

				message_die(GENERAL_MESSAGE, $return_message);
			}
		}
	}

	$return_message = '';
	$return_meta = '';

	disallow_forums($userdata, $forum_id);

	switch ( $mode )
	{
	case 'editpost':

		$username = ( !empty($HTTP_POST_VARS['username']) ) ? $HTTP_POST_VARS['username'] : '';
		$subject = ( !empty($HTTP_POST_VARS['subject']) ) ? trim($HTTP_POST_VARS['subject']) : '';
		$subject_e = ( !empty($HTTP_POST_VARS['subject_e']) ) ? trim($HTTP_POST_VARS['subject_e']) : '';
		$message = ( !empty($HTTP_POST_VARS['message']) ) ? $HTTP_POST_VARS['message'] : '';
		$poll_title = ( isset($HTTP_POST_VARS['poll_title']) && $is_auth['auth_pollcreate'] ) ? $HTTP_POST_VARS['poll_title'] : '';
		$poll_options = ( isset($HTTP_POST_VARS['poll_option_text']) && $is_auth['auth_pollcreate'] ) ? $HTTP_POST_VARS['poll_option_text'] : '';
		$poll_length = ( isset($HTTP_POST_VARS['poll_length']) && $is_auth['auth_pollcreate'] ) ? intval($HTTP_POST_VARS['poll_length']) : '0';
		$poll_length_h = ( isset($HTTP_POST_VARS['poll_length_h']) && $is_auth['auth_pollcreate'] ) ? intval($HTTP_POST_VARS['poll_length_h']) : '0';
		$poll_length = $poll_length * 24;
		$poll_length = $poll_length_h + $poll_length;
		$poll_length = ($poll_length) ? max(0, ($poll_length / 24)) : 0;
		$max_vote = ( isset($HTTP_POST_VARS['max_vote']) && $is_auth['auth_pollcreate'] ) ? ( ( $HTTP_POST_VARS['max_vote'] == 0 ) ? 1 : $HTTP_POST_VARS['max_vote'] ) : '';
		$hide_vote = ( isset($HTTP_POST_VARS['hide_vote']) && $is_auth['auth_pollcreate'] && ($poll_length>0) ) ? 1 : '';
		$tothide_vote = ( isset($HTTP_POST_VARS['tothide_vote']) && isset($HTTP_POST_VARS['hide_vote']) && $is_auth['auth_pollcreate'] && ($poll_length>0) ) ? 1 : '';		
		$bbcode_uid = '';

		if ( strlen($message) > 65500 )
		{
			message_die(GENERAL_MESSAGE, 'Your message is too long. It can not be more than 65500 chars.');
		}

		prepare_post($mode, $post_data, $bbcode_on, $html_on, $smilies_on, $error_msg, $username, $bbcode_uid, $subject, $subject_e, $message, $poll_title, $poll_options, $poll_length, $max_vote, $hide_vote, $tothide_vote, $forum_id);

		if ( $error_msg == '' )
		{
			$topic_type = ($topic_type != $post_data['topic_type'] && !$is_auth['auth_sticky'] && !$is_auth['auth_announce'] && !$is_auth['auth_globalannounce']) ? $post_data['topic_type'] : $topic_type;

			if ( !$userdata['session_logged_in'] && $board_config['not_anonymous_posting'] && empty($HTTP_POST_VARS['username']) )
			{
				message_die(GENERAL_MESSAGE, $lang['No_to_user']);
			}

			$post_approve = ($post_info['forum_moderate'] && !$is_auth['auth_mod']) ? 0 : 1;

			submit_post($mode, $post_data, $return_message, $return_meta, $forum_id, $topic_id, $post_id, $poll_id, $topic_type, $bbcode_on, $html_on, $smilies_on, $attach_sig, $bbcode_uid, str_replace("\'", "''", $username), str_replace("\'", "''", $subject), str_replace("\'", "''", $subject_e), str_replace("\'", "''", $message), str_replace("\'", "''", $poll_title), $poll_options, $poll_length, $max_vote, $hide_vote, $tothide_vote, str_replace("\'", "''", $user_agent), $msg_icon, $msg_expire, str_replace("\'", "''", $topic_color), $post_approve, $is_mod, $is_jr_admin);
				
			if ( $userdata['user_level'] == ADMIN || is_mod($userdata['user_id'], $forum_id) )
			{
				// Log Actions Start
				log_action('edit', $topic_id, $userdata['user_id'], $userdata['username']);
			}

			$notify_n = 1;
			$mode_n = $mode;
			$post_data_n = $post_data;
			$forum_id_n = $forum_id;
			$topic_id_n = $topic_id;
			$post_id_n = $post_id;
			$notify_user_n = $notify_user;
		}
		break;

	case 'newtopic':
	case 'reply':
		$username = (!empty($HTTP_POST_VARS['username'])) ? $HTTP_POST_VARS['username'] : '';
		$subject = (!empty($HTTP_POST_VARS['subject'])) ? trim($HTTP_POST_VARS['subject']) : '';
		$subject_e = (!empty($HTTP_POST_VARS['subject_e'])) ? trim($HTTP_POST_VARS['subject_e']) : '';
		$message = (!empty($HTTP_POST_VARS['message'])) ? $HTTP_POST_VARS['message'] : '';
		$poll_title = (isset($HTTP_POST_VARS['poll_title']) && $is_auth['auth_pollcreate'] ) ? $HTTP_POST_VARS['poll_title'] : '';
		$poll_options = (isset($HTTP_POST_VARS['poll_option_text']) && $is_auth['auth_pollcreate'] ) ? $HTTP_POST_VARS['poll_option_text'] : '';
		$poll_length = (isset($HTTP_POST_VARS['poll_length']) && $is_auth['auth_pollcreate'] ) ? intval($HTTP_POST_VARS['poll_length']) : '0';
		$poll_length_h = (isset($HTTP_POST_VARS['poll_length_h']) && $is_auth['auth_pollcreate'] ) ? intval($HTTP_POST_VARS['poll_length_h']) : '0';
		$poll_length = $poll_length * 24;
		$poll_length = $poll_length_h + $poll_length;
		$poll_length = ($poll_length) ? max(0, ($poll_length / 24)) : 0;
		$max_vote = (isset($HTTP_POST_VARS['max_vote']) && $is_auth['auth_pollcreate'] ) ? ( ( $HTTP_POST_VARS['max_vote'] == 0 ) ? 1 : $HTTP_POST_VARS['max_vote'] ) : '';
		$hide_vote = (isset($HTTP_POST_VARS['hide_vote']) && $is_auth['auth_pollcreate'] && ($poll_length > 0) ) ? 1 : '';
		$tothide_vote = (isset($HTTP_POST_VARS['tothide_vote']) && isset($HTTP_POST_VARS['hide_vote']) && $is_auth['auth_pollcreate'] && ($poll_length>0) ) ? 1 : '';
		$bbcode_uid = '';
		$user_agent = (isset($HTTP_SERVER_VARS['HTTP_USER_AGENT'])) ? htmlspecialchars(trim(stripslashes($HTTP_SERVER_VARS['HTTP_USER_AGENT']))) : htmlspecialchars(trim(stripslashes(getenv('HTTP_USER_AGENT'))));

		if ( strlen($message) > 65500 )
		{
			message_die(GENERAL_MESSAGE, 'Your message is too long. It can not be more than 65500 chars.');
		}

		prepare_post($mode, $post_data, $bbcode_on, $html_on, $smilies_on, $error_msg, $username, $bbcode_uid, $subject, $subject_e, $message, $poll_title, $poll_options, $poll_length, $max_vote, $hide_vote, $tothide_vote, $forum_id);

		if ( $error_msg == '' )
		{
			$topic_type = ( $topic_type != $post_data['topic_type'] && !$is_auth['auth_sticky'] && !$is_auth['auth_announce'] && !$is_auth['auth_globalannounce'] ) ? $post_data['topic_type'] : $topic_type;

			if ( !$userdata['session_logged_in'] && $board_config['not_anonymous_posting'] && empty($HTTP_POST_VARS['username']) )
			{
				message_die(GENERAL_MESSAGE, $lang['No_to_user']);
			}

			$post_approve = ($post_info['forum_moderate'] && !$is_auth['auth_mod']) ? 0 : 1;

			submit_post($mode, $post_data, $return_message, $return_meta, $forum_id, $topic_id, $post_id, $poll_id, $topic_type, $bbcode_on, $html_on, $smilies_on, $attach_sig, $bbcode_uid, str_replace("\'", "''", $username), str_replace("\'", "''", $subject), str_replace("\'", "''", $subject_e), str_replace("\'", "''", $message), str_replace("\'", "''", $poll_title), $poll_options, $poll_length, $max_vote, $hide_vote, $tothide_vote, str_replace("\'", "''", $user_agent), $msg_icon, $msg_expire, str_replace("\'", "''", $topic_color), $post_approve, $is_mod, $is_jr_admin);

			if ( $board_config['read_tracking'] )
			{
				$current_time = time();
				smart_submit($forum_id, $topic_id, $current_time, $post_id);
			}

			$notify_n = 1;
			$mode_n = $mode;
			$post_data_n = $post_data;
			$forum_id_n = $forum_id;
			$topic_id_n = $topic_id;
			$post_id_n = $post_id;
			$notify_user_n = $notify_user;

			if ( $error_msg == '' && $lock && $mode == 'newtopic' && $is_auth['auth_mod'] )
			{
				$sql = "UPDATE " . TOPICS_TABLE . " 
				SET topic_status = " . TOPIC_LOCKED . " 
				WHERE topic_id = $topic_id
					AND topic_moved_id = 0";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not update topics table', '', __LINE__, __FILE__, $sql);
				}
			}
		}
		break;

	case 'delete':
		if ( !$board_config['report_disable'] )
		{
			$post_data['report'] = !empty($post_info['reporter_id']);
		}

	case 'poll_delete':
		if ( $HTTP_POST_VARS['sid'] == '' || $HTTP_POST_VARS['sid'] != $userdata['session_id'] )
		{
			message_die(GENERAL_ERROR, 'Invalid_session');
		}

		if ( $board_config['del_notify_enable'] && (isset($HTTP_POST_VARS['reason']) || isset($HTTP_POST_VARS['reasons'])) && (!($HTTP_POST_VARS['no_notify'] && $board_config['del_notify_choice'])) )
		{
			$reason = (!empty($HTTP_POST_VARS['reason'])) ? $HTTP_POST_VARS['reason'] : $HTTP_POST_VARS['reasons'];	
			notify_delete($post_id, $topic_id, $userdata['user_id'], intval($HTTP_POST_VARS['notify_user']), trim(stripslashes($reason)));
		}

		include($phpbb_root_path . 'includes/functions_remove.'.$phpEx);

		//delete_post($mode, $post_data, $return_message, $return_meta, $forum_id, $topic_id, $post_id, $poll_id);
		if ( $mode != 'poll_delete' )
		{
			delete_post($post_id);
		}

		if ( $mode == 'poll_delete' && $post_data['has_poll'] && $post_data['edit_poll'] )
		{
			delete_poll_data($topic_id);
		}

		if ( $mode == 'delete' && $post_data['first_post'] && $post_data['last_post'] )
		{
			$return_meta = '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . '=' . $forum_id) . '">';
			$return_message = $lang['Deleted'];
		}
		else
		{
			$return_meta = '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $topic_id) . '">';
			$return_message = ( ( $mode == 'poll_delete' ) ? $lang['Poll_delete'] : $lang['Deleted'] ) . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">', '</a>');
		}

		$message .= $return_message . '<br /><br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">', '</a>');
		
		if ( $userdata['user_level'] == ADMIN || $is_mod_forum )
		{
			// Log actions MOD Start
			log_action('delete', $topic_id, $userdata['user_id'], $userdata['username']);
		}

		break;
	}

	if ( $error_msg == '' )
	{
		if ( $mode != 'editpost')
		{
			$user_id = ($mode == 'reply' || $mode == 'newtopic') ? $userdata['user_id'] : $post_data['poster_id'];
			if ( $mode != 'delete' )
			{
				update_post_stats($mode, $post_data, $forum_id, $topic_id, $post_id, $user_id);
			}

			$sql = "SELECT ug.user_id, g.group_id as g_id, g.group_name , u.user_posts, g.group_count FROM " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
				LEFT JOIN " . USER_GROUP_TABLE . " ug ON g.group_id = ug.group_id AND ug.user_id = $user_id
				WHERE u.user_id = $user_id
				AND g.group_single_user = 0 
				AND g.group_count_enable = 1
				AND g.group_moderator <> $user_id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Error geting users post stat', '', __LINE__, __FILE__, $sql);
			}
			while ($group_data = $db->sql_fetchrow($result))
			{
				$user_already_added = (!empty($group_data['user_id']) || $user_id == ANONYMOUS) ? TRUE : FALSE;
				$user_add = ($group_data['group_count'] == $group_data['user_posts'] && $user_id != ANONYMOUS) ? TRUE : FALSE;
				$user_remove = ($group_data['group_count'] > $group_data['user_posts'] && $user_id != ANONYMOUS) ? TRUE : FALSE;
				if ( $user_add && !$user_already_added )
				{
					//user join a autogroup
					$sql = "INSERT INTO " . USER_GROUP_TABLE . " (group_id, user_id, user_pending) 
						VALUES (" . $group_data['g_id'] . ", $user_id, 0)";
					if ( !($db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Error insert users, group count', '', __LINE__, __FILE__, $sql);
					}
				}
				else if ( $user_already_added && $user_remove )
				{
					//remove user from auto group
					$sql = "DELETE FROM " . USER_GROUP_TABLE . "
						WHERE group_id = " . $group_data['g_id'] . " 
						AND user_id = $user_id";
					if ( !($db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Could not remove users, group count', '', __LINE__, __FILE__, $sql);
					}
				}
			}
		}

		if ( defined('ATTACHMENTS_ON') )
		{
			$attachment_mod['posting']->insert_attachment($post_id);
		}

		if ( !$board_config['read_tracking'] )
		{
			if ( $mode == 'newtopic' || $mode == 'reply' )
			{
				$tracking_topics = ( !empty($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : array();
				$tracking_forums = ( !empty($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) : array();

				if ( count($tracking_topics) + count($tracking_forums) == 100 && empty($tracking_topics[$topic_id]) )
				{
					asort($tracking_topics);
					unset($tracking_topics[key($tracking_topics)]);
				}

				$tracking_topics[$topic_id] = time();

				setcookie($board_config['cookie_name'] . '_t', serialize($tracking_topics), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
			}
		}

		if ( $notify_n )
		{
			$notification_username = ($userdata['user_level'] == ANONYMOUS) ? $lang['Guest'] : $userdata['username'];
			user_notification($mode_n, $post_data_n, $forum_id_n, $topic_id_n, $post_id_n, $notify_user_n, $notification_username);
		}

		$template->assign_vars(array(
			'META' => $return_meta)
		);

		message_die(GENERAL_MESSAGE, $return_message);
	}
}

if ( $refresh || isset($HTTP_POST_VARS['del_poll_option']) || $error_msg != '' )
{
	$username = (!empty($HTTP_POST_VARS['username'])) ? htmlspecialchars(trim(stripslashes($HTTP_POST_VARS['username']))) : '';
	$subject = (!empty($HTTP_POST_VARS['subject'])) ? htmlspecialchars(trim(stripslashes($HTTP_POST_VARS['subject']))) : '';
	$subject_e = (!empty($HTTP_POST_VARS['subject_e'])) ? htmlspecialchars(trim(stripslashes($HTTP_POST_VARS['subject_e']))) : '';
	$message = (!empty($HTTP_POST_VARS['message'])) ? htmlspecialchars(trim(stripslashes($HTTP_POST_VARS['message']))) : '';

	$poll_title = (!empty($HTTP_POST_VARS['poll_title'])) ? htmlspecialchars(trim(stripslashes($HTTP_POST_VARS['poll_title']))) : '';
	$poll_length = (isset($HTTP_POST_VARS['poll_length'])) ? max(0, intval($HTTP_POST_VARS['poll_length'])) : 0;
	$max_vote = (isset($HTTP_POST_VARS['max_vote'])) ? max(0, intval($HTTP_POST_VARS['max_vote'])) : 0;
	$hide_vote = (isset($HTTP_POST_VARS['hide_vote'])) ? max(0, intval($HTTP_POST_VARS['hide_vote'])) : 0;
	$tothide_vote = (isset($HTTP_POST_VARS['tothide_vote'])) ? max(0, intval($HTTP_POST_VARS['tothide_vote'])) : 0;

	$poll_options = array();
	if ( !empty($HTTP_POST_VARS['poll_option_text']) )
	{
		while( list($option_id, $option_text) = @each($HTTP_POST_VARS['poll_option_text']) )
		{
			if ( isset($HTTP_POST_VARS['del_poll_option'][$option_id]) )
			{
				unset($poll_options[$option_id]);
			}
			else if ( !empty($option_text) ) 
			{
				$poll_options[$option_id] = htmlspecialchars(trim(stripslashes($option_text)));
			}
		}
	}

	if ( isset($poll_add) && !empty($HTTP_POST_VARS['add_poll_option_text']) )
	{
		$poll_options[] = htmlspecialchars(trim(stripslashes($HTTP_POST_VARS['add_poll_option_text'])));
	}

	if ( $mode == 'newtopic' || $mode == 'reply')
	{
		$user_sig = ($userdata['user_sig'] != '' && $board_config['allow_sig']) ? $userdata['user_sig'] : '';
		$user_sig_image = ($userdata['user_sig_image'] != '' && $board_config['allow_sig'] && $board_config['allow_sig_image']) ? $userdata['user_sig_image'] : '';
	}
	else if ( $mode == 'editpost' )
	{
		$user_sig = ($post_info['user_sig'] != '' && $board_config['allow_sig']) ? $post_info['user_sig'] : '';
		$user_sig_image = ($post_info['user_sig_image'] != '' && $board_config['allow_sig'] && $board_config['allow_sig_image']) ? $post_info['user_sig_image'] : '';
	}
	
	if ( $preview )
	{
		$orig_word = array();
		$replacement_word = array();
		obtain_word_list($orig_word, $replacement_word);

		$bbcode_uid = ($bbcode_on) ? make_bbcode_uid() : '';
		$preview_message = stripslashes(prepare_message(addslashes(unprepare_message($message)), $html_on, $bbcode_on, $smilies_on, $bbcode_uid, $forum_id));
		$preview_message = preg_replace("#\[mod\](.*?)\[/mod\]#si", "<br /><u><b>Mod Info:</u><br />[</b>\\1<b>]</b><br />", $preview_message);
		$preview_subject = $subject;
		$preview_subject_e = $subject_e;
		$preview_username = $username;

		$user_sig = ($userdata['user_allow_signature']) ? $user_sig : '';
		$user_sig_image = ($userdata['user_allow_signature'] && $userdata['user_allow_sig_image']) ? $user_sig_image : '';

		// Finalise processing as per viewtopic
		if ( !$html_on )
		{
			if ( $user_sig != '' || !$userdata['user_allowhtml'] )
			{
				$user_sig = preg_replace('#(<)([\/]?.*?)(>)#is', '&lt;\2&gt;', $user_sig);
			}
		}

		$valid = FALSE;
		if ( $userdata['session_logged_in'] )
		{
			$sql = "SELECT p.poster_id, p.topic_id
				FROM " . POSTS_TABLE . " p
				WHERE p.topic_id = $topic_id
				AND p.poster_id = " . $userdata['user_id'];
			$resultat = $db->sql_query($sql);
			$valid = $db->sql_numrows($resultat) ? TRUE : FALSE;
		}

		$post_text_html = (eregi('<td>', $preview_message) || eregi('<tr>', $preview_message) || eregi('<table>', $preview_message)) ? true : false;

		if ( $attach_sig && $user_sig != '' && $userdata['user_sig_bbcode_uid'] )
		{
			$user_sig = bbencode_second_pass($user_sig, $userdata['user_sig_bbcode_uid'], $userdata['username']);
			$user_sig = bbencode_third_pass($user_sig, $userdata['user_sig_bbcode_uid'], $valid);
		}
		if ( $bbcode_on )
		{
			$preview_message = bbencode_second_pass($preview_message, $bbcode_uid, $userdata['username']);
			$preview_message = bbencode_third_pass($preview_message, $bbcode_uid, $valid);
		}

		if ( !empty($orig_word) )
		{
			$preview_username = (!empty($username)) ? preg_replace($orig_word, $replacement_word, $preview_username) : '';
			$preview_subject = (!empty($subject)) ? preg_replace($orig_word, $replacement_word, $preview_subject) : '';
			$preview_subject_e = (!empty($subject_e)) ? preg_replace($orig_word, $replacement_word, $preview_subject_e) : '';
			$preview_message = (!empty($preview_message)) ? preg_replace($orig_word, $replacement_word, $preview_message) : '';
		}

		if ( $user_sig != '' )
		{
			$user_sig = make_clickable($user_sig);
		}
		$preview_message = make_clickable($preview_message);

		if ( $smilies_on )
		{
			if ( $userdata['user_allowsmile'] && $user_sig != '' )
			{
				$user_sig = smilies_pass($user_sig);
			}

			$preview_message = smilies_pass($preview_message);
		}

		if ( $attach_sig && $user_sig != '' )
		{
			$preview_message = $preview_message . '<br /><br />_________________<br />' . $user_sig;
		}
		if ( $attach_sig && $user_sig_image != '' )
		{
			$preview_message .= (($user_sig != '') ? '<br />' : '<br /><br />_________________<br />') . '<img src="' . $board_config['sig_images_path'] . '/' . $user_sig_image . '" border="0" />';
		}

		$message_html = ( $post_text_html && (($board_config['mod_html'] && $is_mod_forum) || ($board_config['admin_html'] && $userdata['user_level'] == ADMIN) || ($board_config['jr_admin_html'] && $is_jr_admin)) ) ? true : false;

		if ( !empty($HTTP_POST_VARS['disable_html']) || !$message_html )
		{
			$preview_message = str_replace("\n", '<br />', $preview_message);
		}

		$template->set_filenames(array(
			'preview' => 'posting_preview.tpl')
		);

		if ( defined('ATTACHMENTS_ON') )
		{
			$attachment_mod['posting']->preview_attachments();
		}

		$template->assign_vars(array(
			'TOPIC_TITLE' => $preview_subject,
			'POST_SUBJECT' => $preview_subject . (($preview_subject_e) ? ' [' . $preview_subject_e . ']' : ''),
			'POSTER_NAME' => $preview_username,
			'POST_DATE' => create_date($board_config['default_dateformat'], time(), $board_config['board_timezone']),
			'MESSAGE' => $preview_message,

			'L_POST_SUBJECT' => $lang['Post_subject'],
			'L_PREVIEW' => $lang['Preview'],
			'L_POSTED' => $lang['Posted'], 
			'L_POST' => $lang['Post'])
		);

		$template->assign_var_from_handle('POST_PREVIEW_BOX', 'preview');
	}
	else if ( $error_msg != '' )
	{
		$template->set_filenames(array(
			'reg_header' => 'error_body.tpl')
		);

		$template->assign_vars(array(
			'ERROR_MESSAGE' => $error_msg)
		);

		$template->assign_var_from_handle('ERROR_BOX', 'reg_header');
	}
}
else
{
	// User default entry point
	if ( $mode == 'newtopic' )
	{
		$user_sig = ($userdata['user_sig'] != '') ? $userdata['user_sig'] : '';
		$user_sig_image = ($userdata['user_sig_image'] != '') ? $userdata['user_sig_image'] : '';

		$username = ($userdata['session_logged_in']) ? $userdata['username'] : '';
		$poll_title = '';
		$poll_length = '';
		$poll_length_h = '';
		$max_vote = '1';
		$hide_vote = '';
		$tothide_vote = '';
		$subject = '';
		$subject_e = '';
		$message = '';
	}
	else if ( $mode == 'reply' )
	{
		$user_sig = ($userdata['user_sig'] != '') ? $userdata['user_sig'] : '';
		$user_sig_image = ($userdata['user_sig_image'] != '') ? $userdata['user_sig_image'] : '';

		$username = ($userdata['session_logged_in']) ? $userdata['username'] : '';
		$subject = '';
		$subject_e = '';
		$message = '';

	}

	else if ( $mode == 'quote' || $mode == 'editpost' )
	{
		$subject = ($post_data['first_post']) ? $post_info['topic_title'] : $post_info['post_subject'];
		$subject_e = ($post_data['first_post']) ? $post_info['topic_title_e'] : '';
		$message = $post_info['post_text'];

		if ( $mode == 'editpost' )
		{
			$attach_sig = ($post_info['enable_sig'] && ($post_info['user_sig'] != '' || $post_info['user_sig_image'] != '')) ? TRUE : 0; 
			$user_sig = $post_info['user_sig'];
			$user_sig_image = $post_info['user_sig_image'];

			$html_on = ($post_info['enable_html']) ? true : false;
			$bbcode_on = ($post_info['enable_bbcode']) ? true : false;
			$smilies_on = ($post_info['enable_smilies']) ? true : false;

			switch ($post_info['post_icon'])
			{
				case 1 : $msg_icon_checked = 1; break;
				case 2 : $msg_icon_checked = 2; break;
				case 3 : $msg_icon_checked = 3; break;
				case 4 : $msg_icon_checked = 4; break;
				case 5 : $msg_icon_checked = 5; break;
				case 6 : $msg_icon_checked = 6; break;
				case 7 : $msg_icon_checked = 7; break;
				case 8 : $msg_icon_checked = 8; break;
				case 9 : $msg_icon_checked = 9; break;
				case 10 : $msg_icon_checked = 10; break;
				case 11 : $msg_icon_checked = 11; break;
				case 12 : $msg_icon_checked = 12; break;
				default : $msg_icon_checked = 0; break;
			}

			$selected = ' "selected="selected"';
			$check0 = ($post_info['post_expire'] == '0') ? $selected : '';
			$check1 = ($post_info['post_expire'] == '86400') ? $selected : '';
			$check2 = ($post_info['post_expire'] == '172800') ? $selected : '';
			$check3 = ($post_info['post_expire'] == '259200') ? $selected : '';
			$check4 = ($post_info['post_expire'] == '345600') ? $selected : '';
			$check5 = ($post_info['post_expire'] == '432000') ? $selected : '';
			$check6 = ($post_info['post_expire'] == '518400') ? $selected : '';
			$check7 = ($post_info['post_expire'] == '604800') ? $selected : '';
			$check14 = ($post_info['post_expire'] == '1209600') ? $selected : '';
			$check30 = ($post_info['post_expire'] == '2592000') ? $selected : '';
			$check90 = ($post_info['post_expire'] == '7776000') ? $selected : '';
		}
		else
		{
			$attach_sig = ($userdata['user_attachsig']) ? TRUE : 0;
			$user_sig = $userdata['user_sig'];
			$user_sig_image = $userdata['user_sig_image'];
		}

		if ( $post_info['bbcode_uid'] != '' )
		{
			$message = preg_replace('/\:(([a-z0-9]:)?)' . $post_info['bbcode_uid'] . '/s', '', $message);
		}

		$message = str_replace('<', '&lt;', $message);
		$message = str_replace('>', '&gt;', $message);
		$message = str_replace('<br />', "\n", $message);

		if ( $mode == 'quote' )
		{
			$orig_word = array();
			$replacement_word = array();
			obtain_word_list($orig_word, $replace_word);

			$msg_date = create_date($board_config['default_dateformat'], $postrow['post_time'], $board_config['board_timezone']);

			$quote_username = (trim($post_info['post_username']) != '') ? $post_info['post_username'] : $post_info['username'];
			$message = '[quote="' . $quote_username . '"]' . $message . '[/quote]';
			$message = preg_replace("/(?<!;)(\[img\](.+?)\[\/img\])/s","[url=\\2]$lang[quote_image][/url]", $message);

			if ( !empty($orig_word) )
			{
				$subject = (!empty($subject)) ? preg_replace($orig_word, $replace_word, $subject) : '';
				$message = (!empty($message)) ? preg_replace($orig_word, $replace_word, $message) : '';
			}

			if ( $userdata['user_level'] != ADMIN && !$is_jr_admin && !$is_auth['auth_mod'] )
			{
				$message = preg_replace("#\[mod\](.*?)\[/mod\]#si", "", $message);
			}

			if ( !preg_match('/^Re:/', $subject) && strlen($subject) > 0 )
			{
				$subject = 'Re: ' . $subject;
			}
			if ( !$userdata['session_logged_in'] )
			{
				$message = hide_in_quote($message);
			}
			else
			{
				$sql = "SELECT p.poster_id, p.topic_id
					FROM " . POSTS_TABLE . " p
					WHERE p.topic_id = $topic_id
					AND p.poster_id = " . $userdata['user_id'];
				$resultat = $db->sql_query($sql);

				if (!$db->sql_numrows($resultat))
				{
					$message = hide_in_quote($message);
				}
			}
			$mode = 'reply';
		}
		else
		{
			$username = ( $post_info['user_id'] == ANONYMOUS && !empty($post_info['post_username']) ) ? $post_info['post_username'] : '';
		}
	}
}

// Signature toggle selection
if ( $user_sig != '' || $user_sig_image != '' )
{
	$template->assign_block_vars('switch_signature_checkbox', array());
}

if ( $board_config['post_icon'] )
{
	$template->assign_block_vars('switch_msgicon_checkbox', array());
}

$rep = $images['rank_path'] . 'icon';
$dir = opendir($rep);
$i = 0;
$icons_value = 0;
while($file = readdir($dir))
{
	if (strpos($file, '.gif'))
	{
		$i++;
		$icons_value++;
	}
}
closedir($dir);

$class_more_icons = 'gensmall';
if ( $board_config['post_icon'] && $icons_value > 12 )
{
	$template->assign_block_vars('switch_msgicon_checkbox.more_icons', array());
	$class_more_icons = 'copyright';
}

// HTML toggle selection
if ( $show_html )
{
	$html_status = $lang['HTML_is_ON'];
	$template->assign_block_vars('switch_html_checkbox', array());
}
else
{
	$html_status = $lang['HTML_is_OFF'];
}

// BBCode toggle selection
if ( $board_config['allow_bbcode'] || $userdata['session_logged_in'] )
{
	$bbcode_status = $lang['BBCode_is_ON'];
	$template->assign_block_vars('switch_bbcode_checkbox', array());
}
else
{
	$bbcode_status = $lang['BBCode_is_OFF'];
}

// Smilies toggle selection
if ( $board_config['allow_smilies'] )
{
	$smilies_status = $lang['Smilies_are_ON'];
	$template->assign_block_vars('switch_smilies_checkbox', array());
}
else
{
	$smilies_status = $lang['Smilies_are_OFF'];
}

if ( !$userdata['session_logged_in'] || ( $mode == 'editpost' && $post_info['poster_id'] == ANONYMOUS ) )
{
	$template->assign_block_vars('switch_username_select', array());
}

// Notify checkbox - only show if user is logged in
if ( $userdata['session_logged_in'] && $is_auth['auth_read'] )
{
	if ( $mode != 'editpost' || ( $mode == 'editpost' && $post_info['poster_id'] != ANONYMOUS ) )
	{
		$template->assign_block_vars('switch_notify_checkbox', array());
	}
}

// Delete selection
if ( $mode == 'editpost' && ( ( $is_auth['auth_delete'] && $post_data['last_post'] && ( !$post_data['has_poll'] || $post_data['edit_poll'] ) ) || $is_auth['auth_mod'] ) )
{
	$template->assign_block_vars('switch_delete_checkbox', array());
}

// Lock/Unlock topic selection
if ( ( $mode == 'editpost' || $mode == 'reply' || $mode == 'quote' || $mode == 'newtopic' ) && $is_auth['auth_mod'] )
{
	if ( $post_info['topic_status'] == TOPIC_LOCKED )
	{
		$template->assign_block_vars('switch_unlock_topic', array());

		$template->assign_vars(array(
			'L_UNLOCK_TOPIC' => $lang['Unlock_topic'],
			'S_UNLOCK_CHECKED' => ($unlock) ? 'checked="checked"' : '')
		);
	}
	else if ( $post_info['topic_status'] == TOPIC_UNLOCKED )
	{
		$template->assign_block_vars('switch_lock_topic', array());
		
		$template->assign_vars(array(
			'L_LOCK_TOPIC' => $lang['Lock_topic'],
			'S_LOCK_CHECKED' => ($lock) ? 'checked="checked"' : '')
		);
	}
}

if ( $board_config['split_messages'] )
{
	$show_nosplit = false;
	if ( $userdata['user_level'] == ADMIN || $is_jr_admin )
	{
		$show_nosplit = ($board_config['split_messages_admin']) ? true : false;
	}
	else if ( $is_mod )
	{
		$show_nosplit = ($board_config['split_messages_mod']) ? true : false;
	}
	if ( !empty($board_config['split_messages_except']) && $show_nosplit )
	{
		if ( strstr($board_config['split_messages_except'], ',') )
		{
			$fids = explode(',', $board_config['split_messages_except']);
			while( list($foo, $id) = each($fids) )
			{
				$fid[] = intval( trim($id) );
			}
		}
		else
		{
			$fid[] = intval( trim($board_config['split_messages_except']) );
		}
		reset($fid);
		$show_nosplit = ( in_array($forum_id, $fid) == true ) ? false : true;
	}

	if ( $show_nosplit == true )
	{
		$template->assign_block_vars('switch_no_split_post', array());
		
		$template->assign_vars(array(
			'L_NO_SPLIT_POST' => $lang['No_split_post'])
		);
	}
}

// Topic type selection
$topic_type_toggle = '';
if ( $mode == 'newtopic' || ( $mode == 'editpost' && $post_data['first_post'] ) )
{
	$template->assign_block_vars('switch_type_toggle', array());

	if ( $is_auth['auth_sticky'] )
	{
		$topic_type_toggle .= '<input type="radio" name="topictype" value="' . POST_STICKY . '"';
		if ( $post_data['topic_type'] == POST_STICKY || $topic_type == POST_STICKY )
		{
			$topic_type_toggle .= ' checked="checked"';
		}
		$topic_type_toggle .= ' /> ' . $lang['Post_Sticky'] . '&nbsp;&nbsp;';
	}

	if ( $is_auth['auth_announce'] )
	{
		$topic_type_toggle .= '<input type="radio" name="topictype" value="' . POST_ANNOUNCE . '"';
		if ( $post_data['topic_type'] == POST_ANNOUNCE || $topic_type == POST_ANNOUNCE )
		{
			$topic_type_toggle .= ' checked="checked"';
		}
		$topic_type_toggle .= ' /> ' . $lang['Post_Announcement'] . '&nbsp;&nbsp;';
	}
	if ( $is_auth['auth_globalannounce'] )

	{
		$topic_type_toggle .= '<input type="radio" name="topictype" value="' . POST_GLOBAL_ANNOUNCE . '"';
		if ( $post_data['topic_type'] == POST_GLOBAL_ANNOUNCE )
		{
			$topic_type_toggle .= ' checked="checked"';
		}
		$topic_type_toggle .= ' /> ' . $lang['Post_global_announcement'] . '&nbsp;&nbsp;';
	}

	if ( $topic_type_toggle != '' )
	{
		$topic_type_toggle = $lang['Post_topic_as'] . ': <input type="radio" name="topictype" value="' . POST_NORMAL .'"' . ( ( $post_data['topic_type'] == POST_NORMAL || $topic_type == POST_NORMAL ) ? ' checked="checked"' : '' ) . ' /> ' . $lang['Post_Normal'] . '&nbsp;&nbsp;' . $topic_type_toggle;
	}
}

$hidden_form_fields = '<input type="hidden" name="mode" value="' . $mode . '" />';

switch( $mode )
{
	case 'newtopic':
		$page_title = $lang['Post_a_new_topic'];
		$hidden_form_fields .= '<input type="hidden" name="' . POST_FORUM_URL . '" value="' . $forum_id . '" />';
		break;

	case 'reply':
		$page_title = $lang['Post_a_reply'];
		$hidden_form_fields .= '<input type="hidden" name="' . POST_TOPIC_URL . '" value="' . $topic_id . '" />';
		break;

	case 'editpost':
		$page_title = $lang['Edit_Post'];
		$hidden_form_fields .= '<input type="hidden" name="' . POST_POST_URL . '" value="' . $post_id . '" />';
		break;
}

// Generate smilies listing for page output
generate_smilies('inline', PAGE_POSTING);

// Include page header
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'posting_body.tpl',
	'pollbody' => 'posting_poll_body.tpl',
	'reviewbody' => 'posting_topic_review.tpl')
);

make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'FORUM_NAME' => $forum_name,
	'L_POST_A' => $page_title,
	'L_POST_SUBJECT' => $lang['Post_subject'],

	'U_VIEW_FORUM' => append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id"))
);

// This enables the forum/topic title to be output for posting
// but not for privmsg (where it makes no sense)
$template->assign_block_vars('switch_not_privmsg', array());

// Output the data to the template
$topic_select_color = '';
if ( $board_config['topic_color'] && ( $mode == 'newtopic' || ( $mode == 'editpost' && $post_data['first_post'] ) ) )
{
	if ( $userdata['user_level'] == ADMIN || ( $userdata['can_topic_color'] && $board_config['topic_color'] && $is_auth['auth_mod'] && $board_config['topic_color_mod'] || $userdata['can_topic_color'] && $board_config['topic_color_all'] && $board_config['topic_color'] ) )
	{
		$selected = ' selected="selected"';
		$tcol_empty = ($post_info['topic_color'] == '') ? $selected : '';
		$tcol_darkred = ($post_info['topic_color'] == 'darkred') ? $selected : '';
		$tcol_red = ($post_info['topic_color'] == 'red') ? $selected : '';
		$tcol_orange = ($post_info['topic_color'] == 'orange') ? $selected : '';
		$tcol_brown = ($post_info['topic_color'] == 'brown') ? $selected : '';
		$tcol_yellow = ($post_info['topic_color'] == 'yellow') ? $selected : '';
		$tcol_green = ($post_info['topic_color'] == 'green') ? $selected : '';
		$tcol_olive = ($post_info['topic_color'] == 'olive') ? $selected : '';
		$tcol_cyan = ($post_info['topic_color'] == 'cyan') ? $selected : '';
		$tcol_blue = ($post_info['topic_color'] == 'blue') ? $selected : '';
		$tcol_darkblue = ($post_info['topic_color'] == 'darkblue') ? $selected : '';
		$tcol_indigo = ($post_info['topic_color'] == 'indigo') ? $selected : '';
		$tcol_violet = ($post_info['topic_color'] == 'violet') ? $selected : '';
		$tcol_white = ($post_info['topic_color'] == 'white') ? $selected : '';
		$tcol_black = ($post_info['topic_color'] == 'black') ? $selected : '';
		$topic_select_color = ' &nbsp;' . $lang['topic_color'] . ': <select class="post" name="topic_color" onMouseOver="helpline(\'ct\')"><option style="' . $theme['fontcolor1'] . ';" value="" class="genmed"' . $tcol_empty . '>' . $lang['color_default'] . '</option><option style="color:darkred;" value="darkred" class="genmed"' . $tcol_darkred . '>' . $lang['color_dark_red'] . '</option><option style="color:red;" value="red" class="genmed"' . $tcol_red . '>' . $lang['color_red'] . '</option><option style="color:orange;" value="orange" class="genmed"' . $tcol_orange . '>' . $lang['color_orange'] . '</option><option style="color:brown;" value="brown" class="genmed"' . $tcol_brown . '>' . $lang['color_brown'] . '</option><option style="color:yellow;" value="yellow" class="genmed"' . $tcol_yellow . '>' . $lang['color_yellow'] . '</option><option style="color:green;" value="green" class="genmed"' . $tcol_green . '>' . $lang['color_green'] . '</option><option style="color:olive;" value="olive" class="genmed"' . $tcol_olive . '>' . $lang['color_olive'] . '</option><option style="color:cyan;" value="cyan" class="genmed"' . $tcol_cyan . '>' . $lang['color_cyan'] . '</option><option style="color:blue;" value="blue" class="genmed"' . $tcol_blue . '>' . $lang['color_blue'] . '</option><option style="color:darkblue;" value="darkblue" class="genmed"' . $tcol_darkblue . '>' . $lang['color_dark_blue'] . '</option><option style="color:indigo;" value="indigo" class="genmed"' . $tcol_indigo . '>' . $lang['color_indigo'] . '</option><option style="color:violet;" value="violet" class="genmed"' . $tcol_violet . '>' . $lang['color_violet'] . '</option><option style="color:white;" value="white" class="genmed"' . $tcol_white . '>' . $lang['color_white'] . '</option><option style="color:black;" value="black" class="genmed"' . $tcol_black . '>' . $lang['color_black'] . '</option></select>';
	}
}

if ( $portal_config['portal_on'] && $board_config['portal_link'] )
{
	if ( strstr($portal_config['witch_news_forum'], ',') )
	{
		$fids = explode(',', $portal_config['witch_news_forum']);
		while( list($foo, $id) = each($fids) )
		{
			$fid[] = intval( trim($id) );
		}
	}
	else
	{
		$fid[] = intval( trim($portal_config['witch_news_forum']) );
	}
	reset($fid);
	$u_index_check = ( in_array($forum_id, $fid) != false ) ? append_sid('portal.'.$phpEx) : append_sid('index.'.$phpEx);
}
else
{
	$u_index_check = append_sid('index.'.$phpEx);
}

disallow_forums($userdata, $forum_id);

//$symbols = array('&#181;','&#937;','&#928;','&#966;','&#916;','&#920;','&#923;','&#931;','&#934;','&#936;','&#945;','&#946;','&#967;','&#964;','&#947;','&#948;','&#949;','&#950;','&#951;','&#968;','&#952;','&#955;','&#958;','&#961;','&#963;','&#969;','&#954;','&#915;','&#9827;','&#9829;','&#8364;','&#167','&#169;','&#174;','&#8226;','&#8482;','','&#171;','&#187;','&#8804;','&#8805;','&#179;','&#178;','&#189;','&#188;','&#190;','&#177;','&#247','&#215','&#8730;','&#8734;','&#8747;','&#8776;','&#8800;','&#8801;');
$symbols = array('&micro','&Omega;','&Pi;','&phi;','&Delta;','&Theta;','&Lambda;','&Sigma;','&Phi;','&Psi;','&alpha;','&beta;','&chi;','&tau;','&gamma;','&delta;','&epsilon;','&zeta;','&eta;','&psi;','&theta;','&lambda;','&xi;','&rho;','&sigma;','&omega;','&kappa;','&Gamma;','&clubs;','&hearts;','&euro;','&sect;','&copy;','&reg;','&bull;','&trade;','&deg;','&laquo;','&raquo;','&le;','&ge;','&sup3;','&sup2;','&frac12;','&frac14;','&frac34;','&plusmn;','&divide;','&times;','&radic;','&infin;','&int;','&asymp;','&ne;','&equiv;');
$symbol = '<tr><td align="center"><table align="center"><tr align="center" valign="middle">';
for($i = 0; $i < count($symbols); $i++)
{
	if ( ($i / 11 == 1) || ($i / 11 == 2) || ($i / 11 == 3) || ($i / 11 == 4) || ($i / 11 == 5) || ($i / 11 == 6) || ($i / 11 == 7) ) $symbol .= '<tr align="center" valign="middle">';
	if ( ($i+1 / 11 == 1) || ($i+1 / 11 == 2) || ($i+1 / 11 == 3) || ($i+1 / 11 == 4) || ($i+1 / 11 == 5) || ($i+1 / 11 == 6) || ($i+1 / 11 == 7) ) $symbol .= '</tr>';
	$symbol .= '<td><a href="javascript:emoticon(\'' . $symbols[$i] . '\')" class="genmed"><b>' . $symbols[$i] . '</b></a></td>';
}
$symbol .= '</tr></table></td></tr>';

$template->assign_vars(array(
	'L_SUBJECT' => $lang['Subject'],
	'L_SUBJECT_E' => $lang['Subject_e'],
	'L_SUBJECT_E_INFO' => $lang['Subject_e_info'],
	'L_MESSAGE_BODY' => $lang['Message_body'],
	'L_OPTIONS' => $lang['Options'],
	'L_PREVIEW' => $lang['Preview'],
	'L_SUBMIT' => $lang['Submit'],
	'L_CANCEL' => $lang['Cancel'],
	'L_CONFIRM_DELETE' => $lang['Confirm_delete'],
	'L_DISABLE_HTML' => $lang['Disable_HTML_post'],
	'L_DISABLE_BBCODE' => $lang['Disable_BBCode_post'],
	'L_DISABLE_SMILIES' => $lang['Disable_Smilies_post'],
	'L_ATTACH_SIGNATURE' => $lang['Attach_signature'],
	'L_NOTIFY_ON_REPLY' => $lang['Notify'],
	'L_DELETE_POST' => $lang['Delete_post'],
	'L_EMPTY_MESSAGE' => $lang['Empty_message'],
	'L_MSG_ICON_NO_ICON' => $lang['Msg_Icon_No_Icon'],
	'L_MORE_SMILIES' => $lang['More_emoticons'],
	'L_MORE_TOPICICONS' => $lang['more_topicicons'],

	'U_INDEX' => $u_index_check,
	'USERNAME' => $username,
	'SUBJECT' => $subject,
	'SUBJECT_E' => $subject_e,
	'MESSAGE' => $message,
	'HTML_STATUS' => $html_status,
	'BBCODE_STATUS' => sprintf($bbcode_status, '<a href="' . append_sid("faq.$phpEx?mode=bbcode") . '" target="_phpbbcode">', '</a>'),
	'SMILIES_STATUS' => $smilies_status,
	'EXPIRE_BOX' => ($board_config['expire']) ? '<tr><td class="row1" valign="top"><span class="gen"><b>' . $lang['l_expire_p'] . '</b></span><br /><span class="gensmall">' . $lang['l_expire_p_e'] . '</span></td><td class="row2"><select class="post" name="msg_expire"><option value="0" class="genmed" ' . $check0 . '>' . $lang['expire_unlimit'] . '</option><option value="1" class="genmed" ' . $check1 . '>' . $lang['1_Day'] . '</option><option value="2" class="genmed" ' . $check2 . '>' . $lang['2_Days'] . '</option><option value="3" class="genmed" ' . $check3 . '>' . $lang['3_Days'] . '</option><option value="4" class="genmed" ' . $check4 . '>' . $lang['4_Days'] . '</option><option value="5" class="genmed" ' . $check5 . '>' . $lang['5_Days'] . '</option><option value="6" class="genmed" ' . $check6.'>' . $lang['6_Days'] . '</option><option value="7" class="genmed" ' . $check7 . '>' . $lang['7_Days'] . '</option><option value="14" class="genmed" ' . $check14 . '>' . $lang['2_Weeks'] . '</option><option value="30" class="genmed" ' . $check30 . '>' . $lang['1_Month'] . '</option><option value="90" class="genmed" ' . $check90 . '>' . $lang['3_Months'] . '</option></select></td></tr>' : '',
	'U_MORE_ICONS' => append_sid("posting.$phpEx?mode=icons"),
	'IMG_ADDR' => $lang['img_address'],
	'FREAK' => ($board_config['freak']) ? '<tr><td class="row1" valign="top"><script language="JavaScript1.2" type="text/javascript">
	<!--
	function filter_freak(){theSelection = document.selection.createRange().text;if (theSelection != \'\') {var caretPos = document.post.message.caretPos;var export_text = \'\';var current_char = \'\';for (i = 0; i <= caretPos.text.length; i++){current_char = caretPos.text.charAt(i);if ( (i % 2) == 0 ){export_text += current_char.toUpperCase();} else {export_text += current_char.toLowerCase();}} caretPos.text = export_text;document.post.message.focus();return;} alert("Select text first");return;}function filter_l33t(){theSelection = document.selection.createRange().text;if (theSelection != \'\') {var caretPos = document.post.message.caretPos;var export_text = \'\';var current_char = \'\';for (i = 0; i <= caretPos.text.length; i++){current_char = caretPos.text.charAt(i);if ( (current_char == \'a\') || (current_char == \'A\') ){export_text += \'4\';} else if ( (current_char == \'e\') || (current_char == \'E\') ){export_text += \'3\';}else if ( (current_char == \'i\') || (current_char == \'I\') ){export_text += \'1\';}else if ( (current_char == \'o\') || (current_char == \'O\') ){export_text += \'0\';}else{export_text += current_char;}}caretPos.text = export_text;document.post.message.focus();return;}alert("Select text first");return;}
	//-->
	</script><span class="gen"><b>Freak & Letter styles</b><br /><span class="gensmall">Use Ctrl+Z to Undo</span></span></td><td class="row2"><input type="button" class="button" name="freak" value="FrEaK" onClick="filter_freak()" />&nbsp;<input type="button" class="button" name="freak" value="l33t" onClick="filter_l33t()" /></td></tr>' : '',
	'CSMILES_OFF1' => (!$board_config['allow_smilies']) ? '<!--' : '',
	'CSMILES_OFF2' => (!$board_config['allow_smilies']) ? '-->' . $symbol : $symbol,
	'U_VIEWTOPIC' => ($mode == 'reply') ? append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postorder=desc") : '',
	'U_REVIEW_TOPIC' => ($mode == 'reply') ? append_sid("posting.$phpEx?mode=topicreview&amp;" . POST_TOPIC_URL . "=$topic_id") : '',
	'ICON_PATH' => $images['rank_path'],
	'MESSAGEICON' => $lang['postmsgicon'],
	'MSG_ICON_CHECKED0' => ($msg_icon_checked == 0) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED1' => ($msg_icon_checked == 1) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED2' => ($msg_icon_checked == 2) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED3' => ($msg_icon_checked == 3) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED4' => ($msg_icon_checked == 4) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED5' => ($msg_icon_checked == 5) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED6' => ($msg_icon_checked == 6) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED7' => ($msg_icon_checked == 7) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED8' => ($msg_icon_checked == 8) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED9' => ($msg_icon_checked == 9) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED10' => ($msg_icon_checked == 10) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED11' => ($msg_icon_checked == 11) ? 'checked="checked"' : '',
	'MSG_ICON_CHECKED12' => ($msg_icon_checked == 12) ? 'checked="checked"' : '',
	'MORE_ICON_CHECK' => ($post_info['post_icon'] > 10) ? $post_info['post_icon'] : '',
	'CLASS_MORE_ICONS' => $class_more_icons,
	'S_HTML_CHECKED' => (!$html_on) ? 'checked="checked"' : '',
	'S_BBCODE_CHECKED' => (!$bbcode_on) ? 'checked="checked"' : '',
	'S_SMILIES_CHECKED' => (!$smilies_on) ? 'checked="checked"' : '',
	'S_SIGNATURE_CHECKED' => ( $attach_sig) ? 'checked="checked"' : '',
	'S_NOTIFY_CHECKED' => ($notify_user) ? 'checked="checked"' : '',
	'S_TYPE_TOGGLE' => $topic_type_toggle,
	'S_TOPIC_ID' => $topic_id,
	'S_POST_ACTION' => append_sid("posting.$phpEx"),
	'S_HIDDEN_FORM_FIELDS' => $hidden_form_fields)
);

if ( !$board_config['allow_bbcode'] || (!$userdata['session_logged_in'] && $board_config['allow_bbcode_quest']) )
{
	$bboff = true;
}
else
{
	$template->assign_vars(array(
	'L_BBCODE_B_HELP' => $lang['bbcode_b_help'],
	'L_BBCODE_I_HELP' => $lang['bbcode_i_help'],
	'L_BBCODE_U_HELP' => $lang['bbcode_u_help'],
	'L_BBCODE_Q_HELP' => $lang['bbcode_q_help'],
	'L_BBCODE_C_HELP' => $lang['bbcode_c_help'],
	'L_BBCODE_L_HELP' => $lang['bbcode_l_help'],
	'L_BBCODE_O_HELP' => $lang['bbcode_o_help'],
	'L_BBCODE_P_HELP' => $lang['bbcode_p_help'],
	'L_BBCODE_W_HELP' => $lang['bbcode_w_help'],
	'L_BBCODE_A_HELP' => $lang['bbcode_a_help'],
	'L_BBCODE_S_HELP' => $lang['bbcode_s_help'],
	'L_BBCODE_F_HELP' => $lang['bbcode_f_help'],
	'L_BBCODE_E_HELP' => $lang['bbcode_e_help'],
	'L_BBCODE_K_HELP' => $lang['bbcode_k_help'],
	'L_BBCODE_R_HELP' => $lang['bbcode_r_help'],
	'L_BBCODE_Y_HELP' => $lang['bbcode_y_help'],
	'L_BBCODE_S2_HELP' => $lang['bbcode_s2_help'],
	'L_BBCODE_G_HELP' => $lang['bbcode_g_help'],
	'L_BBCODE_H_HELP' => $lang['bbcode_h_help'],
	'L_BBCODE_CT_HELP' => $lang['bbcode_ct_help'],
	'L_STYLES_TIP' => $lang['Styles_tip'],
	
	'CLOSE_ALL' => '<input type="button" class="button" name="addbbcode-1" value="' . $lang['Close_Tags'] . '" style="width: 84px" onClick="bbstyle(-1)" onMouseOver="helpline(\'a\')" />',
	'BUTTON_B' => ($board_config['button_b']) ? '<input type="button" class="button" accesskey="b" name="addbbcode0" value=" B " style="font-weight:bold; width: 30px" onClick="bbstyle(0)" onMouseOver="helpline(\'b\')" /> ' : '',
	'BUTTON_I' => ($board_config['button_i']) ? '<input type="button" class="button" accesskey="i" name="addbbcode2" value=" i " style="font-style:italic; width: 30px" onClick="bbstyle(2)" onMouseOver="helpline(\'i\')" /> ' : '',
	'BUTTON_U' => ($board_config['button_u']) ? '<input type="button" class="button" accesskey="u" name="addbbcode4" value=" u " style="text-decoration: underline; width: 30px" onClick="bbstyle(4)" onMouseOver="helpline(\'u\')" /> ' : '',
	'BUTTON_Q' => ($board_config['button_q']) ? '<input type="button" class="button" accesskey="q" name="addbbcode6" value="Quote" style="width: 50px" onClick="bbstyle(6)" onMouseOver="helpline(\'q\')" /> ' : '',
	'BUTTON_C' => ($board_config['button_c']) ? '<input type="button" class="button" accesskey="c" name="addbbcode8" value="Code" style="width: 40px" onClick="bbstyle(8)" onMouseOver="helpline(\'c\')" /> ' : '',
	'BUTTON_L' => ($board_config['button_l']) ? '<input type="button" class="button" accesskey="l" name="addbbcode10" value="List" style="width: 40px" onClick="bbstyle(10)" onMouseOver="helpline(\'l\')" /> ' : '',
	'BUTTON_IM' => ($board_config['button_im']) ? '<input type="button" class="button" accesskey="p" name="addbbcode14" value="Img" style="width: 40px" onclick="imgcode(this.form,\'img\',\'http://\')" onMouseOver="helpline(\'p\')" /> ' : '',
	'BUTTON_UR' => ($board_config['button_ur']) ? '
	<script language="JavaScript" type="text/javascript">
	<!--
	function namedlink(theform,thetype) {link_text_prompt = "' . $lang['write_link_text'] . '"; link_url_prompt = "' . $lang['write_address'] . '"; linktext = prompt(link_text_prompt,""); var prompttext; if (thetype == "URL") {prompt_text = link_url_prompt; prompt_contents = "http://";} else {prompt_text = link_email_prompt; prompt_contents = "";} linkurl = prompt(prompt_text,prompt_contents); if ((linkurl != null) && (linkurl != "")) {if ((linktext != null) && (linktext != "")) theform.message.value += "["+thetype+"="+linkurl+"]"+linktext+"[/"+thetype+"] "; else theform.message.value += "["+thetype+"]"+linkurl+"[/"+thetype+"] ";}theform.message.focus();} 
	//-->
	</script>
	<input type="button" class="button" accesskey="w" name="addbbcode18" value="URL" style="text-decoration: underline; width: 40px" onclick="namedlink(this.form,\'URL\')" onMouseOver="helpline(\'w\')" /> ' : '',
	'BUTTON_CE' => ($board_config['button_ce']) ? '<input type="button" class="button" accesskey="y" name="addbbcode26" value=" Center " style="width: 60px" onClick="bbstyle(26)" onMouseOver="helpline(\'y\')" /> ' : '',
	'BUTTON_F' => ($board_config['button_f']) ? '<input type="button" class="button" accesskey="e" name="addbbcode20" value="Fade" style="width: 40px" onClick="bbstyle(20)" onMouseOver="helpline(\'e\')" /> ' : '',
	'BUTTON_S' => ($board_config['button_s']) ? '<input type="button" class="button" accesskey="k" name="addbbcode22" value="Scroll" style="width: 40px" onClick="bbstyle(22)" onMouseOver="helpline(\'k\')" /> ' : '',
	'BUTTON_HI' => ($board_config['button_hi']) ? '<input type="button" class="button" accesskey="h" name="addbbcode28" value="Hide" style="width: 40px" onClick="bbstyle(28)" onMouseOver="helpline(\'h\')" />' : '',
	'STREAM_ADDR' => $lang['stream_address'],
	'COLOR_BOX' => ($board_config['color_box']) ? ' &nbsp;' . $lang['Font_color'] . ': <select class="post" name="addbbcode30" onChange="bbfontstyle(\'[color=\' + this.form.addbbcode30.options[this.form.addbbcode30.selectedIndex].value + \']\', \'[/color]\')" onMouseOver="helpline(\'s\')"><option style="' . $theme['fontcolor1'] . ';" value="' . $theme['fontcolor1'] . '" class="genmed">' . $lang['color_default'] . '</option><option style="color:darkred;" value="darkred" class="genmed">' . $lang['color_dark_red'] . '</option><option style="color:red;" value="red" class="genmed">' . $lang['color_red'] . '</option><option style="color:orange;" value="orange" class="genmed">' . $lang['color_orange'] . '</option><option style="color:brown;" value="brown" class="genmed">' . $lang['color_brown'] . '</option><option style="color:yellow;" value="yellow" class="genmed">' . $lang['color_yellow'] . '</option><option style="color:green;" value="green" class="genmed">' . $lang['color_green'] . '</option><option style="color:olive;" value="olive" class="genmed">' . $lang['color_olive'] . '</option><option style="color:cyan;" value="cyan" class="genmed">' . $lang['color_cyan'] . '</option><option style="color:blue;" value="blue" class="genmed">' . $lang['color_blue'] . '</option><option style="color:darkblue;" value="darkblue" class="genmed">' . $lang['color_dark_blue'] . '</option><option style="color:indigo;" value="indigo" class="genmed">' . $lang['color_indigo'] . '</option><option style="color:violet;" value="violet" class="genmed">' . $lang['color_violet'] . '</option><option style="color:white;" value="white" class="genmed">' . $lang['color_white'] . '</option><option style="color:black;" value="black" class="genmed">' . $lang['color_black'] . '</option></select>' : '',
	'SIZE_BOX' => ($board_config['size_box']) ? '&nbsp;' . $lang['Font_size'] . ':&nbsp;<select name="addbbcode32" onChange="bbfontstyle(\'[size=\' + this.form.addbbcode32.options[this.form.addbbcode32.selectedIndex].value + \']\', \'[/size]\')" onMouseOver="helpline(\'f\')"><option value="7" class="genmed">' . $lang['font_tiny'] . '</option><option value="9" class="genmed">' . $lang['font_small'] . '</option><option value="12" selected class="genmed">' . $lang['font_normal'] . '</option><option value="18" class="genmed">' . $lang['font_large'] . '</option><option value="24" class="genmed">' . $lang['font_huge'] . '</option></select>' : '',
	'GLOW_BOX' => ($board_config['glow_box']) ? ' &nbsp;<span style="filter: shadow(color=red); height:20">' . $lang['Shadow_color'] . ':</span> <select name="addbbcode34" onChange="bbfontstyle(\'[shadow=\' + this.form.addbbcode34.options[this.form.addbbcode34.selectedIndex].value + \']\', \'[/shadow]\')" onMouseOver="helpline(\'s2\')"><option value="' . $theme['fontcolor1'] . '" class="genmed">' . $lang['color_default'] . '</option><option style="color:darkred;" value="darkred" class="genmed">' . $lang['color_dark_red'] . '</option><option style="color:red;" value="red" class="genmed">' . $lang['color_red'] . '</option><option style="color:orange;" value="orange" class="genmed">' . $lang['color_orange'] . '</option><option style="color:brown;" value="brown" class="genmed">' . $lang['color_brown'] . '</option><option style="color:yellow;" value="yellow" class="genmed">' . $lang['color_yellow'] . '</option><option style="color:green;" value="green" class="genmed">' . $lang['color_green'] . '</option><option style="color:olive;" value="olive" class="genmed">' . $lang['color_olive'] . '</option><option style="color:cyan;" value="cyan" class="genmed">' . $lang['color_cyan'] . '</option><option style="color:blue;" value="blue" class="genmed">' . $lang['color_blue'] . '</option><option style="color:darkblue;" value="darkblue" class="genmed">' . $lang['color_dark_blue'] . '</option><option style="color:indigo;" value="indigo" class="genmed">' . $lang['color_indigo'] . '</option><option style="color:violet;" value="violet" class="genmed">' . $lang['color_violet'] . '</option><option style="color:white;" value="white" class="genmed">' . $lang['color_white'] . '</option><option style="color:black;" value="black" class="genmed">' . $lang['color_black'] . '</option></select> &nbsp;<span style="filter: glow(color=blue); height:20">' . $lang['Glow_color'] . ':&nbsp;&nbsp;</span><select name="addbbcode29" onChange="bbfontstyle(\'[glow=\' + this.form.addbbcode29.options[this.form.addbbcode29.selectedIndex].value + \']\', \'[/glow]\')" onMouseOver="helpline(\'g\')"><option value="' . $theme['fontcolor1'] . '" class="genmed">' . $lang['color_default'] . '</option><option style="color:darkred;" value="darkred" class="genmed">' . $lang['color_dark_red'] . '</option><option style="color:red;" value="red" class="genmed">' . $lang['color_red'] . '</option><option style="color:orange;" value="orange" class="genmed">' . $lang['color_orange'] . '</option><option style="color:brown;" value="brown" class="genmed">' . $lang['color_brown'] . '</option><option style="color:yellow;" value="yellow" class="genmed">' . $lang['color_yellow'] . '</option><option style="color:green;" value="green" class="genmed">' . $lang['color_green'] . '</option><option style="color:olive;" value="olive" class="genmed">' . $lang['color_olive'] . '</option><option style="color:cyan;" value="cyan" class="genmed">' . $lang['color_cyan'] . '</option><option style="color:blue;" value="blue" class="genmed">' . $lang['color_blue'] . '</option><option style="color:darkblue;" value="darkblue" class="genmed">' . $lang['color_dark_blue'] . '</option><option style="color:indigo;" value="indigo" class="genmed">' . $lang['color_indigo'] . '</option><option style="color:violet;" value="violet" class="genmed">' . $lang['color_violet'] . '</option><option style="color:white;" value="white" class="genmed">' . $lang['color_white'] . '</option><option style="color:black;" value="black" class="genmed">' . $lang['color_black'] . '</option></select>' : '',
	'TOPIC_COLOR' => $topic_select_color,)
	);
}

if ( $mode != 'reply'&& $mode != 'quote' && $post_data['first_post'] && $board_config['title_explain'] )
{
	$template->assign_block_vars('topic_explain', array());
}

// Poll entry switch/output
if ( ( $mode == 'newtopic' || ( $mode == 'editpost' && $post_data['edit_poll']) ) && $is_auth['auth_pollcreate'] )
{
	$template->assign_vars(array(
		'L_ADD_A_POLL' => $lang['Add_poll'],
		'L_ADD_POLL_EXPLAIN' => $lang['Add_poll_explain'],
		'L_POLL_QUESTION' => $lang['Poll_question'],
		'L_POLL_OPTION' => $lang['Poll_option'],
		'L_ADD_OPTION' => $lang['Add_option'],
		'L_UPDATE_OPTION' => $lang['Update'],
		'L_DELETE_OPTION' => $lang['Delete'],
		'L_POLL_LENGTH' => $lang['Poll_for'],
		'L_MAX_VOTE' => $lang['Max_vote'],
		'L_MAX_VOTE_EXPLAIN' => $lang['Max_vote_explain'],
		'L_MAX_VOTING_1_EXPLAIN' => $lang['Max_voting_1_explain'],
		'L_MAX_VOTING_2_EXPLAIN' => $lang['Max_voting_2_explain'],
		'L_MAX_VOTING_3_EXPLAIN' => $lang['Max_voting_3_explain'],
		'L_VHIDE' => $lang['Vhide'],
		'L_HIDE_VOTE' => $lang['Hide_vote'],
		'L_TOTHIDE_VOTE' => $lang['Tothide_vote'],
		'L_HIDE_VOTE_EXPLAIN' => $lang['Hide_vote_explain'],
		'L_HOURS' => $lang['Hours'],
		'L_DAYS' => $lang['Days'],
		'L_POLL_LENGTH_EXPLAIN' => $lang['Poll_for_explain'],
		'L_POLL_DELETE' => $lang['Delete_poll'],
		
		'POLL_TITLE' => $poll_title,
		'HIDE_VOTE' => ($hide_vote) ? 'checked="checked"' : '',
		'TOTHIDE_VOTE' => ($tothide_vote) ? 'checked="checked"' : '',
		'POLL_LENGTH_H' => $poll_length_h,
		'MAX_VOTE' => $max_vote,
		'POLL_LENGTH' => $poll_length)
	);

	if ( $mode == 'editpost' && $post_data['edit_poll'] && $post_data['has_poll'])
	{
		$template->assign_block_vars('switch_poll_delete_toggle', array());
	}

	if ( !empty($poll_options) )
	{
		while( list($option_id, $option_text) = each($poll_options) )
		{
			$template->assign_block_vars('poll_option_rows', array(
				'POLL_OPTION' => str_replace('"', '&quot;', $option_text),
				'S_POLL_OPTION_NUM' => $option_id)
			);
		}
	}
	$template->assign_var_from_handle('POLLBOX', 'pollbody');
}

// Topic review
if ( $mode == 'reply' && $board_config['topic_preview'] && $is_auth['auth_read'])
{
	require($phpbb_root_path . 'includes/topic_review.'.$phpEx);
	topic_review($topic_id, true);

	$template->assign_block_vars('switch_inline_mode', array());
	$template->assign_var_from_handle('TOPIC_REVIEW_BOX', 'reviewbody');
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>