#
# Table structure for table 'phpbb_album'
#
CREATE TABLE phpbb_album (
   pic_id int(11) UNSIGNED NOT NULL auto_increment,
   pic_filename varchar(255) NOT NULL,
   pic_thumbnail varchar(255),
   pic_title varchar(255) NOT NULL,
   pic_desc text,
   pic_user_id mediumint(8) NOT NULL,
   pic_username varchar(32),
   pic_user_ip char(8) NOT NULL DEFAULT '0',
   pic_time int(11) UNSIGNED NOT NULL,
   pic_cat_id mediumint(8) UNSIGNED NOT NULL DEFAULT '1',
   pic_view_count int(11) UNSIGNED NOT NULL DEFAULT '0',
   pic_lock tinyint(3) NOT NULL DEFAULT '0',
   pic_approval tinyint(3) NOT NULL DEFAULT '1',
   PRIMARY KEY (pic_id),
   KEY pic_cat_id (pic_cat_id),
   KEY pic_user_id (pic_user_id),
   KEY pic_time (pic_time));

#
# Table structure for table 'phpbb_album_rate'
#
CREATE TABLE phpbb_album_rate (
   rate_pic_id int(11) UNSIGNED NOT NULL,
   rate_user_id mediumint(8) NOT NULL,
   rate_user_ip char(8) NOT NULL,
   rate_point tinyint(3) UNSIGNED NOT NULL,
   KEY rate_pic_id (rate_pic_id),
   KEY rate_user_id (rate_user_id),
   KEY rate_user_ip (rate_user_ip),
   KEY rate_point (rate_point)
);

#
# Table structure for table 'phpbb_album_comment'
#
CREATE TABLE phpbb_album_comment (
   comment_id int(11) UNSIGNED NOT NULL auto_increment,
   comment_pic_id int(11) UNSIGNED NOT NULL,
   comment_user_id mediumint(8) NOT NULL,
   comment_username varchar(32),
   comment_user_ip char(8) NOT NULL,
   comment_time int(11) UNSIGNED NOT NULL,
   comment_text TEXT,
   comment_edit_time int(11) UNSIGNED,
   comment_edit_count smallint(5) UNSIGNED NOT NULL DEFAULT '0',
   comment_edit_user_id mediumint(8),
   PRIMARY KEY(comment_id),
   KEY comment_pic_id (comment_pic_id),
   KEY comment_user_id (comment_user_id),
   KEY comment_user_ip (comment_user_ip),
   KEY comment_time (comment_time)
);

#
# Table structure for table 'phpbb_album_cat'
#
CREATE TABLE phpbb_album_cat (
   cat_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   cat_parent mediumint unsigned not null default '0',
   cat_type tinyint not null default '0',
   cat_title varchar(255) NOT NULL,
   cat_desc text,
   cat_order mediumint(8) NOT NULL,
   cat_view_level tinyint(3) NOT NULL DEFAULT '-1',
   cat_upload_level tinyint(3) NOT NULL DEFAULT '0',
   cat_rate_level tinyint(3) NOT NULL DEFAULT '0',
   cat_comment_level tinyint(3) NOT NULL DEFAULT '0',
   cat_edit_level tinyint(3) NOT NULL DEFAULT '0',
   cat_delete_level tinyint(3) NOT NULL DEFAULT '2',
   cat_view_groups varchar(255),
   cat_upload_groups varchar(255),
   cat_rate_groups varchar(255),
   cat_comment_groups varchar(255),
   cat_edit_groups varchar(255),
   cat_delete_groups varchar(255),
   cat_moderator_groups varchar(255),
   cat_approval tinyint(3) NOT NULL DEFAULT '0',
   PRIMARY KEY (cat_id),
   KEY cat_order (cat_order)
);

#
# Table structure for table 'phpbb_album_config'
#
CREATE TABLE phpbb_album_config (
   config_name varchar(255) NOT NULL,
   config_value varchar(255) NOT NULL,
   PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_attachments'
#
CREATE TABLE phpbb_attachments (
  attach_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
  post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
  privmsgs_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  user_id_1 mediumint(8) NOT NULL,
  user_id_2 mediumint(8) NOT NULL,
  KEY attach_id_post_id (attach_id, post_id),
  KEY attach_id_privmsgs_id (attach_id, privmsgs_id)
); 

#
# Table structure for table 'phpbb_attachments_config'
#
CREATE TABLE phpbb_attachments_config (
  config_name varchar(255) NOT NULL,
  config_value varchar(255) NOT NULL,
  PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_attachments_desc'
#
CREATE TABLE phpbb_attachments_desc (
  attach_id mediumint(8) UNSIGNED NOT NULL auto_increment,
  physical_filename varchar(255) NOT NULL,
  real_filename varchar(255) NOT NULL,
  download_count mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  comment varchar(255),
  extension varchar(100),
  mimetype varchar(100),
  filesize int(20) NOT NULL,
  filetime int(11) DEFAULT '0' NOT NULL,
  thumbnail tinyint(1) DEFAULT '0' NOT NULL,
  PRIMARY KEY (attach_id),
  KEY filetime (filetime),
  KEY physical_filename (physical_filename(10)),
  KEY filesize (filesize)
);

#
# Table structure for table 'phpbb_anti_robotic_reg'
#
CREATE TABLE phpbb_anti_robotic_reg (
	session_id char(32) DEFAULT '' NOT NULL,
	reg_key char(4) NOT NULL,
	timestamp int(10) unsigned NOT NULL,
	PRIMARY KEY (session_id)
);

#
# Table structure for table 'phpbb_attach_quota'
#
CREATE TABLE phpbb_attach_quota (
  user_id mediumint(8) unsigned NOT NULL default '0',
  group_id mediumint(8) unsigned NOT NULL default '0',
  quota_type smallint(2) NOT NULL default '0',
  quota_limit_id mediumint(8) unsigned NOT NULL default '0',
  KEY quota_type (quota_type)
);

#
# Table structure for table 'phpbb_chatbox'
#
CREATE TABLE phpbb_chatbox (
  id int(11) NOT NULL auto_increment,
  name varchar(99) NOT NULL,
  msg varchar(255) NOT NULL,
  timestamp int(10) unsigned NOT NULL,
  PRIMARY KEY (id)
);

#
# Table structure for table 'phpbb_chatbox_session'
#
CREATE TABLE phpbb_chatbox_session (
  username varchar(99) NOT NULL,
  lastactive int(10) DEFAULT '0' NOT NULL,
  laststatus varchar(8) NOT NULL,
  UNIQUE username (username)
);

#
# Table structure for table 'phpbb_extensions'
#
CREATE TABLE phpbb_extensions (
  ext_id mediumint(8) UNSIGNED NOT NULL auto_increment,
  group_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  extension varchar(100) NOT NULL,
  comment varchar(100),
  PRIMARY KEY ext_id (ext_id)
);

#
# Table structure for table 'phpbb_extension_groups'
#
CREATE TABLE phpbb_extension_groups (
  group_id mediumint(8) NOT NULL auto_increment,
  group_name char(20) NOT NULL,
  cat_id tinyint(2) DEFAULT '0' NOT NULL, 
  allow_group tinyint(1) DEFAULT '0' NOT NULL,
  download_mode tinyint(1) UNSIGNED DEFAULT '1' NOT NULL,
  upload_icon varchar(100) DEFAULT '',
  max_filesize int(20) DEFAULT '0' NOT NULL,
  forum_permissions varchar(255) default '' NOT NULL,
  PRIMARY KEY group_id (group_id)
);

#
# Table structure for table 'phpbb_forbidden_extensions'
#
CREATE TABLE phpbb_forbidden_extensions (
  ext_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
  extension varchar(100) NOT NULL, 
  PRIMARY KEY (ext_id)
);

#
# Table structure for table 'phpbb_ignore'
#
CREATE TABLE phpbb_ignores (
  user_id mediumint(8) NOT NULL default '0',
  user_ignore mediumint(8) NOT NULL default '0'
);

#
# Table structure for table 'phpbb_logs'
#
CREATE TABLE phpbb_logs (
  id_log MEDIUMINT(10) NOT NULL AUTO_INCREMENT,
  mode VARCHAR(50) NULL DEFAULT '', 
  topic_id MEDIUMINT(10) NULL DEFAULT '0',
  user_id MEDIUMINT(8) NULL DEFAULT '0',
  username VARCHAR(255) NULL DEFAULT '',
  user_ip CHAR(8) DEFAULT '0' NOT NULL,
  time INT(11) NULL DEFAULT '0',
  PRIMARY KEY (id_log)
);

#
# Table structure for table 'phpbb_pa_cat'
#
CREATE TABLE phpbb_pa_cat (
  cat_id int(10) NOT NULL auto_increment,
  cat_name text,
  cat_desc text,
  cat_files int(10) default NULL,
  cat_1xid int(10) default NULL,
  cat_parent int(50) default NULL,
  cat_order int(50) default NULL,
  PRIMARY KEY  (cat_id)
);


#
# Table structure for table `phpbb_pa_comments`
#

CREATE TABLE phpbb_pa_comments (
  comments_id int(10) NOT NULL auto_increment,
  file_id int(10) NOT NULL default '0',
  comments_text text NOT NULL,
  comments_title text NOT NULL,
  comments_time int(50) NOT NULL default '0',
  comment_bbcode_uid varchar(10) default NULL,
  poster_id mediumint(8) NOT NULL default '0',
  PRIMARY KEY  (comments_id),
  KEY comments_id (comments_id),
  KEY comment_bbcode_uid (comment_bbcode_uid)
);


#
# Table structure for table `phpbb_pa_custom`
#

CREATE TABLE phpbb_pa_custom (
  custom_id int(50) NOT NULL auto_increment,
  custom_name text NOT NULL,
  custom_description text NOT NULL,
  PRIMARY KEY  (custom_id)
);


#
# Table structure for table `phpbb_pa_customdata`
#

CREATE TABLE phpbb_pa_customdata (
  customdata_file int(50) NOT NULL default '0',
  customdata_custom int(50) NOT NULL default '0',
  data text NOT NULL
);


#
# Table structure for table `phpbb_pa_files`
#

CREATE TABLE phpbb_pa_files (
  file_id int(10) NOT NULL auto_increment,
  file_name text,
  file_desc text,
  file_creator text,
  file_version text,
  file_longdesc text,
  file_ssurl text,
  file_dlurl text,
  file_time int(50) default NULL,
  file_catid int(10) default NULL,
  file_posticon text,
  file_license int(10) default NULL,
  file_dls int(10) default NULL,
  file_last int(50) default NULL,
  file_pin int(2) default NULL,
  file_docsurl text,
  file_rating double(6,4) NOT NULL default '0.0000',
  file_totalvotes int(255) NOT NULL default '0',
  PRIMARY KEY  (file_id)
);


#
# Table structure for table `phpbb_pa_license`
#

CREATE TABLE phpbb_pa_license (
  license_id int(10) NOT NULL auto_increment,
  license_name text,
  license_text text,
  PRIMARY KEY  (license_id)
);


#
# Table structure for table `phpbb_pa_settings`
#

CREATE TABLE phpbb_pa_settings (
  settings_id int(1) NOT NULL default '1',
  settings_dbname text NOT NULL,
  settings_sitename text NOT NULL,
  settings_dbdescription text NOT NULL,
  settings_dburl text NOT NULL,
  settings_topnumber int(5) NOT NULL default '0',
  settings_homeurl text NOT NULL,
  settings_newdays int(5) NOT NULL default '0',
  settings_stats int(5) NOT NULL default '0',
  settings_viewall int(5) NOT NULL default '0',
  settings_showss int(5) NOT NULL default '0',
  settings_disable int(5) NOT NULL default '0',
  allow_html int(5) NOT NULL default '0',
  allow_bbcode int(5) NOT NULL default '0',
  allow_smilies int(5) NOT NULL default '0',
  allow_comment_links int(5) NOT NULL default '0',
  no_comment_link_message varchar(255) NOT NULL default '',
  allow_comment_images int(5) NOT NULL default '0',
  no_comment_image_message varchar(255) NOT NULL default '',
  max_comment_chars int(255) NOT NULL default '0',
  directly_linked int(5) NOT NULL default '0'
);

#
# Table structure for table `phpbb_pa_votes`
#

CREATE TABLE phpbb_pa_votes (
  votes_ip varchar(50) NOT NULL default '0',
  votes_file int(50) NOT NULL default '0'
);


#
# Table structure for table 'phpbb_portal_config'
#
CREATE TABLE phpbb_portal_config (
    config_name varchar(255) NOT NULL,
    config_value text NOT NULL,
    PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_quota_limits'
#
CREATE TABLE phpbb_quota_limits (
  quota_limit_id mediumint(8) unsigned NOT NULL auto_increment,
  quota_desc varchar(20) NOT NULL default '',
  quota_limit bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (quota_limit_id)
);

#
# Table structure for table 'phpbb_read_history'
#
CREATE TABLE phpbb_read_history (
  user_id mediumint(8) NOT NULL default '0',
  forum_id smallint(5) unsigned NOT NULL default '0',
  topic_id mediumint(8) unsigned NOT NULL default '0',
  post_id mediumint(8) unsigned NOT NULL default '0',
  post_time int(11) NOT NULL default '0',
  PRIMARY KEY (user_id, forum_id, topic_id, post_id, post_time),
  KEY user_id (user_id),
  KEY forum_id (forum_id),
  KEY topic_id (topic_id)
);

#
# Table structure for table 'phpbb_stats_config'
#
CREATE TABLE phpbb_stats_config (
  config_name varchar(50) NOT NULL default '',
  config_value varchar(255) NOT NULL default '',
  PRIMARY KEY (config_name)
);

#
# Table structure for table 'phpbb_stats_modules'
#
CREATE TABLE phpbb_stats_modules (
  module_id tinyint(8) NOT NULL default '0',
  name varchar(150) NOT NULL default '',
  active tinyint(1) NOT NULL default '0',
  installed tinyint(1) NOT NULL default '0',
  display_order mediumint(8) unsigned NOT NULL default '0',
  update_time mediumint(8) unsigned NOT NULL default '0',
  auth_value tinyint(2) NOT NULL default '0',
  module_info_cache blob,
  module_db_cache blob,
  module_result_cache blob,
  module_info_time int(10) unsigned NOT NULL default '0',
  module_cache_time int(10) unsigned NOT NULL default '0',
  PRIMARY KEY (module_id)
);

#
# Table structure for table 'phpbb_topic_view'
#
CREATE TABLE phpbb_topic_view ( 
  topic_id mediumint(8) NOT NULL, 
  user_id mediumint(8) NOT NULL, 
  view_time int(11) NOT NULL, 
  view_count int(11) NOT NULL
);

#
# Table structure for table 'phpbb_shoutbox'
#
CREATE TABLE phpbb_shoutbox (
  id int(11) NOT NULL auto_increment,
  sb_user_id int(11) NOT NULL,
  msg text NOT NULL,
  timestamp int(10) unsigned NOT NULL,
  PRIMARY KEY (id)
);

#
# Table structure for table 'phpbb_shoutbox_config'
#
CREATE TABLE phpbb_shoutbox_config ( 
    config_name varchar(255) NOT NULL, 
    config_value varchar(255) NOT NULL, 
    PRIMARY KEY (config_name)
);


CREATE TABLE phpbb_topics_ignore (
  topic_id mediumint(8) UNSIGNED NOT NULL auto_increment,
  user_id mediumint(8) DEFAULT '0' NOT NULL,
  PRIMARY KEY (topic_id, user_id)
);

#
# Table structure for table 'phpbb_birthday'
#
CREATE TABLE phpbb_birthday ( 
    user_id varchar(9) NOT NULL, 
    send_user_id varchar(9) NOT NULL, 
    send_year int(11) NOT NULL, 
    PRIMARY KEY (user_id, send_user_id, send_year)
);

#
# Table structure for table 'phpbb_jr_admin_users'
#
CREATE TABLE phpbb_jr_admin_users (
  user_id mediumint(9) NOT NULL default '0',
  user_jr_admin longtext NOT NULL,
  start_date int(10) unsigned NOT NULL default '0',
  update_date int(10) unsigned NOT NULL default '0',
  admin_notes text NOT NULL,
  notes_view tinyint(1) NOT NULL default '0',
  PRIMARY KEY (user_id)
);

#
# Table structure for table 'phpbb_users_warnings'
#
CREATE TABLE phpbb_users_warnings (
  id mediumint(8) unsigned NOT NULL auto_increment,
  userid mediumint(8) NOT NULL default '0',
  modid mediumint(8) NOT NULL default '0',
  date int(11) NOT NULL default '0',
  value mediumint(8) NOT NULL default '0',
  reason text,
  archive tinyint(1) DEFAULT '0' NOT NULL,
  PRIMARY KEY (id)
);

ALTER TABLE phpbb_auth_access ADD auth_download TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_auth_access ADD auth_globalannounce TINYINT (1) not null AFTER auth_announce;

ALTER TABLE phpbb_banlist ADD ban_time int(11) default NULL;
ALTER TABLE phpbb_banlist ADD ban_expire_time int(11) default NULL;
ALTER TABLE phpbb_banlist ADD ban_by_userid mediumint(8) default NULL;
ALTER TABLE phpbb_banlist ADD ban_by TEXT;
ALTER TABLE phpbb_banlist ADD ban_priv_reason text;
ALTER TABLE phpbb_banlist ADD ban_pub_reason_mode tinyint(1) default NULL;
ALTER TABLE phpbb_banlist ADD ban_pub_reason text;
ALTER TABLE phpbb_banlist ADD ban_reason TEXT;

ALTER TABLE phpbb_categories ADD cat_main_type CHAR(1);
ALTER TABLE phpbb_categories ADD cat_main MEDIUMINT(8) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_categories ADD cat_desc TEXT NOT NULL;

ALTER TABLE phpbb_disallow CHANGE disallow_username disallow_username VARCHAR(25) DEFAULT '' NOT NULL;

ALTER TABLE phpbb_forums ADD auth_download TINYINT(2) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_forums ADD password varchar(20) NOT NULL DEFAULT '';
ALTER TABLE phpbb_forums ADD auth_globalannounce TINYINT (2) DEFAULT '3' NOT NULL AFTER auth_announce;
ALTER TABLE phpbb_forums ADD forum_sort TEXT NOT NULL;
ALTER TABLE phpbb_forums ADD forum_color varchar(20) NOT NULL DEFAULT '';
ALTER TABLE phpbb_forums ADD forum_link VARCHAR(255);
ALTER TABLE phpbb_forums ADD forum_link_internal TINYINT(1) NOT NULL;
ALTER TABLE phpbb_forums ADD forum_link_hit_count TINYINT(1) NOT NULL;
ALTER TABLE phpbb_forums ADD forum_link_hit BIGINT(20) UNSIGNED NOT NULL;
ALTER TABLE phpbb_forums ADD main_type CHAR(1);
ALTER TABLE phpbb_forums ADD forum_moderate TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_forums ADD no_count TINYINT(1) DEFAULT '0' NOT NULL;

ALTER TABLE phpbb_groups ADD group_order MEDIUMINT(8) default '0' NOT NULL;
ALTER TABLE phpbb_groups ADD group_count INT (4) UNSIGNED DEFAULT '99999999';
ALTER TABLE phpbb_groups ADD group_count_enable SMALLINT (2) UNSIGNED DEFAULT '0';

ALTER TABLE phpbb_posts ADD post_attachment TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_posts ADD user_agent TEXT;
ALTER TABLE phpbb_posts ADD post_icon TINYINT(2) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_posts ADD post_expire INT(255) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_posts ADD reporter_id MEDIUMINT(8) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_posts ADD INDEX (reporter_id);
ALTER TABLE phpbb_posts ADD post_marked enum('n','y') NULL;
ALTER TABLE phpbb_posts ADD post_approve tinyint(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_posts ADD poster_delete tinyint(1) DEFAULT '0';

ALTER TABLE phpbb_forum_prune MODIFY COLUMN forum_id smallint(5) UNSIGNED NOT NULL;
ALTER TABLE phpbb_forum_prune MODIFY COLUMN prune_days smallint(5) UNSIGNED NOT NULL;
ALTER TABLE phpbb_forum_prune MODIFY COLUMN prune_freq smallint(5) UNSIGNED NOT NULL;

ALTER TABLE phpbb_privmsgs ADD privmsgs_attachment TINYINT(1) DEFAULT '0' NOT NULL;

ALTER TABLE phpbb_ranks ADD rank_group MEDIUMINT(8) NOT NULL;

ALTER TABLE phpbb_topics ADD topic_attachment TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_topics ADD topic_icon TINYINT (2) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_topics ADD topic_expire INT(255) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_topics ADD topic_color varchar(25) DEFAULT NULL;
ALTER TABLE phpbb_topics ADD topic_title_e char(100) DEFAULT NULL;

ALTER TABLE phpbb_users ADD user_posts_per_page VARCHAR (5) DEFAULT '15';
ALTER TABLE phpbb_users ADD user_topics_per_page VARCHAR (5) DEFAULT '15';
ALTER TABLE phpbb_users ADD user_hot_threshold VARCHAR (5) DEFAULT '35';
ALTER TABLE phpbb_users ADD user_birthday INT DEFAULT '999999' not null;
ALTER TABLE phpbb_users ADD user_next_birthday_greeting INT DEFAULT '0' not null;
ALTER TABLE phpbb_users ADD user_custom_rank VARCHAR(255);
ALTER TABLE phpbb_users ADD user_photo VARCHAR(100);
ALTER TABLE phpbb_users ADD user_photo_type TINYINT(4) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD user_custom_color VARCHAR(6);
ALTER TABLE phpbb_users ADD user_showavatars tinyint(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD page_avatar tinyint(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD user_traffic INT(255) DEFAULT '999999' NOT NULL;
ALTER TABLE phpbb_users ADD user_allowsig TINYINT(1) DEFAULT '1' NOT NULL AFTER user_allowavatar;
ALTER TABLE phpbb_users ADD user_badlogin SMALLINT(5) NOT NULL;
ALTER TABLE phpbb_users ADD user_blocktime INT(11) NOT NULL;
ALTER TABLE phpbb_users ADD user_block_by VARCHAR (8);
ALTER TABLE phpbb_users ADD disallow_forums VARCHAR (99);
ALTER TABLE phpbb_users ADD can_custom_ranks TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD can_custom_color TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_sig_image varchar(100) NOT NULL DEFAULT '' AFTER user_sig_bbcode_uid;
ALTER TABLE phpbb_users ADD user_allow_signature tinyint(1) UNSIGNED NOT NULL DEFAULT '1' AFTER user_sig_image;
ALTER TABLE phpbb_users ADD user_allow_sig_image tinyint(1) UNSIGNED NOT NULL DEFAULT '1' AFTER user_allow_signature;
ALTER TABLE phpbb_users ADD user_gender TINYINT not null DEFAULT '0';
ALTER TABLE phpbb_users ADD user_sub_forum TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_split_cat TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD user_last_topic_title TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_sub_level_links TINYINT(1) DEFAULT '2' NOT NULL;
ALTER TABLE phpbb_users ADD user_display_viewonline TINYINT(1) DEFAULT '2' NOT NULL;
ALTER TABLE phpbb_users ADD view_ignore_topics tinyint(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD can_topic_color TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_notify_gg tinyint(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD allowpm tinyint(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD no_report_popup TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD refresh_report_popup TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD no_report_mail TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD user_avatar_width SMALLINT;
ALTER TABLE phpbb_users ADD user_avatar_height SMALLINT;
ALTER TABLE phpbb_users ADD special_rank mediumint(8) UNSIGNED NULL;
ALTER TABLE phpbb_users ADD user_allow_helped tinyint(1) UNSIGNED NOT NULL DEFAULT '1';
ALTER TABLE phpbb_users ADD user_ip CHAR(8) DEFAULT '';
ALTER TABLE phpbb_users MODIFY COLUMN user_timezone decimal(5,2) DEFAULT '0' NOT NULL;

ALTER TABLE phpbb_vote_desc ADD vote_max INT(3) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_vote_desc ADD vote_voted INT(7) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_vote_desc ADD vote_hide TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_vote_desc ADD vote_tothide TINYINT(1) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_vote_voters ADD vote_cast TINYINT(4) UNSIGNED DEFAULT '0' NOT NULL;

ALTER TABLE phpbb_config CHANGE config_value config_value TEXT NOT NULL;

ALTER TABLE phpbb_words CHANGE replacement replacement TEXT NOT NULL;


INSERT INTO phpbb_album VALUES (6, 'af8a9f4b3bc6ef0c9174b2b46051f5a7.jpg', 'af8a9f4b3bc6ef0c9174b2b46051f5a7.jpg', 'Zdjecie 4', 'opis zdjecia opis zdjecia opis zdjecia opis zdjecia', 2, 'Przemo', '7f000001', 1055091404, 1, 5, 0, 1);
INSERT INTO phpbb_album VALUES (3, '324c3dcd885b202cbe12358ab21e3073.jpg', '324c3dcd885b202cbe12358ab21e3073.jpg', 'Zdjecie 2', '', 2, 'Przemo', '7f000001', 1055091316, 1, 0, 0, 1);
INSERT INTO phpbb_album VALUES (5, '66738c6936cc0a48670409a2a85dcf7a.jpg', '66738c6936cc0a48670409a2a85dcf7a.jpg', 'Las', 'LasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLasLas', 2, 'Przemo', '7f000001', 1055091390, 1, 0, 0, 1);
INSERT INTO phpbb_album_cat VALUES (1, 0, 0, 'Przyroda', 'Tutaj dajemy zdjcia krajobrazw :)', 10, -1, 0, 0, 0, 0, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0);
INSERT INTO phpbb_album_config VALUES ('max_pics', '1024');
INSERT INTO phpbb_album_config VALUES ('user_pics_limit', '50');
INSERT INTO phpbb_album_config VALUES ('mod_pics_limit', '250');
INSERT INTO phpbb_album_config VALUES ('max_file_size', '128000');
INSERT INTO phpbb_album_config VALUES ('max_width', '800');
INSERT INTO phpbb_album_config VALUES ('max_height', '600');
INSERT INTO phpbb_album_config VALUES ('rows_per_page', '3');
INSERT INTO phpbb_album_config VALUES ('cols_per_page', '4');
INSERT INTO phpbb_album_config VALUES ('fullpic_popup', '1');
INSERT INTO phpbb_album_config VALUES ('thumbnail_quality', '50');
INSERT INTO phpbb_album_config VALUES ('thumbnail_size', '125');
INSERT INTO phpbb_album_config VALUES ('thumbnail_cache', '1');
INSERT INTO phpbb_album_config VALUES ('sort_method', 'pic_time');
INSERT INTO phpbb_album_config VALUES ('sort_order', 'DESC');
INSERT INTO phpbb_album_config VALUES ('jpg_allowed', '1');
INSERT INTO phpbb_album_config VALUES ('png_allowed', '1');
INSERT INTO phpbb_album_config VALUES ('gif_allowed', '0');
INSERT INTO phpbb_album_config VALUES ('desc_length', '512');
INSERT INTO phpbb_album_config VALUES ('hotlink_prevent', '0');
INSERT INTO phpbb_album_config VALUES ('hotlink_allowed', '');
INSERT INTO phpbb_album_config VALUES ('personal_gallery', '0');
INSERT INTO phpbb_album_config VALUES ('personal_gallery_private', '0');
INSERT INTO phpbb_album_config VALUES ('personal_gallery_limit', '10');
INSERT INTO phpbb_album_config VALUES ('personal_gallery_view', '-1');
INSERT INTO phpbb_album_config VALUES ('rate', '1');
INSERT INTO phpbb_album_config VALUES ('rate_scale', '10');
INSERT INTO phpbb_album_config VALUES ('comment', '1');
INSERT INTO phpbb_album_config VALUES ('gd_version', '1');
INSERT INTO phpbb_album_config VALUES ('album_version', '.0.51');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('upload_dir','files');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('upload_img','images/icon_clip.gif');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('topic_icon','images/icon_clip.gif');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('display_order','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_filesize','262144');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('attachment_quota','52428800');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_filesize_pm','262144');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_attachments','10');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_attachments_pm','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('disable_mod','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('allow_pm_attach','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('attachment_topic_review','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('allow_ftp_upload','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('show_apcp','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_server','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_path','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('download_path','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_user','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_pass','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_display_inlined','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_max_width','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_max_height','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_link_width','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_link_height','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_create_thumbnail','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_min_thumb_filesize','12000');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_imagick', '');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('wma_autoplay','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('flash_autoplay','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('attach_version','2.3.9');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('default_upload_quota', '0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('default_pm_quota', '0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_pasv_mode','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('use_gd2','0');

INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_photo_remote', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_photo_upload', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('photo_filesize', '40000');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('photo_max_height', '200');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('photo_max_width', '200');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('photo_path', 'images/photos');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_custom_rank', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('birthday_greeting', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_user_age', '100');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('min_user_age', '5');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('birthday_check_day', '7');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cload','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cchat','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cstat','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cregist','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cstyles','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('ccount','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cchat2','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cbirth','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cpost','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('ctop','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cfriend','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cage','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cjoin','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cfrom','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cposts','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('clevell','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cleveld','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cglow','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cfreak','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cignore','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cquick','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cgg','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('csearch','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cicq','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cllogin','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('clevelp','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cyahoo','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cmsn','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cjob','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cinter','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cemail','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cbbcode','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('chtml','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('csmiles','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cpppage','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('clang','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('ctimezone','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cdatefor','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cbstyle','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('refresh', '0' );
INSERT INTO phpbb_config (config_name, config_value) VALUES ('meta_keywords', '' );
INSERT INTO phpbb_config (config_name, config_value) VALUES ('meta_description', '' );
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cavatar', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('clog', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cagent','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('login_require','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('crestrict','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('validate','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_b','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_i','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_u','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_q','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_c','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_l','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_im','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_ur','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_ce','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_f','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_s','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('button_hi','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('color_box','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('size_box','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('glow_box','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('freak','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_bbcode_quest','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('google','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sql','http://');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cregist_b','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_custom_color', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('custom_color_view', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('custom_color_use', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('post_icon', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('auto_date', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('newest', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('download', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('ipview', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('show_badwords', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('album_gallery', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('address_whois', 'http://ripe.net/perl/whois?form_type=simple&amp;full_query_string=&amp;searchtext=');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('u_o_t_d', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('group_rank_hack_version', '1.0.0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('expire', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('expire_value', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('numer_gg', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('haslo_gg', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('block_time', '15');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_login_error', '10');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('min_password_len', '3');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('force_complex_password', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('password_not_login', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('del_user_notify', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('require_aim', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('require_website', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('require_location', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('post_footer','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('graphic','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sig_custom_rank','20');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sig_location','20');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('custom_color_mod','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('custom_rank_mod','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_sig_image', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sig_images_path', 'images/signatures');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sig_image_filesize', '30000');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sig_image_max_width', '400');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sig_image_max_height', '50');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('hide_viewed_admin', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('hide_edited_admin', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('who_viewed', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('who_viewed_admin', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('edit_time', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('read_tracking', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sort_methods', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('gender', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('require_gender', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('main_admin_id', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('day_to_prune', '30');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('banner_top', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('banner_top_enable', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('banner_bottom', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('banner_bottom_enable', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('header_enable', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('not_edit_admin', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('staff_forums', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('staff_enable', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smilies_columns', '4');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smilies_rows', '8');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smilies_w_columns', '8');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('generate_time', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('name_color', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('desc_color', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('mod_nick_color', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('warnings_enable', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('mod_warnings', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('mod_edit_warnings', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('mod_value_warning', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('write_warnings', '3');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('ban_warnings', '6');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('expire_warnings', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('viewtopic_warnings','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('warnings_mods_public', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_msg_enable', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_msg', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('width_forum', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('width_table', '800');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('width_color1', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('width_color2', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('table_border', '6');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('rebuild_search', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('generate_time_admin', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('redirect_after_registering', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('redirect_address', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('r_a_r_time', '10');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('show_rules', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('visitors', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('email_return_path', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('email_from', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('poster_posts', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sub_forum', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sub_forum_over', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('split_cat', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('split_cat_over', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('last_topic_title', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('last_topic_title_over', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('last_topic_title_length', '24');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sub_level_links', '2');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sub_level_links_over', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('display_viewonline', '2');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('display_viewonline_over', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('ignore_topics', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topic_color', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topic_color_all', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topic_color_mod', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('jump_value_arr', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_sig_image_img', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('last_dtable_notify','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_no_guestes', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_no_auth_users', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_no_auth_groups', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_disabled_users', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_disabled_groups', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_only_admin', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_popup_height', '250');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_popup_width', '700');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_popup_links_target', '2');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_post_hack_version', '1.0.5');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_disable', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_avatar', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('last_visitors_time','24');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sig_chars_admin','6');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sig_chars_mod','3');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('viewonline','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('restrict_smilies','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topic_preview','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('not_anonymous_posting','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('not_anonymous_quickreply','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_smilies',	'24');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('portal_link',	'1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('search_enable','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('overlib',	'1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('notify_gg','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('admin_notify_gg',	'');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('admin_notify_reply','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('admin_notify_message','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topic_start_date','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topic_start_dateformat','d-m-y');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('all_time_ban_check','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('autorepair_tables','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('check_address','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('echange_banner','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('banners_list','<center><a href="http://phpbb.com" target="_blank"><img src="images/link_phpbb.gif" alt="" border="0" /></a></center><br />[banner]<center><a href="http://forumimages.com" target="_blank"><img src="images/link_forumimages.gif" alt="" border="0" /></a></center><br />[banner]<center><embed src="images/clock.swf" quality=high type="application/x-shockwave-flash" width="80" height="80" /></center>');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('split_messages','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('split_messages_admin','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('split_messages_mod','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('split_messages_except','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('admin_html','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('jr_admin_html','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('mod_html','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('lastvisit_days','14');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('helped','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('helped_forums','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('del_notify_method', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('del_notify_enable', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('del_notify_choice', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('open_in_windows', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('admin_files', 'admin_board,admin_mass_email,admin_update,admin_portal,admin_forums_config,admin_forums,admin_forumauth,admin_users_list,admin_user_bantron');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('title_explain', '1');

INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (1,'Images',1,1,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (2,'Archives',0,1,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (3,'Plain Text',0,0,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (4,'Documents',0,0,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (5,'Real Media',0,0,2,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (6,'Streams',2,0,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (7,'Flash Files',3,0,1,'',0,'');

INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (1, 1, 'gif', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (2, 1, 'png', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (3, 1, 'jpeg', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (4, 1, 'jpg', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (5, 1, 'tif', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (6, 1, 'tga', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (7, 2, 'gtar', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (8, 2, 'gz', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (9, 2, 'tar', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (10, 2, 'zip', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (11, 2, 'rar', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (12, 2, 'ace', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (13, 3, 'txt', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (14, 3, 'c', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (15, 3, 'h', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (16, 3, 'cpp', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (17, 3, 'hpp', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (18, 3, 'diz', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (19, 4, 'xls', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (20, 4, 'doc', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (21, 4, 'dot', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (22, 4, 'pdf', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (23, 4, 'ai', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (24, 4, 'ps', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (25, 4, 'ppt', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (26, 5, 'rm', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (27, 6, 'wma', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (31, 6, 'avi', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (32, 6, 'mpg', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (33, 6, 'mpeg', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (34, 6, 'mp3', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (35, 6, 'wav', '');

INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (1,'php');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (2,'php3');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (3,'php4');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (4,'phtml');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (5,'pl');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (6,'asp');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (7,'cgi');

INSERT INTO phpbb_pa_cat VALUES (1, 'Test Category', 'Test category', 0, 0, 0, 1);

INSERT INTO phpbb_pa_settings (settings_id, settings_dbname, settings_sitename, settings_dburl, settings_topnumber, settings_homeurl, settings_newdays, settings_stats, settings_viewall, settings_showss, settings_disable, allow_html, allow_bbcode, allow_smilies, allow_comment_links, no_comment_link_message, allow_comment_images, no_comment_image_message, max_comment_chars, directly_linked) VALUES ('1', 'Download Index', 'My Site', 'http://yoursite_URL/phpBB2', '10', 'http://yoursite_URL', '5', '0', '1', '1', '0', '0', '1', '1', '0', 'No links please', '0', 'No images please', '1000', '0');

INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('portal_on', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('link_logo', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('own_header', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('portal_header_body', '<table width="100%" cellspacing="0" cellpadding="10" border="0" align="center"><tr><td class="bodyline"><table class="topbkg"width="100%" cellspacing="0" cellpadding="0" border="0"><tr><td><a href="index.php"><img src="images/portal_logo.jpg" border="0" alt="Forum" /></a></td><td align="center"><span class="gensmall">To jest wasny nagwek. Moesz go cakowicie zmieni w panelu admina, prawdopodobnie kolorystyka jest nieodpowiednia, moesz j dobra w zalenoci jakiego stylu uywasz.</td><td align="right"><img src="images/phpbb2_logor.jpg" alt="" /></td></tr></table><table width="100%" border="0" cellspacing="0" cellpadding="2"><tr><td class="topnav"><a href="index.php" class="mainmenu">Forum</a>  &#8226;  <a href="chatbox_mod/chatbox.php" class="mainmenu">Chat</a>  &#8226;  <a href="faq.php" class="mainmenu">Pomoc</a>  &#8226;  <a href="search.php" class="mainmenu">Szukaj</a>  &#8226;  <a href="memberlist.php" class="mainmenu">Uytkownicy</a>  &#8226;  <a href="groupcp.php" class="mainmenu">Grupy</a>  &#8226;  <a href="statistics.php" class="mainmenu">Statystyki</a>  &#8226;  <a href="album.php" class="mainmenu">Album</a>  &#8226;  <a href="dload.php" class="mainmenu">Download</a></td></tr></table><br />');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('portal_footer_body', '<table  class="topbkg"width="100%" cellspacing="0" cellpadding="0" border="0"><tr><td align="center"><span class="gensmall">W tym miejscu moesz ustawi wasn stopk portalu</span></td></tr></table>');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('news_forum', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('body_news_forum', '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25"><span class="genmed"><b>Tytu newsw lub strony, watever</b></span></td>\r\n</tr><tr><td class="row1" align="left"><span class="gensmall" style="line-height:150%">Dowolna tresc opisujaca portal, strone, forum ...<br /> </span></td></tr></table><br />');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('number_of_news', '20');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('news_length', '2000');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('witch_news_forum', '6');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('witch_poll_forum', '7');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('except_forum', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('scroll_recent_topics', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('poll', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('download_pos', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('portal_menu_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links_a2', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('search_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('stat_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('recent_topics_a', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('top_posters_a', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links1', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links2', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links3', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links4', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links5', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links6', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links7', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links8', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module1', 'portal_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module2', 'register_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module3', 'info_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module4', 'search_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module5', 'stats_user_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module6', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module7', 'whoonline_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module8', 'links_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module9', 'clock_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module10', 'custom_module1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module11', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module12', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module13', 'birthday_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module14', 'recent_topics_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module15', 'login_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module16', 'album_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module17', 'download');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module18', 'top_posters_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module19', 'chat_menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module20', 'blank_module1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module21', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module22', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module23', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('module24', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('links_body', '<center><br /><a href="http://phpbb.com" target="_blank"><img src="images/link_phpbb.gif" border="0" title="phpBB" alt="" /></a><br /><br /><a href="http://www.forumimages.com/" target="_blank"><img src="images/link_forumimages.gif" border="0" title="ForumImages" alt="" /></a>\r\n<br /><br /><a href="http://www.google.com/" target="_blank"><img src="images/links_google.gif" border="0" title="Google" alt="" /></a>\r\n<br /><br /><a href="http://www.apache.org/" target="_blank"><img src="images/link_apache.gif" border="0" title="Apache Software Foundation" alt="" /></a><br /><br />');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom1_body', 'jaka tre, lub tre i html');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom1_name', 'Wasne menu');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom1_body_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom1_body_on', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom2_body', 'jaka tre, lub tre i html');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom2_name', 'Wasne menu 2');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom2_body_a', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom2_body_on', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc1', 'wasny link');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address1', 'http://www.przemo.org');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc2', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address2', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc3', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address3', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc4', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address4', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc5', 'Statystyki');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address5', 'statistics.php');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc6', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address6', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc7', 'Kto tu rzadzi :)');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address7', 'staff.php');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_desc8', 'wlasny link2');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('custom_address8', 'http://www.phpbb.com');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank1_body_on', '1');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank1_body', '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline"><tr><td class="catHead" height="25" align="right"><span class="genmed"><b>Wlasny modul</b></span></td></tr><tr><td class="row1" align="right"><span class="genmed" style="line-height: 150%">\r\n<iframe src="http://www.playboy.com" width="100%" height="300"></iframe>\r\n</span></td></tr></table><br />');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank2_body_on', '0');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank2_body', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank3_body_on', '0');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank3_body', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank4_body_on', '0');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('blank4_body', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('birthday_a', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('info_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('login_a', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('whoonline_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('chat_a', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('register_a', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('album_recent_pics', '2');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('album_a', 'left');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('recent_pics', '2');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('album_pos', 'right');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('own_body', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('value_recent_topics', '10');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('value_top_posters', '10');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('ri_time', '');
INSERT INTO phpbb_portal_config (config_name, config_value) VALUES ('ri_data', '');


INSERT INTO phpbb_quota_limits (quota_limit_id, quota_desc, quota_limit) VALUES (1, 'Low', 262144);
INSERT INTO phpbb_quota_limits (quota_limit_id, quota_desc, quota_limit) VALUES (2, 'Medium', 2097152);
INSERT INTO phpbb_quota_limits (quota_limit_id, quota_desc, quota_limit) VALUES (3, 'High', 5242880);

INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('install_date', 'time()');
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('return_limit', '10');
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('version', '2.1.3');
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('modules_dir', 'stat_modules');
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('page_views', '0');

INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('1', 'top_words', '1', '1', '10', '1440', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('2', 'top_smilies', '1', '1', '20', '1000', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('3', 'most_active_topics', '1', '1', '30', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('4', 'most_viewed_topics', '1', '1', '40', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('5', 'new_topics_by_month', '1', '1', '50', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('6', 'latest_topics', '1', '1', '60', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('7', 'new_posts_by_month', '1', '1', '70', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('8', 'top_posters', '1', '1', '80', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('9', 'last_active_users', '1', '1', '90', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('10', 'new_users_by_month', '1', '1', '100', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('11', 'users_from_where', '1', '1', '110', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('12', 'age_statistics', '1', '1', '120', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('13', 'users_gender', '1', '1', '130', '1440', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('14', 'priv_msgs', '1', '1', '140', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('15', 'admin_statistics', '1', '1', '150', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');
INSERT INTO phpbb_stats_modules (module_id, name, active, installed, display_order, update_time, auth_value, module_info_cache, module_db_cache, module_result_cache, module_info_time, module_cache_time) VALUES ('16', 'forum_index', '1', '1', '160', '0', '0', '[BLOB]', '[BLOB]', '[BLOB]', '0', '0');

INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_guest_view','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_guest','0');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_users_view','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_users','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_delete_all','0');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_delete','0');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_delete_m','0');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_edit_all','0');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_edit','0');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_edit_m','0');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_bbcode','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('allow_smilies','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('links_names','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('make_links','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('count_msg','100');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('delete_days','30');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('text_lenght','500');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('word_lenght','80');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('date_format','D G:i');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('date_on','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('shoutbox_on','1');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('shout_width','630');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('shout_height','130');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('banned_user_id','');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('banned_user_id_view','');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('color_mod','');
INSERT INTO phpbb_shoutbox_config (config_name, config_value) VALUES ('color_admin','');


UPDATE phpbb_config SET config_value = 'Powered by <a href="http://www.phpbb.com" target="blnk" class="copyright">phpBB</a> modified v1.9 by <a href="http://www.przemo.org/phpBB2/" class="copyright" target="_blank">Przemo</a> &copy; 2003 phpBB Group' WHERE config_name = 'version';
