<?php
/***************************************************************************
 *				shoutbox_view.php
 *				-------------------
 *   begin		: Friday, May 02, 2004
 *   copyright	: (C) 2004 Przemo
 *   website	: http://www.przemo.org
 *   email		: przemo@przemo.org
 *   version	: 1.9
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
define('SHOUTBOX', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include_once($phpbb_root_path . 'includes/bbcode.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

if ( $board_config['login_require'] && !$userdata['session_logged_in'] )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

$mode = htmlspecialchars($HTTP_POST_VARS['mode']);
$msg = (isset($HTTP_POST_VARS['msg']) ) ? trim(htmlspecialchars($HTTP_POST_VARS['msg'])) : '';
$edit = (isset($HTTP_GET_VARS['edit']) ) ? intval($HTTP_GET_VARS['edit']) : '';
$delete = (isset($HTTP_GET_VARS['delete']) ) ? intval($HTTP_GET_VARS['delete']) : '';
$edited_msg = (isset($HTTP_POST_VARS['edited_msg']) ) ? intval($HTTP_POST_VARS['edited_msg']) : '';

$sb_user_id = $userdata['user_id'];
$current_time = time();

if ( $HTTP_GET_VARS['mode'] == 'show' )
{
	@setcookie('shoutbox',on , ($current_time + 3600 * 9000), $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
	redirect(append_sid("index.$phpEx?redirect=shoutbox_view.$phpEx", true));
}

// ShoutBox auth
$is_jr_admin = (is_jr_admin($userdata['user_id'])) ? true : false;
$is_mod = (is_mod($userdata['user_id'])) ? true : false;

$is_auth_e_own = ( $shoutbox_config['allow_edit_all'] && $userdata['user_id'] != ANONYMOUS ) ? true : false;
$is_auth_d_own = ( $shoutbox_config['allow_delete_all'] && $userdata['user_id'] != ANONYMOUS ) ? true : false;
$is_auth_e = ( $shoutbox_config['allow_edit'] && ((($is_jr_admin || $is_mod) && $shoutbox_config['allow_edit_m']) || $userdata['user_level'] == ADMIN) ) ? true : false;
$is_auth_d = ( $shoutbox_config['allow_delete'] && ((($is_jr_admin || $is_mod) && $shoutbox_config['allow_delete_m']) || $userdata['user_level'] == ADMIN) ) ? true : false;
$is_auth_send = ((!$shoutbox_config['allow_guest'] && !$userdata['session_logged_in']) || (!$shoutbox_config['allow_users'] && ($userdata['user_level'] != ADMIN && !$is_mod && !$is_jr_admin))) ? false : true;

$not_authorised = '<body onload="window.scrollTo(0,0);" /><table cellpadding="0" cellspacing="0" align="center"><tr><td align="left"><span class="gensmall"><b>' . $lang['Not_Authorised'] . '</b></span></td></tr></table>';
// End ShoutBox auth

if ( $mode == 'submit' && $msg )
{
	if ( !$is_auth_send )
	{
		echo '<body onload="window.scrollTo(0,0);" />
			<table cellpadding="0" cellspacing="0" align="center"><tr><td align="center"><span class="gensmall">
			<b>' . $lang['login_to_shoutcast'] . '</b></span></td></tr></table>';
	}

	$sql = "SELECT MAX(timestamp) AS last_msg_time
		FROM " . SHOUTBOX_TABLE . "
		WHERE sb_user_id = $sb_user_id";
	if ( $result = $db->sql_query($sql) )
	{
		if ( $row = $db->sql_fetchrow($result) )
		{
			if ( $row['last_msg_time'] > 0 && ( $current_time - $row['last_msg_time'] ) < $board_config['flood_interval'] && $userdata['user_level'] != ADMIN )
			{
				$flood_msg = true;
				echo '<body onload="window.scrollTo(0,0);" />
					<table align="center" cellpadding="0" cellspacing="0"><tr><td align="left"><span class="gensmall">
					' . $lang['Flood_Error'] . '</span></td></tr></table>';
			}
		}
	}

	$shoutbox_config['banned_user_id'] = $GLOBALS['shoutbox_config']['banned_user_id'];
	if ( strstr($shoutbox_config['banned_user_id'], ',') )
	{
		$fids = explode(',', $shoutbox_config['banned_user_id']);

		while( list($foo, $id) = each($fids) )
		{
			$fid[] = intval( trim($id) );
		}
	}
	else
	{
		$fid[] = intval( trim($shoutbox_config['banned_user_id']) );
	}
	reset($fid);

	if ( in_array($sb_user_id, $fid) != false )
	{
		echo '<body onload="window.scrollTo(0,0);" />
			<table align="center" cellpadding="0" cellspacing="0"><tr><td align="left"><span class="gensmall">
			' . $lang['sb_banned_send'] . '</span></td></tr></table>';
		$shoutbox_banned = true;
	}

	if ( !$too_long && !$flood_msg && !$shoutbox_banned && $is_auth_send )
	{
		$msg_id = $db->sql_nextid();

		$sql = "INSERT INTO " . SHOUTBOX_TABLE . "
			VALUES($msg_id, $sb_user_id, '" . str_replace("\'", "''", $msg) . "', '$current_time')";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not insert shoutbox message', '', __LINE__, __FILE__, $sql);
		}

		$start = $current_time - $shoutbox_config['delete_days'] * 86400;

		$sql = "DELETE FROM " . SHOUTBOX_TABLE . "
			WHERE timestamp < $start";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not delete shoutbox messages', '', __LINE__, __FILE__, $sql);
		}
	}
}

// Check auth for delete message
if ( $delete )
{
	if ( $HTTP_GET_VARS['sid'] != $userdata['session_id'] )
	{
		message_die(GENERAL_ERROR, 'Invalid_session');
	}

	$del_from_sb = false;

	if ( $is_auth_d )
	{
		$del_from_sb = true;
	}
	else if ( $is_auth_d_own )
	{
		$sql = "SELECT sb_user_id FROM " . SHOUTBOX_TABLE . "
			WHERE id = $delete";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get shoutbox id/user_id information', '', __LINE__, __FILE__, $sql);
		}
		$row = $db->sql_fetchrow($result);

		if ( $row['sb_user_id'] == $userdata['user_id'] )
		{
			$del_from_sb = true;
		}
		else
		{
			echo $not_authorised;
		}
	}
	else
	{
		echo $not_authorised;
	}

	if ( $del_from_sb )
	{
		$sql = "DELETE FROM " . SHOUTBOX_TABLE . "
			WHERE id = $delete";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not delete shoutbox message', '', __LINE__, __FILE__, $sql);
		}
	}
}


if ( $edit )
{
	$sql = "SELECT msg FROM " . SHOUTBOX_TABLE . "
		WHERE id = $edit";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not get shoutbox message to edit', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	echo '<body onload="window.scrollTo(0,0);" />
		<table cellpadding="0" cellspacing="0"><tr><td align="left"><form name="post" action="shoutbox_view.'.$phpEx.'" method="POST"><span class="gensmall">
		' . $lang['Edit_pm'] . ': <input type="text" name="msg" class="post" style="height:15px" size="60" maxlength="' . $shoutbox_config['text_lenght'] . '" " value="' . $row['msg'] . '" class="editbox"><input type="hidden" name="sid" value="' . $userdata['session_id'] . '" /><input type="hidden" name="edited_msg" value="' . $edit . '">
		<input type="submit" name="submit_button" value="' . $lang['Submit'] . '" style="font-size:9px; height:16px;" class="button"></span></form></td>
		</tr></table>';
}

// Check auth for edit message
if ( $edited_msg && $msg )
{
	$edit_from_sb = false;

	if ( $is_auth_e )
	{
		$edit_from_sb = true;
	}
	else if ( $is_auth_e_own )
	{
		$sql = "SELECT sb_user_id FROM " . SHOUTBOX_TABLE . "
			WHERE id = $edited_msg";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get shoutbox id/user_id information', '', __LINE__, __FILE__, $sql);
		}

		$row = $db->sql_fetchrow($result);

		if ( $row['sb_user_id'] == $userdata['user_id'] )
		{
			$edit_from_sb = true;
		}
		else
		{
			echo $not_authorised;
		}
	}
	else
	{
		echo $not_authorised;
	}

	if ( $edit_from_sb )
	{
		if ( !$is_auth_send )
		{
			echo '<body onload="window.scrollTo(0,0);" />
				<table cellpadding="0" cellspacing="0" align="center"><tr><td align="center"><span class="gensmall">
				<b>' . $lang['login_to_shoutcast'] . '</b></span></td></tr></table>';
		}

		$check_lenght = explode(" ",$msg);
		$total = sizeof($check_lenght);

		for($i=0; $total > $i; $i++)
		{
			if ( strlen($check_lenght[$i]) > $shoutbox_config['word_lenght'] )
			{
				$too_long = true;
				echo '<body onload="window.scrollTo(0,0);" />
					<table align="center" cellpadding="0" cellspacing="0"><tr><td align="left"><form name="post" action="shoutbox_view.'.$phpEx.'" method="POST"><span class="gensmall">
					<b>' . $lang['too_long_word'] . '</b></span></form></td></tr></table>';
			}
		}

		if ( !$too_long )
		{
			if ( $HTTP_POST_VARS['sid'] == '' || $HTTP_POST_VARS['sid'] != $userdata['session_id'] )
			{
				message_die(GENERAL_ERROR, 'Invalid_session');
			}

			$sql = "UPDATE " . SHOUTBOX_TABLE . "
				SET msg = '" . str_replace("\'", "''", $msg) . "'
				WHERE id = $edited_msg";
			if( !($result = $db->sql_query($sql)) )
			{
					message_die(GENERAL_ERROR, 'Could not replace shoutbox message', '', __LINE__, __FILE__, $sql);
			}
		}
	}
}

$template->set_filenames(array(
	'body' => 'shoutbox_view_body.tpl')
);

$shoutbox_config['banned_user_id_view'] = $GLOBALS['shoutbox_config']['banned_user_id_view'];

if( strstr($shoutbox_config['banned_user_id_view'], ',') )
{
	$fids = explode(',', $shoutbox_config['banned_user_id_view']);

	while( list($foo, $id) = each($fids) )
	{
		$fid[] = intval( trim($id) );
	}
}
else
{
	$fid[] = intval( trim($shoutbox_config['banned_user_id_view']) );
}
reset($fid);

if ( in_array($sb_user_id, $fid) != false )
{
	$shoutbox_banned_view = true;
}

if ( $shoutbox_config['shoutbox_on'] && $shoutbox != 'off' && !$shoutbox_banned_view && ( $shoutbox_config['allow_guest'] || $shoutbox_config['allow_guest_view'] || $userdata['session_logged_in'] ) && ($shoutbox_config['allow_users'] || $shoutbox_config['allow_users_view'] || $userdata['user_level'] == ADMIN || $is_mod || $is_jr_admin) )
{
	$sql = "SELECT COUNT(id) AS total
		FROM " . SHOUTBOX_TABLE;
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query shoutbox count messages', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);
	$msg_count = $row['total'];

	$number = $shoutbox_config['count_msg'];
	$start = $msg_count - $number;

	if ( $msg_count < $number )
	{
		$start = 0;
	}

	$sql = "SELECT s.id, s.sb_user_id, s.msg, s.timestamp, u.username, u.user_level, u.user_id
		FROM " . SHOUTBOX_TABLE . " s, " . USERS_TABLE . " u
		WHERE u.user_id = s.sb_user_id
		ORDER by s.timestamp
			LIMIT $start, $number";
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query shoutbox messages', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$i = 0;
		do
		{
			$name_id = $row['sb_user_id'];
			$name = $row['username'];
			$id = $row['id'];
			$msg = $row['msg'];
			if ( $shoutbox_config['color_admin'] != '' && $row['user_level'] == ADMIN )
			{
				$name = '<span style="color: #' . $shoutbox_config['color_admin'] . '">' . $name . '</span>';
			}
			else if ( $shoutbox_config['color_mod'] != '' && is_mod($row['user_id']) )
			{
				$name = '<span style="color: #' . $shoutbox_config['color_mod'] . '">' . $name . '</span>';
			}
			else if ( $shoutbox_config['color_mod'] != '' && is_jr_admin($row['user_id']) )
			{
				$name = '<span style="color: #' . $shoutbox_config['color_mod'] . '"><u>' . $name . '</u></span>';
			}			

			if ( $shoutbox_config['links_names'] )
			{
				$name = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;u=$name_id") . '" target="_blank" class="gensmall" title="' . $lang['Read_profile'] . '">' . $name . '</a>';
			}
			if ( $name_id == ANONYMOUS )
			{
				$name = $lang['Guest'];
			}

			if ( $shoutbox_config['date_on'] ) 
			{
				$make_date = create_date($shoutbox_config['date_format'], $row['timestamp'], $board_config['board_timezone']);
				$date = '[' . $make_date . ']';
			}

			if ( $shoutbox_config['allow_smilies'] )
			{
				$msg = smilies_pass($msg);
				$msg = preg_replace('/images\/smiles/', 'images/smiles', $msg);
			}

			if ( $shoutbox_config['make_links'] )
			{
				$msg = make_clickable($msg);
			}

			if ( $shoutbox_config['allow_bbcode'] )
			{
				$msg = str_replace(array('[u]', '[b]', '[i]', '[/i]', '[/b]', '[/u]'), array('<u>', '<b>', '<i>', '</i>', '</b>', '</u>'), $msg);
			}
			else
			{
				$msg = str_replace(array('[u]', '[b]', '[i]', '[/i]', '[/b]', '[/u]'), array('', '', '', '', '', ''), $msg);
			}

			$username = ($userdata['username'] == 'Anonymous') ? $lang['Guest'] : $userdata['username'];
			$msg = str_replace("[you]", $username, $msg);
			$orig_word = array();
			$replacement_word = array();
			obtain_word_list($orig_word, $replacement_word);
			replace_bad_words($orig_word, $replacement_word, $msg);

			$delmsg = $editmsg = '';

			if ( $is_auth_d_own && $name_id == $sb_user_id || $is_auth_d )
			{
				$temp_url = append_sid("shoutbox_view.$phpEx?delete=$id&amp;sid=" . $userdata['session_id']);
				$delmsg = '<a href="' . $temp_url . '" class="mainmenu" title="' . $lang['Delete_message'] . '"><b>x</b></a>';
			}

			if ( $is_auth_e_own && $name_id == $sb_user_id || $is_auth_e )
			{
				$date_edit = $row['timestamp'];
				$name_edit = $row['sb_username'];
				$temp_url_e = append_sid("shoutbox_view.$phpEx?edit=$id");
				$editmsg = '<a href="' . $temp_url_e . '" class="mainmenu" title=" ' .$lang['Edit_pm'] . '"><b>e</b></a>';
			}

			$template->assign_block_vars('shoutrow', array(
				'DELMSG' => $delmsg,
				'EDITMSG' => $editmsg,
				'ROW_CLASS' => (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'],
				'NAME' => $name,
				'DATE' => $date,
				'MSG' => '&nbsp;' . word_wrap_pass($msg))
			);

			$i++;
		}
		while ( $row = $db->sql_fetchrow($result) );
	}
}

$template->assign_vars(array( 
	'S_CONTENT_ENCODING' => $lang['ENCODING']) 
);

$template->pparse('body');

?>