<?php
/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

// DB Cache used here

//
// Top Posting Users
//
$template->assign_vars(array(
	'L_RANK' => $lang['Rank'],
	'L_POSTS' => $lang['helped'],
	'L_PERCENTAGE' => $lang['Percent'],
	'L_USERNAME' => $lang['Username'],
	'L_GRAPH' => $lang['Graph'],
	'MODULE_NAME' => $lang['module_name'])
);

$statistics->init_bars();

$sql = "SELECT SUM(special_rank) as total_helped FROM " . USERS_TABLE . "
	WHERE user_id <> " . ANONYMOUS;

if ( !($result = $stat_db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Couldn\'t retrieve users data', '', __LINE__, __FILE__, $sql);
}

$row = $stat_db->sql_fetchrow($result);
$total_helped = $row['total_helped'];

$sql = "SELECT user_id, username, special_rank FROM " . USERS_TABLE . " 
	WHERE (user_id <> " . ANONYMOUS . " ) AND (special_rank > 0) 
		ORDER BY special_rank DESC 
		LIMIT " . $return_limit;

if ( !($result = $stat_db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Couldn\'t retrieve users data', '', __LINE__, __FILE__, $sql);
}

$user_count = $stat_db->sql_numrows($result);
$user_data = $stat_db->sql_fetchrowset($result);

$firstcount = $user_data[0]['special_rank'];

for ($i = 0; $i < $user_count; $i++)
{
	$class = ( !($i+1 % 2) ) ? $theme['td_class2'] : $theme['td_class1'];

	$statistics->do_math($firstcount, $user_data[$i]['special_rank'], $total_helped);

	$template->assign_block_vars('users_helped', array(
		'RANK' => $i+1,
		'CLASS' => $class,
		'USERNAME' => $user_data[$i]['username'],
		'PERCENTAGE' => $statistics->percentage,
		'BAR' => $statistics->bar_percent,
		'URL' => append_sid($phpbb_root_path . 'profile.php?mode=viewprofile&amp;u=' . $user_data[$i]['user_id']),
		'POSTS' => $user_data[$i]['special_rank'])
	);
}

?>