<?php
/***************************************************************************
 *						viewforum.php
 *						-------------------
 *	begin				: Saturday, Feb 13, 2001
 *	copyright			: (C) 2001 The phpBB Group
 *	email				: support@phpbb.com
 *	modification		: (C) 2003 Przemo http://www.przemo.org
 *	date modification	: ver. 1.9 2004/05/12 14:20
 *
 *	$Id: viewforum.php,v 1.8.9 2004/05/12 14:20
 ***************************************************************************/

/***************************************************************************
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 ***************************************************************************/

define('IN_PHPBB', true);
define('PORTAL', true);
define('ATTACH', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

// Start initial var setup
if ( isset($HTTP_GET_VARS[POST_FORUM_URL]) || isset($HTTP_POST_VARS[POST_FORUM_URL]) )
{
	$forum_id = (isset($HTTP_GET_VARS[POST_FORUM_URL])) ? intval($HTTP_GET_VARS[POST_FORUM_URL]) : intval($HTTP_POST_VARS[POST_FORUM_URL]);
}
else if ( isset($HTTP_GET_VARS['forum']))
{
	$forum_id = intval($HTTP_GET_VARS['forum']);
}
else
{
	$forum_id = '';
}

define('IN_VIEWFORUM', true);

if (isset($HTTP_GET_VARS['selected_id']) || isset($HTTP_POST_VARS['selected_id']))
{
	$selected_id = (isset($HTTP_POST_VARS['selected_id'])) ? $HTTP_POST_VARS['selected_id'] : $HTTP_GET_VARS['selected_id'];
	$type = substr($selected_id, 0, 1);
	$id	= intval(substr($selected_id, 1));

	if ( $type == POST_FORUM_URL )
	{
		$forum_id = $id;
	}
	else if ( ($type == POST_CAT_URL ) || ($selected_id == 'Root'))
	{
		$parm = ($id != 0) ? "?" . POST_CAT_URL . "=$id" : '';
		redirect(append_sid("./index.$phpEx" . $parm));
	}
}

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( isset($HTTP_GET_VARS['mark']) || isset($HTTP_POST_VARS['mark']) )
{
	$mark_read = (isset($HTTP_POST_VARS['mark'])) ? $HTTP_POST_VARS['mark'] : $HTTP_GET_VARS['mark'];
}
else
{
	$mark_read = '';
}
// End initial var setup

// Check if the user has actually sent a forum ID with his/her request
// If not give them a nice error page.
if ( !empty($forum_id) )
{
	$sql = "SELECT *
		FROM " . FORUMS_TABLE . "
		WHERE forum_id = $forum_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
	}
}
else
{
	message_die(GENERAL_MESSAGE, 'Forum_not_exist');
}

// If the query doesn't return any rows this isn't a valid forum. Inform
// the user.
if ( !($forum_row = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, 'Forum_not_exist');
}

// Start session management
$userdata = session_pagestart($user_ip, $forum_id);
init_userprefs($userdata);
// End session management

if ( $userdata['session_logged_in'] && $board_config['redirect_after_registering'] )
{
	if ((time() - $userdata['user_lastvisit']) < $board_config['r_a_r_time'] )
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['redirect_info'], '<a href="' . $board_config['redirect_address'] . '">', '</a>', '<meta http-equiv="refresh" content="4;url=' . $board_config['redirect_address'] . '">'));
	}
}

$user_topics_per_page = ($userdata['user_topics_per_page'] > 0) ? $userdata['user_topics_per_page'] : '25';
$user_posts_per_page = ($userdata['user_posts_per_page'] > 0) ? $userdata['user_posts_per_page'] : '15';

if ( $board_config['read_tracking'] )
{
	include($phpbb_root_path . 'includes/read_history.'.$phpEx);
}

$selected_id = POST_FORUM_URL . $forum_id;
$athis = isset($tree['keys'][$selected_id]) ? $tree['keys'][$selected_id] : -1;
if ( ($athis > -1) && !empty($tree['data'][$athis]['forum_link']))
{
	// add 1 to hit if count ativated
	if ($tree['data'][$athis]['forum_link_hit_count'])
	{
		$sql = "UPDATE " . FORUMS_TABLE . " 
			SET forum_link_hit = forum_link_hit + 1 
			WHERE forum_id = $forum_id";
		if (!$db->sql_query($sql)) message_die(GENERAL_ERROR, 'Could not increment forum hits information', '', __LINE__, __FILE__, $sql);
	}

	// prepare url
	$url = $tree['data'][$athis]['forum_link'];
	if ( $tree['data'][$athis]['forum_link_internal'] )
	{
		$part = explode( '?', $url);
		$url .= ((count($part) > 1) ? '&' : '?') . 'sid=' . $userdata['session_id'];
		$url = append_sid($url);

		// redirect to url
		redirect($url);
	}

	if ( !empty($db) )
	{
		$db->sql_close();
	}

	// Redirect via an HTML form for PITA webservers
	if ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) )
	{
		header('Refresh: 0; URL=' . $url);
		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="0; url=' . $url . '"><title>' . $lang['Redirect'] . '</title></head><body><div align="center">' . sprintf($lang['Rediect_to'], '<a href="' . $url . '">', '</a>') . '</div></body></html>';
	}

	// Behave as per HTTP/1.1 spec for others
	header('Location: ' . $url);
	exit;
}

if ( $board_config['login_require'] && !$userdata['session_logged_in'] )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

//Prune old read tracking
$current_rt_time = time();
$time_to_prune = $current_rt_time - ($board_config['day_to_prune'] * 86400);

$sql = "DELETE FROM " . READ_HIST_TABLE . "
	WHERE post_time < $time_to_prune";

if ( !$db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, 'Error in pruning read history', '', __LINE__, __FILE__, $sql);
}
//end pruning read tracking

// Start auth check
$is_auth = array();
$is_auth = $tree['auth'][POST_FORUM_URL . $forum_id];

if ( !$is_auth['auth_read'] || !$is_auth['auth_view'] )
{
	if ( !$userdata['session_logged_in'] )
	{
		$redirect = POST_FORUM_URL . "=$forum_id" . ( ( isset($start) ) ? "&amp;start=$start" : '' );
		redirect(append_sid("login.$phpEx?redirect=viewforum.$phpEx&amp;$redirect", true));
	}
	// The user is not authed to read this forum ...
	$message = ( !$is_auth['auth_view'] ) ? $lang['Forum_not_exist'] : sprintf($lang['Sorry_auth_read'], $is_auth['auth_read_type']);

	message_die(GENERAL_MESSAGE, $message);
}
// End of auth check

// Password check
if ($forum_row['password'] != '')
{
	if ( !$is_auth['auth_mod'] || $userdata['user_level'] != ADMIN )
	{
		$redirect = str_replace("&amp;", "&", preg_replace('#.*?([a-z]+?\.' . $phpEx . '.*?)$#i', '\1', htmlspecialchars($_SERVER['REQUEST_URI'])));
		$cookie_forum_pass = $board_config['cookie_name'] . '_fpass_' . $forum_id;
		if( $HTTP_POST_VARS['cancel'] )
		{
			redirect(append_sid("index.$phpEx"));
		}
		else if( $HTTP_POST_VARS['submit'] )
		{
			password_check($forum_id, $HTTP_POST_VARS['password'], $redirect);
		}

		if( ($forum_row['password'] != '') && ($HTTP_COOKIE_VARS[$cookie_forum_pass] != md5($forum_row['password'])) )
		{
			password_box($forum_id, $redirect);
		}
	}
}
// END: Password check

$forum_moderate = ($forum_row['forum_moderate']) ? true : false;
$forum_view_moderate = ($forum_moderate && !$is_auth['auth_mod']) ? true : false;

// Handle marking posts
if ( $mark_read == 'topics' )
{
	if ( $userdata['session_logged_in'] )
	{
		if ( $board_config['read_tracking'] )
		{
			smart_mark_forum_read( $forum_id );
		}
		else
		{
			$sql = "SELECT MAX(post_time) AS last_post 
				FROM " . POSTS_TABLE . " 
				WHERE forum_id = $forum_id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
			}

			if ( $row = $db->sql_fetchrow($result) )
			{
				$tracking_forums = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f'])) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) : array();
				$tracking_topics = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t'])) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : array();

				if ( ( count($tracking_forums) + count($tracking_topics) ) >= 150 && empty($tracking_forums[$forum_id]) )
				{
					asort($tracking_forums);
					unset($tracking_forums[key($tracking_forums)]);
				}

				if ( $row['last_post'] > $userdata['user_lastvisit'] )
				{
					$tracking_forums[$forum_id] = time();
					setcookie($board_config['cookie_name'] . '_f', serialize($tracking_forums), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
				}
			}
		}

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">')
		);
	}

	$message = $lang['Topics_marked_read'] . '<br /><br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">', '</a> ');
	message_die(GENERAL_MESSAGE, $message);
}
// End handle marking posts

$tracking_topics = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t'])) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : '';
$tracking_forums = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f'])) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) : '';

// Do the forum Prune
if ( $is_auth['auth_mod'] )
{
	if ( $forum_row['prune_next'] < time() && $forum_row['prune_enable'] )
	{
		include($phpbb_root_path . 'includes/functions_remove.'.$phpEx);
		require($phpbb_root_path . 'includes/functions_admin.'.$phpEx);
		auto_prune($forum_id);
	}
}
// End of forum prune

// Obtain list of moderators of each forum
// First users, then groups ... broken into two queries
$sql = "SELECT u.user_id, u.username 
	FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
	WHERE aa.forum_id = $forum_id
		AND aa.auth_mod = " . TRUE . "
		AND g.group_single_user = 1
		AND ug.group_id = aa.group_id
		AND g.group_id = aa.group_id
		AND u.user_id = ug.user_id
	GROUP BY u.user_id, u.username
	ORDER BY u.user_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
}

$moderators = array();
while( $row = $db->sql_fetchrow($result) )
{
	$moderators[] = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '">' . $row['username'] . '</a>';
}

$sql = "SELECT g.group_id, g.group_name 
	FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g
	WHERE aa.forum_id = $forum_id
		AND aa.auth_mod = " . TRUE . "
		AND g.group_single_user = 0
		AND g.group_type <> ". GROUP_HIDDEN ."
		AND ug.group_id = aa.group_id
		AND g.group_id = aa.group_id
	GROUP BY g.group_id, g.group_name
	ORDER BY g.group_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
}

while( $row = $db->sql_fetchrow($result) )
{
	$moderators[] = '<a href="' . append_sid("groupcp.$phpEx?" . POST_GROUPS_URL . "=" . $row['group_id']) . '">' . $row['group_name'] . '</a>';
}
	
$l_moderators = (count($moderators) == 1) ? $lang['Moderator'] : $lang['Moderators'];
$forum_moderators = (count($moderators)) ? implode(', ', $moderators) : $lang['None'];
unset($moderators);


// Ignore topics
$sql_ignore_topics = '';
if ( $board_config['ignore_topics'] && $userdata['session_logged_in'] )
{
	$ignore_topics = $userdata['ignore_topics'];
	$sql_ignore_topics = ($ignore_topics) ? 'AND t.topic_id NOT IN (' . $ignore_topics . ')' : '';
	$sql_ignore_topics2 = ($ignore_topics) ? 'AND topic_id NOT IN (' . $ignore_topics . ')' : '';
}

// Generate a 'Show topics in previous x days' select box. If the topicsdays var is sent
// then get it's value, find the number of topics with dates newer than it (to properly
// handle pagination) and alter the main query
$previous_days = array(0, 15, 30, 60, 120, 360, 720, 1440, 2880, 4320, 5760, 7200, 8640, 10080, 20160, 43200, 129600, 259200, 524160);
$previous_days_text = array($lang['All_Posts'], $lang['15_min'], $lang['30_min'], $lang['1_Hour'], $lang['2_Hour'], $lang['6_Hour'], $lang['12_Hour'], $lang['1_Day'], $lang['2_Days'], $lang['3_Days'], $lang['4_Days'], $lang['5_Days'], $lang['6_Days'], $lang['7_Days'], $lang['2_Weeks'], $lang['1_Month'], $lang['3_Months'], $lang['6_Months'], $lang['1_Year']);

if ( !empty($HTTP_POST_VARS['topicdays']) || !empty($HTTP_GET_VARS['topicdays']) )
{
	$topic_days = ( !empty($HTTP_POST_VARS['topicdays']) ) ? intval($HTTP_POST_VARS['topicdays']) : intval($HTTP_GET_VARS['topicdays']);
	$min_topic_time = time() - ($topic_days * 60);

	$sql = "SELECT COUNT(t.topic_id) AS forum_topics
		FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p
		WHERE t.forum_id = $forum_id
			$sql_ignore_topics
			AND p.post_id = t.topic_last_post_id
			AND p.post_time >= $min_topic_time";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain limited topics count information', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	$topics_count = ($row['forum_topics']) ? $row['forum_topics'] : 1;
	$limit_topics_time = "AND p.post_time >= $min_topic_time";

	if ( !empty($HTTP_POST_VARS['topicdays']) )
	{
		$start = 0;
	}
}
else
{
	$sql = "SELECT COUNT(topic_id) AS forum_topics
		FROM " . TOPICS_TABLE . "
		WHERE forum_id = $forum_id
			$sql_ignore_topics2";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain limited topics count information', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	$topics_count = ($row['forum_topics']) ? $row['forum_topics'] : 1;
//	$topics_count = ($forum_row['forum_topics']) ? $forum_row['forum_topics'] : 1;

	$limit_topics_time = '';
	$topic_days = 0;
}

$select_topic_days = '<select name="topicdays">';
for($i = 0; $i < count($previous_days); $i++)
{
	$selected = ($topic_days == $previous_days[$i]) ? ' selected="selected"' : '';
	$select_topic_days .= '<option value="' . $previous_days[$i] . '"' . $selected . '>' . $previous_days_text[$i] . '</option>';
}
$select_topic_days .= '</select>';

// All GLOBAL announcement data, this keeps GLOBAL announcements 
// on each viewforum page ... 
if ($forum_row['forum_sort'] == 'SORT_ALPHA') 
{
	$topic_order = 't.topic_title';
}
else
{
	$topic_order = 't.topic_last_post_id DESC';
}

$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_time, p.post_username
	FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . USERS_TABLE . " u2
	WHERE t.topic_poster = u.user_id
	$sql_ignore_topics
		AND p.post_id = t.topic_last_post_id
		AND p.poster_id = u2.user_id
		AND t.topic_type = " . POST_GLOBAL_ANNOUNCE . "
	ORDER BY t.topic_type DESC, $topic_order
	LIMIT $start, $user_topics_per_page";

if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, 'Couldn\'t obtain topic information', '', __LINE__, __FILE__, $sql);
}

$topic_rowset = array();
$total_announcements = 0;
while( $row = $db->sql_fetchrow($result) )
{
	$topic_rowset[] = $row;
	$total_announcements++;
}

$db->sql_freeresult($result);

// All announcement data, this keeps announcements
// on each viewforum page ...
$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_time, p.post_username
	FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . USERS_TABLE . " u2
	WHERE t.forum_id = $forum_id
		$sql_ignore_topics
		AND t.topic_poster = u.user_id
		AND p.post_id = t.topic_last_post_id
		AND p.poster_id = u2.user_id
		AND t.topic_type = " . POST_ANNOUNCE . "
	ORDER BY t.topic_last_post_id DESC ";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain topic information', '', __LINE__, __FILE__, $sql);
}

while( $row = $db->sql_fetchrow($result) )
{
	$topic_rowset[] = $row;
	$total_announcements++;
}

$db->sql_freeresult($result);

// Grab all the basic data (all topics except announcements)
// for this forum

if ( $board_config['sort_methods'] )
{
	$sotr_methods = "ORDER BY t.topic_type DESC, t.topic_status ASC, $topic_order";
}
else
{
	$sotr_methods = "ORDER BY t.topic_type DESC, t.topic_last_post_id DESC, $topic_order";
}

$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_username, p.post_approve AS approve_post, p.poster_id AS approve_poster, p2.post_username AS post_username2, p2.post_time
	FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . POSTS_TABLE . " p2, " . USERS_TABLE . " u2
	WHERE t.forum_id = $forum_id
		$sql_ignore_topics
			AND t.topic_poster = u.user_id
			AND p.post_id = t.topic_first_post_id
			AND p2.post_id = t.topic_last_post_id
			AND u2.user_id = p2.poster_id
			AND t.topic_type <> " . POST_ANNOUNCE . "
			AND t.topic_type <> " . POST_GLOBAL_ANNOUNCE . "
		$limit_topics_time $sotr_methods
		LIMIT $start, $user_topics_per_page";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain topic information', '', __LINE__, __FILE__, $sql);
}

$total_topics = 0;
while( $row = $db->sql_fetchrow($result) )
{
	$topic_rowset[] = $row;
	$total_topics++;
}

$db->sql_freeresult($result);

// Total topics ...
$total_topics += $total_announcements;

// Define censored word matches
$orig_word = array();
$replacement_word = array();
obtain_word_list($orig_word, $replacement_word);

// Post URL generation for templating vars
$template->assign_vars(array(
	'L_DISPLAY_TOPICS' => $lang['Display_topics'],

	'U_POST_NEW_TOPIC' => append_sid("posting.$phpEx?mode=newtopic&amp;" . POST_FORUM_URL . "=$forum_id"),

	'S_SELECT_TOPIC_DAYS' => $select_topic_days,
	'S_POST_DAYS_ACTION' => append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=" . $forum_id . "&amp;start=$start"))
);

//
// User authorisation levels output
//
$s_auth_can = (($is_auth['auth_post']) ? $lang['Rules_post_can'] : $lang['Rules_post_cannot']) . '<br />';
$s_auth_can .= (($is_auth['auth_reply']) ? $lang['Rules_reply_can'] : $lang['Rules_reply_cannot']) . '<br />';
$s_auth_can .= (($is_auth['auth_edit']) ? $lang['Rules_edit_can'] : $lang['Rules_edit_cannot']) . '<br />';
$s_auth_can .= (($is_auth['auth_delete']) ? $lang['Rules_delete_can'] : $lang['Rules_delete_cannot']) . '<br />';
$s_auth_can .= (($is_auth['auth_vote']) ? $lang['Rules_vote_can'] : $lang['Rules_vote_cannot']) . '<br />';

if ( defined('ATTACHMENTS_ON') ) attach_build_auth_levels($is_auth, $s_auth_can);

if ( $is_auth['auth_mod'] )
{
	$s_auth_can .= sprintf($lang['Rules_moderate'], "<a href=\"modcp.$phpEx?" . POST_FORUM_URL . "=$forum_id&amp;start=" . $start . "&amp;sid=" . $userdata['session_id'] . '">', '</a>');
}

// Mozilla navigation bar
$nav_links['up'] = array(
	'url' => append_sid('index.'.$phpEx),
	'title' => sprintf($lang['Forum_Index'], $board_config['sitename'])
);

// Dump out the page header and load viewforum template
$forum_row['forum_name'] = get_object_lang(POST_FORUM_URL . $forum_id, 'name');
$page_title = $lang['View_forum'] . ' - ' . $forum_row['forum_name'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'viewforum_body.tpl')
);

make_jumpbox('viewforum.'.$phpEx);

display_index(POST_FORUM_URL . $forum_id);

$span_i = "2";
$span_j = "6";
if ( $board_config['post_icon'] )
{
	$span_i++;
	$span_j++;
	$icon_box1 = '<td class="row1" align="center" valign="middle" width="16">';
	$icon_box2 = '</td>';
}
else
{
	$icon_box1 = '<!--';
	$icon_box2 = '-->';
}

if ( $portal_config['portal_on'] && $board_config['portal_link'] )
{
	if ( strstr($portal_config['witch_news_forum'], ',') )
	{
		$fids = explode(',', $portal_config['witch_news_forum']);
		while( list($foo, $id) = each($fids) )
		{
			$fid[] = intval( trim($id) );
		}
	}
	else
	{
		$fid[] = intval( trim($portal_config['witch_news_forum']) );
	}
	reset($fid);

	$u_index_check = (in_array($forum_id, $fid) != false) ? append_sid('portal.'.$phpEx) : append_sid('index.'.$phpEx);
}
else
{
	$u_index_check = append_sid('index.'.$phpEx);
}


if ( $board_config['ignore_topics'] && $userdata['session_logged_in'] && $userdata['view_ignore_topics'] )
{
	$span_i++;
	$span_j++;
	$title_style = ($board_config['overlib']) ? ' onMouseOver="return overlib(\'<left>' . $lang['ignore_topic_submit_e'] . '</left>\', ol_offsetx=-203, ol_offsety=8, CAPTION, \'<center>' . $lang['ignore_mark'] . '</center>\')" onMouseOut="nd();"' : '';
	$ignore_begin = '
	<script language="JavaScript" type="text/javascript">
	function setCheckboxes(the_form, do_check)
	{ var elts = (typeof(document.forms[the_form].elements[\'list_ignore[]\']) != \'undefined\') ? document.forms[the_form].elements[\'list_ignore[]\'] : document.forms[the_form].elements = \'\'; var elts_cnt = (typeof(elts.length) != \'undefined\') ? elts.length : 0; if (elts_cnt) { for (var i = 0; i < elts_cnt; i++) { if (do_check == "invert"){ elts[i].checked == true ? elts[i].checked = false : elts[i].checked = true; } else { elts[i].checked = do_check; }}} else { elts.checked = do_check; }
	return true; }
	</script>
	<form method="post" action="' . append_sid("ignore_topics.$phpEx") . '" name="ignoreform">';
	$ignore_end = '<tr><td class="row1" colspan="' . $span_j . '" align="center" height="28"><span class="gensmall"><input type="submit" name="ignore" class="liteoption" value="' . $lang['ignore_mark'] . '"' . $title_style . ' />&nbsp;<a href="#" onclick="setCheckboxes(\'ignoreform\', true); return false;">' . $lang['Mark_all'] . '</a></span></td></tr>';
	$ignore_end_form = '</form>';
}
else
{
	$ignore_begin = '';
	$ignore_end = '';
	$ignore_end_form = '';
}

$template->assign_vars(array(
	'FORUM_ID' => $forum_id,
	'FORUM_NAME' => $forum_row['forum_name'],
	'U_INDEX' => $u_index_check,
	'MODERATORS' => $forum_moderators,
	'POST_IMG' => ($forum_row['forum_status'] == FORUM_LOCKED) ? $images['post_locked'] : $images['post_new'],
	'FOLDER_IMG' => $images['folder'],
	'FOLDER_NEW_IMG' => $images['folder_new'],
	'FOLDER_HOT_IMG' => $images['folder_hot'],
	'FOLDER_HOT_NEW_IMG' => $images['folder_hot_new'],
	'FOLDER_LOCKED_IMG' => $images['folder_locked'],
	'FOLDER_LOCKED_NEW_IMG' => $images['folder_locked_new'],
	'FOLDER_STICKY_IMG' => $images['folder_sticky'],
	'FOLDER_STICKY_NEW_IMG' => $images['folder_sticky_new'],
	'FOLDER_ANNOUNCE_IMG' => $images['folder_announce'],
	'FOLDER_ANNOUNCE_NEW_IMG' => $images['folder_announce_new'],
	'FOLDER_GLOBAL_ANNOUNCE_IMG' => $images['folder_global_announce'],
	'FOLDER_GLOBAL_ANNOUNCE_NEW_IMG' => $images['folder_global_announce_new'],
	'IGNORE_END' => $ignore_end,
	'IGNORE_END_FORM' => $ignore_end_form,
	'IGNORE_BEGIN' => $ignore_begin,
	'SPAN_I' => $span_i,
	'SPAN_J' => $span_j,
	'ICON_BOX1' => $icon_box1,
	'ICON_BOX2' => $icon_box2,

	'L_TOPICS' => $lang['Topics'],
	'L_REPLIES' => $lang['Replies'],
	'L_VIEWS' => $lang['Views'],
	'L_POSTS' => $lang['Posts'],
	'L_LASTPOST' => $lang['Last_Post'],
	'L_MODERATOR' => $l_moderators,
	'L_MARK_TOPICS_READ' => $lang['Mark_all_topics'],
	'L_POST_NEW_TOPIC' => ($forum_row['forum_status'] == FORUM_LOCKED) ? $lang['Forum_locked'] : $lang['Post_new_topic'],
	'L_NO_NEW_POSTS' => $lang['No_new_posts'],
	'L_NEW_POSTS' => $lang['New_posts'],
	'L_NO_NEW_POSTS_LOCKED' => $lang['No_new_posts_locked'],
	'L_NEW_POSTS_LOCKED' => $lang['New_posts_locked'],
	'L_NO_NEW_POSTS_HOT' => $lang['No_new_posts_hot'],
	'L_NEW_POSTS_HOT' => $lang['New_posts_hot'],
	'L_ANNOUNCEMENT' => $lang['Post_Announcement'],
	'L_GLOBAL_ANNOUNCEMENT' => $lang['Post_global_announcement'],
	'L_STICKY' => $lang['Post_Sticky'],
	'L_POSTED' => $lang['Posted'],
	'L_JOINED' => $lang['Joined'],
	'L_AUTHOR' => $lang['Author'],

	'S_AUTH_LIST' => $s_auth_can,
	'U_VIEW_FORUM' => append_sid("viewforum.$phpEx?" . POST_FORUM_URL ."=$forum_id"),
	'U_MARK_READ' => append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id&amp;mark=topics"))
);

// End header
if ( $board_config['csearch'] )
{
	$template->assign_block_vars('switch_search_for', array());
}
$template->assign_vars(array(
	'SEARCH_ACTION' => 'search.'.$phpEx.'?mode=results',
	'L_SEARCH_FOR' => $lang['Search_for'],
	'L_SUBMIT_SEARCH' => $lang['Search'])
);

// Okay, lets dump out the page ...
if( $total_topics )
{
	// BEGIN fetch additional topic data
	$topic_id_list = array();
	for($i = 0; $i < $total_topics; $i++)
	{
		$topic_id_list[] = $topic_rowset[$i]['topic_id'];
	}
	$topic_id_list = implode(',', $topic_id_list);
	$helped_list = array();
	if ( $board_config['helped'] )
	{
		$sql = "SELECT topic_id
			FROM " . POSTS_TABLE . "
			WHERE topic_id IN ($topic_id_list)
				AND post_marked = 'y'
			GROUP BY topic_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain marked posts information', '', __LINE__, __FILE__, $sql);
		}
		while( $row = $db->sql_fetchrow($result) )
		{
			$helped_list[$row['topic_id']] = true;
		}
	}
	if( $userdata['session_logged_in'] )
	{
		get_poster_topic_posts(explode(',', $topic_id_list), $userdata['user_id']);
		if( $board_config['read_tracking'] )
		{
			$smart_new_topics = smart_get_new_topics($topic_id_list);
			$sql = "SELECT topic_id, COUNT(user_id) AS total
					FROM ". READ_HIST_TABLE ."
					WHERE user_id = " . $userdata['user_id'] . "
						AND topic_id IN ($topic_id_list)
					GROUP BY topic_id";
		}
		else
		{
			$sql = "SELECT topic_id, COUNT(post_id) as total
				FROM " . POSTS_TABLE . "
				WHERE post_time >= " . $userdata['user_lastvisit'] . "
					AND topic_id IN ($topic_id_list)
				GROUP BY topic_id";
		}
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain unread posts information', '', __LINE__, __FILE__, $sql);
		}
		$unread_posts = array();
		$topic_id_list = array();
		while( $row = $db->sql_fetchrow($result) )
		{
			$unread_posts[$row['topic_id']] = $row['total'];
			$topic_id_list[] = $row['topic_id'];
		}
		$ur_treplies = array();
		if( count($topic_id_list) > 0 )
		{
			$topic_id_list = implode(',', $topic_id_list);
			$sql = "SELECT topic_id, topic_replies
				FROM " . TOPICS_TABLE . "
				WHERE topic_id IN ($topic_id_list)";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not obtain topic replies information', '', __LINE__, __FILE__, $sql);
			}
			while( $row = $db->sql_fetchrow($result) )
			{
				$ur_treplies[$row['topic_id']] = $row['topic_replies'];
			}
		}
	}
	// END fetch additional topic data

	for($i = 0; $i < $total_topics; $i++)
	{
		$topic_id = $topic_rowset[$i]['topic_id'];
		$topic_vote = $topic_rowset[$i]['topic_vote'];

		// Begin expires mod
		if ( $board_config['expire'] )
		{
			$topic_end = $topic_rowset[$i]['topic_time'] + $topic_rowset[$i]['topic_expire'];
			$topic_expire_date = ($topic_rowset[$i]['topic_expire'] == 0) ? '' : '<br />' . $lang['topic_expire'] . ' ' . @date ("m.d, H:i",$topic_end);
			if ( time() > $topic_end && $topic_rowset[$i]['topic_expire'] > 0)
			{
				require_once($phpbb_root_path . 'includes/functions_remove.' . $phpEx);
				delete_topic($topic_id, $forum_id, true);
			}
		}
		// End expires mod

		if (!$board_config['show_badwords'])
		{
			$topic_title = (count($orig_word)) ? preg_replace($orig_word, $replacement_word, $topic_rowset[$i]['topic_title']) : $topic_rowset[$i]['topic_title'];
			$topic_title_e = (count($orig_word)) ? preg_replace($orig_word, $replacement_word, $topic_rowset[$i]['topic_title_e']) : $topic_rowset[$i]['topic_title_e'];
		}
		else
		{
			$topic_title = $topic_rowset[$i]['topic_title'];
			replace_bad_words($orig_word, $replacement_word, $topic_title);
			$topic_title_e = $topic_rowset[$i]['topic_title_e'];
			replace_bad_words($orig_word, $replacement_word, $topic_title_e);
		}

		$replies = $topic_rowset[$i]['topic_replies'];

		$topic_type = $topic_rowset[$i]['topic_type'];
		if ( $topic_rowset[$i]['topic_icon'] == 0 )
		{
			$icon = ' ';
		}
		else
		{
			$icon = '<img src="' . $images['rank_path'] . 'icon/icon' . $topic_rowset[$i]['topic_icon']. '.gif" alt="' . $lang['messageicon'] . '" border="0">';
		}

		if( $topic_type == POST_ANNOUNCE )
		{
			$topic_type = $lang['Topic_Announcement'] . ' ';
		}
		else if( $topic_type == POST_GLOBAL_ANNOUNCE )
		{
			$topic_type = $lang['Topic_global_announcement'] . ' ';
		}
		else if( $topic_type == POST_STICKY )
		{
			$topic_type = $lang['Topic_Sticky'] . ' ';
		}
		else
		{
			$topic_type = '';
		}

		if( $topic_rowset[$i]['topic_vote'] )
		{
			$topic_type .= $lang['Topic_Poll'] . ' ';
		}
		
		if( $topic_rowset[$i]['topic_status'] == TOPIC_MOVED )
		{
			$topic_type = $lang['Topic_Moved'] . ' ';
			$topic_id = $topic_rowset[$i]['topic_moved_id'];

			$folder_image = $images['folder'];
			$folder_alt = $lang['Topics_Moved'];
			$newest_post_img = '';
		}
		else
		{
			if( $topic_rowset[$i]['topic_type'] == POST_GLOBAL_ANNOUNCE ) 
			{ 
				$folder = $images['folder_global_announce'];
				$folder_new = $images['folder_global_announce_new'];
			}
			else
			if( $topic_rowset[$i]['topic_type'] == POST_ANNOUNCE )
			{
				$folder = $images['folder_announce'];
				$folder_new = $images['folder_announce_new'];
			}
			else if( $topic_rowset[$i]['topic_type'] == POST_STICKY )
			{
				$folder = $images['folder_sticky'];
				$folder_new = $images['folder_sticky_new'];
			}
			else if( $topic_rowset[$i]['topic_status'] == TOPIC_LOCKED )
			{
				$folder = $images['folder_locked'];
				$folder_new = $images['folder_locked_new'];
			}
			else
			{
				if($replies >= $userdata['user_hot_threshold'])
				{
					$folder = $images['folder_hot'];
					$folder_new = $images['folder_hot_new'];
				}
				else
				{
					$folder = $images['folder'];
					$folder_new = $images['folder_new'];
				}
			}

			$newest_post_img = '';
			if( $userdata['session_logged_in'] )
			{
				if ( $board_config['read_tracking'] )
				{
					if( in_array($topic_id, $smart_new_topics) )
					{
						$folder_image = $folder_new;
						$folder_alt = $lang['New_posts'];

						if ( !$board_config['newest'] )
						{
							$newest_post_img = '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=newest") . '"><img src="' . $images['icon_newest_reply'] . '" alt="' . $lang['View_newest_post'] . '" title="' . $lang['View_newest_post'] . '" border="0" /></a> ';
						}
					}
					else
					{
						$folder_image = $folder;
						$folder_alt = ($topic_rowset[$i]['topic_status'] == TOPIC_LOCKED) ? $lang['Topic_locked'] : $lang['No_new_posts'];

						$newest_post_img = '';
					}
				}
				else
				{
					if ( $topic_rowset[$i]['post_time'] > $userdata['user_lastvisit'] ) 
					{
						if ( !empty($tracking_topics) || !empty($tracking_forums) || isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) )
						{
							$unread_topics = true;

							if ( !empty($tracking_topics[$topic_id]) )
							{
								if ( $tracking_topics[$topic_id] >= $topic_rowset[$i]['post_time'] )
								{
									$unread_topics = false;
								}
							}

							if ( !empty($tracking_forums[$forum_id]) )
							{
								if ( $tracking_forums[$forum_id] >= $topic_rowset[$i]['post_time'] )
								{
									$unread_topics = false;
								}
							}

							if ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) )
							{
								if ( $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all'] >= $topic_rowset[$i]['post_time'] )
								{
									$unread_topics = false;
								}
							}

							if ( $unread_topics )
							{
								$folder_image = $folder_new;
								$folder_alt = $lang['New_posts'];

								$newest_post_img = '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=newest") . '"><img src="' . $images['icon_newest_reply'] . '" alt="' . $lang['View_newest_post'] . '" title="' . $lang['View_newest_post'] . '" border="0" /></a> ';
							}
							else
							{
								$folder_image = $folder;
								$folder_alt = ($topic_rowset[$i]['topic_status'] == TOPIC_LOCKED) ? $lang['Topic_locked'] : $lang['No_new_posts'];

								$newest_post_img = '';
							}
						}
						else
						{
							$folder_image = $folder_new;
							$folder_alt = ($topic_rowset[$i]['topic_status'] == TOPIC_LOCKED) ? $lang['Topic_locked'] : $lang['New_posts'];

							$newest_post_img = '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=newest") . '"><img src="' . $images['icon_newest_reply'] . '" alt="' . $lang['View_newest_post'] . '" title="' . $lang['View_newest_post'] . '" border="0" /></a> ';
						}
					}
					else 
					{
						$folder_image = $folder;
						$folder_alt = ($topic_rowset[$i]['topic_status'] == TOPIC_LOCKED) ? $lang['Topic_locked'] : $lang['No_new_posts'];

						$newest_post_img = '';
					}
				}
			}
			else
			{
				$folder_image = $folder;
				$folder_alt = ($topic_rowset[$i]['topic_status'] == TOPIC_LOCKED) ? $lang['Topic_locked'] : $lang['No_new_posts'];

				$newest_post_img = '';
			}
		}

		if ( ( $replies + 1 ) > $user_posts_per_page )
		{
			$total_pages = ceil( ($replies + 1) / $user_posts_per_page );
			$goto_page = ' [ <img src="' . $images['icon_gotopost'] . '" alt="' . $lang['Goto_page'] . '" title="' . $lang['Goto_page'] . '" />' . $lang['Goto_page'] . ': ';
			$times = 1;
			for($j = 0; $j < $replies + 1; $j += $user_posts_per_page)
			{
				$goto_page .= '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=" . $topic_id . "&amp;start=$j") . '">' . $times . '</a>';
				if ( $times == 1 && $total_pages > 4 )
				{
					$goto_page .= ' ... ';
					$times = $total_pages - 3;
					$j += ($total_pages - 4) * $user_posts_per_page;
				}
				else if ( $times < $total_pages )
				{
					$goto_page .= ', ';
				}
				$times++;
			}
			$goto_page .= ' ] ';
		}
		else
		{
			$goto_page = '';
		}

		$get_unread_posts = '';
		if ( $userdata['session_logged_in'] )
		{
			$get_unread_posts = ( isset($unread_posts[$topic_id]) )
				? $unread_posts[$topic_id] : '';
			$unread_topic_replies = '';
			if ($get_unread_posts)
			{
				$unread_topic_replies = $ur_treplies[$topic_id];
			}
		}

		if ( $userdata['session_logged_in'] && $board_config['newest'] && $board_config['read_tracking'] && $topic_rowset[$i]['topic_status'] != TOPIC_MOVED )
		{
			$view_topic_url = ($unread_topic_replies >= 1) ? append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=newest") . '"' : append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id");
		} 
		else
		{
			$view_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id");
		}

		$topic_author = ($topic_rowset[$i]['user_id'] != ANONYMOUS) ? '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $topic_rowset[$i]['user_id']) . '">' : '';
		$topic_author .= ($topic_rowset[$i]['user_id'] != ANONYMOUS) ? $topic_rowset[$i]['username'] : ( ( $topic_rowset[$i]['post_username'] != '' ) ? $topic_rowset[$i]['post_username'] : $lang['Guest'] );
		$topic_author .= ($topic_rowset[$i]['user_id'] != ANONYMOUS) ? '</a>' : '';
		$topic_start_dateformat = ($board_config['topic_start_dateformat']) ? $board_config['topic_start_dateformat'] : $board_config['default_dateformat'];
		$topic_author .= ($board_config['topic_start_date']) ? '</span><br /><span class="copyright">' . create_date($topic_start_dateformat, $topic_rowset[$i]['topic_time'], $board_config['board_timezone']) . '' : '';
		
		$first_post_time = create_date($board_config['default_dateformat'], $topic_rowset[$i]['topic_time'], $board_config['board_timezone']);
		$last_post_time = create_date($board_config['default_dateformat'], $topic_rowset[$i]['post_time'], $board_config['board_timezone']);

		$last_post_author = ($topic_rowset[$i]['id2'] == ANONYMOUS) ? (($topic_rowset[$i]['post_username2'] != '') ? $topic_rowset[$i]['post_username2'] . ' ' : $lang['Guest'] . ' ' ) : '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $topic_rowset[$i]['id2']) . '">' . $topic_rowset[$i]['user2'] . '</a>';
		$last_post_url = '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . '=' . $topic_rowset[$i]['topic_last_post_id']) . '#' . $topic_rowset[$i]['topic_last_post_id'] . '"><img src="' . $images['icon_latest_reply'] . '" alt="' . $lang['View_latest_post'] . '" title="' . $lang['View_latest_post'] . '" border="0" /></a>';

		$views = $topic_rowset[$i]['topic_views'];
		
		if ( $userdata['session_logged_in'] )
		{
			$unread_posts_topic = $title_style = $topic_add_title = $poster_posts = $last_replys = $if_replys_last_post = $if_poster_posts = '';
			$poster_posts = get_poster_topic_posts($topic_id, $userdata['user_id']);
			$standart_title = ($poster_posts) ? '" title="' . $lang['poster_posts'] . ', ' . $lang['your_posts'] . ': ' . $poster_posts : '';

			if ( $poster_posts )
			{
				$lang_poster_posts = ($board_config['overlib']) ? $lang['poster_posts'] : '';
				$topic_add_title = ($board_config['poster_posts']) ? '&#164; ' : '';
				$if_poster_posts = $lang['your_posts'] . ': <b>' . $poster_posts . '</b><br />';
			}
			else
			{
				$lang_poster_posts = ($board_config['overlib']) ? $lang['not_poster_post'] : '';
			}

			if ($board_config['overlib'])
			{
				$unread_posts_topic = '';
				if ( $board_config['read_tracking'] )
				{
					$lang_posts = $lang['unread_posts'];
					if ($get_unread_posts > 0) $unread_posts_topic = $get_unread_posts;
				}
				else
				{
					$lang_posts = $lang['posts_last_visit'];
					if ( $get_unread_posts > 0)
					{
						$unread_posts_topic = $get_unread_posts;
					}
				}
				$last_replys = ($poster_posts) ? get_posts_last_reply($topic_id, $userdata['user_id']) : '';
				$if_replys_last_post = ($last_replys > 0) ? $lang['replys_last_post'] . ': <b>' . $last_replys . '</b><br />' : '';
				$if_unread_post = ($unread_posts_topic) ? $lang_posts . ': <b>' . $unread_posts_topic : '';
			}

			$title_style = ($board_config['overlib'] && ($poster_posts || $unread_posts_topic)) ? '" onMouseOver="return overlib(\'<left>' . $if_poster_posts . $if_replys_last_post . $if_unread_post . '</left>\', ol_width=300, ol_offsetx=10, ol_offsety=10, CAPTION, \'<center>' . $lang_poster_posts . '</center>\')" onMouseOut="nd();' : $standart_title;
			$topic_title = $topic_add_title . $topic_title;
			$view_topic_url = $view_topic_url . $title_style;
		}

		if ( !$board_config['color_topics'] && $topic_rowset[$i]['topic_color'] != '' )
		{
			$topic_title = '<span style="color: ' . $topic_rowset[$i]['topic_color'] . '">' . $topic_title . '</span>';
		}

		$topic_title_e = $topic_rowset[$i]['topic_title_e'];

		if ( $forum_moderate && !$topic_rowset[$i]['approve_post'] )
		{
			if ( $topic_rowset[$i]['approve_poster'] == $userdata['user_id'] || $is_auth['auth_mod'] )
			{
				$topic_title = $topic_title . '<br /><i><b>' . $lang['Post_no_approved'] . '</b></i>';
				$topic_title_e = '';
			}
			else
			{
				$topic_title = '<i><b>' . $lang['Post_no_approved'] . '</b></i>';
				$topic_author = $last_post_time = $last_post_author = $last_post_url = $topic_title_e = '';
			}
		}
			
		$template->assign_block_vars('topicrow', array(
			'ICON' => $icon,
			'TOPIC_EXPIRE' => $topic_expire_date,
			'ROW_COLOR' => (!($i % 2)) ? $theme['td_color1'] : $theme['td_color2'],
			'ROW_CLASS' => (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'],
			'ROW' => (isset($helped_list[$topic_id])) ? 'row_helped' : 'row1',
			'FORUM_ID' => $forum_id,
			'TOPIC_ID' => $topic_id,
			'TOPIC_FOLDER_IMG' => $folder_image,
			'TOPIC_AUTHOR' => $topic_author,
			'GOTO_PAGE' => $goto_page,
			'REPLIES' => $replies,
			'NEWEST_POST_IMG' => $newest_post_img,
			'TOPIC_ATTACHMENT_IMG' => ( defined('ATTACHMENTS_ON') ) ? topic_attachment_image($topic_rowset[$i]['topic_attachment']) : '',
			'TOPIC_TITLE' => $topic_title,
			'TOPIC_TITLE_E' => ($topic_title_e && $board_config['title_explain']) ? '<br />' . $topic_title_e : '',
			'IGNORE_CHECKBOXES' => ($board_config['ignore_topics'] && $userdata['session_logged_in'] && $userdata['view_ignore_topics']) ? '<td class="row1" align="right"><input type="checkbox" name="list_ignore[]" value="' . $topic_id . '" /></td>' : '',
			'TOPIC_TYPE' => $topic_type,
			'VIEWS' => $views,
			'FIRST_POST_TIME' => $first_post_time, 
			'LAST_POST_TIME' => $last_post_time, 
			'LAST_POST_AUTHOR' => $last_post_author, 
			'LAST_POST_IMG' => $last_post_url, 
			'L_TOPIC_FOLDER_ALT' => $folder_alt, 
			'U_VIEW_TOPIC' => $view_topic_url)
		);
	}

	$topics_count -= $total_announcements;

	$template->assign_vars(array(
		'PAGINATION' => generate_pagination("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id&amp;topicdays=$topic_days", $topics_count, $user_topics_per_page, $start),
		'PAGE_NUMBER' => (ceil( $topics_count / $user_topics_per_page ) <= 1) ? '' : sprintf($lang['Page_of'], ( floor( $start / $user_topics_per_page ) + 1 ), ceil( $topics_count / $user_topics_per_page )),
		'L_GOTO_PAGE' => $lang['Goto_page'])
	);
}
else
{
	// No topics
	$no_topics_msg = ( $forum_row['forum_status'] == FORUM_LOCKED ) ? $lang['Forum_locked'] : $lang['No_topics_post_one'];

	$template->assign_vars(array(
		'L_NO_TOPICS' => $no_topics_msg)
	);

	$template->assign_block_vars('switch_no_topics', array() );

}

// Parse the page and print
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>