<?php
/***************************************************************************
 *							viewtopic.php
 *							-------------------
 *	begin					: Saturday, Feb 13, 2001
 *	copyright			: (C) 2001 The phpBB Group
 *	email					: support@phpbb.com
 *
 *	modification 		: (C) 2005 Przemo http://www.przemo.org
 *	date modification	: ver. 1.9 2004/04/01 21:11
 *
 ***************************************************************************/

/***************************************************************************
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 ***************************************************************************/

define('IN_PHPBB', true);
define('PORTAL', true);
define('ATTACH', true);
$phpbb_root_path = './';

if ( isset($HTTP_GET_VARS['sleep']) && $_SERVER['REQUEST_URI'] && $_SERVER['HTTP_HOST'] )
{
	$url = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

	$url = substr($url, 0 ,strpos($url, 'sleep=') - strlen(6));

	if ( !empty($db) )
	{
		$db->sql_close();
	}

	if (strstr(urldecode($url), "\n") || strstr(urldecode($url), "\r"))
	{
		exit;
	}
	if ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) )
	{
		header('Refresh: ' . intval($HTTP_GET_VARS['sleep']) . '; URL=' . $url);
	}
	echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="' . intval($HTTP_GET_VARS['sleep']) . '; url=' . $url . '"><title>Redirect</title></head><body><div align="center">If your browser does not support meta redirection please click <a href="' . $url . '">HERE</a> to be redirected</div></body></html>';
	exit;
}

include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);

if ( $board_config['read_tracking'] )
{
	include($phpbb_root_path . 'includes/read_history.'.$phpEx);
}

// Start initial var setup
$topic_id = $post_id = 0;

if ( isset($HTTP_GET_VARS[POST_TOPIC_URL]) )
{
	$topic_id = intval($HTTP_GET_VARS[POST_TOPIC_URL]);
}
else if ( isset($HTTP_GET_VARS['topic']) )
{
	$topic_id = intval($HTTP_GET_VARS['topic']);
}

if ( isset($HTTP_GET_VARS[POST_POST_URL]))
{
	$post_id = intval($HTTP_GET_VARS[POST_POST_URL]);
}

$start = (isset($HTTP_GET_VARS['start'])) ? intval($HTTP_GET_VARS['start']) : 0;

$post_bypass = (!isset($HTTP_GET_VARS['bypass'])) ? 0 : $HTTP_GET_VARS['bypass'];

if ( $board_config['read_tracking'] )
{
	if ( isset($HTTP_GET_VARS['unmark']) || isset($HTTP_POST_VARS['unmark']) )
	{
		$mark_unread = (isset($HTTP_POST_VARS['unmark'])) ? $HTTP_POST_VARS['unmark'] : $HTTP_GET_VARS['unmark'];
	}
	else
	{
		$mark_unread = '';
	}
}

if ( !isset($topic_id) && !isset($post_id) )
{
	message_die(GENERAL_MESSAGE, 'Topic_post_not_exist');
}

// Find topic id if user requested a newer
// or older topic
if ( isset($HTTP_GET_VARS['view']) && empty($HTTP_GET_VARS[POST_POST_URL]) )
{
	if ( $HTTP_GET_VARS['view'] == 'newest' )
	{
		if ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid']) || isset($HTTP_GET_VARS['sid']) )
		{
			$session_id = isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid']) ? $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid'] : $HTTP_GET_VARS['sid'];

			if (!preg_match('/^[A-Za-z0-9]*$/', $session_id)) 
			{
				$session_id = '';
				$SID = "sid=$session_id";
			}

			if ( $session_id )
			{
				if ( $board_config['read_tracking'] )
				{
					$sql = "SELECT post_id
						FROM " . READ_HIST_TABLE . " rh, " . SESSIONS_TABLE . " s 
						WHERE s.session_id = '$session_id'
							AND s.session_user_id = rh.user_id
							AND rh.topic_id = $topic_id
						ORDER BY rh.post_time ASC
						LIMIT 1";
				}
				else
				{
					$sql = "SELECT p.post_id 
						FROM " . POSTS_TABLE . " p, " . SESSIONS_TABLE . " s, " . USERS_TABLE . " u 
						WHERE s.session_id = '$session_id' 
							AND u.user_id = s.session_user_id 
							AND p.topic_id = $topic_id 
							AND p.post_time >= u.user_lastvisit 
						ORDER BY p.post_time ASC 
						LIMIT 1";
				}
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not obtain newer/older topic information', '', __LINE__, __FILE__, $sql);
				}
				if ( !($row = $db->sql_fetchrow($result)) )
				{
					if ( $board_config['read_tracking'] )
					{
						redirect(append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id", true));
					}
					else
					{
						message_die(GENERAL_MESSAGE, 'No_new_posts_last_visit');
					}
				}
				$post_id = $row['post_id'];

				$sql = "SELECT post_id FROM " . POSTS_TABLE . "
					WHERE post_id = $post_id";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not get post_id from posts table', '', __LINE__, __FILE__, $sql);
				}

				if ( !$db->sql_affectedrows() )
				{
					if ( $board_config['read_tracking'] )
					{
						$sql = "DELETE FROM " . READ_HIST_TABLE . "
							WHERE post_id = $post_id";
						if ( !($result = $db->sql_query($sql)) )
						{
							message_die(GENERAL_ERROR, 'Could not delete post from read history table', '', __LINE__, __FILE__, $sql);
						}
					}
					$post_id = '';
				}

				if ( !$post_id )
				{
					redirect(append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id", true));
				}
				else
				{
					redirect(append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id", true) . "#$post_id");
				}
			}
		}
	}
	else if ( $HTTP_GET_VARS['view'] == 'next' || $HTTP_GET_VARS['view'] == 'previous' )
	{
		$sql_condition = ($HTTP_GET_VARS['view'] == 'next') ? '>' : '<';
		$sql_ordering = ($HTTP_GET_VARS['view'] == 'next') ? 'ASC' : 'DESC';

		$sql = "SELECT t.topic_id
			FROM " . TOPICS_TABLE . " t, " . TOPICS_TABLE . " t2
			WHERE t2.topic_id = $topic_id
				AND t.forum_id = t2.forum_id
				AND t.topic_last_post_id $sql_condition t2.topic_last_post_id
			ORDER BY t.topic_last_post_id $sql_ordering
			LIMIT 1";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain newer/older topic information', '', __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			$topic_id = intval($row['topic_id']);
		}
		else
		{
			$message = ( $HTTP_GET_VARS['view'] == 'next' ) ? 'No_newer_topics' : 'No_older_topics';
			message_die(GENERAL_MESSAGE, $message);
		}
	}
}

// This rather complex gaggle of code handles querying for topics but
// also allows for direct linking to a post (and the calculation of which
// page the post is on and the correct display of viewtopic)

$join_sql_table = (empty($post_id)) ? '' : ", " . POSTS_TABLE . " p, " . POSTS_TABLE . " p2 ";
$join_sql = (empty($post_id)) ? "t.topic_id = $topic_id" : "p.post_id = $post_id AND t.topic_id = p.topic_id AND p2.topic_id = p.topic_id AND p2.post_id <= $post_id";
$count_sql = (empty($post_id)) ? '' : ", COUNT(p2.post_id) AS prev_posts";

$order_sql = (empty($post_id)) ? '' : "GROUP BY p.post_id, t.topic_id, t.topic_title, t.topic_status, t.topic_replies, t.topic_time, t.topic_type, t.topic_vote, t.topic_last_post_id, f.forum_name, f.forum_status, f.forum_id, f.auth_view, f.auth_read, f.auth_post, f.auth_reply, f.auth_edit, f.auth_delete, f.auth_sticky, f.auth_announce, f.auth_pollcreate, f.auth_vote, f.auth_attachments, f.auth_download, t.topic_attachment ORDER BY p.post_id ASC";

$sql = "SELECT t.topic_id, t.topic_title, t.topic_poster, t.topic_status, t.topic_replies, t.topic_time, t.topic_type, t.topic_vote, t.topic_last_post_id, f.forum_name, f.forum_status, f.password, f.forum_id, f.auth_view, f.auth_read, f.auth_post, f.auth_reply, f.auth_edit, f.auth_delete, f.auth_sticky, f.auth_announce, f.auth_pollcreate, f.auth_vote, f.auth_attachments, f.auth_download, t.topic_attachment, f.forum_moderate, p3.post_approve AS topic_approve" . $count_sql . "
	FROM " . TOPICS_TABLE . " t, " . FORUMS_TABLE . " f, " . POSTS_TABLE . " p3" . $join_sql_table . " 
	WHERE $join_sql
		AND p3.post_id = topic_first_post_id
		AND f.forum_id = t.forum_id
	$order_sql";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain topic information', '', __LINE__, __FILE__, $sql);
}

if ( !($forum_topic_data = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, 'Topic_post_not_exist');
}

$forum_id = intval($forum_topic_data['forum_id']);
$topic_id = intval($forum_topic_data['topic_id']);
$forum_moderate = ($forum_topic_data['forum_moderate']) ? true : false;

// Start session management
$userdata = session_pagestart($user_ip, $forum_id, $topic_id);
init_userprefs($userdata);
// End session management

$user_level = $userdata['user_level'];
$user_id = $userdata['user_id'];
$session_id = $userdata['session_id'];
$session_logged_in = $userdata['session_logged_in'];

$user_posts_per_page = ($userdata['user_posts_per_page'] > 0) ? $userdata['user_posts_per_page'] : '15';

if ( $board_config['login_require'] && !$session_logged_in )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

$sql = "SELECT u.user_id, u.username 
	FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
	WHERE aa.forum_id = $forum_id
		AND aa.auth_mod = " . TRUE . "
		AND g.group_single_user = 1
		AND ug.group_id = aa.group_id
		AND g.group_id = aa.group_id
		AND u.user_id = ug.user_id
	GROUP BY u.user_id, u.username
	ORDER BY u.user_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
}

$moderators = array();
while( $row = $db->sql_fetchrow($result) )
{
	$moderators[] = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '">' . $row['username'] . '</a>';
}

$sql = "SELECT g.group_id, g.group_name 
	FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g
	WHERE aa.forum_id = $forum_id
		AND aa.auth_mod = " . TRUE . "
		AND g.group_single_user = 0
		AND g.group_type <> ". GROUP_HIDDEN ."
		AND ug.group_id = aa.group_id
		AND g.group_id = aa.group_id
	GROUP BY g.group_id, g.group_name
	ORDER BY g.group_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
}

while( $row = $db->sql_fetchrow($result) )
{
	$moderators[] = '<a href="' . append_sid("groupcp.$phpEx?" . POST_GROUPS_URL . "=" . $row['group_id']) . '">' . $row['group_name'] . '</a>';
}
	
$l_moderators = ( count($moderators) == 1 ) ? $lang['Moderator'] : $lang['Moderators'];
$forum_moderators = ( count($moderators) ) ? implode(', ', $moderators) : $lang['None'];
unset($moderators);

// Start auth check
$is_auth = array();
$is_auth = $tree['auth'][POST_FORUM_URL . $forum_id];

if ( !$is_auth['auth_read'] )
{
	if ( !$session_logged_in )
	{
		$redirect = ( isset($post_id) && $post_id != 0) ? POST_POST_URL . "=$post_id" : POST_TOPIC_URL . "=$topic_id";
		$redirect .= ( isset($start) ) ? '&amp;start=' . $start : '';
		redirect(append_sid("login.$phpEx?redirect=viewtopic.$phpEx&amp;$redirect", true));
	}

	$message = ( !$is_auth['auth_view'] ) ? $lang['Topic_post_not_exist'] : sprintf($lang['Sorry_auth_read'], $is_auth['auth_read_type']);
	message_die(GENERAL_MESSAGE, $message);
}
// End auth check

$forum_view_moderate = ($forum_moderate && !$is_auth['auth_mod']) ? true : false;

if ( $is_auth['auth_mod'] && ($HTTP_POST_VARS['accept_post'] || $HTTP_POST_VARS['reject_post']) )
{
	if ( $HTTP_POST_VARS['accept_post'] )
	{
		$accept_posts = $HTTP_POST_VARS['accept_post'];
		for($i = 0; $i < count($accept_posts); $i++)
		{
			if ( !(@in_array($accept_posts[$i], $HTTP_POST_VARS['reject_post'])) )
			{
				$sql = "UPDATE " . POSTS_TABLE . "
					SET post_approve = 1
						WHERE post_id = " . intval($accept_posts[$i]);
				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Error in approve post', '', __LINE__, __FILE__, $sql);
				}
			}
		}
	}
	if ( $HTTP_POST_VARS['reject_post'] )
	{
		require_once($phpbb_root_path . 'includes/functions_remove.' . $phpEx);
		$reject_posts = $HTTP_POST_VARS['reject_post'];
		for($i = 0; $i < count($reject_posts); $i++)
		{
			if ( !(@in_array($reject_posts[$i], $HTTP_POST_VARS['accept_post'])) )
			{
				delete_post(intval($reject_posts[$i]));
			}
		}
	}
}

// Password check
if ( $forum_topic_data['password'] != '' )
{
	if ( !$is_auth['auth_mod'] || $user_level != ADMIN )
	{
		$redirect = str_replace('&amp;', '&', preg_replace('#.*?([a-z]+?\.' . $phpEx . '.*?)$#i', '\1', htmlspecialchars($_SERVER['REQUEST_URI'])));
		$cookie_forum_pass = $board_config['cookie_name'] . '_fpass_' . $forum_id;
		if ( $HTTP_POST_VARS['cancel'] )
		{
			redirect(append_sid("index.$phpEx"));
		}
		else if ( $HTTP_POST_VARS['submit'] )
		{
			password_check($forum_id, $HTTP_POST_VARS['password'], $redirect);
		}

		if ( ($forum_topic_data['password'] != '') && ($HTTP_COOKIE_VARS[$cookie_forum_pass] != md5($forum_topic_data['password'])) )
		{
			password_box($forum_id, $redirect);
		}
	}
}
// END Password check

if ( isset($HTTP_GET_VARS['unmark']) && $HTTP_GET_VARS['sid'] != $session_id )
{
	message_die(GENERAL_ERROR, 'Invalid_session');
}

if ( $board_config['read_tracking'] )
{
	if ( $mark_unread == 'topic' )
	{
		if ( isset($HTTP_GET_VARS['unmark']) && $HTTP_GET_VARS['sid'] != $session_id )
		{
			message_die(GENERAL_ERROR, 'Invalid_session');
		}

		$sql = "SELECT user_id from " . READ_HIST_TABLE . "
			WHERE topic_id = $topic_id
				AND forum_id = $forum_id 
				AND user_id = $user_id";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error in checking Unrestricted forum read hist table', '', __LINE__, __FILE__, $sql);
		}
		$row = $db->sql_fetchrow($result);

		if ( mysql_num_rows($result)==0 )
		{
			$current_time = time();
			$sql = "INSERT DELAYED INTO " . READ_HIST_TABLE . "
				" . "(user_id, forum_id, topic_id, post_time) " . "
				SELECT DISTINCT user_id, $forum_id, $topic_id, $current_time " . "
				FROM " . USERS_TABLE . " " . "
				WHERE user_id = $user_id";

			if ( !$db->sql_query($sql) )
			{
				 message_die(GENERAL_ERROR, 'Error in submit of Unrestricted forum', '',__LINE__, __FILE__, $sql);
			}
		}
	}
}

if ( $board_config['who_viewed'] )
{
	if ( !(!$board_config['hide_viewed_admin'] && $user_level == ADMIN) )
	{
		$sql = "UPDATE " . TOPIC_VIEW_TABLE . "
			SET topic_id = $topic_id, view_time = " . time() . ", view_count = view_count + 1
			WHERE topic_id = $topic_id
				AND user_id = $user_id";

		if ( !$db->sql_query($sql) || !$db->sql_affectedrows() )
		{
			$sql = "INSERT IGNORE INTO " . TOPIC_VIEW_TABLE . " (topic_id, user_id, view_time, view_count)
				VALUES ($topic_id, $user_id, " . time() . ", 1)";

			if ( !($db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Error create user view topic information ', '', __LINE__, __FILE__, $sql);
			}
		}
	}
}

$forum_name = get_object_lang(POST_FORUM_URL . $forum_topic_data['forum_id'], 'name');
$topic_title = $forum_topic_data['topic_title'];
$topic_id = intval($forum_topic_data['topic_id']);
$topic_time = $forum_topic_data['topic_time'];

if ( !empty($post_id) )
{
	$start = floor(($forum_topic_data['prev_posts'] - 1) / $user_posts_per_page) * $user_posts_per_page;
}

// Is user watching this thread?
if ( $session_logged_in )
{
	$can_watch_topic = true;

	$sql = "SELECT notify_status
		FROM " . TOPICS_WATCH_TABLE . "
		WHERE topic_id = $topic_id
			AND user_id = $user_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain topic watch information', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		if ( isset($HTTP_GET_VARS['unwatch']) )
		{
			if ( $HTTP_GET_VARS['sid'] != $session_id )
			{
				message_die(GENERAL_ERROR, 'Invalid_session');
			}

			if ( $HTTP_GET_VARS['unwatch'] == 'topic' )
			{
				$is_watching_topic = 0;

				$sql_priority = (SQL_LAYER == 'mysql') ? 'LOW_PRIORITY' : '';
				$sql = "DELETE $sql_priority FROM " . TOPICS_WATCH_TABLE . "
					WHERE topic_id = $topic_id
					AND user_id = $user_id";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not delete topic watch information', '', __LINE__, __FILE__, $sql);
				}
			}
			
			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">')
			);

			$message = $lang['No_longer_watching'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
		else
		{
			$is_watching_topic = true;

			if ( $row['notify_status'] )
			{
				$sql_priority = (SQL_LAYER == 'mysql') ? 'LOW_PRIORITY' : '';
				$sql = "UPDATE $sql_priority " . TOPICS_WATCH_TABLE . "
					SET notify_status = 0
					WHERE topic_id = $topic_id
						AND user_id = $user_id";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not update topic watch information', '', __LINE__, __FILE__, $sql);
				}
			}
		}
	}
	else
	{
		if ( isset($HTTP_GET_VARS['watch']) )
		{
			if ( $HTTP_GET_VARS['watch'] == 'topic' )
			{
				if ( $HTTP_GET_VARS['sid'] != $session_id )
				{
					message_die(GENERAL_ERROR, 'Invalid_session');
				}

				$is_watching_topic = true;

				$sql_priority = (SQL_LAYER == 'mysql') ? 'LOW_PRIORITY' : '';
				$sql = "INSERT $sql_priority INTO " . TOPICS_WATCH_TABLE . " (user_id, topic_id, notify_status)
					VALUES ($user_id, $topic_id, 0)";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not insert topic watch information', '', __LINE__, __FILE__, $sql);
				}
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">')
			);

			$message = $lang['You_are_watching'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
		else
		{
			$is_watching_topic = 0;
		}
	}
}
else
{
	if ( isset($HTTP_GET_VARS['unwatch']) )
	{
		if ( $HTTP_GET_VARS['unwatch'] == 'topic' )
		{
			redirect(append_sid("login.$phpEx?redirect=viewtopic.$phpEx&amp;" . POST_TOPIC_URL . "=$topic_id&amp;unwatch=topic", true));
		}
	}
	else
	{
		$can_watch_topic = 0;
		$is_watching_topic = 0;
	}
}

// Begin Helped
if ( $board_config['helped'] )
{
	if ( strstr($board_config['helped_forums'], ',') )
	{
		$hpd_ids = explode(',', $board_config['helped_forums']);
		
		while( list($foo_hpdf, $id_hpdf) = each($hpd_ids) )
		{
			$fid_hpdf[] = intval( trim($id_hpdf) );
		}
	}
	else
	{
		$fid_hpdf[] = intval( trim($board_config['helped_forums']) );
	}
	reset($fid_hpdf);

	$do_helped = (in_array($forum_id, $fid_hpdf) == false) ? true : false;
}

$rank = '';
if ( isset($_GET['p_add']) && $board_config['helped'] && $do_helped && $userdata['user_allow_helped'])
{
	$p_add = intval($_GET['p_add']);

	if ( !isset($_GET['c_add']) )
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['helped_confirm'], '<a href="' . append_sid("viewtopic.$phpEx?t=$topic_id&amp;p_add=$p_add&amp;c_add=1&amp;sid=$session_id") . '">', '</a>', '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$p_add#$p_add") . '">', '</a>'));
	}

	if ( $HTTP_GET_VARS['sid'] != $session_id )
	{
		message_die(GENERAL_ERROR, 'Invalid_session');
	}

	$sql = "SELECT post_marked, poster_id FROM " . POSTS_TABLE . "
		WHERE post_id = $p_add
		LIMIT 1";

	if ( $result = $db->sql_query($sql) )
	{
		$row = $db->sql_fetchrow($result);

		if ( $row['post_marked'] != 'y' && $row['poster_id'] != $userdata['user_id'])
		{
			$sql = "SELECT special_rank FROM " . USERS_TABLE . "
				WHERE user_id = " . $row['poster_id'];

			if ( $result = $db->sql_query($sql) ) 
			{
				$row2 = $db->sql_fetchrow($result); 

				$rank = ($row2['special_rank']) ? intval($row2['special_rank']) : 0;

				$sql3 = "SELECT topic_poster FROM " . TOPICS_TABLE . "
					WHERE topic_id = $topic_id
						AND topic_poster = " . $userdata['user_id'];

				if ( !($result3 = $db->sql_query($sql3)) )
				{
					message_die(GENERAL_ERROR, 'Could not query topics table', '', __LINE__, __FILE__, $sql3);
				}
				if ( !($row3 = $db->sql_fetchrow($result3)) )
				{
					message_die(GENERAL_ERROR, $lang['Not_Authorised']);
				}

				$sql4 = "SELECT topic_id FROM " . POSTS_TABLE . "
				WHERE post_id = $p_add";

				if ( !($result4 = $db->sql_query($sql4)) )
				{
					message_die(GENERAL_ERROR, 'Could not query posts table', '', __LINE__, __FILE__, $sql4);
				}
				$row4 = $db->sql_fetchrow($result4);

				if ( $row4['topic_id'] != $topic_id )
				{
					message_die(GENERAL_ERROR, $lang['Not_Authorised']);
				}

				$sql = "UPDATE " . POSTS_TABLE . " SET post_marked = 'y'
					WHERE post_id = " . $p_add; 
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not query posts table', '', __LINE__, __FILE__, $sql);
				}

				$sql2 = "UPDATE " . USERS_TABLE . " SET special_rank = " . (++$rank) . "
					WHERE user_id = " . $row['poster_id'];

				if ( $db->sql_query($sql) && $db->sql_query($sql2) ) 
				{
					$template->assign_vars(array( 
						'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . '=' . $p_add) . '#' . $p_add .'">')
					); 

					$message = sprintf($lang['helped_added'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . '=' . $p_add) . '#' . $p_add . '">', '</a>');
					message_die(GENERAL_MESSAGE, $message); 
				} 
			} 
		} 
	} 
} 
// End Helped

// Generate a 'Show posts in previous x days' select box. If the postdays var is POSTed
// then get it's value, find the number of topics with dates newer than it (to properly
// handle pagination) and alter the main query
$valid = false;
if ( $session_logged_in )
{
	$sql = "SELECT p.poster_id, p.topic_id
		FROM " . POSTS_TABLE . " p
		WHERE p.topic_id = $topic_id
			AND p.poster_id = $user_id";

	$resultat = $db->sql_query($sql);
	$valid = $db->sql_numrows($resultat) ? true : false;
}

$previous_days = array(0, 15, 30, 60, 120, 360, 720, 1440, 2880, 4320, 5760, 7200, 8640, 10080, 20160, 43200, 129600, 259200, 524160);
$previous_days_text = array($lang['All_Posts'], $lang['15_min'], $lang['30_min'], $lang['1_Hour'], $lang['2_Hour'], $lang['6_Hour'], $lang['12_Hour'], $lang['1_Day'], $lang['2_Days'], $lang['3_Days'], $lang['4_Days'], $lang['5_Days'], $lang['6_Days'], $lang['7_Days'], $lang['2_Weeks'], $lang['1_Month'], $lang['3_Months'], $lang['6_Months'], $lang['1_Year']);

if ( !empty($HTTP_POST_VARS['postdays']) || !empty($HTTP_GET_VARS['postdays']) )
{
	$post_days = (!empty($HTTP_POST_VARS['postdays'])) ? intval($HTTP_POST_VARS['postdays']) : intval($HTTP_GET_VARS['postdays']);
	$min_post_time = time() - ($post_days * 60);

	$sql = "SELECT COUNT(p.post_id) AS num_posts
		FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p
		WHERE t.topic_id = $topic_id 
			AND p.topic_id = t.topic_id 
			AND p.post_time >= $min_post_time";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain limited topics count information', '', __LINE__, __FILE__, $sql);
	}

	$total_replies = ($row = $db->sql_fetchrow($result)) ? $row['num_posts'] : 0;
	$limit_posts_time = "AND p.post_time >= $min_post_time ";
	if ( !empty($HTTP_POST_VARS['postdays']))
	{
		$start = 0;
	}
}
else
{
	$total_replies = $forum_topic_data['topic_replies'] + 1;

	$limit_posts_time = '';
	$post_days = 0;
}

$select_post_days = '<select name="postdays">';
for($i = 0; $i < count($previous_days); $i++)
{
	$selected = ($post_days == $previous_days[$i]) ? ' selected="selected"' : '';
	$select_post_days .= '<option value="' . $previous_days[$i] . '"' . $selected . '>' . $previous_days_text[$i] . '</option>';
}
$select_post_days .= '</select>';

// Decide how to order the post display
if ( !empty($HTTP_POST_VARS['postorder']) || !empty($HTTP_GET_VARS['postorder']) )
{
	$post_order = (!empty($HTTP_POST_VARS['postorder'])) ? htmlspecialchars($HTTP_POST_VARS['postorder']) : htmlspecialchars($HTTP_GET_VARS['postorder']);
	$post_time_order = ($post_order == 'asc') ? 'ASC' : 'DESC';
}
else
{
	$post_order = 'asc';
	$post_time_order = 'ASC';
}

$select_post_order = '<select name="postorder">';
if ( $post_time_order == 'ASC' )
{
	$select_post_order .= '<option value="asc" selected="selected">' . $lang['Oldest_First'] . '</option><option value="desc">' . $lang['Newest_First'] . '</option>';
}
else
{
	$select_post_order .= '<option value="asc">' . $lang['Oldest_First'] . '</option><option value="desc" selected="selected">' . $lang['Newest_First'] . '</option>';
}
$select_post_order .= '</select>';

$custom_fields_exists = (custom_fields('viewtopic', false, $forum_id)) ? true : false;

// Go ahead and pull all data for this topic
$sgv = '';
$sgv .= ($board_config['post_icon']) ? ', p.post_icon' : '';
$sgv .= ($board_config['cagent']) ? ', p.user_agent' : '';
$sgv .= (defined('ATTACHMENTS_ON')) ? ', p.post_attachment' : '';
$sgv .= ($board_config['expire']) ? ', p.post_expire' : '';
$sgv .= (!$board_config['report_disable']) ? ', p.reporter_id' : '';
$sgv .= ($do_helped) ? ', p.post_marked' : '';
$sgv .= ($board_config['allow_sig_image']) ? ', u.user_sig_image' : '';
$sgv .= ($board_config['cage']) ? ', u.user_birthday' : '';
$sgv .= ($board_config['cfrom']) ? ', u.user_from' : '';
$sgv .= ($board_config['clevell'] || $board_config['cleveld'] || $board_config['cjoin']) ? ', u.user_regdate' : '';
$sgv .= ($board_config['gender']) ? ', u.user_gender' : '';
$sgv .= ($board_config['cicq']) ? ', u.user_icq' : '';
$sgv .= ($board_config['cgg']) ? ', u.user_aim' : '';
$sgv .= ($board_config['cmsn']) ? ', u.user_msnm' : '';
$sgv .= ($board_config['cyahoo']) ? ', u.user_yim' : '';
$sgv .= ($do_helped) ? ', u.special_rank, u.user_allow_helped' : '';

$sgv .= ($board_config['custom_color_use'] || $board_config['custom_color_mod'] || $board_config['custom_color_view'] || $board_config['mod_nick_color']) ? ', u.can_custom_color, u.user_custom_color' : '';
$sgv .= ($board_config['allow_avatar_remote']) ? ', u.user_avatar_width, u.user_avatar_height' : '';

$fields_to_get = '';
if ( $custom_fields_exists )
{
	$custom_fields = custom_fields('', 'viewtopic', $forum_id);
	for($i = 0; $i < count($custom_fields[0]); $i++)
	{
		$split_field = 'u.user_field_' . $custom_fields[0][$i] . ', u.user_allow_field_' . $custom_fields[0][$i];
		$fields_to_get .= ', ' . $split_field;
	}
}
else
{
	$fields_to_get = '';
}

$sgv .= $fields_to_get . ', ';

$sql = "SELECT p.post_id, p.post_time, p.enable_sig, p.enable_html, p.enable_smilies, p.post_edit_count, p.post_edit_time, p.post_username, p.post_approve, p.poster_delete" . $sgv . "u.user_id, u.username, u.user_level, u.user_posts, u.user_allowsig, u.user_sig, u.user_sig_bbcode_uid, u.user_allowsmile, u.user_avatar_type, u.user_allowavatar, u.user_avatar, u.user_rank, u.user_viewemail, u.user_website, u.user_email, u.can_custom_ranks, u.user_custom_rank, pt.post_text, pt.bbcode_uid, pt.post_subject
	FROM " . POSTS_TABLE . " p, " . USERS_TABLE . " u, " . POSTS_TEXT_TABLE . " pt
	WHERE p.topic_id = $topic_id
		$limit_posts_time
		AND pt.post_id = p.post_id
		AND u.user_id = p.poster_id
	ORDER BY p.post_time $post_time_order
	LIMIT $start, $user_posts_per_page";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain post/user information.', '', __LINE__, __FILE__, $sql);
}

$postrow = array();
$posters_id = array();
$posts_id = array();
$poster_id_sql = '';
if ( $row = $db->sql_fetchrow($result) )
{
	do
	{
		$postrow[] = $row;
		if( !in_array($row['user_id'], $posters_id) )
		{
			$posters_id[] = $row['user_id'];
		}
		$posts_id[] = $row['post_id'];
		$poster_id_sql .= ($row['user_rank']) ? '' : ( ',' . $row['user_id'] );
	}
	while ( $row = $db->sql_fetchrow($result) );
	$db->sql_freeresult($result);

	$total_posts = count($postrow);
}
else
{
	require_once($phpbb_root_path . 'includes/functions_admin.' . $phpEx);
	sync('topic', $topic_id);
	message_die(GENERAL_MESSAGE, $lang['No_posts_topic']);
}
if ( $board_config['read_tracking'] )
{
	$new_posts = smart_get_new_topic_posts($topic_id, implode(',', $posts_id));
}
unset($posts_id);

// Get warnings for users
if ( $board_config['viewtopic_warnings'] && $board_config['warnings_enable'] )
{
	$sql = "SELECT userid, value
		FROM " . WARNINGS_TABLE . "
		WHERE userid IN (" . implode(',', $posters_id) . ")
			AND archive = '0'";
	$result = $db->sql_query($sql);

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query value info from warnings table', '', __LINE__, __FILE__, $sql);
	}
	$warnings = array();

	foreach( $posters_id as $poster_id )
	{
		$warnings[$poster_id] = 0;
	}
	while($row = $db->sql_fetchrow($result))
	{
		$warnings[$row['userid']] += $row['value'];
	}
}

$resync = false;
if ( $forum_topic_data['topic_replies'] + 1 < $start + count($postrow) )
{
	$resync = true;
}
else if ( $start + $user_posts_per_page > $forum_topic_data['topic_replies'] )
{
	$row_id = intval($forum_topic_data['topic_replies']) % intval($user_posts_per_page);
	if ( $postrow[$row_id]['post_id'] != $forum_topic_data['topic_last_post_id'] || $start + count($postrow) < $forum_topic_data['topic_replies'] )
	{
		$resync = true;
	}
}
else if ( count($postrow) < $user_posts_per_page )
{
	$resync = true;
}

if ( $resync )
{ 
	include($phpbb_root_path . 'includes/functions_admin.' . $phpEx);
	sync('topic', $topic_id);

	$result = $db->sql_query('SELECT COUNT(post_id) AS total FROM ' . POSTS_TABLE . ' WHERE topic_id = ' . $topic_id);
	$row = $db->sql_fetchrow($result);
	$total_replies = $row['total'];
}

$sql = "SELECT *
	FROM " . RANKS_TABLE . "
	ORDER BY rank_special, rank_min DESC";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain ranks information.', '', __LINE__, __FILE__, $sql);
}

$ranksrow = array();
$rank_group_id_sql = '';
while ( $row = $db->sql_fetchrow($result) )
{
	if ( $row['rank_special'] )
	{
		$ranksrow[-1][$row['rank_id']] = $row;
	}
	else
	{
		$ranksrow[$row['rank_group']][] = $row;
		$rank_group_id_sql .= $row['rank_group'] > 0 ? ( ',' . $row['rank_group'] ) : '';
		$ranksrow[$row['rank_group']]['count']++;
	}
}
$db->sql_freeresult($result);

$poster_group = array();
if ( !empty($poster_id_sql) && !empty($rank_group_id_sql) )
{
	$rank_group_id_sql = substr($rank_group_id_sql, 1);
	$poster_id_sql = substr($poster_id_sql, 1);

	$sql = "SELECT ug.user_id, ug.group_id
		FROM " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g
		WHERE ug.user_id IN ( $poster_id_sql )
			AND ug.group_id IN ( $rank_group_id_sql )
			AND g.group_id = ug.group_id
			AND g.group_single_user = 0
			AND ug.user_pending <> 1
		ORDER BY g.group_order DESC";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain poster group information.', '', __LINE__, __FILE__, $sql);
	}

	while ( $row = $db->sql_fetchrow($result) )
	{
		$poster_group[$row['user_id']] = $row['group_id'];
	}
	$db->sql_freeresult($result);
}

// Define censored word matches
$orig_word = array();
$replacement_word = array();
obtain_word_list($orig_word, $replacement_word);

// Censor topic title
if ( !$board_config['show_badwords'] )
{
	if ( count($orig_word) )
	{
		$topic_title = preg_replace($orig_word, $replacement_word, $topic_title);
	}
}
else
{
	replace_bad_words($orig_word, $replacement_word, $topic_title);
}

// Was a highlight request part of the URI? Yes, this idea was
// taken from vB but we did already have a highlighter in place
// in search itself ... it's just been extended a bit!
$highlight_match = $highlight = '';
if ( isset($HTTP_GET_VARS['highlight']) )
{
	// Split words and phrases
	$words = explode(' ', trim(htmlspecialchars($HTTP_GET_VARS['highlight'])));

	for($i = 0; $i < sizeof($words); $i++)
	{
		if ( trim($words[$i]) != '' )
		{
			$highlight_match .= (($highlight_match != '') ? '|' : '') . str_replace('*', '\w*', phpbb_preg_quote($words[$i], '#'));
		}
	}
	unset($words);

	$highlight = urlencode($HTTP_GET_VARS['highlight']);
	$highlight_match = phpbb_rtrim($highlight_match, "\\");
}

// Post, reply and other URL generation for
// templating vars
$new_topic_url = append_sid("posting.$phpEx?mode=newtopic&amp;" . POST_FORUM_URL . "=$forum_id");
$reply_topic_url = append_sid("posting.$phpEx?mode=reply&amp;" . POST_TOPIC_URL . "=$topic_id");
$view_forum_url = append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id");
$view_prev_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=previous");
$view_next_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=next");

// Mozilla navigation bar
$nav_links['prev'] = array(
	'url' => $view_prev_topic_url,
	'title' => $lang['View_previous_topic']
);
$nav_links['next'] = array(
	'url' => $view_next_topic_url,
	'title' => $lang['View_next_topic']
);
$nav_links['up'] = array(
	'url' => $view_forum_url,
	'title' => $forum_name
);

if ( $HTTP_GET_VARS['cp'] && $HTTP_GET_VARS['ap'] )
{
	$reply_topic_back_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=0&amp;postorder=0&amp;start=" . ($HTTP_GET_VARS['cp'] * $user_posts_per_page));
	message_die('GENERAL_MESSAGE', sprintf($lang['Loser_protect'], $HTTP_GET_VARS['cp'], $HTTP_GET_VARS['ap'], '<a href="' . $reply_topic_back_url . '">', '</a>', '<a href="' . $reply_topic_url . '">', '</a>'));
}

if ( $board_config['graphic'] )
{
	$reply_img = ($forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED) ? $images['reply_locked'] : $images['reply_new'];
	$reply_alt = ($forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED) ? $lang['Topic_locked'] : $lang['Reply_to_topic'];
	$post_img = ($forum_topic_data['forum_status'] == FORUM_LOCKED) ? $images['post_locked'] : $images['post_new'];
	$post_alt = ($forum_topic_data['forum_status'] == FORUM_LOCKED) ? $lang['Forum_locked'] : $lang['Post_new_topic'];
}
else
{
	$mini_reply = ($forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED) ? $lang['mini_locked'] : $lang['mini_reply'];
	$mini_newtopic = ($forum_topic_data['forum_status'] == FORUM_LOCKED) ? $lang['mini_locked'] : $lang['mini_newtopic'];
	$reply_img = $images['spacer'] . '" border="0" />[ ' . $mini_reply . ' ]</a><a href=""><img src="' . $images['spacer'] . '" alt="';
	$post_img = $images['spacer'] . '" border="0" />[ ' . $mini_newtopic . ' ]</a><a href=""><img src="' . $images['spacer'] . '" alt="';
}

if ( !$board_config['read_tracking'] )
{
	if ( $session_logged_in )
	{
		$tracking_topics = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t'])) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : array();
		$tracking_forums = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f'])) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) : array();

		if ( !empty($tracking_topics[$topic_id]) && !empty($tracking_forums[$forum_id]) )
		{
			$topic_last_read = ($tracking_topics[$topic_id] > $tracking_forums[$forum_id]) ? $tracking_topics[$topic_id] : $tracking_forums[$forum_id];
		}
		else if ( !empty($tracking_topics[$topic_id]) || !empty($tracking_forums[$forum_id]) )
		{
			$topic_last_read = (!empty($tracking_topics[$topic_id])) ? $tracking_topics[$topic_id] : $tracking_forums[$forum_id];
		}
		else
		{
			$topic_last_read = $userdata['user_lastvisit'];
		}

		if ( count($tracking_topics) >= 150 && empty($tracking_topics[$topic_id]) )
		{
			asort($tracking_topics);
			unset($tracking_topics[key($tracking_topics)]);
		}

		$tracking_topics[$topic_id] = time();

		setcookie($board_config['cookie_name'] . '_t', serialize($tracking_topics), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
	}
}

// Load templates
$template->set_filenames(array(
	'body' => 'viewtopic_body.tpl')
);

make_jumpbox('viewforum.'.$phpEx, $forum_id);

// Output page header
$page_title = $lang['View_topic'] .' - ' . $topic_title;
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

// User authorisation levels output
$s_auth_can = (( $is_auth['auth_post']) ? $lang['Rules_post_can'] : $lang['Rules_post_cannot']) . '<br />';
$s_auth_can .= (( $is_auth['auth_reply']) ? $lang['Rules_reply_can'] : $lang['Rules_reply_cannot']) . '<br />';
$s_auth_can .= (( $is_auth['auth_edit']) ? $lang['Rules_edit_can'] : $lang['Rules_edit_cannot']) . '<br />';
$s_auth_can .= (( $is_auth['auth_delete']) ? $lang['Rules_delete_can'] : $lang['Rules_delete_cannot']) . '<br />';
$s_auth_can .= (( $is_auth['auth_vote']) ? $lang['Rules_vote_can'] : $lang['Rules_vote_cannot']) . '<br />';

if ( defined('ATTACHMENTS_ON') )
{
	attach_build_auth_levels($is_auth, $s_auth_can);
}

$topic_mod = '';

if ( $is_auth['auth_mod'] )
{
	$s_auth_can .= sprintf($lang['Rules_moderate'], "<a href=\"modcp.$phpEx?" . POST_FORUM_URL . "=$forum_id&amp;sid=" . $session_id . '">', '</a>');
	$topic_mod .= ($is_auth['auth_delete']) ? "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=delete&amp;sid=" . $session_id . '"><img src="' . $images['topic_mod_delete'] . '" alt="' . $lang['Delete_topic'] . '" title="' . $lang['Delete_topic'] . '" border="0" /></a>&nbsp;' : '';
	$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=move&amp;sid=" . $session_id . '"><img src="' . $images['topic_mod_move'] . '" alt="' . $lang['Move_topic'] . '" title="' . $lang['Move_topic'] . '" border="0" /></a>&nbsp;';
	$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=mergepost&amp;sid=" . $session_id . '"><img src="' . $images['topic_mod_merge'] . '" alt="' . $lang['Merge_post'] . '" title="' . $lang['Merge_post'] . '" border="0" /></a>&nbsp;';
	$topic_mod .= ($forum_topic_data['topic_status'] == TOPIC_UNLOCKED) ? "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=lock&amp;sid=" . $session_id . '"><img src="' . $images['topic_mod_lock'] . '" alt="' . $lang['Lock_topic'] . '" title="' . $lang['Lock_topic'] . '" border="0" /></a>&nbsp;' : '<a href="' . append_sid("modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=unlock&amp;sid=" . $session_id . "") . '"><img src="' . $images['topic_mod_unlock'] . '" alt="' . $lang['Unlock_topic'] . '" title="' . $lang['Unlock_topic'] . '" border="0" /></a>&nbsp;';
	$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=split&amp;sid=" . $session_id . '"><img src="' . $images['topic_mod_split'] . '" alt="' . $lang['Split_topic'] . '" title="' . $lang['Split_topic'] . '" border="0" /></a>&nbsp;';
	$normal_button = "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=normalise&amp;sid=" . $session_id . '"><img src="' . $images['folder'] . '" alt="' . $lang['Normal_topic'] . '" title="' . $lang['Normal_topic'] . '" border="0" /></a>&nbsp;';
	$sticky_button = ($is_auth['auth_sticky']) ? "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=sticky&amp;sid=" . $session_id . '"><img src="' . $images['folder_sticky'] . '" alt="' . $lang['Sticky_topic'] . '" title="' . $lang['Sticky_topic'] . '" border="0" /></a>&nbsp;' : '';
	$announce_button = ($is_auth['auth_announce']) ? "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=announce&amp;sid=" . $session_id . '"><img src="' . $images['folder_announce'] . '" alt="' . $lang['Announce_topic'] . '" title="' . $lang['Announce_topic'] . '" border="0" /></a>&nbsp;' : '';

	switch( $forum_topic_data['topic_type'] )
	{
		case POST_NORMAL: 
			$topic_mod .= $sticky_button . $announce_button;
			break;
		case POST_STICKY:
			$topic_mod .= $announce_button . $normal_button;
			break;
		case POST_ANNOUNCE:
			$topic_mod .= $sticky_button . $normal_button;
			break;
	}

	if ( $board_config['expire'] )
	{
		$topic_mod .= '<br /><span class="gensmall">' . $lang['topic_expire_mod'];
		$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=expire1&amp;sid=" . $session_id . '" class="mainmenu" title="' . $lang['expire_e'] . '">1</a>&nbsp;';
		$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=expire2&amp;sid=" . $session_id . '" class="mainmenu" title="' . $lang['expire_e'] . '">2</a>&nbsp;';
		$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=expire7&amp;sid=" . $session_id . '" class="mainmenu" title="' . $lang['expire_e'] . '">7</a>&nbsp;';
		$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=expire14&amp;sid=" . $session_id . '" class="mainmenu" title="' . $lang['expire_e'] . '">14</a> ' . $lang['Days'] . '</span>&nbsp;';
	}
}

// Topic watch information
$s_watching_topic = '';
if ( $can_watch_topic )
{
	if ( $is_watching_topic )
	{
		$s_watching_topic = '<br /><a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;unwatch=topic&amp;start=$start&amp;sid=" . $session_id . "") . '">' . $lang['Stop_watching_topic'] . '</a>';
		$s_watching_topic_img = (isset($images['Topic_un_watch'])) ? '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;unwatch=topic&amp;start=$start&amp;sid=" . $session_id . "") . '"><img src="' . $images['Topic_un_watch'] . '" alt="' . $lang['Stop_watching_topic'] . '" title="' . $lang['Stop_watching_topic'] . '" border="0"></a>' : '';
	}
	else
	{
		$s_watching_topic = '<br /><a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;watch=topic&amp;start=$start&amp;sid=" . $session_id . "") . '">' . $lang['Start_watching_topic'] . '</a>';
		$s_watching_topic_img = ( isset($images['Topic_watch']) ) ? '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;watch=topic&amp;start=$start&amp;sid=" . $session_id . "") . '"><img src="' . $images['Topic_watch'] . '" alt="' . $lang['Stop_watching_topic'] . '" title="' . $lang['Start_watching_topic'] . '" border="0"></a>' : '';
	}
}

// If we've got a hightlight set pass it on to pagination,
// I get annoyed when I lose my highlight after the first page.
$pagination = ($highlight != '') ? generate_pagination("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=$post_days&amp;postorder=$post_order&amp;highlight=$highlight", $total_replies, $user_posts_per_page, $start) : generate_pagination("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=$post_days&amp;postorder=$post_order", $total_replies, $user_posts_per_page, $start);

// Send vars to template

if ( $board_config['who_viewed'] && $session_logged_in )
{
	$topic_view_img = '<br /><a href="' . append_sid("topic_view_users.$phpEx?".POST_TOPIC_URL."=$topic_id") . '">' . $lang['Topic_view_users'] . '</a>';
	if ( $board_config['who_viewed_admin'] && !$is_auth['auth_mod'] && !$user_level != ADMIN )
	{
		$topic_view_img = '';
	}
}

if ( $board_config['read_tracking'] )
{
	$u_mark_topic_unread = '<br /><a href="' . append_sid("viewtopic.$phpEx?".POST_TOPIC_URL."=$topic_id"."&amp;unmark=topic&amp;sid=" . $session_id . "") . '">' . $lang[Mark_topic_unread] . '</a>';
}

if ( $portal_config['portal_on'] && $board_config['portal_link'] )
{
	if ( strstr($portal_config['witch_news_forum'], ',') )
	{
		$fids = explode(',', $portal_config['witch_news_forum']);
		while( list($foo, $id) = each($fids) )
		{
			$fid[] = intval( trim($id) );
		}
	}
	else
	{
		$fid[] = intval(trim($portal_config['witch_news_forum']));
	}
	reset($fid);
	$u_index_check = (in_array($forum_id, $fid) != false) ? append_sid("portal.$phpEx") : append_sid("index.$phpEx");
}
else
{
	$u_index_check = append_sid("index.$phpEx");
}

$view_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id");

if ( $board_config['poster_posts'] && $session_logged_in )
{
	$topic_add_title = '';
	$poster_post = '';
	$poster_post = get_poster_topic_posts($topic_id, $user_id);
	if ( $poster_post )
	{
		$topic_add_title = '&#164; ';
		$view_topic_url = $view_topic_url . '" title="' . $lang['poster_posts'] . ', ' . $lang['your_posts'] . ': ' . $poster_post;
	}
	$topic_title = $topic_add_title . $topic_title;
}

$ignore_status = '';

if ( $board_config['ignore_topics'] && $session_logged_in && $userdata['view_ignore_topics'] )
{
	$sql = "SELECT COUNT(topic_id) AS ignore_total FROM " . TOPICS_IGNORE_TABLE . "
		WHERE user_id = $user_id
		AND topic_id = $topic_id";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not list ignore topics', '', __LINE__, __FILE__, $sql_tot);
	}
	$row = $db->sql_fetchrow($result);
	$ignore_status = ($row['ignore_total']) ? '&nbsp;&nbsp;&nbsp;<span class="gensmall">[ <a href="' . append_sid("ignore_topics.$phpEx?mode=view&amp;topic_ignore=$topic_id") . '">' . $lang['current_topic_ignore'] . '</a> ]</span>' : '&nbsp;&nbsp;&nbsp;&nbsp;<a href="' . append_sid("ignore_topics.$phpEx?topic_id=$topic_id&amp;sid=" . $session_id . "") . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['ignore_topic'] . '" title="' . $lang['ignore_topic'] . '" border="0" align="top"/></a>';
}

$current_page = (floor($start / $user_posts_per_page) + 1);
$all_pages = ceil($total_replies / $user_posts_per_page);

$show_quickreply = (!$board_config['cquick'] || (!$session_logged_in && $board_config['not_anonymous_quickreply'])) ? false : true;
if ( $show_quickreply && $all_pages != $current_page )
{
	$reply_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $topic_id . "&amp;cp=" . $current_page . "&amp;ap=" . $all_pages);
	$show_quickreply = ($board_config['group_rank_hack_version']) ? true : false; // Sorry for: group_rank_hack_version :)
}

$server_protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
$script_name = ($script_name == '') ? $script_name : '/' . $script_name;

$template->assign_vars(array(
	'FORUM_ID' => $forum_id,
	'FORUM_NAME' => $forum_name,
	'U_INDEX' => $u_index_check,
	'TOPIC_ID' => $topic_id,
	'TOPIC_TITLE' => $topic_title,
	'TOPIC_TITLE_B' => $b_topic_title,
	'PAGINATION' => $pagination,
	'POST_IMG' => $post_img,
	'REPLY_IMG' => $reply_img,
	'IGNORE_STATUS' => $ignore_status,
	'L_PRINT' => $lang['Print_View'],
	'U_PRINT' => append_sid("printview.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start"),
	'L_AUTHOR' => $lang['Author'],
	'L_MESSAGE' => $lang['Message'],
	'L_POSTED' => $lang['Posted'],
	'L_POST_SUBJECT' => $lang['Post_subject'],
	'L_VIEW_NEXT_TOPIC' => $lang['View_next_topic'],
	'L_VIEW_PREVIOUS_TOPIC' => $lang['View_previous_topic'],
	'L_POST_NEW_TOPIC' => $post_alt,
	'L_POST_REPLY_TOPIC' => $reply_alt,
	'L_DISPLAY_POSTS' => $lang['Display_posts'],
	'L_LOCK_TOPIC' => $lang['Lock_topic'],
	'L_UNLOCK_TOPIC' => $lang['Unlock_topic'],
	'L_MOVE_TOPIC' => $lang['Move_topic'],
	'L_SPLIT_TOPIC' => $lang['Split_topic'],
	'L_DELETE_TOPIC' => $lang['Delete_topic'],
	'L_GOTO_PAGE' => $lang['Goto_page'],
	'L_LEVEL' => $lang['l_level'],
	'S_TOPIC_LINK' => POST_TOPIC_URL,
	'S_SELECT_POST_DAYS' => $select_post_days,
	'S_SELECT_POST_ORDER' => $select_post_order,
	'S_POST_DAYS_ACTION' => append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $topic_id . "&amp;start=$start"),
	'S_AUTH_LIST' => $s_auth_can,
	'S_TOPIC_ADMIN' => $topic_mod,
	'S_WATCH_TOPIC' => $s_watching_topic,
	'PAGE_NUMBER' => ($all_pages > 1) ? sprintf($lang['Page_of'], $current_page, $all_pages) : '',
	'U_TOPIC_BOOKMARK' => $server_protocol . $server_name . $server_port . $script_name . "/viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id",
	'L_TOPIC_BOOKMARK' => $lang['Topic_bookmark'],
	'U_MARK_TOPIC_UNREAD' => $u_mark_topic_unread,
	'TELLFRIEND_BOX' => ($board_config['cfriend'] && $session_logged_in) ? '<a href="' . append_sid("tellafriend.$phpEx?topic_id=$topic_id") . '">' . $lang['s_email_friend'] . '</a><br />' : '',
	'TOPIC_VIEW_IMG' => $topic_view_img,
	'U_VIEW_TOPIC' => $view_topic_url,
	'U_VIEW_FORUM' => $view_forum_url,
	'U_VIEW_OLDER_TOPIC' => $view_prev_topic_url,
	'U_VIEW_NEWER_TOPIC' => $view_next_topic_url,
	'U_POST_NEW_TOPIC' => $new_topic_url,
	'U_POST_REPLY_TOPIC' => $reply_topic_url,
	'CSMILES_OFF1' => (!$board_config['allow_smilies']) ? '<!--' : '',
	'CSMILES_OFF2' => (!$board_config['allow_smilies']) ? '-->' : '')
);

if ( $forum_moderate && $is_auth['auth_mod'] )
{
	$template->assign_block_vars('moderate', array(
		'L_ACCEPT-REJECT_POST' => $lang['Accept-reject'],
		'S_MODERATE_ACTION' => append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id"))
	);
}

// Does this topic contain a poll? 
if ( !empty($forum_topic_data['topic_vote']) && (!$forum_moderate || $forum_topic_data['topic_approve'] || $forum_topic_data['topic_poster'] == $userdata['user_id'] || $is_auth['auth_mod']) )
{
	$s_hidden_fields = '';

	$sql = "SELECT vd.vote_id, vd.vote_text, vd.vote_start, vd.vote_length, vd.vote_max, vd.vote_voted, vd.vote_hide, vd.vote_tothide, vr.vote_option_id, vr.vote_option_text, vr.vote_result
		FROM " . VOTE_DESC_TABLE . " vd, " . VOTE_RESULTS_TABLE . " vr
		WHERE vd.topic_id = $topic_id
			AND vr.vote_id = vd.vote_id
		ORDER BY vr.vote_option_id ASC";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain vote data for this topic', '', __LINE__, __FILE__, $sql);
	}

	if ( $vote_info = $db->sql_fetchrowset($result) )
	{
		$db->sql_freeresult($result);
		$vote_options = count($vote_info);

		$vote_id = $vote_info[0]['vote_id'];
		$vote_title = $vote_info[0]['vote_text'];
		$max_vote = $vote_info[0]['vote_max'];
		$voted_vote = $vote_info[0]['vote_voted'];
		$hide_vote = $vote_info[0]['vote_hide'];
		$tothide_vote = $vote_info[0]['vote_tothide'];

		$sql = "SELECT vote_id
			FROM " . VOTE_USERS_TABLE . "
			WHERE vote_id = $vote_id
				AND vote_user_id = " . intval($user_id);
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain user vote data for this topic', '', __LINE__, __FILE__, $sql);
		}

		$user_voted = ($row = $db->sql_fetchrow($result)) ? TRUE : 0;
		$db->sql_freeresult($result);

		if ( isset($HTTP_GET_VARS['vote']) || isset($HTTP_POST_VARS['vote']) )
		{
			$view_result = (((isset($HTTP_GET_VARS['vote'])) ? $HTTP_GET_VARS['vote'] : $HTTP_POST_VARS['vote']) == 'viewresult' ) ? TRUE : 0;
		}
		else
		{
			$view_result = 0;
		}

		$poll_expired = ($vote_info[0]['vote_length']) ? (($vote_info[0]['vote_start'] + $vote_info[0]['vote_length'] < time()) ? TRUE : 0) : 0;

		if ( $user_voted || $view_result || $poll_expired || !$is_auth['auth_vote'] || $forum_topic_data['topic_status'] == TOPIC_LOCKED )
		{
			$template->set_filenames(array(
				'pollbox' => 'viewtopic_poll_result.tpl')
			);

			$vote_results_sum = 0;

			for($i = 0; $i < $vote_options; $i++)
			{
				$vote_results_sum += $vote_info[$i]['vote_result'];
			}

			$vote_graphic = 0;
			$vote_graphic_max = count($images['voting_graphic']);

			for($i = 0; $i < $vote_options; $i++)
			{
				$vote_percent = ($vote_results_sum > 0) ? $vote_info[$i]['vote_result'] / $vote_results_sum : 0;
				$vote_graphic_length = round($vote_percent * $board_config['vote_graphic_length']);

				$vote_graphic_img = $images['voting_graphic'][$vote_graphic];
				$vote_graphic = ($vote_graphic < $vote_graphic_max - 1) ? $vote_graphic + 1 : 0;

				if ( !$board_config['show_badwords'] )
				{
					if ( count($orig_word) )
					{
						$vote_info[$i]['vote_option_text'] = preg_replace($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
					}
				}
				else
				{
					replace_bad_words($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
				}
				$hide_vote_bl = '';
				$hide_vote_zr = '0';
				$total_votes_1 = $lang['Total_votes'] ;
				$total_votes_2 = $vote_results_sum;

				if ( ( $poll_expired == 0 ) && ( $hide_vote == 1 ) && ( $vote_info[0]['vote_length'] <> 0 ) )
				{
					if ( $tothide_vote == 1 )
					{
						$total_votes_1 = '' ;
						$total_votes_2 = '' ;
					}
					$poll_expires_c = $lang['Results_after'];

					$template->assign_block_vars('poll_option', array(
						'POLL_OPTION_CAPTION' => $vote_info[$i]['vote_option_text'],
						'POLL_OPTION_RESULT' => $hide_vote_bl,
						'POLL_OPTION_PERCENT' => $hide_vote_bl,
						'POLL_OPTION_IMG' => $vote_graphic_img,
						'POLL_OPTION_IMG_WIDTH' => $hide_vote_zr)
					);
				}
				else
				{
					$poll_expires_c = '';
					$template->assign_block_vars('poll_option', array(
						'POLL_OPTION_CAPTION' => $vote_info[$i]['vote_option_text'],
						'POLL_OPTION_RESULT' => $vote_info[$i]['vote_result'],
						'POLL_OPTION_PERCENT' => sprintf("%.1d%%", ($vote_percent * 100)),

						'POLL_OPTION_IMG' => $vote_graphic_img,
						'POLL_OPTION_IMG_WIDTH' => $vote_graphic_length)
					);
				}
			}

			if ( ( $poll_expired == 0 ) && ( $vote_info[0]['vote_length'] <> 0 ) )
			{
				$poll_expire_1 = (($vote_info[0]['vote_start'] + $vote_info[0]['vote_length']) - time() );
				$poll_expire_2 = intval($poll_expire_1 / 86400);
				$poll_expire_a = $poll_expire_2 * 86400;
				$poll_expire_3 = intval(($poll_expire_1 - ($poll_expire_a)) / 3600);
				$poll_expire_b = $poll_expire_3 * 3600;
				$poll_expire_4 = intval((($poll_expire_1 - ($poll_expire_a) - ($poll_expire_b))) / 60);
				$poll_comma = ', ';
				$poll_space = ' ';
				$poll_expire_2 == '0' ? $poll_expire_6 = '' : (($poll_expire_3 == 0 && $poll_expire_4 == 0) ? $poll_expire_6 = $poll_expire_2 . $poll_space . $lang['Days'] : $poll_expire_6 = $poll_expire_2 . $poll_space . $lang['Days'] . $poll_comma) ;
				$poll_expire_3 == '0' ? $poll_expire_7 = '' : ($poll_expire_4 == 0 ? $poll_expire_7 = $poll_expire_3 . $poll_space . $lang['Hours'] : $poll_expire_7 = $poll_expire_3 . $poll_space . $lang['Hours'] . $poll_comma);
				$poll_expire_4 == '0' ? $poll_expire_8 = '' : $poll_expire_8 = $poll_expire_4 . $poll_space . $lang['Minutes'] ;
				$poll_expires_d = $lang['Poll_expires'];
			}
			else
			{
				$poll_expires_6 = '';
				$poll_expires_7 = '';
				$poll_expires_8 = '';
				$poll_expires_d = '';
			}
			$voted_vote_nb = $voted_vote;

			$template->assign_vars(array(
				'VOTED_SHOW' => $lang['Voted_show'],
				'L_TOTAL_VOTES' => $total_votes_1 . ': ',
				'L_RESULTS_AFTER' => $poll_expires_c,
				'L_POLL_EXPIRES' => $poll_expires_d,
				'POLL_EXPIRES' => ($poll_expire_6 . $poll_expire_7 . $poll_expire_8),
				'TOTAL_VOTES' => $total_votes_2)
			);
		}
		else
		{
			$template->set_filenames(array(
				'pollbox' => 'viewtopic_poll_ballot.tpl')
			);

			$vote_box = ($max_vote > 1) ? 'checkbox' : 'radio';

			for($i = 0; $i < $vote_options; $i++)
			{
				if ( !$board_config['show_badwords'] )
				{
					if ( count($orig_word) )
					{
						$vote_info[$i]['vote_option_text'] = preg_replace($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
					}
				}
				else
				{
					replace_bad_words($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
				}

				$template->assign_block_vars('poll_option', array(
					'POLL_VOTE_BOX' => $vote_box,
					'POLL_OPTION_ID' => $vote_info[$i]['vote_option_id'],
					'POLL_OPTION_CAPTION' => $vote_info[$i]['vote_option_text'])
				);
			}

			$template->assign_vars(array(
				'L_SUBMIT_VOTE' => $lang['Submit_vote'],
				'L_VIEW_RESULTS' => $lang['View_results'],

				'U_VIEW_RESULTS' => append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=$post_days&amp;postorder=$post_order&amp;vote=viewresult"))
			);

			$s_hidden_fields = '<input type="hidden" name="topic_id" value="' . $topic_id . '"><input type="hidden" name="mode" value="vote">';
		}
		if ( $max_vote > 1 )
		{
			$vote_br = '<br />';
			$max_vote_nb = $max_vote;
		}
		else
		{
			$vote_br = '';
			$lang['Max_voting_1_explain'] = '';
			$lang['Max_voting_2_explain'] = '';
			$lang['Max_voting_3_explain'] = '';
			$max_vote_nb = '';
		}
		if ( !$board_config['show_badwords'] )
		{
			if ( count($orig_word) )
			{
				$vote_title = preg_replace($orig_word, $replacement_word, $vote_title);
			}
		}
		else
		{
			replace_bad_words($orig_word, $replacement_word, $vote_title);
		}

		$s_hidden_fields .= '<input type="hidden" name="sid" value="' . $session_id . '" />';

		$template->assign_vars(array(
			'POLL_QUESTION' => $vote_title,
			'POLL_VOTE_BR' => $vote_br,
			'MAX_VOTING_1_EXPLAIN' => $lang['Max_voting_1_explain'],
			'MAX_VOTING_2_EXPLAIN' => $lang['Max_voting_2_explain'],
			'MAX_VOTING_3_EXPLAIN' => $lang['Max_voting_3_explain'],
			'max_vote' => $max_vote_nb,
			'voted_vote' => $voted_vote_nb,

			'S_HIDDEN_FIELDS' => $s_hidden_fields,
			'S_POLL_ACTION' => append_sid("posting.$phpEx?mode=vote&amp;" . POST_TOPIC_URL . "=$topic_id"))
		);

		$template->assign_var_from_handle('POLL_DISPLAY', 'pollbox');
	}
}

if ( defined('ATTACHMENTS_ON') )
{
	init_display_post_attachments($forum_topic_data['topic_attachment']);
}

// Update the topic view counter
$sql = "UPDATE " . TOPICS_TABLE . "
	SET topic_views = topic_views + 1
	WHERE topic_id = $topic_id";
if ( !$db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, 'Could not update topic views.', '', __LINE__, __FILE__, $sql);
}

// Okay, let's do the loop, yeah come on baby let's do the loop
// and it goes like this ...
$counter_i = 0;
for($i = 0; $i < $total_posts; $i++)
{
	$poster_id = $postrow[$i]['user_id'];
	$poster_username = $postrow[$i]['username'];
	$postrow_post_id = $postrow[$i]['post_id'];
	$poster_level = $postrow[$i]['user_level'];
	$poster_posts = $postrow[$i]['user_posts'];
	$post_time = $postrow[$i]['post_time'];
	$show_post = (!$postrow[$i]['post_approve'] && $forum_view_moderate ) ? false : true; 
	$row_class = '';

	if ( $poster_level != ANONYMOUS && $poster_level != ADMIN && is_mod_buffered($poster_id) )
	{
		if ( is_mod($poster_id, $forum_id) )
		{
			$poster_is_mod_here = true;
			$poster_is_mod = true;
		}
		else
		{
			$poster_is_mod_here = false;
			$poster_is_mod = true;
		}
	}
	else
	{
		$poster_is_mod_here = $poster_is_mod = false;
		$poster_is_jr_admin = (is_jr_admin_buffered($poster_id)) ? true : false;
	}


	// Begin post expires
	if ( $board_config['expire'] )
	{
		$post_end = $post_time + $postrow[$i]['post_expire'];
		$post_expire_date = ($postrow[$i]['post_expire'] == 0) ? '' : $lang['post_expire'] . ' ' . date('m.d, H:i', $post_end);

		if ( time() > $post_end && $postrow[$i]['post_expire'] > 0 )
		{
			require_once($phpbb_root_path . 'includes/functions_remove.' . $phpEx);
			delete_post($postrow_post_id);
		}
	}
	// End post expire

	if ( $board_config['cignore'] )
	{
		if ( $user_id != ANONYMOUS )
		{
			$sql = "SELECT user_ignore
				FROM " . IGNORE_TABLE . "
				WHERE user_id = $user_id
					AND user_ignore = $poster_id";
			if ( !$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, 'Could not get data from ignore table', __LINE__, __FILE__, $sql);
			}
			$post_ignored = $db->sql_numrows($result);
		}
		else
		{
			$post_ignored = 0;
		}
		$counter_i++;
	}

	$poster = ($poster_id == ANONYMOUS) ? $lang['Guest'] : $poster_username;

	$ignore_this_post = (($post_ignored > 0) && ($poster_id != ANONYMOUS) && ($post_bypass != $postrow_post_id) && ($poster_level != ADMIN) && !$poster_is_mod ) ? true : false;

	if ( $ignore_this_post || (!$show_post && $userdata['user_id'] != $poster_id) )
	{
		$post_date = create_date($board_config['default_dateformat'], $post_time, $board_config['board_timezone']);

		$message = (!$show_post) ? '<i><b>' . $lang['Post_no_approved'] . '</b></i>' : $lang['Post_user_ignored'] . ' ' . sprintf($lang['Click_view_ignore'], '<a href="' . append_sid("viewtopic.$phpEx?p=" . $postrow_post_id . "&amp;bypass=" . $postrow_post_id . "#" . $postrow_post_id) . '">', '</a>') . ' ' . sprintf($lang['Click_return_ignore'], '<a href="' . append_sid("ignore.$phpEx") . '">', '</a>');

		$aim_img = '';
		$aim = '';
		$aim_status_img = '';
		$delpost_img = '';
		$delpost = '';
		$email_img = '';
		$email = '';
		$gender_image = '';
		$icq_status_img = '';
		$icq_img = '';
		$icq = '';
		$icon = '';
		$ignore = '';
		$l_edited_by = '';
		$helped_me_show = '';
		$special_rank = '';
		$level_hp = '';
		$level_hp_percent = '';
		$level_mp_percent = '';
		$level_exp_percent = '';
		$level_level = '';
		$max_warn = '';
		$msn_img = '';
		$msn = '';
		$new_post = '';
		$pm_img = '';
		$pm = '';
		$post_expire_date = '';
		$poster_age = '';
		$poster_custom_rank = '';
		$poster_rank = '';
		$poster_joined = '';
		$poster_post = '';
		$poster_from = '';
		$poster_avatar = '';
		$poster_member = '';
		$post_subject = '';
		$profile_img = '';
		$profile = '';
		$quote_img = '';
		$q_img = '';
		$quote = '';
		$rank_image = '';
		$report_img = '';
		$report = '';
		$search_img = '';
		$search = '';
		$user_sig = '';
		$user_sig_image = '';
		$warn_percent = '';
		$www_img = '';
		$www = '';
		$yim_img = '';
		$yim = '';
		$mini_post_img = $images['icon_minipost'];
	}
	else
	{
		if ( $postrow[$i]['user_birthday'] != 999999 && $board_config['cage'] )
		{
			$poster_age = realdate('Y',(time() / 86400))- realdate ('Y',$postrow[$i]['user_birthday']);
			if ( date('md') < realdate('md',$postrow[$i]['user_birthday']) )
			{
				$poster_age--;
			}
			$poster_age = $lang['Age'] . ': ' . $poster_age .' ';
		}
		else
		{
			$poster_age = '';
		}

		$post_date = create_date($board_config['default_dateformat'], $post_time, $board_config['board_timezone']);

		$poster_post = ($poster_id != ANONYMOUS && $board_config['cposts']) ? $lang['Posts'] . ': ' . $poster_posts : '';
		$poster_from = ($postrow[$i]['user_from'] && $board_config['cfrom'] && $poster_id != ANONYMOUS ) ? $lang['Location'] . ': ' . $postrow[$i]['user_from'] : '';
		$poster_custom_color = ($postrow[$i]['user_custom_color'] && $poster_id != ANONYMOUS) ? $postrow[$i]['user_custom_color'] : '';
		$poster_joined = ($poster_id != ANONYMOUS && $board_config['cjoin']) ? (($postrow[$i]['user_gender'] == 2) ? $lang['Joined_she'] : $lang['Joined']) . ': ' . create_date($lang['DATE_FORMAT'], $postrow[$i]['user_regdate'], $board_config['board_timezone']) : '';

		$poster_avatar = '';
		if ( $postrow[$i]['user_avatar_type'] && $poster_id != ANONYMOUS && $postrow[$i]['user_allowavatar'] && $userdata['user_showavatars'] )
		{
			switch( $postrow[$i]['user_avatar_type'] )
			{
				case USER_AVATAR_UPLOAD:
					$poster_avatar = ($board_config['allow_avatar_upload']) ? '<img src="' . $board_config['avatar_path'] . '/' . $postrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
					break;
				case USER_AVATAR_REMOTE:
				if ( $board_config['allow_avatar_remote'] )
				{
					if ( ($postrow[$i]['user_avatar_height'] && $postrow[$i]['user_avatar_height'] > 0) && ($postrow[$i]['user_avatar_width'] && $postrow[$i]['user_avatar_width'] > 0) )
					{
						$poster_avatar = '<img src="' . $postrow[$i]['user_avatar'] . '" height="' . $postrow[$i]['user_avatar_height'] . '" width="' . $postrow[$i]['user_avatar_width'] . '" alt="" border="0" />';
					}
					else // No width/height in the user's profile
					{
						$poster_avatar = '<img src="' . $postrow[$i]['user_avatar'] . '" alt="" border="0" />';
					}
				}
				else $poster_avatar = '';
					break;
				case USER_AVATAR_GALLERY:
					$poster_avatar = ($board_config['allow_avatar_local']) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $postrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
					break;
			}
			$poster_avatar = $poster_avatar . '<br />';
		}

		// Define the little post icon
		if ( $session_logged_in )
		{
			if ( $board_config['read_tracking'] )
			{
				if ( in_array($postrow_post_id, $new_posts) )
				{
					$mini_post_img = $images['icon_minipost_new'];
					$mini_post_alt = $lang['New_post'];
					$new_post = 1;
				}
				else
				{
					$mini_post_img = $images['icon_minipost'];
					$mini_post_alt = $lang['Post'];
					$new_post = 0;
				}
			}
			else
			{
				if ( $post_time > $userdata['user_lastvisit'] && $post_time > $topic_last_read )
				{
					$mini_post_img = $images['icon_minipost_new'];
					$mini_post_alt = $lang['New_post'];
					$new_post = 1;
				}
				else
				{
					$mini_post_img = $images['icon_minipost'];
					$mini_post_alt = $lang['Post'];
					$new_post = 0;
				}
			}
		}
		else
		{
			$mini_post_img = $images['icon_minipost'];
			$mini_post_alt = $lang['Post'];
		}

		$mini_post_url = append_sid("viewtopic.$phpEx?" . POST_POST_URL . '=' . $postrow_post_id) . '#' . $postrow_post_id;

		// Generate ranks, set them to empty string initially.
		$poster_rank = '';
		$rank_image = '';
		if ( $poster_id == ANONYMOUS )
		{
			$anonymous_user = true;
		}
		else if ( $postrow[$i]['user_rank'] )
		{
			$poster_rank = $ranksrow[-1][$postrow[$i]['user_rank']]['rank_title'];
			$rank_file = $images['rank_path'] . $ranksrow[-1][$postrow[$i]['user_rank']]['rank_image'];
			$sizes = @getimagesize($rank_file);
			$rank_sizes = (intval($sizes[0]) > 0 && intval($sizes[1]) > 0) ? '" width="' . $sizes[0] . '" height="' . $sizes[1] : '';
			$rank_image = ($ranksrow[-1][$postrow[$i]['user_rank']]['rank_image']) ? '<img src="' . $rank_file . $width . '" alt="' . str_replace('-#', '', $poster_rank) . '" title="' . str_replace('-#', '', $poster_rank) . '" border="0" /><br />' : '';
			$poster_rank = $poster_rank . '<br />';
			if ( ereg('-#', $poster_rank) )
			{
				$poster_rank = '';
			}
		}
		else if ( isset($poster_group[$poster_id]) )
		{
			$g = $poster_group[$poster_id];
			for($j = 0; $j < $ranksrow[$g]['count']; $j++)
			{
				if ( $poster_posts >= $ranksrow[$g][$j]['rank_min'] )
				{
					$poster_rank = $ranksrow[$g][$j]['rank_title'];
					$rank_file = $images['rank_path'] . $ranksrow[$g][$j]['rank_image'];
					$sizes = @getimagesize($rank_file);
					$rank_sizes = (intval($sizes[0]) > 0 && intval($sizes[1]) > 0) ? '" width="' . $sizes[0] . '" height="' . $sizes[1] : '';
					$rank_image = ($ranksrow[$g][$j]['rank_image']) ? '<img src="' . $rank_file . $width . '" alt="' . str_replace('-#', '', $poster_rank) . '" title="' . str_replace('-#', '', $poster_rank) . '" border="0" /><br />' : '';
					$poster_rank = $poster_rank . '<br />';
					if ( ereg('-#', $poster_rank) )
					{
						$poster_rank = '';
					}
					break;
				}
			}
		}
		else
		{
			for($j = 0; $j < $ranksrow[0]['count']; $j++)
			{
				if ( $poster_posts >= $ranksrow[0][$j]['rank_min'] )
				{
					$poster_rank = $ranksrow[0][$j]['rank_title'];
					$rank_file = $images['rank_path'] . $ranksrow[0][$j]['rank_image'];
					$sizes = @getimagesize($rank_file);
					$rank_sizes = (intval($sizes[0]) > 0 && intval($sizes[1]) > 0) ? '" width="' . $sizes[0] . '" height="' . $sizes[1] : '';
					$rank_image = ($ranksrow[0][$j]['rank_image']) ? '<img src="' . $rank_file . $width . '" alt="' . str_replace('-#', '', $poster_rank) . '" title="' . str_replace('-#', '', $poster_rank) . '" border="0" /><br />' : '';
					$poster_rank = $poster_rank . '<br />';
					if ( ereg('-#', $poster_rank) )
					{
						$poster_rank = '';
					}
					break;
				}
			}
		}

		$show_custom_rank = false;
		$custom_rank_mod = false;

		if ( $poster_posts >= $board_config['allow_custom_rank'] )
		{
			$show_custom_rank = true;
		}
		if ( $poster_is_mod || $poster_level == ADMIN || $poster_is_jr_admin )
		{
			$custom_rank_mod = true;
		}
		if ( $board_config['custom_rank_mod'] && $custom_rank_mod )
		{
			$show_custom_rank = true;
		}
		if ( $show_custom_rank && $postrow[$i]['can_custom_ranks'] && $postrow[$i]['user_custom_rank'] != '' && $poster_id != ANONYMOUS )
		{
			$poster_custom_rank = $postrow[$i]['user_custom_rank'];
			$poster_custom_rank = $poster_custom_rank . '<br />';
		}
		else
		{
			$poster_custom_rank = '';
		}

		// Handle anon users posting with usernames
		if ( $poster_id == ANONYMOUS && $postrow[$i]['post_username'] != '' )
		{
			$poster = ($postrow[$i]['poster_delete']) ? $postrow[$i]['post_username'] . '</b><br /><font size="1">-<i>' . $lang['User_deleted'] . '</i>-</font><b>' : $postrow[$i]['post_username'];
			$poster = $poster . '<br />';
			$poster_rank = $lang['Guest'];
		}

		$temp_url = '';

		if ( $poster_id != ANONYMOUS )
		{
			if ( $poster_id == $user_id || !$board_config['cignore'] )
			{
				$ignore = '';
			}
			else
			{
				$temp_url = append_sid("ignore.$phpEx?mode=add&amp;ignore_id=$poster_id&amp;topic=$topic_id&amp;sid=" . $session_id . "");
				$ignore = ($board_config['graphic']) ? '<a href="' . $temp_url . '"><img src="' . $images['icon_ignore'] . '" alt="' . $lang['Ignore_add'] . '" title="' . $lang['Ignore_add'] . '" border="0" /></a> ' : '<a href="' . $temp_url . '" class="gen" title="' . $lang['Ignore_add'] . '">[<b>' . $lang['Ignore_mini'] . '</b>]</a> ';
			}

			$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$poster_id");
			if ( $board_config['post_footer'] )
			{		
				if ( $board_config['graphic'] )
				{
					$profile_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_profile'] . '" alt="' . $lang['Read_profile'] . '" title="' . $lang['Read_profile'] . '" border="0" /></a>';
					$profile = '<a href="' . $temp_url . '">' . $lang['Read_profile'] . '</a>';
					$temp_url = append_sid("privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=$poster_id");
					$pm_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_pm'] . '" alt="' . $lang['Send_private_message'] . '" title="' . $lang['Send_private_message'] . '" border="0" /></a>';
					if ( $board_config['gender'] )
					{
						switch ($postrow[$i]['user_gender'])
						{
							case 1 :
								$gender_image = '&nbsp;<img src="' . $images['icon_minigender_male'] . '" alt="' . $lang['Gender']. ':' . $lang['Male'] . '" title="' . $lang['Male'] . '" border="0" />';
							break;
							case 2 :
								$gender_image = '&nbsp;<img src="' . $images['icon_minigender_female'] . '" alt="' . $lang['Gender'] . ':' . $lang['Female'] . '" title="' . $lang['Female'] . '" border="0" />';
							break;
							default :
								$gender_image = '';
						}
					}
					else
					{
						$gender_image = '';
					}
					$temp_url = append_sid("privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=$poster_id");
					$pm = '<a href="' . $temp_url . '">' . $lang['Send_private_message'] . '</a>';
					if ( !empty($postrow[$i]['user_viewemail']) || $is_auth['auth_mod'] )
					{
						$email_uri = ($board_config['board_email_form']) ? append_sid("profile.$phpEx?mode=email&amp;" . POST_USERS_URL .'=' . $poster_id) : 'mailto:' . $postrow[$i]['user_email'];
						$email_img = '<a href="' . $email_uri . '"><img src="' . $images['icon_email'] . '" alt="' . $lang['Send_email'] . '" title="' . $lang['Send_email'] . '" border="0" /></a>';
						$email = '<a href="' . $email_uri . '">' . $lang['Send_email'] . '</a>';
					}
					else
					{
						$email_img = '';
						$email = '';
					}
					$www_img = ($postrow[$i]['user_website']) ? '<a href="' . $postrow[$i]['user_website'] . '" target="_userwww"><img src="' . $images['icon_www'] . '" alt="' . $lang['Visit_website'] . '" title="' . $lang['Visit_website'] . '" border="0" /></a>' : '';
					$www = ($postrow[$i]['user_website']) ? '<a href="' . $postrow[$i]['user_website'] . '" target="_userwww">' . $lang['Visit_website'] . '</a>' : '';
					if ( $board_config['cicq'] && !empty($postrow[$i]['user_icq']) )
					{
						$icq_status_img = '<a href="http://wwp.icq.com/' . $postrow[$i]['user_icq'] . '#pager"><img src="http://web.icq.com/whitepages/online?icq=' . $postrow[$i]['user_icq'] . '&amp;img=5" width="18" height="18" border="0" alt="" /></a>';
						$icq_img = '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $postrow[$i]['user_icq'] . '"><img src="' . $images['icon_icq'] . '" alt="' . $lang['ICQ'] . '" title="' . $lang['ICQ'] . '" border="0" /></a>';
						$icq = '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $postrow[$i]['user_icq'] . '">' . $lang['ICQ'] . '</a>';
					}
			
					else
					{
						$icq_status_img = '';
						$icq_img = '';
						$icq = '';
					}
					if ( !empty($postrow[$i]['user_aim']) && $board_config['cgg'] )
					{
						$gg_url = append_sid("gg.$phpEx?mode=gadu&amp;" . POST_USERS_URL . "=$poster_id");
						$aim_status_img = '<a href="gg:' .$postrow[$i]['user_aim'] . '"><img src="http://www.gadu-gadu.pl/users/status.asp?id=' . $postrow[$i]['user_aim'] . '&amp;styl=1" alt="' .$postrow[$i]['user_aim'] . '" border="0" /></a>';
						$aim_img = '<a href="' . $gg_url . '"><img src="' . $images['icon_aim'] . '" alt="' . $lang['AIM'] . '" title="' . $lang['AIM'] . ': ' . $postrow[$i]['user_aim'] . '" border="0" /></a>';
						$aim ='<a href="' . $gg_url . '">' . $lang['AIM'] . '</a>';
					}
					else
					{
						$aim_status_img = '';
						$aim_img = '';
						$aim = '';
					}
					$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$poster_id");
					$msn_img = ($postrow[$i]['user_msnm'] && $board_config['cmsn']) ? '<a href="' . $temp_url . '"><img src="' . $images['icon_msnm'] . '" alt="' . $lang['MSNM'] . '" title="' . $lang['MSNM'] . '" border="0" /></a> ' : '';
					$msn = ($postrow[$i]['user_msnm']) ? '<a href="' . $temp_url . '">' . $lang['MSNM'] . '</a>' : '';
					$yim_img = ( $postrow[$i]['user_yim'] && $board_config['cyahoo']) ? '<a href="http://edit.yahoo.com/config/send_webmesg?.target=' . $postrow[$i]['user_yim'] . '&amp;.src=pg"><img src="' . $images['icon_yim'] . '" alt="' . $lang['YIM'] . '" title="' . $lang['YIM'] . '" border="0" /></a> ' : '';
					$yim = ($postrow[$i]['user_yim']) ? '<a href="http://edit.yahoo.com/config/send_webmesg?.target=' . $postrow[$i]['user_yim'] . '&amp;.src=pg">' . $lang['YIM'] . '</a>' : '';
				}
				else
				{
					$profile_img = '<a href="' . $temp_url . '" class="gen" title="' . $lang['Read_profile'] . '">[<b>' . $lang['Profile'] . '</b>]</a>';
					$profile = '<a href="' . $temp_url . '">' . $lang['Read_profile'] . '</a>';
					$temp_url = append_sid("privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=$poster_id");
					$pm_img = '<a href="' . $temp_url . '" class="gen" title="' . $lang['Send_private_message'] . '">[<b>' . $lang['pm_mini'] . '</b>]</a>';
					$pm = '<a href="' . $temp_url . '">' . $lang['Send_private_message'] . '</a>';

					if ( !empty($postrow[$i]['user_viewemail']) || $is_auth['auth_mod'] )
					{
						$email_uri = ($board_config['board_email_form']) ? append_sid("profile.$phpEx?mode=email&amp;" . POST_USERS_URL .'=' . $poster_id) : 'mailto:' . $postrow[$i]['user_email'];
						$email_img = '<a href="' . $email_uri . '" class="gen" title="' . $lang['Send_email'] . '">[<b>' . $lang['Email'] . '</b>]</a>';
						$email = '<a href="' . $email_uri . '">' . $lang['Send_email'] . '</a>';
					}
					else
					{
						$email_img = '';
						$email = '';
					}
					$www_img = ($postrow[$i]['user_website']) ? '<a href="' . $postrow[$i]['user_website'] . '" target="_userwww" class="gen" title="' . $lang['Visit_website'] . '">[<b>WWW</b>]</a>' : '';
					$www = ($postrow[$i]['user_website']) ? '<a href="' . $postrow[$i]['user_website'] . '" target="_userwww">' . $lang['Visit_website'] . '</a>' : '';

					if ( $board_config['cicq'] && !empty($postrow[$i]['user_icq']) )
					{
						$icq_img = '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $postrow[$i]['user_icq'] . '" class="gen" title="' . $lang['ICQ'] . '">[<b>' . $lang['cicq'] . '</b>]</a>';
						$icq ='<a href="http://wwp.icq.com/scripts/search.dll?to=' . $postrow[$i]['user_icq'] . '" class="gen" title="' . $lang['ICQ'] . '">[<b>' . $lang['cicq'] . '</b>]</a>';
					}
					else
					{
						$icq_status_img = '';
						$icq_img = '';
						$icq = '';
					}
					if ( !empty($postrow[$i]['user_aim']) && $board_config['cgg'] )
					{
						$gg_url = append_sid("gg.$phpEx?mode=gadu&amp;" . POST_USERS_URL . "=$poster_id");
						$aim_img = '<a href="' . $gg_url . '" class="gen" title="' . $lang['AIM'] . ': ' . $postrow[$i]['user_aim'] . '">[<b>' . $lang['aim_mini'] . '</b>]</a>';
						$aim ='<a href="' . $gg_url . '">' . $lang['AIM'] . '</a>';
					}
					else
					{
						$aim_status_img = '';
						$aim_img = '';
						$aim = '';
					}
					$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$poster_id");
					$msn_img = ($postrow[$i]['user_msnm'] && $board_config['cmsn']) ? '<a href="' . $temp_url . '" class="gen" " title="' . $lang['MSNM'] . '">[<b>MSNM</b>]</a> ' : '';
					$msn = ($postrow[$i]['user_msnm']) ? '<a href="' . $temp_url . '">' . $lang['MSNM'] . '</a>' : '';
					$yim_img = ($postrow[$i]['user_yim'] && $board_config['cyahoo']) ? '<a href="http://edit.yahoo.com/config/send_webmesg?.target=' . $postrow[$i]['user_yim'] . '&amp;.src=pg" class="gen" title="' . $lang['YIM'] . '>[<b>YIM</a></b>] ' : '';
					$yim = ($postrow[$i]['user_yim'] ) ? '<a href="http://edit.yahoo.com/config/send_webmesg?.target=' . $postrow[$i]['user_yim'] . '&amp;.src=pg">' . $lang['YIM'] . '</a>' : '';
				}
			}
			else
			{
				$profile_img = '';
				$profile = '';
				$pm_img = '';
				$pm = '';
				$email_img = '';
				$email = '';
				$www_img = '';
				$www = '';
				$icq_status_img = '';
				$icq_img = '';
				$icq = '';
				$aim_img = '';
				$aim = '';
				$msn_img = '';
				$msn = '';
				$yim_img = '';
				$yim = '';
			}

			$link_username = ($show_quickreply) ? '<a href="javascript:emoticon(\'[b]' . $poster_username . '[/b], \')" style="text-decoration: none; font-size : 12;">' : '<a href="' . $temp_url . '" title="' . $lang['Read_profile'] . '" style="text-decoration: none; font-size : 12;">';
			$show_custom_color = false;
			$custom_color_mod = false;
			if ( $board_config['mod_nick_color'] == '' )
			{
				if ( $board_config['custom_color_use'] && $poster_posts >= $board_config['allow_custom_color'] )
				{
					$show_custom_color = true;
				}
				if ( $poster_is_mod || $poster_level == ADMIN || $poster_is_jr_admin )
				{
					$custom_color_mod = true;
				}
				if ( $board_config['custom_color_mod'] && $custom_color_mod )
				{
					$show_custom_color = true;
				}
				if ( $board_config['custom_color_view'] )
				{
					$show_custom_color = true;
				}

				if ( $show_custom_color && $postrow[$i]['can_custom_color'] && $poster_custom_color != '' && $board_config['mod_nick_color'] == '' )
				{
					$poster = $link_username . '<span style="color: #' . $poster_custom_color . '">' . $poster . '</span></a>' . $gender_image . '<br />';
					$poster2 = $link_username . $poster_username . '</a>';
				}
				else
				{
					$poster = $link_username . $poster . '</a>' . $gender_image . '<br />';
					$poster2 = $link_username . $poster_username . '</a>';
				}
			}
			else
			{
				if ( ( $poster_level == ADMIN || $poster_is_jr_admin ) && $postrow[$i]['can_custom_color'] )
				{
					$poster = $link_username . '<span style="color: #' . $poster_custom_color . '">' . $poster . '</span></a>' . $gender_image . '<br />';
					$poster2 = $link_username . $poster_username . '</a>';
				}
				else if ( $poster_is_mod && $postrow[$i]['can_custom_color'] )
				{
					$poster = $link_username . '<span style="color: #' . $board_config['mod_nick_color'] . '">' . $poster . '</span></a>' . $gender_image . '<br />';
					$poster2 = $link_username . $poster_username . '</a>';
				}
				else
				{
					$poster = $link_username . $poster . '</a>' . $gender_image . '<br />';
					$poster2 = $link_username . $poster_username . '</a>';
				}
			}
		}
		else
		{
			$profile_img = '';
			$profile = '';
			$ignore = '';
			$pm_img = '';
			$pm = '';
			$email_img = '';
			$email = '';
			$www_img = '';
			$www = '';
			$icq_status_img = '';
			$icq_img = '';
			$icq = '';
			$aim_img = '';
			$aim_status_img = '';
			$aim = '';
			$msn_img = '';
			$msn = '';
			$yim_img = '';
			$yim = '';
		}

		$temp_url = append_sid("posting.$phpEx?mode=quote&amp;" . POST_POST_URL . "=" . $postrow_post_id);
		if ( $board_config['allow_bbcode'] )
		{
			if ( $board_config['graphic'] )
			{
				$title_style = ($board_config['overlib'] && $show_quickreply) ? 'onMouseOver="return overlib(\'<left>' . $lang['lang_q_quote_e'] . '</left>\', ol_offsetx=-205, CAPTION, \'<center>' . $lang['lang_q_quote'] . '</center>\')" onMouseOut="nd();"' : 'title="' . $lang['lang_q_quote'] . '"';
				$quote_q_img = ($show_quickreply) ? '<a href="javascript:void(null)" onclick="if (document.post && document.post.message) quoteSelection(); return false" onmouseover="selectedText = document.selection? document.selection.createRange().text : document.getSelection();"><img src="' . $images['icon_q_quote'] . '" ' . $title_style . ' border="0" alt="" /></a>&nbsp;' : $quote_q_img = '';
				$quote_img = ($user_id != $poster_id) ? $quote_q_img . '<a href="' . $temp_url . '"><img src="' . $images['icon_quote'] . '" alt="' . $lang['Reply_with_quote'] . '" title="' . $lang['Reply_with_quote'] . '" border="0" /></a>' : '';
				$quote_username = 'onmouseup="if (window.getSelection && window.getSelection() || document.selection && document.selection.createRange && document.selection.createRange().text) quoteAuthor = &quot;' . (($poster_id == ANONYMOUS) ? $lang['Guest'] : $poster_username) . '&quot;"';
			}
			else
			{
				$quote_username = '';
				$quote_img = ($user_id != $poster_id) ? '<a href="' . $temp_url . '" class="gen" title="' . $lang['Reply_with_quote'] . '">[<b>' . $lang['quote_mini'] . '</b>]</a>' : '';
			}
		}
		$quote = '<a href="' . $temp_url . '">' . $lang['Reply_with_quote'] . '</a>';

		$temp_url = append_sid("search.$phpEx?search_author=" . urlencode($poster_username) . "&amp;showresults=posts");
		$search_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_search'] . '" alt="' . $lang['Search_user_posts'] . '" title="' . $lang['Search_user_posts'] . '" border="0" /></a>';
		$search = '<a href="' . $temp_url . '">' . $lang['Search_user_posts'] . '</a>';

		if ( ( $user_id == $poster_id && $is_auth['auth_edit'] ) || $is_auth['auth_mod'] )
		{
			$temp_url = append_sid("posting.$phpEx?mode=editpost&amp;" . POST_POST_URL . "=" . $postrow_post_id);
			if ( $board_config['graphic'] )
			{
				$edit_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_edit'] . '" alt="' . $lang['Edit_delete_post'] . '" title="' . $lang['Edit_delete_post'] . '" border="0" /></a>';
			}
			else
			{
				$edit_img = '<a href="' . $temp_url . '" class="gen" title="' . $lang['Edit_delete_post'] . '">[<b>' . $lang['edit_mini'] . '</b>]</a>';
			}
			$edit = '<a href="' . $temp_url . '">' . $lang['Edit_delete_post'] . '</a>';
		}
		else
		{
			$edit_img = '';
			$edit = '';
		}

		if ( $is_auth['auth_mod'] )
		{
			$temp_url = "modcp.$phpEx?mode=ip&amp;" . POST_POST_URL . "=" . $postrow_post_id . "&amp;" . POST_TOPIC_URL . "=" . $topic_id . "&amp;sid=" . $session_id;
			if ( $user_level == ADMIN | ($board_config['ipview']) )
			{
				if ( $board_config['graphic'] )
				{
					$ip_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_ip'] . '" alt="' . $lang['View_IP'] . '" title="' . $lang['View_IP'] . '" border="0" /></a>';
				}
				else
				{
					$ip_img = '<a href="' . $temp_url . '" class="gen" title="' . $lang['View_IP'] . '">[<b>IP</b>]</a>';
				}
			} 
			else
			{
				$ip_img = '';
			}
			$ip = '<a href="' . $temp_url . '">' . $lang['View_IP'] . '</a>';

			$temp_url = append_sid("posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow_post_id);
			if ( $board_config['graphic'] )
			{
				$delpost_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete_post'] . '" title="' . $lang['Delete_post'] . '" border="0" /></a>';
			}
			else
			{
				$delpost_img = '<a href="' . $temp_url . '" class="gen" title="' . $lang['Delete_post'] . '">[<b>X</b>]</a>';
			}
			$delpost = '<a href="' . $temp_url . '">' . $lang['Delete_post'] . '</a>';
		}
		else
		{
			$ip_img = '';
			$ip = '';

			if ( $user_id == $poster_id && $is_auth['auth_delete'] && $forum_topic_data['topic_last_post_id'] == $postrow_post_id )
			{
				$temp_url = append_sid("posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow_post_id);
				if ( $board_config['graphic'] )
				{
					$delpost_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete_post'] . '" title="' . $lang['Delete_post'] . '" border="0" /></a>';
				}
				else
				{
					$delpost_img = '<a href="' . $temp_url . '" class="gen" title="' . $lang['Delete_post'] . '>[<b>X</b>]</a>';
				}
				$delpost = '<a href="' . $temp_url . '">' . $lang['Delete_post'] . '</a>';
			}
			else
			{
				$delpost_img = '';
				$delpost = '';
			}
		}

		if ( !$board_config['report_disable'] )
		{
			if ( !isset($rp) )
			{
				require_once($phpbb_root_path . 'includes/reportpost.'.$phpEx);
			}
			if ( empty($postrow[$i]['reporter_id']) && ( !$session_logged_in || $poster_id != $user_id ) && !$rp->report_disabled2($poster_id) && $rp->report_auth($user_id) )
			{
				$temp_url = append_sid("report.$phpEx?mode=report&amp;" . POST_POST_URL . "=" . $postrow_post_id);
				$report_img = ($board_config['graphic']) ? '<a href="' . $temp_url . '"><img src="' . $images['icon_report'] . '" alt="' . $lang['Report_post'] . '" title="' . $lang['Report_post'] . '" border="0" /></a>' : '<a href="' . $temp_url . '" title="' . $lang['Report_post'] . '" class="gen">[ <b>!!!</b> ]</a>';
				$report = '<a href="' . $temp_url . '">' . $lang['Report_post'] . '</a>';
			}
			else if ( !empty($postrow[$i]['reporter_id']) && ( ( $session_logged_in && $postrow[$i]['reporter_id'] == $user_id ) || ( $is_auth['auth_mod'] && $rp->check_access() ) ) )
			{
				$temp_url = append_sid("report.$phpEx?mode=del_report&amp;" . POST_POST_URL . "=" . $postrow_post_id);
				$report_img = ($board_config['graphic']) ? '<a href="' . $temp_url . '"><img src="' . $images['icon_del_report'] . '" alt="' . $lang['Report_del'] . '" title="' . $lang['Report_del'] . '" border="0" /></a>' : '<a href="' . $temp_url . '" title="' . $lang['Report_del'] . '" class="gen">[ <b>!X!</b> ]</a>';
				$report = '<a href="' . $temp_url . '">' . $lang['Report_del'] . '</a>';
			}
			else
			{
				$report_img = '';
				$report = '';
			}
		}
		else
		{
			$report_img = '';
			$report = '';
		}

		$post_subject = ( $postrow[$i]['post_subject'] != '' ) ? $postrow[$i]['post_subject'] : '';

		$message = $postrow[$i]['post_text'];

		$bbcode_uid = $postrow[$i]['bbcode_uid'];

		$user_sig = '';
		$user_sig_image = '';
		$user_sig_bbcode_uid = '';
		if ( $poster_id != ANONYMOUS && $postrow[$i]['user_allowsig'] )
		{
			$user_sig = ($postrow[$i]['enable_sig'] && $postrow[$i]['user_sig'] != '' && $board_config['allow_sig']) ? $postrow[$i]['user_sig'] : '';
			$user_sig_bbcode_uid = $postrow[$i]['user_sig_bbcode_uid'];
			$user_sig_image = ( $postrow[$i]['enable_sig'] && $postrow[$i]['user_sig_image'] != '' && $board_config['allow_sig'] && $board_config['allow_sig_image'] ) ? $postrow[$i]['user_sig_image'] : '';
			$user_sig = ($userdata['user_allow_signature']) ? $user_sig : '';
			$user_sig_image = ( $userdata['user_allow_signature'] && $userdata['user_allow_sig_image'] ) ? $user_sig_image : '';
		}
		
		if ( (!$board_config['allow_html'] || !$userdata['user_allowhtml']) && (!( ($poster_is_mod_here && $board_config['mod_html']) || ($board_config['admin_html'] && $poster_level == ADMIN) || ($board_config['jr_admin_html'] && $poster_is_jr_admin) )) )
		{
			if ( $user_sig != '' )
			{
				$user_sig = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $user_sig);
			}

			if ( $postrow[$i]['enable_html'] )
			{
				$message = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $message);
			}
		}

		$post_text_html = (eregi('<td>', $message) || eregi('<tr>', $message) || eregi('<table>', $message)) ? true : false;

		if ( $user_level == ADMIN || is_jr_admin_buffered($user_id) || $is_auth['auth_mod'] )
		{
			$message = preg_replace("#\[mod\](.*?)\[/mod\]#si", "<br><u><b>Mod Info:</u><br>[</b>\\1<b>]</b><br>", $message);
		}
		elseif ( eregi("[mod]", $message) )
		{
			$message = preg_replace("#\[mod\](.*?)\[/mod\]#si", "", $message);
  			$message = bbencode_first_pass($message, $bbcode_uid);
		}

		if ( $user_sig != '' && $user_sig_bbcode_uid != '' )
		{
			$user_sig = bbencode_second_pass($user_sig, $user_sig_bbcode_uid, $userdata['username']);
			$user_sig = bbencode_third_pass($user_sig, $user_sig_bbcode_uid, $valid);
		}
		if ( $bbcode_uid != '' )
		{
			$message = bbencode_second_pass($message, $bbcode_uid, $userdata['username']);
			$message = bbencode_third_pass($message, $bbcode_uid, $valid);
		}

		if ( $user_sig != '' )
		{
			$user_sig = make_clickable($user_sig);
		}
		$message = make_clickable($message);

		// Highlight active words (primarily for search)
		if ( $highlight_match )
		{
			// This was shamelessly 'borrowed' from volker at multiartstudio dot de
			// via php.net's annotated manual
			$message = str_replace('\"', '"', substr(@preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "@preg_replace('#\b(" . $highlight_match . ")\b#i', '<span style=\"color:#" . $theme['fontcolor3'] . "\"><b>\\\\1</b></span>', '\\0')", '>' . $message . '<'), 1, -1));
		}

		// Replace naughty words
		if ( !$board_config['show_badwords'] )
		{
			if ( count($orig_word) )
			{
				$post_subject = preg_replace($orig_word, $replacement_word, $post_subject);

				if ( $user_sig != '' )
				{
					$user_sig = str_replace('\"', '"', substr(@preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "@preg_replace(\$orig_word, \$replacement_word, '\\0')", '>' . $user_sig . '<'), 1, -1));
				}

				$message = str_replace('\"', '"', substr(@preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "@preg_replace(\$orig_word, \$replacement_word, '\\0')", '>' . $message . '<'), 1, -1));
			}
		}
		else
		{
			if ( $user_sig != '' )
			{
				replace_bad_words($orig_word, $replacement_word, $user_sig);
			}

			replace_bad_words($orig_word, $replacement_word, $post_subject);
			replace_bad_words($orig_word, $replacement_word, $message);
		}

		// Parse smilies
		if ( $board_config['allow_smilies'] )
		{
			if ( $postrow[$i]['user_allowsmile'] && $user_sig != '' )
			{
				$user_sig = smilies_pass($user_sig);
			}

			if ( $postrow[$i]['enable_smilies'] )
			{
				$message = smilies_pass($message);
			}
		}

		// Replace newlines (we use this rather than nl2br because
		// till recently it wasn't XHTML compliant)
		if ( $user_sig != '' )
		{
			$user_sig = '<br />_________________<br />' . str_replace("\n", "\n<br />\n", $user_sig);
		}
		if ( $user_sig_image != '' )
		{
			$user_sig_image = (($user_sig != '') ? '<br />' : '<br />_________________<br />') . '<img src="' . $board_config['sig_images_path'] . '/' . $user_sig_image . '" border="0" alt="" />';
		}

		if ( !(($postrow[$i]['enable_html'] && $post_text_html && (($poster_is_mod_here && $board_config['mod_html']) || ($board_config['admin_html'] && $poster_level == ADMIN) || ($board_config['jr_admin_html'] && $poster_is_jr_admin)))) )
		{
			$message = str_replace("\n", "\n<br />\n", $message);
		}

		// Editing information
		if ( $poster_level == '1' && $board_config['hide_edited_admin'] )
		{
			$hide_edited_admin = true;
		}
		if ( $postrow[$i]['post_edit_count'] && !$hide_edited_admin )
		{
			$l_edit_time_total = ($postrow[$i]['post_edit_count'] == 1) ? $lang['Edited_time_total'] : $lang['Edited_times_total'];
		
			$l_edited_by = '<br /><br />' . sprintf($l_edit_time_total, $poster2, create_date($board_config['default_dateformat'], $postrow[$i]['post_edit_time'], $board_config['board_timezone']), $postrow[$i]['post_edit_count']);
		}
		else
		{
			$l_edited_by = '';
		}

		if ( $board_config['post_icon'] == 1 )
		{
			if ( $postrow[$i]['post_icon'] == 0 )
			{
				$icon = '';
			} 
			else
			{
				$icon = '<img src="' . $images['rank_path'] . 'icon/icon' . $postrow[$i]['post_icon'] . '.gif" alt="' . $lang['postmsgicon'] . '" border="0">&nbsp;';
			}
		}

		// Helped
		$helped_me_show = $special_rank = $icon_help = '';
		if ( $board_config['helped'] && $do_helped )
		{
			$rank = ($postrow[$i]['special_rank']) ? intval($postrow[$i]['special_rank']) : 0;

			$helped_how_much = ($rank < 2) ? $lang['help_1'] : $lang['help_more'];

			$special_rank = ($rank > 0 && $poster_id != ANONYMOUS && $postrow[$i]['user_allow_helped']) ? (($postrow[$i]['user_gender'] == 2) ? $lang['postrow_help_she'] : $lang['postrow_help']) . $rank . $helped_how_much . '<br />' : '';

			if ( $postrow[$i]['post_marked'] == 'y' )
			{
				$row_class = 'row_helped';
			}
			elseif ( $userdata['session_logged_in'] && $poster_id != ANONYMOUS && $poster_id != $userdata['user_id'] && $userdata['user_allow_helped'] && $userdata['user_id'] == $forum_topic_data['topic_poster'] )
			{
				$icon_help = ($postrow[$i]['user_gender'] == 2) ? $images['icon_help-a'] : $images['icon_help'];
				$helped_me_show = '<a href="' . append_sid("viewtopic.php?t=$topic_id&amp;p_add=$postrow_post_id") . '"><img src="' . $icon_help . '" border="0" title="' . $lang['He_helped'] . '" alt=""></a> ';
			}
		}
		// Helped end
	}
	// Again this will be handled by the templating
	// code at some point

	$template->assign_block_vars('postrow', array(
		'ICON' => $icon,
		'POST_EXPIRE' => $post_expire_date,
		'ROW_COLOR' => '#' . (!($i % 2)) ? $theme['td_color1'] : $theme['td_color2'],
		'ROW_CLASS' => (!$row_class) ? (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'] : $row_class,
		'POSTER_NAME' => (!$show_post && $userdata['user_id'] != $poster_id) ? '' : $poster,
		'POSTER_AGE' => ($poster_age) ? $poster_age . '<br />' : '',
		'POSTER_RANK' => $poster_rank,
		'CUSTOM_RANK' => $poster_custom_rank,
		'RANK_IMAGE' => $rank_image,
		'POSTER_JOINED' => ($poster_joined) ? $poster_joined . '<br />' : '',
		'POSTER_POSTS' => ($poster_post) ? $poster_post . '<br />' : '',
		'POSTER_FROM' => ($poster_from) ? $poster_from . '<br />' : '',
		'POSTER_AVATAR' => $poster_avatar,
		'POST_DATE' => $post_date,
		'POST_SUBJECT' => $post_subject,
		'HELPED_ME' => $helped_me_show,
		'SPECIAL_RANK' => $special_rank,
		'VIEW_USER_AGENT' => ($board_config['cagent'] && $postrow[$i]['user_agent'] && !$ignore_this_post && $show_post) ? user_agent($postrow[$i]['user_agent'], $images['images']): '',
		'MESSAGE' => (!$show_post && (($userdata['user_id'] == $poster_id) || (!$postrow[$i]['post_approve'] && $is_auth['auth_mod']))) ? '<i><b>' . $lang['Post_no_approved'] . '</b></i><br /><br />' . $message : $message,
		'SIGNATURE' => $user_sig, 
		'SIG_IMAGE' => $user_sig_image,
		'EDITED_MESSAGE' => $l_edited_by, 
		'MINI_POST_IMG' => $mini_post_img,
		'PROFILE_IMG' => $profile_img, 
		'PROFILE' => $profile, 
		'IGNORE' => $ignore,
		'SEARCH_IMG' => $search_img,
		'SEARCH' => $search,
		'PM_IMG' => $pm_img,
		'PM' => $pm,
		'EMAIL_IMG' => $email_img,
		'EMAIL' => $email,
		'WWW_IMG' => $www_img,
		'WWW' => $www,
		'ICQ_STATUS_IMG' => ($board_config['cicq']) ? $icq_status_img : '',
		'ICQ_IMG' => ($board_config['cicq']) ? $icq_img : '',
		'ICQ' => ($board_config['cicq']) ? $icq : '',
		'AIM_IMG' => ($board_config['cgg']) ? $aim_img : '',
		'AIM' => ($board_config['cgg']) ? $aim : '',
		'AIM_STATUS_IMG' => ($board_config['cgg']) ? $aim_status_img : '',
		'MSN_IMG' => $msn_img,
		'MSN' => $msn,
		'YIM_IMG' => $yim_img,
		'YIM' => $yim,
		'EDIT_IMG' => $edit_img,
		'EDIT' => $edit,
		'QUOTE_IMG' => $quote_img,
		'QUOTE' => $quote,
		'QUOTE_USERNAME' => $quote_username,
		'IP_IMG' => $ip_img,
		'IP' => $ip,
		'DELETE_IMG' => $delpost_img,
		'DELETE' => $delpost,
		'REPORT_IMG' => $report_img,
		'REPORT' => $report,
		'TR_FOOTER' => ($board_config['post_footer']) ? '<tr><td class="spaceRow" colspan="2" height="1"><img src="' . $images['spacer'] . '" alt="" width="1" height="1" /></td></tr>' : '',
		'NEW_POST' => ($new_post) ? ($board_config['read_tracking']) ? $lang['unread_post'] : $lang['New_post'] : '',
		'L_MINI_POST_ALT' => $mini_post_alt,
		'POST_ID' => $postrow_post_id,
		'U_MINI_POST' => $mini_post_url,
		'ACCEPT-REJECT_POST' => ($forum_moderate && !$postrow[$i]['post_approve'] && $is_auth['auth_mod']) ? $lang['Accept'] . '<input type="checkbox" name="accept_post[]" value="' . $postrow_post_id . '">&nbsp;' . $lang['Reject'] . '<input type="checkbox" name="reject_post[]" value="' . $postrow_post_id . '">&nbsp;&nbsp;' : '',
		'U_POST_ID' => $postrow_post_id)
	);

	if ( $custom_fields_exists )
	{
		for($j = 0; $j < count($custom_fields[0]); $j++)
		{
			$user_field = $postrow[$i]['user_field_' . $custom_fields[0][$j]];
			$user_allow_field = $postrow[$i]['user_allow_field_' . $custom_fields[0][$j]];
			$desc = (isset($lang[$custom_fields[1][$j]])) ? $lang[$custom_fields[1][$j]] : $custom_fields[1][$j];

			$remove_string = array('.gif', '.jpg', '<br>', '<br />', '-#');
			$replace_string = array('', '', '', '', '');
			$desc_post = (isset($lang[$custom_fields[1][$j]])) ? $lang[$custom_fields[1][$j]] : $custom_fields[1][$j];
			$max_value = $custom_fields[2][$j];
			$min_value = $custom_fields[3][$j];
			$numerics = $custom_fields[4][$j];
			$jumpbox = $custom_fields[5][$j];
			$makelinks = $custom_fields[6][$j];
			$view_post = $custom_fields[7][$j];
			$desc2 = '';

			if ( !empty($user_field) && $user_allow_field)
			{
				$auth_field = false;
				if ( strlen($user_field) > $max_value )
				{
					$user_field = substr($user_field, 0, intval($max_value));
				}
				if ( strlen($user_field) < $min_value )
				{
					$user_field = '';
				}

				if ( $numerics )
				{
					if ( !is_numeric($user_field) )
					{
						$user_field = '';
					}
				}
				else
				{
					if ( $makelinks )
					{
						$user_field = make_clickable($user_field);
					}
					if ( $jumpbox )
					{
						$options = explode(',', $jumpbox);
						for($k = 0; $k+1 <= count($options); $k++)
						{
							$auth_field = ($options[$k] == $user_field) ? true : $auth_field;
						}
						if ( eregi('.gif', $options[count($options) -1 ]) || eregi('.jpg', $options[count($options) -1 ]))
						{
							$field_name = str_replace(array('_', '.gif', '.jpg'), array(' ', '', ''), $user_field);
							$user_field = '<img src="' . $images['images'] . '/custom_fields/' . $user_field . '" border="0" alt="' . $field_name . '" title="' . $field_name . '" align="top" /><br />';
							$desc2 = $desc . ':<br />';
						}
					}
				}
				if ( $auth_field || !$jumpbox )
				{
					$desc = (eregi('<br>', $desc)) ? str_replace('<br>', '', $desc) . ':<br />' : $desc . ': ';
					$desc = ($desc2) ? $desc2 : $desc;
			
					if ( $view_post == '2' )
					{
						$template->assign_block_vars('postrow.custom_fields_avatar', array(
							'DESC' => (eregi('-#', $desc)) ? '' : $desc,
							'FIELD' => $user_field)
						);
					}
					else if ( $view_post == '1' )
					{
						$template->assign_block_vars('postrow.custom_fields_post', array(
							'DESC' => (eregi('-#', $desc_post)) ? '' : '<b>' . $desc_post . ':</b> ',
							'FIELD' => $user_field)
						);
					}
					else
					{
						$template->assign_block_vars('postrow.custom_fields_upost', array(
							'DESC' => (eregi('-#', $desc)) ? '' : $desc,
							'FIELD' => $user_field)
						);
					}
				}
			}
		}
	}

	$check_view_post = false;
	for($j = 0; $j < count($custom_fields[0]); $j++)
	{
		if ($custom_fields[7][$j] == '3')
		{
			$check_view_post = true;
		}
	}
	if ( !$check_view_post && $board_config['post_footer'] )
	{
		$template->assign_block_vars('postrow.top', array(
			'TOP_IMG' => ($i == 0) ? '<a href="#' . $postrow[($total_posts-1)]['post_id']	 . '"><img src="' . $images['topic_mod_merge'] . '" alt="' . $lang['Go_to_bottom'] . '" title="' . $lang['Go_to_bottom'] . '" border="0" /></a>' : '<a href="#top"><img src="' . $images['topic_mod_move'] . '" alt="' . $lang['Back_to_top'] . '" title="' . $lang['Back_to_top'] . '" border="0" /></a>',
			'L_BACK_TO_TOP' => ($i == 0) ? '<a href="#' . $postrow[($total_posts-1)]['post_id']	 . '" style="text-decoration: none; font-size : 9;">' . $lang['Go_to_bottom'] . '</a>' : '<a href="#top" style="text-decoration: none; font-size : 9;">' . $lang['Back_to_top'] . '</a>')
		);
	}

	if ( defined('ATTACHMENTS_ON') )
	{
		display_post_attachments($postrow_post_id, $postrow[$i]['post_attachment']);
	}

	if ( $board_config['viewtopic_warnings'] && $board_config['warnings_enable'] )
	{
		$val = $warnings[$poster_id];

		if ( $val > 0 )
		{
			$max_warn = $board_config['ban_warnings'];
			$warn_percent = ($val > $max_warn) ? 100 : $val / $max_warn * 100;

			$template->assign_block_vars('postrow.warnings', array(
				'WARNINGS' => $lang['Warnings_viewtopic'],
				'HOW' => '<a href="' . append_sid("warnings.$phpEx?mode=detail&amp;userid=" . $poster_id . "") . '" class="mainmenu"><b>' . $val . '</b></a>',
				'WRITE' => $board_config['write_warnings'],
				'MAX' => $max_warn,
				'POSTER_W_WIDTH' => $warn_percent,
				'POSTER_W_EMPTY' => (100 - $warn_percent))
			);
		}
	}

	// Level Mod
	if ( $board_config['clevell'] || $board_config['cleveld'] && $poster_id != ANONYMOUS && $board_config['graphic'] )
	{
		if ( $poster_posts < 1 )
		{
			$level_level = 0;
		}
		else
		{
			$level_level = floor(pow(log10( $poster_posts), 3)) + 1;
		}
		$level_avg_ppd = 5;
		$level_bonus_redux = 5;
		$level_user_ppd = ($poster_posts/max(1, round((time() - $postrow[$i]['user_regdate'])/86400 )));
		if ( $level_level < 1 )
		{
			$level_hp = '0/0';
			$level_hp_percent = 0;
		}
		else
		{
			$level_max_hp = floor((pow( $level_level, (1/4) ) ) * (pow( 10, pow( $level_level+2, (1/3) ) ) )/(1.5) );

			if ( $level_user_ppd >= $level_avg_ppd )
			{
				$level_hp_percent = floor((.5 + (($level_user_ppd - $level_avg_ppd)/($level_bonus_redux * 2))) * 100);
			}
			else
			{
				$level_hp_percent = floor($level_user_ppd/($level_avg_ppd/50));
			}
	
			if ( $level_hp_percent > 100 )
			{
				//Give the user a bonus to max HP for greater than 100% hp.
				$level_max_hp += floor(($level_hp_percent - 100) * pi());
				$level_hp_percent = 100;
			}
			else
			{
				$level_hp_percent = max(0, $level_hp_percent);
			}
	
			$level_cur_hp = floor($level_max_hp * ($level_hp_percent/100) );
	
			//Be sure a user has no more than max, and no less than zero hp.
			$level_cur_hp = max(0, $level_cur_hp);
			$level_cur_hp = min($level_max_hp, $level_cur_hp);
	
			$level_hp = $level_cur_hp . '/' . $level_max_hp;
		}
		$level_user_days = max(1, round(( time() - $postrow[$i]['user_regdate'] ) / 86400));
		$level_post_mp_cost = 2.5;
		$level_mp_regen_per_day = 4;
		if ( $level_level < 1 )
		{
			$level_mp = '0/0';
			$level_mp_percent = 0;
		}
		else
		{
			$level_max_mp = floor((pow( $level_level, (1/4) ) ) * (pow( 10, pow($level_level+2, (1/3)))) / (pi()) );
			$level_mp_cost = $poster_posts * $level_post_mp_cost;
			$level_mp_regen = max(1, $level_user_days * $level_mp_regen_per_day);
			$level_cur_mp = floor($level_max_mp - $level_mp_cost + $level_mp_regen);
			$level_cur_mp = max(0, $level_cur_mp);
			$level_cur_mp = min($level_max_mp, $level_cur_mp);
			$level_mp = $level_cur_mp . '/' . $level_max_mp;
			$level_mp_percent = floor($level_cur_mp/$level_max_mp * 100 );
		}
		if ( $level_level == 0 )
		{
			$level_exp = '0/0';
			$level_exp_percent = 100;
		}
		else
		{
			$level_posts_for_next = floor(pow(10, pow($level_level, (1/3))));
			@$level_posts_for_this = max(1, floor(pow( 10, pow(($level_level - 1), (1/3)))));
			$level_exp = ($poster_posts - $level_posts_for_this) . "/" . ($level_posts_for_next - $level_posts_for_this);
			$level_exp_percent = floor((($poster_posts - $level_posts_for_this) / max(1, ($level_posts_for_next - $level_posts_for_this))) * 100);
		}

		if ( $board_config['cleveld'] )
		{
			if ( $board_config['post_footer'] )
			{
				$template->assign_block_vars('postrow.levelmodd', array(
					"POSTER_HP" => $level_hp,
					"POSTER_HP_WIDTH" => $level_hp_percent,
					"POSTER_HP_EMPTY" => ( 100 - $level_hp_percent ),
					"POSTER_MP" => $level_mp,
					"POSTER_MP_WIDTH" => $level_mp_percent,
					"POSTER_MP_EMPTY" => ( 100 - $level_mp_percent ),
					"POSTER_EXP" => $level_exp,
					"POSTER_EXP_WIDTH" => $level_exp_percent,
					"POSTER_EXP_EMPTY" => ( 100 - $level_exp_percent ),
					"POSTER_LEVEL" => $level_level)
				);
			}
		}
		if ( $board_config['clevell'] )
		{
			$template->assign_block_vars('postrow.levelmodl', array(
				"POSTER_HP" => $level_hp,
				"POSTER_HP_WIDTH" => $level_hp_percent,
				"POSTER_HP_EMPTY" => ( 100 - $level_hp_percent ),
				"POSTER_MP" => $level_mp,
				"POSTER_MP_WIDTH" => $level_mp_percent,
				"POSTER_MP_EMPTY" => ( 100 - $level_mp_percent ),
				"POSTER_EXP" => $level_exp,
				"POSTER_EXP_WIDTH" => $level_exp_percent,
				"POSTER_EXP_EMPTY" => ( 100 - $level_exp_percent ),
				"POSTER_LEVEL" => $level_level)
			);
		}
	}
	// End Level Mod

	if ( !empty($postrow[$i]['user_aim']) && $board_config['cgg'] && $poster_id != ANONYMOUS && $board_config['cgg'] )
	{
		$template->assign_block_vars('postrow.aim', array());
	}
	if ( !empty($postrow[$i]['user_icq']) && $board_config['cicq'] && $poster_id != ANONYMOUS && $board_config['cicq'] )
	{
		$template->assign_block_vars('postrow.icq', array());
	}
}

if ( $is_auth['auth_delete'] )
{
	$template->assign_block_vars('switch_auth_delete', array());
}

if ( $show_quickreply )
{
	include($phpbb_root_path . 'quick_reply.'.$phpEx);
}

if ( $board_config['read_tracking'] )
{
	if ( $mark_unread == '' )
	{
		smart_read_topic( $topic_id );
	}
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>