<?php
/***************************************************************************
 *					warnings.php
 *					-------------------
 *	begin			: 11, 09, 2001
 *	copyright		: (C) 2003 Przemo (http://www.przemo.org)
 *	email			: przemo@przemo.org
 *	version			: ver. 1.9 2004/05/03 11:44
 *
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';

include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include_once($phpbb_root_path . 'includes/bbcode.'.$phpEx);
require($phpbb_root_path . 'includes/functions_search.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_VIEWMEMBERS);
init_userprefs($userdata);

require($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_warnings.' . $phpEx);

if ( $userdata['session_logged_in'] && $board_config['redirect_after_registering'] )
{
	if ((time() - $userdata['user_lastvisit']) < $board_config['r_a_r_time'] )
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['redirect_info'], '<a href="' . $board_config['redirect_address'] . '">', '</a>', '<meta http-equiv="refresh" content="4;url=' . $board_config['redirect_address'] . '">'));
	}
}

$page_title = $lang['warnings'];

$user_topics_per_page = ($userdata['user_topics_per_page'] > 0) ? $userdata['user_topics_per_page'] : '25';

if ( !$board_config['warnings_enable'] )
{
	redirect(append_sid("index.$phpEx", true));
}

if ( isset($HTTP_GET_VARS['action']) || isset($HTTP_POST_VARS['action']) )
{
	$action = (isset($HTTP_GET_VARS['action'])) ? $HTTP_GET_VARS['action'] : $HTTP_POST_VARS['action'];
}

if ( $action == 'hide' || $action == 'show')
{
	if ( $action == 'show' )
	{
		@setcookie('warnings_view',on , (time()+3600*9000), $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
	}
	else
	{
		@setcookie('warnings_view',off , (time()+3600*9000), $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
	}
	redirect(append_sid("warnings.$phpEx", true));
}

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

function get_username($user_id)
{
	global $db;
	$sql = "SELECT username
		FROM " . USERS_TABLE . "
		WHERE user_id = $user_id";
	if ( !($result = $db->sql_query($sql)) )
	{
			message_die(GENERAL_ERROR, 'Could not get username from users table', '', __LINE__, __FILE__, $sql);
	}
	$rowname = $db->sql_fetchrow($result);
	return $rowname['username'];
}

function get_user_id($username)
{
	global $db, $lang;
	$sql = "SELECT user_id
		FROM " . USERS_TABLE . "
		WHERE username = '" . str_replace("\'", "''", $username) . "'";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, $lang['wrong_user']);
	}

	$rowname = $db->sql_fetchrow($result);
	if ( $rowname['user_id'] < 1 )
	{
		message_die(GENERAL_ERROR, $lang['wrong_user']);
	}

	return $rowname['user_id'];
}

function get_value($user_id)
{
	global $db;
	$sql = "SELECT SUM(value) as val
		FROM " . WARNINGS_TABLE . "
		WHERE userid = $user_id
			AND archive = '0'";
	$result = $db->sql_query($sql);

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query value info from warnings table', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	return $row['val'];
}

function count_warnings($userid)
{
	global $db;
	$sql = "SELECT COUNT(id) AS total
		FROM ". WARNINGS_TABLE ."
		WHERE archive = '0'
			AND userid = $userid";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query value count from warnings table', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);
	$warnings = $row['total'];

	return $warnings;
}

$subtitle = '';
$admin = ($userdata['user_level'] == ADMIN) ? true : false;
$mod = (is_mod($userdata['user_id']) || is_jr_admin($userdata['user_id'])) ? true : false;
$can_edit = ($admin || ($mod && $board_config['mod_warnings'] && $board_config['mod_edit_warnings'])) ? true : false;
$can_add = ($admin || ($mod && $board_config['mod_warnings'])) ? true : false;
$can_view_modid = ((!$board_config['warnings_mods_public'] && ($admin || $mod)) || $board_config['warnings_mods_public']) ? true : false;

$template->set_filenames(array('warning_body' => 'warnings_body.tpl'));

$sql = "SELECT COUNT(id) AS total
	FROM " . WARNINGS_TABLE;
$result = $db->sql_query($sql);

$row = $db->sql_fetchrow($result);
$list_empty = ($row['total'] < 1) ? $lang['list_empty'] : '';

$value = intval($HTTP_POST_VARS['value']);
$reason = str_replace("\'", "''", htmlspecialchars($HTTP_POST_VARS['reason']));

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = (isset($HTTP_GET_VARS['mode'])) ? $HTTP_GET_VARS['mode'] : $HTTP_POST_VARS['mode'];
}
else
{
	$mode = '';
}
if ( isset($HTTP_GET_VARS['userid']) || isset($HTTP_POST_VARS['userid']) )
{
	$userid = (isset($HTTP_GET_VARS['userid'])) ? intval($HTTP_GET_VARS['userid']) : intval($HTTP_POST_VARS['userid']);
}
if ( isset($HTTP_GET_VARS['id']) || isset($HTTP_POST_VARS['id']) )
{
	$id = (isset($HTTP_GET_VARS['id'])) ? intval($HTTP_GET_VARS['id']) : intval($HTTP_POST_VARS['id']);
}

if ( isset($HTTP_GET_VARS['archive']) || isset($HTTP_POST_VARS['archive']) )
{
	$archive = (isset($HTTP_GET_VARS['archive'])) ? $HTTP_GET_VARS['archive'] : $HTTP_POST_VARS['archive'];
}
if ( isset($HTTP_GET_VARS['modid']) || isset($HTTP_POST_VARS['modid']) )
{
	$modid = (isset($HTTP_GET_VARS['modid'])) ? intval($HTTP_GET_VARS['modid']) : intval($HTTP_POST_VARS['modid']);
}
if ( isset($HTTP_GET_VARS['username']) || isset($HTTP_POST_VARS['username']) )
{
	$username = (isset($HTTP_GET_VARS['username'])) ? trim(strip_tags(htmlspecialchars($HTTP_GET_VARS['username']))) : trim(strip_tags(htmlspecialchars($HTTP_POST_VARS['username'])));
}

$start = (isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if (isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if (isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

$mode_types_text = array($lang['Sort_Joined'], $lang['Sort_Last_visit'], $lang['Sort_Username'], $lang['Location'], $lang['Total_posts'], $lang['Email'], $lang['Website']);
$mode_types = array('joindate', 'lastvisit', 'username', 'location', 'posts', 'email', 'website');

$select_sort_mode = '<select name="sort">';

for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ($sort == $mode_types[$i]) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';

if ( $sort_order == 'ASC' )
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

if ( isset($HTTP_GET_VARS['sort']) || isset($HTTP_POST_VARS['sort']) )
{
	$sort = (isset($HTTP_POST_VARS['sort'])) ? $HTTP_POST_VARS['sort'] : $HTTP_GET_VARS['sort'];

	switch( $sort )
	{
		case 'joindate':
			$order_by = "u.user_regdate $sort_order LIMIT $start, $user_topics_per_page";
			break;
		case 'lastvisit':
			$order_by = "u.user_lastvisit $sort_order LIMIT $start, $user_topics_per_page";
			break;
		case 'username':
			$order_by = "u.username $sort_order LIMIT $start, $user_topics_per_page";
			break;
		case 'location':
			$order_by = "u.user_from $sort_order LIMIT $start, $user_topics_per_page";
			break;
		case 'posts':
			$order_by = "u.user_posts $sort_order LIMIT $start, $user_topics_per_page";
			break;
		case 'email':
			$order_by = "u.user_email $sort_order LIMIT $start, $user_topics_per_page";
			break;
		case 'website':
			$order_by = "u.user_website $sort_order LIMIT $start, $user_topics_per_page";
			break;
		default:
			$order_by = "u.username $sort_order LIMIT $start, $user_topics_per_page";
			break;
	}
}
else
{
	$order_by = "u.username $sort_order LIMIT $start, $user_topics_per_page";
}

if ( !$mode )
{
	$sql = "SELECT COUNT(id) AS total
		FROM " . WARNINGS_TABLE . "
		WHERE archive = '1'
		LIMIT 1";
	$result = $db->sql_query($sql);

	$check = $db->sql_fetchrow($result);

	$template->assign_block_vars('default', array(
		'ARCHIVE' => ($check['total'] >= 1) ? '<a href="' . append_sid("warnings.$phpEx?mode=archive") . '" class="mainmenu">' . $lang['warning_archive'] . '</a>' : '')
	);

	$subtitle = $lang['list_users'];
	if ( $list_empty != '' )
	{
		$subtitle = $list_empty;
	}

	$sql = "SELECT w.*, u.username, u.user_gender, u.user_regdate, u.user_posts, u.user_lastvisit, u.user_from, u.user_email, u.user_website
		FROM " . WARNINGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.userid = u.user_id
			AND archive = '0'
		GROUP by w.userid
		ORDER BY $order_by"; 

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query warnings table', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$i = 0;
		do
		{
			$username = $row['username']; 
			$userid = $row['userid']; 
			$value = get_value($userid);
			if ( $value >= $board_config['ban_warnings'] )
			{
				$value = '<b>' . $value . '</b><br /><span class="gensmall">' . $lang['banned'] . '</span>';
			}
			else
			{
				$value = ($value >= $board_config['write_warnings']) ? '<b>' . $value . '</b><br /><span class="gensmall">' . $lang['write_denied'] . '</span>' : '<b>' . $value . '</b>';
			}
			$warnings = count_warnings($userid);
			$gender_image = '';
			if ( $board_config['gender'] )
			{
				switch ($row['user_gender'])
				{
					case 1 :
						$gender_image = '&nbsp;<img src="' . $images['icon_minigender_male'] . '" alt="' . $lang['Gender']. ' : ' . $lang['Male'] . '" title="' . $lang['Male'] . '" border="0" />';
					break;
					case 2 :
						$gender_image = '&nbsp;<img src="' . $images['icon_minigender_female'] . '" alt="' . $lang['Gender']. ' : ' . $lang['Female'] . '" title="' . $lang['Female'] . '" border="0" />';
					break;
					default : $gender_image = '';
				}
			}
			$memberdays = max(1, round( ( time() - $row['user_regdate'] ) / 86400 ));

			if ( $row['user_posts'] != 0 )
			{
				$total_posts = get_db_stat('postcount');
				$percentage = ($total_posts) ? min(100, ($row['user_posts'] / $total_posts) * 100) : 0;
			}
			else
			{
				$percentage = 0; $total_posts = '';
			}

			$sql = "SELECT post_time, post_id
				FROM " . POSTS_TABLE . "
				WHERE poster_id = $userid
				ORDER BY post_time DESC LIMIT 1";
			if ( !($result_p = $db->sql_query($sql)) ) 
			{ 
				message_die(GENERAL_ERROR, 'Error getting user last post time', '', __LINE__, __FILE__, $post_time_sql); 
			} 
			$rowpost = $db->sql_fetchrow($result_p); 

			$template->assign_block_vars('default_list', array(
				'ROW_CLASS' => (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'],
				'WARNINGS' => $warnings,
				'VALUE' => $value,
				'U_VIEWPROFILE' => '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $userid) . '" title="' . $lang['Profile'] . '"><b>' . $username . '</b></a>' . $gender_image . '',
				'DETAIL' => '<a href="' . append_sid("warnings.$phpEx?mode=detail&amp;userid=$userid") . '" class="gensmall">' . $lang['l_whoisonline'] . '</a>',
				'LASTPOST' => ( isset($rowpost['post_time']) ) ? '<img src="' . $images['icon_minipost'] . '"><a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$rowpost[post_id]#$rowpost[post_id]").'" class=gensmall>'.create_date($board_config['default_dateformat'], $rowpost['post_time'], $board_config['board_timezone']) . '</a>' : $lang['None'],
				'POSTS' => $row['user_posts'],
				'PERIOD' => sprintf($lang['Period'], $memberdays))
			);
			$i++;
		}
		while ( $row = $db->sql_fetchrow($result) );
	}
}

if ( $mode == 'detail' )
{
	$template->assign_block_vars('detail', array());

	$sql = "SELECT w.*, u.username
		FROM " . WARNINGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.userid = $userid
			AND w.archive = '0'
			AND w.userid = u.user_id
		ORDER BY w.date DESC";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query warnings table', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$i = 0;
		do
		{
			$username = $row['username'];
			$subtitle = $lang['view_warning_detail'] . ': <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['userid']) . '" title="' . $lang['Profile'] . '">' . $username . '</a>'; 
			$id = $row['id'];
			$modname = get_username($row['modid']);
			$mod_id = $row['modid'];
			$reason = $row['reason'];
			$reason = trim($reason);
			$reason = make_clickable($reason);
			$reason = str_replace(array("\n", "[u]", "[b]", "[i]", "[/i]", "[/b]", "[/u]"), array("\n<br />\n", "<u>", "<b>", "<i>", "</i>", "</b>", "</u>"), $reason);

			if ( $userdata['user_id'] == $row['modid'] && $can_add || $can_edit )
			{
				$delete_img = ($admin) ? "&nbsp;<a href=\"warnings.$phpEx?mode=delete&amp;id=$id&amp;userid=$userid&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete'] . '" title="' . $lang['Delete'] . '" border="0" /></a>' : '';
				$l_action = $lang['action'];
				$action_url = '<a href="' . append_sid("warnings.$phpEx?mode=edit&amp;id=$id") . '"><img src="' . $images['icon_edit'] . '" alt="' . $lang['edit_mini'] . '" title="' . $lang['edit_mini'] . '" border="0" /></a>' . $delete_img . '';
			}
			else
			{
				$l_action = '';
				$action_url = '';
			}

			$template->assign_block_vars('detail_list', array(
				'ROW_CLASS' => ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
				'VALUE' => $row['value'],
				'ACTION' => $action_url,
				'MODID' => ($can_view_modid) ? '<a href="' . append_sid("warnings.$phpEx?mode=view_modid&amp;modid=$mod_id") . '" title="' . $lang['view_warning_modid'] . ' ' . $modname . '">' . $modname . '</a>' : '',
				'REASON' => smilies_pass($reason),
				'DATE' => create_date($board_config['default_dateformat'], $row['date'], $board_config['board_timezone']))
			);
			$i++;
		}
		while ( $row = $db->sql_fetchrow($result) );
	}
}

if ( $mode == 'edit' && ( $admin || $mod ))
{
	$sql = "SELECT * FROM " . WARNINGS_TABLE . "
		WHERE id = $id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query warnings table', '', __LINE__, __FILE__, $sql);
	}
	$rowedit = $db->sql_fetchrow($result);

	$template->assign_block_vars('edit', array(
		'USERID' => $rowedit['userid'],
		'ID' => $rowedit['id'],
		'VALUE' => $rowedit['value'],
		'REASON' => $rowedit['reason'])
	);
}

if ( $mode == 'archive' )
{
	$subtitle = $lang['warning_archive'];
	$template->assign_block_vars('archive', array());

	$sql = "SELECT w.*, u.username
		FROM " . WARNINGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE archive = '1'
			AND w.userid = u.user_id
		ORDER BY u.username ASC";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query archive warnings', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$i = 0;
		do
		{
			$user_id = $row['userid'];
			$id = $row['id'];
			$l_action = $action = '';

			if ( $admin )
			{
				$l_action = $lang['action'];
				$action_url = '<a href="' . append_sid("warnings.$phpEx?mode=edit&amp;id=$id") . '"><img src="' . $images['icon_edit'] . '" alt="' . $lang['edit_mini'] . '" title="' . $lang['edit_mini'] . '" border="0" /></a>&nbsp;<a href="' . append_sid("warnings.$phpEx?mode=delete&amp;id=$id&amp;userid=$userid&amp;sid=" . $userdata['session_id'] . "") . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete'] . '" title="' . $lang['Delete'] . '" border="0" /></a>';
			}

			$template->assign_block_vars('archive_list', array(
				'ROW_CLASS' => (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'],
				'USERNAME' => '<a href="' . append_sid("warnings.$phpEx?mode=detail&amp;userid=$user_id") . '" title="' . $lang['detail'] . '">' . $row['username'] . '</a>',
				'VALUE' => $row['value'],
				'ACTION' => $action_url,
				'MODID' => ($can_view_modid) ? '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['modid']) . '">' . get_username($row['modid']) . '</a>' : '',
				'REASON' => str_replace(array("\n", "[u]", "[b]", "[i]", "[/i]", "[/b]", "[/u]"), array("\n<br />\n", "<u>", "<b>", "<i>", "</i>", "</b>", "</u>"), make_clickable($row['reason'])),
				'DATE' => create_date($board_config['default_dateformat'], $row['date'], $board_config['board_timezone']))
			);
			$i++;
		}
		while ( $row = $db->sql_fetchrow($result) );
	}
	if ( $userdata['user_level'] == ADMIN )
	{
		if ( isset($HTTP_GET_VARS['rem_all']) )
		{
			$sql = "DELETE FROM " . WARNINGS_TABLE . "
				WHERE archive = 1";
			if ( !($result = $db->sql_query($sql)) ) 
			{
				message_die(GENERAL_ERROR, 'Could not delete from warnings table', '', __LINE__, __FILE__, $sql);
			}
			else 
			{
				$message = '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=warnings.'.$phpEx.'?mode=archive">' . sprintf($lang['Click_view_deleted_warning'], '<a href="' . append_sid("warnings.$phpEx?mode=archive") . '">', '</a>');
				message_die(GENERAL_MESSAGE, $message);
			}
		}
		$template->assign_vars(array(
			'PAGINATION' => '<a href="' . append_sid("warnings.$phpEx?mode=archive&amp;rem_all=1") . '">' . $lang['Delete_all'] . '</a><br /><br />')
		);
	}
}

if ( $mode == 'update' )
{
	if (( $value < 1 ) || ( !$admin && $value > $board_config['mod_value_warning']	))
	{
		$message = $lang['wrong_value'] . '<br /><br />' . sprintf($lang['Click_to_back'], '<a href="' . append_sid("warnings.$phpEx?mode=edit&amp;id=$id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}
	if ( $reason == '' )
	{
		$message = $lang['reason_empty'] . '<br /><br />' . sprintf($lang['Click_to_back'], '<a href="' . append_sid("warnings.$phpEx?mode=edit&amp;id=$id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}
	if ( $value > 0 && $reason != '' )
	{
		$sql = "SELECT modid
			FROM " . WARNINGS_TABLE . "
			WHERE id = $id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR);
		}

		$rowname = $db->sql_fetchrow($result);

		if ( $rowname['modid'] == $userdata['user_id'] || $can_edit )
		{
			$sql = "UPDATE " . WARNINGS_TABLE . "
				SET value = $value, reason = '$reason'
				WHERE id = $id";
			if ( !($result = $db->sql_query($sql)) ) 
			{
				message_die(GENERAL_ERROR, 'Error in updating warnings table', '', __LINE__, __FILE__, $sql);
			}
			else 
			{
				$message = '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=warnings.'.$phpEx.'?mode=detail&amp;userid=' . $userid . '">' . sprintf($lang['Click_view_edited_warning'], '<a href="' . append_sid("warnings.$phpEx?mode=detail&amp;userid=$userid") . '">', '</a>');
				message_die(GENERAL_MESSAGE, $message);
			}
		}
	}
}

if ( $mode == 'delete' && $admin )
{
	if ( $HTTP_GET_VARS['sid'] != $userdata['session_id'] )
	{
		message_die(GENERAL_ERROR, 'Invalid_session');
	}

	$sql = "DELETE FROM " . WARNINGS_TABLE . "
		WHERE id = " . intval($id) . "";
	if ( !($result = $db->sql_query($sql)) ) 
	{
		message_die(GENERAL_ERROR, 'Could not delete from warnings table', '', __LINE__, __FILE__, $sql);
	}
	else 
	{
		$message = '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=warnings.'.$phpEx.'">' . sprintf($lang['Click_view_deleted_warning'], '<a href="' . append_sid("warnings.$phpEx") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}
}

if ( $mode == 'add' && $can_add )
{
	if ( $user_id )
	{
		$username = get_username($user_id);
	}

	$template->assign_block_vars('add', array(
		'L_EXPLAIN' => $lang['add_warning_e'],
		'L_USERNAME' => $lang['Username'],
		'USERNAME' => $username)
	);

	if ( $mode == 'add' && $action == 'warning' )
	{
		if ( $value < 1 || ( !$admin && $value > $board_config['mod_value_warning'] ))
		{
			$message = $lang['wrong_value'] . '<br /><br />' . sprintf($lang['Click_to_back'], '<a href="' . append_sid("warnings.$phpEx?mode=add") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
		if ( $reason == '' )
		{
			$message = $lang['reason_empty'] . '<br /><br />' . sprintf($lang['Click_to_back'], '<a href="' . append_sid("warnings.$phpEx?mode=add") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
		if ( $username == '' )
		{
			message_die(GENERAL_MESSAGE, $lang['user_empty']);
		}

		$userid = get_user_id($username);

		$sql = "INSERT INTO " . WARNINGS_TABLE . " (userid, modid, date, value, reason)
			VALUES ($userid, " . $userdata['user_id'] . ", " . time() . ", $value, '$reason')";
		if ( !($result = $db->sql_query($sql)) ) 
		{
			message_die(GENERAL_ERROR, 'Could not insert into warnings table', '', __LINE__, __FILE__, $sql);
		}
		else
		{
			$message = '<meta http-equiv="refresh" content="' . $board_config['refresh'] . ';url=warnings.'.$phpEx.'?mode=detail&amp;userid=' . $userid . '">' . sprintf($lang['Click_view_added'], '<a href="' . append_sid("warnings.$phpEx?mode=detail&amp;userid=$userid") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}

	}

}

if ( $mode == 'view_modid' && $can_view_modid )
{
	$template->assign_block_vars('view_modid_main', array());

	$sql = "SELECT w.*, u.username
		FROM " . WARNINGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.modid = $modid
			AND w.modid = u.user_id
		ORDER BY w.archive ASC, w.date DESC";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query warnings table', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$i = 0;
		do
		{
			$subtitle = $lang['view_warning_modid'] . ': <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $modid) . '" title="' . $lang['Profile'] . '">' . $row['username'] . '</a>'; 
			$userid = $row['userid'];

			if ( $userdata['user_id'] == $row['modid'] && $can_add || $can_edit )
			{
				$delete_img = ($admin) ? '&nbsp;<a href="warnings.$phpEx?mode=delete&amp;id=$id&amp;userid=$userid&amp;sid=' . $userdata['session_id'] . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete'] . '" title="' . $lang['Delete'] . '" border="0" /></a>' : '';
				$l_action = $lang['action'];
				$action_url = '<a href="' . append_sid("warnings.$phpEx?mode=edit&amp;id=$id") . '"><img src="' . $images['icon_edit'] . '" alt="' . $lang['edit_mini'] . '" title="' . $lang['edit_mini'] . '" border="0" /></a>' . $delete_img . '';
			}
			else
			{
				$l_action = '';
				$action_url = '';

			}
			$date = create_date($board_config['default_dateformat'], $row['date'], $board_config['board_timezone']);

			$template->assign_block_vars('view_modid', array(
				'ROW_CLASS' => (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'],
				'VALUE' => $row['value'],
				'ACTION' => $action_url,
				'MODID' => '<a href="' . append_sid("warnings.$phpEx?mode=detail&amp;userid=$userid") . '" title="' . $lang['detail'] . '">' . get_username($row['userid']) . '</a>',
				'REASON' => str_replace(array("\n", "[u]", "[b]", "[i]", "[/i]", "[/b]", "[/u]"), array("\n<br />\n", "<u>", "<b>", "<i>", "</i>", "</b>", "</u>"), make_clickable($row['reason'])),
				'DATE' => ($row['archive']) ? '' . $date . ' <i><b>arch.</b></i>' : $date)
			);
			$i++;
		}
		while ( $row = $db->sql_fetchrow($result) );
	}
}

if ( $HTTP_COOKIE_VARS['warnings_view'] != 'off' )
{
	$hide = '<a href="warnings.'.$phpEx.'?action=hide" class="mainmenu">' . $lang['hide_config'] . '</a>';

	$template->assign_block_vars('hide', array(
		'TITLE' => $lang['warnings_e'])
	);
}
else
{
	$hide = '<a href="warnings.'.$phpEx.'?action=show" class="mainmenu">' . $lang['show_config'] . '</a>';
}

if ( $subtitle )
{
	$subtitle .= '<br /><br />';
}

if ( $HTTP_GET_VARS['userid'] )
{
	$add_username = '&amp;username=' . get_username(intval($HTTP_GET_VARS['userid']));
}

$template->assign_vars(array(
	'L_JOINED' => $lang['Joined'], 
	'L_LAST_VISIT' => $lang['Last_visit'],
	'L_POSTS' => $lang['Posts'], 
	'L_POST_TIME' => $lang['Last_Post'],
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_EMAIL' => $lang['Email'],
	'L_WEBSITE' => $lang['Website'],
	'L_FROM' => $lang['Location'],
	'L_ORDER' => $lang['Order'],
	'L_SORT' => $lang['Sort'],
	'L_SUBMIT' => $lang['Sort'],	
	'L_USERNAME' => $lang['Username'],
	'L_MODID' => $l_modid,
	'L_ACTION' => $l_action,
	'L_DATE' => $lang['Date'],
	'L_VALUE' => $lang['value'],
	'L_REASON' => $lang['reason'],
	'L_EDIT' => $lang['edit_mini'],
	'L_WARNINGS' => $lang['how_many_warnings'],
	'L_PAGE' => $lang['warnings'],
	'L_PAGE_E' => $lang['warnings_e'],
	'L_DETAIL' => $lang['detail'],
	'L_LASTPOST' => $lang['Last_Post'],
	'L_POSTS' => $lang['Total_posts'],

	'HIDE' => $hide,
	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'SUBTITLE' => $subtitle,
	'S_ACTION' => append_sid("warnings.$phpEx"),
	'S_ACTION_ADD' => append_sid("warnings.$phpEx?mode=add"),
	'U_INDEX_WARNING' => '<a href="' . append_sid("warnings.$phpEx") . '" class="nav">' . $lang['index_warning'] . '</a>',
	'U_ADD_WARNING' => ($can_add) ? '<a href="' . append_sid("warnings.$phpEx?mode=add$add_username") . '" class="nav">' . $lang['add_warning'] . '</a>' : '')
);

if ( !$mode )
{
	$sql = "SELECT id FROM " . WARNINGS_TABLE . "
		WHERE archive = '0'
		GROUP by userid"; 
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query warnings table', '', __LINE__, __FILE__, $sql);
	}
	if ( $row = $db->sql_fetchrow($result) )
	{
		$i = 0;
		do
		{
			$i++;
			$total_members = $i;
		}
		while ( $row = $db->sql_fetchrow($result) );
	}
	$sort = ($sort) ? $sort : 'username';
	$pagination = generate_pagination("warnings.$phpEx?sort=$sort&amp;order=$sort_order", $total_members, $user_topics_per_page, $start). '&nbsp;';
}
if ( $total_members > $user_topics_per_page )
{
	$template->assign_vars(array(
		'PAGINATION' => "$pagination<br />",
		'PAGE_NUMBER' => (ceil( $total_members / $user_topics_per_page ) == 1) ? '&nbsp;&nbsp;' : sprintf($lang['Page_of'], ( floor( $start / $user_topics_per_page ) + 1 ), ceil( $total_members / $user_topics_per_page )) . '&nbsp;&nbsp;',

		'L_GOTO_PAGE' => $lang['Goto_page'])
	);
}

$template->pparse('warning_body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>